/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.StringTokenizer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DeviceField
extends DeviceComponent {
    String data;
    public boolean textOnly = false;
    public boolean showState = false;
    public boolean displayEvaluated = false;
    public String labelString = "";
    public int numCols = 10;
    private boolean initial_state;
    protected boolean initializing = true;
    GridBagLayout gridbag;
    protected int preferredWidth = -1;
    JPanel jp = new JPanel();
    protected boolean isGridBag = false;
    protected String initialField;
    private boolean reportingChange = false;
    private TransferHandler origTH;
    protected JCheckBox checkB = new JCheckBox();
    protected JLabel label;
    protected JTextField textF;

    public void setNumCols(int numCols) {
        this.numCols = numCols;
        this.textF.setColumns(numCols);
    }

    public int getNumCols() {
        return this.numCols;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean getEditable() {
        return this.editable;
    }

    public boolean getDisplayEvaluated() {
        return this.displayEvaluated;
    }

    public void setDisplayEvaluated(boolean displayEvaluated) {
        this.displayEvaluated = displayEvaluated;
    }

    public void setPreferredWidth(int preferredWidth) {
        this.preferredWidth = preferredWidth;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setLabelString(String labelString) {
        this.labelString = labelString;
        this.label.setText(labelString);
    }

    public String getLabelString() {
        return this.labelString;
    }

    public void setShowState(boolean showState) {
        this.showState = showState;
        if (showState) {
            this.checkB.setVisible(true);
        } else {
            this.checkB.setVisible(false);
        }
    }

    public boolean getShowState() {
        return this.showState;
    }

    public void setTextOnly(boolean textOnly) {
        this.textOnly = textOnly;
    }

    public boolean getTextOnly() {
        return this.textOnly;
    }

    public DeviceField() {
        this.jp.add(this.checkB);
        this.checkB.setVisible(false);
        this.label = new JLabel();
        this.jp.add(this.label);
        this.add(this.jp);
        this.textF = new JTextField(10);
        this.add(this.textF);
        this.textF.setEnabled(this.editable);
        this.textF.setEditable(this.editable);
        this.origTH = this.textF.getTransferHandler();
        this.textF.setTransferHandler(new ToTransferHandler());
        this.initializing = false;
    }

    @Override
    protected void initializeData(String data, boolean is_on) {
        this.initializing = true;
        this.initial_state = is_on;
        Container parent = this.getParent();
        this.isGridBag = parent.getLayout() != null;
        GridBagConstraints gc = null;
        if (this.isGridBag) {
            this.gridbag = new GridBagLayout();
            this.setLayout(this.gridbag);
            gc = new GridBagConstraints();
            gc.anchor = 17;
            gc.gridy = 0;
            gc.gridx = 0;
            gc.gridwidth = 1;
            gc.gridheight = 1;
            gc.weighty = 1.0;
            gc.weightx = 1.0;
            gc.fill = 0;
            this.gridbag.setConstraints(this.jp, gc);
        }
        if (this.showState) {
            this.checkB.setVisible(true);
            this.checkB.setSelected(is_on);
            this.checkB.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    boolean state = DeviceField.this.checkB.isSelected();
                    if (DeviceField.this.label != null) {
                        DeviceField.this.label.setEnabled(state);
                    }
                    if (DeviceField.this.textF != null && DeviceField.this.editable) {
                        DeviceField.this.textF.setEnabled(state);
                        DeviceField.this.textF.setEditable(state);
                    }
                }
            });
        }
        if (this.textF != null && this.isGridBag) {
            ++gc.gridx;
            gc.anchor = 13;
            gc.gridwidth = 1;
            this.gridbag.setConstraints(this.textF, gc);
        }
        this.displayData(data, is_on);
        this.setEnabled(is_on);
        this.textF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                DeviceField.this.reportingChange = true;
                DeviceField.this.reportDataChanged(DeviceField.this.textF.getText());
                DeviceField.this.reportingChange = false;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DeviceField.this.reportingChange = true;
                DeviceField.this.reportDataChanged(DeviceField.this.textF.getText());
                DeviceField.this.reportingChange = false;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DeviceField.this.reportingChange = true;
                DeviceField.this.reportDataChanged(DeviceField.this.textF.getText());
                DeviceField.this.reportingChange = false;
            }
        });
        this.textF.setEnabled(this.editable);
        this.textF.setEditable(this.editable);
        if (this.preferredWidth > 0) {
            this.setPreferredSize(new Dimension(this.preferredWidth, this.getPreferredSize().height));
            this.setSize(new Dimension(this.preferredWidth, this.getPreferredSize().height));
        }
        this.redisplay();
        this.initializing = false;
    }

    protected void dataChanged(int offsetNid, String data) {
        if (this.reportingChange || this.offsetNid != offsetNid) {
            return;
        }
        this.textF.setText(data);
    }

    @Override
    void postApply() {
        String textString;
        if (this.editable || !this.displayEvaluated || this.data == null) {
            return;
        }
        try {
            textString = this.subtree.execute(this.data);
        }
        catch (Exception exc) {
            textString = this.data;
        }
        if (textString != null) {
            if (this.textOnly && textString.charAt(0) == '\"') {
                this.textF.setText(textString.substring(1, textString.length() - 1));
            } else {
                this.textF.setText(textString);
            }
        }
    }

    @Override
    protected void displayData(String data, boolean is_on) {
        this.data = data;
        this.initial_state = is_on;
        if (this.showState) {
            this.checkB.setSelected(is_on);
        }
        if (data != null) {
            String textString;
            if (this.displayEvaluated) {
                try {
                    this.initialField = textString = this.subtree.execute(data);
                }
                catch (Exception exc) {
                    this.initialField = textString = data;
                }
            } else {
                this.initialField = textString = data;
            }
            if (textString != null) {
                if (this.textOnly && textString.charAt(0) == '\"') {
                    this.textF.setText(textString.substring(1, textString.length() - 1));
                } else {
                    this.textF.setText(textString);
                }
            }
        } else {
            this.textF.setText("");
        }
        this.label.setEnabled(is_on);
        this.textF.setEnabled(is_on & this.editable);
        this.textF.setEditable(is_on & this.editable);
    }

    @Override
    protected String getData() {
        String dataString = this.textF.getText();
        if (dataString == null || dataString.length() == 0) {
            return null;
        }
        if (this.textOnly) {
            if (dataString.trim().startsWith("[")) {
                return dataString;
            }
            return "\"" + dataString + "\"";
        }
        return dataString;
    }

    @Override
    protected boolean getState() {
        if (!this.showState) {
            return this.initial_state;
        }
        return this.checkB.isSelected();
    }

    @Override
    public void setEnabled(boolean state) {
        if (!this.editable && state) {
            return;
        }
        if (this.textF != null) {
            this.textF.setEnabled(state);
            this.textF.setEditable(state);
        }
        if (this.label != null) {
            this.label.setEnabled(state);
        }
    }

    @Override
    public Component add(Component c) {
        if (!this.initializing) {
            JOptionPane.showMessageDialog(null, "You cannot add a component to a Device Field. Please remove the component.", "Error adding Device field", 2);
            return null;
        }
        return super.add(c);
    }

    @Override
    public Component add(String name, Component c) {
        if (!this.initializing) {
            JOptionPane.showMessageDialog(null, "You cannot add a component to a Device Field. Please remove the component.", "Error adding Device field", 2);
            return null;
        }
        return super.add(c);
    }

    @Override
    public Component add(Component c, int intex) {
        if (!this.initializing) {
            JOptionPane.showMessageDialog(null, "You cannot add a component to a Device Field. Please remove the component.", "Error adding Device field", 2);
            return null;
        }
        return super.add(c);
    }

    @Override
    public boolean supportsState() {
        return this.showState;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.setPreferredSize(new Dimension(width, height));
    }

    @Override
    protected boolean isDataChanged() {
        if (this.displayEvaluated && this.initialField != null) {
            return !this.textF.getText().equals(this.initialField);
        }
        return true;
    }

    @Override
    protected boolean isChanged() {
        if (this.displayEvaluated) {
            return false;
        }
        return super.isChanged();
    }

    @Override
    public void print(Graphics g) {
        Font prevLabelFont = null;
        Font prevTextFont = null;
        if (this.label != null) {
            prevLabelFont = this.label.getFont();
            this.label.setFont(new Font("Serif", 1, 10));
        }
        if (this.textF != null) {
            prevTextFont = this.textF.getFont();
            this.textF.setFont(new Font("Serif", 1, 10));
        }
        super.print(g);
        if (this.label != null) {
            this.label.setFont(prevLabelFont);
        }
        if (this.textF != null) {
            this.textF.setFont(prevTextFont);
        }
    }

    @Override
    public void setHighlight(boolean highlighted) {
        if (highlighted) {
            if (this.label != null) {
                this.label.setEnabled(true);
                this.label.setForeground(Color.red);
            }
        } else if (this.label != null) {
            this.label.setForeground(Color.black);
            this.label.setEnabled(this.getState());
        }
        super.setHighlight(highlighted);
    }

    class ToTransferHandler
    extends TransferHandler {
        ToTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent comp) {
            return 3;
        }

        @Override
        public Transferable createTransferable(JComponent comp) {
            return new StringSelection(DeviceField.this.textF.getSelectedText());
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDrop() && support.isDataFlavorSupported(DataFlavor.stringFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return DeviceField.this.origTH.importData(support);
            }
            if (!DeviceField.this.editable) {
                return false;
            }
            try {
                String data = (String)support.getTransferable().getTransferData(DataFlavor.stringFlavor);
                if (data.indexOf(":\\") != -1) {
                    StringTokenizer st = new StringTokenizer(data, ":");
                    String experiment = st.nextToken();
                    String path = data.substring(experiment.length() + 1);
                    DeviceField.this.textF.setText(path);
                } else {
                    DeviceField.this.textF.setText(data);
                }
            }
            catch (Exception exc) {
                return false;
            }
            return true;
        }
    }
}

