/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class DeviceLabel
extends DeviceComponent {
    String data;
    public boolean textOnly = false;
    public boolean displayEvaluated = false;
    public String labelString = "<empty>";
    public int numCols = 10;
    protected boolean initializing = true;
    protected int preferredWidth = -1;
    JPanel jp;
    protected String initialField = "<empty>";
    private boolean reportingChange = false;
    protected JLabel label = new JLabel("<empty>");

    public void setNumCols(int numCols) {
        this.numCols = numCols;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.setSize(numCols * fm.charWidth('A'), fm.getHeight() + 4);
    }

    public int getNumCols() {
        return this.numCols;
    }

    public boolean getDisplayEvaluated() {
        return this.displayEvaluated;
    }

    public void setDisplayEvaluated(boolean displayEvaluated) {
        this.displayEvaluated = displayEvaluated;
    }

    public void setPreferredWidth(int preferredWidth) {
        this.preferredWidth = preferredWidth;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setLabelString(String labelString) {
        this.labelString = labelString;
        this.label.setText(labelString);
    }

    public String getLabelString() {
        return this.labelString;
    }

    public void setTextOnly(boolean textOnly) {
        this.textOnly = textOnly;
    }

    public boolean getTextOnly() {
        return this.textOnly;
    }

    public DeviceLabel() {
        this.add(this.label);
        this.setLayout(new FlowLayout(0, 2, 0));
        this.initializing = false;
    }

    @Override
    protected void initializeData(String data, boolean is_on) {
        this.initializing = true;
        this.displayData(data, is_on);
        this.redisplay();
        this.initializing = false;
    }

    protected void dataChanged(int offsetNid, String data) {
        if (this.reportingChange || this.offsetNid != offsetNid) {
            return;
        }
        this.label.setText(data);
    }

    @Override
    public void apply(int currBaseNid) {
    }

    @Override
    public void apply() {
    }

    @Override
    protected void displayData(String data, boolean is_on) {
        this.data = data;
        if (data != null) {
            String textString;
            if (this.displayEvaluated) {
                try {
                    this.initialField = textString = this.subtree.execute(data);
                }
                catch (Exception exc) {
                    textString = data;
                }
            } else {
                textString = data;
            }
            if (textString != null) {
                if (this.textOnly && textString.charAt(0) == '\"') {
                    this.label.setText(textString.substring(1, textString.length() - 1));
                } else {
                    this.label.setText(textString);
                }
            }
        } else {
            this.label.setText("<empty>");
        }
    }

    @Override
    protected String getData() {
        String dataString = this.label.getText();
        if (dataString == null) {
            return null;
        }
        if (this.textOnly) {
            return "\"" + dataString + "\"";
        }
        return dataString;
    }

    @Override
    protected boolean getState() {
        return true;
    }

    @Override
    public Component add(Component c) {
        if (!this.initializing) {
            JOptionPane.showMessageDialog(null, "You cannot add a component to a Device Label. Please remove the component.", "Error adding Device field", 2);
            return null;
        }
        return super.add(c);
    }

    @Override
    public Component add(String name, Component c) {
        if (!this.initializing) {
            JOptionPane.showMessageDialog(null, "You cannot add a component to a Device Label. Please remove the component.", "Error adding Device field", 2);
            return null;
        }
        return super.add(c);
    }

    @Override
    public Component add(Component c, int intex) {
        if (!this.initializing) {
            JOptionPane.showMessageDialog(null, "You cannot add a component to a Device Label. Please remove the component.", "Error adding Device field", 2);
            return null;
        }
        return super.add(c);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.setPreferredSize(new Dimension(width, height));
    }

    @Override
    protected boolean isDataChanged() {
        if (this.displayEvaluated && this.initialField != null) {
            return !this.label.getSize().equals(this.initialField);
        }
        return true;
    }
}

