/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class DeviceTable
extends DeviceComponent {
    public static final int NORMAL = 0;
    public static final int REFLEX = 1;
    public static final int REFLEX_INVERT = 2;
    int refMode = 0;
    int numRows = 3;
    int numCols = 3;
    int currRow = -1;
    int currCol = -1;
    String[] columnNames = new String[0];
    String[] rowNames = new String[0];
    boolean state = true;
    String labelString = "";
    boolean initializing = true;
    boolean editable = true;
    boolean displayRowNumber = false;
    boolean binary = false;
    boolean useExpressions = false;
    JPopupMenu popM = null;
    JMenuItem copyRowI;
    JMenuItem copyColI;
    JMenuItem copyI;
    JMenuItem pasteRowI;
    JMenuItem pasteColI;
    JMenuItem pasteI;
    JMenuItem propagateToRowI;
    JMenuItem propagateToColI;
    protected int preferredColumnWidth = 30;
    protected int preferredHeight = 70;
    protected JScrollPane scroll;
    protected JTable table;
    protected JLabel label;
    protected String[] items = new String[9];
    static String[] copiedColItems;
    static String[] copiedRowItems;
    static String[] copiedItems;

    public void setRefMode(int refMode) {
        this.refMode = refMode;
        if (refMode == 1 || refMode == 2) {
            this.table.setDefaultRenderer(Object.class, new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JTextField tf = new JTextField();
                    tf.setText("" + value);
                    tf.setEnabled(DeviceTable.this.isEditable(row, column));
                    return tf;
                }
            });
        }
    }

    public int getRefMode() {
        return this.refMode;
    }

    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public void setNumCols(int numCols) {
        this.numCols = numCols;
        this.table.setPreferredScrollableViewportSize(new Dimension(this.preferredColumnWidth * numCols, this.preferredHeight));
        this.redisplay();
    }

    public int getNumCols() {
        return this.numCols;
    }

    public void setPreferredColumnWidth(int preferredColumnWidth) {
        this.preferredColumnWidth = preferredColumnWidth;
    }

    public int getPreferredColumnWidth() {
        return this.preferredColumnWidth;
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public void setPreferredHeight(int preferredHeight) {
        this.preferredHeight = preferredHeight;
    }

    public void setUseExpressions(boolean useExpressions) {
        this.useExpressions = useExpressions;
    }

    public boolean getUseExpressions() {
        return this.useExpressions;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
        this.redisplay();
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setRowNames(String[] rowNames) {
        this.rowNames = rowNames;
        if (rowNames != null && rowNames.length > 0) {
            this.displayRowNumber = true;
        }
        this.redisplay();
    }

    public String[] getRowNames() {
        return this.rowNames;
    }

    public void setLabelString(String labelString) {
        this.labelString = labelString;
        this.redisplay();
    }

    public String getLabelString() {
        return this.labelString;
    }

    public void setEditable(boolean state) {
        this.editable = state;
    }

    public boolean getEditable() {
        return this.editable;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public boolean getBinary() {
        return this.binary;
    }

    public void setDisplayRowNumber(boolean displayRowNumber) {
        this.displayRowNumber = displayRowNumber;
    }

    public boolean getDisplayRowNumber() {
        return this.displayRowNumber;
    }

    public DeviceTable() {
        if (this.rowNames.length > 0) {
            this.displayRowNumber = true;
        }
        this.table = new JTable();
        this.scroll = new JScrollPane(this.table);
        this.table.setPreferredScrollableViewportSize(new Dimension(200, 70));
        this.label = new JLabel();
        this.setLayout(new BorderLayout());
        JPanel jp = new JPanel();
        jp.add(this.label);
        this.add((Component)jp, "North");
        this.add((Component)this.scroll, "Center");
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if ((e.getModifiers() & 4) != 0) {
                    DeviceTable.this.showPopup(e.getX(), e.getY());
                }
            }
        });
        this.initializing = false;
    }

    void showPopup(int x, int y) {
        if (this.popM == null) {
            this.popM = new JPopupMenu();
            this.copyRowI = new JMenuItem("Copy row");
            this.copyRowI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceTable.this.copyRow(DeviceTable.this.table.getSelectedRow());
                }
            });
            this.popM.add(this.copyRowI);
            this.copyColI = new JMenuItem("Copy column");
            this.copyColI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceTable.this.copyCol(DeviceTable.this.table.getSelectedColumn());
                }
            });
            this.popM.add(this.copyColI);
            this.copyI = new JMenuItem("Copy table");
            this.copyI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceTable.this.copy();
                }
            });
            this.popM.add(this.copyI);
            this.pasteRowI = new JMenuItem("Paste row");
            this.pasteRowI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceTable.this.pasteRow(DeviceTable.this.table.getSelectedRow());
                }
            });
            this.popM.add(this.pasteRowI);
            this.pasteColI = new JMenuItem("Paste column");
            this.pasteColI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceTable.this.pasteCol(DeviceTable.this.table.getSelectedColumn());
                }
            });
            this.popM.add(this.pasteColI);
            this.pasteI = new JMenuItem("Paste table");
            this.pasteI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceTable.this.paste();
                }
            });
            this.popM.add(this.pasteI);
            JMenuItem copyClipboardI = new JMenuItem("Clipboard Copy");
            copyClipboardI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceTable.this.writeToClipboard();
                }
            });
            this.popM.add(copyClipboardI);
            JMenuItem pasteClipboardI = new JMenuItem("Clipboard Paste");
            pasteClipboardI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceTable.this.readFromClipboard();
                }
            });
            this.popM.add(pasteClipboardI);
            JMenuItem propagateToRowI = new JMenuItem("Propagate to Row");
            propagateToRowI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceTable.this.propagateToRow(DeviceTable.this.table.getSelectedRow(), DeviceTable.this.table.getSelectedColumn());
                }
            });
            this.popM.add(propagateToRowI);
            JMenuItem propagateToColI = new JMenuItem("Propagate to Column");
            propagateToColI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceTable.this.propagateToCol(DeviceTable.this.table.getSelectedRow(), DeviceTable.this.table.getSelectedColumn());
                }
            });
            this.popM.add(propagateToColI);
        }
        if (copiedRowItems == null) {
            this.pasteRowI.setEnabled(false);
        } else {
            this.pasteRowI.setEnabled(true);
        }
        if (copiedColItems == null) {
            this.pasteColI.setEnabled(false);
        } else {
            this.pasteColI.setEnabled(true);
        }
        if (copiedItems == null) {
            this.pasteI.setEnabled(false);
        } else {
            this.pasteI.setEnabled(true);
        }
        this.popM.show(this.table, x, y);
    }

    void copy() {
        copiedItems = new String[this.items.length];
        for (int i = 0; i < this.items.length; ++i) {
            DeviceTable.copiedItems[i] = this.items[i];
        }
    }

    void paste() {
        try {
            for (int i = 0; i < this.items.length; ++i) {
                this.items[i] = copiedItems[i];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.completeTable();
        this.table.repaint();
    }

    void copyRow(int row) {
        if (row == -1) {
            return;
        }
        copiedRowItems = new String[this.numCols];
        for (int i = 0; i < this.numCols; ++i) {
            DeviceTable.copiedRowItems[i] = this.items[row * this.numCols + i];
        }
    }

    void pasteRow(int row) {
        if (row == -1) {
            return;
        }
        try {
            for (int i = 0; i < this.numCols; ++i) {
                this.items[row * this.numCols + i] = copiedRowItems[i];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.completeTable();
        this.table.repaint();
    }

    void copyCol(int col) {
        if (this.displayRowNumber) {
            --col;
        }
        copiedColItems = new String[this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            DeviceTable.copiedColItems[i] = this.items[col + i * this.numCols];
        }
    }

    void pasteCol(int col) {
        if (this.displayRowNumber) {
            --col;
        }
        try {
            for (int i = 0; i < this.numRows; ++i) {
                this.items[col + i * this.numCols] = copiedColItems[i];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.completeTable();
        this.table.repaint();
    }

    void propagateToRow(int row, int col) {
        if (row == -1 || col == -1) {
            row = this.currRow;
            col = this.currCol;
        }
        if (row == -1 || col == -1) {
            return;
        }
        if (this.displayRowNumber) {
            --col;
        }
        try {
            for (int i = 0; i < this.numCols; ++i) {
                this.items[row * this.numCols + i] = this.items[row * this.numCols + col];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.completeTable();
        this.table.repaint();
    }

    void propagateToCol(int row, int col) {
        if (row == -1 || col == -1) {
            row = this.currRow;
            col = this.currCol;
        }
        if (row == -1 || col == -1) {
            return;
        }
        if (this.displayRowNumber) {
            --col;
        }
        try {
            for (int i = 0; i < this.numRows; ++i) {
                this.items[col + i * this.numCols] = this.items[row * this.numCols + col];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.completeTable();
        this.table.repaint();
    }

    private boolean isEditable(int row, int col) {
        int firstCol;
        if (this.displayRowNumber && col == 0) {
            return false;
        }
        if (this.refMode == 0) {
            return this.editable;
        }
        if (!this.editable) {
            return false;
        }
        int n = firstCol = this.displayRowNumber ? 1 : 0;
        return col != firstCol || row <= this.numRows - this.numRows / 2;
    }

    @Override
    public void initializeData(String data, boolean is_on) {
        this.initializing = true;
        String decompiled = "";
        try {
            if (this.useExpressions) {
                decompiled = data;
                if (decompiled.startsWith("COMPILE('") || decompiled.startsWith("COMPILE(\"")) {
                    decompiled = this.shrinkBackslash(decompiled.substring(9, decompiled.length() - 2));
                }
            } else {
                decompiled = this.subtree.execute(data);
            }
        }
        catch (Exception exc) {
            System.err.println(exc);
            decompiled = null;
        }
        this.items = new String[this.numCols * this.numRows];
        int idx = 0;
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = "";
        }
        if (decompiled != null) {
            decompiled = decompiled.trim();
            while (decompiled.startsWith("[") && decompiled.endsWith("]") && this.balancedSquareParenthesis(decompiled)) {
                decompiled = decompiled.substring(1, decompiled.length() - 1);
                decompiled = decompiled.trim();
            }
            StringTokenizer st = new StringTokenizer(decompiled, ",");
            while (idx < this.numCols * this.numRows && st.hasMoreTokens()) {
                String currToken = st.nextToken();
                currToken = currToken.trim();
                while (currToken.startsWith("[") && !this.balancedSquareParenthesis(currToken)) {
                    currToken = currToken.substring(1);
                }
                while (currToken.endsWith("]") && !this.balancedSquareParenthesis(currToken)) {
                    currToken = currToken.substring(0, currToken.length() - 1);
                }
                while (currToken.startsWith("[") && currToken.endsWith("]") && this.balancedSquareParenthesis(currToken)) {
                    currToken = currToken.substring(1, currToken.length() - 1);
                    currToken = currToken.trim();
                }
                int n = idx;
                this.items[n] = this.items[n] + currToken;
                if (this.balancedParenthesis(this.items[idx])) {
                    ++idx;
                    continue;
                }
                int n2 = idx;
                this.items[n2] = this.items[n2] + ",";
            }
        }
        this.label.setText(this.labelString);
        this.table.setModel(new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                if (DeviceTable.this.refMode == 1 || DeviceTable.this.refMode == 2) {
                    if (DeviceTable.this.displayRowNumber || DeviceTable.this.rowNames != null && DeviceTable.this.rowNames.length > 0) {
                        return DeviceTable.this.numCols / 2 + 1 + 1;
                    }
                    return DeviceTable.this.numCols / 2 + 1;
                }
                if (DeviceTable.this.displayRowNumber || DeviceTable.this.rowNames != null && DeviceTable.this.rowNames.length > 0) {
                    return DeviceTable.this.numCols + 1;
                }
                return DeviceTable.this.numCols;
            }

            @Override
            public int getRowCount() {
                return DeviceTable.this.numRows;
            }

            @Override
            public String getColumnName(int idx) {
                try {
                    if (DeviceTable.this.displayRowNumber || DeviceTable.this.rowNames != null && DeviceTable.this.rowNames.length > 0) {
                        if (idx == 0) {
                            return "";
                        }
                        return DeviceTable.this.columnNames[idx - 1];
                    }
                    return DeviceTable.this.columnNames[idx];
                }
                catch (Exception exc) {
                    return "";
                }
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (DeviceTable.this.rowNames != null && DeviceTable.this.rowNames.length > 0) {
                    if (col == 0) {
                        try {
                            return DeviceTable.this.rowNames[row];
                        }
                        catch (Exception exc) {
                            return "";
                        }
                    }
                    try {
                        String retItem = DeviceTable.this.items[row * DeviceTable.this.numCols + col - 1];
                        if (!DeviceTable.this.binary) {
                            return retItem;
                        }
                        if (retItem.trim().equals("0") || retItem.trim().equals("0.")) {
                            return new Boolean(false);
                        }
                        return new Boolean(true);
                    }
                    catch (Exception exc) {
                        return null;
                    }
                }
                if (DeviceTable.this.displayRowNumber) {
                    if (col == 0) {
                        return "" + (row + 1);
                    }
                    try {
                        String retItem = DeviceTable.this.items[row * DeviceTable.this.numCols + col - 1];
                        if (!DeviceTable.this.binary) {
                            return retItem;
                        }
                        if (retItem.trim().equals("0") || retItem.trim().equals("0.")) {
                            return new Boolean(false);
                        }
                        return new Boolean(true);
                    }
                    catch (Exception exc) {
                        return null;
                    }
                }
                try {
                    String retItem = DeviceTable.this.items[row * DeviceTable.this.numCols + col];
                    if (!DeviceTable.this.binary) {
                        return retItem;
                    }
                    if (retItem.trim().equals("0") || retItem.trim().equals("0.")) {
                        return new Boolean(false);
                    }
                    return new Boolean(true);
                }
                catch (Exception exc) {
                    return null;
                }
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return DeviceTable.this.isEditable(row, col);
            }

            private String convertValue(String value) {
                if (DeviceTable.this.refMode != 2) {
                    return value;
                }
                if (value.trim().startsWith("-")) {
                    return value.trim().substring(1);
                }
                return "-" + value.trim();
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                int actCol = DeviceTable.this.rowNames != null && DeviceTable.this.rowNames.length > 0 || DeviceTable.this.displayRowNumber ? col - 1 : col;
                int itemIdx = DeviceTable.this.rowNames != null && DeviceTable.this.rowNames.length > 0 || DeviceTable.this.displayRowNumber ? row * DeviceTable.this.numCols + actCol : row * DeviceTable.this.numCols + actCol;
                if (DeviceTable.this.binary) {
                    boolean isOn = (Boolean)value;
                    DeviceTable.this.items[itemIdx] = isOn ? "1" : "0";
                    DeviceTable.this.currRow = row;
                    DeviceTable.this.currCol = col;
                } else {
                    DeviceTable.this.items[itemIdx] = (String)value;
                }
                this.fireTableCellUpdated(row, col);
                if (DeviceTable.this.refMode == 1 || DeviceTable.this.refMode == 2) {
                    DeviceTable.this.completeTable();
                    DeviceTable.this.table.repaint();
                }
            }

            public Class getColumnClass(int c) {
                if (!DeviceTable.this.binary) {
                    return String.class;
                }
                if (DeviceTable.this.rowNames != null && (DeviceTable.this.rowNames.length > 0 || DeviceTable.this.displayRowNumber) && c == 0) {
                    return String.class;
                }
                return Boolean.class;
            }
        });
        if (this.binary) {
            this.table.setRowSelectionAllowed(false);
        }
        if (this.refMode == 1 || this.refMode == 2) {
            this.table.setPreferredScrollableViewportSize(new Dimension(this.preferredColumnWidth * (this.numCols / 2 + 1), this.preferredHeight));
        } else {
            this.table.setPreferredScrollableViewportSize(new Dimension(this.preferredColumnWidth * this.numCols, this.preferredHeight));
        }
        this.table.revalidate();
        this.initializing = false;
    }

    void completeTable() {
        int j;
        int i;
        if (this.refMode != 1 && this.refMode != 2) {
            return;
        }
        String sign = "";
        if (this.refMode == 2) {
            sign = "- ";
        }
        for (i = 1; i < this.numCols / 2; ++i) {
            this.items[this.numCols - i] = sign + this.items[i];
        }
        for (i = 1; i < this.numRows / 2; ++i) {
            this.items[(this.numRows - i) * this.numCols] = sign + this.items[i * this.numCols];
        }
        for (i = 1; i < this.numRows; ++i) {
            for (j = 1; j < this.numCols / 2; ++j) {
                this.items[(this.numRows - i) * this.numCols + this.numCols - j] = sign + this.items[i * this.numCols + j];
            }
        }
        System.out.println("HERMITIAN:");
        for (i = 0; i < this.numRows; ++i) {
            for (j = 0; j < this.numCols; ++j) {
                System.out.print(this.items[i * this.numCols + j] + " ");
            }
            System.out.println("");
        }
    }

    @Override
    public void displayData(String data, boolean is_on) {
        this.state = is_on;
        String decompiled = data;
        StringTokenizer st = new StringTokenizer(decompiled, ",[]");
        this.items = new String[this.numCols * this.numRows];
        int idx = 0;
        while (idx < this.numCols * this.numRows && st.hasMoreTokens()) {
            this.items[idx++] = st.nextToken();
        }
        int actCols = this.numCols;
        if (this.refMode == 1 || this.refMode == 2) {
            actCols = this.numCols / 2 + 1;
        }
        for (int i = 0; i < actCols; ++i) {
            this.table.getColumnModel().getColumn(i).setMinWidth(6);
            this.table.getColumnModel().getColumn(i).setPreferredWidth(6);
            this.table.getColumnModel().getColumn(i).setWidth(6);
        }
        this.completeTable();
        this.table.repaint();
        this.redisplay();
    }

    @Override
    public boolean getState() {
        return this.state;
    }

    @Override
    public String getData() {
        if (this.refMode == 1 || this.refMode == 2) {
            this.completeTable();
        }
        int n_data = this.items.length;
        String dataString = "[";
        for (int i = 0; i < n_data; ++i) {
            if (i % this.numCols == 0) {
                dataString = dataString + "[";
            }
            dataString = this.items[i].trim().equals("") ? dataString + "0" : dataString + this.items[i];
            if (i % this.numCols == this.numCols - 1) {
                dataString = dataString + "]";
                if (i < n_data - 1 && this.items[i + 1] != null) {
                    dataString = dataString + ",";
                    continue;
                }
                if (i != n_data - 1) continue;
                dataString = dataString + "]";
                continue;
            }
            dataString = dataString + ",";
        }
        if (this.useExpressions) {
            return "COMPILE('" + this.expandBackslash(dataString) + "')";
        }
        return dataString;
    }

    @Override
    public Component add(Component c) {
        if (!this.initializing) {
            JOptionPane.showMessageDialog(null, "You cannot add a component to a Device Field. Please remove the component.", "Error adding Device field", 2);
            return null;
        }
        return super.add(c);
    }

    @Override
    public Component add(String name, Component c) {
        if (!this.initializing) {
            JOptionPane.showMessageDialog(null, "You cannot add a component to a Device Field. Please remove the component.", "Error adding Device field", 2);
            return null;
        }
        return super.add(c);
    }

    @Override
    public Component add(Component c, int intex) {
        if (!this.initializing) {
            JOptionPane.showMessageDialog(null, "You cannot add a component to a Device Field. Please remove the component.", "Error adding Device field", 2);
            return null;
        }
        return super.add(c);
    }

    @Override
    public void apply() throws Exception {
        TableCellEditor ce = this.table.getCellEditor();
        if (ce != null) {
            ce.stopCellEditing();
        }
        super.apply();
    }

    void readFromClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        if (transferable == null) {
            return;
        }
        if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String tableText = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                StringTokenizer st = new StringTokenizer(tableText, ",\n");
                int idx = 0;
                while (st.hasMoreTokens() && this.items.length > idx) {
                    this.items[idx++] = st.nextToken();
                }
            }
            catch (Exception exc) {
                System.err.println("Error reading from clipboard: " + exc);
            }
            this.completeTable();
            this.table.repaint();
        }
    }

    void writeToClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        String tableText = "";
        int idx = 0;
        if (this.refMode == 1 || this.refMode == 2) {
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    tableText = tableText + " " + this.items[idx++];
                }
                tableText = tableText + "\n";
            }
        }
        clipboard.setContents(new StringSelection(tableText), null);
    }

    private String expandBackslash(String str) {
        String outStr = "";
        for (int i = 0; i < str.length(); ++i) {
            char currChar = str.charAt(i);
            outStr = outStr + currChar;
            if (currChar != '\\') continue;
            outStr = outStr + currChar;
        }
        return outStr;
    }

    private String shrinkBackslash(String str) {
        String outStr = "";
        char prevChar = str.charAt(0);
        for (int i = 1; i < str.length(); ++i) {
            char currChar = str.charAt(i);
            if (currChar != '\\' || prevChar != '\\') {
                outStr = outStr + currChar;
            }
            prevChar = currChar;
        }
        return outStr;
    }

    private boolean balancedParenthesis(String inStr) {
        int roundCount = 0;
        int squareCount = 0;
        int braceCount = 0;
        block8: for (int i = 0; i < inStr.length(); ++i) {
            switch (inStr.charAt(i)) {
                case '(': {
                    ++roundCount;
                    continue block8;
                }
                case ')': {
                    --roundCount;
                    continue block8;
                }
                case '[': {
                    ++squareCount;
                    continue block8;
                }
                case ']': {
                    --squareCount;
                    continue block8;
                }
                case '{': {
                    ++braceCount;
                    continue block8;
                }
                case '}': {
                    --braceCount;
                }
            }
        }
        return roundCount == 0 && squareCount == 0 && braceCount == 0;
    }

    private boolean balancedSquareParenthesis(String inStr) {
        int squareCount = 0;
        block4: for (int i = 0; i < inStr.length(); ++i) {
            switch (inStr.charAt(i)) {
                case '[': {
                    ++squareCount;
                    continue block4;
                }
                case ']': {
                    --squareCount;
                }
            }
        }
        return squareCount == 0;
    }

    @Override
    public void setHighlight(boolean highlighted) {
        if (highlighted) {
            if (this.label != null) {
                this.label.setForeground(Color.red);
            }
        } else if (this.label != null) {
            this.label.setForeground(Color.black);
        }
        super.setHighlight(highlighted);
    }
}

