/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import mds.wave.WaveformEditor;
import mds.wave.WaveformEditorListener;

public class DeviceWave
extends DeviceComponent {
    static final int MAX_POINTS = 500;
    static final double MIN_STEP = 1.0E-5;
    public boolean maxXVisible = false;
    public boolean minXVisible = false;
    public boolean maxYVisible = true;
    public boolean minYVisible = false;
    public boolean waveEditable = false;
    public String updateExpression = null;
    protected int prefHeight = 200;
    protected boolean initializing = false;
    protected WaveformEditor waveEditor;
    protected JTable table;
    protected JTextField maxXField = null;
    protected JTextField minXField = null;
    protected JTextField maxYField = null;
    protected JTextField minYField = null;
    protected JCheckBox editCB;
    protected JScrollPane scroll;
    protected int numPoints;
    protected float[] waveX = null;
    protected float[] waveY = null;
    protected float[] waveXOld = null;
    protected float[] waveYOld = null;
    protected float maxX;
    protected float minX;
    protected float maxY;
    protected float minY;
    protected float maxXOld;
    protected float minXOld;
    protected float maxYOld;
    protected float minYOld;
    private NumberFormat nf = NumberFormat.getInstance(Locale.ENGLISH);
    protected static float savedMinX;
    protected static float savedMinY;
    protected static float savedMaxX;
    protected static float savedMaxY;
    protected static float[] savedWaveX;
    protected static float[] savedWaveY;
    JPopupMenu copyPastePopup;
    JMenuItem copyI;
    JMenuItem copyC;
    JMenuItem pasteI;
    JMenuItem pasteC;

    public void setPrefHeight(int prefHeight) {
        this.prefHeight = prefHeight;
    }

    public int getPrefHeight() {
        return this.prefHeight;
    }

    public void setMaxXVisible(boolean visible) {
        this.maxXVisible = visible;
    }

    public void setMinXVisible(boolean visible) {
        this.minXVisible = visible;
    }

    public void setMaxYVisible(boolean visible) {
        this.maxYVisible = visible;
    }

    public void setMinYVisible(boolean visible) {
        this.minYVisible = visible;
    }

    public boolean getMaxXVisible() {
        return this.maxXVisible;
    }

    public boolean getMinXVisible() {
        return this.minXVisible;
    }

    public boolean getMaxYVisible() {
        return this.maxYVisible;
    }

    public boolean getMinYVisible() {
        return this.minYVisible;
    }

    public void setWaveEditable(boolean editable) {
        this.waveEditable = editable;
    }

    public boolean getWaveEditable() {
        return this.waveEditable;
    }

    public void setUpdateExpression(String updateExpression) {
        this.updateExpression = updateExpression;
    }

    public String getUpdateExpression() {
        return this.updateExpression;
    }

    private boolean isClipboardText(Clipboard clip) {
        Transferable contents = clip.getContents(null);
        DataFlavor[] flavors = contents.getTransferDataFlavors();
        boolean isText = false;
        for (int k = 0; k < flavors.length; ++k) {
            if (!flavors[k].getHumanPresentableName().equals("Unicode String")) continue;
            isText = true;
            break;
        }
        return isText;
    }

    private void create() {
        savedWaveX = null;
        this.waveEditor = new WaveformEditor();
        this.nf.setMaximumFractionDigits(4);
        this.nf.setGroupingUsed(false);
        this.waveEditor.setPreferredSize(new Dimension(300, this.prefHeight));
        this.waveEditor.addWaveformEditorListener(new WaveformEditorListener(){

            @Override
            public void waveformUpdated(float[] waveX, float[] waveY, int newIdx) {
                DeviceWave.this.numPoints = waveX.length;
                DeviceWave.this.waveX = waveX;
                DeviceWave.this.waveY = waveY;
                if (newIdx >= 0) {
                    DeviceWave.this.table.setRowSelectionInterval(newIdx, newIdx);
                    DeviceWave.this.table.setEditingRow(newIdx);
                    int centerIdx = newIdx > 8 ? newIdx - 4 : 0;
                    int rowY = centerIdx * DeviceWave.this.table.getRowHeight();
                    DeviceWave.this.scroll.getViewport().setViewPosition(new Point(0, rowY));
                }
                if (DeviceWave.this.maxYVisible) {
                    try {
                        DeviceWave.this.maxY = new Float(DeviceWave.this.maxYField.getText()).floatValue();
                        for (int i = 0; i < waveY.length; ++i) {
                            if (!(waveY[i] > DeviceWave.this.maxY)) continue;
                            waveY[i] = DeviceWave.this.maxY;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                DeviceWave.this.table.repaint();
            }
        });
        this.waveEditor.setEditable(false);
        this.table = new JTable();
        this.table.setModel(new DefaultTableModel(){

            @Override
            public void addTableModelListener(TableModelListener l) {
            }

            public Class getColumnClass(int col) {
                return new String().getClass();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return 500;
            }

            @Override
            public String getColumnName(int col) {
                if (col == 0) {
                    return "Time";
                }
                return "Value";
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (DeviceWave.this.waveX == null || row >= DeviceWave.this.waveX.length) {
                    return "";
                }
                float currVal = col == 0 ? DeviceWave.this.waveX[row] : DeviceWave.this.waveY[row];
                return DeviceWave.this.nf.format(currVal);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                if (!DeviceWave.this.waveEditable) {
                    return false;
                }
                if (row == 0 && col == 0) {
                    return false;
                }
                return row != DeviceWave.this.waveX.length - 1 || col != 0;
            }

            @Override
            public void removeTableModelListener(TableModelListener l) {
            }

            @Override
            public void setValueAt(Object val, int row, int col) {
                float valFloat;
                if (row >= DeviceWave.this.waveX.length) {
                    JOptionPane.showMessageDialog(DeviceWave.this, "There are misssing points in the waveform definition", "Incorrect waveform definition", 2);
                    return;
                }
                try {
                    valFloat = new Float((String)val).floatValue();
                }
                catch (Exception exc) {
                    JOptionPane.showMessageDialog(DeviceWave.this, "The value is not a correct floating point representation", "Incorrect waveform definition", 2);
                    return;
                }
                if (col == 0) {
                    DeviceWave.this.waveX[row] = valFloat > DeviceWave.this.maxX ? DeviceWave.this.maxX : (valFloat < DeviceWave.this.minX ? DeviceWave.this.minX : valFloat);
                    if (row == 0 || row == DeviceWave.this.waveX.length - 1) {
                        return;
                    }
                    if ((double)DeviceWave.this.waveX[row] < (double)DeviceWave.this.waveX[row - 1] + 1.0E-5) {
                        DeviceWave.this.waveX[row] = DeviceWave.this.waveX[row - 1] + 1.0E-5f;
                    }
                    if ((double)DeviceWave.this.waveX[row] > (double)DeviceWave.this.waveX[row + 1] - 1.0E-5) {
                        DeviceWave.this.waveX[row] = DeviceWave.this.waveX[row + 1] - 1.0E-5f;
                    }
                } else {
                    DeviceWave.this.waveY[row] = valFloat;
                }
                DeviceWave.this.waveEditor.setWaveform(DeviceWave.this.waveX, DeviceWave.this.waveY, DeviceWave.this.minY, DeviceWave.this.maxY);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.waveEditor, "Center");
        this.scroll = new JScrollPane(this.table);
        this.scroll.setPreferredSize(new Dimension(150, 200));
        this.add((Component)this.scroll, "East");
        JPanel jp = new JPanel();
        if (this.minXVisible) {
            jp.add(new JLabel("Min X: "));
            this.minXField = new JTextField("" + this.minX, 6);
            jp.add(this.minXField);
        }
        if (this.maxXVisible) {
            jp.add(new JLabel("Max X: "));
            this.maxXField = new JTextField("" + this.maxX, 6);
            jp.add(this.maxXField);
        }
        if (this.minYVisible) {
            jp.add(new JLabel("Min Y: "));
            this.minYField = new JTextField("" + this.minY, 6);
            jp.add(this.minYField);
        }
        if (this.maxYVisible) {
            jp.add(new JLabel("Max Y: "));
            this.maxYField = new JTextField("" + this.maxY, 6);
            jp.add(this.maxYField);
        }
        this.editCB = new JCheckBox("Edit", false);
        this.editCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceWave.this.waveEditable = DeviceWave.this.editCB.isSelected();
                DeviceWave.this.waveEditor.setEditable(DeviceWave.this.editCB.isSelected());
            }
        });
        jp.add(this.editCB);
        JButton updateB = new JButton("Update");
        updateB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceWave.this.updateLimits();
                DeviceWave.this.waveEditor.setWaveform(DeviceWave.this.waveX, DeviceWave.this.waveY, DeviceWave.this.minY, DeviceWave.this.maxY);
            }
        });
        jp.add(updateB);
        this.add((Component)jp, "North");
        this.copyPastePopup = new JPopupMenu();
        this.copyI = new JMenuItem("Copy");
        this.copyI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                savedMinX = DeviceWave.this.minX;
                savedMinY = DeviceWave.this.minY;
                savedMaxX = DeviceWave.this.maxX;
                savedMaxY = DeviceWave.this.maxY;
                savedWaveX = DeviceWave.this.waveX;
                savedWaveY = DeviceWave.this.waveY;
            }
        });
        this.copyPastePopup.add(this.copyI);
        this.pasteI = new JMenuItem("Paste");
        this.pasteI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (savedWaveX == null) {
                    return;
                }
                if (DeviceWave.this.minXVisible) {
                    DeviceWave.this.minX = savedMinX;
                }
                if (DeviceWave.this.minYVisible) {
                    DeviceWave.this.minY = savedMinY;
                }
                if (DeviceWave.this.maxXVisible) {
                    DeviceWave.this.maxX = savedMaxX;
                }
                if (DeviceWave.this.maxYVisible) {
                    DeviceWave.this.maxY = savedMaxY;
                }
                try {
                    DeviceWave.this.waveX = new float[savedWaveX.length];
                    DeviceWave.this.waveY = new float[savedWaveY.length];
                    for (int i = 0; i < savedWaveX.length; ++i) {
                        DeviceWave.this.waveX[i] = savedWaveX[i];
                        DeviceWave.this.waveY[i] = savedWaveY[i];
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DeviceWave.this.displayData(null, true);
            }
        });
        this.copyPastePopup.add(this.pasteI);
        this.pasteC = new JMenuItem("Paste from Clipboard");
        this.pasteC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int numPoint;
                boolean yxColumn = false;
                boolean setMinX = false;
                boolean setMaxX = false;
                boolean setMinY = false;
                boolean setMaxY = false;
                try {
                    Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Transferable contents = clip.getContents(null);
                    DataFlavor[] flavors = contents.getTransferDataFlavors();
                    String valType = "";
                    for (int k = 0; k < flavors.length; ++k) {
                        try {
                            if (!flavors[k].getHumanPresentableName().equals("Unicode String")) continue;
                            BufferedReader in = new BufferedReader(flavors[k].getReaderForText(contents));
                            String s = in.readLine();
                            while (s != null) {
                                int i;
                                if (s.trim().length() == 0) continue;
                                StringTokenizer st = new StringTokenizer(s);
                                valType = st.nextToken();
                                if (valType.trim().equalsIgnoreCase("xmax")) {
                                    savedMaxX = Float.parseFloat(st.nextToken());
                                    setMaxX = true;
                                } else if (valType.trim().equalsIgnoreCase("xmin")) {
                                    savedMinX = Float.parseFloat(st.nextToken());
                                    setMinX = true;
                                } else if (valType.trim().equalsIgnoreCase("ymax")) {
                                    savedMaxY = Float.parseFloat(st.nextToken());
                                    setMaxY = true;
                                } else if (valType.trim().equalsIgnoreCase("ymin")) {
                                    savedMinY = Float.parseFloat(st.nextToken());
                                    setMinY = true;
                                } else if (valType.trim().equalsIgnoreCase("x")) {
                                    i = 0;
                                    numPoint = st.countTokens();
                                    savedWaveX = new float[numPoint];
                                    while (st.hasMoreTokens()) {
                                        DeviceWave.savedWaveX[i] = Float.parseFloat(st.nextToken());
                                        ++i;
                                    }
                                } else if (valType.trim().equalsIgnoreCase("y")) {
                                    i = 0;
                                    numPoint = st.countTokens();
                                    savedWaveY = new float[numPoint];
                                    while (st.hasMoreTokens()) {
                                        DeviceWave.savedWaveY[i] = Float.parseFloat(st.nextToken());
                                        ++i;
                                    }
                                } else if (valType.trim().equalsIgnoreCase("xc") && st.nextToken().equalsIgnoreCase("yc") || (yxColumn = valType.trim().equalsIgnoreCase("yc") && st.nextToken().equalsIgnoreCase("xc"))) {
                                    i = 0;
                                    Vector<Float> vectX = new Vector<Float>();
                                    Vector<Float> vectY = new Vector<Float>();
                                    while ((s = in.readLine()) != null) {
                                        StringTokenizer st1 = new StringTokenizer(s);
                                        float fv1 = Float.parseFloat(st1.nextToken());
                                        float fv2 = Float.parseFloat(st1.nextToken());
                                        vectX.addElement(yxColumn ? new Float(fv2) : new Float(fv1));
                                        vectY.addElement(yxColumn ? new Float(fv1) : new Float(fv2));
                                    }
                                    savedWaveX = new float[vectX.size()];
                                    savedWaveY = new float[vectY.size()];
                                    for (Float val : vectX) {
                                        DeviceWave.savedWaveX[i++] = val.floatValue();
                                    }
                                    i = 0;
                                    for (Float val : vectY) {
                                        DeviceWave.savedWaveY[i++] = val.floatValue();
                                    }
                                } else {
                                    JOptionPane.showMessageDialog(DeviceWave.this, "Clipboard contents syntax error\nSyntax : \nx nx1 nx2 nx3 ..... nxm\ny ny1 ny2 ny3 ..... nym", "Invalid clipboard contents", 2);
                                    return;
                                }
                                s = in.readLine();
                            }
                            break;
                        }
                        catch (NumberFormatException ex) {
                            JOptionPane.showMessageDialog(DeviceWave.this, "Clipboard contents syntax error on " + valType + " value", "Invalid clipboard contents", 2);
                            return;
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(DeviceWave.this, "Error on clipboard data reading", "Invalid clipboard contents", 2);
                            return;
                        }
                    }
                }
                catch (UnsupportedFlavorException ex) {
                    JOptionPane.showMessageDialog(DeviceWave.this, "Clipboard data type not supported", "Invalid clipboard contents", 2);
                    return;
                }
                try {
                    int i;
                    numPoint = savedWaveX.length;
                    if (savedWaveX.length != savedWaveY.length) {
                        JOptionPane.showMessageDialog(DeviceWave.this, "x and y array must be equal in length", "Invalid clipboard contents", 2);
                        return;
                    }
                    for (int i2 = 1; i2 < numPoint; ++i2) {
                        if (!(savedWaveX[i2] < savedWaveX[i2 - 1])) continue;
                        JOptionPane.showMessageDialog(DeviceWave.this, "X must be monotonic increasing array", "Invalid clipboard contents", 2);
                        return;
                    }
                    if (DeviceWave.this.minXVisible && setMinX) {
                        DeviceWave.this.minX = savedMinX;
                    }
                    if (DeviceWave.this.minYVisible && setMinY) {
                        DeviceWave.this.minY = savedMinY;
                    }
                    if (DeviceWave.this.maxXVisible && setMaxX) {
                        DeviceWave.this.maxX = savedMaxX;
                    }
                    if (DeviceWave.this.maxYVisible && setMaxY) {
                        DeviceWave.this.maxY = savedMaxY;
                    }
                    Vector<Float> vectX = new Vector<Float>();
                    Vector<Float> vectY = new Vector<Float>();
                    String warningMessage = "";
                    boolean minXfound = false;
                    boolean maxXfound = false;
                    for (i = 0; i < numPoint; ++i) {
                        float valX = savedWaveX[i];
                        float valY = savedWaveY[i];
                        if (valX < DeviceWave.this.minX) continue;
                        if (valX > DeviceWave.this.maxX) break;
                        if (valX >= DeviceWave.this.minX || valX <= DeviceWave.this.maxX) {
                            if (valY < DeviceWave.this.minY) {
                                valY = DeviceWave.this.minY;
                            } else if (valY > DeviceWave.this.maxY) {
                                valY = DeviceWave.this.maxY;
                            }
                        } else {
                            valY = 0.0f;
                        }
                        if (valX <= DeviceWave.this.minX) {
                            if (minXfound) continue;
                            valX = DeviceWave.this.minX;
                            minXfound = true;
                        } else if (valX >= DeviceWave.this.maxX) {
                            if (maxXfound) break;
                            valX = DeviceWave.this.maxX;
                            maxXfound = true;
                        } else {
                            if (!minXfound && (i == 0 || savedWaveX[i - 1] < DeviceWave.this.minX)) {
                                vectX.addElement(new Float(DeviceWave.this.minX));
                                vectY.addElement(new Float(0.0f));
                                vectX.addElement(new Float(valX));
                                vectY.addElement(new Float(0.0f));
                            }
                            if (!maxXfound && (i == numPoint - 1 || savedWaveX[i + 1] > DeviceWave.this.maxX)) {
                                vectX.addElement(new Float(valX));
                                vectY.addElement(new Float(valY));
                                vectX.addElement(new Float(valX));
                                vectY.addElement(new Float(0.0f));
                                valX = DeviceWave.this.maxX;
                                valY = 0.0f;
                            }
                        }
                        vectX.addElement(new Float(valX));
                        vectY.addElement(new Float(valY));
                    }
                    i = 0;
                    DeviceWave.this.waveX = new float[vectX.size()];
                    DeviceWave.this.waveY = new float[vectY.size()];
                    for (Float val : vectX) {
                        DeviceWave.this.waveX[i++] = val.floatValue();
                    }
                    i = 0;
                    for (Float val : vectY) {
                        DeviceWave.this.waveY[i++] = val.floatValue();
                    }
                    if (warningMessage.length() > 0) {
                        JOptionPane.showMessageDialog(DeviceWave.this, warningMessage, "WARNING clipboard contents", 2);
                    }
                }
                catch (Exception exc) {
                    JOptionPane.showMessageDialog(DeviceWave.this, "Invalid content in clipboard", "Parsing clipboard data error", 2);
                }
                DeviceWave.this.displayData(null, true);
            }
        });
        this.copyPastePopup.add(this.pasteC);
        this.pasteC.setEnabled(this.isClipboardText(Toolkit.getDefaultToolkit().getSystemClipboard()));
        Toolkit.getDefaultToolkit().getSystemClipboard().addFlavorListener(new FlavorListener(){

            @Override
            public void flavorsChanged(FlavorEvent e) {
                Clipboard clip = (Clipboard)e.getSource();
                DeviceWave.this.pasteC.setEnabled(DeviceWave.this.isClipboardText(clip));
            }
        });
        this.copyC = new JMenuItem("Copy to Clipboard");
        this.copyC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String myString = "";
                if (DeviceWave.this.minXVisible) {
                    myString = myString + "xmin\t" + DeviceWave.this.minX + "\n";
                }
                if (DeviceWave.this.minYVisible) {
                    myString = myString + "ymin\t" + DeviceWave.this.minY + "\n";
                }
                if (DeviceWave.this.maxXVisible) {
                    myString = myString + "xmax\t" + DeviceWave.this.maxX + "\n";
                }
                if (DeviceWave.this.maxYVisible) {
                    myString = myString + "ymax\t" + DeviceWave.this.maxY + "\n";
                }
                myString = myString + "x";
                for (float val : DeviceWave.this.waveX) {
                    myString = myString + "\t" + val;
                }
                myString = myString + "\ny";
                for (float val : DeviceWave.this.waveY) {
                    myString = myString + "\t" + val;
                }
                StringSelection stringSelection = new StringSelection(myString);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, null);
            }
        });
        this.copyPastePopup.add(this.copyC);
        this.copyPastePopup.pack();
        this.copyPastePopup.setInvoker(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if ((e.getModifiers() & 4) != 0) {
                    if (savedWaveX == null) {
                        DeviceWave.this.pasteI.setEnabled(false);
                    } else {
                        DeviceWave.this.pasteI.setEnabled(true);
                    }
                    DeviceWave.this.copyPastePopup.setInvoker(DeviceWave.this);
                    DeviceWave.this.copyPastePopup.show(DeviceWave.this, e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    protected void initializeData(String data, boolean is_on) {
        int i;
        float[] currX;
        float[] currY;
        String currData;
        int currNid;
        this.create();
        this.initializing = true;
        try {
            currNid = this.nidData + 1;
            currData = this.subtree.execute(this.subtree.getDataExpr(currNid));
            this.minX = this.minXOld = this.subtree.getFloat(currData);
        }
        catch (Exception exc) {
            this.minXOld = 0.0f;
            this.minX = 0.0f;
        }
        try {
            currNid = this.nidData + 2;
            currData = this.subtree.execute(this.subtree.getDataExpr(currNid));
            this.maxX = this.maxXOld = this.subtree.getFloat(currData);
        }
        catch (Exception exc) {
            this.maxXOld = 1.0f;
            this.maxX = 1.0f;
        }
        try {
            currNid = this.nidData + 3;
            currData = this.subtree.execute(this.subtree.getDataExpr(currNid));
            this.minY = this.minYOld = this.subtree.getFloat(currData);
        }
        catch (Exception exc) {
            this.minYOld = 0.0f;
            this.minY = 0.0f;
        }
        try {
            currNid = this.nidData + 4;
            currData = this.subtree.execute(this.subtree.getDataExpr(currNid));
            this.maxY = this.maxYOld = this.subtree.getFloat(currData);
        }
        catch (Exception exc) {
            this.maxYOld = 1.0f;
            this.maxY = 1.0f;
        }
        try {
            currNid = this.nidData;
            currData = this.subtree.getDataExpr(currNid);
            currY = this.subtree.getFloatArray("VALUE_OF(" + currData + ")");
            currX = this.subtree.getFloatArray("DIM_OF(" + currData + ")");
        }
        catch (Exception exc) {
            currX = new float[]{this.minX, this.maxX};
            currY = new float[]{0.0f, 0.0f};
        }
        if ((double)currX[0] <= (double)this.minX - 1.0E-5 || (double)currX[currX.length - 1] >= (double)this.maxX + 1.0E-5) {
            currX = new float[]{this.minX, this.maxX};
            currY = new float[]{0.0f, 0.0f};
            JOptionPane.showMessageDialog(this, "The stored signal lies outside the valid X range. Hit apply to override the incorrect values.", "Incorret waveform limits", 2);
        }
        int nPoints = currX.length;
        if ((double)Math.abs(currX[0] - this.minX) > 1.0E-5) {
            ++nPoints;
        } else {
            currX[0] = this.minX;
        }
        if ((double)Math.abs(currX[currX.length - 1] - this.maxX) > 1.0E-5) {
            ++nPoints;
        } else {
            currX[currX.length - 1] = this.maxX;
        }
        this.waveX = new float[nPoints];
        this.waveY = new float[nPoints];
        int currIdx = 0;
        if ((double)Math.abs(currX[0] - this.minX) > 1.0E-5) {
            this.waveX[0] = this.minX;
            this.waveY[0] = 0.0f;
            ++currIdx;
        }
        for (i = 0; i < currX.length; ++i) {
            this.waveX[currIdx] = currX[i];
            this.waveY[currIdx++] = currY[i];
        }
        if ((double)Math.abs(currX[currX.length - 1] - this.maxX) > 1.0E-5) {
            this.waveX[currIdx] = this.maxX;
            this.waveY[currIdx] = 0.0f;
        }
        this.waveXOld = new float[this.waveX.length];
        this.waveYOld = new float[this.waveX.length];
        for (i = 0; i < this.waveX.length; ++i) {
            this.waveXOld[i] = this.waveX[i];
            this.waveYOld[i] = this.waveY[i];
        }
        this.displayData(data, is_on);
        this.initializing = false;
    }

    @Override
    protected void displayData(String data, boolean is_on) {
        this.waveEditor.setWaveform(this.waveX, this.waveY, this.minY, this.maxY);
        if (this.maxXVisible) {
            this.maxXField.setText("" + this.maxX);
        }
        if (this.minXVisible) {
            this.minXField.setText("" + this.minX);
        }
        if (this.maxYVisible) {
            this.maxYField.setText("" + this.maxY);
        }
        if (this.minYVisible) {
            this.minYField.setText("" + this.minY);
        }
        this.table.repaint();
    }

    @Override
    protected String getData() {
        String dims = this.getArrayExpr(this.waveX);
        String values = this.getArrayExpr(this.waveY);
        return "BUIILD_SIGNAL(" + values + ",," + dims + ")";
    }

    protected String getArrayExpr(float[] vals) {
        String retExpr = "";
        for (int i = 0; i < vals.length; ++i) {
            retExpr = i < vals.length - 1 ? retExpr + vals[i] + "," : retExpr + vals[i];
        }
        return retExpr + "]";
    }

    @Override
    protected boolean getState() {
        return true;
    }

    @Override
    public void setEnabled(boolean state) {
    }

    @Override
    public void apply() throws Exception {
        TableCellEditor ce = this.table.getCellEditor();
        if (ce != null) {
            ce.stopCellEditing();
        }
        super.apply();
        this.updateLimits();
        if (this.minXVisible) {
            try {
                this.subtree.putDataExpr(this.nidData + 1, "" + this.minX);
            }
            catch (Exception exc) {
                System.out.println("Error storing min X value: " + exc);
            }
        }
        if (this.maxXVisible) {
            try {
                this.subtree.putDataExpr(this.nidData + 2, "" + this.maxX);
            }
            catch (Exception exc) {
                System.out.println("Error storing max X value: " + exc);
            }
        }
        if (this.minYVisible) {
            try {
                this.subtree.putDataExpr(this.nidData + 3, "" + this.minY);
            }
            catch (Exception exc) {
                System.out.println("Error storing min Y value: " + exc);
            }
        }
        if (this.maxYVisible) {
            try {
                this.subtree.putDataExpr(this.nidData + 4, "" + this.maxY);
            }
            catch (Exception exc) {
                System.out.println("Error storing max Y value: " + exc);
            }
        }
    }

    @Override
    public void reset() {
        this.minX = this.minXOld;
        this.maxX = this.maxXOld;
        this.minY = this.minYOld;
        this.maxY = this.maxYOld;
        this.waveX = new float[this.waveXOld.length];
        this.waveY = new float[this.waveXOld.length];
        for (int i = 0; i < this.waveXOld.length; ++i) {
            this.waveX[i] = this.waveXOld[i];
            this.waveY[i] = this.waveYOld[i];
        }
        super.reset();
    }

    protected void updateLimits() {
        if (this.minXVisible) {
            while (true) {
                try {
                    this.minX = new Float(this.minXField.getText()).floatValue();
                }
                catch (Exception exc) {
                    JOptionPane.showMessageDialog(this, "Invalid value for min X", "Incorret limit", 2);
                    continue;
                }
                break;
            }
        }
        if (this.maxXVisible) {
            while (true) {
                try {
                    this.maxX = new Float(this.maxXField.getText()).floatValue();
                }
                catch (Exception exc) {
                    JOptionPane.showMessageDialog(this, "Invalid value for max X", "Incorret limit", 2);
                    continue;
                }
                break;
            }
        }
        if (this.minYVisible) {
            while (true) {
                try {
                    this.minY = new Float(this.minYField.getText()).floatValue();
                }
                catch (Exception exc) {
                    JOptionPane.showMessageDialog(this, "Invalid value for min Y", "Incorret limit", 2);
                    continue;
                }
                break;
            }
        }
        if (this.maxYVisible) {
            while (true) {
                try {
                    this.maxY = new Float(this.maxYField.getText()).floatValue();
                }
                catch (Exception exc) {
                    JOptionPane.showMessageDialog(this, "Invalid value for max Y", "Incorret limit", 2);
                    continue;
                }
                break;
            }
            for (int i = 0; i < this.waveX.length; ++i) {
                if (!(this.waveY[i] > this.maxY)) continue;
                this.waveY[i] = this.maxY;
            }
            this.repaint();
        }
    }

    @Override
    public Component add(Component c) {
        if (!this.initializing) {
            JOptionPane.showMessageDialog(null, "You cannot add a component to a Device Wave. Please remove the component.", "Error adding Device field", 2);
            return null;
        }
        return super.add(c);
    }

    @Override
    public Component add(String name, Component c) {
        if (!this.initializing) {
            JOptionPane.showMessageDialog(null, "You cannot add a component to a Device Wave. Please remove the component.", "Error adding Device field", 2);
            return null;
        }
        return super.add(c);
    }

    @Override
    public Component add(Component c, int intex) {
        if (!this.initializing) {
            JOptionPane.showMessageDialog(null, "You cannot add a component to a Device Wave. Please remove the component.", "Error adding Device field", 2);
            return null;
        }
        return super.add(c);
    }

    @Override
    public void fireUpdate(String updateId, String newExpr) {
        if (this.updateIdentifier != null && this.updateExpression != null && this.updateIdentifier.equals(updateId)) {
            StringTokenizer st = new StringTokenizer(this.updateExpression, "$");
            String newExprStr = "";
            try {
                String newVal = newExpr.toString();
                while (st.hasMoreTokens()) {
                    newExprStr = newExprStr + st.nextToken();
                    if (!st.hasMoreTokens()) continue;
                    newExprStr = newExprStr + newVal;
                }
                this.master.updateIdentifiers();
                String newData = this.subtree.execute(newExprStr);
                this.maxY = this.subtree.getFloat(newData);
                if (this.maxYVisible) {
                    this.maxYField.setText("" + this.maxY);
                }
                this.waveEditor.setWaveform(this.waveX, this.waveY, this.minY, this.maxY);
            }
            catch (Exception exc) {
                System.err.println("Error updating Max Y: " + exc);
            }
        }
    }

    @Override
    protected Object getFullData() {
        Vector<Object> res = new Vector<Object>();
        res.add(new Float(this.minX));
        res.add(new Float(this.maxX));
        res.add(new Float(this.minY));
        res.add(new Float(this.maxY));
        res.add(this.waveX);
        res.add(this.waveY);
        return res;
    }

    @Override
    protected void dataChanged(int offsetNid, Object data) {
        Vector inVect;
        if (offsetNid != this.getOffsetNid()) {
            return;
        }
        try {
            inVect = (Vector)data;
        }
        catch (Exception exc) {
            System.err.println("Internal error: wrong data passed to DeviceWave.dataChanged");
            return;
        }
        this.minX = ((Float)inVect.elementAt(0)).floatValue();
        this.maxX = ((Float)inVect.elementAt(1)).floatValue();
        this.minY = ((Float)inVect.elementAt(2)).floatValue();
        this.maxY = ((Float)inVect.elementAt(3)).floatValue();
        float[] currX = (float[])inVect.elementAt(4);
        float[] currY = (float[])inVect.elementAt(5);
        try {
            this.waveX = new float[currX.length];
            this.waveY = new float[currY.length];
            for (int i = 0; i < currX.length; ++i) {
                this.waveX[i] = currX[i];
                this.waveY[i] = currY[i];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.displayData(null, true);
    }

    @Override
    public void setHighlight(boolean highlighted) {
        if (highlighted) {
            WaveformEditor.SetColors(new Color[]{Color.red}, new String[]{"Red"});
        } else {
            WaveformEditor.SetColors(new Color[]{Color.black}, new String[]{"Black"});
        }
        super.setHighlight(highlighted);
    }

    public static void main(String[] args) {
        DeviceWave dw = new DeviceWave();
        System.out.println("Istanziato");
    }

    static {
        savedWaveX = null;
        savedWaveY = null;
    }
}

