/*
 * Decompiled with CFR 0.152.
 */
package mds.provider.mds;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JOptionPane;

public class MdsIpProtocolWrapper {
    int connectionIdx = -1;

    InputStream getInputStream() {
        return new MdsIpInputStream();
    }

    OutputStream getOutputStream() {
        return new MdsIpOutputStream();
    }

    public native int connectToMds(String var1);

    public native int send(int var1, byte[] var2, boolean var3);

    public native byte[] recv(int var1, int var2);

    public native void flush(int var1);

    public native void disconnect(int var1);

    public MdsIpProtocolWrapper(String url) {
        this.connectionIdx = this.connectToMds(url);
    }

    public static void main(String[] args) {
        MdsIpProtocolWrapper mpw = new MdsIpProtocolWrapper("tcp");
        int idx = mpw.connectToMds("tcp://ra22.igi.cnr.it:8100");
        System.out.println("Connected: " + idx);
    }

    static {
        try {
            System.loadLibrary("JavaMds");
        }
        catch (UnsatisfiedLinkError e) {
            JOptionPane.showMessageDialog(null, "Can't load data provider class LocalDataProvider : " + e, "Alert LocalDataProvider", 0);
        }
    }

    class MdsIpOutputStream
    extends OutputStream {
        MdsIpOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            if (MdsIpProtocolWrapper.this.connectionIdx == -1) {
                throw new IOException("Not Connected");
            }
            int numSent = MdsIpProtocolWrapper.this.send(MdsIpProtocolWrapper.this.connectionIdx, new byte[]{(byte)b}, false);
            if (numSent == -1) {
                throw new IOException("Cannot Write Data");
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (MdsIpProtocolWrapper.this.connectionIdx == -1) {
                throw new IOException("Not Connected");
            }
            int numSent = MdsIpProtocolWrapper.this.send(MdsIpProtocolWrapper.this.connectionIdx, b, false);
            if (numSent == b.length) {
                throw new IOException("Incomplete write");
            }
        }

        @Override
        public void close() throws IOException {
            if (MdsIpProtocolWrapper.this.connectionIdx != -1) {
                MdsIpProtocolWrapper.this.disconnect(MdsIpProtocolWrapper.this.connectionIdx);
                MdsIpProtocolWrapper.this.connectionIdx = -1;
            }
        }
    }

    class MdsIpInputStream
    extends InputStream {
        MdsIpInputStream() {
        }

        @Override
        public int read() throws IOException {
            if (MdsIpProtocolWrapper.this.connectionIdx == -1) {
                throw new IOException("Not Connected");
            }
            byte[] readBuf = MdsIpProtocolWrapper.this.recv(MdsIpProtocolWrapper.this.connectionIdx, 1);
            if (readBuf == null) {
                throw new IOException("Cannot Read Data");
            }
            return readBuf[0];
        }

        @Override
        public int read(byte[] buf) throws IOException {
            if (MdsIpProtocolWrapper.this.connectionIdx == -1) {
                throw new IOException("Not Connected");
            }
            byte[] readBuf = MdsIpProtocolWrapper.this.recv(MdsIpProtocolWrapper.this.connectionIdx, buf.length);
            if (readBuf == null) {
                throw new IOException("Cannot Read Data");
            }
            System.arraycopy(readBuf, 0, buf, 0, buf.length);
            return buf.length;
        }

        @Override
        public int read(byte[] buf, int offset, int len) throws IOException {
            if (MdsIpProtocolWrapper.this.connectionIdx == -1) {
                throw new IOException("Not Connected");
            }
            byte[] readBuf = MdsIpProtocolWrapper.this.recv(MdsIpProtocolWrapper.this.connectionIdx, len);
            if (readBuf == null || readBuf.length == 0) {
                throw new IOException("Cannot Read Data");
            }
            System.arraycopy(readBuf, 0, buf, offset, readBuf.length);
            return readBuf.length;
        }
    }
}

