/*
 * Decompiled with CFR 0.152.
 */
package mds.wave;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;
import mds.wave.Waveform;
import mds.wave.WaveformMetrics;

public class Grid
implements Serializable {
    static final long dayMilliSeconds = 86400000L;
    WaveformMetrics wm;
    boolean reversed = false;
    int x_dim;
    int y_dim;
    double[] x_values;
    double[] y_values;
    double x_step;
    double y_step;
    int grid_step_x;
    int grid_step_y;
    int mode;
    boolean int_ylabels;
    boolean int_xlabels;
    Font font;
    int label_width;
    int label_height;
    int label_descent;
    int num_x_steps;
    int num_y_steps;
    String x_label;
    String y_label;
    String title;
    String error;
    static final int IS_X = 0;
    static final int IS_Y = 1;
    public static final int IS_DOTTED = 0;
    public static final int IS_GRAY = 1;
    public static final int IS_NONE = 2;
    public static final int MAX_GRID = 10;
    public static final String[] GRID_MODE = new String[]{"Dotted", "Gray", "None"};
    double xmax;
    boolean xAxisHMS = false;

    public Grid(double xmax, double ymax, double xmin, double ymin, boolean xlog, boolean ylog, int mode, String x_label, String y_label, String title, String error, int grid_step_x, int grid_step_y, boolean int_xlabels, boolean int_ylabels, boolean reversed) {
        this.reversed = reversed;
        this.mode = mode;
        this.x_label = x_label;
        this.y_label = y_label;
        this.title = title;
        this.error = error;
        this.grid_step_x = grid_step_x;
        this.grid_step_y = grid_step_y;
        this.int_xlabels = int_xlabels;
        this.int_ylabels = int_ylabels;
        this.font = null;
        this.x_values = new double[50];
        this.y_values = new double[50];
        this.xmax = xmax;
        this.x_dim = this.BuildGrid(this.x_values, 0, xmax, ymax, xmin, ymin, xlog, ylog);
        this.y_dim = this.BuildGrid(this.y_values, 1, xmax, ymax, xmin, ymin, xlog, ylog);
    }

    void SetReversed(boolean reversed) {
        this.reversed = reversed;
    }

    public static double evalStep(double min, double max, int numStep) {
        double delta = Math.abs(max - min);
        int pow = (int)Math.log10(delta) - 1;
        return 2.0 * Math.pow(10.0, pow);
    }

    private int BuildGridNew(double[] val, int mode, double xmax, double ymax, double xmin, double ymin, boolean xlog, boolean ylog) {
        double curr;
        int i;
        double step;
        double curr_min;
        double curr_max;
        int grid_step;
        if (ymax < ymin) {
            ymax = ymin + 1.0E-10;
        }
        if (xmax < xmin) {
            xmax = xmin + 1.0E-10;
        }
        double xrange = xmax - xmin;
        double yrange = ymax - ymin;
        boolean greater = false;
        int count = 0;
        if (xrange <= 0.0) {
            xrange = 0.001;
        }
        if (yrange <= 0.0) {
            yrange = 0.001;
        }
        if (mode == 0) {
            grid_step = this.grid_step_x;
            curr_max = xmax + 0.1 * xrange;
            curr_min = xmin - 0.1 * xrange;
            step = (xmax - xmin) / (double)grid_step;
            step = Grid.evalStep(xmin, xmax, grid_step);
        } else {
            grid_step = this.grid_step_y;
            curr_max = ymax + 0.1 * yrange;
            curr_min = ymin - 0.1 * yrange;
            step = (ymax - ymin) / (double)grid_step;
        }
        if (step > 1.0) {
            greater = true;
            while (step / 10.0 > 1.0) {
                step /= 10.0;
                ++count;
            }
        } else {
            greater = false;
            while (step < 1.0 && step > 0.0) {
                step *= 10.0;
                ++count;
            }
        }
        step = (int)step;
        int num_steps = (int)step;
        if (greater) {
            for (i = 0; i < count; ++i) {
                step *= 10.0;
            }
        } else {
            for (i = 0; i < count; ++i) {
                step /= 10.0;
            }
        }
        if ((curr = (double)((long)(curr_min / step)) * step) > curr_min) {
            curr -= (double)((long)((curr - curr_min) / step)) * step;
        }
        while (curr >= curr_min) {
            curr -= step;
        }
        for (i = 0; i < 50 && curr < curr_max + step; curr += step, ++i) {
            val[i] = (double)((long)(curr / step + 0.5)) * step;
            if (!(val[i] < step / 100.0) || !(val[i] > -step / 100.0)) continue;
            val[i] = 0.0;
        }
        if (mode == 0) {
            this.x_step = step / (double)num_steps;
            this.num_x_steps = num_steps;
        } else {
            this.y_step = step / (double)num_steps;
            this.num_y_steps = num_steps;
        }
        return i;
    }

    private int BuildGrid(double[] val, int mode, double xmax, double ymax, double xmin, double ymin, boolean xlog, boolean ylog) {
        double curr;
        int i;
        double step;
        double curr_min;
        double curr_max;
        int grid_step;
        if (ymax <= ymin) {
            ymax = ymin + 1.0E-10;
        }
        if (xmax <= xmin) {
            xmax = xmin + 1.0E-10;
        }
        double xrange = xmax - xmin;
        double yrange = ymax - ymin;
        boolean greater = false;
        int count = 0;
        if (xrange <= 0.0) {
            xrange = 0.001;
        }
        if (yrange <= 0.0) {
            yrange = 0.001;
        }
        if (mode == 0) {
            grid_step = this.grid_step_x;
            curr_max = xmax + 0.1 * xrange;
            curr_min = xmin - 0.1 * xrange;
            step = (xmax - xmin) / (double)grid_step;
        } else {
            grid_step = this.grid_step_y;
            curr_max = ymax + 0.1 * yrange;
            curr_min = ymin - 0.1 * yrange;
            step = (ymax - ymin) / (double)grid_step;
        }
        if (step > 1.0) {
            greater = true;
            while (step / 10.0 > 1.0) {
                step /= 10.0;
                ++count;
            }
        } else {
            greater = false;
            while (step < 1.0 && step > 0.0) {
                step *= 10.0;
                ++count;
            }
        }
        step = (int)step;
        int num_steps = (int)step;
        if (greater) {
            for (i = 0; i < count; ++i) {
                step *= 10.0;
            }
        } else {
            for (i = 0; i < count; ++i) {
                step /= 10.0;
            }
        }
        if ((curr = (double)((long)(curr_min / step)) * step) > curr_min) {
            curr -= (double)((long)((curr - curr_min) / step)) * step;
        }
        while (curr >= curr_min) {
            curr -= step;
        }
        for (i = 0; i < 50 && curr < curr_max + step; curr += step, ++i) {
            val[i] = (double)((long)(curr / step + 0.5)) * step;
            if (!(val[i] < step / 100.0) || !(val[i] > -step / 100.0)) continue;
            val[i] = 0.0;
        }
        if (mode == 0) {
            this.x_step = step / (double)num_steps;
            this.num_x_steps = num_steps;
        } else {
            this.y_step = step / (double)num_steps;
            this.num_y_steps = num_steps;
        }
        return i;
    }

    public void setXaxisHMS(boolean xAxisHMS) {
        this.xAxisHMS = xAxisHMS;
    }

    public void GetLimits(Graphics g, Rectangle lim_rect, boolean ylog) {
        FontMetrics fm = g.getFontMetrics();
        int label_height = this.int_xlabels ? 1 : (this.x_label != null ? 2 * fm.getHeight() : fm.getHeight());
        int label_width = 0;
        if (!this.int_ylabels) {
            for (int i = 0; i < this.y_dim; ++i) {
                int curr_dim = fm.stringWidth(Waveform.ConvertToString(this.y_values[i], ylog));
                if (label_width >= curr_dim) continue;
                label_width = curr_dim;
            }
            if (this.y_label != null) {
                label_width += fm.getHeight();
            }
        }
        lim_rect.width = label_width;
        lim_rect.height = label_height;
    }

    public void updateValues(String x_label, String y_label, String title, String error, int grid_step_x, int grid_step_y, boolean int_xlabels, boolean int_ylabels, boolean reversed) {
        this.reversed = reversed;
        this.x_label = x_label;
        this.y_label = y_label;
        this.title = title;
        this.error = error;
        this.grid_step_x = grid_step_x;
        this.grid_step_y = grid_step_y;
        this.int_xlabels = int_xlabels;
        this.int_ylabels = int_ylabels;
    }

    private long toMillis(double xin) {
        if (xin > 2.0E13) {
            xin /= 1000000.0;
        }
        return (long)xin;
    }

    /*
     * Unable to fully structure code
     */
    public void paint(Graphics g, Dimension d, Waveform w, WaveformMetrics wm) {
        curr_date_string = null;
        prev_date_string = "";
        if (this.reversed) {
            g.setColor(Color.white);
        } else {
            g.setColor(Color.black);
        }
        this.wm = wm;
        fm = g.getFontMetrics();
        this.label_height = this.int_xlabels != false ? 0 : fm.getHeight();
        this.label_descent = fm.getDescent();
        this.label_width = 0;
        if (!this.int_ylabels && wm != null) {
            for (i = 0; i < this.y_dim; ++i) {
                curr_dim = fm.stringWidth(Waveform.ConvertToString(this.y_values[i], wm.YLog()));
                if (this.label_width >= curr_dim) continue;
                this.label_width = curr_dim;
            }
            if (this.y_label != null) {
                this.label_width += fm.getHeight();
            }
        }
        prev_col = g.getColor();
        if (wm != null) {
            for (i = 0; i < this.y_dim; ++i) {
                dim = wm.YPixel(this.y_values[i], d);
                switch (this.mode) {
                    case 0: {
                        if (dim > d.height - this.label_height) break;
                        for (j = this.label_width; j < d.width; j += 4) {
                            g.fillRect(j, dim, 1, 1);
                        }
                        break;
                    }
                    case 1: {
                        g.setColor(Color.lightGray);
                        if (dim > d.height - this.label_height) break;
                        g.drawLine(this.label_width, dim, d.width, dim);
                        break;
                    }
                    case 2: {
                        if (dim <= d.height - this.label_height) {
                            g.drawLine(this.label_width + 3, dim, d.width / 80 + this.label_width + 3, dim);
                            g.drawLine(d.width - d.width / 80, dim, d.width, dim);
                        }
                        if (i == this.y_dim - 1) break;
                        curr_step = wm.YLog() != false ? (this.y_values[i + 1] - this.y_values[i]) / (double)this.num_y_steps : this.y_step;
                        for (j = 1; j <= this.num_y_steps; ++j) {
                            curr_dim = wm.YPixel(this.y_values[i] + (double)j * curr_step, d);
                            if (curr_dim > d.height - this.label_height) continue;
                            g.drawLine(this.label_width + 3, curr_dim, this.label_width + d.width / 100 + 3, curr_dim);
                            g.drawLine(d.width - d.width / 100, curr_dim, d.width, curr_dim);
                        }
                        break;
                    }
                }
                g.setColor(prev_col);
                if (dim > d.height - this.label_height || (curr_dim = dim + fm.getHeight() / 2) - fm.getAscent() < 0 || curr_dim + fm.getDescent() > d.height) continue;
                ylabel_offset = 1;
                if (this.y_label != null) {
                    ylabel_offset = fm.getHeight();
                }
                if (this.int_ylabels) {
                    ylabel_offset = this.mode == 2 ? (ylabel_offset += d.width / 40) : 2;
                }
                g.drawString(Waveform.ConvertToString(this.y_values[i], wm.YLog()), ylabel_offset + 1, curr_dim);
            }
            currStringSubSec = "";
            prevIdx = 0;
            for (i = 0; i < this.x_dim; ++i) {
                dim = wm.XPixel(this.x_values[i], d);
                switch (this.mode) {
                    case 0: {
                        if (dim < this.label_width) break;
                        for (j = 0; j < d.height - this.label_height; j += 4) {
                            g.fillRect(dim, j, 1, 1);
                        }
                        break;
                    }
                    case 1: {
                        g.setColor(Color.lightGray);
                        if (dim < this.label_width) break;
                        g.drawLine(dim, 0, dim, d.height - this.label_height);
                        break;
                    }
                    case 2: {
                        if (dim >= this.label_width) {
                            g.drawLine(dim, 2, dim, d.height / 40);
                            g.drawLine(dim, d.height - this.label_height - d.height / 40, dim, d.height - this.label_height);
                        }
                        if (i == this.x_dim - 1) break;
                        curr_step = wm.XLog() != false ? (this.x_values[i + 1] - this.x_values[i]) / (double)this.num_x_steps : this.x_step;
                        for (j = 1; j <= this.num_x_steps; ++j) {
                            val = this.x_values[i] + (double)j * curr_step;
                            curr_dim = wm.XPixel(val, d);
                            if (curr_dim < this.label_width) continue;
                            g.drawLine(curr_dim, 2, curr_dim, d.height / 80);
                            g.drawLine(curr_dim, d.height - this.label_height - d.height / 80, curr_dim, d.height - this.label_height);
                        }
                        g.drawRect(this.label_width + 3, 2, d.width - this.label_width - 3, d.height - this.label_height - 2);
                    }
                }
                g.setColor(prev_col);
                if (this.xAxisHMS) {
                    try {
                        datel = this.toMillis(this.x_values[i]);
                        df = new SimpleDateFormat("HH:mm:ss");
                        dfSubSec = new SimpleDateFormat("HH:mm:ss.SSS");
                        if (datel <= 86400000L) {
                            df.setTimeZone(new SimpleTimeZone(0, "GMT"));
                            dfSubSec.setTimeZone(new SimpleTimeZone(0, "GMT"));
                        }
                        date = new Date();
                        date.setTime(datel);
                        currStringSubSec = dfSubSec.format(date);
                        curr_string = df.format(date);
                        df1 = new SimpleDateFormat("d-MMM-yyyy");
                        new_date_string = df1.format(date);
                        curr_date_string = i == 0 || new_date_string.equals(prev_date_string) == false ? (prev_date_string = new_date_string) : null;
                        if (i >= this.x_dim - 1 || (num_day = this.calculateDifference(new Date(this.toMillis(this.x_values[i])), new Date(this.toMillis(this.x_values[i + 1])))) == 0L) ** GOTO lbl128
                        ca = Calendar.getInstance();
                        ca.setTimeInMillis(this.toMillis(this.x_values[i]));
                        ca.set(ca.get(1), ca.get(2), ca.get(5) + 1, 0, 0);
                        dd = 0;
                        while ((long)dd < num_day) {
                            timeMillis = ca.getTimeInMillis();
                            if ((double)timeMillis < this.xmax) {
                                c = g.getColor();
                                g.setColor(Color.BLUE);
                                curr_dim = wm.XPixel(timeMillis, d);
                                if (curr_dim >= this.label_width) {
                                    for (j = 0; j < d.height - this.label_height; j += 7) {
                                        g.fillRect(curr_dim, j, 1, 5);
                                    }
                                }
                                g.setColor(c);
                            }
                            ca.set(ca.get(1), ca.get(2), ca.get(5) + 1, 0, 0);
                            ++dd;
                        }
                    }
                    catch (Exception exc) {
                        curr_string = Waveform.ConvertToString(this.x_values[i], wm.XLog());
                    }
                } else {
                    curr_string = Waveform.ConvertToString(this.x_values[i], wm.XLog());
                }
lbl128:
                // 4 sources

                curr_dim = dim - fm.stringWidth(curr_string) / 2;
                if (curr_dim >= this.label_width && dim + fm.stringWidth(curr_string) / 2 < d.width) {
                    if (this.xAxisHMS && i > 0 && this.toMillis(this.x_values[i] - this.x_values[prevIdx]) < 1000L) {
                        g.drawString(currStringSubSec, curr_dim, d.height - fm.getHeight() / 10 - this.label_descent);
                    } else {
                        g.drawString(curr_string, curr_dim, d.height - fm.getHeight() / 10 - this.label_descent);
                    }
                    prevIdx = i;
                }
                if (curr_date_string == null || (curr_dim = dim - fm.stringWidth(curr_date_string) / 2) < this.label_width || dim + fm.stringWidth(curr_string) / 2 >= d.width) continue;
                g.drawString(curr_date_string, curr_dim, d.height - fm.getHeight() - 2 * fm.getHeight() / 10 - this.label_descent);
            }
        }
        if (this.x_label != null && this.x_label.length() != 0) {
            g.drawString(this.x_label, (d.width - fm.stringWidth(this.x_label)) / 2, d.height - this.label_descent - fm.getHeight());
        }
        if (this.y_label != null && this.y_label.length() != 0) {
            g2d = (Graphics2D)g;
            x_tra = 4 + fm.getHeight();
            y_tra = (d.height + fm.stringWidth(this.y_label)) / 2;
            angle = 1.5707963267948966;
            g2d.translate(x_tra, y_tra);
            g2d.rotate(-angle);
            g2d.drawString(this.y_label, 0, 0);
            g2d.rotate(angle);
            g2d.translate(-x_tra, -y_tra);
        }
        if (this.title != null && this.title.length() != 0) {
            g.drawString(this.title, (d.width - fm.stringWidth(this.title)) / 2, fm.getAscent() + d.height / 40);
        }
        if (this.error != null && this.error.length() != 0) {
            y_pos = 0;
            if (this.title != null && this.title.trim().length() != 0) {
                y_pos = fm.getHeight();
            }
            g.drawString(this.error, (d.width - fm.stringWidth(this.error)) / 2, y_pos + fm.getAscent() + d.height / 40);
        }
    }

    public Rectangle GetBoundingBox(Dimension d) {
        return new Rectangle(this.label_width, 0, d.width - this.label_width + 1, d.height - this.label_height + 1);
    }

    public void setLabels(String title, String x_label, String y_label) {
        this.title = title;
        this.x_label = x_label;
        this.y_label = y_label;
    }

    public long calculateDifference(Date a, Date b) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(a);
        cal1.set(cal1.get(1), cal1.get(2), cal1.get(5), 23, 59, 59);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(b);
        cal2.set(cal2.get(1), cal2.get(2), cal2.get(5), 0, 0, 0);
        long diffMillis = cal2.getTimeInMillis() - cal1.getTimeInMillis();
        if (diffMillis < 0L) {
            return 0L;
        }
        return 1L + diffMillis / 86400000L;
    }

    public static void main(String[] args) {
    }
}

