/*
 * Decompiled with CFR 0.152.
 */
package mds.wave;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.RepaintManager;
import mds.wave.MultiWaveform;
import mds.wave.RowColumnContainer;
import mds.wave.RowColumnLayout;
import mds.wave.WaveContainerEvent;
import mds.wave.WaveContainerListener;
import mds.wave.WavePopup;
import mds.wave.Waveform;
import mds.wave.WaveformEvent;
import mds.wave.WaveformListener;
import mds.wave.WaveformManager;

public class WaveformContainer
extends RowColumnContainer
implements WaveformManager,
WaveformListener,
Printable {
    private Waveform sel_wave;
    int mode = 1;
    int grid_mode = 0;
    int x_grid_lines = 5;
    int y_grid_lines = 5;
    protected boolean reversed = false;
    private static Waveform copy_waveform = null;
    protected Font font = new Font("Helvetica", 0, 12);
    protected WavePopup wave_popup;
    private final Vector<WaveContainerListener> wave_container_listener = new Vector();
    protected boolean print_with_legend = false;
    protected boolean print_bw = false;
    protected String save_as_txt_directory = null;

    public WaveformContainer(int[] rows, boolean add_component) {
        super(rows, null);
        this.CreateWaveformContainer(add_component);
    }

    public WaveformContainer() {
        this.CreateWaveformContainer(true);
    }

    private void CreateWaveformContainer(boolean create_component) {
        if (create_component) {
            Component[] c = this.CreateWaveComponents(this.getComponentNumber());
            super.add(c);
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Dimension scr_dim = WaveformContainer.this.getToolkit().getScreenSize();
                Waveform w = (Waveform)e.getSource();
                int x = e.getX();
                int y = e.getY();
                if (WaveformContainer.this.wave_popup != null) {
                    Point p = new Point();
                    Container co = w;
                    Dimension wp_size = WaveformContainer.this.wave_popup.getSize();
                    if (wp_size.height == 0 || wp_size.width == 0) {
                        WaveformContainer.this.wave_popup.Show(w, x, y, 0, 0);
                        wp_size = WaveformContainer.this.wave_popup.getSize();
                    }
                    while (co != null) {
                        p.x += co.getLocation().x;
                        p.y += co.getLocation().y;
                        co = co.getParent();
                    }
                    int tran_x = 0;
                    int tran_y = 0;
                    if (y + p.y + wp_size.height > scr_dim.height) {
                        tran_y = y + p.y + wp_size.height - scr_dim.height + 20;
                    }
                    if (x + p.x + wp_size.width > scr_dim.width) {
                        tran_x = x + p.x + wp_size.width - scr_dim.width + 20;
                    }
                    WaveformContainer.this.wave_popup.Show(w, x, y, tran_x, tran_y);
                }
            }
        });
    }

    public Component CreateWaveComponent() {
        Component[] c = this.CreateWaveComponents(1);
        return c[0];
    }

    protected Component[] CreateWaveComponents(int num) {
        Component[] c = new Component[num];
        for (int i = 0; i < c.length; ++i) {
            MultiWaveform wave = new MultiWaveform();
            wave.addWaveformListener(this);
            this.SetWaveParams(wave);
            c[i] = wave;
        }
        return c;
    }

    public void AddComponents(Component[] c) {
        super.add(c);
    }

    public synchronized void addWaveContainerListener(WaveContainerListener l) {
        if (l == null) {
            return;
        }
        this.wave_container_listener.addElement(l);
    }

    public synchronized void removeContainerListener(ActionListener l) {
        if (l == null) {
            return;
        }
        this.wave_container_listener.removeElement(l);
    }

    protected void dispatchWaveContainerEvent(WaveContainerEvent e) {
        if (this.wave_container_listener != null) {
            for (int i = 0; i < this.wave_container_listener.size(); ++i) {
                this.wave_container_listener.elementAt(i).processWaveContainerEvent(e);
            }
        }
    }

    @Override
    public void processWaveformEvent(WaveformEvent e) {
        Waveform w = (Waveform)e.getSource();
        switch (e.getID()) {
            case 2003: {
                this.allSameScale(w);
                return;
            }
            case 2004: {
                if (copy_waveform != null) {
                    this.notifyChange(w, copy_waveform);
                }
                return;
            }
            case 2005: {
                this.setCopySource(w);
                return;
            }
            case 2007: {
                return;
            }
            case 2000: 
            case 2001: {
                if (w.GetMode() != 2) break;
                double x = e.point_x;
                double y = e.point_y;
                if (w.IsImage()) {
                    x = e.delta_x;
                } else if (e.is_mb2) {
                    this.allSameXScaleAutoY(w);
                }
                if (!Double.isNaN(e.time_value)) {
                    x = e.time_value;
                }
                this.UpdatePoints(x, y, (Waveform)e.getSource());
                break;
            }
        }
        WaveContainerEvent we = new WaveContainerEvent((Object)this, e);
        this.dispatchWaveContainerEvent(we);
    }

    public void setPopupMenu(WavePopup wave_popup) {
        this.wave_popup = wave_popup;
        wave_popup.setParent(this);
    }

    public Waveform GetWavePanel(int idx) {
        Component c = this.getGridComponent(idx);
        if (c instanceof MultiWaveform || c instanceof Waveform) {
            return (Waveform)c;
        }
        return null;
    }

    public void SetWaveParams(Waveform w) {
        boolean int_label = this.grid_mode != 2;
        w.SetMode(this.mode);
        w.SetReversed(this.reversed);
        w.SetGridMode(this.grid_mode, int_label, int_label);
        w.SetGridSteps(this.x_grid_lines, this.y_grid_lines);
    }

    public int GetWaveIndex(Waveform w) {
        int idx;
        for (idx = 0; idx < this.getGridComponentCount() && this.GetWavePanel(idx) != w; ++idx) {
        }
        if (idx < this.getGridComponentCount()) {
            return idx;
        }
        return -1;
    }

    @Override
    public Point getWavePosition(Waveform w) {
        return this.getComponentPosition(w);
    }

    public void RemoveSelection() {
        for (int i = 0; i < this.getGridComponentCount() && copy_waveform != null; ++i) {
            Waveform w = this.GetWavePanel(i);
            if (w == null || !w.IsCopySelected()) continue;
            copy_waveform = null;
            w.SetCopySelected(false);
            break;
        }
    }

    @Override
    public void setShowMeasure(boolean state) {
        if (state) {
            for (int i = 0; i < this.getGridComponentCount(); ++i) {
                Waveform w = this.GetWavePanel(i);
                if (w == null) continue;
                w.show_measure = false;
            }
        }
    }

    @Override
    public void updatePoints(double x, Waveform curr_w) {
        this.UpdatePoints(x, Double.NaN, curr_w);
    }

    public void UpdatePoints(double x, double y, Waveform curr_w) {
        for (int i = 0; i < this.getGridComponentCount(); ++i) {
            Waveform w = this.GetWavePanel(i);
            if (w == null || w == curr_w) continue;
            w.UpdatePoint(x, y);
        }
    }

    public synchronized void appendUpdateWaveforms() {
        for (int i = 0; i < this.getGridComponentCount(); ++i) {
            Waveform w = this.GetWavePanel(i);
            if (w == null) continue;
            w.appendUpdate();
        }
    }

    public synchronized void updateWaveforms() {
        for (int i = 0; i < this.getGridComponentCount(); ++i) {
            Waveform w = this.GetWavePanel(i);
            if (w == null) continue;
            w.Update();
        }
    }

    @Override
    public void autoscaleAll() {
        for (int i = 0; i < this.getGridComponentCount(); ++i) {
            Waveform w = this.GetWavePanel(i);
            if (w == null) continue;
            w.Autoscale();
        }
    }

    @Override
    public void autoscaleAllImages() {
        for (int i = 0; i < this.getGridComponentCount(); ++i) {
            Waveform w = this.GetWavePanel(i);
            if (w == null || !w.IsImage()) continue;
            w.Autoscale();
        }
    }

    @Override
    public void autoscaleAllY() {
        for (int i = 0; i < this.getGridComponentCount(); ++i) {
            Waveform w = this.GetWavePanel(i);
            if (w == null) continue;
            w.AutoscaleY();
        }
    }

    @Override
    public void allSameScale(Waveform curr_w) {
        for (int i = 0; i < this.getGridComponentCount(); ++i) {
            Waveform w = this.GetWavePanel(i);
            if (w == null || w == curr_w) continue;
            w.SetScale(curr_w);
        }
    }

    @Override
    public void allSameXScaleAutoY(Waveform curr_w) {
        for (int i = 0; i < this.getGridComponentCount(); ++i) {
            Waveform w = this.GetWavePanel(i);
            if (w == null) continue;
            w.SetXScaleAutoY(curr_w);
        }
    }

    @Override
    public void allSameYScale(Waveform curr_w) {
        for (int i = 0; i < this.getGridComponentCount(); ++i) {
            Waveform w = this.GetWavePanel(i);
            if (w == null || w == curr_w) continue;
            w.SetYScale(curr_w);
        }
    }

    @Override
    public void allSameXScale(Waveform curr_w) {
        for (int i = 0; i < this.getGridComponentCount(); ++i) {
            Waveform w = this.GetWavePanel(i);
            if (w == null || w == curr_w) continue;
            w.SetXScale(curr_w);
        }
    }

    @Override
    public void resetAllScales() {
        for (int i = 0; i < this.getGridComponentCount(); ++i) {
            Waveform w = this.GetWavePanel(i);
            if (w == null) continue;
            w.ResetScales();
        }
    }

    @Override
    public void notifyChange(Waveform dest, Waveform source) {
        dest.Copy(source);
    }

    @Override
    public void removePanel(Waveform w) {
        if (w == this.sel_wave) {
            this.sel_wave = null;
        }
        if (w.IsCopySelected()) {
            copy_waveform = null;
            w.SetCopySelected(false);
        }
        super.removeComponent(w);
    }

    public int GetMode() {
        return this.mode;
    }

    @Override
    public int getWaveformCount() {
        return this.getGridComponentCount();
    }

    public void SetFont(Font font) {
        Waveform.SetFont(font);
    }

    public void setLegendMode(int legend_mode) {
        for (int i = 0; i < this.getGridComponentCount(); ++i) {
            Waveform w = this.GetWavePanel(i);
            if (w == null || !(w instanceof MultiWaveform)) continue;
            ((MultiWaveform)w).setLegendMode(legend_mode);
        }
    }

    public void setPrintWithLegend(boolean print_with_legend) {
        this.print_with_legend = print_with_legend;
    }

    public void setPrintBW(boolean print_bw) {
        this.print_bw = print_bw;
    }

    public void SetColors(Color[] colors, String[] colors_name) {
        int k = 0;
        for (int i = 0; i < this.rows.length; ++i) {
            int j = 0;
            while (j < this.rows[i]) {
                Waveform w = this.GetWavePanel(k);
                if (w != null) {
                    Waveform.SetColors(colors, colors_name);
                }
                ++j;
                ++k;
            }
        }
    }

    public void SetParams(int mode, int grid_mode, int legend_mode, int x_grid_lines, int y_grid_lines, boolean reversed) {
        this.SetReversed(reversed);
        this.SetMode(mode);
        this.SetGridMode(grid_mode);
        this.SetGridStep(x_grid_lines, y_grid_lines);
        this.setLegendMode(legend_mode);
    }

    public void SetReversed(boolean reversed) {
        this.reversed = reversed;
        for (int i = 0; i < this.getGridComponentCount(); ++i) {
            Waveform w = this.GetWavePanel(i);
            if (w == null) continue;
            w.SetReversed(reversed);
        }
    }

    public void stopPlaying() {
        for (int i = 0; i < this.getGridComponentCount(); ++i) {
            Waveform w = this.GetWavePanel(i);
            if (w == null) continue;
            w.StopFrame();
        }
    }

    public void SetMode(int mode) {
        this.mode = mode;
        for (int i = 0; i < this.getGridComponentCount(); ++i) {
            Waveform w = this.GetWavePanel(i);
            if (w == null) continue;
            if (copy_waveform == w && w.mode == 4 && mode != 4) {
                this.RemoveSelection();
                copy_waveform = null;
            }
            w.SetMode(mode);
        }
    }

    public void SetGridMode(int grid_mode) {
        this.grid_mode = grid_mode;
        boolean int_label = grid_mode != 2;
        for (int i = 0; i < this.getGridComponentCount(); ++i) {
            Waveform w = this.GetWavePanel(i);
            if (w == null) continue;
            w.SetGridMode(grid_mode, int_label, int_label);
        }
    }

    public void SetGridStep(int x_grid_lines, int y_grid_lines) {
        this.x_grid_lines = x_grid_lines;
        this.y_grid_lines = y_grid_lines;
        for (int i = 0; i < this.getGridComponentCount(); ++i) {
            Waveform w = this.GetWavePanel(i);
            if (w == null) continue;
            w.SetGridSteps(x_grid_lines, y_grid_lines);
        }
    }

    public Waveform GetSelectPanel() {
        Waveform w;
        if (this.sel_wave == null) {
            int i;
            for (i = 0; i < this.getGridComponentCount() && this.GetWavePanel(i) != null && (this.GetWavePanel(i).GetShowSignalCount() != 0 || this.GetWavePanel(i).IsImage()); ++i) {
            }
            if (i == this.getGridComponentCount()) {
                Component[] c = this.CreateWaveComponents(1);
                w = (Waveform)c[0];
            } else {
                w = this.GetWavePanel(i);
            }
        } else {
            return this.sel_wave;
        }
        return w;
    }

    public void ResetDrawPanel(int[] _row) {
        int n_wave = 0;
        int num = 0;
        for (int i = 0; i < _row.length; ++i) {
            n_wave = _row[i] - this.rows[i];
            if (n_wave <= 0) continue;
            num += n_wave;
        }
        Component[] c = null;
        if (num > 0) {
            c = this.CreateWaveComponents(num);
        }
        this.update(_row, c);
        if (this.sel_wave != null) {
            this.sel_wave.SelectWave();
        }
    }

    @Override
    public void deselect() {
        if (this.sel_wave != null) {
            this.sel_wave.DeselectWave();
        }
        this.sel_wave = null;
    }

    @Override
    public void maximizeComponent(Waveform w) {
        super.maximizeComponent(w);
    }

    @Override
    public Component getMaximizeComponent() {
        return super.getMaximizeComponent();
    }

    public boolean isMaximize(Waveform w) {
        return super.isMaximize();
    }

    @Override
    public void select(Waveform w) {
        this.deselect();
        this.sel_wave = w;
        this.sel_wave.SelectWave();
    }

    @Override
    public Waveform gGetSelected() {
        return this.sel_wave;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        int st_x = 0;
        int st_y = 0;
        double height = pf.getImageableHeight();
        double width = pf.getImageableWidth();
        Graphics2D g2 = (Graphics2D)g;
        String ver = System.getProperty("java.version");
        if (pageIndex == 0) {
            if (ver.indexOf("1.2") != -1) {
                if (pf.getOrientation() == 0) {
                    st_y = -13;
                    st_x = 15;
                    width -= 5.0;
                } else {
                    st_y = -5;
                    width -= 25.0;
                    height -= 25.0;
                }
            }
            g2.translate(pf.getImageableX(), pf.getImageableY());
            this.PrintAll(g2, st_x, st_y, (int)height, (int)width);
            return 0;
        }
        return 1;
    }

    @Override
    public void setCopySource(Waveform w) {
        if (w != null) {
            if (w == copy_waveform) {
                w.SetCopySelected(false);
                copy_waveform = null;
                return;
            }
            w.SetCopySelected(true);
        }
        if (copy_waveform != null) {
            copy_waveform.SetCopySelected(false);
        }
        copy_waveform = w;
    }

    @Override
    public Waveform getCopySource() {
        return copy_waveform;
    }

    public void RepaintAllWaves() {
        for (int i = 0; i < this.getGridComponentCount(); ++i) {
            Waveform w = this.GetWavePanel(i);
            if (w == null) continue;
            w.repaint();
        }
    }

    public void RemoveAllSignals() {
        for (int i = 0; i < this.getGridComponentCount(); ++i) {
            Waveform w = this.GetWavePanel(i);
            if (w == null) continue;
            w.Erase();
        }
        System.gc();
    }

    public void LoadFileConfiguration() {
    }

    public void PrintAll(Graphics g, int st_x, int st_y, int height, int width) {
        int k = 0;
        int pix = 1;
        if (this.GetWavePanel((int)0).grid_mode == 2) {
            pix = 0;
        }
        int curr_height = 0;
        int curr_width = 0;
        int px = 0;
        int py = 0;
        int pos = 0;
        k = 0;
        px = st_x;
        for (int i = 0; i < this.rows.length; ++i) {
            if (this.rows[i] == 0) continue;
            g.translate(px, 0);
            curr_width = (int)((double)((float)width * ((RowColumnLayout)this.getLayout()).getPercentWidth(i)) + 0.9);
            if (curr_width == 0) {
                k += this.rows[i];
                continue;
            }
            pos = 0;
            py = st_y;
            for (int j = 0; j < this.rows[i]; ++j) {
                curr_height = (int)((double)((float)height * ((RowColumnLayout)this.getLayout()).getPercentHeight(k)) + 0.9);
                if (curr_height == 0) {
                    ++k;
                    continue;
                }
                g.translate(0, py);
                if (j == this.rows[i] - 1 && pos + curr_height != height) {
                    curr_height = height - pos;
                }
                g.setClip(0, 0, curr_width, curr_height);
                Waveform w = this.GetWavePanel(k);
                if (w != null) {
                    int print_mode = 2;
                    if (this.print_with_legend) {
                        print_mode |= 4;
                    }
                    if (this.print_bw) {
                        print_mode |= 8;
                    }
                    WaveformContainer.disableDoubleBuffering(w);
                    w.paint(g, new Dimension(curr_width, curr_height), print_mode);
                    WaveformContainer.enableDoubleBuffering(w);
                }
                py = curr_height - pix;
                pos += curr_height - pix;
                ++k;
            }
            px = curr_width - pix;
            g.translate(0, -pos - st_y + py);
        }
    }

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }

    private String getFileName(Waveform w) {
        String out;
        Properties prop = new Properties();
        String pr = w.getProperties();
        try {
            prop.load(new StringReader(pr));
            out = w.GetTitle();
            out = out + "_" + prop.getProperty("x_pix");
            out = out + "_" + prop.getProperty("y_pix");
            out = out + "_" + prop.getProperty("time");
            out = out.replace('.', '-') + ".txt";
        }
        catch (Exception e) {
            out = null;
        }
        return out;
    }

    public void SaveAsText(Waveform w, boolean all) {
        String title = "Save";
        if (all) {
            title = "Save all signals in text format";
        } else {
            Point p = this.getWavePosition(w);
            if (p != null) {
                title = "Save signals on panel (" + p.x + ", " + p.y + ") in text format";
            }
        }
        JFileChooser file_diag = new JFileChooser();
        if (this.save_as_txt_directory != null && this.save_as_txt_directory.trim().length() != 0) {
            file_diag.setCurrentDirectory(new File(this.save_as_txt_directory));
        }
        file_diag.setDialogTitle(title);
        int returnVal = 1;
        boolean done = false;
        String txtsig_file = null;
        while (!done) {
            String fname = this.getFileName(w);
            if (fname != null) {
                file_diag.setSelectedFile(new File(fname));
            }
            if ((returnVal = file_diag.showSaveDialog(this)) == 0) {
                File file = file_diag.getSelectedFile();
                txtsig_file = file.getAbsolutePath();
                if (file.exists()) {
                    Object[] options = new Object[]{"Yes", "No"};
                    int val = JOptionPane.showOptionDialog(null, txtsig_file + " already exists.\nDo you want to replace it?", "Save as", 0, 2, null, options, options[1]);
                    if (val != 0) continue;
                    done = true;
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        if (returnVal == 0 && txtsig_file != null) {
            this.save_as_txt_directory = new String(txtsig_file);
            String s1 = "";
            String s2 = "";
            StringBuffer space = new StringBuffer();
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(txtsig_file));
                out.write("% Title: " + w.GetTitle());
                out.newLine();
                Properties prop = new Properties();
                String pr = w.getProperties();
                try {
                    prop.load(new StringReader(pr));
                    out.write("% Expression: " + prop.getProperty("expr"));
                    out.newLine();
                    out.write("% x_pixel: " + prop.getProperty("x_pix"));
                    out.newLine();
                    out.write("% y_pixel: " + prop.getProperty("y_pix"));
                    out.newLine();
                    out.write("% time: " + prop.getProperty("time"));
                    out.newLine();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                double xmax = w.GetWaveformMetrics().XMax();
                double xmin = w.GetWaveformMetrics().XMin();
                s1 = "";
                s2 = "";
                int nPoint = w.waveform_signal.getNumPoints();
                for (int j = 0; j < nPoint; ++j) {
                    int u;
                    double x = w.waveform_signal.getX(j);
                    if (!(x > xmin) || !(x < xmax)) continue;
                    s1 = "" + x;
                    s2 = "" + w.waveform_signal.getY(j);
                    out.write(s1);
                    space.setLength(0);
                    for (u = 0; u < 25 - s1.length(); ++u) {
                        space.append(' ');
                    }
                    space.append(' ');
                    out.write(space.toString());
                    out.write(" ");
                    out.write(s2);
                    space.setLength(0);
                    for (u = 0; u < 25 - s2.length(); ++u) {
                        space.append(' ');
                    }
                    out.write(space.toString());
                    out.newLine();
                }
                out.close();
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
    }
}

