/*
 * Decompiled with CFR 0.152.
 */
package mds.wave;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.io.Serializable;
import java.util.Vector;
import mds.wave.ColorMap;
import mds.wave.Signal;

public class WaveformMetrics
implements Serializable {
    static double MAX_VALUE = 10000.0;
    static double MIN_VALUE = -10000.0;
    static int INT_MAX_VALUE = (int)MAX_VALUE;
    static int INT_MIN_VALUE = (int)MIN_VALUE;
    double xmax;
    double xmin;
    double ymax;
    double ymin;
    double xrange;
    double yrange;
    double y_range;
    boolean x_log;
    boolean y_log;
    double x_offset;
    double x_range;
    int start_x;
    double FACT_X;
    double FACT_Y;
    double OFS_X;
    double OFS_Y;
    int horizontal_offset;
    int vertical_offset;
    static final double LOG10 = 2.302585092994;
    static final double MIN_LOG = 1.0E-99;

    public WaveformMetrics(double _xmax, double _xmin, double _ymax, double _ymin, Rectangle limits, Dimension d, boolean _x_log, boolean _y_log, int horizontal_offset, int vertical_offset) {
        int ylabel_width = limits.width;
        int xlabel_height = limits.height;
        this.horizontal_offset = horizontal_offset;
        this.vertical_offset = vertical_offset;
        if (_ymin > _ymax) {
            _ymin = _ymax;
        }
        if (_xmin > _xmax) {
            _xmin = _xmax;
        }
        this.start_x = ylabel_width;
        this.x_log = _x_log;
        this.y_log = _y_log;
        int border_y = xlabel_height;
        this.y_range = (double)(d.height - border_y - 2 * vertical_offset) / (double)d.height;
        this.x_range = (double)(d.width - this.start_x - 2 * horizontal_offset) / (double)d.width;
        this.x_offset = (double)this.start_x / (double)d.width;
        if (this.x_log) {
            if (_xmax < 1.0E-99) {
                _xmax = 1.0E-99;
            }
            if (_xmin < 1.0E-99) {
                _xmin = 1.0E-99;
            }
            this.xmax = Math.log(_xmax) / 2.302585092994;
            this.xmin = Math.log(_xmin) / 2.302585092994;
        } else {
            this.xmax = _xmax;
            this.xmin = _xmin;
        }
        double delta_x = this.xmax - this.xmin;
        this.xmax += delta_x / 100.0;
        this.xmin -= delta_x / 100.0;
        if (this.y_log) {
            if (_ymax < 1.0E-99) {
                _ymax = 1.0E-99;
            }
            if (_ymin < 1.0E-99) {
                _ymin = 1.0E-99;
            }
            this.ymax = Math.log(_ymax) / 2.302585092994;
            this.ymin = Math.log(_ymin) / 2.302585092994;
        } else {
            this.ymax = _ymax;
            this.ymin = _ymin;
        }
        double delta_y = this.ymax - this.ymin;
        this.ymax += delta_y / 50.0;
        this.ymin -= delta_y / 50.0;
        this.xrange = this.xmax - this.xmin;
        this.yrange = this.ymax - this.ymin;
        if (this.xrange <= 0.0) {
            this.xrange = 1.0E-10;
            this.x_offset = 0.5;
        }
        if (this.yrange <= 0.0) {
            this.yrange = 1.0E-10;
        }
    }

    public final double XMax() {
        return this.xmax;
    }

    public final double YMax() {
        return this.ymax;
    }

    public final double XMin() {
        return this.xmin;
    }

    public final double YMin() {
        return this.ymin;
    }

    public final double XRange() {
        return this.xmax - this.xmin;
    }

    public final double YRange() {
        return this.ymax - this.ymin;
    }

    public final boolean XLog() {
        return this.x_log;
    }

    public final boolean YLog() {
        return this.y_log;
    }

    public final void ComputeFactors(Dimension d) {
        this.OFS_X = this.x_offset * (double)d.width - this.xmin * this.x_range * (double)d.width / this.xrange + (double)this.horizontal_offset + 0.5;
        this.FACT_X = this.x_range * (double)d.width / this.xrange;
        this.OFS_Y = this.y_range * this.ymax * (double)d.height / this.yrange + (double)this.vertical_offset + 0.5;
        this.FACT_Y = -this.y_range * (double)d.height / this.yrange;
    }

    public final int XPixel(double x) {
        double xpix = x * this.FACT_X + this.OFS_X;
        if (xpix >= MAX_VALUE) {
            return INT_MAX_VALUE;
        }
        if (xpix <= MIN_VALUE) {
            return INT_MIN_VALUE;
        }
        return (int)xpix;
    }

    public final int YPixel(double y) {
        double ypix;
        if (this.y_log) {
            if (y < 1.0E-99) {
                y = 1.0E-99;
            }
            y = Math.log(y) / 2.302585092994;
        }
        if ((ypix = y * this.FACT_Y + this.OFS_Y) >= MAX_VALUE) {
            return INT_MAX_VALUE;
        }
        if (ypix <= MIN_VALUE) {
            return INT_MIN_VALUE;
        }
        return (int)ypix;
    }

    public final int XPixel(double x, Dimension d) {
        double ris;
        if (this.x_log) {
            if (x < 1.0E-99) {
                x = 1.0E-99;
            }
            x = Math.log(x) / 2.302585092994;
        }
        if ((ris = (this.x_offset + this.x_range * (x - this.xmin) / this.xrange) * (double)d.width + 0.5) > 20000.0) {
            ris = 20000.0;
        }
        if (ris < -20000.0) {
            ris = -20000.0;
        }
        return (int)ris;
    }

    public final int YPixel(double y, Dimension d) {
        double ris;
        if (this.y_log) {
            if (y < 1.0E-99) {
                y = 1.0E-99;
            }
            y = Math.log(y) / 2.302585092994;
        }
        if ((ris = this.y_range * (this.ymax - y) / this.yrange * (double)d.height + 0.5) > 20000.0) {
            ris = 20000.0;
        }
        if (ris < -20000.0) {
            ris = -20000.0;
        }
        return (int)ris;
    }

    public final double XValue(int x, Dimension d) {
        double ris = (((double)x - 0.5) / (double)d.width - this.x_offset) * this.xrange / this.x_range + this.xmin;
        if (this.x_log) {
            return Math.exp(2.302585092994 * ris);
        }
        return ris;
    }

    public final double YValue(int y, Dimension d) {
        double ris = this.ymax - ((double)y - 0.5) / (double)d.height * this.yrange / this.y_range;
        if (this.y_log) {
            return Math.exp(2.302585092994 * ris);
        }
        return ris;
    }

    private void drawRectagle(Graphics g, IndexColorModel cm, int x, int y, int w, int h, int cIdx) {
        g.setColor(new Color(cm.getRed(cIdx), cm.getGreen(cIdx), cm.getBlue(cIdx), cm.getAlpha(cIdx)));
        g.fillRect(x, y, w, h);
    }

    public void ToImage(Signal s, Image img, Dimension d, ColorMap colorMap) {
        int i;
        float z2D_max;
        Graphics2D g2 = (Graphics2D)img.getGraphics();
        IndexColorModel cm = colorMap.getIndexColorModel(8);
        this.ComputeFactors(d);
        g2.setColor(Color.white);
        g2.fillRect(0, 0, d.width - 1, d.height - 1);
        double[] x2D = s.getX2D();
        float[] y2D = s.getY2D();
        float[] z2D = s.getZ();
        float z2D_min = z2D_max = z2D[0];
        for (int idx = 0; idx < z2D.length; ++idx) {
            if (z2D[idx] < z2D_min) {
                z2D_min = z2D[idx];
            }
            if (!(z2D[idx] > z2D_max)) continue;
            z2D_max = z2D[idx];
        }
        for (i = 0; i < x2D.length && x2D[i] < this.xmin; ++i) {
        }
        int xSt = i;
        for (i = 0; i < x2D.length && x2D[i] < this.xmax; ++i) {
        }
        int xEt = i;
        for (i = 0; i < y2D.length && (double)y2D[i] < this.ymin; ++i) {
        }
        int ySt = i;
        for (i = 0; i < y2D.length && (double)y2D[i] < this.ymax; ++i) {
        }
        int yEt = i;
        if (yEt == 0) {
            return;
        }
        int p = 0;
        int h = 0;
        int w = 0;
        try {
            int x;
            int y;
            int yPix1 = (this.YPixel(y2D[ySt + 1]) + this.YPixel(y2D[ySt])) / 2;
            yPix1 = 2 * this.YPixel(y2D[ySt]) - yPix1;
            float currMax = z2D_min;
            float currMin = z2D_max;
            for (y = ySt; y < yEt; ++y) {
                p = y * x2D.length + xSt;
                for (x = xSt; x < xEt && p < z2D.length; ++p, ++x) {
                    if (z2D[p] > currMax) {
                        currMax = z2D[p];
                    }
                    if (!(z2D[p] < currMin)) continue;
                    currMin = z2D[p];
                }
            }
            for (y = ySt; y < yEt; ++y) {
                int yPix0 = yPix1;
                try {
                    yPix1 = (this.YPixel(y2D[y + 1]) + this.YPixel(y2D[y])) / 2;
                    h = Math.abs(yPix0 - yPix1) + 2;
                }
                catch (Exception e) {
                    yPix1 = 2 * this.YPixel(y2D[yEt - 1]) - yPix1;
                    h = Math.abs(yPix0 - yPix1) + 2;
                }
                p = y * x2D.length + xSt;
                int xPix1 = (this.XPixel(x2D[xSt]) + this.XPixel(x2D[xSt + 1])) / 2;
                xPix1 = 2 * this.XPixel(x2D[xSt]) - xPix1;
                for (x = xSt; x < xEt && p < z2D.length; ++x) {
                    int xPix0 = xPix1;
                    try {
                        xPix1 = (this.XPixel(x2D[x + 1]) + this.XPixel(x2D[x])) / 2;
                        w = Math.abs(xPix1 - xPix0);
                    }
                    catch (Exception e) {
                        w = 2 * (this.XPixel(x2D[xEt - 1]) - xPix1);
                    }
                    int pix = (int)(255.0f * (z2D[p++] - currMin) / (currMax - currMin));
                    pix = pix > 255 ? 255 : pix;
                    pix = pix < 0 ? 0 : pix;
                    this.drawRectagle(g2, cm, xPix0, yPix1, w, h, pix);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Vector<Polygon> ToPolygonsDoubleX(Signal sig, Dimension d) {
        double max_y;
        Vector<Polygon> curr_vect = new Vector<Polygon>(5);
        Polygon curr_polygon = null;
        int pol_idx = 0;
        double min_y = max_y = (double)sig.getY(0);
        int[] xpoints = new int[sig.getNumPoints()];
        int[] ypoints = new int[sig.getNumPoints()];
        int curr_num_points = 0;
        int j = 0;
        int i = 0;
        int end_point = sig.getNumPoints();
        this.ComputeFactors(d);
        try {
            double[] x = sig.getX();
            float[] y = sig.getY();
            for (i = 0; i < x.length && x[i] < this.xmin; ++i) {
            }
            if (i > 0) {
                --i;
            }
            min_y = max_y = (double)y[i];
            j = i + 1;
            int start_x = this.XPixel(x[i]);
            while (j < end_point) {
                double last_y;
                double first_y = last_y = (double)y[i];
                for (j = i + 1; j < x.length && (pol_idx >= sig.getNumNaNs() || j != sig.getNaNs()[pol_idx]) && this.XPixel(x[j]) == start_x; ++j) {
                    double curr_y;
                    last_y = curr_y = (double)y[j];
                    if (curr_y < min_y) {
                        min_y = curr_y;
                    }
                    if (!(curr_y > max_y)) continue;
                    max_y = curr_y;
                }
                if (max_y > min_y) {
                    if (first_y == min_y) {
                        xpoints[curr_num_points] = start_x;
                        ypoints[curr_num_points] = this.YPixel(first_y);
                        ++curr_num_points;
                        if (last_y == max_y) {
                            xpoints[curr_num_points] = start_x;
                            ypoints[curr_num_points] = this.YPixel(last_y);
                            ++curr_num_points;
                        } else {
                            xpoints[curr_num_points] = start_x;
                            ypoints[curr_num_points] = this.YPixel(max_y);
                            xpoints[++curr_num_points] = start_x;
                            ypoints[curr_num_points] = this.YPixel(last_y);
                            ++curr_num_points;
                        }
                    } else if (first_y == max_y) {
                        xpoints[curr_num_points] = start_x;
                        ypoints[curr_num_points] = this.YPixel(first_y);
                        ++curr_num_points;
                        if (last_y == min_y) {
                            xpoints[curr_num_points] = start_x;
                            ypoints[curr_num_points] = this.YPixel(last_y);
                            ++curr_num_points;
                        } else {
                            xpoints[curr_num_points] = start_x;
                            ypoints[curr_num_points] = this.YPixel(min_y);
                            xpoints[++curr_num_points] = start_x;
                            ypoints[curr_num_points] = this.YPixel(last_y);
                            ++curr_num_points;
                        }
                    } else {
                        xpoints[curr_num_points] = start_x;
                        ypoints[curr_num_points] = this.YPixel(first_y);
                        ++curr_num_points;
                        if (last_y == min_y) {
                            xpoints[curr_num_points] = start_x;
                            ypoints[curr_num_points] = this.YPixel(max_y);
                            xpoints[++curr_num_points] = start_x;
                            ypoints[curr_num_points] = this.YPixel(last_y);
                            ++curr_num_points;
                        } else if (last_y == max_y) {
                            xpoints[curr_num_points] = start_x;
                            ypoints[curr_num_points] = this.YPixel(min_y);
                            xpoints[++curr_num_points] = start_x;
                            ypoints[curr_num_points] = this.YPixel(last_y);
                            ++curr_num_points;
                        } else {
                            xpoints[curr_num_points] = start_x;
                            ypoints[curr_num_points] = this.YPixel(min_y);
                            xpoints[++curr_num_points] = start_x;
                            ypoints[curr_num_points] = this.YPixel(max_y);
                            xpoints[++curr_num_points] = start_x;
                            ypoints[curr_num_points] = this.YPixel(last_y);
                            ++curr_num_points;
                        }
                    }
                } else {
                    xpoints[curr_num_points] = start_x;
                    ypoints[curr_num_points] = this.YPixel(max_y);
                    ++curr_num_points;
                }
                if (j == x.length || j >= end_point || Double.isNaN(y[j])) {
                    curr_polygon = new Polygon(xpoints, ypoints, curr_num_points);
                    curr_vect.addElement(curr_polygon);
                    ++pol_idx;
                    curr_num_points = 0;
                    if (j < x.length) {
                        while (j < x.length && Double.isNaN(y[j])) {
                            ++j;
                        }
                    }
                }
                if (j >= end_point) continue;
                start_x = this.XPixel(x[j]);
                max_y = min_y = (double)y[j];
                i = j;
                if (!sig.isIncreasingX() || !(x[j] > this.xmax)) continue;
                end_point = j + 1;
            }
        }
        catch (Exception x) {
            // empty catch block
        }
        if (sig.getMode1D() == 3) {
            Vector<Polygon> v = new Vector<Polygon>();
            for (i = 0; i < curr_vect.size(); ++i) {
                curr_polygon = curr_vect.elementAt(i);
                int np = curr_polygon.npoints * 2 - 1;
                int[] x = new int[np];
                int[] y = new int[np];
                i = 0;
                j = 0;
                while (i < curr_polygon.npoints) {
                    x[j] = curr_polygon.xpoints[i];
                    y[j] = curr_polygon.ypoints[i];
                    if (++j == np) break;
                    x[j] = curr_polygon.xpoints[i + 1];
                    y[j] = curr_polygon.ypoints[i];
                    ++i;
                    ++j;
                }
                curr_polygon = new Polygon(x, y, np);
                v.addElement(curr_polygon);
            }
            curr_vect = v;
        }
        return curr_vect;
    }

    public Vector<Polygon> ToPolygons(Signal sig, Dimension d) {
        return this.ToPolygons(sig, d, false);
    }

    public Vector<Polygon> ToPolygons(Signal sig, Dimension d, boolean appendMode) {
        try {
            return this.ToPolygonsDoubleX(sig, d);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }
}

