/*
		A basic implementation of the DeviceSetup class.
*/


import java.awt.*;
import javax.swing.*;

public class ACQD240Setup extends DeviceSetup
{
	private static final long serialVersionUID = 1L;
	public ACQD240Setup(JFrame parent)
	{
	  super(parent);
	  initComponents();
	}

	private void initComponents() {

		// This code is automatically generated by Visual Cafe when you add
		// components to the visual environment. It instantiates and initializes
		// the components. To modify the code, only use code syntax that matches
		// what Visual Cafe can generate, or Visual Cafe may be unable to back
		// parse your Java file into its visual environment.
		//{{INIT_CONTROLS
		setDeviceTitle("Acqiris Digitizer Model DC240");
		setDeviceType("ACQD240");
		getContentPane().setLayout(null);
		setSize(600,592);
		name_label.setText("Name:");
		getContentPane().add(name_label);
		name_label.setBounds(10,42,42,24);
		name.setNumCols(15);
		name.setIdentifier("dev_name");
		name.setTextOnly(true);
		name.setOffsetNid(1);
		getContentPane().add(name);
		name.setBounds(40,35,361,29);
		comment_label.setText("Comment:");
		getContentPane().add(comment_label);
		comment_label.setBounds(10,7,65,27);
		comment.setNumCols(35);
		comment.setTextOnly(true);
		comment.setOffsetNid(2);
		getContentPane().add(comment);
		comment.setBounds(40,7,480,28);
		JPanel2.setLayout(null);
		getContentPane().add(JPanel2);
		JPanel2.setBounds(11,105,527,96);
		deviceChoice1.setOffsetNid(13);
		{
			String[] tempString = new String[2];
			tempString[0] = "INTERNAL";
			tempString[1] = "EXTERNAL";
			deviceChoice1.setChoiceItems(tempString);
		}
		deviceChoice1.setLabelString("Trig. Mode: ");
		JPanel2.add(deviceChoice1);
		deviceChoice1.setBounds(2,1,177,34);
		deviceField3.setNumCols(5);
		deviceField3.setOffsetNid(14);
		JPanel2.add(deviceField3);
		deviceField3.setBounds(79,35,87,28);
		JLabel3.setText("Trig. Source:");
		JLabel3.setToolTipText("Time value of the first trigger pule.");
		JPanel2.add(JLabel3);
		JLabel3.setBounds(9,35,110,28);
		JLabel4.setText("Trig. Delay:");
		JPanel2.add(JLabel4);
		JLabel4.setBounds(9,64,89,28);
		deviceField4.setNumCols(5);
		deviceField4.setOffsetNid(15);
		JPanel2.add(deviceField4);
		deviceField4.setBounds(79,64,87,28);
		JLabel5.setText("Trig. Level:");
		JLabel5.setToolTipText("In % of the vertical Full Scale of the channel, or in mV if using external trig source");
		JPanel2.add(JLabel5);
		JLabel5.setBounds(172,35,69,28);
		deviceField5.setNumCols(5);
		deviceField5.setOffsetNid(19);
		JPanel2.add(deviceField5);
		deviceField5.setBounds(245,35,87,28);
		JLabel6.setText("Trig. Channel:");
		JLabel6.setToolTipText("Positive number: channel trigger number (Internal trigger), board number (External trigger)");
		JPanel2.add(JLabel6);
		JLabel6.setBounds(172,64,96,28);
		deviceField6.setNumCols(5);
		deviceField6.setOffsetNid(16);
		JPanel2.add(deviceField6);
		deviceField6.setBounds(245,64,92,28);
		deviceChoice2.setOffsetNid(17);
		{
			String[] tempString = new String[4];
			tempString[0] = "DC";
			tempString[1] = "AC";
			tempString[2] = "DC 50ohm";
			tempString[3] = "AC 50ohm";
			deviceChoice2.setChoiceItems(tempString);
		}
		deviceChoice2.setLabelString("Trig. Coupling:");
		JPanel2.add(deviceChoice2);
		deviceChoice2.setBounds(177,1,205,34);
		deviceChoice3.setOffsetNid(18);
		{
			String[] tempString = new String[2];
			tempString[0] = "POS";
			tempString[1] = "NEG";
			deviceChoice3.setChoiceItems(tempString);
		}
		deviceChoice3.setLabelString("Trig. Slope:");
		JPanel2.add(deviceChoice3);
		deviceChoice3.setBounds(375,1,142,34);
		JLabel2.setText("Segment Number:");
		JPanel2.add(JLabel2);
		JLabel2.setBounds(336,64,110,28);
		JLabel1.setText("Segment Points:");
		JPanel2.add(JLabel1);
		JLabel1.setBounds(337,35,99,28);
		deviceField1.setNumCols(5);
		deviceField1.setIdentifier("seg_points");
		deviceField1.setOffsetNid(10);
		JPanel2.add(deviceField1);
		deviceField1.setBounds(433,35,92,28);
		deviceField2.setNumCols(5);
		deviceField2.setIdentifier("seg_num");
		deviceField2.setOffsetNid(11);
		JPanel2.add(deviceField2);
		deviceField2.setBounds(432,64,87,28);
		deviceTable1.setNumCols(1);
		{
			String[] tempString = new String[1];
			tempString[0] = "Serial_Number";
			deviceTable1.setColumnNames(tempString);
		}
		deviceTable1.setNumRows(7);
		deviceTable1.setOffsetNid(3);
		getContentPane().add(deviceTable1);
		deviceTable1.setBounds(19,200,121,142);
		{
			String[] tempString = new String[4];
			tempString[0] = "Device name must be defined";
			tempString[1] = "Segment number must be  > 0";
			tempString[2] = "Segment points must be > 0";
			tempString[3] = "Acquired samples must be <= 128k";
			deviceButtons1.setCheckMessages(tempString);
		}
		{
			String[] tempString = new String[4];
			tempString[0] = "len(_dev_name)>0";
			tempString[1] = "_seg_num > 0";
			tempString[2] = "_seg_points > 0";
			tempString[3] = "_seg_num * _seg_points < 128000";
			deviceButtons1.setCheckExpressions(tempString);
		}
		{
			String[] tempString = new String[8];
			tempString[0] = "calibrate";
			tempString[1] = "pre_init";
			tempString[2] = "init";
			tempString[3] = "config";
			tempString[4] = "start";
			tempString[5] = "trigger";
			tempString[6] = "stop";
			tempString[7] = "store";
			deviceButtons1.setMethods(tempString);
		}
		getContentPane().add(deviceButtons1);
		deviceButtons1.setBounds(132,553,312,40);
		getContentPane().add(deviceDispatch1);
		deviceDispatch1.setBounds(404,33,136,33);
		deviceChoice4.setOffsetNid(5);
		{
			String[] tempString = new String[3];
			tempString[0] = "INTERNAL";
			tempString[1] = "EXTERNAL";
			tempString[2] = "EXT Ref 10MHz";
			deviceChoice4.setChoiceItems(tempString);
		}
		deviceChoice4.setLabelString("Ck. Mode:");
		getContentPane().add(deviceChoice4);
		deviceChoice4.setBounds(7,70,205,30);
		deviceChoice5.setChoiceFloatValues(new float[] {
	            (float)1.0E2,(float)2.0E2,(float)2.5E2,(float)4.0E2,(float)5.0E2,
	            (float)1.0E3,(float)2.0E3,(float)2.5E3,(float)4.0E3,(float)5.0E3,
	            (float)1.0E4,(float)2.0E4,(float)2.5E4,(float)4.0E4,(float)5.0E4,
	            (float)1.0E5,(float)2.0E5,(float)2.5E5,(float)4.0E5,(float)5.0E5,
	            (float)1.0E6,(float)2.0E6,(float)2.5E6,(float)4.0E6,(float)5.0E6,
	            (float)1.0E7,(float)2.0E7,(float)2.5E7,(float)4.0E7,(float)5.0E7,
	            (float)1.0E8,(float)2.0E8,(float)2.5E8,(float)4.0E8,(float)5.0E8,
	            (float)1.0E9,(float)2.0E9});
		deviceChoice5.setOffsetNid(8);
		{
			String[] tempString = new String[37];
			tempString[0] = "100";
			tempString[1] = "200";
			tempString[2] = "250";
			tempString[3] = "400";
			tempString[4] = "500";
			tempString[5] = "1000";
			tempString[6] = "2000";
			tempString[7] = "2500";
			tempString[8] = "4000";
			tempString[9] = "5000";
			tempString[10] = "10E3";
			tempString[11] = "20E3";
			tempString[12] = "25E3";
			tempString[13] = "40E3";
			tempString[14] = "50E3";
			tempString[15] = "100E3";
			tempString[16] = "200E3";
			tempString[17] = "250E3";
			tempString[18] = "400E3";
			tempString[19] = "500E3";
			tempString[20] = "1E6";
			tempString[21] = "2E6";
			tempString[22] = "2.5E6";
			tempString[23] = "4E6";
			tempString[24] = "5E6";
			tempString[25] = "10E6";
			tempString[26] = "20E6";
			tempString[27] = "25E5";
			tempString[28] = "40E6";
			tempString[29] = "50E6";
			tempString[30] = "100E6";
			tempString[31] = "200E6";
			tempString[32] = "250E6";
			tempString[33] = "400E6";
			tempString[34] = "500E6";
	                tempString[35] = "1E9";
	                tempString[36] = "2E9";
			deviceChoice5.setChoiceItems(tempString);
		}
		deviceChoice5.setLabelString("Freq. :");
		getContentPane().add(deviceChoice5);
		deviceChoice5.setBounds(208,70,116,30);
		JLabel7.setText("Ck. Source:");
		JLabel7.setToolTipText("External clock source reference (External clock source not implemented)");
		getContentPane().add(JLabel7);
		JLabel7.setBounds(351,72,72,30);
		deviceField7.setOffsetNid(6);
	        deviceField7.setNumCols(6);
		getContentPane().add(deviceField7);
		deviceField7.setBounds(413,72,120,30);
		JLabel8.setText("Hz");
		getContentPane().add(JLabel8);
		JLabel8.setBounds(324,72,23,30);
		getContentPane().add(JTabbedPane1);
		JTabbedPane1.setBounds(8,357,549,188);
		JPanel9.setAlignmentX(0.498925F);
		JPanel9.setLayout(null);
		JTabbedPane1.add(JPanel9);
		JPanel9.setBackground(new java.awt.Color(204,204,204));
		JPanel9.setBounds(2,24,524,161);
		JPanel9.setVisible(false);
		JPanel10.setAlignmentY(0.0F);
		JPanel10.setLayout(new BoxLayout(JPanel10,BoxLayout.X_AXIS));
		JPanel9.add(JPanel10);
		JPanel10.setBounds(22,0,490,15);
		JLabel16.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
		JLabel16.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
		JLabel16.setText("                      Full Scale  (V)              Offset  (V)                     Coupling                     Bandwidth");
		JPanel10.add(JLabel16);
		deviceChannel13.setInSameLine(true);
		deviceChannel13.setOffsetNid(20);
		deviceChannel13.setLabelString("Ch01");
		deviceChannel13.setLayout(new BorderLayout(0,0));
		JPanel9.add(deviceChannel13);
		deviceChannel13.setBounds(6,15,524,44);
		deviceChoice62.setChoiceFloatValues(new float[] {(float)0.05,(float)0.1,(float)0.2,(float)0.5,(float)1.0,(float)2.0,(float)5.0});
		deviceChoice62.setOffsetNid(21);
		{
			String[] tempString = new String[7];
			tempString[0] = "50e-3";
			tempString[1] = "100e-3";
			tempString[2] = "200e-3";
			tempString[3] = "500e-3";
			tempString[4] = "1";
			tempString[5] = "2";
			tempString[6] = "5 ";
			deviceChoice62.setChoiceItems(tempString);
		}
		deviceChoice62.setLabelString(" ");
		deviceChannel13.add(deviceChoice62);
		deviceField33.setNumCols(8);
		deviceField33.setOffsetNid(22);
		deviceChannel13.add(deviceField33);
		deviceChoice30.setOffsetNid(23);
		{
			String[] tempString = new String[4];
			tempString[0] = "DC 1M";
			tempString[1] = "AC 1M";
			tempString[2] = "DC 50ohm";
			tempString[3] = "AC 50ohm";
			deviceChoice30.setChoiceItems(tempString);
		}
		deviceChoice30.setLabelString(" ");
		deviceChannel13.add(deviceChoice30);
		deviceChoice31.setOffsetNid(24);
		{
			String[] tempString = new String[2];
			tempString[0] = "LIMIT ON";
			tempString[1] = "LIMIT OFF";
			deviceChoice31.setChoiceItems(tempString);
		}
		deviceChoice31.setLabelString(" ");
		deviceChannel13.add(deviceChoice31);
		deviceChannel14.setInSameLine(true);
		deviceChannel14.setOffsetNid(26);
		deviceChannel14.setLabelString("Ch02");
		deviceChannel14.setLayout(new BorderLayout(0,0));
		JPanel9.add(deviceChannel14);
		deviceChannel14.setBounds(6,49,524,44);
		deviceChoice63.setChoiceFloatValues(new float[] {(float)0.05,(float)0.1,(float)0.2,(float)0.5,(float)1.0,(float)2.0,(float)5.0});
		deviceChoice63.setOffsetNid(27);
		{
			String[] tempString = new String[7];
			tempString[0] = "50e-3";
			tempString[1] = "100e-3";
			tempString[2] = "200e-3";
			tempString[3] = "500e-3";
			tempString[4] = "1";
			tempString[5] = "2";
			tempString[6] = "5 ";
			deviceChoice63.setChoiceItems(tempString);
		}
		deviceChoice63.setLabelString(" ");
		deviceChannel14.add(deviceChoice63);
		deviceField35.setNumCols(8);
		deviceField35.setOffsetNid(28);
		deviceChannel14.add(deviceField35);
		deviceChoice32.setOffsetNid(29);
		{
			String[] tempString = new String[4];
			tempString[0] = "DC 1M";
			tempString[1] = "AC 1M";
			tempString[2] = "DC 50ohm";
			tempString[3] = "AC 50ohm";
			deviceChoice32.setChoiceItems(tempString);
		}
		deviceChoice32.setLabelString(" ");
		deviceChannel14.add(deviceChoice32);
		deviceChoice33.setOffsetNid(24);
		{
			String[] tempString = new String[2];
			tempString[0] = "LIMIT ON";
			tempString[1] = "LIMIT OFF";
			deviceChoice33.setChoiceItems(tempString);
		}
		deviceChoice33.setLabelString(" ");
		deviceChannel14.add(deviceChoice33);
		JPanel3.setAlignmentX(0.498925F);
		JPanel3.setLayout(null);
		JTabbedPane1.add(JPanel3);
		JPanel3.setBackground(new java.awt.Color(204,204,204));
		JPanel3.setBounds(2,24,524,161);
		JPanel3.setVisible(false);
		JPanel4.setAlignmentY(0.0F);
		JPanel4.setLayout(new BoxLayout(JPanel4,BoxLayout.X_AXIS));
		JPanel3.add(JPanel4);
		JPanel4.setBounds(22,0,465,15);
		JLabel9.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
		JLabel9.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
		JLabel9.setText("                      Full Scale  (V)              Offset  (V)                     Coupling                     Bandwidth");
		JPanel4.add(JLabel9);
		deviceChannel15.setInSameLine(true);
		deviceChannel15.setOffsetNid(32);
		deviceChannel15.setLabelString("Ch03");
		deviceChannel15.setLayout(new BorderLayout(0,0));
		JPanel3.add(deviceChannel15);
		deviceChannel15.setBounds(6,15,524,44);
		deviceChoice64.setChoiceFloatValues(new float[] {(float)0.05,(float)0.1,(float)0.2,(float)0.5,(float)1.0,(float)2.0,(float)5.0});
		deviceChoice64.setOffsetNid(33);
		{
			String[] tempString = new String[7];
			tempString[0] = "50e-3";
			tempString[1] = "100e-3";
			tempString[2] = "200e-3";
			tempString[3] = "500e-3";
			tempString[4] = "1";
			tempString[5] = "2";
			tempString[6] = "5 ";
			deviceChoice64.setChoiceItems(tempString);
		}
		deviceChoice64.setLabelString(" ");
		deviceChannel15.add(deviceChoice64);
		deviceField37.setNumCols(8);
		deviceField37.setOffsetNid(34);
		deviceChannel15.add(deviceField37);
		deviceChoice34.setOffsetNid(35);
		{
			String[] tempString = new String[4];
			tempString[0] = "DC 1M";
			tempString[1] = "AC 1M";
			tempString[2] = "DC 50ohm";
			tempString[3] = "AC 50ohm";
			deviceChoice34.setChoiceItems(tempString);
		}
		deviceChoice34.setLabelString(" ");
		deviceChannel15.add(deviceChoice34);
		deviceChoice35.setOffsetNid(36);
		{
			String[] tempString = new String[2];
			tempString[0] = "LIMIT ON";
			tempString[1] = "LIMIT OFF";
			deviceChoice35.setChoiceItems(tempString);
		}
		deviceChoice35.setLabelString(" ");
		deviceChannel15.add(deviceChoice35);
		deviceChannel16.setInSameLine(true);
		deviceChannel16.setOffsetNid(38);
		deviceChannel16.setLabelString("Ch04");
		deviceChannel16.setLayout(new BorderLayout(0,0));
		JPanel3.add(deviceChannel16);
		deviceChannel16.setBounds(6,49,524,44);
		deviceChoice65.setChoiceFloatValues(new float[] {(float)0.05,(float)0.1,(float)0.2,(float)0.5,(float)1.0,(float)2.0,(float)5.0});
		deviceChoice65.setOffsetNid(39);
		{
			String[] tempString = new String[7];
			tempString[0] = "50e-3";
			tempString[1] = "100e-3";
			tempString[2] = "200e-3";
			tempString[3] = "500e-3";
			tempString[4] = "1";
			tempString[5] = "2";
			tempString[6] = "5 ";
			deviceChoice65.setChoiceItems(tempString);
		}
		deviceChoice65.setLabelString(" ");
		deviceChannel16.add(deviceChoice65);
		deviceField39.setNumCols(8);
		deviceField39.setOffsetNid(40);
		deviceChannel16.add(deviceField39);
		deviceChoice36.setOffsetNid(41);
		{
			String[] tempString = new String[4];
			tempString[0] = "DC 1M";
			tempString[1] = "AC 1M";
			tempString[2] = "DC 50ohm";
			tempString[3] = "AC 50ohm";
			deviceChoice36.setChoiceItems(tempString);
		}
		deviceChoice36.setLabelString(" ");
		deviceChannel16.add(deviceChoice36);
		deviceChoice37.setOffsetNid(42);
		{
			String[] tempString = new String[2];
			tempString[0] = "LIMIT ON";
			tempString[1] = "LIMIT OFF";
			deviceChoice37.setChoiceItems(tempString);
		}
		deviceChoice37.setLabelString(" ");
		deviceChannel16.add(deviceChoice37);
		JPanel7.setAlignmentX(0.498925F);
		JPanel7.setLayout(null);
		JTabbedPane1.add(JPanel7);
		JPanel7.setBackground(new java.awt.Color(204,204,204));
		JPanel7.setBounds(2,24,524,161);
		JPanel7.setVisible(false);
		JPanel8.setAlignmentY(0.0F);
		JPanel8.setLayout(new BoxLayout(JPanel8,BoxLayout.X_AXIS));
		JPanel7.add(JPanel8);
		JPanel8.setBounds(22,0,465,15);
		JLabel11.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
		JLabel11.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
		JLabel11.setText("                      Full Scale  (V)              Offset  (V)                     Coupling                     Bandwidth");
		JPanel8.add(JLabel11);
		deviceChannel1.setInSameLine(true);
		deviceChannel1.setOffsetNid(44);
		deviceChannel1.setLabelString("Ch05");
		deviceChannel1.setLayout(new BorderLayout(0,0));
		JPanel7.add(deviceChannel1);
		deviceChannel1.setBounds(6,15,524,44);
		deviceChoice66.setChoiceFloatValues(new float[] {(float)0.05,(float)0.1,(float)0.2,(float)0.5,(float)1.0,(float)2.0,(float)5.0});
		deviceChoice66.setOffsetNid(45);
		{
			String[] tempString = new String[7];
			tempString[0] = "50e-3";
			tempString[1] = "100e-3";
			tempString[2] = "200e-3";
			tempString[3] = "500e-3";
			tempString[4] = "1";
			tempString[5] = "2";
			tempString[6] = "5 ";
			deviceChoice66.setChoiceItems(tempString);
		}
		deviceChoice66.setLabelString(" ");
		deviceChannel1.add(deviceChoice66);
		deviceField9.setNumCols(8);
		deviceField9.setOffsetNid(46);
		deviceChannel1.add(deviceField9);
		deviceChoice6.setOffsetNid(47);
		{
			String[] tempString = new String[4];
			tempString[0] = "DC 1M";
			tempString[1] = "AC 1M";
			tempString[2] = "DC 50ohm";
			tempString[3] = "AC 50ohm";
			deviceChoice6.setChoiceItems(tempString);
		}
		deviceChoice6.setLabelString(" ");
		deviceChannel1.add(deviceChoice6);
		deviceChoice7.setOffsetNid(48);
		{
			String[] tempString = new String[2];
			tempString[0] = "LIMIT ON";
			tempString[1] = "LIMIT OFF";
			deviceChoice7.setChoiceItems(tempString);
		}
		deviceChoice7.setLabelString(" ");
		deviceChannel1.add(deviceChoice7);
		deviceChannel2.setInSameLine(true);
		deviceChannel2.setOffsetNid(50);
		deviceChannel2.setLabelString("Ch06");
		deviceChannel2.setLayout(new BorderLayout(0,0));
		JPanel7.add(deviceChannel2);
		deviceChannel2.setBounds(6,49,524,44);
		deviceChoice67.setChoiceFloatValues(new float[] {(float)0.05,(float)0.1,(float)0.2,(float)0.5,(float)1.0,(float)2.0,(float)5.0});
		deviceChoice67.setOffsetNid(51);
		{
			String[] tempString = new String[7];
			tempString[0] = "50e-3";
			tempString[1] = "100e-3";
			tempString[2] = "200e-3";
			tempString[3] = "500e-3";
			tempString[4] = "1";
			tempString[5] = "2";
			tempString[6] = "5 ";
			deviceChoice67.setChoiceItems(tempString);
		}
		deviceChoice67.setLabelString(" ");
		deviceChannel2.add(deviceChoice67);
		deviceField11.setNumCols(8);
		deviceField11.setOffsetNid(52);
		deviceChannel2.add(deviceField11);
		deviceChoice8.setOffsetNid(53);
		{
			String[] tempString = new String[4];
			tempString[0] = "DC 1M";
			tempString[1] = "AC 1M";
			tempString[2] = "DC 50ohm";
			tempString[3] = "AC 50ohm";
			deviceChoice8.setChoiceItems(tempString);
		}
		deviceChoice8.setLabelString(" ");
		deviceChannel2.add(deviceChoice8);
		deviceChoice9.setOffsetNid(54);
		{
			String[] tempString = new String[2];
			tempString[0] = "LIMIT ON";
			tempString[1] = "LIMIT OFF";
			deviceChoice9.setChoiceItems(tempString);
		}
		deviceChoice9.setLabelString(" ");
		deviceChannel2.add(deviceChoice9);
		JPanel5.setAlignmentX(0.498925F);
		JPanel5.setLayout(null);
		JTabbedPane1.add(JPanel5);
		JPanel5.setBackground(new java.awt.Color(204,204,204));
		JPanel5.setBounds(2,24,524,161);
		JPanel5.setVisible(false);
		JPanel6.setAlignmentY(0.0F);
		JPanel6.setLayout(new BoxLayout(JPanel6,BoxLayout.X_AXIS));
		JPanel5.add(JPanel6);
		JPanel6.setBounds(22,0,465,15);
		JLabel10.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
		JLabel10.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
		JLabel10.setText("                      Full Scale  (V)              Offset  (V)                     Coupling                     Bandwidth");
		JPanel6.add(JLabel10);
		deviceChannel3.setInSameLine(true);
		deviceChannel3.setOffsetNid(56);
		deviceChannel3.setLabelString("Ch07");
		deviceChannel3.setLayout(new BorderLayout(0,0));
		JPanel5.add(deviceChannel3);
		deviceChannel3.setBounds(6,15,524,44);
		deviceChoice68.setChoiceFloatValues(new float[] {(float)0.05,(float)0.1,(float)0.2,(float)0.5,(float)1.0,(float)2.0,(float)5.0});
		deviceChoice68.setOffsetNid(57);
		{
			String[] tempString = new String[7];
			tempString[0] = "50e-3";
			tempString[1] = "100e-3";
			tempString[2] = "200e-3";
			tempString[3] = "500e-3";
			tempString[4] = "1";
			tempString[5] = "2";
			tempString[6] = "5 ";
			deviceChoice68.setChoiceItems(tempString);
		}
		deviceChoice68.setLabelString(" ");
		deviceChannel3.add(deviceChoice68);
		deviceField13.setNumCols(8);
		deviceField13.setOffsetNid(58);
		deviceChannel3.add(deviceField13);
		deviceChoice10.setOffsetNid(59);
		{
			String[] tempString = new String[4];
			tempString[0] = "DC 1M";
			tempString[1] = "AC 1M";
			tempString[2] = "DC 50ohm";
			tempString[3] = "AC 50ohm";
			deviceChoice10.setChoiceItems(tempString);
		}
		deviceChoice10.setLabelString(" ");
		deviceChannel3.add(deviceChoice10);
		deviceChoice11.setOffsetNid(60);
		{
			String[] tempString = new String[2];
			tempString[0] = "LIMIT ON";
			tempString[1] = "LIMIT OFF";
			deviceChoice11.setChoiceItems(tempString);
		}
		deviceChoice11.setLabelString(" ");
		deviceChannel3.add(deviceChoice11);
		deviceChannel4.setInSameLine(true);
		deviceChannel4.setOffsetNid(62);
		deviceChannel4.setLabelString("Ch08");
		deviceChannel4.setLayout(new BorderLayout(0,0));
		JPanel5.add(deviceChannel4);
		deviceChannel4.setBounds(6,49,524,44);
		deviceChoice69.setChoiceFloatValues(new float[] {(float)0.05,(float)0.1,(float)0.2,(float)0.5,(float)1.0,(float)2.0,(float)5.0});
		deviceChoice69.setOffsetNid(63);
		{
			String[] tempString = new String[7];
			tempString[0] = "50e-3";
			tempString[1] = "100e-3";
			tempString[2] = "200e-3";
			tempString[3] = "500e-3";
			tempString[4] = "1";
			tempString[5] = "2";
			tempString[6] = "5 ";
			deviceChoice69.setChoiceItems(tempString);
		}
		deviceChoice69.setLabelString(" ");
		deviceChannel4.add(deviceChoice69);
		deviceField15.setNumCols(8);
		deviceField15.setOffsetNid(64);
		deviceChannel4.add(deviceField15);
		deviceChoice12.setOffsetNid(65);
		{
			String[] tempString = new String[4];
			tempString[0] = "DC 1M";
			tempString[1] = "AC 1M";
			tempString[2] = "DC 50ohm";
			tempString[3] = "AC 50ohm";
			deviceChoice12.setChoiceItems(tempString);
		}
		deviceChoice12.setLabelString(" ");
		deviceChannel4.add(deviceChoice12);
		deviceChoice13.setOffsetNid(66);
		{
			String[] tempString = new String[2];
			tempString[0] = "LIMIT ON";
			tempString[1] = "LIMIT OFF";
			deviceChoice13.setChoiceItems(tempString);
		}
		deviceChoice13.setLabelString(" ");
		deviceChannel4.add(deviceChoice13);
		JPanel11.setAlignmentX(0.498925F);
		JPanel11.setLayout(null);
		JTabbedPane1.add(JPanel11);
		JPanel11.setBackground(new java.awt.Color(204,204,204));
		JPanel11.setBounds(2,24,524,161);
		JPanel11.setVisible(false);
		JPanel12.setAlignmentY(0.0F);
		JPanel12.setLayout(new BoxLayout(JPanel12,BoxLayout.X_AXIS));
		JPanel11.add(JPanel12);
		JPanel12.setBounds(22,0,465,15);
		JLabel12.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
		JLabel12.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
		JLabel12.setText("                      Full Scale  (V)              Offset  (V)                     Coupling                     Bandwidth");
		JPanel12.add(JLabel12);
		deviceChannel5.setInSameLine(true);
		deviceChannel5.setOffsetNid(68);
		deviceChannel5.setLabelString("Ch09");
		deviceChannel5.setLayout(new BorderLayout(0,0));
		JPanel11.add(deviceChannel5);
		deviceChannel5.setBounds(6,15,524,44);
		deviceChoice70.setChoiceFloatValues(new float[] {(float)0.05,(float)0.1,(float)0.2,(float)0.5,(float)1.0,(float)2.0,(float)5.0});
		deviceChoice70.setOffsetNid(69);
		{
			String[] tempString = new String[7];
			tempString[0] = "50e-3";
			tempString[1] = "100e-3";
			tempString[2] = "200e-3";
			tempString[3] = "500e-3";
			tempString[4] = "1";
			tempString[5] = "2";
			tempString[6] = "5 ";
			deviceChoice70.setChoiceItems(tempString);
		}
		deviceChoice70.setLabelString(" ");
		deviceChannel5.add(deviceChoice70);
		deviceField17.setNumCols(8);
		deviceField17.setOffsetNid(70);
		deviceChannel5.add(deviceField17);
		deviceChoice14.setOffsetNid(71);
		{
			String[] tempString = new String[4];
			tempString[0] = "DC 1M";
			tempString[1] = "AC 1M";
			tempString[2] = "DC 50ohm";
			tempString[3] = "AC 50ohm";
			deviceChoice14.setChoiceItems(tempString);
		}
		deviceChoice14.setLabelString(" ");
		deviceChannel5.add(deviceChoice14);
		deviceChoice15.setOffsetNid(72);
		{
			String[] tempString = new String[2];
			tempString[0] = "LIMIT ON";
			tempString[1] = "LIMIT OFF";
			deviceChoice15.setChoiceItems(tempString);
		}
		deviceChoice15.setLabelString(" ");
		deviceChannel5.add(deviceChoice15);
		deviceChannel6.setInSameLine(true);
		deviceChannel6.setOffsetNid(74);
		deviceChannel6.setLabelString("Ch10");
		deviceChannel6.setLayout(new BorderLayout(0,0));
		JPanel11.add(deviceChannel6);
		deviceChannel6.setBounds(6,49,524,44);
		deviceChoice71.setChoiceFloatValues(new float[] {(float)0.05,(float)0.1,(float)0.2,(float)0.5,(float)1.0,(float)2.0,(float)5.0});
		deviceChoice71.setOffsetNid(75);
		{
			String[] tempString = new String[7];
			tempString[0] = "50e-3";
			tempString[1] = "100e-3";
			tempString[2] = "200e-3";
			tempString[3] = "500e-3";
			tempString[4] = "1";
			tempString[5] = "2";
			tempString[6] = "5 ";
			deviceChoice71.setChoiceItems(tempString);
		}
		deviceChoice71.setLabelString(" ");
		deviceChannel6.add(deviceChoice71);
		deviceField19.setNumCols(8);
		deviceField19.setOffsetNid(76);
		deviceChannel6.add(deviceField19);
		deviceChoice16.setOffsetNid(77);
		{
			String[] tempString = new String[4];
			tempString[0] = "DC 1M";
			tempString[1] = "AC 1M";
			tempString[2] = "DC 50ohm";
			tempString[3] = "AC 50ohm";
			deviceChoice16.setChoiceItems(tempString);
		}
		deviceChoice16.setLabelString(" ");
		deviceChannel6.add(deviceChoice16);
		deviceChoice17.setOffsetNid(78);
		{
			String[] tempString = new String[2];
			tempString[0] = "LIMIT ON";
			tempString[1] = "LIMIT OFF";
			deviceChoice17.setChoiceItems(tempString);
		}
		deviceChoice17.setLabelString(" ");
		deviceChannel6.add(deviceChoice17);
		JPanel13.setAlignmentX(0.498925F);
		JPanel13.setLayout(null);
		JTabbedPane1.add(JPanel13);
		JPanel13.setBackground(new java.awt.Color(204,204,204));
		JPanel13.setBounds(2,24,524,161);
		JPanel13.setVisible(false);
		JPanel14.setAlignmentY(0.0F);
		JPanel14.setLayout(new BoxLayout(JPanel14,BoxLayout.X_AXIS));
		JPanel13.add(JPanel14);
		JPanel14.setBounds(22,0,465,15);
		JLabel13.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
		JLabel13.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
		JLabel13.setText("                      Full Scale  (V)              Offset  (V)                     Coupling                     Bandwidth");
		JPanel14.add(JLabel13);
		deviceChannel7.setInSameLine(true);
		deviceChannel7.setOffsetNid(80);
		deviceChannel7.setLabelString("Ch11");
		deviceChannel7.setLayout(new BorderLayout(0,0));
		JPanel13.add(deviceChannel7);
		deviceChannel7.setBounds(6,15,524,44);
		deviceChoice72.setChoiceFloatValues(new float[] {(float)0.05,(float)0.1,(float)0.2,(float)0.5,(float)1.0,(float)2.0,(float)5.0});
		deviceChoice72.setOffsetNid(81);
		{
			String[] tempString = new String[7];
			tempString[0] = "50e-3";
			tempString[1] = "100e-3";
			tempString[2] = "200e-3";
			tempString[3] = "500e-3";
			tempString[4] = "1";
			tempString[5] = "2";
			tempString[6] = "5 ";
			deviceChoice72.setChoiceItems(tempString);
		}
		deviceChoice72.setLabelString(" ");
		deviceChannel7.add(deviceChoice72);
		deviceField21.setNumCols(8);
		deviceField21.setOffsetNid(82);
		deviceChannel7.add(deviceField21);
		deviceChoice18.setOffsetNid(83);
		{
			String[] tempString = new String[4];
			tempString[0] = "DC 1M";
			tempString[1] = "AC 1M";
			tempString[2] = "DC 50ohm";
			tempString[3] = "AC 50ohm";
			deviceChoice18.setChoiceItems(tempString);
		}
		deviceChoice18.setLabelString(" ");
		deviceChannel7.add(deviceChoice18);
		deviceChoice19.setOffsetNid(84);
		{
			String[] tempString = new String[2];
			tempString[0] = "LIMIT ON";
			tempString[1] = "LIMIT OFF";
			deviceChoice19.setChoiceItems(tempString);
		}
		deviceChoice19.setLabelString(" ");
		deviceChannel7.add(deviceChoice19);
		deviceChannel8.setInSameLine(true);
		deviceChannel8.setOffsetNid(86);
		deviceChannel8.setLabelString("Ch12");
		deviceChannel8.setLayout(new BorderLayout(0,0));
		JPanel13.add(deviceChannel8);
		deviceChannel8.setBounds(6,49,524,44);
		deviceChoice73.setChoiceFloatValues(new float[] {(float)0.05,(float)0.1,(float)0.2,(float)0.5,(float)1.0,(float)2.0,(float)5.0});
		deviceChoice73.setOffsetNid(87);
		{
			String[] tempString = new String[7];
			tempString[0] = "50e-3";
			tempString[1] = "100e-3";
			tempString[2] = "200e-3";
			tempString[3] = "500e-3";
			tempString[4] = "1";
			tempString[5] = "2";
			tempString[6] = "5 ";
			deviceChoice73.setChoiceItems(tempString);
		}
		deviceChoice73.setLabelString(" ");
		deviceChannel8.add(deviceChoice73);
		deviceField23.setNumCols(8);
		deviceField23.setOffsetNid(88);
		deviceChannel8.add(deviceField23);
		deviceChoice20.setOffsetNid(89);
		{
			String[] tempString = new String[4];
			tempString[0] = "DC 1M";
			tempString[1] = "AC 1M";
			tempString[2] = "DC 50ohm";
			tempString[3] = "AC 50ohm";
			deviceChoice20.setChoiceItems(tempString);
		}
		deviceChoice20.setLabelString(" ");
		deviceChannel8.add(deviceChoice20);
		deviceChoice21.setOffsetNid(90);
		{
			String[] tempString = new String[2];
			tempString[0] = "LIMIT ON";
			tempString[1] = "LIMIT OFF";
			deviceChoice21.setChoiceItems(tempString);
		}
		deviceChoice21.setLabelString(" ");
		deviceChannel8.add(deviceChoice21);
		JPanel15.setAlignmentX(0.498925F);
		JPanel15.setLayout(null);
		JTabbedPane1.add(JPanel15);
		JPanel15.setBackground(new java.awt.Color(204,204,204));
		JPanel15.setBounds(2,24,524,161);
		JPanel15.setVisible(false);
		JPanel16.setAlignmentY(0.0F);
		JPanel16.setLayout(new BoxLayout(JPanel16,BoxLayout.X_AXIS));
		JPanel15.add(JPanel16);
		JPanel16.setBounds(22,0,465,15);
		JLabel14.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
		JLabel14.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
		JLabel14.setText("                      Full Scale  (V)              Offset  (V)                     Coupling                     Bandwidth");
		JPanel16.add(JLabel14);
		JLabel14.setForeground(new java.awt.Color(102,102,153));
		deviceChannel9.setInSameLine(true);
		deviceChannel9.setOffsetNid(92);
		deviceChannel9.setLabelString("Ch13");
		deviceChannel9.setLayout(new BorderLayout(0,0));
		JPanel15.add(deviceChannel9);
		deviceChannel9.setBounds(6,15,524,44);
		deviceChoice74.setChoiceFloatValues(new float[] {(float)0.05,(float)0.1,(float)0.2,(float)0.5,(float)1.0,(float)2.0,(float)5.0});
		deviceChoice74.setOffsetNid(93);
		{
			String[] tempString = new String[7];
			tempString[0] = "50e-3";
			tempString[1] = "100e-3";
			tempString[2] = "200e-3";
			tempString[3] = "500e-3";
			tempString[4] = "1";
			tempString[5] = "2";
			tempString[6] = "5 ";
			deviceChoice74.setChoiceItems(tempString);
		}
		deviceChoice74.setLabelString(" ");
		deviceChannel9.add(deviceChoice74);
		deviceField25.setNumCols(8);
		deviceField25.setOffsetNid(94);
		deviceChannel9.add(deviceField25);
		deviceChoice22.setOffsetNid(95);
		{
			String[] tempString = new String[4];
			tempString[0] = "DC 1M";
			tempString[1] = "AC 1M";
			tempString[2] = "DC 50ohm";
			tempString[3] = "AC 50ohm";
			deviceChoice22.setChoiceItems(tempString);
		}
		deviceChoice22.setLabelString(" ");
		deviceChannel9.add(deviceChoice22);
		deviceChoice23.setOffsetNid(96);
		{
			String[] tempString = new String[2];
			tempString[0] = "LIMIT ON";
			tempString[1] = "LIMIT OFF";
			deviceChoice23.setChoiceItems(tempString);
		}
		deviceChoice23.setLabelString(" ");
		deviceChannel9.add(deviceChoice23);
		deviceChannel10.setInSameLine(true);
		deviceChannel10.setOffsetNid(98);
		deviceChannel10.setLabelString("Ch14");
		deviceChannel10.setLayout(new BorderLayout(0,0));
		JPanel15.add(deviceChannel10);
		deviceChannel10.setBounds(6,49,524,44);
		deviceChoice75.setChoiceFloatValues(new float[] {(float)0.05,(float)0.1,(float)0.2,(float)0.5,(float)1.0,(float)2.0,(float)5.0});
		deviceChoice75.setOffsetNid(99);
		{
			String[] tempString = new String[7];
			tempString[0] = "50e-3";
			tempString[1] = "100e-3";
			tempString[2] = "200e-3";
			tempString[3] = "500e-3";
			tempString[4] = "1";
			tempString[5] = "2";
			tempString[6] = "5 ";
			deviceChoice75.setChoiceItems(tempString);
		}
		deviceChoice75.setLabelString(" ");
		deviceChannel10.add(deviceChoice75);
		deviceField27.setNumCols(8);
		deviceField27.setOffsetNid(100);
		deviceChannel10.add(deviceField27);
		deviceChoice24.setOffsetNid(101);
		{
			String[] tempString = new String[4];
			tempString[0] = "DC 1M";
			tempString[1] = "AC 1M";
			tempString[2] = "DC 50ohm";
			tempString[3] = "AC 50ohm";
			deviceChoice24.setChoiceItems(tempString);
		}
		deviceChoice24.setLabelString(" ");
		deviceChannel10.add(deviceChoice24);
		deviceChoice25.setOffsetNid(102);
		{
			String[] tempString = new String[2];
			tempString[0] = "LIMIT ON";
			tempString[1] = "LIMIT OFF";
			deviceChoice25.setChoiceItems(tempString);
		}
		deviceChoice25.setLabelString(" ");
		deviceChannel10.add(deviceChoice25);
		JTabbedPane1.setSelectedIndex(0);
		JTabbedPane1.setSelectedComponent(JPanel9);
		JTabbedPane1.setTitleAt(0,"Board 1");
		JTabbedPane1.setTitleAt(1,"Board 2");
		JTabbedPane1.setTitleAt(2,"Board 3");
		JTabbedPane1.setTitleAt(3,"Board 4");
		JTabbedPane1.setTitleAt(4,"Board 5");
		JTabbedPane1.setTitleAt(5,"Board 6");
		JTabbedPane1.setTitleAt(6,"Board 7");
		deviceTable3.setNumCols(1);
		{
			String[] tempString = new String[1];
			tempString[0] = "Temperature";
			deviceTable3.setColumnNames(tempString);
		}
		deviceTable3.setNumRows(7);
		deviceTable3.setOffsetNid(7);
		deviceTable3.setEditable(false);
		getContentPane().add(deviceTable3);
		deviceTable3.setBounds(250,200,100,142);
		deviceTable2.setNumCols(1);
		{
			String[] tempString = new String[1];
			tempString[0] = "Slot number";
			deviceTable2.setColumnNames(tempString);
		}
		deviceTable2.setNumRows(7);
		deviceTable2.setOffsetNid(4);
		deviceTable2.setEditable(false);
		getContentPane().add(deviceTable2);
		deviceTable2.setBounds(142,200,106,142);
		//}}
	}

	public ACQD240Setup()
	{
		this((JFrame)null);
	}

	public ACQD240Setup(String sTitle)
	{
		this();
		setTitle(sTitle);
	}

	public void setVisible(boolean b)
	{
		if (b)
			setLocation(50, 50);
		super.setVisible(b);
	}

	static public void main(String args[])
	{
		(new ACQD240Setup()).setVisible(true);
	}

	public void addNotify()
	{
		// Record the size of the window prior to calling parents addNotify.
		Dimension size = getSize();

		super.addNotify();

		if (frameSizeAdjusted)
			return;
		frameSizeAdjusted = true;

		// Adjust size of frame according to the insets
		Insets insets = getInsets();
		setSize(insets.left + insets.right + size.width, insets.top + insets.bottom + size.height);
	}

	// Used by addNotify
	boolean frameSizeAdjusted = false;

	//{{DECLARE_CONTROLS
	javax.swing.JLabel name_label = new javax.swing.JLabel();
	DeviceField name = new DeviceField();
	javax.swing.JLabel comment_label = new javax.swing.JLabel();
	DeviceField comment = new DeviceField();
	javax.swing.JPanel JPanel2 = new javax.swing.JPanel();
	DeviceChoice deviceChoice1 = new DeviceChoice();
	DeviceField deviceField3 = new DeviceField();
	javax.swing.JLabel JLabel3 = new javax.swing.JLabel();
	javax.swing.JLabel JLabel4 = new javax.swing.JLabel();
	DeviceField deviceField4 = new DeviceField();
	javax.swing.JLabel JLabel5 = new javax.swing.JLabel();
	DeviceField deviceField5 = new DeviceField();
	javax.swing.JLabel JLabel6 = new javax.swing.JLabel();
	DeviceField deviceField6 = new DeviceField();
	DeviceChoice deviceChoice2 = new DeviceChoice();
	DeviceChoice deviceChoice3 = new DeviceChoice();
	javax.swing.JLabel JLabel2 = new javax.swing.JLabel();
	javax.swing.JLabel JLabel1 = new javax.swing.JLabel();
	DeviceField deviceField1 = new DeviceField();
	DeviceField deviceField2 = new DeviceField();
	DeviceTable deviceTable1 = new DeviceTable();
	DeviceButtons deviceButtons1 = new DeviceButtons();
	DeviceDispatch deviceDispatch1 = new DeviceDispatch();
	DeviceChoice deviceChoice4 = new DeviceChoice();
	DeviceChoice deviceChoice5 = new DeviceChoice();
	javax.swing.JLabel JLabel7 = new javax.swing.JLabel();
	DeviceField deviceField7 = new DeviceField();
	javax.swing.JLabel JLabel8 = new javax.swing.JLabel();
	javax.swing.JTabbedPane JTabbedPane1 = new javax.swing.JTabbedPane();
	javax.swing.JPanel JPanel9 = new javax.swing.JPanel();
	javax.swing.JPanel JPanel10 = new javax.swing.JPanel();
	javax.swing.JLabel JLabel16 = new javax.swing.JLabel();
	DeviceChannel deviceChannel13 = new DeviceChannel();
	DeviceChoice deviceChoice62 = new DeviceChoice();
	DeviceField deviceField33 = new DeviceField();
	DeviceChoice deviceChoice30 = new DeviceChoice();
	DeviceChoice deviceChoice31 = new DeviceChoice();
	DeviceChannel deviceChannel14 = new DeviceChannel();
	DeviceChoice deviceChoice63 = new DeviceChoice();
	DeviceField deviceField35 = new DeviceField();
	DeviceChoice deviceChoice32 = new DeviceChoice();
	DeviceChoice deviceChoice33 = new DeviceChoice();
	DeviceChannel deviceChannel15 = new DeviceChannel();
	DeviceChoice deviceChoice64 = new DeviceChoice();
	DeviceField deviceField37 = new DeviceField();
	DeviceChoice deviceChoice34 = new DeviceChoice();
	DeviceChoice deviceChoice35 = new DeviceChoice();
	DeviceChannel deviceChannel16 = new DeviceChannel();
	DeviceChoice deviceChoice65 = new DeviceChoice();
	DeviceField deviceField39 = new DeviceField();
	DeviceChoice deviceChoice36 = new DeviceChoice();
	DeviceChoice deviceChoice37 = new DeviceChoice();
	javax.swing.JPanel JPanel3 = new javax.swing.JPanel();
	javax.swing.JPanel JPanel4 = new javax.swing.JPanel();
	javax.swing.JLabel JLabel9 = new javax.swing.JLabel();
	DeviceChannel deviceChannel1 = new DeviceChannel();
	DeviceChoice deviceChoice66 = new DeviceChoice();
	DeviceField deviceField9 = new DeviceField();
	DeviceChoice deviceChoice6 = new DeviceChoice();
	DeviceChoice deviceChoice7 = new DeviceChoice();
	DeviceChannel deviceChannel2 = new DeviceChannel();
	DeviceChoice deviceChoice67 = new DeviceChoice();
	DeviceField deviceField11 = new DeviceField();
	DeviceChoice deviceChoice8 = new DeviceChoice();
	DeviceChoice deviceChoice9 = new DeviceChoice();
	DeviceChannel deviceChannel3 = new DeviceChannel();
	DeviceChoice deviceChoice68 = new DeviceChoice();
	DeviceField deviceField13 = new DeviceField();
	DeviceChoice deviceChoice10 = new DeviceChoice();
	DeviceChoice deviceChoice11 = new DeviceChoice();
	DeviceChannel deviceChannel4 = new DeviceChannel();
	DeviceChoice deviceChoice69 = new DeviceChoice();
	DeviceField deviceField15 = new DeviceField();
	DeviceChoice deviceChoice12 = new DeviceChoice();
	DeviceChoice deviceChoice13 = new DeviceChoice();
	javax.swing.JPanel JPanel5 = new javax.swing.JPanel();
	javax.swing.JPanel JPanel6 = new javax.swing.JPanel();
	javax.swing.JLabel JLabel10 = new javax.swing.JLabel();
	DeviceChannel deviceChannel5 = new DeviceChannel();
	DeviceChoice deviceChoice70 = new DeviceChoice();
	DeviceField deviceField17 = new DeviceField();
	DeviceChoice deviceChoice14 = new DeviceChoice();
	DeviceChoice deviceChoice15 = new DeviceChoice();
	DeviceChannel deviceChannel6 = new DeviceChannel();
	DeviceChoice deviceChoice71 = new DeviceChoice();
	DeviceField deviceField19 = new DeviceField();
	DeviceChoice deviceChoice16 = new DeviceChoice();
	DeviceChoice deviceChoice17 = new DeviceChoice();
	DeviceChannel deviceChannel7 = new DeviceChannel();
	DeviceChoice deviceChoice72 = new DeviceChoice();
	DeviceField deviceField21 = new DeviceField();
	DeviceChoice deviceChoice18 = new DeviceChoice();
	DeviceChoice deviceChoice19 = new DeviceChoice();
	DeviceChannel deviceChannel8 = new DeviceChannel();
	DeviceChoice deviceChoice73 = new DeviceChoice();
	DeviceField deviceField23 = new DeviceField();
	DeviceChoice deviceChoice20 = new DeviceChoice();
	DeviceChoice deviceChoice21 = new DeviceChoice();
	javax.swing.JPanel JPanel7 = new javax.swing.JPanel();
	javax.swing.JPanel JPanel8 = new javax.swing.JPanel();
	javax.swing.JLabel JLabel11 = new javax.swing.JLabel();
	DeviceChannel deviceChannel9 = new DeviceChannel();
	DeviceChoice deviceChoice74 = new DeviceChoice();
	DeviceField deviceField25 = new DeviceField();
	DeviceChoice deviceChoice22 = new DeviceChoice();
	DeviceChoice deviceChoice23 = new DeviceChoice();
	DeviceChannel deviceChannel10 = new DeviceChannel();
	DeviceChoice deviceChoice75 = new DeviceChoice();
	DeviceField deviceField27 = new DeviceField();
	DeviceChoice deviceChoice24 = new DeviceChoice();
	DeviceChoice deviceChoice25 = new DeviceChoice();
	DeviceChannel deviceChannel11 = new DeviceChannel();
	DeviceChoice deviceChoice76 = new DeviceChoice();
	DeviceField deviceField29 = new DeviceField();
	DeviceChoice deviceChoice26 = new DeviceChoice();
	DeviceChoice deviceChoice27 = new DeviceChoice();
	DeviceChannel deviceChannel12 = new DeviceChannel();
	DeviceChoice deviceChoice77 = new DeviceChoice();
	DeviceField deviceField31 = new DeviceField();
	DeviceChoice deviceChoice28 = new DeviceChoice();
	DeviceChoice deviceChoice29 = new DeviceChoice();
	javax.swing.JPanel JPanel11 = new javax.swing.JPanel();
	javax.swing.JPanel JPanel12 = new javax.swing.JPanel();
	javax.swing.JLabel JLabel12 = new javax.swing.JLabel();
	DeviceChannel deviceChannel17 = new DeviceChannel();
	DeviceChoice deviceChoice78 = new DeviceChoice();
	DeviceField deviceField41 = new DeviceField();
	DeviceChoice deviceChoice38 = new DeviceChoice();
	DeviceChoice deviceChoice39 = new DeviceChoice();
	DeviceChannel deviceChannel18 = new DeviceChannel();
	DeviceChoice deviceChoice79 = new DeviceChoice();
	DeviceField deviceField43 = new DeviceField();
	DeviceChoice deviceChoice40 = new DeviceChoice();
	DeviceChoice deviceChoice41 = new DeviceChoice();
	DeviceChannel deviceChannel19 = new DeviceChannel();
	DeviceChoice deviceChoice80 = new DeviceChoice();
	DeviceField deviceField45 = new DeviceField();
	DeviceChoice deviceChoice42 = new DeviceChoice();
	DeviceChoice deviceChoice43 = new DeviceChoice();
	DeviceChannel deviceChannel20 = new DeviceChannel();
	DeviceChoice deviceChoice81 = new DeviceChoice();
	DeviceField deviceField47 = new DeviceField();
	DeviceChoice deviceChoice44 = new DeviceChoice();
	DeviceChoice deviceChoice45 = new DeviceChoice();
	javax.swing.JPanel JPanel13 = new javax.swing.JPanel();
	javax.swing.JPanel JPanel14 = new javax.swing.JPanel();
	javax.swing.JLabel JLabel13 = new javax.swing.JLabel();
	DeviceChannel deviceChannel21 = new DeviceChannel();
	DeviceChoice deviceChoice82 = new DeviceChoice();
	DeviceField deviceField49 = new DeviceField();
	DeviceChoice deviceChoice46 = new DeviceChoice();
	DeviceChoice deviceChoice47 = new DeviceChoice();
	DeviceChannel deviceChannel22 = new DeviceChannel();
	DeviceChoice deviceChoice83 = new DeviceChoice();
	DeviceField deviceField51 = new DeviceField();
	DeviceChoice deviceChoice48 = new DeviceChoice();
	DeviceChoice deviceChoice49 = new DeviceChoice();
	DeviceChannel deviceChannel23 = new DeviceChannel();
	DeviceChoice deviceChoice84 = new DeviceChoice();
	DeviceField deviceField53 = new DeviceField();
	DeviceChoice deviceChoice50 = new DeviceChoice();
	DeviceChoice deviceChoice51 = new DeviceChoice();
	DeviceChannel deviceChannel24 = new DeviceChannel();
	DeviceChoice deviceChoice85 = new DeviceChoice();
	DeviceField deviceField55 = new DeviceField();
	DeviceChoice deviceChoice52 = new DeviceChoice();
	DeviceChoice deviceChoice53 = new DeviceChoice();
	javax.swing.JPanel JPanel15 = new javax.swing.JPanel();
	javax.swing.JPanel JPanel16 = new javax.swing.JPanel();
	javax.swing.JLabel JLabel14 = new javax.swing.JLabel();
	DeviceChannel deviceChannel25 = new DeviceChannel();
	DeviceChoice deviceChoice86 = new DeviceChoice();
	DeviceField deviceField57 = new DeviceField();
	DeviceChoice deviceChoice54 = new DeviceChoice();
	DeviceChoice deviceChoice55 = new DeviceChoice();
	DeviceChannel deviceChannel26 = new DeviceChannel();
	DeviceChoice deviceChoice87 = new DeviceChoice();
	DeviceField deviceField59 = new DeviceField();
	DeviceChoice deviceChoice56 = new DeviceChoice();
	DeviceChoice deviceChoice57 = new DeviceChoice();
	DeviceChannel deviceChannel27 = new DeviceChannel();
	DeviceChoice deviceChoice88 = new DeviceChoice();
	DeviceField deviceField61 = new DeviceField();
	DeviceChoice deviceChoice58 = new DeviceChoice();
	DeviceChoice deviceChoice59 = new DeviceChoice();
	DeviceChannel deviceChannel28 = new DeviceChannel();
	DeviceChoice deviceChoice89 = new DeviceChoice();
	DeviceField deviceField63 = new DeviceField();
	DeviceChoice deviceChoice60 = new DeviceChoice();
	DeviceChoice deviceChoice61 = new DeviceChoice();
	DeviceTable deviceTable3 = new DeviceTable();
	DeviceTable deviceTable2 = new DeviceTable();
	//}}

}
