/*
 * Decompiled with CFR 0.152.
 */
package mds.connection;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Descriptor {
    public static final byte MAX_DIM = 8;
    public static final byte DTYPE_UBYTE = 2;
    public static final byte DTYPE_USHORT = 3;
    public static final byte DTYPE_ULONG = 4;
    public static final byte DTYPE_ULONGLONG = 5;
    public static final byte DTYPE_BYTE = 6;
    public static final byte DTYPE_SHORT = 7;
    public static final byte DTYPE_LONG = 8;
    public static final byte DTYPE_LONGLONG = 9;
    public static final byte DTYPE_FLOAT = 10;
    public static final byte DTYPE_DOUBLE = 11;
    public static final byte DTYPE_COMPLEX = 12;
    public static final byte DTYPE_COMPLEX_DOUBLE = 13;
    public static final byte DTYPE_CSTRING = 14;
    public static final byte DTYPE_EVENT = 99;
    public static final byte DTYPE_EVENT_NOTIFY = 99;
    public byte dtype;
    public short[] short_data;
    public double[] double_data;
    public float[] float_data;
    public int[] int_data;
    public byte[] byte_data;
    public long[] long_data;
    public String strdata;
    public String error = null;
    public int[] dims;
    public int status;

    public Descriptor() {
    }

    public Descriptor(String error) {
        this.error = error;
    }

    public Descriptor(byte dtype, int[] dims, byte[] byte_data) {
        this.dtype = dtype;
        this.dims = dims;
        this.byte_data = byte_data;
    }

    public Descriptor(int[] dims, byte[] byte_data) {
        this.dtype = (byte)6;
        this.dims = dims;
        this.byte_data = byte_data;
    }

    public Descriptor(int[] dims, long[] long_data) {
        this.dtype = (byte)9;
        this.dims = dims;
        this.long_data = long_data;
    }

    public Descriptor(int[] dims, float[] float_data) {
        this.dtype = (byte)10;
        this.dims = dims;
        this.float_data = float_data;
    }

    public Descriptor(int[] dims, int[] int_data) {
        this.dtype = (byte)8;
        this.dims = dims;
        this.int_data = int_data;
    }

    public Descriptor(int[] dims, short[] short_data) {
        this.dtype = (byte)7;
        this.dims = dims;
        this.short_data = short_data;
    }

    public Descriptor(int[] dims, String strdata) {
        this.dtype = (byte)14;
        this.dims = dims;
        this.strdata = strdata;
    }

    public int getStatus() {
        return this.status;
    }

    public int getInt() {
        return this.int_data[0];
    }

    public static byte[] dataToByteArray(Object o) {
        byte[] b = null;
        try {
            int d;
            ByteArrayOutputStream dosb = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(dosb);
            if (o instanceof Short) {
                d = ((Short)o).shortValue();
                dos.writeShort(d);
                b = dosb.toByteArray();
            }
            if (o instanceof Integer) {
                d = (Integer)o;
                dos.writeInt(d);
                b = dosb.toByteArray();
            }
            if (o instanceof Float) {
                float d2 = ((Float)o).floatValue();
                dos.writeFloat(d2);
                b = dosb.toByteArray();
            }
            if (o instanceof Double) {
                double d3 = (Double)o;
                dos.writeDouble(d3);
                b = dosb.toByteArray();
            }
            if (o instanceof Long) {
                long l = (Long)o;
                dos.writeLong(l);
                b = dosb.toByteArray();
            }
            dos.close();
            return b;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] dataToByteArray() {
        byte[] b = null;
        try {
            ByteArrayOutputStream dosb = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(dosb);
            switch (this.dtype) {
                case 14: {
                    dos.close();
                    if (this.strdata != null) {
                        return this.strdata.getBytes();
                    }
                    return this.byte_data;
                }
                case 2: 
                case 6: {
                    dos.close();
                    return this.byte_data;
                }
                case 3: 
                case 7: {
                    for (int i = 0; i < this.short_data.length; ++i) {
                        dos.writeShort(this.short_data[i]);
                    }
                    break;
                }
                case 4: 
                case 8: {
                    for (int i = 0; i < this.int_data.length; ++i) {
                        dos.writeInt(this.int_data[i]);
                    }
                    break;
                }
                case 10: {
                    for (int i = 0; i < this.float_data.length; ++i) {
                        dos.writeFloat(this.float_data[i]);
                    }
                    break;
                }
                case 5: 
                case 9: {
                    for (int i = 0; i < this.long_data.length; ++i) {
                        dos.writeLong(this.long_data[i]);
                    }
                    break;
                }
                case 11: {
                    for (int i = 0; i < this.double_data.length; ++i) {
                        dos.writeDouble(this.double_data[i]);
                    }
                    break;
                }
            }
            b = dosb.toByteArray();
            dos.close();
            return b;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static short getDataSize(byte type, byte[] body) {
        switch (type) {
            case 14: {
                return (short)body.length;
            }
            case 6: {
                return 1;
            }
            case 3: 
            case 7: {
                return 2;
            }
            case 4: 
            case 8: 
            case 10: {
                return 4;
            }
            case 5: 
            case 9: 
            case 11: {
                return 8;
            }
        }
        return 0;
    }
}

