/*
 * Decompiled with CFR 0.152.
 */
package mds.jscope;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JPanel;

class FontPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    Font thisFont = new Font("Arial", 0, 10);

    public void changeFont(Font font) {
        this.thisFont = font;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(100, 50);
    }

    public boolean isFontAvailable(Font font) {
        Graphics g = this.getGraphics();
        FontMetrics fm = g.getFontMetrics(font);
        int height = fm.getHeight();
        return height > 9 && height < 100;
    }

    @Override
    public void paint(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        g.setColor(Color.darkGray);
        g.setFont(this.thisFont);
        String change = "Pick a font, size, and style to change me";
        FontMetrics metrics = g.getFontMetrics();
        int width = metrics.stringWidth("Pick a font, size, and style to change me");
        int height = metrics.getHeight();
        g.drawString("Pick a font, size, and style to change me", w / 2 - width / 2, h / 2 - height / 2);
    }
}

