/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DeviceExprEditor
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    String expr;
    String data;
    int rows;
    int columns;
    JButton left = null;
    JButton right = null;
    JTextArea text_area;
    JTextField text_field;
    JPanel pl;
    JPanel pr;
    boolean default_scroll;
    boolean default_to_string;
    boolean quotes_added;
    boolean editable = true;

    public DeviceExprEditor(boolean default_to_string) {
        this(null, default_to_string, 1, 20);
    }

    public DeviceExprEditor(String data, boolean default_to_string) {
        this(data, default_to_string, 1, 20);
    }

    public DeviceExprEditor(String data, boolean default_to_string, int rows, int columns) {
        boolean quotes_needed;
        this.rows = rows;
        this.columns = columns;
        this.default_to_string = default_to_string;
        if (rows > 1) {
            this.default_scroll = true;
        }
        this.expr = data != null ? data : null;
        boolean bl = quotes_needed = default_to_string && (this.expr == null || this.expr.trim().equals("") || this.expr.charAt(0) == '\"');
        if (quotes_needed) {
            this.quotes_added = true;
            this.left = new JButton("\"");
            this.right = new JButton("\"");
            this.left.setMargin(new Insets(0, 0, 0, 0));
            this.right.setMargin(new Insets(0, 0, 0, 0));
            this.left.addActionListener(this);
            this.right.addActionListener(this);
            if (this.expr != null && this.expr.length() > 2) {
                this.expr = this.expr.substring(1, this.expr.length() - 1);
            }
        } else {
            this.quotes_added = false;
        }
        this.setLayout(new BorderLayout());
        if (this.default_scroll) {
            this.text_area = new JTextArea(rows, columns);
            Dimension d = this.text_area.getPreferredSize();
            this.text_area.setText(this.expr);
            d.height += 20;
            d.width += 20;
            JScrollPane scroll_pane = new JScrollPane(this.text_area);
            scroll_pane.setPreferredSize(d);
            if (quotes_needed) {
                this.pl = new JPanel();
                this.pl.setLayout(new BorderLayout());
                this.pl.add((Component)this.left, "North");
                this.add((Component)this.pl, "East");
            }
            this.add((Component)scroll_pane, "Center");
            if (quotes_needed) {
                this.pr = new JPanel();
                this.pr.setLayout(new BorderLayout());
                this.pr.add((Component)this.right, "North");
                this.add((Component)this.pr, "West");
            }
        } else {
            if (quotes_needed) {
                this.add((Component)this.left, "Before");
            }
            this.text_field = new JTextField(columns);
            this.text_field.setText(this.expr);
            this.add(this.text_field);
            if (quotes_needed) {
                this.add((Component)this.right, "After");
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.editable) {
            return;
        }
        this.quotes_added = false;
        if (this.default_scroll) {
            this.remove(this.pl);
            this.remove(this.pr);
        } else {
            this.remove(this.left);
            this.remove(this.right);
        }
        this.right = null;
        this.left = null;
        this.expr = this.default_scroll ? this.text_area.getText() : this.text_field.getText();
        this.expr = "\"" + this.expr + "\"";
        if (this.default_scroll) {
            this.text_area.setText(this.expr);
        } else {
            this.text_field.setText(this.expr);
        }
        this.validate();
        this.repaint();
    }

    public String getData() {
        this.expr = this.default_scroll ? this.text_area.getText() : this.text_field.getText();
        if (this.quotes_added) {
            return "\"" + this.expr + "\"";
        }
        return this.expr;
    }

    public void reset() {
        int len;
        this.expr = this.data == null ? "" : this.data;
        if (this.default_to_string && (len = this.expr.length()) >= 2) {
            this.expr = this.expr.substring(1, len - 1);
        }
        if (this.default_scroll) {
            this.text_area.setText(this.expr);
        } else {
            this.text_field.setText(this.expr);
        }
    }

    public void setData(String data) {
        this.data = data;
        this.reset();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        if (this.text_area != null) {
            this.text_area.setEditable(editable);
        }
        if (this.text_field != null) {
            this.text_field.setEditable(editable);
        }
    }
}

