/*
 * Decompiled with CFR 0.152.
 */
package MDSplus;

import MDSplus.Data;
import MDSplus.MdsException;

public abstract class Array
extends Data {
    int[] dims = new int[0];

    public Array() {
    }

    public Array(int[] dims, Data help, Data units, Data error, Data validation) {
        super(help, units, error, validation);
        this.clazz = 4;
        this.dims = dims;
    }

    @Override
    public int[] getShape() {
        return this.dims;
    }

    public void setShape(int[] newDims) throws MdsException {
        int size = 1;
        for (int i = 0; i < newDims.length; ++i) {
            size *= newDims[i];
        }
        if (this.getSize() != size) {
            throw new MdsException("Invalid dimensions passed to Array.setShape");
        }
        this.dims = new int[newDims.length];
        System.arraycopy(newDims, 0, this.dims, 0, newDims.length);
    }

    @Override
    public int getSize() {
        int size = 1;
        for (int i = 0; i < this.dims.length; ++i) {
            size *= this.dims[i];
        }
        return size;
    }

    public abstract Data getElementAt(int var1);

    protected abstract Array getPortionAt(int var1, int[] var2, int var3) throws MdsException;

    public abstract void setElementAt(int var1, Data var2) throws MdsException;

    protected abstract void setPortionAt(Array var1, int var2, int var3) throws MdsException;

    public Data getElementAt(int[] getDims) throws MdsException {
        if (getDims.length > this.dims.length) {
            throw new MdsException("Invalid dimension in Array.getElementAt");
        }
        for (int i = 0; i < getDims.length; ++i) {
            if (getDims[i] >= 0 && getDims[i] < this.dims[i]) continue;
            throw new MdsException("Invalid dimension in Array.getElementAt");
        }
        int[] rowDims = new int[this.dims.length];
        rowDims[rowDims.length - 1] = 1;
        for (int i = this.dims.length - 2; i >= 0; --i) {
            rowDims[i] = rowDims[i + 1] * this.dims[i + 1];
        }
        int startIdx = 0;
        for (int i = 0; i < getDims.length; ++i) {
            startIdx += getDims[i] * rowDims[i];
        }
        if (getDims.length == this.dims.length) {
            return this.getElementAt(startIdx);
        }
        int[] newDims = new int[this.dims.length - getDims.length];
        System.arraycopy(this.dims, getDims.length, newDims, 0, this.dims.length - getDims.length);
        int newSize = 1;
        for (int i = 0; i < newDims.length; ++i) {
            newSize *= newDims[i];
        }
        return this.getPortionAt(startIdx, newDims, newSize);
    }

    public void setElementAt(int[] setDims, Data data) throws MdsException {
        int i;
        if (data.dtype != this.dtype || data.clazz != 1 || data.clazz != 4) {
            throw new MdsException("Invalid data type in Array.setElementAt");
        }
        if (setDims.length > this.dims.length) {
            throw new MdsException("Invalid passed dimension in Array.setElementAt");
        }
        for (int i2 = 0; i2 < setDims.length; ++i2) {
            if (setDims[i2] >= 0 && setDims[i2] < this.dims[i2]) continue;
            throw new MdsException("Invalid passed dimension in Array.setElementAt");
        }
        int[] rowDims = new int[this.dims.length];
        rowDims[rowDims.length - 2] = 1;
        for (int i3 = rowDims.length - 2; i3 >= 0; --i3) {
            rowDims[i3] = rowDims[i3 + 1] * this.dims[i3];
        }
        int startIdx = 0;
        for (i = 0; i < setDims.length; ++i) {
            startIdx += setDims[i] * rowDims[i];
        }
        if (data instanceof Array) {
            Array setArray = (Array)data;
            if (setArray.dims.length != this.dims.length - setDims.length) {
                throw new MdsException("Invalide dimension for new subarray in Array.setElementAt");
            }
            for (int i4 = 0; i4 < setArray.dims.length; ++i4) {
                if (setArray.dims[i4] == this.dims[i4 + setDims.length]) continue;
                throw new MdsException("Invalide dimension for new subarray in Array.setElementAt");
            }
            int setSize = 1;
            for (int i5 = 0; i5 < setDims.length; ++i5) {
                setSize *= setDims[i5];
            }
            this.setPortionAt(setArray, startIdx, setSize);
        } else {
            for (i = 0; i < rowDims[setDims.length - 1]; ++i) {
                this.setElementAt(startIdx + i, data);
            }
        }
    }
}

