/*
 * Decompiled with CFR 0.152.
 */
package MDSplus;

import MDSplus.Array;
import MDSplus.Data;
import MDSplus.Float32;
import MDSplus.Float32Array;
import MDSplus.Float64;
import MDSplus.Float64Array;
import MDSplus.Int16;
import MDSplus.Int16Array;
import MDSplus.Int32;
import MDSplus.Int32Array;
import MDSplus.Int64;
import MDSplus.Int64Array;
import MDSplus.Int8;
import MDSplus.Int8Array;
import MDSplus.MdsException;
import MDSplus.String;
import MDSplus.StringArray;
import MDSplus.Tree;
import MDSplus.TreeNodeArray;

public class TreeNode
extends Data {
    protected int nid;
    static final int NciM_STATE = 1;
    static final int NciM_PARENT_STATE = 2;
    static final int NciM_ESSENTIAL = 4;
    static final int NciM_CACHED = 8;
    static final int NciM_VERSIONS = 16;
    static final int NciM_SEGMENTED = 32;
    static final int NciM_SETUP_INFORMATION = 64;
    static final int NciM_WRITE_ONCE = 128;
    static final int NciM_COMPRESSIBLE = 256;
    static final int NciM_DO_NOT_COMPRESS = 512;
    static final int NciM_COMPRESS_ON_PUT = 1024;
    static final int NciM_NO_WRITE_MODEL = 2048;
    static final int NciM_NO_WRITE_SHOT = 4096;
    static final int NciM_PATH_REFERENCE = 8192;
    static final int NciM_NID_REFERENCE = 16384;
    static final int NciM_INCLUDE_IN_PULSE = 32768;
    static final int NciM_COMPRESS_SEGMENTS = 65536;
    static final int NciTIME_INSERTED = 4;
    static final int NciOWNER_ID = 5;
    static final int NciCLASS = 6;
    static final int NciDTYPE = 7;
    static final int NciLENGTH = 8;
    static final int NciSTATUS = 9;
    static final int NciCONGLOMERATE_ELT = 10;
    static final int NciGET_FLAGS = 12;
    static final int NciNODE_NAME = 13;
    static final int NciPATH = 14;
    static final int NciDEPTH = 15;
    static final int NciPARENT = 16;
    static final int NciBROTHER = 17;
    static final int NciMEMBER = 18;
    static final int NciCHILD = 19;
    static final int NciPARENT_RELATIONSHIP = 20;
    static final int NciK_IS_CHILD = 1;
    static final int NciK_IS_MEMBER = 2;
    static final int NciCONGLOMERATE_NIDS = 21;
    static final int NciORIGINAL_PART_NAME = 22;
    static final int NciNUMBER_OF_MEMBERS = 23;
    static final int NciNUMBER_OF_CHILDREN = 24;
    static final int NciMEMBER_NIDS = 25;
    static final int NciCHILDREN_NIDS = 26;
    static final int NciFULLPATH = 27;
    static final int NciMINPATH = 28;
    static final int NciUSAGE = 29;
    static final int NciPARENT_TREE = 30;
    static final int NciRLENGTH = 31;
    static final int NciNUMBER_OF_ELTS = 32;
    static final int NciDATA_IN_NCI = 33;
    static final int NciERROR_ON_PUT = 34;
    static final int NciRFA = 35;
    static final int NciIO_STATUS = 36;
    static final int NciIO_STV = 37;
    static final int NciDTYPE_STR = 38;
    static final int NciUSAGE_STR = 39;
    static final int NciCLASS_STR = 40;
    static final int NciVERSION = 41;
    static final int TreeUSAGE_ANY = 0;
    static final int TreeUSAGE_STRUCTURE = 1;
    static final int TreeUSAGE_ACTION = 2;
    static final int TreeUSAGE_DEVICE = 3;
    static final int TreeUSAGE_DISPATCH = 4;
    static final int TreeUSAGE_NUMERIC = 5;
    static final int TreeUSAGE_SIGNAL = 6;
    static final int TreeUSAGE_TASK = 7;
    static final int TreeUSAGE_TEXT = 8;
    static final int TreeUSAGE_WINDOW = 9;
    static final int TreeUSAGE_AXIS = 10;
    static final int TreeUSAGE_SUBTREE = 11;
    static final int TreeUSAGE_COMPOUND_DATA = 12;

    public TreeNode(int nid, Data help, Data units, Data error, Data validation) throws MdsException {
        super(help, units, error, validation);
        this.clazz = 1;
        this.dtype = 192;
        this.nid = nid;
        this.ctxTree = Tree.getActiveTree();
    }

    public TreeNode(Data help, Data units, Data error, Data validation) throws MdsException {
        super(help, units, error, validation);
        this.clazz = 1;
        this.dtype = 192;
        this.ctxTree = Tree.getActiveTree();
    }

    public TreeNode(int nid, Tree tree, Data help, Data units, Data error, Data validation) {
        super(help, units, error, validation);
        this.clazz = 1;
        this.dtype = 192;
        this.nid = nid;
        this.ctxTree = tree;
    }

    public TreeNode(int nid, Tree tree) throws MdsException {
        this(nid, tree, null, null, null, null);
    }

    public TreeNode(int nid) throws MdsException {
        this(nid, null, null, null, null);
    }

    public static TreeNode getData(int nid) throws MdsException {
        return TreeNode.getData(nid, null, null, null, null);
    }

    public static TreeNode getData(int nid, Data help, Data units, Data error, Data validation) throws MdsException {
        return new TreeNode(nid, help, units, error, validation);
    }

    protected void resolveNid() throws MdsException {
    }

    private static native int getNci(int var0, long var1, int var3) throws MdsException;

    private static native long getNciLong(int var0, long var1, int var3) throws MdsException;

    private static native java.lang.String getNciString(int var0, long var1, int var3) throws MdsException;

    private static native void setNciFlag(int var0, long var1, int var3, boolean var4) throws MdsException;

    private static native void setNciFlags(int var0, long var1, int var3) throws MdsException;

    private static native boolean getNciFlag(int var0, long var1, int var3) throws MdsException;

    private static native int getNciFlags(int var0, long var1) throws MdsException;

    private static native int[] getNciNids(int var0, long var1, int var3, int var4) throws MdsException;

    private static native void turnOn(int var0, long var1, boolean var3) throws MdsException;

    private static native boolean isOn(int var0, long var1) throws MdsException;

    private static native boolean isParentOff(int var0, long var1) throws MdsException;

    private static native Data getExtendedAttribute(int var0, long var1, java.lang.String var3) throws MdsException;

    private static native void setExtendedAttribute(int var0, long var1, java.lang.String var3, Data var4) throws MdsException;

    private static native Data getData(int var0, long var1) throws MdsException;

    private static native void putData(int var0, long var1, Data var3) throws MdsException;

    private static native void deleteData(int var0, long var1) throws MdsException;

    private static native void doMethod(int var0, long var1, java.lang.String var3) throws MdsException;

    private static native java.lang.String[] getTags(int var0, long var1) throws MdsException;

    private static native void beginSegment(int var0, long var1, Data var3, Data var4, Data var5, Data var6) throws MdsException;

    private static native void makeSegment(int var0, long var1, Data var3, Data var4, Data var5, Data var6, int var7) throws MdsException;

    private static native void putSegment(int var0, long var1, Data var3, int var4) throws MdsException;

    private static native void updateSegment(int var0, long var1, int var3, Data var4, Data var5, Data var6) throws MdsException;

    private static native void beginTimestampedSegment(int var0, long var1, Data var3) throws MdsException;

    private static native void putTimestampedSegment(int var0, long var1, Data var3, long[] var4) throws MdsException;

    private static native void makeTimestampedSegment(int var0, long var1, Data var3, long[] var4) throws MdsException;

    private static native void putRow(int var0, long var1, Data var3, long var4, int var6) throws MdsException;

    private static native int getNumSegments(int var0, long var1) throws MdsException;

    private static native void acceptSegment(int var0, long var1, Data var3, Data var4) throws MdsException;

    private static native void acceptRow(int var0, long var1, Data var3, long var4) throws MdsException;

    private static native Data getSegmentStart(int var0, long var1, int var3) throws MdsException;

    private static native Data getSegmentEnd(int var0, long var1, int var3) throws MdsException;

    private static native Data getSegmentDim(int var0, long var1, int var3) throws MdsException;

    private static native Data getSegment(int var0, long var1, int var3) throws MdsException;

    private static native int addNode(int var0, long var1, java.lang.String var3, int var4) throws MdsException;

    private static native void deleteNode(int var0, long var1, java.lang.String var3) throws MdsException;

    private static native void renameNode(int var0, long var1, java.lang.String var3) throws MdsException;

    private static native void addTag(int var0, long var1, java.lang.String var3) throws MdsException;

    private static native void removeTag(int var0, long var1, java.lang.String var3) throws MdsException;

    private static native int addDevice(int var0, long var1, java.lang.String var3, java.lang.String var4) throws MdsException;

    private static native void setSubtree(int var0, long var1, boolean var3);

    private static native void moveNode(int var0, long var1, int var3, java.lang.String var4);

    private static native int doAction(int var0, long var1);

    public boolean isCompressOnPut() throws MdsException {
        this.resolveNid();
        return TreeNode.getNciFlag(this.nid, this.ctxTree.getCtx(), 1024);
    }

    public boolean isCompressible() throws MdsException {
        this.resolveNid();
        return TreeNode.getNciFlag(this.nid, this.ctxTree.getCtx(), 256);
    }

    public boolean isCompressSegments() throws MdsException {
        this.resolveNid();
        return TreeNode.getNciFlag(this.nid, this.ctxTree.getCtx(), 65536);
    }

    public void setCompressible(boolean flag) throws MdsException {
        this.resolveNid();
        TreeNode.setNciFlag(this.nid, this.ctxTree.getCtx(), 256, flag);
    }

    public void setCompressOnPut(boolean flag) throws MdsException {
        this.resolveNid();
        TreeNode.setNciFlag(this.nid, this.ctxTree.getCtx(), 1024, flag);
    }

    public void setCompressSegments(boolean flag) throws MdsException {
        this.resolveNid();
        TreeNode.setNciFlag(this.nid, this.ctxTree.getCtx(), 65536, flag);
    }

    public int getConglomerateElt() throws MdsException {
        this.resolveNid();
        return TreeNode.getNci(this.nid, this.ctxTree.getCtx(), 10);
    }

    public int getNumElts() throws MdsException {
        this.resolveNid();
        return TreeNode.getNci(this.nid, this.ctxTree.getCtx(), 32);
    }

    public int getFlags() throws MdsException {
        this.resolveNid();
        return TreeNode.getNci(this.nid, this.ctxTree.getCtx(), 12);
    }

    public TreeNodeArray getConglomerateNodes() throws MdsException {
        this.resolveNid();
        return new TreeNodeArray(TreeNode.getNciNids(this.nid, this.ctxTree.getCtx(), 32, 21), this.ctxTree);
    }

    public java.lang.String getOriginalPartName() throws MdsException {
        this.resolveNid();
        return TreeNode.getNciString(this.nid, this.ctxTree.getCtx(), 22);
    }

    public java.lang.String getDtype() throws MdsException {
        this.resolveNid();
        return TreeNode.getNciString(this.nid, this.ctxTree.getCtx(), 38);
    }

    public java.lang.String getDclass() throws MdsException {
        this.resolveNid();
        return TreeNode.getNciString(this.nid, this.ctxTree.getCtx(), 40);
    }

    public boolean isEssential() throws MdsException {
        this.resolveNid();
        return TreeNode.getNciFlag(this.nid, this.ctxTree.getCtx(), 4);
    }

    public void setEssential(boolean flag) throws MdsException {
        this.resolveNid();
        TreeNode.setNciFlag(this.nid, this.ctxTree.getCtx(), 4, flag);
    }

    public java.lang.String getFullPath() throws MdsException {
        this.resolveNid();
        return TreeNode.getNciString(this.nid, this.ctxTree.getCtx(), 27);
    }

    public java.lang.String getMinPath() throws MdsException {
        this.resolveNid();
        return TreeNode.getNciString(this.nid, this.ctxTree.getCtx(), 28);
    }

    public java.lang.String getPath() throws MdsException {
        this.resolveNid();
        return TreeNode.getNciString(this.nid, this.ctxTree.getCtx(), 14);
    }

    public java.lang.String getNodeName() throws MdsException {
        this.resolveNid();
        return TreeNode.getNciString(this.nid, this.ctxTree.getCtx(), 13).trim();
    }

    public boolean isIncludedInPulse() throws MdsException {
        return this.isIncludeInPulse();
    }

    public boolean isIncludeInPulse() throws MdsException {
        this.resolveNid();
        return TreeNode.getNciFlag(this.nid, this.ctxTree.getCtx(), 32768);
    }

    public void setIncludedInPulse(boolean flag) throws MdsException {
        this.setIncludeInPulse(flag);
    }

    public void setIncludeInPulse(boolean flag) throws MdsException {
        this.resolveNid();
        TreeNode.setNciFlag(this.nid, this.ctxTree.getCtx(), 32768, flag);
    }

    public int getDepth() throws MdsException {
        this.resolveNid();
        return TreeNode.getNci(this.nid, this.ctxTree.getCtx(), 15);
    }

    public boolean isChild() throws MdsException {
        this.resolveNid();
        int flags = TreeNode.getNci(this.nid, this.ctxTree.getCtx(), 20);
        return (flags & 1) != 0;
    }

    public TreeNode getChild() throws MdsException {
        this.resolveNid();
        return new TreeNode(TreeNode.getNci(this.nid, this.ctxTree.getCtx(), 19), this.ctxTree);
    }

    public int getNumChildren() throws MdsException {
        this.resolveNid();
        return TreeNode.getNci(this.nid, this.ctxTree.getCtx(), 24);
    }

    public TreeNodeArray getChildren() throws MdsException {
        this.resolveNid();
        return new TreeNodeArray(TreeNode.getNciNids(this.nid, this.ctxTree.getCtx(), 24, 26), this.ctxTree);
    }

    public boolean isMember() throws MdsException {
        this.resolveNid();
        int flags = TreeNode.getNci(this.nid, this.ctxTree.getCtx(), 20);
        return (flags & 2) != 0;
    }

    public TreeNode getMember() throws MdsException {
        this.resolveNid();
        return new TreeNode(TreeNode.getNci(this.nid, this.ctxTree.getCtx(), 18), this.ctxTree);
    }

    public int getNumMembers() throws MdsException {
        this.resolveNid();
        return TreeNode.getNci(this.nid, this.ctxTree.getCtx(), 23);
    }

    public TreeNodeArray getMembers() throws MdsException {
        this.resolveNid();
        return new TreeNodeArray(TreeNode.getNciNids(this.nid, this.ctxTree.getCtx(), 23, 25), this.ctxTree);
    }

    public int getNumDescendants() throws MdsException {
        return this.getNumMembers() + this.getNumChildren();
    }

    public TreeNodeArray getDescendants() throws MdsException {
        int i;
        this.resolveNid();
        int[] memberNids = TreeNode.getNciNids(this.nid, this.ctxTree.getCtx(), 23, 25);
        int[] childrenNids = TreeNode.getNciNids(this.nid, this.ctxTree.getCtx(), 24, 26);
        int[] descendantNids = new int[memberNids.length + childrenNids.length];
        for (i = 0; i < memberNids.length; ++i) {
            descendantNids[i] = memberNids[i];
        }
        for (i = 0; i < childrenNids.length; ++i) {
            descendantNids[memberNids.length + i] = childrenNids[i];
        }
        return new TreeNodeArray(descendantNids, this.ctxTree);
    }

    public TreeNode getParent() throws MdsException {
        this.resolveNid();
        return new TreeNode(TreeNode.getNci(this.nid, this.ctxTree.getCtx(), 16), this.ctxTree);
    }

    public TreeNode getBrother() throws MdsException {
        this.resolveNid();
        return new TreeNode(TreeNode.getNci(this.nid, this.ctxTree.getCtx(), 17), this.ctxTree);
    }

    public int getLength() throws MdsException {
        this.resolveNid();
        return TreeNode.getNci(this.nid, this.ctxTree.getCtx(), 8);
    }

    public int getCompressedLength() throws MdsException {
        this.resolveNid();
        return TreeNode.getNci(this.nid, this.ctxTree.getCtx(), 31);
    }

    public int getNid() throws MdsException {
        this.resolveNid();
        return this.nid;
    }

    public boolean isNoWriteModel() throws MdsException {
        this.resolveNid();
        return TreeNode.getNciFlag(this.nid, this.ctxTree.getCtx(), 2048);
    }

    public void setNoWriteModel(boolean noWriteModel) throws MdsException {
        this.resolveNid();
        TreeNode.setNciFlag(this.nid, this.ctxTree.getCtx(), 2048, noWriteModel);
    }

    public boolean isNoWriteShot() throws MdsException {
        this.resolveNid();
        return TreeNode.getNciFlag(this.nid, this.ctxTree.getCtx(), 4096);
    }

    public void setNoWriteShot(boolean noWriteShot) throws MdsException {
        this.resolveNid();
        TreeNode.setNciFlag(this.nid, this.ctxTree.getCtx(), 4096, noWriteShot);
    }

    public boolean isWriteOnce() throws MdsException {
        this.resolveNid();
        return TreeNode.getNciFlag(this.nid, this.ctxTree.getCtx(), 128);
    }

    public void setWriteOnce(boolean writeOnce) throws MdsException {
        this.resolveNid();
        TreeNode.setNciFlag(this.nid, this.ctxTree.getCtx(), 128, writeOnce);
    }

    public int getNciFlags() throws MdsException {
        this.resolveNid();
        return TreeNode.getNciFlags(this.nid, this.ctxTree.getCtx());
    }

    public void setNciFlags(int flags) throws MdsException {
        this.resolveNid();
        TreeNode.setNciFlags(this.nid, this.ctxTree.getCtx(), flags);
    }

    public boolean getNciFlag(int flagId) throws MdsException {
        this.resolveNid();
        return TreeNode.getNciFlag(this.nid, this.ctxTree.getCtx(), 1 << flagId);
    }

    public void setNciFlag(int flagId) throws MdsException {
        this.resolveNid();
        TreeNode.setNciFlag(this.nid, this.ctxTree.getCtx(), 1 << flagId, true);
    }

    public void clearNciFlag(int flagId) throws MdsException {
        this.resolveNid();
        TreeNode.setNciFlag(this.nid, this.ctxTree.getCtx(), 1 << flagId, false);
    }

    public boolean isOn() throws MdsException {
        this.resolveNid();
        return TreeNode.isOn(this.nid, this.ctxTree.getCtx());
    }

    public boolean isParentOff() throws MdsException {
        this.resolveNid();
        return TreeNode.isParentOff(this.nid, this.ctxTree.getCtx());
    }

    public void setExtendedAttribute(java.lang.String name, Data val) throws MdsException {
        this.resolveNid();
        TreeNode.setExtendedAttribute(this.nid, this.ctxTree.getCtx(), name, val);
    }

    public Data getExtendedAttribute(java.lang.String name) throws MdsException {
        this.resolveNid();
        return TreeNode.getExtendedAttribute(this.nid, this.ctxTree.getCtx(), name);
    }

    public void setOn(boolean on) throws MdsException {
        this.resolveNid();
        TreeNode.turnOn(this.nid, this.ctxTree.getCtx(), on);
    }

    public int getOwnerId() throws MdsException {
        this.resolveNid();
        return TreeNode.getNci(this.nid, this.ctxTree.getCtx(), 5);
    }

    public Data getData() throws MdsException {
        this.resolveNid();
        Data data = TreeNode.getData(this.nid, this.ctxTree.getCtx());
        data.setCtxTree(this.ctxTree);
        return data;
    }

    public void putData(Data data) throws MdsException {
        this.resolveNid();
        TreeNode.putData(this.nid, this.ctxTree.getCtx(), data);
    }

    public void deleteData() throws MdsException {
        this.resolveNid();
        TreeNode.deleteData(this.nid, this.ctxTree.getCtx());
    }

    public long getTimeInserted() throws MdsException {
        this.resolveNid();
        return TreeNode.getNciLong(this.nid, this.ctxTree.getCtx(), 4);
    }

    public void doMethod(java.lang.String method) throws MdsException {
        this.resolveNid();
        TreeNode.doMethod(this.nid, this.ctxTree.getCtx(), method);
    }

    public boolean isSetup() throws MdsException {
        this.resolveNid();
        return TreeNode.getNciFlag(this.nid, this.ctxTree.getCtx(), 64);
    }

    public int getStatus() throws MdsException {
        this.resolveNid();
        return TreeNode.getNci(this.nid, this.ctxTree.getCtx(), 9);
    }

    public java.lang.String getUsage() throws MdsException {
        this.resolveNid();
        int usage = TreeNode.getNci(this.nid, this.ctxTree.getCtx(), 29);
        switch (usage) {
            case 2: {
                return "ACTION";
            }
            case 0: {
                return "ANY";
            }
            case 10: {
                return "AXIS";
            }
            case 12: {
                return "COMPOUND_DATA";
            }
            case 3: {
                return "DEVICE";
            }
            case 4: {
                return "DISPATCH";
            }
            case 1: {
                return "STRUCTURE";
            }
            case 5: {
                return "NUMERIC";
            }
            case 6: {
                return "SIGNAL";
            }
            case 11: {
                return "SUBTREE";
            }
            case 7: {
                return "TASK";
            }
            case 8: {
                return "TEXT";
            }
            case 9: {
                return "WINDOW";
            }
        }
        return "";
    }

    public java.lang.String[] findTags() throws MdsException {
        this.resolveNid();
        return TreeNode.getTags(this.nid, this.ctxTree.getCtx());
    }

    public boolean containsVersions() throws MdsException {
        this.resolveNid();
        return TreeNode.getNciFlag(this.nid, this.ctxTree.getCtx(), 41);
    }

    public boolean isSegmented() throws MdsException {
        return this.getNumSegments() == 0;
    }

    public void beginSegment(Data start, Data end, Data dim, Array initData) throws MdsException {
        this.resolveNid();
        TreeNode.beginSegment(this.nid, this.ctxTree.getCtx(), start, end, dim, initData);
    }

    public void makeSegment(Data start, Data end, Data dim, Array initData) throws MdsException {
        this.resolveNid();
        int[] shape = initData.getShape();
        TreeNode.makeSegment(this.nid, this.ctxTree.getCtx(), start, end, dim, initData, shape[shape.length - 1]);
    }

    public void putSegment(Array data, int offset) throws MdsException {
        this.resolveNid();
        TreeNode.putSegment(this.nid, this.ctxTree.getCtx(), data, offset);
    }

    public void updateSegment(int segmentOffset, Data start, Data end, Data dim) throws MdsException {
        this.resolveNid();
        TreeNode.updateSegment(this.nid, this.ctxTree.getCtx(), segmentOffset, start, end, dim);
    }

    public void beginTimestampedSegment(Array initData) throws MdsException {
        this.resolveNid();
        TreeNode.beginTimestampedSegment(this.nid, this.ctxTree.getCtx(), initData);
    }

    public void putTimestampedSegment(Data data, long[] times) throws MdsException {
        this.resolveNid();
        TreeNode.putTimestampedSegment(this.nid, this.ctxTree.getCtx(), data, times);
    }

    public void makeTimestampedSegment(Data data, long[] times) throws MdsException {
        this.resolveNid();
        TreeNode.makeTimestampedSegment(this.nid, this.ctxTree.getCtx(), data, times);
    }

    public void putRow(Data row, long time, int size) throws MdsException {
        this.resolveNid();
        TreeNode.putRow(this.nid, this.ctxTree.getCtx(), row, time, size);
    }

    public void putRow(Data row, long time) throws MdsException {
        this.putRow(row, time, 1024);
    }

    public int getNumSegments() throws MdsException {
        this.resolveNid();
        return TreeNode.getNumSegments(this.nid, this.ctxTree.getCtx());
    }

    public Data getSegmentStart(int idx) throws MdsException {
        this.resolveNid();
        return TreeNode.getSegmentStart(this.nid, this.ctxTree.getCtx(), idx);
    }

    public Data getSegmentEnd(int idx) throws MdsException {
        this.resolveNid();
        return TreeNode.getSegmentEnd(this.nid, this.ctxTree.getCtx(), idx);
    }

    public Data getSegmentDim(int idx) throws MdsException {
        this.resolveNid();
        return TreeNode.getSegmentDim(this.nid, this.ctxTree.getCtx(), idx);
    }

    public Array getSegment(int idx) throws MdsException {
        this.resolveNid();
        return (Array)TreeNode.getSegment(this.nid, this.ctxTree.getCtx(), idx);
    }

    public Tree getTree() {
        return this.ctxTree;
    }

    public void setTree(Tree tree) {
        this.ctxTree = tree;
    }

    public TreeNode addNode(java.lang.String name, java.lang.String usage) throws MdsException {
        this.resolveNid();
        int newNid = TreeNode.addNode(this.nid, this.ctxTree.getCtx(), name, Tree.convertUsage(usage));
        return new TreeNode(newNid, this.ctxTree);
    }

    public void remove(java.lang.String name) throws MdsException {
        this.resolveNid();
        TreeNode defNode = this.ctxTree.getDefault();
        this.ctxTree.setDefault(this);
        TreeNode.deleteNode(this.nid, this.ctxTree.getCtx(), name);
        this.ctxTree.setDefault(defNode);
    }

    public void rename(java.lang.String newName) throws MdsException {
        this.resolveNid();
        TreeNode.renameNode(this.nid, this.ctxTree.getCtx(), newName);
    }

    public void move(TreeNode parent, java.lang.String newName) throws MdsException {
        this.resolveNid();
        TreeNode defNode = this.ctxTree.getDefault();
        this.ctxTree.setDefault(parent);
        TreeNode.moveNode(this.nid, this.ctxTree.getCtx(), parent.nid, newName);
        this.ctxTree.setDefault(defNode);
    }

    public void move(TreeNode parent) throws MdsException {
        this.resolveNid();
        TreeNode defNode = this.ctxTree.getDefault();
        this.ctxTree.setDefault(parent);
        TreeNode.moveNode(this.nid, this.ctxTree.getCtx(), parent.nid, this.getNodeName());
        this.ctxTree.setDefault(defNode);
    }

    public void addTag(java.lang.String tagName) throws MdsException {
        this.resolveNid();
        TreeNode.addTag(this.nid, this.ctxTree.getCtx(), tagName);
    }

    public void removeTag(java.lang.String tagName) throws MdsException {
        this.resolveNid();
        TreeNode.removeTag(this.nid, this.ctxTree.getCtx(), tagName);
    }

    public TreeNode addDevice(java.lang.String name, java.lang.String type) throws MdsException {
        this.resolveNid();
        int devNid = TreeNode.addDevice(this.nid, this.ctxTree.getCtx(), name, type);
        return new TreeNode(devNid, this.ctxTree);
    }

    public void setSubtree(boolean isSubtree) throws MdsException {
        this.resolveNid();
        TreeNode.setSubtree(this.nid, this.ctxTree.getCtx(), isSubtree);
    }

    public int doAction() throws MdsException {
        this.resolveNid();
        return TreeNode.doAction(this.nid, this.ctxTree.getCtx());
    }

    public void putData(byte d) throws MdsException {
        this.putData(new Int8(d));
    }

    public void putData(short d) throws MdsException {
        this.putData(new Int16(d));
    }

    public void putData(int d) throws MdsException {
        this.putData(new Int32(d));
    }

    public void putData(long d) throws MdsException {
        this.putData(new Int64(d));
    }

    public void putData(float d) throws MdsException {
        this.putData(new Float32(d));
    }

    public void putData(double d) throws MdsException {
        this.putData(new Float64(d));
    }

    public void putData(java.lang.String d) throws MdsException {
        this.putData(new String(d));
    }

    public void putData(byte[] d) throws MdsException {
        this.putData(new Int8Array(d));
    }

    public void putData(short[] d) throws MdsException {
        this.putData(new Int16Array(d));
    }

    public void putData(int[] d) throws MdsException {
        this.putData(new Int32Array(d));
    }

    public void putData(long[] d) throws MdsException {
        this.putData(new Int64Array(d));
    }

    public void putData(float[] d) throws MdsException {
        this.putData(new Float32Array(d));
    }

    public void putData(double[] d) throws MdsException {
        this.putData(new Float64Array(d));
    }

    public void putData(java.lang.String[] d) throws MdsException {
        this.putData(new StringArray(d));
    }
}

