/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class DeviceOutputs
extends DeviceComponent {
    private JScrollPane scrollP;
    private int numOutputs;
    private JTextField[] segLensTF;
    private JTextField[] streamNamesTF;
    private int[] segLenNids;
    private int[] streamNameNids;
    private int numOutputChildren = 0;
    private int numItems;

    @Override
    protected void initializeData(String data, boolean is_on) {
        this.mode = 3;
        int currNid = this.baseNid + this.offsetNid;
        try {
            this.numOutputs = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currNid) + ",'NUMBER_OF_CHILDREN')");
        }
        catch (Exception exc) {
            this.numOutputs = 0;
        }
        int currOutNid = currNid + 7;
        this.numItems = 0;
        for (int outIdx = 0; outIdx < this.numOutputs; ++outIdx) {
            int numFields;
            int numPars;
            int numMembers;
            int numChildren;
            try {
                numChildren = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currOutNid) + ",'NUMBER_OF_CHILDREN')");
                numMembers = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currOutNid) + ",'NUMBER_OF_MEMBERS')");
                numPars = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currOutNid) + ":PARAMETERS,'NUMBER_OF_CHILDREN')");
            }
            catch (Exception exc) {
                System.out.println("Error getting Output fields");
                this.numOutputs = 0;
                break;
            }
            try {
                numFields = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currOutNid) + ":FIELDS,'NUMBER_OF_CHILDREN')");
            }
            catch (Exception exc) {
                numFields = 0;
            }
            this.numItems = numFields == 0 ? ++this.numItems : (this.numItems += numFields);
            currOutNid += 1 + numChildren + numMembers + 2 * numPars + 8 * numFields;
        }
        this.segLensTF = new JTextField[this.numItems];
        this.streamNamesTF = new JTextField[this.numItems];
        this.segLenNids = new int[this.numItems];
        this.streamNameNids = new int[this.numItems];
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(this.numItems, 1));
        currOutNid = currNid + 7;
        int currItem = 0;
        for (int outIdx = 0; outIdx < this.numOutputs; ++outIdx) {
            int numFields;
            int numPars;
            int numMembers;
            int numChildren;
            try {
                numChildren = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currOutNid) + ",'NUMBER_OF_CHILDREN')");
                numMembers = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currOutNid) + ",'NUMBER_OF_MEMBERS')");
                numPars = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currOutNid) + ":PARAMETERS,'NUMBER_OF_CHILDREN')");
            }
            catch (Exception exc) {
                System.out.println("Error getting Output fields");
                this.numOutputs = 0;
                break;
            }
            try {
                numFields = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currOutNid) + ":FIELDS,'NUMBER_OF_CHILDREN')");
            }
            catch (Exception exc) {
                numFields = 0;
            }
            String outName = "";
            try {
                outName = this.subtree.getString(this.subtree.getDataExpr(currOutNid + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (numFields == 0) {
                JPanel jp1 = new JPanel();
                jp1.setBorder(new TitledBorder(outName));
                jp1.setLayout(new GridLayout(1, 2));
                jp1.add(new JLabel("Segment len.: "));
                this.segLensTF[currItem] = new JTextField(10);
                jp1.add(this.segLensTF[currItem]);
                jp1.add(new JLabel("Stream name: "));
                this.streamNamesTF[currItem] = new JTextField(10);
                jp1.add(this.streamNamesTF[currItem]);
                jp.add(jp1);
                this.segLenNids[currItem] = currOutNid + 5;
                this.streamNameNids[currItem] = currOutNid + 6;
                ++currItem;
            } else {
                for (int fieldIdx = 0; fieldIdx < numFields; ++fieldIdx) {
                    int fieldNid = currOutNid + numChildren + numMembers + 1 + 2 * numPars + 8 * fieldIdx;
                    this.segLenNids[currItem] = fieldNid + 5;
                    this.streamNameNids[currItem] = fieldNid + 6;
                    String fieldName = "";
                    try {
                        fieldName = this.subtree.getString(this.subtree.getDataExpr(fieldNid + 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    JPanel jp1 = new JPanel();
                    jp1.setBorder(new TitledBorder(outName + '.' + fieldName));
                    jp1.setLayout(new GridLayout(1, 2));
                    jp1.add(new JLabel("Segment len.: "));
                    this.segLensTF[currItem] = new JTextField(10);
                    jp1.add(this.segLensTF[currItem]);
                    jp1.add(new JLabel("Stream name: "));
                    this.streamNamesTF[currItem] = new JTextField(10);
                    jp1.add(this.streamNamesTF[currItem]);
                    jp.add(jp1);
                    ++currItem;
                }
            }
            currOutNid += 1 + numChildren + numMembers + 2 * numPars + 8 * numFields;
        }
        this.scrollP = new JScrollPane(jp);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollP, "Center");
        this.displayData(data, is_on);
    }

    @Override
    protected void displayData(String data, boolean is_on) {
        for (int idx = 0; idx < this.numItems; ++idx) {
            try {
                this.segLensTF[idx].setText(this.subtree.getDataExpr(this.segLenNids[idx]));
            }
            catch (Exception exc) {
                this.segLensTF[idx].setText("");
            }
            try {
                this.streamNamesTF[idx].setText(this.subtree.getString(this.subtree.getDataExpr(this.streamNameNids[idx])));
                continue;
            }
            catch (Exception exc) {
                this.streamNamesTF[idx].setText("");
            }
        }
    }

    @Override
    protected String getData() {
        return null;
    }

    @Override
    protected boolean getState() {
        return true;
    }

    @Override
    public void apply() throws Exception {
        for (int idx = 0; idx < this.numItems; ++idx) {
            try {
                this.subtree.putDataExpr(this.segLenNids[idx], this.segLensTF[idx].getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String name = this.streamNamesTF[idx].getText();
                this.subtree.putDataExpr(this.streamNameNids[idx], "\"" + this.streamNamesTF[idx].getText() + "\"");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

