/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class DeviceInputs
extends DeviceComponent {
    private JScrollPane scrollP;
    private int numInputs;
    private JTextField[] valuesTF;
    private JTextField[][] fieldsTF;
    private JLabel[] labels;
    int[] numParameters;
    int[] numFields;
    private int numInputChildren = 0;

    @Override
    protected void initializeData(String data, boolean is_on) {
        this.mode = 3;
        int currNid = this.baseNid;
        try {
            currNid = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(this.baseNid) + ".INPUTS, 'NID_NUMBER')");
        }
        catch (Exception exc) {
            this.numInputs = 0;
        }
        this.offsetNid = currNid - this.baseNid;
        try {
            this.numInputs = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currNid) + ",'NUMBER_OF_CHILDREN')");
        }
        catch (Exception exc) {
            this.numInputs = 0;
        }
        this.valuesTF = new JTextField[this.numInputs];
        this.labels = new JLabel[this.numInputs];
        this.fieldsTF = new JTextField[this.numInputs][];
        this.numParameters = new int[this.numInputs];
        this.numFields = new int[this.numInputs];
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(this.numInputs, 1));
        int currInputNid = currNid + 1;
        try {
            int children = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currInputNid) + ",'NUMBER_OF_CHILDREN')");
            int members = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currInputNid) + ",'NUMBER_OF_MEMBERS')");
            this.numInputChildren = children + members;
        }
        catch (Exception exc) {
            System.out.println("Error getting number of input children");
        }
        for (int i = 0; i < this.numInputs; ++i) {
            String inputName;
            try {
                this.numParameters[i] = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currInputNid + 6) + ",'NUMBER_OF_CHILDREN')");
            }
            catch (Exception exc) {
                this.numParameters[i] = 0;
            }
            if (this.numInputChildren == 6) {
                this.numFields[i] = 0;
            } else {
                try {
                    this.numFields[i] = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currInputNid + 7 + this.numParameters[i]) + ",'NUMBER_OF_CHILDREN')");
                }
                catch (Exception exc) {
                    this.numFields[i] = 0;
                }
            }
            this.fieldsTF[i] = new JTextField[this.numFields[i]];
            try {
                inputName = this.subtree.getString(this.subtree.getDataExpr(currInputNid + 5));
            }
            catch (Exception exc) {
                inputName = "";
            }
            JPanel jp1 = new JPanel();
            TitledBorder titledBorder = new TitledBorder(inputName);
            titledBorder.setTitleColor(Color.red);
            jp1.setBorder(titledBorder);
            jp1.setLayout(new GridLayout(1 + this.numFields[i], 1));
            JPanel jp2 = new JPanel();
            jp2.setLayout(new BorderLayout());
            this.valuesTF[i] = new JTextField();
            jp2.add((Component)this.valuesTF[i], "Center");
            jp1.add(jp2);
            for (int fieldIdx = 0; fieldIdx < this.numFields[i]; ++fieldIdx) {
                String fieldName;
                try {
                    fieldName = this.subtree.getString(this.subtree.getDataExpr(currInputNid + 8 + 2 * this.numParameters[i] + 6 * fieldIdx + 4));
                }
                catch (Exception exc) {
                    fieldName = "";
                }
                jp2 = new JPanel();
                jp2.setLayout(new BorderLayout());
                jp2.setBorder(new TitledBorder(inputName + "." + fieldName));
                JTextField jTextField = new JTextField();
                this.fieldsTF[i][fieldIdx] = jTextField;
                jp2.add((Component)jTextField, "Center");
                jp1.add(jp2);
            }
            currInputNid += this.numInputChildren + 1 + 2 * this.numParameters[i] + 6 * this.numFields[i];
            jp.add(jp1);
        }
        this.scrollP = new JScrollPane(jp);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollP, "Center");
        this.displayData(data, is_on);
    }

    @Override
    protected void displayData(String data, boolean is_on) {
        int currInputNid = this.baseNid + this.offsetNid + 1;
        for (int inputIdx = 0; inputIdx < this.numInputs; ++inputIdx) {
            try {
                this.valuesTF[inputIdx].setText(this.subtree.getDataExpr(currInputNid + 4));
            }
            catch (Exception exc) {
                this.valuesTF[inputIdx].setText("");
            }
            for (int fieldIdx = 0; fieldIdx < this.numFields[inputIdx]; ++fieldIdx) {
                try {
                    this.fieldsTF[inputIdx][fieldIdx].setText(this.subtree.getDataExpr(currInputNid + 8 + 2 * this.numParameters[inputIdx] + 6 * fieldIdx + 5));
                    continue;
                }
                catch (Exception exc) {
                    this.fieldsTF[inputIdx][fieldIdx].setText("");
                }
            }
            currInputNid += this.numInputChildren + 1 + 2 * this.numParameters[inputIdx] + 6 * this.numFields[inputIdx];
        }
    }

    @Override
    protected String getData() {
        return null;
    }

    @Override
    protected boolean getState() {
        return true;
    }

    @Override
    public void apply() throws Exception {
        int currInputNid = this.baseNid + this.offsetNid + 1;
        for (int inputIdx = 0; inputIdx < this.numInputs; ++inputIdx) {
            try {
                int children = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currInputNid) + ",'NUMBER_OF_CHILDREN')");
                int members = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currInputNid) + ",'NUMBER_OF_MEMBERS')");
                this.numInputChildren = children + members;
            }
            catch (Exception exc) {
                System.out.println("Error getting number of input children");
            }
            try {
                this.subtree.putDataExpr(currInputNid + 4, this.valuesTF[inputIdx].getText());
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(null, "" + exc, "Error in input field " + inputIdx, 2);
            }
            for (int fieldIdx = 0; fieldIdx < this.numFields[inputIdx]; ++fieldIdx) {
                try {
                    this.subtree.putDataExpr(currInputNid + 8 + 2 * this.numParameters[inputIdx] + 6 * fieldIdx + 5, this.fieldsTF[inputIdx][fieldIdx].getText());
                    continue;
                }
                catch (Exception exc) {
                    JOptionPane.showMessageDialog(null, "" + exc, "Error in subfield of input field " + inputIdx, 2);
                }
            }
            currInputNid += this.numInputChildren + 1 + 2 * this.numParameters[inputIdx] + 6 * this.numFields[inputIdx];
        }
    }
}

