/*
 * Decompiled with CFR 0.152.
 */
package MDSplus;

import MDSplus.Array;
import MDSplus.Data;
import MDSplus.Dictionary;
import MDSplus.GetMany;
import MDSplus.List;
import MDSplus.MdsException;
import MDSplus.PutMany;
import MDSplus.Scalar;
import MDSplus.String;
import MDSplus.Uint8Array;

public class Connection {
    boolean isConnected = false;
    int sockId;
    java.lang.String mdsipAddr;

    boolean checkArgs(Data[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof Scalar || args[i] instanceof Array) continue;
            return false;
        }
        return true;
    }

    public Connection() {
    }

    public Connection(java.lang.String mdsipAddr) throws MdsException {
        this.initialize(mdsipAddr);
    }

    public void initialize(java.lang.String mdsipAddr) throws MdsException {
        this.mdsipAddr = mdsipAddr;
        this.sockId = this.connectToMds(mdsipAddr);
        if (this.sockId < 0) {
            throw new MdsException("Cannot connect to " + mdsipAddr);
        }
        this.isConnected = true;
    }

    protected void finalize() {
        if (this.sockId >= 0) {
            this.disconnectFromMds(this.sockId);
        }
        this.isConnected = false;
    }

    public void openTree(java.lang.String name, int shot) throws MdsException {
        this.openTree(this.sockId, name, shot);
    }

    public void closeAllTree() throws MdsException {
        this.closeTree(this.sockId);
    }

    public void closeTree(java.lang.String name, int shot) throws MdsException {
        this.closeTree(this.sockId);
    }

    public void setDefault(java.lang.String path) throws MdsException {
        this.setDefault(this.sockId, path);
    }

    public Data get(java.lang.String expr, Data[] args) throws MdsException {
        if (!this.checkArgs(args)) {
            throw new MdsException("Invalid arguments: only scalars and arrays arguments can be passed to COnnection.get()");
        }
        return this.get(this.sockId, expr, args);
    }

    public Data get(java.lang.String expr) throws MdsException {
        return this.get(expr, new Data[0]);
    }

    public void put(java.lang.String path, java.lang.String expr, Data[] args) throws MdsException {
        if (!this.checkArgs(args)) {
            throw new MdsException("Invalid arguments: only scalars and arrays arguments can be passed to COnnection.put()");
        }
        this.put(this.sockId, path, expr, args);
    }

    public void put(java.lang.String path, java.lang.String expr) throws MdsException {
        this.put(path, expr, new Data[0]);
    }

    public void put(java.lang.String path, Data data) throws MdsException {
        this.put(path, "$", new Data[]{data});
    }

    native int connectToMds(java.lang.String var1);

    native void disconnectFromMds(int var1);

    public native void openTree(int var1, java.lang.String var2, int var3) throws MdsException;

    public native void closeTree(int var1) throws MdsException;

    public native void setDefault(int var1, java.lang.String var2) throws MdsException;

    public native Data get(int var1, java.lang.String var2, Data[] var3) throws MdsException;

    public native void put(int var1, java.lang.String var2, java.lang.String var3, Data[] var4) throws MdsException;

    public GetMany getMany() {
        return new GetManyInConnection();
    }

    public PutMany putMany() {
        return new PutManyInConnection();
    }

    static {
        try {
            boolean loaded = false;
            try {
                java.lang.String value = System.getenv("JavaMdsLib");
                if (value == null) {
                    value = System.getProperty("JavaMdsLib");
                }
                if (value != null) {
                    System.load(value);
                    loaded = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!loaded) {
                System.loadLibrary("JavaMds");
            }
        }
        catch (Throwable e) {
            System.out.println("Error loading library javamds: " + e);
            e.printStackTrace();
        }
    }

    class PutManyInConnection
    extends List
    implements PutMany {
        Dictionary evalRes;

        PutManyInConnection() {
        }

        public void insert(int idx, java.lang.String path, java.lang.String expr, Data[] args) {
            Dictionary dict = new Dictionary();
            dict.setItem(new String("exp"), new String(expr));
            dict.setItem(new String("node"), new String(path));
            dict.setItem(new String("args"), new List(args));
            try {
                this.insert(idx, dict);
            }
            catch (Exception exc) {
                System.out.println("INTERNAL ERROR: GetMany insertion outsize List limits");
            }
        }

        @Override
        public void append(java.lang.String path, java.lang.String expr, Data[] args) {
            this.insert(this.len(), path, expr, args);
        }

        @Override
        public void insert(java.lang.String prevPath, java.lang.String path, java.lang.String expr, Data[] args) {
            int idx;
            for (idx = 0; idx < this.len() && !this.getElementAt(idx).equals(new String(prevPath)); ++idx) {
            }
            this.insert(idx, path, expr, args);
        }

        @Override
        public void remove(java.lang.String path) {
            String pathStr = new String(path);
            String nodeKeyStr = new String("node");
            for (int i = 0; i < this.len(); ++i) {
                Dictionary currDict = (Dictionary)this.getElementAt(i);
                if (!currDict.getItem(nodeKeyStr).equals(pathStr)) continue;
                this.remove(i);
                return;
            }
        }

        @Override
        public void execute() throws MdsException {
            Uint8Array serializedIn = new Uint8Array(this.serialize());
            Data serializedOut = Connection.this.get("PutManyExecute($)", new Data[]{serializedIn});
            this.evalRes = (Dictionary)Data.deserialize(serializedOut.getByteArray());
        }

        @Override
        public void checkStatus(java.lang.String path) throws MdsException {
            if (this.evalRes == null) {
                throw new MdsException("PutMany not executed yet");
            }
            String retMsg = (String)this.evalRes.getItem(new String(path));
            if (!retMsg.equals(new String("Success"))) {
                throw new MdsException(retMsg.getString());
            }
        }
    }

    class GetManyInConnection
    extends List
    implements GetMany {
        Dictionary evalRes;

        GetManyInConnection() {
        }

        public void insert(int idx, java.lang.String name, java.lang.String expr, Data[] args) {
            Dictionary dict = new Dictionary();
            dict.setItem(new String("exp"), new String(expr));
            dict.setItem(new String("name"), new String(name));
            dict.setItem(new String("args"), new List(args));
            try {
                this.insert(idx, dict);
            }
            catch (Exception exc) {
                System.out.println("INTERNAL ERROR: GetMany insertion outsize List limits");
            }
        }

        @Override
        public void append(java.lang.String name, java.lang.String expr, Data[] args) {
            this.insert(this.len(), name, expr, args);
        }

        @Override
        public void insert(java.lang.String prevName, java.lang.String name, java.lang.String expr, Data[] args) {
            int idx;
            for (idx = 0; idx < this.len() && !this.getElementAt(idx).equals(new String(prevName)); ++idx) {
            }
            this.insert(idx, name, expr, args);
        }

        @Override
        public void remove(java.lang.String name) {
            String nameStr = new String(name);
            String nameKeyStr = new String("name");
            for (int i = 0; i < this.len(); ++i) {
                Dictionary currDict = (Dictionary)this.getElementAt(i);
                if (!currDict.getItem(nameKeyStr).equals(nameStr)) continue;
                this.remove(i);
                return;
            }
        }

        @Override
        public void execute() throws MdsException {
            Uint8Array serializedIn = new Uint8Array(this.serialize());
            Data serializedOut = Connection.this.get("GetManyExecute($)", new Data[]{serializedIn});
            this.evalRes = (Dictionary)Data.deserialize(serializedOut.getByteArray());
        }

        @Override
        public Data get(java.lang.String name) throws MdsException {
            if (this.evalRes == null) {
                throw new MdsException("GetMany expressions not evaluated yet");
            }
            Dictionary currDict = (Dictionary)this.evalRes.getItem(new String(name));
            Data retData = currDict.getItem(new String("value"));
            if (retData == null) {
                throw new MdsException(currDict.getItem(new String("error")).getString());
            }
            return retData;
        }
    }
}

