/*
 * Decompiled with CFR 0.152.
 */
package mds.jscope;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import mds.connection.ConnectionListener;
import mds.connection.UpdateEventListener;
import mds.jscope.MdsWaveInterface;
import mds.jscope.jScopeBrowseSignals;
import mds.jscope.jScopeDefaultValues;
import mds.jscope.jScopeFacade;
import mds.jscope.jScopeMultiWave;
import mds.provider.MdsDataProvider;
import mds.wave.ColorMapDialog;
import mds.wave.DataProvider;
import mds.wave.DataServerItem;
import mds.wave.Signal;
import mds.wave.WaveContainerEvent;
import mds.wave.WaveInterface;
import mds.wave.Waveform;
import mds.wave.WaveformContainer;
import mds.wave.WaveformEvent;

class jScopeWaveContainer
extends WaveformContainer
implements Printable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_COLUMN = 4;
    DataProvider dp;
    private final jScopeDefaultValues def_vals;
    private String title = null;
    private DataServerItem server_item = null;
    private String event = null;
    private String print_event = null;
    private int columns;
    private UpdW updateThread;
    private boolean abort;
    private boolean add_sig = false;
    private long[] main_shots = null;
    private String main_shot_str = null;
    private String main_shot_error = null;
    jScopeMultiWave[] wave_all;
    private String save_as_txt_directory = null;
    private jScopeBrowseSignals browse_sig = null;
    private String prev_add_signal = null;
    private final Object mainShotLock = new Object();
    ProgressMonitor progressMonitor;

    public jScopeWaveContainer(int[] rows, DataProvider dp, jScopeDefaultValues def_vals) {
        super(rows, false);
        this.def_vals = def_vals;
        this.dp = dp;
        Component[] c = this.CreateWaveComponents(this.getComponentNumber());
        this.AddComponents(c);
        this.updateThread = new UpdW();
        this.updateThread.start();
        this.setBackground(Color.white);
        this.save_as_txt_directory = System.getProperty("jScope.curr_directory");
    }

    public jScopeWaveContainer(int[] rows, jScopeDefaultValues def_vals) {
        this(rows, DataServerItem.NotConnected, def_vals);
        this.server_item = new DataServerItem();
    }

    public void AbortUpdate() {
        this.abort = true;
    }

    public synchronized void AddAllEvents(UpdateEventListener l) throws IOException {
        if (this.dp == null) {
            return;
        }
        if (this.event != null && this.event.length() != 0) {
            this.dp.addUpdateEventListener(l, this.event);
        }
        if (this.print_event != null && this.print_event.length() != 0) {
            this.dp.addUpdateEventListener(l, this.print_event);
        }
        int k = 0;
        for (int i = 0; i < 4; ++i) {
            int j = 0;
            while (j < this.getComponentsInColumn(i)) {
                jScopeMultiWave w = (jScopeMultiWave)this.getGridComponent(k);
                w.AddEvent();
                ++j;
                ++k;
            }
        }
    }

    private String AddRemoveEvent(UpdateEventListener l, String curr_event, String event) throws IOException {
        if (curr_event != null && curr_event.length() != 0) {
            if (event == null || event.length() == 0) {
                this.dp.removeUpdateEventListener(l, curr_event);
                return null;
            }
            if (!curr_event.equals(event)) {
                this.dp.removeUpdateEventListener(l, curr_event);
                this.dp.addUpdateEventListener(l, event);
            }
            return event;
        }
        if (event != null && event.length() != 0) {
            this.dp.addUpdateEventListener(l, event);
        }
        return event;
    }

    public void AddSignal(String expr, boolean check_prev_signal) {
        if (!(expr == null || expr.length() == 0 || check_prev_signal && (!check_prev_signal || this.prev_add_signal != null && this.prev_add_signal.equals(expr)))) {
            this.prev_add_signal = expr;
            this.AddSignal(null, null, "", expr, false, false);
        }
    }

    public void AddSignal(String tree, String shot, String x_expr, String y_expr, boolean with_error, boolean is_image) {
        String[] x = new String[1];
        String[] y = new String[1];
        x[0] = x_expr;
        y[0] = y_expr;
        this.AddSignals(tree, shot, x, y, with_error, is_image);
    }

    public void AddSignals(String tree, String shot, String[] x_expr, String[] y_expr, boolean with_error, boolean is_image) {
        MdsWaveInterface new_wi = null;
        jScopeMultiWave sel_wave = (jScopeMultiWave)this.GetSelectPanel();
        if (sel_wave.wi == null || is_image) {
            sel_wave.wi = new MdsWaveInterface(sel_wave, this.dp, this.def_vals);
            sel_wave.wi.SetAsImage(is_image);
            if (!with_error) {
                ((MdsWaveInterface)sel_wave.wi).prev_wi = new MdsWaveInterface(sel_wave, this.dp, this.def_vals);
            }
        } else {
            new_wi = new MdsWaveInterface((MdsWaveInterface)sel_wave.wi);
            new_wi.wave = sel_wave;
            if (!with_error) {
                new_wi.prev_wi = (MdsWaveInterface)sel_wave.wi;
            }
            sel_wave.wi = new_wi;
        }
        if (tree != null && (((MdsWaveInterface)sel_wave.wi).cexperiment == null || ((MdsWaveInterface)sel_wave.wi).cexperiment.trim().length() == 0)) {
            ((MdsWaveInterface)sel_wave.wi).cexperiment = new String(tree);
            ((MdsWaveInterface)sel_wave.wi).defaults &= 0xFFFFFF7F;
        }
        if (shot != null && (((MdsWaveInterface)sel_wave.wi).cin_shot == null || ((MdsWaveInterface)sel_wave.wi).cin_shot.trim().length() == 0)) {
            ((MdsWaveInterface)sel_wave.wi).cin_shot = new String(shot);
            ((MdsWaveInterface)sel_wave.wi).defaults &= 0xFFFFFEFF;
        }
        if (sel_wave.wi.AddSignals(x_expr, y_expr)) {
            this.add_sig = true;
            this.Refresh(sel_wave, "Add signal to");
            this.update();
            this.add_sig = false;
        }
    }

    public DataServerItem buildDataServerItem(Properties pr, String prompt) {
        if (pr == null) {
            return null;
        }
        String name = pr.getProperty(prompt + ".data_server_name");
        if (name == null) {
            return null;
        }
        String argument = pr.getProperty(prompt + ".data_server_argument");
        String user = pr.getProperty(prompt + ".data_server_user");
        String class_name = pr.getProperty(prompt + ".data_server_class");
        String browse_class = pr.getProperty(prompt + ".data_server_browse_class");
        String browse_url = pr.getProperty(prompt + ".data_server_browse_url");
        String tunnel_port = pr.getProperty(prompt + ".data_server_tunnel_port");
        return new DataServerItem(name, argument, user, class_name, browse_class, browse_url, tunnel_port);
    }

    protected jScopeMultiWave BuildjScopeMultiWave(DataProvider dp, jScopeDefaultValues def_vals) {
        return new jScopeMultiWave(dp, def_vals);
    }

    public void ChangeDataProvider(DataProvider dp) {
        this.main_shot_str = null;
        for (int i = 0; i < this.getGridComponentCount(); ++i) {
            jScopeMultiWave w = (jScopeMultiWave)this.GetWavePanel(i);
            if (w == null) continue;
            if (w.wi != null) {
                w.wi.SetDataProvider(dp);
            }
            w.Erase();
            w.SetTitle(null);
        }
    }

    private boolean checkIpMask(String ip, String Mask) {
        boolean found = false;
        StringTokenizer tokenLocalIp = new StringTokenizer(ip, ".");
        StringTokenizer clientMaskIp = new StringTokenizer(Mask, ".");
        if (tokenLocalIp.countTokens() != clientMaskIp.countTokens()) {
            return false;
        }
        while (tokenLocalIp.hasMoreElements() && clientMaskIp.hasMoreTokens()) {
            String tm;
            String tl = tokenLocalIp.nextToken();
            if (tl.equals(tm = clientMaskIp.nextToken()) || tm.equals("*")) {
                found = true;
                continue;
            }
            found = false;
            break;
        }
        return found;
    }

    @Override
    protected Component[] CreateWaveComponents(int num) {
        Component[] c = new Component[num];
        jScopeMultiWave wave = null;
        for (int i = 0; i < c.length; ++i) {
            wave = this.BuildjScopeMultiWave(this.dp, this.def_vals);
            wave.addWaveformListener(this);
            this.SetWaveParams(wave);
            c[i] = wave;
        }
        return c;
    }

    public DataServerItem DataServerFromClient(DataServerItem dataServerIn) {
        int c = 0;
        boolean found = false;
        DataServerItem out = null;
        try {
            StringTokenizer st;
            String clientMask;
            InetAddress dsiInet;
            String disIpAdddress;
            InetAddress localaddr = InetAddress.getLocalHost();
            String localIpAdddress = localaddr.getHostAddress();
            if (dataServerIn != null && !dataServerIn.getClassName().equals(MdsDataProvider.class.getName())) {
                return null;
            }
            if (dataServerIn != null && !this.checkIpMask(disIpAdddress = (dsiInet = InetAddress.getByName(dataServerIn.getArgument())).getHostAddress(), clientMask = (st = new StringTokenizer(localIpAdddress, ".")).nextToken() + "." + st.nextToken() + ".*.*")) {
                return dataServerIn;
            }
            if (new File(jScopeFacade.JSCOPE_SERVERS).exists()) {
                String prompt;
                Properties srvFromClientProp = new Properties();
                FileInputStream fis = new FileInputStream(jScopeFacade.JSCOPE_SERVERS);
                srvFromClientProp.load(fis);
                fis.close();
                while ((clientMask = srvFromClientProp.getProperty((prompt = "jScope.server_from_client_" + ++c) + ".client_mask")) != null) {
                    if (!this.checkIpMask(localIpAdddress, clientMask)) continue;
                    out = this.buildDataServerItem(srvFromClientProp, prompt);
                }
            }
        }
        catch (Exception exc) {
            out = null;
        }
        return out;
    }

    public void EraseAllWave() {
        for (int i = 0; i < this.getComponentNumber(); ++i) {
            jScopeMultiWave w = (jScopeMultiWave)this.getGridComponent(i);
            if (w == null) continue;
            w.Erase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EvaluateMainShot(String in_shots) throws IOException {
        long[] long_data = null;
        Object object = this.mainShotLock;
        synchronized (object) {
            this.main_shot_error = null;
            this.main_shots = null;
            this.main_shot_str = null;
            if (in_shots == null || in_shots.trim().length() == 0) {
                this.main_shot_error = "Main shot value Undefine";
                return;
            }
            long_data = WaveInterface.GetShotArray(in_shots, this.def_vals.experiment_str, this.dp);
            if (this.main_shot_error == null) {
                this.main_shots = long_data;
            }
            this.main_shot_str = in_shots.trim();
        }
    }

    public void FromFile(Properties pr, String prompt, int[] colorMapping, ColorMapDialog cmd) throws IOException {
        int i;
        int v;
        int c;
        int[] read_rows = new int[]{0, 0, 0, 0};
        this.resetMaximizeComponent();
        String prop = pr.getProperty(prompt + ".columns");
        if (prop == null) {
            throw new IOException("missing columns keyword");
        }
        this.columns = Integer.parseInt(prop);
        this.pw = new float[4];
        this.title = pr.getProperty(prompt + ".title");
        this.event = pr.getProperty(prompt + ".update_event");
        this.print_event = pr.getProperty(prompt + ".print_event");
        this.server_item = this.buildDataServerItem(pr, prompt);
        DataServerItem server_item_conf = this.DataServerFromClient(this.server_item);
        if (server_item_conf != null) {
            this.server_item = server_item_conf;
        }
        for (c = 1; c <= 4; ++c) {
            int r;
            prop = pr.getProperty(prompt + ".rows_in_column_" + c);
            if (prop == null) {
                if (c != 1) break;
                throw new IOException("missing rows_in_column_1 keyword");
            }
            read_rows[c - 1] = r = Integer.parseInt(prop);
        }
        if (this.columns > 1) {
            for (c = 1; c < this.columns; ++c) {
                prop = pr.getProperty(prompt + ".vpane_" + c);
                if (prop == null) {
                    throw new IOException("missing vpane_" + c + " keyword");
                }
                int w = Integer.parseInt(prop);
                this.pw[c - 1] = w;
            }
        }
        this.reversed = (prop = pr.getProperty(prompt + ".reversed")) != null ? new Boolean(prop) : false;
        this.def_vals.xmax = pr.getProperty(prompt + ".global_1_1.xmax");
        this.def_vals.xmin = pr.getProperty(prompt + ".global_1_1.xmin");
        this.def_vals.xlabel = pr.getProperty(prompt + ".global_1_1.x_label");
        this.def_vals.ymax = pr.getProperty(prompt + ".global_1_1.ymax");
        this.def_vals.ymin = pr.getProperty(prompt + ".global_1_1.ymin");
        this.def_vals.ylabel = pr.getProperty(prompt + ".global_1_1.y_label");
        this.def_vals.experiment_str = pr.getProperty(prompt + ".global_1_1.experiment");
        this.def_vals.title_str = pr.getProperty(prompt + ".global_1_1.title");
        this.def_vals.upd_event_str = pr.getProperty(prompt + ".global_1_1.event");
        this.def_vals.def_node_str = pr.getProperty(prompt + ".global_1_1.default_node");
        prop = pr.getProperty(prompt + ".global_1_1.horizontal_offset");
        if (prop != null) {
            v = 0;
            try {
                v = Integer.parseInt(prop);
            }
            catch (NumberFormatException w) {
                // empty catch block
            }
            Waveform.SetHorizontalOffset(v);
        }
        if ((prop = pr.getProperty(prompt + ".global_1_1.vertical_offset")) != null) {
            v = 0;
            try {
                v = Integer.parseInt(prop);
            }
            catch (NumberFormatException w) {
                // empty catch block
            }
            Waveform.SetVerticalOffset(v);
        }
        if ((prop = pr.getProperty(prompt + ".global_1_1.shot")) != null) {
            this.def_vals.shot_str = prop.indexOf("_shots") != -1 ? prop.substring(prop.indexOf("[") + 1, prop.indexOf("]")) : prop;
            this.def_vals.setIsEvaluated(false);
        }
        this.ResetDrawPanel(read_rows);
        int k = 0;
        for (int c2 = 0; c2 < 4; ++c2) {
            for (int r = 0; r < read_rows[c2]; ++r) {
                jScopeMultiWave w = (jScopeMultiWave)this.getGridComponent(k);
                ((MdsWaveInterface)w.wi).FromFile(pr, "Scope.plot_" + (r + 1) + "_" + (c2 + 1), cmd);
                ((MdsWaveInterface)w.wi).mapColorIndex(colorMapping);
                this.SetWaveParams(w);
                ++k;
            }
        }
        int r_columns = 0;
        for (i = 0; i < 4; ++i) {
            if (read_rows[i] == 0) continue;
            r_columns = i + 1;
        }
        if (this.columns != r_columns) {
            this.columns = r_columns;
            this.pw = new float[4];
            for (i = 0; i < this.columns; ++i) {
                this.pw[i] = 1.0f / (float)this.columns;
            }
        } else {
            if (this.columns == 4) {
                this.pw[3] = Math.abs((float)((double)(1000.0f - this.pw[2]) / 1000.0));
            }
            if (this.columns >= 3) {
                this.pw[2] = Math.abs((float)((double)(this.pw[2] != 0.0f ? this.pw[2] - this.pw[1] : 1000.0f - this.pw[1]) / 1000.0));
            }
            if (this.columns >= 2) {
                this.pw[1] = Math.abs((float)((double)(this.pw[1] != 0.0f ? this.pw[1] - this.pw[0] : 1000.0f - this.pw[0]) / 1000.0));
            }
            if (this.columns >= 1) {
                this.pw[0] = Math.abs((float)((double)(this.pw[0] == 0.0f ? 1000.0f : this.pw[0]) / 1000.0));
            }
        }
        this.UpdateHeight();
    }

    public String GetBrowseClass() {
        return this.server_item != null ? this.server_item.getBrowseClass() : "";
    }

    public String GetBrowseUrl() {
        return this.server_item != null ? this.server_item.getBrowseUrl() : "";
    }

    public String GetEvaluatedTitle() {
        if (this.title == null || this.title.length() == 0 || this.dp == null) {
            return "";
        }
        try {
            String t = this.dp.getString(this.title, -1, -1, -1);
            String err = this.dp.getError();
            if (err == null || err.length() == 0) {
                return t;
            }
            return "< evaluation error >";
        }
        catch (Exception exc) {
            return "";
        }
    }

    public String GetEvent() {
        return this.event;
    }

    private JFrame GetFrameParent() {
        Container c;
        for (c = this; c != null && !(c instanceof JFrame); c = c.getParent()) {
        }
        return (JFrame)c;
    }

    public synchronized void getjScopeMultiWave() {
        this.wave_all = new jScopeMultiWave[this.getGridComponentCount()];
        int k = 0;
        for (int i = 0; i < 4; ++i) {
            int j = 0;
            while (j < this.rows[i]) {
                this.wave_all[k] = (jScopeMultiWave)this.getGridComponent(k);
                ++j;
                ++k;
            }
        }
    }

    public String getMainShotError(boolean brief) {
        return this.main_shot_error;
    }

    public long[] getMainShots() {
        return this.main_shots;
    }

    public String getMainShotStr() {
        return this.main_shot_str;
    }

    public String GetPrintEvent() {
        return this.print_event;
    }

    public String GetServerArgument() {
        return this.server_item != null ? this.server_item.getArgument() : "";
    }

    public DataServerItem GetServerItem() {
        if (this.server_item == null) {
            this.server_item = new DataServerItem();
        }
        return this.server_item;
    }

    public String GetServerLabel() {
        if (this.dp == null && this.server_item != null && this.server_item.getName() != null) {
            return "Can't connect to " + this.server_item.getName();
        }
        if (this.dp == null && this.server_item == null) {
            return "Not connected";
        }
        return this.server_item.getName();
    }

    public String GetTitle() {
        return this.title;
    }

    public void InvalidateDefaults() {
        int k = 0;
        for (int i = 0; i < this.rows.length; ++i) {
            int j = 0;
            while (j < this.rows[i]) {
                jScopeMultiWave w = (jScopeMultiWave)this.getGridComponent(k);
                if (w != null) {
                    ((MdsWaveInterface)w.wi).default_is_update = false;
                }
                ++j;
                ++k;
            }
        }
    }

    public boolean isBusy() {
        return this.dp.isBusy();
    }

    @Override
    public void maximizeComponent(Waveform w) {
        super.maximizeComponent(w);
        if (w == null) {
            this.StartUpdate();
        }
    }

    @Override
    public void notifyChange(Waveform dest, Waveform source) {
        jScopeMultiWave w = (jScopeMultiWave)source;
        MdsWaveInterface mwi = new MdsWaveInterface((MdsWaveInterface)w.wi);
        mwi.setDefaultsValues(this.def_vals);
        ((jScopeMultiWave)dest).wi = mwi;
        ((jScopeMultiWave)dest).wi.SetDataProvider(this.dp);
        ((jScopeMultiWave)dest).wi.wave = dest;
        this.Refresh((jScopeMultiWave)dest, "Copy in");
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        boolean st_x = false;
        boolean st_y = false;
        double height = pf.getImageableHeight();
        double width = pf.getImageableWidth();
        Graphics2D g2 = (Graphics2D)g;
        if (pageIndex == 0) {
            g2.translate(pf.getImageableX(), pf.getImageableY());
            this.PrintAll(g2, 0, 0, (int)height, (int)width);
            return 0;
        }
        return 1;
    }

    public void PrintAll(Graphics g, int height, int width) {
        if (this.font == null) {
            this.font = g.getFont();
            this.font = new Font(this.font.getName(), this.font.getStyle(), 18);
            g.setFont(this.font);
        } else {
            this.font = new Font(this.font.getName(), this.font.getStyle(), 18);
            g.setFont(this.font);
        }
        super.PrintAll(g, 0, 0, height, width);
    }

    @Override
    public void PrintAll(Graphics g, int st_x, int st_y, int height, int width) {
        String title = this.GetEvaluatedTitle();
        if (title != null && title.length() != 0) {
            if (this.font == null) {
                this.font = g.getFont();
                this.font = new Font(this.font.getName(), this.font.getStyle(), 18);
                g.setFont(this.font);
            } else {
                this.font = new Font(this.font.getName(), this.font.getStyle(), 18);
                g.setFont(this.font);
            }
            FontMetrics fm = g.getFontMetrics();
            int s_width = fm.stringWidth(title);
            g.drawString(title, st_x + (width - s_width) / 2, st_y += fm.getHeight() / 2 + 2);
            height -= (st_y += 2);
        }
        super.PrintAll(g, st_x, st_y, height, width);
    }

    public void PrintAllWaves(DocPrintJob prnJob, PrintRequestAttributeSet attrs) throws PrinterException, PrintException {
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        SimpleDoc doc = new SimpleDoc(this, flavor, null);
        prnJob.print(doc, attrs);
    }

    @Override
    public void processWaveformEvent(WaveformEvent e) {
        super.processWaveformEvent(e);
        jScopeMultiWave w = (jScopeMultiWave)e.getSource();
        switch (e.getID()) {
            case 2010: {
                Point p = this.getComponentPosition(w);
                if (w.wi.isAddSignal()) {
                    String er;
                    if (!w.wi.IsSignalAdded()) {
                        this.prev_add_signal = null;
                    }
                    if ((er = w.wi.error != null ? w.wi.error : ((MdsWaveInterface)w.wi).getErrorString()) != null) {
                        JOptionPane.showMessageDialog(this, er, "alert processWaveformEvent", 0);
                    }
                    w.wi.setAddSignal(false);
                }
                WaveContainerEvent wce = new WaveContainerEvent(this, 2004, "Wave column " + p.x + " row " + p.y + " is updated");
                this.dispatchWaveContainerEvent(wce);
            }
        }
    }

    public synchronized void Refresh(jScopeMultiWave w, String label) {
        Point p = null;
        if (this.add_sig) {
            p = this.getSplitPosition();
        }
        if (p == null) {
            p = this.getComponentPosition(w);
        }
        WaveContainerEvent wce = new WaveContainerEvent(this, 2003, label + " wave column " + p.x + " row " + p.y);
        this.dispatchWaveContainerEvent(wce);
        w.Refresh();
        if (this.add_sig) {
            this.resetSplitPosition();
        }
    }

    public void RemoveAllEvents(UpdateEventListener l) throws IOException {
        if (this.dp == null) {
            return;
        }
        if (this.event != null && this.event.length() != 0) {
            this.dp.removeUpdateEventListener(l, this.event);
        }
        if (this.print_event != null && this.print_event.length() != 0) {
            this.dp.removeUpdateEventListener(l, this.print_event);
        }
        int k = 0;
        for (int i = 0; i < 4; ++i) {
            int j = 0;
            while (j < this.getComponentsInColumn(i)) {
                jScopeMultiWave w = (jScopeMultiWave)this.getGridComponent(k);
                w.RemoveEvent();
                ++j;
                ++k;
            }
        }
    }

    private void RepaintAllWave() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int k = 0;
                for (int i = 0; i < 4; ++i) {
                    int j = 0;
                    while (j < jScopeWaveContainer.this.rows[i]) {
                        jScopeMultiWave wx = (jScopeMultiWave)jScopeWaveContainer.this.getGridComponent(k);
                        if (wx.wi != null) {
                            wx.Update(wx.wi);
                        }
                        ++j;
                        ++k;
                    }
                }
            }
        });
    }

    public void Reset() {
        int[] reset_rows = new int[]{1, 0, 0, 0};
        this.ph = null;
        this.pw = null;
        this.SetTitle(null);
        this.event = null;
        this.print_event = null;
        this.ResetDrawPanel(reset_rows);
        this.update();
        jScopeMultiWave w = (jScopeMultiWave)this.GetWavePanel(0);
        w.jScopeErase();
        this.def_vals.Reset();
    }

    public void SaveAsText(jScopeMultiWave w, boolean all) {
        Vector<Waveform> panel = new Vector<Waveform>();
        if (!(all || w != null && w.wi != null && w.wi.signals != null && w.wi.signals.length != 0)) {
            return;
        }
        String title = "Save";
        if (all) {
            title = "Save all signals in text format";
        } else {
            Point p = this.getWavePosition(w);
            if (p != null) {
                title = "Save signals on panel (" + p.x + ", " + p.y + ") in text format";
            }
        }
        JFileChooser file_diag = new JFileChooser();
        if (this.save_as_txt_directory != null && this.save_as_txt_directory.trim().length() != 0) {
            file_diag.setCurrentDirectory(new File(this.save_as_txt_directory));
        }
        file_diag.setDialogTitle(title);
        int returnVal = 1;
        boolean done = false;
        String txtsig_file = null;
        while (!done) {
            returnVal = file_diag.showSaveDialog(this);
            if (returnVal == 0) {
                File file = file_diag.getSelectedFile();
                txtsig_file = file.getAbsolutePath();
                if (file.exists()) {
                    Object[] options = new Object[]{"Yes", "No"};
                    int val = JOptionPane.showOptionDialog(null, txtsig_file + " already exists.\nDo you want to replace it?", "Save as", 0, 2, null, options, options[1]);
                    if (val != 0) continue;
                    done = true;
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        if (returnVal == 0 && txtsig_file != null) {
            this.save_as_txt_directory = new String(txtsig_file);
            if (all) {
                for (int i = 0; i < this.getWaveformCount(); ++i) {
                    panel.addElement(this.GetWavePanel(i));
                }
            } else {
                panel.addElement(w);
            }
            String s = "";
            String s1 = "";
            String s2 = "";
            StringBuffer space = new StringBuffer();
            try {
                MdsWaveInterface wi;
                jScopeMultiWave wave;
                BufferedWriter out = new BufferedWriter(new FileWriter(txtsig_file));
                for (int l = 0; l < 3; ++l) {
                    s = "%";
                    for (int k = 0; k < panel.size(); ++k) {
                        wave = (jScopeMultiWave)panel.elementAt(k);
                        wi = (MdsWaveInterface)wave.wi;
                        if (wi == null || wi.signals == null) continue;
                        for (int i = 0; i < wi.signals.length; ++i) {
                            switch (l) {
                                case 0: {
                                    s = s + "x : " + (wi.in_x != null && wi.in_x.length > 0 ? wi.in_x[i] : "None");
                                    break;
                                }
                                case 1: {
                                    s = s + "y : " + (wi.in_y != null && wi.in_y.length > 0 ? wi.in_y[i] : "None");
                                    break;
                                }
                                case 2: {
                                    s = s + "Shot : " + (wi.shots != null && wi.shots.length > 0 ? "" + wi.shots[i] : "None");
                                }
                            }
                            out.write(s, 0, s.length() < 50 ? s.length() : 50);
                            space.setLength(0);
                            for (int u = 0; u < 52 - s.length(); ++u) {
                                space.append(' ');
                            }
                            out.write(space.toString());
                            s = "";
                        }
                    }
                    out.newLine();
                }
                boolean g_more_point = true;
                int n_max_sig = 0;
                boolean[] more_point = new boolean[panel.size()];
                for (int k = 0; k < panel.size(); ++k) {
                    more_point[k] = true;
                    wave = (jScopeMultiWave)panel.elementAt(k);
                    wi = (MdsWaveInterface)wave.wi;
                    if (wi == null || wi.signals == null || wi.signals.length <= n_max_sig) continue;
                    n_max_sig = wi.signals.length;
                }
                int[][] start_idx = new int[panel.size()][n_max_sig];
                while (g_more_point) {
                    g_more_point = false;
                    for (int k = 0; k < panel.size(); ++k) {
                        wave = (jScopeMultiWave)panel.elementAt(k);
                        wi = (MdsWaveInterface)wave.wi;
                        if (wi == null || wi.signals == null) continue;
                        if (!more_point[k]) {
                            for (Signal signal : wi.signals) {
                                out.write("                                   ");
                            }
                            continue;
                        }
                        g_more_point = true;
                        int j = 0;
                        double xmax = wave.GetWaveformMetrics().XMax();
                        double xmin = wave.GetWaveformMetrics().XMin();
                        more_point[k] = false;
                        for (int i = 0; i < wi.signals.length; ++i) {
                            int u;
                            s1 = "";
                            s2 = "";
                            if (wi.signals[i] != null && wi.signals[i].hasX()) {
                                for (j = start_idx[k][i]; j < wi.signals[i].getNumPoints(); ++j) {
                                    if (!(wi.signals[i].getX(j) > xmin) || !(wi.signals[i].getX(j) < xmax)) continue;
                                    more_point[k] = true;
                                    s1 = "" + wi.signals[i].getX(j);
                                    s2 = "" + wi.signals[i].getY(j);
                                    start_idx[k][i] = j + 1;
                                    break;
                                }
                            }
                            out.write(s1);
                            space.setLength(0);
                            for (u = 0; u < 25 - s1.length(); ++u) {
                                space.append(' ');
                            }
                            space.append(' ');
                            out.write(space.toString());
                            out.write(" ");
                            out.write(s2);
                            space.setLength(0);
                            for (u = 0; u < 25 - s2.length(); ++u) {
                                space.append(' ');
                            }
                            out.write(space.toString());
                        }
                    }
                    out.newLine();
                }
                out.close();
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
    }

    public void SetDataServer(DataServerItem server_item, UpdateEventListener l) throws Exception {
        if (server_item == null || server_item.getName() == null) {
            throw new Exception("Defined null or empty data server name");
        }
        DataProvider new_dp = server_item.getProvider();
        if (this.browse_sig != null && this.browse_sig.isShowing()) {
            this.browse_sig.setVisible(false);
        }
        try {
            this.RemoveAllEvents(l);
            if (this.dp != null) {
                this.dp.removeConnectionListener((ConnectionListener)((Object)l));
                this.dp.close();
            }
            this.dp = new_dp;
            int option = this.dp.inquireCredentials(this.GetFrameParent(), server_item);
            switch (option) {
                case 1: {
                    this.dp.setArgument(server_item.getArgument());
                    break;
                }
                case 2: 
                case 3: {
                    server_item = new DataServerItem();
                    this.dp = DataServerItem.NotConnected;
                }
            }
            if (this.dp != null) {
                this.dp.addConnectionListener((ConnectionListener)((Object)l));
            }
            if (server_item.isNotConnected() && this.dp.getShots("0", "xx") == null) {
                throw new Exception("Cannot connect to " + server_item.getClassName() + " data server");
            }
            this.ChangeDataProvider(this.dp);
            this.AddAllEvents(l);
            if (server_item != null && server_item.getBrowseClass() != null && server_item.getBrowseUrl() != null) {
                try {
                    Class<?> cl = Class.forName("mds.provider.browser." + server_item.getBrowseClass());
                    this.browse_sig = (jScopeBrowseSignals)cl.newInstance();
                    this.browse_sig.setWaveContainer(this);
                }
                catch (Exception e) {
                    this.browse_sig = null;
                    JOptionPane.showMessageDialog(this, "Unable to locate the signal server " + server_item.getBrowseUrl() + " : " + e.getMessage(), "alert", 0);
                }
            } else {
                this.browse_sig = null;
            }
            this.server_item = server_item;
        }
        catch (IOException e) {
            this.server_item = new DataServerItem();
            this.dp = DataServerItem.NotConnected;
            this.ChangeDataProvider(this.dp);
            throw new Exception(e.getMessage());
        }
    }

    public void SetEvent(UpdateEventListener l, String event) throws IOException {
        this.event = this.AddRemoveEvent(l, this.event, event);
    }

    public void SetMainShot(String shot_str) {
        if (shot_str != null) {
            try {
                this.EvaluateMainShot(shot_str.trim());
            }
            catch (IOException exc) {
                this.main_shot_str = null;
                this.main_shot_error = "Main Shots evaluations error : \n" + exc.getMessage();
                JOptionPane.showMessageDialog(this, this.main_shot_error, "alert SetMainShot", 0);
            }
        }
    }

    public void SetModifiedState(boolean state) {
        for (int i = 0; i < this.getComponentNumber(); ++i) {
            jScopeMultiWave w = (jScopeMultiWave)this.getGridComponent(i);
            if (w == null || w.wi == null) continue;
            w.wi.setModified(state);
        }
    }

    public void SetPrintEvent(UpdateEventListener l, String print_event) throws IOException {
        this.print_event = this.AddRemoveEvent(l, this.print_event, print_event);
    }

    public void SetTitle(String title) {
        this.title = title;
    }

    public void ShowBrowseSignals() {
        if (this.browse_sig != null) {
            if (!this.browse_sig.isConnected()) {
                try {
                    this.browse_sig.connectToBrowser(this.server_item.getBrowseUrl());
                    this.browse_sig.setTitle("URL : " + this.server_item.getBrowseUrl());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "alert", 0);
                }
            }
            this.browse_sig.setVisible(true);
        } else {
            String msg;
            if (this.GetBrowseUrl() == null) {
                msg = "Signals browser not yet implemented on this data server";
            } else {
                msg = "jScope is unable to locate the signal server page at " + this.GetBrowseUrl();
                msg = msg + "\nModify browse_url property for this data server in jScope.properties file.";
            }
            JOptionPane.showMessageDialog(null, msg, "alert", 0);
        }
    }

    public void StartPrint(DocPrintJob prnJob, PrintRequestAttributeSet attrs) {
        try {
            this.getjScopeMultiWave();
            this.UpdateAllWave();
            this.PrintAllWaves(prnJob, attrs);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (PrinterException printerException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void StartUpdate() {
        if (!this.updateThread.isAlive()) {
            this.updateThread = new UpdW();
            this.updateThread.start();
        }
        this.getjScopeMultiWave();
        this.updateThread.StartUpdate();
    }

    public void startUpdatingPanel() {
        this.progressMonitor = new ProgressMonitor(this, "Running a Long Task", "", 0, 0);
    }

    public void stopUpdatingPanel() {
        this.progressMonitor.close();
    }

    public void ToFile(PrintWriter out, String prompt) throws IOException {
        WaveInterface.WriteLine(out, prompt + "title: ", this.title);
        if (this.server_item != null) {
            WaveInterface.WriteLine(out, prompt + "data_server_name: ", this.server_item.getName());
            WaveInterface.WriteLine(out, prompt + "data_server_class: ", this.server_item.getClassName());
            if (this.server_item.getArgument() != null) {
                WaveInterface.WriteLine(out, prompt + "data_server_argument: ", this.server_item.getArgument());
            }
            if (this.server_item.getUser() != null) {
                WaveInterface.WriteLine(out, prompt + "data_server_user: ", this.server_item.getUser());
            }
            if (this.server_item.getBrowseClass() != null) {
                WaveInterface.WriteLine(out, prompt + "data_server_browse_class: ", this.server_item.getBrowseClass());
            }
            if (this.server_item.getBrowseUrl() != null) {
                WaveInterface.WriteLine(out, prompt + "data_server_browse_url: ", this.server_item.getBrowseUrl());
            }
            if (this.server_item.getTunnelPort() != null) {
                WaveInterface.WriteLine(out, prompt + "data_server_tunnel_port: ", this.server_item.getTunnelPort());
            }
        }
        WaveInterface.WriteLine(out, prompt + "update_event: ", this.event);
        WaveInterface.WriteLine(out, prompt + "print_event: ", this.print_event);
        WaveInterface.WriteLine(out, prompt + "reversed: ", "" + this.reversed);
        out.println();
        WaveInterface.WriteLine(out, prompt + "global_1_1.experiment: ", this.def_vals.experiment_str);
        WaveInterface.WriteLine(out, prompt + "global_1_1.event: ", this.def_vals.upd_event_str);
        WaveInterface.WriteLine(out, prompt + "global_1_1.default_node: ", this.def_vals.def_node_str);
        WaveInterface.WriteLine(out, prompt + "global_1_1.shot: ", this.def_vals.shot_str);
        WaveInterface.WriteLine(out, prompt + "global_1_1.title: ", this.def_vals.title_str);
        WaveInterface.WriteLine(out, prompt + "global_1_1.xmax: ", this.def_vals.xmax);
        WaveInterface.WriteLine(out, prompt + "global_1_1.xmin: ", this.def_vals.xmin);
        WaveInterface.WriteLine(out, prompt + "global_1_1.x_label: ", this.def_vals.xlabel);
        WaveInterface.WriteLine(out, prompt + "global_1_1.ymax: ", this.def_vals.ymax);
        WaveInterface.WriteLine(out, prompt + "global_1_1.ymin: ", this.def_vals.ymin);
        WaveInterface.WriteLine(out, prompt + "global_1_1.y_label: ", this.def_vals.ylabel);
        WaveInterface.WriteLine(out, prompt + "global_1_1.horizontal_offset: ", "" + Waveform.GetHorizontalOffset());
        WaveInterface.WriteLine(out, prompt + "global_1_1.vertical_offset: ", "" + Waveform.GetVerticalOffset());
        out.println();
        out.println("Scope.columns: " + this.getColumns());
        float[] normHeight = this.getNormalizedHeight();
        float[] normWidth = this.getNormalizedWidth();
        Dimension dim = this.getSize();
        int i = 0;
        int c = 1;
        int k = 0;
        while (i < this.getColumns()) {
            WaveInterface.WriteLine(out, prompt + "rows_in_column_" + c + ": ", "" + this.getComponentsInColumn(i));
            int j = 0;
            int r = 1;
            while (j < this.getComponentsInColumn(i)) {
                jScopeMultiWave w = (jScopeMultiWave)this.getGridComponent(k);
                MdsWaveInterface wi = (MdsWaveInterface)w.wi;
                out.println("\n");
                WaveInterface.WriteLine(out, prompt + "plot_" + r + "_" + c + ".height: ", "" + (int)((float)dim.height * normHeight[k]));
                WaveInterface.WriteLine(out, prompt + "plot_" + r + "_" + c + ".grid_mode: ", "" + w.grid_mode);
                if (wi != null) {
                    wi.ToFile(out, prompt + "plot_" + r + "_" + c + ".");
                }
                ++k;
                ++j;
                ++r;
            }
            ++i;
            ++c;
        }
        out.println();
        int pos = 0;
        for (i = 1; i < this.getColumns(); ++i) {
            WaveInterface.WriteLine(out, prompt + "vpane_" + i + ": ", "" + (pos += (int)((double)normWidth[i - 1] * 1000.0)));
            this.getComponentsInColumn(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void UpdateAllWave() throws Exception {
        try {
            int i;
            WaveContainerEvent wce;
            int j;
            int i2;
            this.abort = this.wave_all == null;
            if (this.def_vals != null && !this.def_vals.getIsEvaluated()) {
                this.dp.setEnvironment(this.def_vals.getPublicVariables());
                this.def_vals.setIsEvaluated(true);
            }
            int k = 0;
            for (i2 = 0; i2 < 4 && !this.abort; ++i2) {
                j = 0;
                while (j < this.rows[i2]) {
                    if (this.wave_all[k].wi != null && this.wave_all[k].isWaveformVisible()) {
                        ((MdsWaveInterface)this.wave_all[k].wi).Update();
                    }
                    ++j;
                    ++k;
                }
            }
            k = 0;
            for (i2 = 0; i2 < 4 && !this.abort; ++i2) {
                j = 0;
                while (j < this.rows[i2] && !this.abort) {
                    if (this.wave_all[k].wi != null && this.wave_all[k].wi.error == null && this.wave_all[k].isWaveformVisible()) {
                        wce = new WaveContainerEvent(this, 2003, "Start Evaluate column " + (i2 + 1) + " row " + (j + 1));
                        try {
                            this.dispatchWaveContainerEvent(wce);
                            ((MdsWaveInterface)this.wave_all[k].wi).StartEvaluate();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++j;
                    ++k;
                }
            }
            Object i3 = this.mainShotLock;
            synchronized (i3) {
                if (this.main_shots != null) {
                    for (int l = 0; l < this.main_shots.length && !this.abort; ++l) {
                        int k2 = 0;
                        for (int i4 = 0; i4 < 4 && !this.abort; ++i4) {
                            int j2 = 0;
                            while (j2 < this.rows[i4] && !this.abort) {
                                if (this.wave_all[k2].wi != null && this.wave_all[k2].wi.error == null && this.wave_all[k2].isWaveformVisible() && this.wave_all[k2].wi.num_waves != 0 && ((MdsWaveInterface)this.wave_all[k2].wi).UseDefaultShot()) {
                                    wce = new WaveContainerEvent(this, 2003, "Update signal column " + (i4 + 1) + " row " + (j2 + 1) + " main shot " + this.main_shots[l]);
                                    this.dispatchWaveContainerEvent(wce);
                                    ((MdsWaveInterface)this.wave_all[k2].wi).EvaluateShot(this.main_shots[l]);
                                    if (((MdsWaveInterface)this.wave_all[k2].wi).allEvaluated() && this.wave_all[k2].wi != null) {
                                        this.wave_all[k2].Update(this.wave_all[k2].wi);
                                    }
                                }
                                ++j2;
                                ++k2;
                            }
                        }
                    }
                }
            }
            k = 0;
            for (i = 0; i < 4; ++i) {
                j = 0;
                while (j < this.rows[i]) {
                    block29: {
                        block30: {
                            if (this.wave_all == null || this.wave_all[k] == null) break block29;
                            if (this.wave_all[k].wi == null || this.wave_all[k].wi.error != null || !this.wave_all[k].isWaveformVisible() || this.wave_all[k].wi.num_waves == 0 || this.abort) break block30;
                            if (((MdsWaveInterface)this.wave_all[k].wi).allEvaluated()) break block29;
                            wce = new WaveContainerEvent(this, 2003, "Evaluate wave column " + (i + 1) + " row " + (j + 1));
                            this.dispatchWaveContainerEvent(wce);
                            ((MdsWaveInterface)this.wave_all[k].wi).EvaluateOthers();
                        }
                        if (this.wave_all[k].wi != null && this.wave_all[k].isWaveformVisible()) {
                            this.wave_all[k].Update(this.wave_all[k].wi);
                        }
                    }
                    ++j;
                    ++k;
                }
            }
            k = 0;
            for (i = 0; i < 4; ++i) {
                j = 0;
                while (j < this.rows[i]) {
                    if (this.wave_all != null && this.wave_all[k] != null) {
                        ((MdsWaveInterface)this.wave_all[k].wi).allEvaluated();
                    }
                    ++j;
                    ++k;
                }
            }
            this.wave_all = null;
        }
        catch (Exception e) {
            this.RepaintAllWave();
        }
    }

    public void UpdateHeight() {
        float height = 0.0f;
        this.ph = new float[this.getComponentNumber()];
        int k = 0;
        block0: for (int j = 0; j < this.columns; ++j) {
            jScopeMultiWave w;
            int i;
            height = 0.0f;
            for (i = 0; i < this.rows[j]; ++i) {
                w = (jScopeMultiWave)this.getGridComponent(k + i);
                height += (float)w.wi.height;
            }
            i = 0;
            while (i < this.rows[j]) {
                w = (jScopeMultiWave)this.getGridComponent(k);
                if (height == 0.0f) {
                    k -= i;
                    for (i = 0; i < this.rows[j]; ++i) {
                        this.ph[k++] = 1.0f / (float)this.rows[j];
                    }
                    continue block0;
                }
                this.ph[k] = (float)w.wi.height / height;
                ++i;
                ++k;
            }
        }
        this.invalidate();
    }

    class UpdW
    extends Thread {
        boolean pending = false;

        UpdW() {
        }

        @Override
        public synchronized void run() {
            Date date = new Date();
            WaveContainerEvent wce = null;
            this.setName("Update Thread");
            block4: while (true) {
                try {
                    while (true) {
                        if (!this.pending) {
                            this.wait();
                        }
                        this.pending = false;
                        date = new Date();
                        long start = date.getTime();
                        wce = new WaveContainerEvent(this, 2003, "Start Update");
                        jScopeWaveContainer.this.dispatchWaveContainerEvent(wce);
                        try {
                            jScopeWaveContainer.this.UpdateAllWave();
                            date = new Date();
                            long end = date.getTime();
                            String msg = !jScopeWaveContainer.this.abort ? "All waveforms are up to date < " + (end - start) + " ms >" : " Aborted ";
                            wce = new WaveContainerEvent(this, 2004, msg);
                            jScopeWaveContainer.this.dispatchWaveContainerEvent(wce);
                            continue block4;
                        }
                        catch (Throwable e) {
                            wce = new WaveContainerEvent(this, 2005, e.getMessage());
                            jScopeWaveContainer.this.dispatchWaveContainerEvent(wce);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public synchronized void StartUpdate() {
            this.pending = true;
            this.notify();
        }
    }
}

