/*
 * Decompiled with CFR 0.152.
 */
package mds.wave;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import mds.wave.ColorMap;
import mds.wave.FrameData;

public class Frames
extends Canvas {
    private static final long serialVersionUID = 1L;
    static final int ROI = 20;
    Vector<Float> frame_time = new Vector();
    Rectangle zoom_rect = null;
    Rectangle view_rect = null;
    private int curr_frame_idx = -1;
    protected boolean aspect_ratio = true;
    protected int curr_grab_frame = -1;
    protected int[] pixel_array;
    protected float[] values_array;
    protected int img_width = -1;
    protected int img_height = -1;
    protected int[] frames_pixel_array;
    protected float[] frames_value_array;
    protected Rectangle frames_pixel_roi;
    protected int x_measure_pixel = 0;
    protected int y_measure_pixel = 0;
    protected float[] ft = null;
    protected Point sel_point = null;
    protected boolean horizontal_flip = false;
    protected boolean vertical_flip = false;
    protected int color_idx;
    protected String error;
    FrameCache cache = new FrameCache();

    public static int DecodeImageType(byte[] buf) {
        String s = new String(buf, 0, 20);
        if (s.indexOf("GIF") == 0) {
            return 8;
        }
        if (s.indexOf("JFIF") == 6) {
            return 8;
        }
        return 9;
    }

    public Frames() {
    }

    Frames(Frames frames) {
        this();
        this.cache = new FrameCache(frames.cache);
        if (this.frame_time.size() != 0) {
            this.frame_time.removeAllElements();
        }
        if (frames.zoom_rect != null) {
            this.zoom_rect = new Rectangle(frames.zoom_rect);
        }
        if (frames.view_rect != null) {
            this.view_rect = new Rectangle(frames.view_rect);
        }
        this.curr_frame_idx = frames.curr_frame_idx;
    }

    public void applyColorModel(ColorMap colorMap) {
        if (colorMap == null) {
            return;
        }
        this.cache.setColorMap(colorMap);
    }

    public boolean contain(Point p, Dimension d) {
        Dimension fr_dim = this.getFrameSize(this.curr_frame_idx, d);
        return p.x <= fr_dim.width && p.y <= fr_dim.height;
    }

    public void FlipFrame(byte[] buf, Dimension d, int num_byte_pixel) {
        if (!this.vertical_flip && !this.horizontal_flip) {
            return;
        }
        int img_size = d.height * d.width * num_byte_pixel;
        byte[] tmp = new byte[img_size];
        int h = this.vertical_flip ? d.height - 1 : 0;
        int w = this.horizontal_flip ? d.width - 1 : 0;
        for (int j = 0; j < d.width; ++j) {
            for (int k = 0; k < d.height; ++k) {
                for (int l = 0; l < num_byte_pixel; ++l) {
                    tmp[(Math.abs((int)(h - k)) * d.width + Math.abs((int)(w - j))) * num_byte_pixel + l] = buf[(k * d.width + j) * num_byte_pixel + l];
                }
            }
        }
        System.arraycopy(tmp, 0, buf, 0, img_size);
    }

    public void flipFrames(byte[] buf) {
        if (!this.vertical_flip && !this.horizontal_flip) {
            return;
        }
        try {
            ByteArrayInputStream b = new ByteArrayInputStream(buf);
            DataInputStream d = new DataInputStream(b);
            int width = d.readInt();
            int height = d.readInt();
            int img_size = height * width;
            int n_frame = d.readInt();
            d.close();
            byte[] tmp = new byte[img_size];
            int h = this.vertical_flip ? height - 1 : 0;
            int w = this.horizontal_flip ? width - 1 : 0;
            int ofs = 12 + 4 * n_frame;
            for (int i = 0; i < n_frame; ++i) {
                for (int j = 0; j < width; ++j) {
                    for (int k = 0; k < height; ++k) {
                        tmp[Math.abs((int)(h - k)) * width + Math.abs((int)(w - j))] = buf[ofs + k * width + j];
                    }
                }
                System.arraycopy(tmp, 0, buf, ofs, img_size);
                ofs += img_size;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean getAspectRatio() {
        return this.aspect_ratio;
    }

    public int GetColorIdx() {
        return this.color_idx;
    }

    public ColorMap getColorMap() {
        return this.cache.getColorMap();
    }

    String getError() {
        return this.error;
    }

    public Image GetFrame(int idx) {
        Image img;
        if (idx < 0) {
            return null;
        }
        int numFrames = this.cache.getNumFrames();
        if (idx >= numFrames) {
            idx = numFrames - 1;
        }
        this.curr_frame_idx = idx;
        try {
            img = this.cache.getImageAt(idx);
        }
        catch (Exception exc) {
            img = null;
        }
        if (img != null && this.img_width == -1) {
            this.img_width = img.getWidth(this);
            this.img_height = img.getHeight(this);
        }
        return img;
    }

    public Image GetFrame(int idx, Dimension d) {
        return this.GetFrame(idx);
    }

    protected Dimension GetFrameDim(int idx) {
        return this.cache.getFrameDimension();
    }

    public int GetFrameIdx() {
        return this.curr_frame_idx;
    }

    public int GetFrameIdxAtTime(float t) {
        int idx = -1;
        int numFrames = this.cache.getNumFrames();
        if (numFrames <= 0) {
            return -1;
        }
        float dt = numFrames == 1 ? 1.0f : this.frame_time.elementAt(1).floatValue() - this.frame_time.elementAt(0).floatValue();
        if (t >= this.frame_time.elementAt(numFrames - 1).floatValue() + dt) {
            return -1;
        }
        if (t >= this.frame_time.elementAt(numFrames - 1).floatValue()) {
            return numFrames - 1;
        }
        for (int i = 0; i < numFrames - 1; ++i) {
            if (!(t >= this.frame_time.elementAt(i).floatValue()) || !(t < this.frame_time.elementAt(i + 1).floatValue())) continue;
            idx = i;
            break;
        }
        return idx;
    }

    public Point getFramePoint(Dimension d) {
        if (this.sel_point != null) {
            return this.getImagePoint(new Point(this.sel_point.x, this.sel_point.y), d);
        }
        return new Point(0, 0);
    }

    public Point getFramePoint(Point p, Dimension d) {
        Point p_out = new Point(0, 0);
        if (p.x < 0) {
            p.x = 0;
        }
        if (p.y < 0) {
            p.y = 0;
        }
        if (this.curr_frame_idx != -1 && this.cache.getNumFrames() != 0) {
            Dimension dim;
            Dimension view_dim;
            Dimension fr_dim = this.getFrameSize(this.curr_frame_idx, d);
            if (this.zoom_rect == null) {
                dim = view_dim = this.GetFrameDim(this.curr_frame_idx);
            } else {
                dim = new Dimension(this.zoom_rect.width, this.zoom_rect.height);
                view_dim = new Dimension(this.zoom_rect.x + this.zoom_rect.width, this.zoom_rect.y + this.zoom_rect.height);
                p_out.x = this.zoom_rect.x;
                p_out.y = this.zoom_rect.y;
            }
            double ratio_x = (double)dim.width / (double)fr_dim.width;
            double ratio_y = (double)dim.height / (double)fr_dim.height;
            p_out.x = (int)((double)p_out.x + ratio_x * (double)p.x);
            if (p_out.x > view_dim.width - 1) {
                p_out.x = view_dim.width - 1;
                p.x = fr_dim.width;
            }
            p_out.y = (int)((double)p_out.y + ratio_y * (double)p.y);
            if (p_out.y > view_dim.height - 1) {
                p_out.y = view_dim.height - 1;
                p.y = fr_dim.height;
            }
        }
        return p_out;
    }

    public Dimension getFrameSize(int idx, Dimension d) {
        Dimension dim_b = new Dimension(d.width - 1, d.height - 1);
        int width = dim_b.width;
        int height = dim_b.height;
        if (this.getAspectRatio()) {
            double ratio;
            Dimension dim = this.GetFrameDim(idx);
            int w = dim.width;
            int h = dim.height;
            if (this.zoom_rect != null) {
                w = this.zoom_rect.width;
                h = this.zoom_rect.height;
            }
            if ((width = (int)((ratio = (double)w / (double)h) * (double)d.height)) > d.width) {
                width = d.width;
                height = (int)((double)d.width / ratio);
            }
        }
        return new Dimension(width, height);
    }

    public float[] getFramesTime() {
        if (this.frame_time == null || this.frame_time.size() == 0) {
            return null;
        }
        if (this.ft == null) {
            this.ft = new float[this.frame_time.size()];
            for (int i = 0; i < this.frame_time.size(); ++i) {
                this.ft[i] = this.frame_time.elementAt(i).floatValue();
            }
        }
        return this.ft;
    }

    public float GetFrameTime() {
        float t_out = 0.0f;
        if (this.curr_frame_idx != -1 && this.frame_time != null && !this.frame_time.isEmpty()) {
            t_out = this.frame_time.elementAt(this.curr_frame_idx).floatValue();
        }
        return t_out;
    }

    public int getFrameType() {
        return this.cache.getFrameType();
    }

    public boolean getHorizontalFlip() {
        return this.horizontal_flip;
    }

    private Point getImageBufferPoint(int x, int y) {
        Point p = new Point();
        p.x = x;
        p.y = y;
        if (this.horizontal_flip) {
            p.y = this.img_height - y - 1;
        }
        if (this.vertical_flip) {
            p.x = this.img_width - x - 1;
        }
        return p;
    }

    public Point getImagePoint(Point p, Dimension d) {
        Point p_out = new Point(0, 0);
        if (this.curr_frame_idx != -1 && this.cache.getNumFrames() != 0) {
            Dimension dim;
            Dimension fr_dim = this.getFrameSize(this.curr_frame_idx, d);
            if (this.zoom_rect == null) {
                Dimension view_dim;
                dim = view_dim = this.GetFrameDim(this.curr_frame_idx);
            } else {
                dim = new Dimension(this.zoom_rect.width, this.zoom_rect.height);
                Dimension view_dim = new Dimension(this.zoom_rect.x + this.zoom_rect.width, this.zoom_rect.y + this.zoom_rect.height);
                p.x -= this.zoom_rect.x;
                p.y -= this.zoom_rect.y;
            }
            double ratio_x = (double)fr_dim.width / (double)dim.width;
            double ratio_y = (double)fr_dim.height / (double)dim.height;
            p_out.x = (int)(ratio_x * (double)p.x + ratio_x / 2.0);
            if ((double)p_out.x > (double)(dim.width - 1) * ratio_x) {
                p_out.x = 0;
                p_out.y = 0;
            } else {
                p_out.y = (int)(ratio_y * (double)p.y + ratio_y / 2.0);
                if ((double)p_out.y > (double)(dim.height - 1) * ratio_y) {
                    p_out.x = 0;
                    p_out.y = 0;
                }
            }
        }
        return p_out;
    }

    public int getLastFrameIdx() {
        if (this.curr_frame_idx - 1 < 0) {
            return 0;
        }
        return --this.curr_frame_idx;
    }

    public Point getMeasurePoint(Dimension d) {
        return this.getImagePoint(new Point(this.x_measure_pixel, this.y_measure_pixel), d);
    }

    public int getNextFrameIdx() {
        if (this.curr_frame_idx + 1 == this.getNumFrame()) {
            return this.curr_frame_idx;
        }
        return ++this.curr_frame_idx;
    }

    public int getNumFrame() {
        return this.cache.getNumFrames();
    }

    public int getPixel(int idx, int x, int y) {
        if (!this.isInImage(idx, x, y)) {
            return -1;
        }
        try {
            BufferedImage img = (BufferedImage)this.cache.getImageAt(idx);
            Point p = this.getImageBufferPoint(x, y);
            if (img != null) {
                return img.getRGB(p.y, p.x);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    protected int[] getPixelArray(int idx, int x, int y, int img_w, int img_h) {
        Image img;
        this.error = "";
        try {
            img = this.cache.getImageAt(idx);
        }
        catch (Exception exc) {
            this.error = "INTERNAL ERROR in Frame.getPixelArrat: " + exc;
            System.out.println("INTERNAL ERROR in Frame.getPixelArrat: " + exc);
            return null;
        }
        if (img_w == -1 && img_h == -1) {
            this.img_width = img_w = img.getWidth(this);
            this.img_height = img_h = img.getHeight(this);
        }
        int[] pixel_array = new int[img_w * img_h];
        PixelGrabber grabber = new PixelGrabber(img, x, y, img_w, img_h, pixel_array, 0, img_w);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException ie) {
            this.error = "Pixel array not completed";
            System.err.println("Pixel array not completed");
            return null;
        }
        return pixel_array;
    }

    public int[] getPixelsLine(int st_x, int st_y, int end_x, int end_y) {
        int n_point = (int)(Math.sqrt(Math.pow(st_x - end_x, 2.0) + Math.pow(st_y - end_y, 2.0)) + 0.5);
        int[] pixels_line = new int[]{this.pixel_array[st_y * this.img_width + st_x], this.pixel_array[st_y * this.img_width + st_x]};
        this.grabFrame();
        if (n_point < 2) {
            pixels_line = new int[2];
            Point p = this.getImageBufferPoint(st_x, st_y);
            pixels_line[0] = pixels_line[1] = this.pixel_array[p.y * this.img_width + p.x];
            return pixels_line;
        }
        pixels_line = new int[n_point];
        for (int i = 0; i < n_point; ++i) {
            int x = (int)((double)st_x + (double)i * (double)(end_x - st_x) / (double)n_point);
            int y = (int)((double)st_y + (double)i * (double)(end_y - st_y) / (double)n_point);
            Point p = this.getImageBufferPoint(x, y);
            pixels_line[i] = this.pixel_array[p.y * this.img_width + p.x];
        }
        return pixels_line;
    }

    public int[] getPixelsSignal(int x, int y) {
        int i;
        int[] pixels_signal = null;
        if (this.frames_pixel_array == null || !this.frames_pixel_roi.contains(x, y)) {
            this.frames_pixel_roi = new Rectangle();
            if (this.zoom_rect == null) {
                this.zoom_rect = new Rectangle(0, 0, this.img_width, this.img_height);
            }
            this.frames_pixel_roi.x = x - 20 >= this.zoom_rect.x ? x - 20 : this.zoom_rect.x;
            this.frames_pixel_roi.y = y - 20 >= this.zoom_rect.y ? y - 20 : this.zoom_rect.y;
            this.frames_pixel_roi.width = this.frames_pixel_roi.x + 40 <= this.zoom_rect.x + this.zoom_rect.width ? 40 : this.zoom_rect.width - (this.frames_pixel_roi.x - this.zoom_rect.x);
            this.frames_pixel_roi.height = this.frames_pixel_roi.y + 40 <= this.zoom_rect.y + this.zoom_rect.height ? 40 : this.zoom_rect.height - (this.frames_pixel_roi.y - this.zoom_rect.y);
            this.frames_pixel_array = new int[this.frames_pixel_roi.width * this.frames_pixel_roi.height * this.getNumFrame()];
            for (i = 0; i < this.getNumFrame(); ++i) {
                int[] f_array = this.getPixelArray(i, this.frames_pixel_roi.x, this.frames_pixel_roi.y, this.frames_pixel_roi.width, this.frames_pixel_roi.height);
                System.arraycopy(f_array, 0, this.frames_pixel_array, f_array.length * i, f_array.length);
            }
        }
        if (this.frames_pixel_array != null) {
            x -= this.frames_pixel_roi.x;
            y -= this.frames_pixel_roi.y;
            int size = this.frames_pixel_roi.width * this.frames_pixel_roi.height;
            pixels_signal = new int[this.getNumFrame()];
            for (i = 0; i < this.getNumFrame(); ++i) {
                pixels_signal[i] = this.frames_pixel_array[size * i + y * this.frames_pixel_roi.width + x];
            }
        }
        return pixels_signal;
    }

    public int[] getPixelsX(int y) {
        int[] pixels_x = null;
        this.grabFrame();
        if (this.pixel_array != null && y < this.img_height) {
            int end;
            int st;
            if (this.zoom_rect != null) {
                st = this.zoom_rect.x;
                end = this.zoom_rect.x + this.zoom_rect.width;
            } else {
                st = 0;
                end = this.img_width;
            }
            pixels_x = new int[end - st];
            int i = st;
            int j = 0;
            while (i < end) {
                Point p = this.getImageBufferPoint(i, y);
                pixels_x[j] = this.pixel_array[p.y * this.img_width + p.x];
                ++i;
                ++j;
            }
        }
        return pixels_x;
    }

    public int[] getPixelsY(int x) {
        int[] pixels_y = null;
        this.grabFrame();
        if (this.pixel_array != null && x < this.img_width) {
            int end;
            int st;
            if (this.zoom_rect != null) {
                st = this.zoom_rect.y;
                end = this.zoom_rect.y + this.zoom_rect.height;
            } else {
                st = 0;
                end = this.img_height;
            }
            pixels_y = new int[end - st];
            int i = st;
            int j = 0;
            while (i < end) {
                Point p = this.getImageBufferPoint(x, i);
                pixels_y[j] = this.pixel_array[p.y * this.img_width + p.x];
                ++i;
                ++j;
            }
        }
        return pixels_y;
    }

    public float getPointValue(int idx, int x, int y) {
        if (!this.isInImage(idx, x, y)) {
            return -1.0f;
        }
        this.values_array = this.cache.getValuesAt(idx);
        Point p = this.getImageBufferPoint(x, y);
        if (this.values_array != null) {
            return this.values_array[p.y * this.img_width + p.x];
        }
        return 0.0f;
    }

    public int getStartPixelX() {
        if (this.zoom_rect != null) {
            return this.zoom_rect.x;
        }
        return 0;
    }

    public int getStartPixelY() {
        if (this.zoom_rect != null) {
            return this.zoom_rect.y;
        }
        return 0;
    }

    public float GetTime(int frame_idx) {
        if (frame_idx > this.cache.getNumFrames() - 1 || frame_idx < 0) {
            return 0.0f;
        }
        return this.frame_time.elementAt(frame_idx).floatValue();
    }

    protected float[] getValueArray(int idx, int x, int y, int img_w, int img_h) {
        Image img;
        float[] values;
        try {
            values = this.cache.getValuesAt(idx);
            img = this.cache.getImageAt(idx);
        }
        catch (Exception exc) {
            return null;
        }
        if (img_w == -1 && img_h == -1) {
            this.img_width = img_w = img.getWidth(this);
            this.img_height = img_h = img.getHeight(this);
            return values;
        }
        float[] values_array = new float[img_w * img_h];
        int k = 0;
        for (int j = y; j < y + img_h; ++j) {
            for (int i = x; i < x + img_w; ++i) {
                values_array[k++] = values[j * this.img_width + i];
            }
        }
        return values_array;
    }

    public float[] getValuesLine(int st_x, int st_y, int end_x, int end_y) {
        int n_point = (int)(Math.sqrt(Math.pow(st_x - end_x, 2.0) + Math.pow(st_y - end_y, 2.0)) + 0.5);
        this.grabFrame();
        if (n_point < 2) {
            float[] values_line = new float[2];
            Point p = this.getImageBufferPoint(st_x, st_y);
            values_line[0] = values_line[1] = this.values_array[p.y * this.img_width + p.x];
            return values_line;
        }
        float[] values_line = new float[n_point];
        for (int i = 0; i < n_point; ++i) {
            int x = (int)((double)st_x + (double)i * (double)(end_x - st_x) / (double)n_point);
            int y = (int)((double)st_y + (double)i * (double)(end_y - st_y) / (double)n_point);
            Point p = this.getImageBufferPoint(x, y);
            values_line[i] = this.values_array[p.y * this.img_width + p.x];
        }
        return values_line;
    }

    public float[] getValuesSignal(int x, int y) {
        int i;
        float[] values_signal = null;
        if (this.frames_value_array == null || !this.frames_pixel_roi.contains(x, y)) {
            this.frames_pixel_roi = new Rectangle();
            if (this.zoom_rect == null) {
                this.zoom_rect = new Rectangle(0, 0, this.img_width, this.img_height);
            }
            this.frames_pixel_roi.x = x - 20 >= this.zoom_rect.x ? x - 20 : this.zoom_rect.x;
            this.frames_pixel_roi.y = y - 20 >= this.zoom_rect.y ? y - 20 : this.zoom_rect.y;
            this.frames_pixel_roi.width = this.frames_pixel_roi.x + 40 <= this.zoom_rect.x + this.zoom_rect.width ? 40 : this.zoom_rect.width - (this.frames_pixel_roi.x - this.zoom_rect.x);
            this.frames_pixel_roi.height = this.frames_pixel_roi.y + 40 <= this.zoom_rect.y + this.zoom_rect.height ? 40 : this.zoom_rect.height - (this.frames_pixel_roi.y - this.zoom_rect.y);
            this.frames_value_array = new float[this.frames_pixel_roi.width * this.frames_pixel_roi.height * this.getNumFrame()];
            for (i = 0; i < this.getNumFrame(); ++i) {
                float[] f_array = this.getValueArray(i, this.frames_pixel_roi.x, this.frames_pixel_roi.y, this.frames_pixel_roi.width, this.frames_pixel_roi.height);
                System.arraycopy(f_array, 0, this.frames_value_array, f_array.length * i, f_array.length);
            }
        }
        if (this.frames_value_array != null) {
            x -= this.frames_pixel_roi.x;
            y -= this.frames_pixel_roi.y;
            int size = this.frames_pixel_roi.width * this.frames_pixel_roi.height;
            values_signal = new float[this.getNumFrame()];
            for (i = 0; i < this.getNumFrame(); ++i) {
                values_signal[i] = this.frames_value_array[size * i + y * this.frames_pixel_roi.width + x];
            }
        }
        return values_signal;
    }

    public float[] getValuesX(int y) {
        float[] values_x = null;
        this.grabFrame();
        if (this.values_array != null && y < this.img_height) {
            int end;
            int st;
            if (this.zoom_rect != null) {
                st = this.zoom_rect.x;
                end = this.zoom_rect.x + this.zoom_rect.width;
            } else {
                st = 0;
                end = this.img_width;
            }
            values_x = new float[end - st];
            int i = st;
            int j = 0;
            while (i < end) {
                Point p = this.getImageBufferPoint(i, y);
                values_x[j] = this.values_array[p.y * this.img_width + p.x];
                ++i;
                ++j;
            }
        }
        return values_x;
    }

    public float[] getValuesY(int x) {
        float[] values_y = null;
        this.grabFrame();
        if (this.values_array != null && x < this.img_width) {
            int end;
            int st;
            if (this.zoom_rect != null) {
                st = this.zoom_rect.y;
                end = this.zoom_rect.y + this.zoom_rect.height;
            } else {
                st = 0;
                end = this.img_height;
            }
            values_y = new float[end - st];
            int i = st;
            int j = 0;
            while (i < end) {
                Point p = this.getImageBufferPoint(x, i);
                values_y[j] = this.values_array[p.y * this.img_width + p.x];
                ++i;
                ++j;
            }
        }
        return values_y;
    }

    public boolean getVerticalFlip() {
        return this.vertical_flip;
    }

    public Rectangle GetZoomRect() {
        return this.zoom_rect;
    }

    protected void grabFrame() {
        if ((this.curr_frame_idx != this.curr_grab_frame || this.pixel_array == null) && (this.pixel_array = this.getPixelArray(this.curr_frame_idx, 0, 0, -1, -1)) != null) {
            this.values_array = this.getValueArray(this.curr_frame_idx, 0, 0, -1, -1);
            this.curr_grab_frame = this.curr_frame_idx;
        }
    }

    public boolean isInImage(int idx, int x, int y) {
        Dimension d = this.GetFrameDim(idx);
        Rectangle r = new Rectangle(0, 0, d.width, d.height);
        return r.contains(x, y);
    }

    public void Resize() {
        this.zoom_rect = null;
    }

    public void setAspectRatio(boolean aspect_ratio) {
        this.aspect_ratio = aspect_ratio;
    }

    public void SetColorIdx(int color_idx) {
        this.color_idx = color_idx;
    }

    public void setColorMap(ColorMap colorMap) {
        if (colorMap == null) {
            return;
        }
        this.cache.setColorMap(colorMap);
    }

    public void SetFrameData(FrameData fd) throws Exception {
        this.cache.setFrameData(fd);
        this.curr_frame_idx = 0;
        float[] t = fd.getFrameTimes();
        for (int i = 0; i < t.length; ++i) {
            this.frame_time.addElement(new Float(t[i]));
        }
    }

    public void setFramePoint(Point sel_point, Dimension d) {
        this.sel_point = this.getFramePoint(new Point(sel_point.x, sel_point.y), d);
    }

    public void setHorizontalFlip(boolean horizontal_flip) {
        this.horizontal_flip = horizontal_flip;
    }

    public void setMeasurePoint(int x_pixel, int y_pixel, Dimension d) {
        Point mp = this.getFramePoint(new Point(x_pixel, y_pixel), d);
        this.x_measure_pixel = mp.x;
        this.y_measure_pixel = mp.y;
    }

    public void setMinMax(float min, float max) {
        this.cache.setMinMax(min, max);
    }

    public void setVerticalFlip(boolean vertical_flip) {
        this.vertical_flip = vertical_flip;
    }

    public void SetViewRect(int start_x, int start_y, int end_x, int end_y) {
        this.view_rect = null;
        if (start_x == -1 && start_y == -1 && end_x == -1 && end_y == -1) {
            return;
        }
        if (this.getNumFrame() == 0) {
            return;
        }
        Dimension dim = this.GetFrameDim(0);
        if (start_x < 0) {
            start_x = 0;
        }
        if (start_y < 0) {
            start_y = 0;
        }
        if (end_x == -1 || end_x > dim.width) {
            end_x = dim.width;
        }
        if (end_y == -1 || end_y > dim.height) {
            end_y = dim.height;
        }
        if (start_x < end_x && start_y < end_y) {
            this.zoom_rect = this.view_rect = new Rectangle(start_x, start_y, end_x - start_x, end_y - start_y);
        }
    }

    public void SetZoomRegion(int idx, Dimension d, Rectangle r) {
        Dimension dim;
        int numFrames = this.cache.getNumFrames();
        if (idx > numFrames - 1) {
            return;
        }
        Dimension fr_dim = this.getFrameSize(idx, d);
        if (this.zoom_rect == null) {
            this.zoom_rect = new Rectangle(0, 0, 0, 0);
            dim = this.GetFrameDim(idx);
        } else {
            dim = new Dimension(this.zoom_rect.width, this.zoom_rect.height);
        }
        double ratio_x = (double)dim.width / (double)fr_dim.width;
        double ratio_y = (double)dim.height / (double)fr_dim.height;
        this.zoom_rect.width = (int)(ratio_x * (double)r.width + 0.5);
        this.zoom_rect.height = (int)(ratio_y * (double)r.height + 0.5);
        this.zoom_rect.x = (int)((double)this.zoom_rect.x + (ratio_x * (double)r.x + 0.5));
        this.zoom_rect.y = (int)((double)this.zoom_rect.y + (ratio_y * (double)r.y + 0.5));
        if (this.zoom_rect.width == 0) {
            this.zoom_rect.width = 1;
        }
        if (this.zoom_rect.height == 0) {
            this.zoom_rect.height = 1;
        }
        this.curr_frame_idx = idx;
    }

    public void shiftImagePixel(int bitShift, boolean bitClip) {
        this.cache.shiftImagePixel(bitShift, bitClip);
    }

    static class FrameDescriptor {
        byte[] buffer;
        Image image;
        Image updatedImage;
        int updateCount;

        FrameDescriptor(byte[] buffer, Image image, Image updatedImage, int updateCount) {
            this.buffer = buffer;
            this.image = image;
            this.updatedImage = updatedImage;
            this.updateCount = updateCount;
        }
    }

    class FrameCache {
        static final int MAX_CACHE_MEM = 50000000;
        FrameData fd;
        Hashtable<Integer, FrameDescriptor> recentFrames;
        int bitShift;
        boolean bitClip;
        ColorMap colorMap;
        private float max;
        private float min;
        int frameType;
        int pixelSize;
        int bytesPerPixel;
        Dimension frameDim;
        int numFrames;
        MediaTracker tracker;
        Vector<Integer> recentIdxV = new Vector();
        int updateCount = 0;

        public FrameCache() {
            this.recentFrames = new Hashtable();
            this.bitShift = 0;
            this.bitClip = false;
            this.min = Float.MIN_VALUE;
            this.max = Float.MAX_VALUE;
            this.colorMap = new ColorMap();
            this.tracker = new MediaTracker(Frames.this);
        }

        FrameCache(FrameCache fc) {
            this.fd = fc.fd;
            this.bitShift = 0;
            this.bitClip = false;
            this.min = Float.MIN_VALUE;
            this.max = Float.MAX_VALUE;
            this.colorMap = new ColorMap();
            this.recentFrames = new Hashtable();
            Enumeration<Integer> fds = fc.recentFrames.keys();
            while (fds.hasMoreElements()) {
                Integer idx = fds.nextElement();
                FrameDescriptor fDescr = fc.recentFrames.get(idx);
                this.recentFrames.put(idx, fDescr);
            }
        }

        byte[] getBufferAt(int idx) {
            Frames.this.error = "";
            FrameDescriptor fDescr = this.recentFrames.get(new Integer(idx));
            if (fDescr == null) {
                try {
                    this.loadFrame(idx);
                }
                catch (Exception exc) {
                    if (Frames.this.error.length() == 0) {
                        Frames.this.error = "Error Loading frame at " + idx;
                    }
                    System.out.println(Frames.this.error);
                    return null;
                }
            }
            if ((fDescr = this.recentFrames.get(new Integer(idx))) == null) {
                return null;
            }
            return fDescr.buffer;
        }

        ColorMap getColorMap() {
            return this.colorMap;
        }

        Dimension getFrameDimension() {
            return this.frameDim;
        }

        int getFrameType() {
            return this.frameType;
        }

        Image getImageAt(int idx) throws IOException {
            Image img;
            Frames.this.error = "";
            FrameDescriptor fDesc = this.recentFrames.get(new Integer(idx));
            if (fDesc == null) {
                try {
                    this.loadFrame(idx);
                }
                catch (Exception exc) {
                    if (Frames.this.error.length() == 0) {
                        Frames.this.error = "Error Loading frame at " + idx;
                    }
                    System.out.println(Frames.this.error);
                    return null;
                }
                fDesc = this.recentFrames.get(new Integer(idx));
            }
            if (fDesc == null) {
                return null;
            }
            if (fDesc.updateCount == this.updateCount) {
                return fDesc.updatedImage;
            }
            if (this.pixelSize > 0) {
                try {
                    IndexColorModel colorModel = this.colorMap.getIndexColorModel(16);
                    img = new BufferedImage(colorModel, ((BufferedImage)fDesc.image).getRaster(), false, null);
                    BufferedImage bi = (BufferedImage)img;
                    ByteArrayInputStream b = new ByteArrayInputStream(fDesc.buffer);
                    DataInputStream din = new DataInputStream(b);
                    WritableRaster wr = bi.getRaster();
                    DataBuffer db = wr.getDataBuffer();
                    int nPixels = db.getSize();
                    if (nPixels != this.frameDim.width * this.frameDim.height) {
                        Frames.this.error = "INTERNAL ERRROR: Inconsistend frame dimension when getting frame";
                        System.out.println("INTERNAL ERRROR: Inconsistend frame dimension when getting frame");
                        return null;
                    }
                    for (int j = 0; j < nPixels; ++j) {
                        byte bval;
                        float val = this.frameType == 1 || this.frameType == 2 ? ((bval = din.readByte()) < 0 ? (float)(256 + (bval & 0x7F)) : (float)bval) : (this.frameType == 3 ? (float)din.readShort() : (this.frameType == 4 ? (float)(0xFFFF & din.readShort()) : (this.frameType == 7 ? din.readFloat() : (float)din.readInt())));
                        if (val < this.min) {
                            db.setElem(j, 0);
                            continue;
                        }
                        if (val > this.max) {
                            db.setElem(j, 255);
                            continue;
                        }
                        db.setElem(j, (int)((val - this.min) * 255.0f / (this.max - this.min)));
                    }
                }
                catch (Exception exc) {
                    System.out.println(exc);
                    img = null;
                }
            } else {
                img = fDesc.image;
            }
            this.tracker = new MediaTracker(Frames.this);
            this.tracker.addImage(img, idx);
            try {
                this.tracker.waitForID(idx);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.recentFrames.put(new Integer(idx), new FrameDescriptor(fDesc.buffer, fDesc.image, img, this.updateCount));
            return img;
        }

        int getNumFrames() {
            return this.numFrames;
        }

        float[] getValuesAt(int idx) {
            Frames.this.error = "";
            FrameDescriptor fDescr = this.recentFrames.get(new Integer(idx));
            if (fDescr == null) {
                try {
                    this.loadFrame(idx);
                }
                catch (Exception exc) {
                    if (Frames.this.error.length() == 0) {
                        Frames.this.error = "Error Loading frame at " + idx;
                    }
                    System.out.println(Frames.this.error);
                    return null;
                }
            }
            if ((fDescr = this.recentFrames.get(new Integer(idx))) == null) {
                return null;
            }
            byte[] buf = fDescr.buffer;
            int n_pix = this.frameDim.width * this.frameDim.height;
            float[] values = new float[n_pix];
            ByteArrayInputStream b = new ByteArrayInputStream(buf);
            DataInputStream din = new DataInputStream(b);
            switch (this.frameType) {
                case 1: 
                case 2: {
                    b = new ByteArrayInputStream(buf);
                    din = new DataInputStream(b);
                    try {
                        for (int j = 0; j < n_pix; ++j) {
                            byte bval = din.readByte();
                            values[j] = bval < 0 ? (float)(256 + (bval & 0x7F)) : (float)bval;
                        }
                        break;
                    }
                    catch (IOException exc) {
                        Frames.this.error = "INTERNAL ERROR Getting Frame values: " + exc;
                        System.out.println("INTERNAL ERROR Getting Frame values: " + exc);
                        return null;
                    }
                }
                case 3: 
                case 4: {
                    b = new ByteArrayInputStream(buf);
                    din = new DataInputStream(b);
                    try {
                        for (int j = 0; j < n_pix; ++j) {
                            values[j] = this.frameType == 4 ? (float)(0xFFFF & din.readShort()) : (float)din.readShort();
                        }
                        break;
                    }
                    catch (IOException exc) {
                        Frames.this.error = "INTERNAL ERROR Getting Frame values: " + exc;
                        System.out.println("INTERNAL ERROR Getting Frame values: " + exc);
                        return null;
                    }
                }
                case 5: 
                case 6: {
                    try {
                        for (int j = 0; j < n_pix; ++j) {
                            values[j] = din.readInt();
                        }
                        break;
                    }
                    catch (IOException exc) {
                        Frames.this.error = "INTERNAL ERROR Getting Frame values: " + exc;
                        System.out.println("INTERNAL ERROR Getting Frame values: " + exc);
                        return null;
                    }
                }
                case 7: {
                    try {
                        for (int j = 0; j < n_pix; ++j) {
                            values[j] = din.readFloat();
                        }
                        break;
                    }
                    catch (IOException exc) {
                        Frames.this.error = "INTERNAL ERROR Getting Frame values: " + exc;
                        System.out.println("INTERNAL ERROR Getting Frame values: " + exc);
                        return null;
                    }
                }
                case 8: {
                    break;
                }
                default: {
                    Frames.this.error = "INTERNAL ERROR frame values requested for unexpected type: " + this.frameType;
                    System.out.println("INTERNAL ERROR frame values requested for unexpected type: " + this.frameType);
                    return null;
                }
            }
            return values;
        }

        void loadFrame(int idx) throws Exception {
            BufferedImage img;
            this.frameType = this.fd.getFrameType();
            this.frameDim = this.fd.getFrameDimension();
            this.numFrames = this.fd.getNumFrames();
            byte[] buf = this.fd.getFrameAt(idx);
            if (buf == null) {
                return;
            }
            switch (this.frameType) {
                case 1: 
                case 2: {
                    this.pixelSize = 8;
                    this.bytesPerPixel = 1;
                    IndexColorModel colorModel = this.colorMap.getIndexColorModel(16);
                    int n_pix = this.frameDim.width * this.frameDim.height;
                    DataBufferUShort db = new DataBufferUShort(n_pix);
                    for (int j = 0; j < n_pix; ++j) {
                        short val = buf[j] < 0 ? (short)(256 + (buf[j] & 0x7F)) : (short)buf[j];
                        if ((float)val < this.min) {
                            ((DataBuffer)db).setElem(j, 0);
                        } else if ((float)val > this.max) {
                            ((DataBuffer)db).setElem(j, -1);
                        } else {
                            ((DataBuffer)db).setElem(j, (byte)(((float)val - this.min) * 512.0f / (this.max - this.min)));
                        }
                        ((DataBuffer)db).setElem(j, val);
                    }
                    WritableRaster raster = Raster.createInterleavedRaster(db, this.frameDim.width, this.frameDim.height, this.frameDim.width, 1, new int[]{0}, null);
                    img = new BufferedImage(colorModel, raster, false, null);
                    break;
                }
                case 3: 
                case 4: {
                    this.pixelSize = 16;
                    this.bytesPerPixel = 2;
                    IndexColorModel colorModel = this.colorMap.getIndexColorModel(16);
                    if (this.colorMap.bitShift < 0) {
                        // empty if block
                    }
                    this.bitShift = this.colorMap.bitShift;
                    int n_pix = this.frameDim.width * this.frameDim.height;
                    DataBufferUShort db = new DataBufferUShort(n_pix);
                    ByteArrayInputStream b = new ByteArrayInputStream(buf);
                    DataInputStream din = new DataInputStream(b);
                    for (int j = 0; j < n_pix; ++j) {
                        int val = this.frameType == 3 ? din.readShort() : 0xFFFF & din.readShort();
                        if ((float)val < this.min) {
                            ((DataBuffer)db).setElem(j, 0);
                            continue;
                        }
                        if ((float)val > this.max) {
                            ((DataBuffer)db).setElem(j, 255);
                            continue;
                        }
                        ((DataBuffer)db).setElem(j, (int)(((float)val - this.min) * 255.0f / (this.max - this.min)));
                    }
                    WritableRaster raster = Raster.createInterleavedRaster(db, this.frameDim.width, this.frameDim.height, this.frameDim.width, 1, new int[]{0}, null);
                    img = new BufferedImage(colorModel, raster, false, null);
                    break;
                }
                case 5: 
                case 6: {
                    this.pixelSize = 32;
                    this.bytesPerPixel = 4;
                    IndexColorModel colorModel = this.colorMap.getIndexColorModel(16);
                    int n_pix = this.frameDim.width * this.frameDim.height;
                    ByteArrayInputStream b = new ByteArrayInputStream(buf);
                    DataInputStream din = new DataInputStream(b);
                    DataBufferUShort db = new DataBufferUShort(n_pix);
                    for (int j = 0; j < n_pix; ++j) {
                        long val = this.frameType == 5 ? (long)din.readInt() : (long)(0xFFFFFFFF & din.readInt());
                        if ((float)val < this.min) {
                            ((DataBuffer)db).setElem(j, 0);
                            continue;
                        }
                        if ((float)val > this.max) {
                            ((DataBuffer)db).setElem(j, 255);
                            continue;
                        }
                        ((DataBuffer)db).setElem(j, (int)(((float)val - this.min) * 255.0f / (this.max - this.min)));
                    }
                    WritableRaster raster = Raster.createInterleavedRaster(db, this.frameDim.width, this.frameDim.height, this.frameDim.width, 1, new int[]{0}, null);
                    img = new BufferedImage(colorModel, raster, false, null);
                    break;
                }
                case 7: {
                    this.pixelSize = 32;
                    this.bytesPerPixel = 4;
                    IndexColorModel colorModel = this.colorMap.getIndexColorModel(16);
                    int n_pix = this.frameDim.width * this.frameDim.height;
                    ByteArrayInputStream b = new ByteArrayInputStream(buf);
                    DataInputStream din = new DataInputStream(b);
                    DataBufferUShort db = new DataBufferUShort(n_pix);
                    for (int j = 0; j < n_pix; ++j) {
                        float val = din.readFloat();
                        if (val < this.min) {
                            ((DataBuffer)db).setElem(j, 0);
                            continue;
                        }
                        if (val > this.max) {
                            ((DataBuffer)db).setElem(j, 255);
                            continue;
                        }
                        ((DataBuffer)db).setElem(j, (int)((val - this.min) * 255.0f / (this.max - this.min)));
                    }
                    WritableRaster raster = Raster.createInterleavedRaster(db, this.frameDim.width, this.frameDim.height, this.frameDim.width, 1, new int[]{0}, null);
                    img = new BufferedImage(colorModel, raster, false, null);
                    break;
                }
                case 8: {
                    this.pixelSize = 0;
                    img = ImageIO.read(new ByteArrayInputStream(buf));
                    break;
                }
                default: {
                    Frames.this.error = "Frame data type (MDSplus code " + this.frameType + ") is not yet supported";
                    throw new Exception(Frames.this.error);
                }
            }
            this.tracker = new MediaTracker(Frames.this);
            this.tracker.addImage(img, idx);
            this.recentFrames.put(new Integer(idx), new FrameDescriptor(buf, img, img, 0));
            try {
                this.tracker.waitForID(idx);
            }
            catch (Exception n_pix) {
                // empty catch block
            }
            int maxStoreFrames = 50000000 / buf.length;
            this.recentIdxV.insertElementAt(new Integer(idx), 0);
            if (maxStoreFrames < 1) {
                maxStoreFrames = 1;
            }
            if (this.recentIdxV.size() > maxStoreFrames) {
                Integer delIdx = this.recentIdxV.elementAt(maxStoreFrames);
                this.recentFrames.remove(delIdx);
                this.recentIdxV.removeElementAt(maxStoreFrames);
            }
        }

        void setColorMap(ColorMap colorMap) {
            this.colorMap = colorMap;
            this.min = colorMap.getMin();
            this.max = colorMap.getMax();
            ++this.updateCount;
        }

        void setFrameData(FrameData fd) {
            this.fd = fd;
            try {
                this.numFrames = fd.getNumFrames();
            }
            catch (Exception exc) {
                this.numFrames = 0;
            }
        }

        public void setMinMax(float min, float max) {
            this.min = min;
            this.max = max;
            ++this.updateCount;
        }

        public void shiftImagePixel(int bitShift, boolean bitClip) {
            this.bitShift = bitShift;
            this.bitClip = bitClip;
            ++this.updateCount;
        }
    }
}

