/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import javax.swing.border.TitledBorder;

public class DeviceOutputs
extends DeviceComponent {
    private JScrollPane scrollP;
    private int numOutputs;
    private JTextField[] segLensTF;
    private JTextField[] parametersTF;
    private JTextField[] dimensionsTF;
    private int[] segLenNids;
    private int[] parameterNids;
    private int[] dimensionNids;
    private int numOutputChildren = 0;
    private int numItems;
    private int numParItems;

    @Override
    protected void initializeData(String data, boolean is_on) {
        this.mode = 3;
        int currNid = this.baseNid;
        try {
            currNid = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(this.baseNid) + ".OUTPUTS, 'NID_NUMBER')");
        }
        catch (Exception exc) {
            this.numOutputs = 0;
        }
        try {
            this.numOutputs = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currNid) + ",'NUMBER_OF_CHILDREN')");
        }
        catch (Exception exc) {
            this.numOutputs = 0;
        }
        int currOutNid = currNid + 7;
        this.numItems = 0;
        int numBusItems = 0;
        for (int outIdx = 0; outIdx < this.numOutputs; ++outIdx) {
            int numFields;
            int numPars;
            int numMembers;
            int numChildren;
            try {
                numChildren = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currOutNid) + ",'NUMBER_OF_CHILDREN')");
                numMembers = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currOutNid) + ",'NUMBER_OF_MEMBERS')");
                numPars = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currOutNid) + ":PARAMETERS,'NUMBER_OF_CHILDREN')");
            }
            catch (Exception exc) {
                System.out.println("Error getting Output fields");
                this.numOutputs = 0;
                break;
            }
            try {
                numFields = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currOutNid) + ":FIELDS,'NUMBER_OF_CHILDREN')");
            }
            catch (Exception exc) {
                numFields = 0;
            }
            if (numFields == 0) {
                ++this.numItems;
            } else {
                this.numItems += numFields;
                ++numBusItems;
            }
            this.numParItems += numPars;
            currOutNid += 1 + numChildren + numMembers + 3 * numPars + 8 * numFields;
        }
        this.dimensionsTF = new JTextField[this.numItems];
        this.segLensTF = new JTextField[this.numItems];
        this.parametersTF = new JTextField[this.numParItems];
        this.dimensionNids = new int[this.numItems];
        this.segLenNids = new int[this.numItems];
        this.parameterNids = new int[this.numParItems];
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(this.numItems + numBusItems, 1));
        currOutNid = currNid + 7;
        int currItem = 0;
        this.numParItems = 0;
        for (int outIdx = 0; outIdx < this.numOutputs; ++outIdx) {
            int numFields;
            int numPars;
            int numMembers;
            int numChildren;
            try {
                numChildren = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currOutNid) + ",'NUMBER_OF_CHILDREN')");
                numMembers = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currOutNid) + ",'NUMBER_OF_MEMBERS')");
                numPars = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currOutNid) + ":PARAMETERS,'NUMBER_OF_CHILDREN')");
            }
            catch (Exception exc) {
                System.out.println("Error getting Output fields");
                this.numOutputs = 0;
                break;
            }
            try {
                numFields = this.subtree.getInt("GETNCI(" + this.subtree.getFullPath(currOutNid) + ":FIELDS,'NUMBER_OF_CHILDREN')");
            }
            catch (Exception exc) {
                numFields = 0;
            }
            String outName = "";
            try {
                outName = this.subtree.getString(this.subtree.getDataExpr(currOutNid + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (numFields == 0) {
                JPanel jp1 = new JPanel();
                jp1.setBorder(new TitledBorder(outName));
                jp1.add(new JLabel("Dimensions: "));
                this.dimensionsTF[currItem] = new JTextField(4);
                jp1.add(this.dimensionsTF[currItem]);
                this.dimensionNids[currItem] = currOutNid + 4;
                jp1.add(new JLabel("Segment len.: "));
                this.segLensTF[currItem] = new JTextField(10);
                jp1.add(this.segLensTF[currItem]);
                this.segLenNids[currItem] = currOutNid + 5;
                ++currItem;
                for (int parIdx = 0; parIdx < numPars; ++parIdx) {
                    String parName;
                    int nameNid = currOutNid + 10 + 3 * parIdx;
                    try {
                        parName = this.subtree.getString(this.subtree.getDataExpr(nameNid));
                    }
                    catch (Exception exc) {
                        parName = "";
                    }
                    jp1.add(new JLabel(parName + ":"));
                    this.parametersTF[this.numParItems] = new JTextField(10);
                    jp1.add(this.parametersTF[this.numParItems]);
                    this.parameterNids[this.numParItems++] = currOutNid + 11 + 3 * parIdx;
                }
                jp.add(jp1);
            } else {
                JLabel busLabel = new JLabel(outName);
                busLabel.setForeground(Color.red);
                try {
                    busLabel.setTransferHandler(new FromTransferHandler(this.subtree.getFullPath(currOutNid) + ":VALUE"));
                }
                catch (Exception exc) {
                    System.err.println(exc);
                }
                MouseAdapter listener = new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent me) {
                        JComponent comp = (JComponent)me.getSource();
                        TransferHandler handler = comp.getTransferHandler();
                        handler.exportAsDrag(comp, me, 1);
                    }
                };
                busLabel.addMouseListener(listener);
                jp.add(busLabel);
                for (int fieldIdx = 0; fieldIdx < numFields; ++fieldIdx) {
                    int fieldNid = currOutNid + numChildren + numMembers + 1 + 3 * numPars + 8 * fieldIdx;
                    this.segLenNids[currItem] = fieldNid + 5;
                    String fieldName = "";
                    try {
                        fieldName = this.subtree.getString(this.subtree.getDataExpr(fieldNid + 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    JPanel jp1 = new JPanel();
                    jp1.setBorder(new TitledBorder(outName + '.' + fieldName));
                    jp1.setLayout(new GridLayout(1, 2));
                    jp1.add(new JLabel("Segment len.: "));
                    this.segLensTF[currItem] = new JTextField(10);
                    jp1.add(this.segLensTF[currItem]);
                    try {
                        jp1.setTransferHandler(new FromTransferHandler(this.subtree.getFullPath(currOutNid) + ".FIELDS." + fieldName + ":VALUE"));
                    }
                    catch (Exception exc) {
                        System.err.println(exc);
                    }
                    listener = new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent me) {
                            JComponent comp = (JComponent)me.getSource();
                            TransferHandler handler = comp.getTransferHandler();
                            handler.exportAsDrag(comp, me, 1);
                        }
                    };
                    jp1.addMouseListener(listener);
                    jp.add(jp1);
                    ++currItem;
                }
            }
            currOutNid += 1 + numChildren + numMembers + 3 * numPars + 8 * numFields;
        }
        this.scrollP = new JScrollPane(jp);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollP, "Center");
        this.displayData(data, is_on);
    }

    @Override
    protected void displayData(String data, boolean is_on) {
        int idx;
        for (idx = 0; idx < this.numItems; ++idx) {
            try {
                this.segLensTF[idx].setText(this.subtree.getDataExpr(this.segLenNids[idx]));
            }
            catch (Exception exc) {
                this.segLensTF[idx].setText("");
            }
            try {
                this.dimensionsTF[idx].setText(this.subtree.getDataExpr(this.dimensionNids[idx]));
                continue;
            }
            catch (Exception exc) {
                this.dimensionsTF[idx].setText("");
            }
        }
        for (idx = 0; idx < this.numParItems; ++idx) {
            try {
                this.parametersTF[idx].setText(this.subtree.getDataExpr(this.parameterNids[idx]));
                continue;
            }
            catch (Exception exc) {
                this.parametersTF[idx].setText("");
            }
        }
    }

    public void setDisplayDimensions(boolean mode) {
    }

    @Override
    protected String getData() {
        return null;
    }

    @Override
    protected boolean getState() {
        return true;
    }

    @Override
    public void apply() throws Exception {
        int idx;
        for (idx = 0; idx < this.numItems; ++idx) {
            try {
                this.subtree.putDataExpr(this.dimensionNids[idx], this.dimensionsTF[idx].getText());
            }
            catch (Exception exc) {
                System.out.println("Error saving Dimensions");
            }
            try {
                this.subtree.putDataExpr(this.segLenNids[idx], this.segLensTF[idx].getText());
                continue;
            }
            catch (Exception exc) {
                System.out.println("Error saving Segment len");
            }
        }
        for (idx = 0; idx < this.numParItems; ++idx) {
            try {
                this.subtree.putDataExpr(this.parameterNids[idx], this.parametersTF[idx].getText());
                continue;
            }
            catch (Exception exc) {
                System.out.println("Error saving Parameter");
            }
        }
    }

    class FromTransferHandler
    extends TransferHandler {
        String path;

        public FromTransferHandler(String path) {
            this.path = path;
        }

        @Override
        public Transferable createTransferable(JComponent comp) {
            try {
                return new StringSelection(this.path);
            }
            catch (Exception exc) {
                return null;
            }
        }

        @Override
        public int getSourceActions(JComponent comp) {
            return 3;
        }
    }
}

