/*
 * Decompiled with CFR 0.152.
 */
package mds.jscope;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mds.jscope.MdsWaveInterface;
import mds.jscope.jScopeFacade;
import mds.jscope.jScopeMultiWave;
import mds.wave.Signal;
import mds.wave.WaveInterface;
import mds.wave.Waveform;
import mds.wave.WaveformEvent;
import mds.wave.WaveformListener;

class SetupDataDialog
extends JDialog
implements ActionListener,
ItemListener,
KeyListener,
WaveformListener {
    public static int UNDEF_SHOT = -99999;
    private JLabel lab;
    private SError error_w;
    private jScopeFacade main_scope;
    private ExpandExp expand_expr;
    private SList signalList;
    private jScopeMultiWave wave;
    public MdsWaveInterface wi;
    JCheckBox title_b = new JCheckBox("Title");
    JTextField title = new JTextField(50);
    JButton expand = new JButton("Expand Expr.");
    JLabel sig_label = new JLabel();
    JTextField signal_label = new JTextField(50);
    JButton error = new JButton("Error");
    JLabel y_lab = new JLabel();
    JTextArea y_expr = new JTextArea(1, 58);
    JCheckBox y_min_b = new JCheckBox("Y min");
    JTextField y_min = new JTextField(10);
    JLabel pix_y_min = new JLabel();
    JCheckBox y_max_b = new JCheckBox("Y max");
    JTextField y_max = new JTextField(10);
    JLabel pix_y_max = new JLabel();
    JCheckBox image_b = new JCheckBox("Is image");
    JLabel x_lab = new JLabel();
    JTextArea x_expr = new JTextArea(1, 58);
    JCheckBox x_log = new JCheckBox("Log scale");
    JCheckBox x_label_b = new JCheckBox("X Label");
    JTextField x_label = new JTextField(20);
    JCheckBox y_log = new JCheckBox("Log scale");
    JCheckBox y_label_b = new JCheckBox("Y Label");
    JTextField y_label = new JTextField(20);
    JCheckBox x_min_b = new JCheckBox("X min");
    JCheckBox time_min_b = new JCheckBox("T min");
    JLabel pix_x_max = new JLabel();
    JTextField x_min = new JTextField(10);
    JTextField time_min = new JTextField(10);
    JCheckBox x_max_b = new JCheckBox("X max");
    JCheckBox continuous_update_b = new JCheckBox("Continuous Update");
    JCheckBox upd_limits_b = new JCheckBox("");
    JCheckBox upd_limits = new JCheckBox("Upd. Limits");
    JCheckBox time_max_b = new JCheckBox("T max");
    JLabel pix_x_min = new JLabel();
    JTextField x_max = new JTextField(10);
    JTextField time_max = new JTextField(10);
    JCheckBox keep_ratio_b = new JCheckBox("Keep ratio");
    JCheckBox experiment_b = new JCheckBox("Experiment");
    JTextField experiment = new JTextField(20);
    JCheckBox shot_b = new JCheckBox("Shot");
    JTextField shot = new JTextField(25);
    JCheckBox horizontal_flip_b = new JCheckBox("Horizontal flip");
    JCheckBox upd_event_b = new JCheckBox("Update event");
    JTextField upd_event = new JTextField(20);
    JCheckBox def_node_b = new JCheckBox("Default node");
    JTextField def_node = new JTextField(20);
    JCheckBox vertical_flip_b = new JCheckBox("Vertical Flip");
    JPanel p9 = new JPanel(new BorderLayout(2, 2));
    JButton ok = new JButton("Ok");
    JButton apply = new JButton("Apply");
    JButton reset = new JButton("Reset");
    JButton erase = new JButton("Erase");
    JButton cancel = new JButton("Cancel");
    static final int LINE = 0;
    static final int POINT = 1;
    static final int BOTH = 2;
    static final int NONE = 3;
    static final int BROWSE_X = 0;
    static final int BROWSE_Y = 1;

    public SetupDataDialog(Frame fw, String frame_title) {
        super(fw, frame_title, false);
        this.setModal(true);
        this.main_scope = (jScopeFacade)fw;
        this.error_w = new SError(fw);
        this.expand_expr = new ExpandExp(fw, this);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setVisible(false);
        JPanel p1 = new JPanel(new FlowLayout(0));
        p1.add(this.title_b);
        p1.add(this.title);
        p1.add(this.expand);
        JPanel p2 = new JPanel(new FlowLayout(0));
        this.sig_label.setText("Signal Label");
        p2.add(this.sig_label);
        p2.add(this.signal_label);
        p2.add(this.error);
        JPanel p3 = new JPanel(new FlowLayout(0));
        this.y_lab.setText("Y");
        p3.add(this.y_lab);
        p3.add(this.y_expr);
        p3.add(this.y_log);
        JPanel p4 = new JPanel(new FlowLayout(0));
        p4.add(this.y_label_b);
        p4.add(this.y_label);
        this.pix_y_min.setText("Pixel Y min");
        p4.add(this.pix_y_min);
        this.pix_y_min.setVisible(false);
        p4.add(this.y_min_b);
        p4.add(this.y_min);
        this.pix_y_max.setText("Pixel Y max");
        p4.add(this.pix_y_max);
        this.pix_y_max.setVisible(false);
        p4.add(this.y_max_b);
        p4.add(this.y_max);
        p4.add(this.image_b);
        JPanel p5 = new JPanel(new FlowLayout(0));
        this.x_lab.setText("X");
        p5.add(this.x_lab);
        p5.add(this.x_expr);
        p5.add(this.time_min_b);
        this.time_min_b.setVisible(false);
        p5.add(this.time_min);
        this.time_min.setVisible(false);
        p5.add(this.time_max_b);
        p5.add(this.time_max);
        this.time_max_b.setVisible(false);
        this.time_max.setVisible(false);
        p5.add(this.x_log);
        JPanel p6 = new JPanel(new FlowLayout(0));
        p6.add(this.x_label_b);
        p6.add(this.x_label);
        this.pix_x_min.setText("Pixel X min");
        p6.add(this.pix_x_min);
        this.pix_x_min.setVisible(false);
        p6.add(this.x_min_b);
        p6.add(this.x_min);
        this.pix_x_max.setText("Pixel X max");
        p6.add(this.pix_x_max);
        this.pix_x_max.setVisible(false);
        p6.add(this.x_max_b);
        p6.add(this.x_max);
        p6.add(this.continuous_update_b);
        p6.add(this.keep_ratio_b);
        this.keep_ratio_b.setVisible(false);
        JPanel p7 = new JPanel(new FlowLayout(0));
        p7.add(this.experiment_b);
        p7.add(this.experiment);
        p7.add(this.shot_b);
        p7.add(this.shot);
        p7.add(this.upd_limits_b);
        JPanel pp1 = new JPanel();
        this.upd_limits.setMargin(new Insets(1, 1, 1, 1));
        BevelBorder bb = (BevelBorder)BorderFactory.createBevelBorder(1);
        pp1.setBorder(bb);
        pp1.add(this.upd_limits);
        p7.add(pp1);
        p7.add(this.horizontal_flip_b);
        this.horizontal_flip_b.setVisible(false);
        JPanel p8 = new JPanel(new FlowLayout(0));
        p8.add(this.upd_event_b);
        p8.add(this.upd_event);
        p8.add(this.def_node_b);
        p8.add(this.def_node);
        p8.add(this.vertical_flip_b);
        this.vertical_flip_b.setVisible(false);
        this.p9.setBorder(BorderFactory.createLoweredBevelBorder());
        this.signalList = new SList();
        this.p9.add("Center", this.signalList);
        JPanel p10 = new JPanel();
        p10.setLayout(new FlowLayout());
        p10.setBounds(12, 347, 660, 40);
        p10.add(this.ok);
        p10.add(this.apply);
        p10.add(this.reset);
        p10.add(this.erase);
        p10.add(this.cancel);
        this.getContentPane().add(p1);
        this.getContentPane().add(p2);
        this.getContentPane().add(p3);
        this.getContentPane().add(p4);
        this.getContentPane().add(p5);
        this.getContentPane().add(p6);
        this.getContentPane().add(p7);
        this.getContentPane().add(p8);
        this.getContentPane().add(this.p9);
        this.getContentPane().add(p10);
        this.title_b.addItemListener(this);
        this.expand.addActionListener(this);
        this.signal_label.addKeyListener(this);
        this.error.addActionListener(this);
        this.y_expr.addKeyListener(this);
        this.y_label_b.addItemListener(this);
        this.y_min_b.addItemListener(this);
        this.y_min.addKeyListener(this);
        this.y_max_b.addItemListener(this);
        this.y_max.addKeyListener(this);
        this.image_b.addItemListener(this);
        this.x_expr.addKeyListener(this);
        this.x_label_b.addItemListener(this);
        this.x_min_b.addItemListener(this);
        this.x_min.addKeyListener(this);
        this.x_max_b.addItemListener(this);
        this.x_max.addKeyListener(this);
        this.upd_limits_b.addItemListener(this);
        this.time_max_b.addItemListener(this);
        this.time_max.addKeyListener(this);
        this.time_min_b.addItemListener(this);
        this.time_min.addKeyListener(this);
        this.experiment_b.addItemListener(this);
        this.experiment.addKeyListener(this);
        this.shot_b.addItemListener(this);
        this.shot.addKeyListener(this);
        this.upd_event_b.addItemListener(this);
        this.def_node_b.addItemListener(this);
        this.ok.addActionListener(this);
        this.apply.addActionListener(this);
        this.reset.addActionListener(this);
        this.erase.addActionListener(this);
        this.cancel.addActionListener(this);
        this.pack();
        this.y_expr.setPreferredSize(this.y_expr.getSize());
        this.x_expr.setPreferredSize(this.x_expr.getSize());
        p3.setPreferredSize(p3.getSize());
        this.p9.setPreferredSize(this.p9.getSize());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SetupDataDialog.this.cancelOperation();
            }
        });
        SymContainer aSymContainer = new SymContainer();
        this.addContainerListener(aSymContainer);
    }

    public void Show(Waveform w, int col, int row) {
        this.wave = (jScopeMultiWave)w;
        this.wi = (MdsWaveInterface)this.wave.wi;
        this.wi = new MdsWaveInterface(this.wave, ((MdsWaveInterface)this.wave.wi).dp, ((MdsWaveInterface)this.wave.wi).def_vals);
        this.wi.defaults = ((MdsWaveInterface)this.wave.wi).defaults;
        this.putWindowSetup((MdsWaveInterface)this.wave.wi);
        this.updateDataSetup();
        this.setLocationRelativeTo(w.getParent());
        this.signalList.signalSelect(this.wave.GetSelectedSignal());
        this.setTitle("Wave Setup for column " + col + " row " + row);
        jScopeFacade.jScopeSetUI(this);
        jScopeFacade.jScopeSetUI(this.error_w);
        this.error_w.pack();
        jScopeFacade.jScopeSetUI(this.expand_expr);
        this.expand_expr.pack();
        this.pack();
        this.setVisible(true);
    }

    public void SetColorList() {
        this.signalList.SetColorList();
    }

    public void selectSignal(int sig) {
        this.signalList.setSignalSelect(sig);
    }

    private void resetDefaultFlags() {
        boolean state = true;
        this.wi.defaults = -1;
        if (this.wi.is_image) {
            this.wi.defaults &= 0xFFFF3FFF;
        }
        this.title_b.setSelected(state);
        this.title.setEditable(!state);
        this.shot_b.setSelected(state);
        this.shot.setEditable(!state);
        this.experiment_b.setSelected(state);
        this.experiment.setEditable(!state);
        if (this.image_b.isSelected()) {
            this.time_max_b.setSelected(state);
            this.time_max.setEditable(!state);
            this.time_min_b.setSelected(state);
            this.time_min.setEditable(!state);
            this.y_max_b.setSelected(false);
            this.y_max.setEditable(true);
            this.y_min_b.setSelected(false);
            this.y_min.setEditable(true);
            this.x_max_b.setSelected(false);
            this.x_max.setEditable(true);
            this.x_min_b.setSelected(false);
            this.x_min.setEditable(true);
        } else {
            this.y_max_b.setSelected(state);
            this.y_max.setEditable(!state);
            this.y_min_b.setSelected(state);
            this.y_min.setEditable(!state);
            this.x_max_b.setSelected(state);
            this.x_max.setEditable(!state);
            this.x_min_b.setSelected(state);
            this.x_min.setEditable(!state);
        }
        this.x_label_b.setSelected(state);
        this.x_label.setEditable(!state);
        this.y_label_b.setSelected(state);
        this.y_label.setEditable(!state);
        this.upd_event_b.setSelected(state);
        this.upd_event.setEditable(!state);
        this.def_node_b.setSelected(state);
        this.def_node.setEditable(!state);
        this.PutDefaultValues();
    }

    private void setDefaultFlags(int flags) {
        block14: for (int i = 0; i < 32; ++i) {
            switch (i) {
                case 16: {
                    this.title_b.setSelected((flags & 1 << i) == 1 << i);
                    continue block14;
                }
                case 8: {
                    this.shot_b.setSelected((flags & 1 << i) == 1 << i);
                    continue block14;
                }
                case 7: {
                    this.experiment_b.setSelected((flags & 1 << i) == 1 << i);
                    continue block14;
                }
                case 13: {
                    if (this.image_b.isSelected()) {
                        this.time_max_b.setSelected((flags & 1 << i) == 1 << i);
                        continue block14;
                    }
                    this.x_max_b.setSelected((flags & 1 << i) == 1 << i);
                    continue block14;
                }
                case 12: {
                    if (this.image_b.isSelected()) {
                        this.time_min_b.setSelected((flags & 1 << i) == 1 << i);
                        continue block14;
                    }
                    this.x_min_b.setSelected((flags & 1 << i) == 1 << i);
                    continue block14;
                }
                case 10: {
                    this.x_label_b.setSelected((flags & 1 << i) == 1 << i);
                    continue block14;
                }
                case 15: {
                    this.y_max_b.setSelected((flags & 1 << i) == 1 << i);
                    continue block14;
                }
                case 14: {
                    this.y_min_b.setSelected((flags & 1 << i) == 1 << i);
                    continue block14;
                }
                case 11: {
                    this.y_label_b.setSelected((flags & 1 << i) == 1 << i);
                    continue block14;
                }
                case 17: {
                    this.upd_event_b.setSelected((flags & 1 << i) == 1 << i);
                    continue block14;
                }
                case 9: {
                    this.def_node_b.setSelected((flags & 1 << i) == 1 << i);
                    continue block14;
                }
                case 0: {
                    this.upd_limits_b.setSelected((flags & 1 << i) == 1 << i);
                }
            }
        }
    }

    private int getDefaultFlags() {
        int value = 0;
        value = this.title_b.isSelected() ? (value |= 0x10000) : (value &= 0xFFFEFFFF);
        value = this.shot_b.isSelected() ? (value |= 0x100) : (value &= 0xFFFFFEFF);
        value = this.experiment_b.isSelected() ? (value |= 0x80) : (value &= 0xFFFFFF7F);
        if (this.image_b.isSelected()) {
            value = this.time_max_b.isSelected() ? (value |= 0x2000) : (value &= 0xFFFFDFFF);
            value = this.time_min_b.isSelected() ? (value |= 0x1000) : (value &= 0xFFFFEFFF);
        } else {
            value = this.x_max_b.isSelected() ? (value |= 0x2000) : (value &= 0xFFFFDFFF);
            value = this.x_min_b.isSelected() ? (value |= 0x1000) : (value &= 0xFFFFEFFF);
        }
        value = this.x_label_b.isSelected() ? (value |= 0x400) : (value &= 0xFFFFFBFF);
        value = this.y_max_b.isSelected() ? (value |= 0x8000) : (value &= 0xFFFF7FFF);
        value = this.y_min_b.isSelected() ? (value |= 0x4000) : (value &= 0xFFFFBFFF);
        value = this.y_label_b.isSelected() ? (value |= 0x800) : (value &= 0xFFFFF7FF);
        value = this.upd_event_b.isSelected() ? (value |= 0x20000) : (value &= 0xFFFDFFFF);
        value = this.def_node_b.isSelected() ? (value |= 0x200) : (value &= 0xFFFFFDFF);
        value = this.upd_limits_b.isSelected() ? (value |= 1) : (value &= 0xFFFFFFFE);
        return value;
    }

    public void PutDefaultValues() {
        boolean def_flag = this.title_b.isSelected();
        this.defaultButtonOperation(this.title, def_flag, this.wi.GetDefaultValue(16, def_flag));
        this.putShotValue(this.shot_b.isSelected());
        def_flag = this.experiment_b.isSelected();
        this.defaultButtonOperation(this.experiment, def_flag, this.wi.GetDefaultValue(7, def_flag));
        if (this.image_b.isSelected()) {
            def_flag = this.time_max_b.isSelected();
            this.defaultButtonOperation(this.time_max, def_flag, this.wi.GetDefaultValue(13, def_flag));
            if (!def_flag) {
                this.time_max.setText(this.wi.cin_timemax);
            }
            def_flag = this.time_min_b.isSelected();
            this.defaultButtonOperation(this.time_min, def_flag, this.wi.GetDefaultValue(12, def_flag));
            if (!def_flag) {
                this.time_min.setText(this.wi.cin_timemin);
            }
            this.x_min.setText(this.wi.cin_xmin);
            this.x_max.setText(this.wi.cin_xmax);
        } else {
            def_flag = this.x_max_b.isSelected();
            this.defaultButtonOperation(this.x_max, def_flag, this.wi.GetDefaultValue(13, def_flag));
            def_flag = this.x_min_b.isSelected();
            this.defaultButtonOperation(this.x_min, def_flag, this.wi.GetDefaultValue(12, def_flag));
        }
        def_flag = this.x_label_b.isSelected();
        this.defaultButtonOperation(this.x_label, def_flag, this.wi.GetDefaultValue(10, def_flag));
        def_flag = this.y_max_b.isSelected();
        this.defaultButtonOperation(this.y_max, def_flag, this.wi.GetDefaultValue(15, def_flag));
        def_flag = this.y_min_b.isSelected();
        this.defaultButtonOperation(this.y_min, def_flag, this.wi.GetDefaultValue(14, def_flag));
        def_flag = this.y_label_b.isSelected();
        this.defaultButtonOperation(this.y_label, def_flag, this.wi.GetDefaultValue(11, def_flag));
        def_flag = this.upd_event_b.isSelected();
        this.defaultButtonOperation(this.upd_event, def_flag, this.wi.GetDefaultValue(17, def_flag));
        def_flag = this.def_node_b.isSelected();
        this.defaultButtonOperation(this.def_node, def_flag, this.wi.GetDefaultValue(9, def_flag));
        def_flag = this.upd_limits_b.isSelected();
        this.defaultButtonOperation(this.upd_limits, def_flag, this.wi.GetDefaultValue(0, def_flag));
    }

    public void putWindowSetup(MdsWaveInterface wi) {
        if (wi == null) {
            this.eraseForm();
            return;
        }
        if (wi.is_image) {
            wi.defaults &= 0xFFFF3FFF;
        }
        this.setImageDialog(wi.is_image);
        this.wi.colorMap = wi.colorMap;
        this.wi.cexperiment = wi.cexperiment;
        this.wi.cin_shot = wi.cin_shot;
        this.wi.cin_upd_event = wi.cin_upd_event;
        this.wi.in_upd_event = wi.in_upd_event;
        this.wi.last_upd_event = wi.last_upd_event;
        this.wi.cin_def_node = wi.cin_def_node;
        this.wi.cin_xmax = wi.cin_xmax;
        this.wi.cin_xmin = wi.cin_xmin;
        this.wi.cin_ymax = wi.cin_ymax;
        this.wi.cin_ymin = wi.cin_ymin;
        this.wi.cin_upd_limits = wi.cin_upd_limits;
        this.wi.cin_timemin = wi.cin_timemin;
        this.wi.cin_timemax = wi.cin_timemax;
        this.wi.cin_title = wi.cin_title;
        this.wi.cin_xlabel = wi.cin_xlabel;
        this.wi.cin_ylabel = wi.cin_ylabel;
        this.wi.legend_x = wi.legend_x;
        this.wi.legend_y = wi.legend_y;
        this.wi.show_legend = wi.show_legend;
        this.wi.reversed = wi.reversed;
        this.wi.is_image = wi.is_image;
        this.wi.keep_ratio = wi.keep_ratio;
        this.wi.horizontal_flip = wi.horizontal_flip;
        this.wi.vertical_flip = wi.vertical_flip;
        this.image_b.setSelected(wi.is_image);
        this.keep_ratio_b.setSelected(wi.keep_ratio);
        this.horizontal_flip_b.setSelected(wi.horizontal_flip);
        this.vertical_flip_b.setSelected(wi.vertical_flip);
        this.setDefaultFlags(wi.defaults);
        this.PutDefaultValues();
        this.signal_label.setText("");
        this.x_expr.setText("");
        this.y_expr.setText("");
        this.x_log.setSelected(wi.x_log);
        this.y_log.setSelected(wi.y_log);
        this.continuous_update_b.setSelected(wi.isContinuousUpdate);
        this.signalList.init(wi);
    }

    private void setImageDialog(boolean state) {
        if (state) {
            this.sig_label.setVisible(false);
            this.signal_label.setVisible(false);
            this.time_min_b.setVisible(true);
            this.time_min.setVisible(true);
            this.time_max_b.setVisible(true);
            this.time_max.setVisible(true);
            this.pix_x_max.setVisible(true);
            this.pix_x_min.setVisible(true);
            this.x_max_b.setVisible(false);
            this.x_min_b.setVisible(false);
            this.continuous_update_b.setVisible(false);
            this.pix_y_max.setVisible(true);
            this.pix_y_min.setVisible(true);
            this.y_max_b.setVisible(false);
            this.y_min_b.setVisible(false);
            this.upd_limits_b.setVisible(false);
            this.upd_limits.getParent().setVisible(false);
            this.x_log.setVisible(false);
            this.y_log.setVisible(false);
            this.signalList.setVisible(false);
            this.p9.setVisible(false);
            this.error.setVisible(false);
            this.keep_ratio_b.setVisible(true);
            this.horizontal_flip_b.setVisible(true);
            this.vertical_flip_b.setVisible(true);
            this.y_lab.setText("Frames");
            this.x_lab.setText("Times");
            this.x_expr.setPreferredSize(null);
            this.x_expr.setColumns(24);
        } else {
            this.sig_label.setVisible(true);
            this.signal_label.setVisible(true);
            this.time_min_b.setVisible(false);
            this.time_min.setVisible(false);
            this.time_max_b.setVisible(false);
            this.time_max.setVisible(false);
            this.pix_x_max.setVisible(false);
            this.pix_x_min.setVisible(false);
            this.x_max_b.setVisible(true);
            this.x_min_b.setVisible(true);
            this.continuous_update_b.setVisible(false);
            this.pix_y_max.setVisible(false);
            this.pix_y_min.setVisible(false);
            this.y_max_b.setVisible(true);
            this.y_min_b.setVisible(true);
            this.upd_limits_b.setVisible(true);
            this.upd_limits.getParent().setVisible(true);
            this.x_log.setVisible(true);
            this.y_log.setVisible(true);
            this.signalList.setVisible(true);
            this.p9.setVisible(true);
            this.error.setVisible(true);
            this.x_lab.setVisible(true);
            this.keep_ratio_b.setVisible(false);
            this.horizontal_flip_b.setVisible(false);
            this.vertical_flip_b.setVisible(false);
            this.y_lab.setText("Y");
            this.x_lab.setText("X");
            this.x_expr.setPreferredSize(null);
            this.x_expr.setColumns(58);
        }
        this.pack();
        this.x_expr.setPreferredSize(this.x_expr.getSize());
    }

    public void eraseForm() {
        this.title.setText("");
        this.signal_label.setText("");
        this.x_expr.setText("");
        this.x_label.setText("");
        this.x_label.setForeground(Color.black);
        this.time_max.setText("");
        this.time_max.setForeground(Color.black);
        this.x_max.setText("");
        this.x_max.setForeground(Color.black);
        this.x_min.setText("");
        this.x_min.setForeground(Color.black);
        this.time_min.setText("");
        this.time_min.setForeground(Color.black);
        this.y_expr.setText("");
        this.y_max.setText("");
        this.y_max.setForeground(Color.black);
        this.y_min.setText("");
        this.y_min.setForeground(Color.black);
        this.y_label.setText("");
        this.y_label.setForeground(Color.black);
        this.experiment.setText("");
        this.shot.setText("");
        this.upd_event.setText("");
        this.def_node.setText("");
        this.shot.setForeground(Color.black);
        this.resetDefaultFlags();
        this.signalList.reset();
        this.signalList.signalListRefresh();
    }

    public boolean isChanged(Data[] s) {
        MdsWaveInterface wave_wi = (MdsWaveInterface)this.wave.wi;
        if (wave_wi == null) {
            return true;
        }
        if (wave_wi.getModified()) {
            return true;
        }
        if (s.length != wave_wi.num_waves) {
            return true;
        }
        if (this.signalList.getNumShot() != wave_wi.num_shot) {
            return true;
        }
        if (!this.main_scope.equalsString(this.title.getText(), wave_wi.cin_title)) {
            return true;
        }
        if (!this.main_scope.equalsString(this.x_max.getText(), wave_wi.cin_xmax)) {
            return true;
        }
        if (!this.main_scope.equalsString(this.x_min.getText(), wave_wi.cin_xmin)) {
            return true;
        }
        if (this.image_b.isSelected()) {
            if (!this.main_scope.equalsString(this.time_max.getText(), wave_wi.cin_timemax)) {
                return true;
            }
            if (!this.main_scope.equalsString(this.time_min.getText(), wave_wi.cin_timemin)) {
                return true;
            }
        }
        if (!this.main_scope.equalsString(this.x_label.getText(), wave_wi.cin_xlabel)) {
            return true;
        }
        if (this.x_log.isSelected() != wave_wi.x_log) {
            return true;
        }
        if (this.upd_limits.isSelected() != wave_wi.cin_upd_limits) {
            return true;
        }
        if (!this.main_scope.equalsString(this.y_max.getText(), wave_wi.cin_ymax)) {
            return true;
        }
        if (!this.main_scope.equalsString(this.y_min.getText(), wave_wi.cin_ymin)) {
            return true;
        }
        if (!this.main_scope.equalsString(this.y_label.getText(), wave_wi.cin_ylabel)) {
            return true;
        }
        if (this.y_log.isSelected() != wave_wi.y_log) {
            return true;
        }
        if (!this.main_scope.equalsString(this.shot.getText(), wave_wi.in_shot)) {
            return true;
        }
        if (!this.main_scope.equalsString(this.upd_event.getText(), wave_wi.cin_upd_event)) {
            return true;
        }
        if (!this.main_scope.equalsString(this.def_node.getText(), wave_wi.cin_def_node)) {
            return true;
        }
        if (!this.main_scope.equalsString(this.experiment.getText(), wave_wi.cexperiment)) {
            return true;
        }
        if (this.getDefaultFlags() != wave_wi.defaults) {
            return true;
        }
        if (this.image_b.isSelected() != wave_wi.is_image) {
            return true;
        }
        if (this.keep_ratio_b.isSelected() != wave_wi.keep_ratio) {
            return true;
        }
        if (this.horizontal_flip_b.isSelected() != wave_wi.horizontal_flip) {
            return true;
        }
        if (this.vertical_flip_b.isSelected() != wave_wi.vertical_flip) {
            return true;
        }
        for (int i = 0; i < wave_wi.num_waves; ++i) {
            if (!this.main_scope.equalsString(s[i].x_expr, wave_wi.in_x[i])) {
                return true;
            }
            if (!this.main_scope.equalsString(s[i].y_expr, wave_wi.in_y[i])) {
                return true;
            }
            if (!this.main_scope.equalsString(s[i].up_err, wave_wi.in_up_err[i])) {
                return true;
            }
            if (this.main_scope.equalsString(s[i].low_err, wave_wi.in_low_err[i])) continue;
            return true;
        }
        return false;
    }

    private void updateDataSetup() {
        this.setCursor(new Cursor(3));
        try {
            this.signalList.updateList();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "alert", 0);
        }
        this.setCursor(new Cursor(0));
    }

    private void updateGlobalWI() {
        if (!this.experiment_b.isSelected() && !this.main_scope.equalsString(this.experiment.getText(), this.wi.cexperiment)) {
            this.wi.cexperiment = this.experiment.getText();
        }
        if (!this.shot_b.isSelected() && !this.main_scope.equalsString(this.shot.getText(), this.wi.cin_shot)) {
            this.wi.cin_shot = this.shot.getText();
        }
        if (!this.upd_event_b.isSelected() && !this.main_scope.equalsString(this.upd_event.getText(), this.wi.cin_upd_event)) {
            this.wi.cin_upd_event = this.upd_event.getText();
        }
        if (!this.def_node_b.isSelected() && !this.main_scope.equalsString(this.def_node.getText(), this.wi.cin_def_node)) {
            this.wi.cin_def_node = this.def_node.getText();
        }
        if (!this.time_max_b.isSelected() && !this.main_scope.equalsString(this.time_max.getText(), this.wi.cin_timemax)) {
            this.wi.cin_timemax = this.time_max.getText();
        }
        if (!this.time_min_b.isSelected() && !this.main_scope.equalsString(this.time_min.getText(), this.wi.cin_timemin)) {
            this.wi.cin_timemin = this.time_min.getText();
        }
        if (!this.x_max_b.isSelected() && !this.main_scope.equalsString(this.x_max.getText(), this.wi.cin_xmax)) {
            this.wi.cin_xmax = this.x_max.getText();
        }
        if (!this.x_min_b.isSelected() && !this.main_scope.equalsString(this.x_min.getText(), this.wi.cin_xmin)) {
            this.wi.cin_xmin = this.x_min.getText();
        }
        if (!this.upd_limits_b.isSelected() && this.upd_limits.isSelected() != this.wi.cin_upd_limits) {
            this.wi.cin_upd_limits = this.upd_limits.isSelected();
        }
        if (!this.y_max_b.isSelected() && !this.main_scope.equalsString(this.y_max.getText(), this.wi.cin_ymax)) {
            this.wi.cin_ymax = this.y_max.getText();
        }
        if (!this.y_min_b.isSelected() && !this.main_scope.equalsString(this.y_min.getText(), this.wi.cin_ymin)) {
            this.wi.cin_ymin = this.y_min.getText();
        }
        if (!this.title_b.isSelected() && !this.main_scope.equalsString(this.title.getText(), this.wi.cin_title)) {
            this.wi.cin_title = this.title.getText();
        }
        if (!this.x_label_b.isSelected() && !this.main_scope.equalsString(this.x_label.getText(), this.wi.cin_xlabel)) {
            this.wi.cin_xlabel = this.x_label.getText();
        }
        if (!this.y_label_b.isSelected() && !this.main_scope.equalsString(this.y_label.getText(), this.wi.cin_ylabel)) {
            this.wi.cin_ylabel = this.y_label.getText();
        }
        this.wi.isContinuousUpdate = false;
    }

    private int updateWI() {
        Data[] s = this.signalList.getSignals();
        int num_signal = s.length;
        if (num_signal == 0) {
            if (this.wave.wi != null) {
                this.wave.wi.Erase();
            }
            return 1;
        }
        this.wi.setModified(this.isChanged(s));
        this.main_scope.setChange(this.wi.getModified());
        this.wi.is_image = this.image_b.isSelected();
        this.wi.keep_ratio = this.keep_ratio_b.isSelected();
        this.wi.horizontal_flip = this.horizontal_flip_b.isSelected();
        this.wi.vertical_flip = this.vertical_flip_b.isSelected();
        if (!this.wi.getModified()) {
            for (int i = 0; i < this.wave.wi.num_waves; ++i) {
                this.wave.wi.markers[i] = s[i].marker;
                this.wave.wi.markers_step[i] = s[i].marker_step;
                this.wave.wi.interpolates[i] = s[i].interpolate;
                this.wave.wi.mode2D[i] = s[i].mode2D;
                this.wave.wi.mode1D[i] = s[i].mode1D;
                this.wave.wi.colors_idx[i] = s[i].color_idx;
                this.wave.wi.in_label[i] = s[i].label;
            }
            return 0;
        }
        this.updateGlobalWI();
        this.wi.num_waves = num_signal;
        this.wi.experiment = new String(this.experiment.getText());
        this.wi.in_shot = new String(this.shot.getText());
        this.wi.in_def_node = new String(this.def_node.getText());
        this.wi.in_xmax = new String(this.x_max.getText());
        this.wi.in_xmin = new String(this.x_min.getText());
        this.wi.in_timemax = new String(this.time_max.getText());
        this.wi.in_timemin = new String(this.time_min.getText());
        this.wi.in_ymax = new String(this.y_max.getText());
        this.wi.in_ymin = new String(this.y_min.getText());
        this.wi.in_title = new String(this.title.getText());
        this.wi.in_xlabel = new String(this.x_label.getText());
        this.wi.in_ylabel = new String(this.y_label.getText());
        this.wi.x_log = this.x_log.isSelected();
        this.wi.y_log = this.y_log.isSelected();
        this.wi.in_upd_limits = this.upd_limits.isSelected();
        this.wi.num_shot = this.signalList.getNumShot();
        this.wi.defaults = this.getDefaultFlags();
        this.wi.in_label = new String[num_signal];
        this.wi.in_x = new String[num_signal];
        this.wi.in_y = new String[num_signal];
        this.wi.in_up_err = new String[num_signal];
        this.wi.in_low_err = new String[num_signal];
        this.wi.markers = new int[num_signal];
        this.wi.markers_step = new int[num_signal];
        this.wi.colors_idx = new int[num_signal];
        this.wi.interpolates = new boolean[num_signal];
        this.wi.mode2D = new int[num_signal];
        this.wi.mode1D = new int[num_signal];
        this.wi.isContinuousUpdate = false;
        if (s[0].shot != (long)UNDEF_SHOT) {
            this.wi.shots = new long[num_signal];
        }
        for (int i = 0; i < num_signal; ++i) {
            if (s[i].label != null) {
                this.wi.in_label[i] = new String(s[i].label);
            }
            if (s[i].x_expr != null) {
                this.wi.in_x[i] = new String(s[i].x_expr);
            }
            if (s[i].y_expr != null) {
                this.wi.in_y[i] = new String(s[i].y_expr);
            }
            if (this.wi.shots != null) {
                this.wi.shots[i] = s[i].shot;
            }
            if (this.wi.is_image) continue;
            this.wi.markers[i] = s[i].marker;
            this.wi.markers_step[i] = s[i].marker_step;
            this.wi.interpolates[i] = s[i].interpolate;
            this.wi.mode2D[i] = s[i].mode2D;
            this.wi.mode1D[i] = s[i].mode1D;
            if (s[i].up_err != null) {
                this.wi.in_up_err[i] = new String(s[i].up_err);
            }
            if (s[i].low_err != null) {
                this.wi.in_low_err[i] = new String(s[i].low_err);
            }
            this.wi.colors_idx[i] = s[i].color_idx;
        }
        this.wave.wi = this.wi;
        return 0;
    }

    private int checkSetup() {
        int error = 0;
        boolean def_exp = true;
        boolean def_shot = true;
        this.main_scope.SetStatusLabel("");
        if (this.experiment.getText() == null || this.experiment.getText().trim().length() == 0) {
            def_exp = false;
        }
        if (this.shot.getText() == null || this.shot.getText().trim().length() == 0) {
            def_shot = false;
        }
        if (def_exp ^ def_shot && !def_shot) {
            JOptionPane.showMessageDialog(null, "Experiment defined but undefined shot", "alert", 0);
            error = 1;
        }
        this.updateDataSetup();
        if (this.updateWI() != 0) {
            JOptionPane.showMessageDialog(null, "Nothing to evaluate", "alert", 0);
            error = 1;
        }
        return error;
    }

    private void applyWaveform() {
        this.checkSetup();
        this.setCursor(new Cursor(3));
        try {
            this.main_scope.wave_panel.Refresh(this.wave, "Update ");
        }
        catch (Throwable e) {
            this.main_scope.SetStatusLabel("Error during apply: " + e);
            this.setCursor(new Cursor(0));
        }
        this.setCursor(new Cursor(0));
    }

    @Override
    public void processWaveformEvent(WaveformEvent e) {
        jScopeMultiWave w = (jScopeMultiWave)e.getSource();
        this.wave.removeWaveformListener(this);
        switch (e.getID()) {
            case 2010: {
                String full_error = ((MdsWaveInterface)w.wi).getErrorString();
                if (full_error != null) {
                    JOptionPane.showMessageDialog(this, full_error, "alert", 0);
                }
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void cancelOperation() {
        this.setVisible(false);
        this.signalList.reset();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object ob = e.getSource();
        if (this.getCursor().getType() == 3) {
            return;
        }
        if (ob == this.erase) {
            this.eraseForm();
        }
        if (ob == this.cancel) {
            this.cancelOperation();
        }
        if (ob == this.apply || ob == this.ok) {
            this.wave.addWaveformListener(this);
            this.applyWaveform();
            if (ob == this.ok) {
                this.setVisible(false);
                this.signalList.reset();
            }
        }
        if (ob == this.reset) {
            this.signalList.reset();
            this.putWindowSetup((MdsWaveInterface)this.wave.wi);
        }
        if (ob == this.error && this.y_expr.getText().trim().length() != 0) {
            if (this.signalList.getSignalSelect() == -1) {
                this.updateDataSetup();
            }
            if (this.signalList.getSignalSelect() != -1) {
                this.signalList.updateError();
                this.error_w.setLocationRelativeTo(this);
                this.error_w.setVisible(true);
            }
        }
        if (ob == this.expand) {
            this.expand_expr.setExpressionString(this.x_expr.getText(), this.y_expr.getText());
            this.expand_expr.setSize(600, 400);
            this.expand_expr.setLocationRelativeTo(this);
            this.expand_expr.setVisible(true);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Object ob = e.getSource();
        char key = e.getKeyChar();
        if (key == '\uffff') {
            return;
        }
        if (key == '\n' && (ob == this.y_expr || ob == this.x_expr || ob == this.shot || ob == this.experiment || ob == this.signal_label)) {
            this.updateDataSetup();
            e.consume();
        }
        if (ob instanceof TextField && (ob == this.x_max || ob == this.y_max || ob == this.x_min || ob == this.y_min || ob == this.shot || ob == this.time_max || ob == this.time_min) && !Character.isDigit(key) && key != '\u007f' && key != '.' && key != '+' && key != '-') {
            return;
        }
    }

    private void defaultButtonOperation(Object obj, boolean state, String val) {
        if (obj instanceof JTextField) {
            JTextField text = (JTextField)obj;
            if (state) {
                text.setForeground(Color.blue);
                text.setEditable(false);
            } else {
                text.setForeground(Color.black);
                text.setEditable(true);
            }
            if (val != null && val.trim().length() != 0) {
                text.setText(val);
            } else {
                text.setText("");
            }
        }
        if (obj instanceof JCheckBox) {
            JCheckBox check = (JCheckBox)obj;
            if (state) {
                check.setEnabled(false);
                check.setForeground(Color.blue);
            } else {
                check.setForeground(Color.black);
                check.setEnabled(true);
            }
            if (val != null && val.trim().length() != 0 && val.equals("false")) {
                check.setSelected(false);
            } else {
                check.setSelected(true);
            }
        }
    }

    private void putShotValue(boolean def_flag) {
        this.wi.defaults = def_flag ? (this.wi.defaults |= 0x100) : (this.wi.defaults &= 0xFFFFFEFF);
        switch (this.wi.GetShotIdx()) {
            case 0: {
                this.shot.setForeground(Color.black);
                this.shot.setEditable(true);
                break;
            }
            case 1: {
                this.shot.setForeground(Color.blue);
                this.shot.setEditable(false);
                break;
            }
            case 2: {
                this.shot.setForeground(Color.red);
                this.shot.setEditable(false);
            }
        }
        this.shot.setText(this.wi.GetUsedShot());
    }

    private void DefaultButtonChange(Object ob) {
        boolean def_flag;
        if (ob == this.title_b) {
            def_flag = this.title_b.isSelected();
            this.defaultButtonOperation(this.title, def_flag, this.wi.GetDefaultValue(16, def_flag));
        }
        if (ob == this.shot_b) {
            this.putShotValue(this.shot_b.isSelected());
        }
        if (ob == this.experiment_b) {
            def_flag = this.experiment_b.isSelected();
            this.defaultButtonOperation(this.experiment, def_flag, this.wi.GetDefaultValue(7, def_flag));
        }
        if (ob == this.upd_event_b) {
            def_flag = this.upd_event_b.isSelected();
            this.defaultButtonOperation(this.upd_event, def_flag, this.wi.GetDefaultValue(17, def_flag));
        }
        if (ob == this.def_node_b) {
            def_flag = this.def_node_b.isSelected();
            this.defaultButtonOperation(this.def_node, def_flag, this.wi.GetDefaultValue(9, def_flag));
        }
        if (ob == this.x_max_b) {
            def_flag = this.x_max_b.isSelected();
            this.defaultButtonOperation(this.x_max, def_flag, this.wi.GetDefaultValue(13, def_flag));
        }
        if (ob == this.x_min_b) {
            def_flag = this.x_min_b.isSelected();
            this.defaultButtonOperation(this.x_min, def_flag, this.wi.GetDefaultValue(12, def_flag));
        }
        if (ob == this.time_max_b) {
            def_flag = this.time_max_b.isSelected();
            this.defaultButtonOperation(this.time_max, def_flag, this.wi.GetDefaultValue(13, def_flag));
        }
        if (ob == this.time_min_b) {
            def_flag = this.time_min_b.isSelected();
            this.defaultButtonOperation(this.time_min, def_flag, this.wi.GetDefaultValue(12, def_flag));
        }
        if (ob == this.x_label_b) {
            def_flag = this.x_label_b.isSelected();
            this.defaultButtonOperation(this.x_label, def_flag, this.wi.GetDefaultValue(10, def_flag));
        }
        if (ob == this.y_max_b) {
            def_flag = this.y_max_b.isSelected();
            this.defaultButtonOperation(this.y_max, def_flag, this.wi.GetDefaultValue(15, def_flag));
        }
        if (ob == this.y_min_b) {
            def_flag = this.y_min_b.isSelected();
            this.defaultButtonOperation(this.y_min, def_flag, this.wi.GetDefaultValue(14, def_flag));
        }
        if (ob == this.y_label_b) {
            def_flag = this.y_label_b.isSelected();
            this.defaultButtonOperation(this.y_label, def_flag, this.wi.GetDefaultValue(11, def_flag));
        }
        if (ob == this.upd_limits_b) {
            def_flag = this.upd_limits_b.isSelected();
            this.defaultButtonOperation(this.upd_limits, def_flag, this.wi.GetDefaultValue(0, def_flag));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object ob = e.getSource();
        if (ob instanceof JCheckBox) {
            if (ob == this.image_b) {
                this.eraseForm();
                this.setImageDialog(this.image_b.isSelected());
                return;
            }
            this.DefaultButtonChange(ob);
        }
    }

    void SetupDataDialog_componentAdded(ContainerEvent event) {
    }

    class SymContainer
    extends ContainerAdapter {
        SymContainer() {
        }

        @Override
        public void componentAdded(ContainerEvent event) {
            Object object = event.getSource();
            if (object == SetupDataDialog.this) {
                SetupDataDialog.this.SetupDataDialog_componentAdded(event);
            }
        }
    }

    class ExpandExp
    extends JDialog
    implements ActionListener {
        private JLabel lab_x;
        private JLabel lab_y;
        private JTextArea x_expr;
        private JTextArea y_expr;
        private JButton ok;
        private JButton cancel;
        private SetupDataDialog conf_dialog;

        ExpandExp(Frame _fw, SetupDataDialog conf_diag) {
            super(_fw, "Expand Expression Dialog", false);
            this.setModal(true);
            this.conf_dialog = conf_diag;
            this.getContentPane().setLayout(new BorderLayout());
            JPanel p1 = new JPanel();
            p1.setLayout(new BoxLayout(p1, 1));
            JPanel p2 = new JPanel(new FlowLayout(0));
            this.lab_y = new JLabel("Y Expression:");
            p2.add(this.lab_y);
            p1.add(p2);
            this.y_expr = new JTextArea(50, 20);
            JScrollPane scroller = new JScrollPane(this.y_expr);
            p1.add(scroller);
            JPanel p3 = new JPanel(new FlowLayout(0));
            this.lab_x = new JLabel("X Expression:");
            p3.add(this.lab_x);
            p1.add(p3);
            this.x_expr = new JTextArea(50, 20);
            scroller = new JScrollPane(this.x_expr);
            p1.add(scroller);
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout(1));
            this.ok = new JButton("Ok");
            this.ok.addActionListener(this);
            p.add(this.ok);
            this.cancel = new JButton("Cancel");
            this.cancel.addActionListener(this);
            p.add(this.cancel);
            this.getContentPane().add("Center", p1);
            this.getContentPane().add("South", p);
        }

        public void setExpressionString(String x, String y) {
            if (SetupDataDialog.this.image_b.isSelected()) {
                this.lab_x.setText("Times Expression:");
                this.lab_y.setText("Frames Expression:");
            } else {
                this.lab_x.setText("X Expression:");
                this.lab_y.setText("Y Expression:");
            }
            if (x != null) {
                this.x_expr.setText(x);
            }
            if (y != null) {
                this.y_expr.setText(y);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object ob = e.getSource();
            if (ob == this.ok) {
                this.conf_dialog.x_expr.setText(this.x_expr.getText());
                this.conf_dialog.y_expr.setText(this.y_expr.getText());
                SetupDataDialog.this.updateDataSetup();
            }
            this.setVisible(false);
        }
    }

    class SList
    extends JPanel
    implements ItemListener {
        private JList<String> sig_list;
        private DefaultListModel<String> list_model = new DefaultListModel();
        private JComboBox<String> mode1D;
        private JComboBox<String> mode2D;
        private JComboBox<String> color;
        private JComboBox<String> marker;
        private JTextField marker_step_t;
        private Vector<Data> signals = new Vector();
        private long[] shots = null;
        private int list_num_shot = 0;
        private int sel_signal = -1;

        public SList() {
            BorderLayout bl = new BorderLayout(25, 1);
            this.setLayout(bl);
            SetupDataDialog.this.lab = new JLabel("Signals list");
            this.add("North", SetupDataDialog.this.lab);
            this.list_model.addElement("Select this item to add new expression");
            this.sig_list = new JList<String>(this.list_model);
            JScrollPane scroll_sig_list = new JScrollPane(this.sig_list);
            this.sig_list.setSelectionMode(0);
            this.sig_list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    SList.this.signalSelect(((JList)e.getSource()).getSelectedIndex() - 1);
                }
            });
            this.sig_list.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    char key = e.getKeyChar();
                    if (key == '\u007f') {
                        SList.this.removeSignalSetup();
                    }
                }
            });
            this.add("Center", scroll_sig_list);
            JPanel p = new JPanel(new GridLayout(4, 1));
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = 2;
            c.gridwidth = 0;
            c.insets = new Insets(5, 5, 5, 5);
            p.setLayout(gridbag);
            this.mode1D = new JComboBox();
            this.mode1D.addItem("Line");
            this.mode1D.addItem("No Line");
            this.mode1D.addItem("Step Plot");
            this.mode1D.addItemListener(this);
            gridbag.setConstraints(this.mode1D, c);
            p.add(this.mode1D);
            this.mode2D = new JComboBox();
            this.mode2D.addItem("y & time");
            this.mode2D.addItem("x & y");
            this.mode2D.addItem("y & x");
            this.mode2D.addItem("Image");
            this.mode2D.addItemListener(this);
            gridbag.setConstraints(this.mode2D, c);
            p.add(this.mode2D);
            this.color = new JComboBox();
            this.SetColorList();
            this.color.addItemListener(this);
            gridbag.setConstraints(this.color, c);
            p.add(this.color);
            this.marker = new JComboBox();
            for (int i = 0; i < Signal.markerList.length; ++i) {
                this.marker.addItem(Signal.markerList[i]);
            }
            this.marker.addItemListener(this);
            gridbag.setConstraints(this.marker, c);
            p.add(this.marker);
            c.gridwidth = 1;
            SetupDataDialog.this.lab = new JLabel("M.Step");
            gridbag.setConstraints(SetupDataDialog.this.lab, c);
            p.add(SetupDataDialog.this.lab);
            c.fill = 0;
            c.gridwidth = 0;
            this.marker_step_t = new JTextField(3);
            this.marker_step_t.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (SList.this.getSignalSelect() != -1) {
                        try {
                            ((Data)((SList)SList.this).signals.elementAt((int)SList.this.getSignalSelect())).marker_step = Integer.parseInt(SList.this.marker_step_t.getText());
                        }
                        catch (NumberFormatException ex) {
                            SList.this.marker_step_t.setText("1");
                        }
                    }
                }
            });
            gridbag.setConstraints(this.marker_step_t, c);
            p.add(this.marker_step_t);
            this.add("East", p);
            SetupDataDialog.this.lab = new JLabel("");
            this.add("South", SetupDataDialog.this.lab);
            this.setOptionState(false);
        }

        public void setSignalSelect(int sig) {
            this.sel_signal = sig;
        }

        public int getSignalSelect() {
            if (this.sig_list.getModel().getSize() == 2 && SetupDataDialog.this.image_b.isSelected()) {
                return 0;
            }
            return this.sel_signal;
        }

        private void signalSelect(int sig) {
            if (sig + 1 >= this.sig_list.getModel().getSize()) {
                return;
            }
            this.setSignalSelect(sig);
            int id = this.getSignalSelect() + 1;
            this.sig_list.setSelectedIndex(id);
            this.sig_list.ensureIndexIsVisible(id);
            if (sig >= 0) {
                if (this.getSignalSelect() < this.signals.size()) {
                    this.putSignalSetup(this.signals.elementAt(this.getSignalSelect()));
                } else {
                    this.resetSignalSetup();
                }
            }
            this.setOptionState(this.getSignalSelect() >= 0);
        }

        private void setOptionState(boolean state) {
            this.marker.setEnabled(state);
            this.mode1D.setEnabled(state);
            this.mode2D.setEnabled(state);
            this.color.setEnabled(state);
            if (this.getSignalSelect() == -1) {
                this.marker_step_t.setEditable(false);
            }
        }

        public int getNumShot() {
            if (this.shots != null) {
                return this.shots.length;
            }
            return 0;
        }

        public void SetColorList() {
            String[] colors_name = ((SetupDataDialog)SetupDataDialog.this).main_scope.color_dialog.GetColorsName();
            if (this.color.getItemCount() != 0) {
                this.color.removeAllItems();
            }
            if (colors_name != null) {
                for (int i = 0; i < colors_name.length; ++i) {
                    this.color.addItem(colors_name[i]);
                }
            }
        }

        public int findSignalSetup(Data ws) {
            for (int i = 0; i < this.signals.size(); ++i) {
                if (!this.signals.elementAt(i).equals(ws)) continue;
                return i;
            }
            return -1;
        }

        public void updateSignalSetup(int idx, Data ws) {
            this.signals.setElementAt(ws, idx);
        }

        public void removeSignalSetup() {
            int num_shot = 1;
            int num_signal = this.signals.size();
            if (this.shots != null && this.shots.length > 0) {
                num_shot = this.shots.length;
            }
            if (this.getSignalSelect() != -1) {
                int start_idx = this.getSignalSelect() / num_shot * num_shot;
                int end_idx = start_idx + num_shot;
                for (int i = 0; i < num_signal; ++i) {
                    if (i < start_idx || i >= end_idx) continue;
                    this.list_model.removeElementAt(start_idx + 1);
                    this.signals.removeElementAt(start_idx);
                }
            }
            this.signalSelect(-1);
            SetupDataDialog.this.signal_label.setText("");
            SetupDataDialog.this.x_expr.setText("");
            SetupDataDialog.this.y_expr.setText("");
        }

        private void setMarkerTextState(int marker_idx) {
            if (marker_idx > 0 && marker_idx < 5) {
                this.marker_step_t.setEditable(true);
            } else {
                this.marker_step_t.setText("1");
                this.marker_step_t.setEditable(false);
            }
        }

        private int getPlotMode1D(Data ws) {
            switch (ws.mode1D) {
                case 0: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 2;
                }
            }
            return 0;
        }

        private void setPlotMode1D(Data ws, int mode) {
            if (mode == 2) {
                ws.interpolate = true;
                ws.mode1D = 3;
            } else if (mode == 0) {
                ws.interpolate = true;
                ws.mode1D = 0;
            } else {
                ws.interpolate = false;
                ws.mode1D = 2;
            }
        }

        private int getPlotMode2D(Data ws) {
            return ws.mode2D;
        }

        private void setPlotMode2D(Data ws, int mode) {
            ws.mode2D = mode;
        }

        public void putSignalSetup(Data ws) {
            if (ws.label != null) {
                SetupDataDialog.this.signal_label.setText(ws.label);
            } else {
                SetupDataDialog.this.signal_label.setText("");
            }
            if (ws.x_expr != null) {
                SetupDataDialog.this.x_expr.setText(ws.x_expr);
            } else {
                SetupDataDialog.this.x_expr.setText("");
            }
            if (ws.y_expr != null) {
                SetupDataDialog.this.y_expr.setText(ws.y_expr);
            } else {
                SetupDataDialog.this.y_expr.setText("");
            }
            this.mode1D.setSelectedIndex(this.getPlotMode1D(ws));
            this.mode2D.setSelectedIndex(this.getPlotMode2D(ws));
            this.marker.setSelectedIndex(ws.marker);
            this.marker_step_t.setText("" + ws.marker_step);
            this.setMarkerTextState(ws.marker);
            try {
                this.color.setSelectedIndex(ws.color_idx);
            }
            catch (Exception exc) {
                this.color.setSelectedIndex(0);
            }
            if (SetupDataDialog.this.error_w.isVisible()) {
                SetupDataDialog.this.error_w.setError(ws);
            }
        }

        private void resetSignalSetup() {
            SetupDataDialog.this.signal_label.setText("");
            SetupDataDialog.this.x_expr.setText("");
            SetupDataDialog.this.y_expr.setText("");
            this.mode1D.setSelectedIndex(0);
            this.mode2D.setSelectedIndex(0);
            this.marker.setSelectedIndex(0);
            this.marker_step_t.setText("1");
            this.setMarkerTextState(0);
            this.color.setSelectedIndex(0);
        }

        public Data getSignalSetup() {
            Data ws = new Data();
            ws.label = new String(SetupDataDialog.this.signal_label.getText());
            ws.x_expr = new String(SetupDataDialog.this.x_expr.getText());
            ws.y_expr = new String(SetupDataDialog.this.y_expr.getText());
            this.setPlotMode1D(ws, this.mode1D.getSelectedIndex());
            this.setPlotMode2D(ws, this.mode2D.getSelectedIndex());
            ws.marker = this.marker.getSelectedIndex();
            try {
                ws.marker_step = Integer.parseInt(this.marker_step_t.getText());
            }
            catch (NumberFormatException e) {
                ws.marker_step = 1;
            }
            ws.color_idx = this.color.getSelectedIndex();
            return ws;
        }

        public void reset() {
            this.signalSelect(-1);
            if (this.signals.size() != 0) {
                this.signals.removeAllElements();
            }
        }

        public void init(WaveInterface wi) {
            if (wi != null) {
                int i;
                if (wi.shots != null) {
                    this.shots = new long[wi.num_shot];
                    for (i = 0; i < wi.num_shot; ++i) {
                        this.shots[i] = wi.shots[i];
                    }
                }
                this.list_num_shot = wi.num_shot;
                for (i = 0; i < wi.num_waves; ++i) {
                    Data ws = new Data();
                    ws.label = wi.in_label[i];
                    ws.x_expr = wi.in_x[i];
                    ws.y_expr = wi.in_y[i];
                    ws.up_err = wi.in_up_err[i];
                    ws.low_err = wi.in_low_err[i];
                    ws.interpolate = wi.interpolates[i];
                    ws.mode2D = wi.mode2D[i];
                    ws.mode1D = wi.mode1D[i];
                    ws.marker = wi.markers[i];
                    ws.marker_step = wi.markers_step[i];
                    ws.color_idx = wi.colors_idx[i];
                    ws.shot = wi.shots != null ? wi.shots[i] : (long)UNDEF_SHOT;
                    this.addSignalSetup(ws);
                }
                this.signalListRefresh();
            }
            if (this.getSignalSelect() == -1 && wi.num_waves > 0) {
                this.setSignalSelect(0);
            }
            this.signalSelect(this.getSignalSelect());
        }

        public Data[] getSignals() {
            Object[] s = new Data[this.signals.size()];
            this.signals.copyInto(s);
            return s;
        }

        private void addSignalSetup(Data ws) {
            this.signals.addElement(ws);
        }

        public void addSignals() {
            int color_idx = 0;
            if (SetupDataDialog.this.y_expr.getText().length() == 0) {
                return;
            }
            Data ws = this.getSignalSetup();
            int idx = this.findSignalSetup(ws);
            if (idx == -1) {
                if (this.shots != null && this.shots.length != 0) {
                    for (int i = 0; i < this.shots.length; ++i) {
                        ws.shot = this.shots[i];
                        ws.color_idx = color_idx;
                        color_idx = (color_idx + 1) % ((SetupDataDialog)SetupDataDialog.this).main_scope.color_dialog.GetNumColor();
                        this.addSignalSetup(ws);
                        this.signalListAdd(ws);
                        ws = this.getSignalSetup();
                    }
                } else {
                    ws.shot = UNDEF_SHOT;
                    this.addSignalSetup(ws);
                    this.signalListAdd(ws);
                }
                this.signalSelect(this.findSignalSetup(ws));
            }
        }

        public boolean evaluateShotList(String in_shot) throws IOException {
            this.list_num_shot = this.shots != null && this.shots.length != 0 ? this.shots.length : 1;
            SetupDataDialog.this.main_scope.SetMainShot();
            in_shot = MdsWaveInterface.containMainShot(in_shot, ((SetupDataDialog)SetupDataDialog.this).main_scope.wave_panel.getMainShotStr());
            long[] new_shots = SetupDataDialog.this.wi.GetShotArray(in_shot);
            if (new_shots == null) {
                if (this.shots == null) {
                    return false;
                }
                this.shots = null;
                return true;
            }
            if (this.shots == null) {
                this.shots = new_shots;
                return true;
            }
            if (this.shots.equals(new_shots)) {
                return false;
            }
            this.shots = new_shots;
            if (SetupDataDialog.this.image_b.isSelected() && this.shots.length > 1) {
                long[] sh = new long[]{this.shots[0]};
                this.shots = sh;
            }
            return true;
        }

        public void signalsRefresh() {
            int color_idx = 0;
            int k = 0;
            int n_shot = this.shots != null ? this.shots.length : 1;
            int num_sig = this.signals.size() / this.list_num_shot * n_shot;
            for (int j = 0; j < num_sig; j += n_shot) {
                for (int i = 0; i < n_shot; ++i) {
                    if (i < this.list_num_shot) {
                        this.signals.setElementAt(this.signals.elementAt(j + i), k);
                    } else {
                        Data ws = new Data();
                        ws.copy(this.signals.elementAt(j));
                        ws.color_idx = color_idx = (color_idx + 1) % ((SetupDataDialog)SetupDataDialog.this).main_scope.color_dialog.GetNumColor();
                        this.signals.insertElementAt(ws, k);
                    }
                    this.signals.elementAt((int)k).shot = this.shots != null ? this.shots[i] : (long)UNDEF_SHOT;
                    ++k;
                }
                for (int l = n_shot; l < this.list_num_shot; ++l) {
                    this.signals.removeElementAt(j + n_shot);
                }
            }
        }

        public void updateSignals() {
            int num_shot = 1;
            int num_signal = this.signals.size();
            if (this.findSignalSetup(this.getSignalSetup()) != -1) {
                return;
            }
            if (this.getSignalSelect() != -1) {
                if (this.shots != null && this.shots.length > 0) {
                    num_shot = this.shots.length;
                }
                int start_idx = this.getSignalSelect() / num_shot * num_shot;
                int end_idx = start_idx + num_shot;
                for (int i = 0; i < num_signal; ++i) {
                    if (i < start_idx || i >= end_idx) continue;
                    this.signals.elementAt((int)i).label = SetupDataDialog.this.signal_label.getText();
                    this.signals.elementAt((int)i).x_expr = SetupDataDialog.this.x_expr.getText();
                    this.signals.elementAt((int)i).y_expr = SetupDataDialog.this.y_expr.getText();
                    this.signalListReplace(i + 1, this.signals.elementAt(i));
                }
                this.signalSelect(start_idx);
            }
        }

        public void updateError() {
            if (this.getSignalSelect() == -1) {
                return;
            }
            SetupDataDialog.this.error_w.setError(this.signals.elementAt(this.getSignalSelect()));
        }

        public void signalListRefresh() {
            if (this.list_model.size() > 1) {
                this.sig_list.setSelectedIndex(0);
                this.list_model.removeRange(1, this.list_model.size() - 1);
            }
            for (int i = 0; i < this.signals.size(); ++i) {
                this.signalListAdd(this.signals.elementAt(i));
            }
        }

        private String getExpressionList(String expr) {
            String out = expr;
            StringTokenizer st = new StringTokenizer(expr, "\n");
            if (st.countTokens() > 1) {
                out = st.nextToken() + "... ";
            }
            return out;
        }

        private void signalListAdd(Data ws) {
            if (ws.shot != (long)UNDEF_SHOT) {
                if (ws.x_expr == null || ws.x_expr.length() == 0) {
                    this.list_model.addElement("Y : " + this.getExpressionList(ws.y_expr) + " Shot : " + ws.shot);
                } else {
                    this.list_model.addElement("Y : " + this.getExpressionList(ws.y_expr) + " X : " + this.getExpressionList(ws.x_expr) + " Shot : " + ws.shot);
                }
            } else if (ws.x_expr == null || ws.x_expr.length() == 0) {
                this.list_model.addElement("Y : " + this.getExpressionList(ws.y_expr) + " Shot : Undef");
            } else {
                this.list_model.addElement("Y : " + this.getExpressionList(ws.y_expr) + " X : " + this.getExpressionList(ws.x_expr) + " Shot : Undef");
            }
        }

        private void signalListReplace(int idx, Data ws) {
            if (ws.shot != (long)UNDEF_SHOT) {
                if (ws.x_expr == null || ws.x_expr.length() == 0) {
                    this.list_model.setElementAt("Y : " + this.getExpressionList(ws.y_expr) + " Shot : " + ws.shot, idx);
                } else {
                    this.list_model.setElementAt("Y : " + this.getExpressionList(ws.y_expr) + " X : " + this.getExpressionList(ws.x_expr) + " Shot : " + ws.shot, idx);
                }
            } else if (ws.x_expr == null || ws.x_expr.length() == 0) {
                this.list_model.setElementAt("Y : " + this.getExpressionList(ws.y_expr) + " Shot : Undef", idx);
            } else {
                this.list_model.setElementAt("Y : " + this.getExpressionList(ws.y_expr) + " X : " + this.getExpressionList(ws.x_expr) + " Shot : Undef", idx);
            }
        }

        public void updateList() throws IOException {
            if (this.getSignalSelect() == -1) {
                SetupDataDialog.this.signalList.addSignals();
            } else if (SetupDataDialog.this.y_expr.getText().trim().length() != 0) {
                SetupDataDialog.this.signalList.updateSignals();
            } else {
                this.removeSignalSetup();
            }
            if (this.evaluateShotList(SetupDataDialog.this.shot.getText())) {
                this.signalsRefresh();
                this.signalListRefresh();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object ob = e.getSource();
            if (ob instanceof JCheckBox) {
                SetupDataDialog.this.DefaultButtonChange(ob);
            }
            if (this.getSignalSelect() == -1 || SetupDataDialog.this.image_b.isSelected()) {
                return;
            }
            if (ob == this.marker) {
                int m_idx;
                this.signals.elementAt((int)this.getSignalSelect()).marker = m_idx = this.marker.getSelectedIndex();
                this.setMarkerTextState(m_idx);
            }
            if (ob == this.mode1D) {
                this.setPlotMode1D(this.signals.elementAt(this.getSignalSelect()), this.mode1D.getSelectedIndex());
            }
            if (ob == this.mode2D) {
                this.setPlotMode2D(this.signals.elementAt(this.getSignalSelect()), this.mode2D.getSelectedIndex());
            }
            if (ob == this.color) {
                this.signals.elementAt((int)this.getSignalSelect()).color_idx = this.color.getSelectedIndex();
            }
        }
    }

    class SError
    extends JDialog
    implements ActionListener {
        private JTextField e_up;
        private JTextField e_low;
        private JButton ok;
        private JButton cancel;
        private Data ws;

        SError(Frame fw) {
            super(fw, "Error Setup", true);
            GridBagConstraints c = new GridBagConstraints();
            GridBagLayout gridbag = new GridBagLayout();
            this.getContentPane().setLayout(gridbag);
            c.insets = new Insets(4, 4, 4, 4);
            c.fill = 1;
            c.gridwidth = 1;
            JLabel label = new JLabel("Error up");
            gridbag.setConstraints(label, c);
            this.getContentPane().add(label);
            c.gridwidth = 0;
            this.e_up = new JTextField(40);
            gridbag.setConstraints(this.e_up, c);
            this.getContentPane().add(this.e_up);
            c.gridwidth = 1;
            label = new JLabel("Error low");
            gridbag.setConstraints(label, c);
            this.getContentPane().add(label);
            c.gridwidth = 0;
            this.e_low = new JTextField(40);
            gridbag.setConstraints(this.e_low, c);
            this.getContentPane().add(this.e_low);
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout(1));
            this.ok = new JButton("Ok");
            this.ok.addActionListener(this);
            p.add(this.ok);
            this.cancel = new JButton("Cancel");
            this.cancel.addActionListener(this);
            p.add(this.cancel);
            c.gridwidth = 0;
            gridbag.setConstraints(p, c);
            this.getContentPane().add(p);
        }

        public void resetError() {
            this.e_up.setText("");
            this.e_low.setText("");
        }

        public void setError(Data ws_in) {
            this.ws = ws_in;
            this.resetError();
            if (this.ws.up_err != null) {
                this.e_up.setText(this.ws.up_err);
            }
            if (this.ws.up_err != null) {
                this.e_low.setText(this.ws.low_err);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object ob = e.getSource();
            if (ob == this.ok) {
                this.ws.up_err = new String(this.e_up.getText());
                this.ws.low_err = new String(this.e_low.getText());
                this.setVisible(false);
            }
            if (ob == this.cancel) {
                this.setVisible(false);
            }
        }
    }

    class Data {
        String label;
        String x_expr;
        String y_expr;
        long shot;
        int color_idx;
        boolean interpolate;
        int marker;
        int marker_step;
        String up_err;
        String low_err;
        int mode2D;
        int mode1D;

        Data() {
        }

        public boolean equals(Data ws) {
            if (this.x_expr != null ? !this.x_expr.equals(ws.x_expr) : ws.x_expr != null && ws.x_expr.length() != 0) {
                return false;
            }
            if (this.y_expr != null ? !this.y_expr.equals(ws.y_expr) : ws.y_expr != null && ws.y_expr.length() != 0) {
                return false;
            }
            return !(this.label != null ? !this.label.equals(ws.label) : ws.label != null && ws.label.length() != 0);
        }

        public void copy(Data ws) {
            if (ws.label != null) {
                this.label = new String(ws.label);
            }
            if (ws.x_expr != null) {
                this.x_expr = new String(ws.x_expr);
            }
            if (ws.y_expr != null) {
                this.y_expr = new String(ws.y_expr);
            }
            if (ws.up_err != null) {
                this.up_err = new String(ws.up_err);
            }
            if (ws.low_err != null) {
                this.low_err = new String(ws.low_err);
            }
            this.shot = ws.shot;
            this.color_idx = ws.color_idx;
            this.interpolate = ws.interpolate;
            this.marker = ws.marker;
            this.marker_step = ws.marker_step;
        }
    }
}

