/*
 * Decompiled with CFR 0.152.
 */
package mds.jscope;

import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import mds.jscope.jScopeDefaultValues;
import mds.jscope.jScopeFacade;
import mds.wave.Grid;
import mds.wave.WaveInterface;
import mds.wave.Waveform;

public class SetupDefaults
extends JDialog
implements ActionListener {
    JTextField title;
    JTextField shot;
    JTextField experiment;
    JTextField x_max;
    JTextField x_min;
    JTextField x_label;
    JTextField y_max;
    JTextField y_min;
    JTextField y_label;
    JTextField def_node;
    JTextField upd_event;
    JButton ok;
    JButton cancel;
    JButton reset;
    JButton erase;
    JButton apply;
    JLabel lab;
    jScopeFacade main_scope;
    jScopeDefaultValues def_vals;
    boolean reversed;
    private JTextField x_grid_lines;
    private JTextField y_grid_lines;
    private JTextField vertical_offset;
    private JTextField horizontal_offset;
    private JComboBox<String> grid_mode;
    private JComboBox<String> legend_mode;
    private JComboBox<String> auto_color_mode;
    private JCheckBox reversed_b;
    private JCheckBox upd_limits;
    int curr_grid_mode = 0;
    int x_curr_lines_grid = 3;
    int y_curr_lines_grid = 3;
    int curr_legend_mode = 0;

    public SetupDefaults(Frame fw, String frame_title, jScopeDefaultValues def_vals) {
        super(fw, frame_title, true);
        this.setModal(true);
        this.main_scope = (jScopeFacade)fw;
        this.GetPropertiesValue();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Insets insets = new Insets(4, 4, 4, 4);
        this.getContentPane().setLayout(gridbag);
        c.insets = insets;
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 1;
        this.lab = new JLabel("Title");
        gridbag.setConstraints(this.lab, c);
        this.getContentPane().add(this.lab);
        c.gridwidth = 0;
        this.title = new JTextField(30);
        gridbag.setConstraints(this.title, c);
        this.getContentPane().add(this.title);
        c.gridwidth = 1;
        this.lab = new JLabel("Y Label");
        gridbag.setConstraints(this.lab, c);
        this.getContentPane().add(this.lab);
        this.y_label = new JTextField(25);
        gridbag.setConstraints(this.y_label, c);
        this.getContentPane().add(this.y_label);
        this.lab = new JLabel("Y min");
        gridbag.setConstraints(this.lab, c);
        this.getContentPane().add(this.lab);
        this.y_min = new JTextField(10);
        gridbag.setConstraints(this.y_min, c);
        this.getContentPane().add(this.y_min);
        this.lab = new JLabel("Y max");
        gridbag.setConstraints(this.lab, c);
        this.getContentPane().add(this.lab);
        c.gridwidth = 0;
        this.y_max = new JTextField(10);
        gridbag.setConstraints(this.y_max, c);
        this.getContentPane().add(this.y_max);
        c.gridwidth = 1;
        this.lab = new JLabel("X Label");
        gridbag.setConstraints(this.lab, c);
        this.getContentPane().add(this.lab);
        this.x_label = new JTextField(25);
        gridbag.setConstraints(this.x_label, c);
        this.getContentPane().add(this.x_label);
        this.lab = new JLabel("X min");
        gridbag.setConstraints(this.lab, c);
        this.getContentPane().add(this.lab);
        this.x_min = new JTextField(10);
        gridbag.setConstraints(this.x_min, c);
        this.getContentPane().add(this.x_min);
        this.lab = new JLabel("X max");
        gridbag.setConstraints(this.lab, c);
        this.getContentPane().add(this.lab);
        c.gridwidth = 0;
        this.x_max = new JTextField(10);
        gridbag.setConstraints(this.x_max, c);
        this.getContentPane().add(this.x_max);
        c.gridwidth = 1;
        this.lab = new JLabel("Experiment");
        gridbag.setConstraints(this.lab, c);
        this.getContentPane().add(this.lab);
        this.experiment = new JTextField(25);
        gridbag.setConstraints(this.experiment, c);
        this.getContentPane().add(this.experiment);
        this.lab = new JLabel("Shot");
        gridbag.setConstraints(this.lab, c);
        this.getContentPane().add(this.lab);
        c.gridwidth = 0;
        this.shot = new JTextField(30);
        gridbag.setConstraints(this.shot, c);
        this.getContentPane().add(this.shot);
        c.gridwidth = 1;
        this.lab = new JLabel("Update event");
        gridbag.setConstraints(this.lab, c);
        this.getContentPane().add(this.lab);
        this.upd_event = new JTextField(25);
        gridbag.setConstraints(this.upd_event, c);
        this.getContentPane().add(this.upd_event);
        this.lab = new JLabel("Default node");
        gridbag.setConstraints(this.lab, c);
        this.getContentPane().add(this.lab);
        c.gridwidth = 0;
        this.def_node = new JTextField(30);
        gridbag.setConstraints(this.def_node, c);
        this.getContentPane().add(this.def_node);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 2, 3));
        c.fill = 0;
        panel.add(new JLabel("   lines x:"));
        this.x_grid_lines = new JTextField(2);
        panel.add(this.x_grid_lines);
        this.x_grid_lines.addActionListener(this);
        this.x_grid_lines.setText("" + this.x_curr_lines_grid);
        panel.add(new JLabel("   lines y:"));
        this.y_grid_lines = new JTextField(2);
        panel.add(this.y_grid_lines);
        this.y_grid_lines.addActionListener(this);
        this.y_grid_lines.setText("" + this.y_curr_lines_grid);
        panel.add(new JLabel("   Vertical offset:"));
        this.vertical_offset = new JTextField(3);
        panel.add(this.vertical_offset);
        this.vertical_offset.addActionListener(this);
        this.vertical_offset.setText("");
        panel.add(new JLabel("   Horizontal offset:"));
        this.horizontal_offset = new JTextField(3);
        panel.add(this.horizontal_offset);
        this.horizontal_offset.addActionListener(this);
        this.horizontal_offset.setText("");
        gridbag.setConstraints(panel, c);
        this.getContentPane().add(panel);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new FlowLayout(0, 2, 3));
        c.fill = 0;
        this.reversed_b = new JCheckBox("Reversed");
        panel1.add(this.reversed_b);
        this.reversed_b.setHorizontalTextPosition(2);
        this.lab = new JLabel("Grid: Mode");
        panel1.add(this.lab);
        String[] grd = new String[]{"Dotted", "Gray"};
        this.grid_mode = new JComboBox<String>(grd);
        this.grid_mode.setSelectedIndex(this.curr_grid_mode);
        panel1.add(this.grid_mode);
        this.lab = new JLabel("Legend:");
        panel1.add(this.lab);
        this.legend_mode = new JComboBox();
        this.legend_mode.addItem("In Graphics");
        this.legend_mode.addItem("Fixed Bottom");
        this.legend_mode.addItem("Fixed Right");
        this.legend_mode.setSelectedIndex(this.curr_legend_mode);
        panel1.add(this.legend_mode);
        this.lab = new JLabel("Auto color:");
        panel1.add(this.lab);
        this.auto_color_mode = new JComboBox();
        this.auto_color_mode.addItem("on shot");
        this.auto_color_mode.addItem("on expression");
        this.auto_color_mode.setSelectedIndex(WaveInterface.auto_color_on_expr ? 1 : 0);
        panel1.add(this.auto_color_mode);
        this.upd_limits = new JCheckBox("Upd. limits", true);
        panel1.add(this.upd_limits);
        gridbag.setConstraints(panel1, c);
        this.getContentPane().add(panel1);
        JPanel p1 = new JPanel();
        this.ok = new JButton("Ok");
        this.ok.addActionListener(this);
        p1.add(this.ok);
        this.apply = new JButton("Apply");
        this.apply.addActionListener(this);
        p1.add(this.apply);
        this.reset = new JButton("Reset");
        this.reset.addActionListener(this);
        p1.add(this.reset);
        this.erase = new JButton("Erase");
        this.erase.addActionListener(this);
        p1.add(this.erase);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        p1.add(this.cancel);
        c.fill = 0;
        c.anchor = 10;
        c.gridwidth = 0;
        gridbag.setConstraints(p1, c);
        this.getContentPane().add(p1);
    }

    private int IsGridMode(String mode) {
        for (int i = 0; i < Grid.GRID_MODE.length; ++i) {
            if (!Grid.GRID_MODE[i].equals(mode)) continue;
            return i;
        }
        return -1;
    }

    private void GetPropertiesValue() {
        Properties js_prop = this.main_scope.js_prop;
        int val = 0;
        if (js_prop == null) {
            return;
        }
        String prop = js_prop.getProperty("jScope.reversed");
        this.reversed = prop != null && (prop.equals("true") || prop.equals("false")) ? new Boolean(prop) : false;
        prop = js_prop.getProperty("jScope.grid_mode");
        if (prop != null && (val = this.IsGridMode(prop)) > 0) {
            this.curr_grid_mode = val;
        }
        if ((prop = js_prop.getProperty("jScope.x_grid")) != null) {
            try {
                val = Integer.parseInt(prop);
                this.x_curr_lines_grid = val > 10 ? 10 : val;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((prop = js_prop.getProperty("jScope.y_grid")) != null) {
            try {
                val = Integer.parseInt(prop);
                this.y_curr_lines_grid = val > 10 ? 10 : val;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public int getLegendMode() {
        return this.curr_legend_mode;
    }

    public int getGridMode() {
        return this.curr_grid_mode;
    }

    public int getXLines() {
        return this.x_curr_lines_grid;
    }

    public int getYLines() {
        return this.y_curr_lines_grid;
    }

    public boolean getReversed() {
        return this.reversed;
    }

    public void eraseForm() {
        this.title.setText("");
        this.x_label.setText("");
        this.x_max.setText("");
        this.x_min.setText("");
        this.y_max.setText("");
        this.y_min.setText("");
        this.y_label.setText("");
        this.experiment.setText("");
        this.shot.setText("");
        this.upd_event.setText("");
        this.def_node.setText("");
        this.grid_mode.setSelectedIndex(0);
        this.x_grid_lines.setText("3");
        this.y_grid_lines.setText("3");
        this.horizontal_offset.setText("0");
        this.vertical_offset.setText("0");
        this.reversed_b.setSelected(false);
        this.upd_limits.setSelected(true);
    }

    private void setTextValue(JTextField t, String val) {
        if (val != null) {
            t.setText(val);
        }
    }

    private void initialize() {
        this.eraseForm();
        this.setTextValue(this.title, this.def_vals.title_str);
        this.setTextValue(this.y_label, this.def_vals.ylabel);
        this.setTextValue(this.x_label, this.def_vals.xlabel);
        this.setTextValue(this.y_max, this.def_vals.ymax);
        this.setTextValue(this.y_min, this.def_vals.ymin);
        this.setTextValue(this.x_max, this.def_vals.xmax);
        this.setTextValue(this.x_min, this.def_vals.xmin);
        this.setTextValue(this.experiment, this.def_vals.experiment_str);
        this.setTextValue(this.shot, this.def_vals.shot_str);
        this.setTextValue(this.upd_event, this.def_vals.upd_event_str);
        this.setTextValue(this.def_node, this.def_vals.def_node_str);
        this.upd_limits.setSelected(this.def_vals.upd_limits);
        this.grid_mode.setSelectedIndex(this.curr_grid_mode);
        this.legend_mode.setSelectedIndex(this.curr_legend_mode);
        this.x_grid_lines.setText("" + this.x_curr_lines_grid);
        this.y_grid_lines.setText("" + this.y_curr_lines_grid);
        this.reversed_b.setSelected(this.reversed);
        this.horizontal_offset.setText("" + Waveform.GetHorizontalOffset());
        this.vertical_offset.setText("" + Waveform.GetVerticalOffset());
    }

    public void SaveDefaultConfiguration(jScopeDefaultValues def_vals) {
        def_vals.experiment_str = new String(this.experiment.getText());
        def_vals.shot_str = new String(this.shot.getText());
        def_vals.xmax = new String(this.x_max.getText());
        def_vals.xmin = new String(this.x_min.getText());
        def_vals.ymax = new String(this.y_max.getText());
        def_vals.ymin = new String(this.y_min.getText());
        def_vals.title_str = new String(this.title.getText());
        def_vals.xlabel = new String(this.x_label.getText());
        def_vals.ylabel = new String(this.y_label.getText());
        def_vals.upd_event_str = new String(this.upd_event.getText());
        def_vals.def_node_str = new String(this.def_node.getText());
        def_vals.upd_limits = this.upd_limits.isSelected();
        this.curr_grid_mode = this.grid_mode.getSelectedIndex();
        this.curr_legend_mode = this.legend_mode.getSelectedIndex();
        this.reversed = this.reversed_b.getModel().isSelected();
        int h_ofs = 0;
        int v_ofs = 0;
        try {
            h_ofs = Integer.parseInt(this.horizontal_offset.getText().trim());
        }
        catch (NumberFormatException exc) {
            h_ofs = 0;
        }
        Waveform.SetHorizontalOffset(h_ofs);
        this.horizontal_offset.setText("" + h_ofs);
        try {
            v_ofs = Integer.parseInt(this.vertical_offset.getText().trim());
        }
        catch (NumberFormatException exc) {
            v_ofs = 0;
        }
        Waveform.SetVerticalOffset(v_ofs);
        this.vertical_offset.setText("" + v_ofs);
        WaveInterface.auto_color_on_expr = this.auto_color_mode.getSelectedIndex() != 0;
        try {
            this.x_curr_lines_grid = Integer.parseInt(this.x_grid_lines.getText().trim());
        }
        catch (NumberFormatException exc) {
            this.x_curr_lines_grid = 3;
        }
        if (this.x_curr_lines_grid > 10) {
            this.x_curr_lines_grid = 10;
        }
        this.x_grid_lines.setText("" + this.x_curr_lines_grid);
        try {
            this.y_curr_lines_grid = Integer.parseInt(this.y_grid_lines.getText().trim());
        }
        catch (NumberFormatException exc) {
            this.y_curr_lines_grid = 3;
        }
        if (this.y_curr_lines_grid > 10) {
            this.y_curr_lines_grid = 10;
        }
        this.y_grid_lines.setText("" + this.y_curr_lines_grid);
        def_vals.setIsEvaluated(false);
    }

    public void Show(Frame f, jScopeDefaultValues def_vals) {
        this.def_vals = def_vals;
        this.initialize();
        this.pack();
        this.setLocationRelativeTo(f);
        this.setVisible(true);
    }

    public boolean IsChanged(jScopeDefaultValues def_vals) {
        if (!this.main_scope.equalsString(this.shot.getText(), def_vals.shot_str)) {
            return true;
        }
        if (!this.main_scope.equalsString(this.experiment.getText(), def_vals.experiment_str)) {
            return true;
        }
        if (!this.main_scope.equalsString(this.upd_event.getText(), def_vals.upd_event_str)) {
            return true;
        }
        if (!this.main_scope.equalsString(this.def_node.getText(), def_vals.def_node_str)) {
            return true;
        }
        if (!this.main_scope.equalsString(this.title.getText(), def_vals.title_str)) {
            return true;
        }
        if (!this.main_scope.equalsString(this.x_max.getText(), def_vals.xmax)) {
            return true;
        }
        if (!this.main_scope.equalsString(this.x_min.getText(), def_vals.xmin)) {
            return true;
        }
        if (!this.main_scope.equalsString(this.x_label.getText(), def_vals.xlabel)) {
            return true;
        }
        if (!this.main_scope.equalsString(this.y_max.getText(), def_vals.ymax)) {
            return true;
        }
        if (!this.main_scope.equalsString(this.y_min.getText(), def_vals.ymin)) {
            return true;
        }
        if (!this.main_scope.equalsString(this.y_label.getText(), def_vals.ylabel)) {
            return true;
        }
        return this.upd_limits.isSelected() != def_vals.upd_limits;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object ob = e.getSource();
        if (ob == this.erase) {
            this.eraseForm();
        }
        if (ob == this.cancel) {
            this.setVisible(false);
        }
        if (ob == this.apply || ob == this.ok) {
            if (ob == this.ok) {
                this.setVisible(false);
            }
            this.main_scope.UpdateDefaultValues();
        }
        if (ob == this.reset) {
            this.initialize();
        }
    }
}

