/*
 * Decompiled with CFR 0.152.
 */
package mds.jscope;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrinterResolution;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import mds.connection.ConnectionEvent;
import mds.connection.ConnectionListener;
import mds.connection.UpdateEvent;
import mds.connection.UpdateEventListener;
import mds.jscope.AboutWindow;
import mds.jscope.ColorDialog;
import mds.jscope.FontSelection;
import mds.jscope.MdsWaveInterface;
import mds.jscope.ServerDialog;
import mds.jscope.SetupDataDialog;
import mds.jscope.SetupDefaults;
import mds.jscope.SignalsBoxDialog;
import mds.jscope.WindowDialog;
import mds.jscope.jScopeBrowseUrl;
import mds.jscope.jScopeDefaultValues;
import mds.jscope.jScopeMultiWave;
import mds.jscope.jScopeProperties;
import mds.jscope.jScopeWaveContainer;
import mds.jscope.jScopeWavePopup;
import mds.provider.MdsDataProvider;
import mds.provider.MdsDataProviderLocal;
import mds.provider.MdsDataProviderSsh;
import mds.wave.ColorMapDialog;
import mds.wave.DataServerItem;
import mds.wave.ImageTransferable;
import mds.wave.ProfileDialog;
import mds.wave.PropertiesEditor;
import mds.wave.WaveContainerEvent;
import mds.wave.WaveContainerListener;
import mds.wave.WaveInterface;
import mds.wave.Waveform;
import mds.wave.WaveformEvent;

public class jScopeFacade
extends JFrame
implements ActionListener,
ItemListener,
WindowListener,
WaveContainerListener,
UpdateEventListener,
ConnectionListener,
Printable {
    static final String JSCOPE_PROFILE;
    static final String JSCOPE_SERVERS;
    static final String JSCOPE_CONFIGURATIONS;
    static final String JSCOPE_PROPERTIES;
    static final String JSCOPE_PALETTE;
    private static final long serialVersionUID = 1L;
    public static boolean is_debug;
    public static final int MAX_NUM_SHOT = 30;
    public static final int MAX_VARIABLE = 10;
    static long refreshPeriod;
    JWindow aboutScreen;
    static boolean enableNetworkSelection;
    static String mdsDataServer;
    static String sshDataServer;
    protected JMenuBar mb;
    protected JMenu edit_m;
    protected JMenu look_and_feel_m;
    protected JMenu pointer_mode_m;
    protected JMenu customize_m;
    protected JMenu autoscale_m;
    protected JMenu network_m;
    protected JMenu help_m;
    JMenu servers_m;
    JMenu updates_m;
    private JCheckBoxMenuItem update_i;
    private JCheckBoxMenuItem update_when_icon_i;
    private JMenuItem exit_i;
    private JMenuItem win_i;
    protected JMenuItem default_i;
    protected JMenuItem use_i;
    protected JMenuItem pub_variables_i;
    protected JMenuItem save_as_i;
    protected JMenuItem use_last_i;
    protected JMenuItem save_i;
    protected JMenuItem color_i;
    protected JMenuItem print_all_i;
    protected JMenuItem open_i;
    protected JMenuItem close_i;
    protected JMenuItem server_list_i;
    protected JMenuItem font_i;
    protected JMenuItem save_all_as_text_i;
    private JCheckBoxMenuItem brief_error_i;
    private JMenuItem zoom_i;
    private JMenuItem point_i;
    private JMenuItem copy_i;
    private JMenuItem pan_i;
    private JMenuItem all_i;
    private JMenuItem allY_i;
    private JMenuItem print_i;
    private JMenuItem properties_i;
    private JPanel panel;
    private JPanel panel1;
    private final ButtonGroup pointer_mode = new ButtonGroup();
    private JRadioButton zoom;
    private JRadioButton point;
    private JRadioButton copy;
    private JRadioButton pan;
    private JLabel shot_l;
    private JTextField shot_t;
    private JTextField signal_expr;
    private JButton apply_b;
    private JFileChooser file_diag;
    protected String curr_directory;
    protected String last_directory;
    private JLabel point_pos;
    private JTextField info_text;
    private JTextField net_text;
    private WindowDialog win_diag;
    public ColorDialog color_dialog;
    public ColorMapDialog colorMapDialog;
    public FontSelection font_dialog;
    jScopeWaveContainer wave_panel;
    SetupDefaults setup_default;
    private PubVarDialog pub_var_diag;
    static int num_scope;
    private String config_file;
    static DataServerItem[] server_ip_list;
    ServerDialog server_diag;
    static boolean not_sup_local;
    private static jScopeFacade win;
    DocPrintJob prnJob = null;
    PrintRequestAttributeSet attrs;
    PrintService[] printersServices;
    PrintService printerSelection;
    Properties js_prop = null;
    int default_server_idx;
    boolean is_playing = false;
    int height = 500;
    int width = 700;
    int xpos = 50;
    int ypos = 50;
    jScopeDefaultValues def_values = new jScopeDefaultValues();
    SetupDataDialog setup_dialog;
    JProgressBar progress_bar;
    private jScopeBrowseUrl help_dialog;
    private boolean modified = false;
    static String macClassName;
    static String metalClassName;
    static String motifClassName;
    static String windowsClassName;
    JRadioButtonMenuItem macMenuItem;
    JRadioButtonMenuItem metalMenuItem;
    JRadioButtonMenuItem motifMenuItem;
    JRadioButtonMenuItem windowsMenuItem;
    static Component T_parentComponent;
    static Object T_message;
    static String T_title;
    static int T_messageType;
    BasicArrowButton incShot;
    BasicArrowButton decShot;
    int incShotValue = 0;
    private final String propertiesFile;
    public static final String VERSION;

    public static void ShowMessage(Component parentComponent, Object message, String title, int messageType) {
        T_parentComponent = parentComponent;
        T_message = message;
        T_title = title;
        T_messageType = messageType;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(T_parentComponent, T_message, T_title, T_messageType);
            }
        });
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)g;
        if (pageIndex == 0) {
            g2.translate(pf.getImageableX(), pf.getImageableY());
            RepaintManager currentManager = RepaintManager.currentManager(this);
            currentManager.setDoubleBufferingEnabled(false);
            g2.scale(0.12, 0.12);
            g2.translate(pf.getImageableWidth() / 2.0, pf.getImageableHeight() / 2.0);
            g2.translate(pf.getWidth() / 2.0, pf.getHeight() / 2.0);
            g.drawOval(0, 0, 100, 100);
            g.drawOval(0, 0, 200, 200);
            g.drawOval(0, 0, 300, 300);
            g.drawOval(0, 0, 400, 400);
            g.drawOval(0, 0, 500, 500);
            g.drawOval(0, 0, 600, 600);
            currentManager.setDoubleBufferingEnabled(true);
            return 0;
        }
        return 1;
    }

    public static void displayPageFormatAttributes(int idx, PageFormat myPageFormat) {
        System.out.println("+----------------------------------------------------------+");
        System.out.println("Index = " + idx);
        System.out.println("Width = " + myPageFormat.getWidth());
        System.out.println("Height = " + myPageFormat.getHeight());
        System.out.println("ImageableX = " + myPageFormat.getImageableX());
        System.out.println("ImageableY = " + myPageFormat.getImageableY());
        System.out.println("ImageableWidth = " + myPageFormat.getImageableWidth());
        System.out.println("ImageableHeight = " + myPageFormat.getImageableHeight());
        int o = myPageFormat.getOrientation();
        System.out.println("Orientation = " + (o == 1 ? "PORTRAIT" : (o == 0 ? "LANDSCAPE" : (o == 2 ? "REVERSE_LANDSCAPE" : "<invalid>"))));
        System.out.println("+----------------------------------------------------------+");
    }

    public void createAboutScreen() {
        AboutWindow aboutLabel = new AboutWindow();
        this.aboutScreen = new JWindow();
        this.aboutScreen.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                jScopeFacade.this.hideAbout();
            }
        });
        this.aboutScreen.getContentPane().add(aboutLabel);
        this.aboutScreen.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.aboutScreen.setLocation(screenSize.width / 2 - this.aboutScreen.getSize().width / 2, screenSize.height / 2 - this.aboutScreen.getSize().height / 2);
    }

    public void showAboutScreen() {
        this.aboutScreen.setVisible(true);
    }

    public void hideAbout() {
        this.aboutScreen.setVisible(false);
        this.aboutScreen.dispose();
        this.aboutScreen = null;
    }

    public jScopeFacade(int spos_x, int spos_y, String propFile) {
        String string = this.propertiesFile = propFile == null ? JSCOPE_PROPERTIES : propFile;
        if (num_scope == 0) {
            this.createAboutScreen();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jScopeFacade.this.showAboutScreen();
                }
            });
        }
        this.jScopeCreate(spos_x, spos_y);
    }

    public void jScopeCreate(int spos_x, int spos_y) {
        this.printersServices = PrintServiceLookup.lookupPrintServices(null, null);
        this.printerSelection = PrintServiceLookup.lookupDefaultPrintService();
        this.attrs = new HashPrintRequestAttributeSet();
        PrinterResolution res = new PrinterResolution(600, 600, 100);
        this.attrs.add(MediaSizeName.ISO_A4);
        this.attrs.add(OrientationRequested.LANDSCAPE);
        this.attrs.add(new MediaPrintableArea(5.0f, 5.0f, MediaSize.ISO.A4.getX(1000) - 5.0f, MediaSize.ISO.A4.getY(1000) - 5.0f, 1000));
        this.attrs.add(res);
        if (this.printerSelection != null) {
            this.prnJob = this.printerSelection.createPrintJob();
        }
        this.help_dialog = new jScopeBrowseUrl(this);
        try {
            String path = "jdocs/jScope.html";
            URL url = this.getClass().getClassLoader().getResource("jdocs/jScope.html");
            this.help_dialog.connectToBrowser(url);
        }
        catch (Exception path) {
            // empty catch block
        }
        this.setBounds(spos_x, spos_y, 750, 550);
        this.InitProperties();
        this.GetPropertiesValue();
        this.font_dialog = new FontSelection((Frame)this, "Waveform Font Selection");
        this.setup_default = new SetupDefaults((Frame)this, "Default Setup", this.def_values);
        this.color_dialog = new ColorDialog((Frame)this, "Color Configuration Dialog");
        String palette = this.js_prop.getProperty("jScope.color_palette_file");
        if (palette == null) {
            palette = JSCOPE_PALETTE;
            try {
                ColorMapDialog.exportPalette(new File(JSCOPE_PALETTE));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        this.colorMapDialog = new ColorMapDialog((Frame)this, palette);
        this.pub_var_diag = new PubVarDialog(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        this.addWindowListener(this);
        this.file_diag = new JFileChooser();
        this.file_diag.addChoosableFileFilter(new javax.swing.filechooser.FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".dat");
            }

            @Override
            public String getDescription() {
                return ".dat files";
            }
        });
        javax.swing.filechooser.FileFilter defaultFileFilter = new javax.swing.filechooser.FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".jscp");
            }

            @Override
            public String getDescription() {
                return ".jscp files";
            }
        };
        this.file_diag.addChoosableFileFilter(defaultFileFilter);
        this.file_diag.setFileFilter(defaultFileFilter);
        this.mb = new JMenuBar();
        this.setJMenuBar(this.mb);
        this.edit_m = new JMenu("File");
        this.mb.add(this.edit_m);
        JMenuItem browse_signals_i = new JMenuItem("Browse signals");
        this.edit_m.add(browse_signals_i);
        browse_signals_i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                jScopeFacade.this.wave_panel.ShowBrowseSignals();
            }
        });
        this.open_i = new JMenuItem("New Window");
        this.open_i.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.edit_m.add(this.open_i);
        this.open_i.addActionListener(this);
        this.look_and_feel_m = new JMenu("Look & Feel");
        this.edit_m.add(this.look_and_feel_m);
        JMenuItem sign = new JMenuItem("History...");
        sign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SignalsBoxDialog sig_box_diag = new SignalsBoxDialog(jScopeFacade.this, "Visited Signals", false);
                sig_box_diag.setVisible(true);
            }
        });
        this.edit_m.add(sign);
        this.edit_m.addSeparator();
        JMenuItem cb_copy = new JMenuItem("Copy to Clipboard");
        cb_copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dimension dim = jScopeFacade.this.wave_panel.getSize();
                BufferedImage ri = new BufferedImage(dim.width, dim.height, 1);
                Graphics2D g2d = (Graphics2D)ri.getGraphics();
                g2d.setBackground(Color.white);
                jScopeFacade.this.wave_panel.PrintAll(g2d, dim.height, dim.width);
                try {
                    ImageTransferable imageTransferable = new ImageTransferable(ri);
                    Clipboard cli = Toolkit.getDefaultToolkit().getSystemClipboard();
                    cli.setContents(imageTransferable, imageTransferable);
                }
                catch (Exception exc) {
                    System.out.println("Exception " + exc);
                }
            }
        });
        this.edit_m.add(cb_copy);
        this.edit_m.addSeparator();
        this.print_i = new JMenuItem("Print Setup ...");
        this.print_i.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.print_i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread print_cnf = new Thread(){

                    @Override
                    public void run() {
                        this.setName("Print Dialog Thread");
                        PrintService svc = PrintServiceLookup.lookupDefaultPrintService();
                        jScopeFacade.this.printerSelection = ServiceUI.printDialog(null, 100, 100, jScopeFacade.this.printersServices, svc, null, jScopeFacade.this.attrs);
                        if (jScopeFacade.this.printerSelection != null) {
                            System.out.println(jScopeFacade.this.printerSelection.getName() + " |||| " + jScopeFacade.this.printerSelection.getSupportedDocFlavors() + " |||| " + jScopeFacade.this.printerSelection.hashCode());
                            jScopeFacade.this.prnJob = jScopeFacade.this.printerSelection.createPrintJob();
                            jScopeFacade.this.PrintAllWaves(jScopeFacade.this.attrs);
                        }
                    }
                };
                print_cnf.start();
            }
        });
        this.edit_m.add(this.print_i);
        this.print_all_i = new JMenuItem("Print");
        this.print_all_i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread print_page = new Thread(){

                    @Override
                    public void run() {
                        this.setName("Print All Thread");
                        jScopeFacade.this.PrintAllWaves(jScopeFacade.this.attrs);
                    }
                };
                print_page.start();
            }
        });
        this.edit_m.add(this.print_all_i);
        this.edit_m.addSeparator();
        this.properties_i = new JMenuItem("Properties...");
        this.properties_i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesEditor pe = new PropertiesEditor(jScopeFacade.this, jScopeFacade.this.propertiesFile);
                pe.setVisible(true);
            }
        });
        this.edit_m.add(this.properties_i);
        this.edit_m.addSeparator();
        this.close_i = new JMenuItem("Close");
        this.close_i.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.edit_m.add(this.close_i);
        this.close_i.addActionListener(this);
        this.exit_i = new JMenuItem("Exit");
        this.exit_i.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.edit_m.add(this.exit_i);
        this.exit_i.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        ToggleUIListener toggleUIListener = new ToggleUIListener();
        this.metalMenuItem = (JRadioButtonMenuItem)this.look_and_feel_m.add(new JRadioButtonMenuItem("Java Look and Feel"));
        this.metalMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals("Metal"));
        this.metalMenuItem.setSelected(true);
        this.metalMenuItem.setEnabled(jScopeFacade.isAvailableLookAndFeel(metalClassName));
        group.add(this.metalMenuItem);
        this.metalMenuItem.addItemListener(toggleUIListener);
        this.motifMenuItem = (JRadioButtonMenuItem)this.look_and_feel_m.add(new JRadioButtonMenuItem("Motif Look and Feel"));
        this.motifMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals("CDE/Motif"));
        this.motifMenuItem.setEnabled(jScopeFacade.isAvailableLookAndFeel(motifClassName));
        group.add(this.motifMenuItem);
        this.motifMenuItem.addItemListener(toggleUIListener);
        this.windowsMenuItem = (JRadioButtonMenuItem)this.look_and_feel_m.add(new JRadioButtonMenuItem("Windows Style Look and Feel"));
        this.windowsMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals("Windows"));
        this.windowsMenuItem.setEnabled(jScopeFacade.isAvailableLookAndFeel(windowsClassName));
        group.add(this.windowsMenuItem);
        this.windowsMenuItem.addItemListener(toggleUIListener);
        this.macMenuItem = (JRadioButtonMenuItem)this.look_and_feel_m.add(new JRadioButtonMenuItem("Macintosh Look and Feel"));
        this.macMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals("Macintosh"));
        this.macMenuItem.setEnabled(jScopeFacade.isAvailableLookAndFeel(macClassName));
        group.add(this.macMenuItem);
        this.macMenuItem.addItemListener(toggleUIListener);
        this.pointer_mode_m = new JMenu("Pointer mode");
        this.mb.add(this.pointer_mode_m);
        this.point_i = new JMenuItem("Point");
        this.point_i.setAccelerator(KeyStroke.getKeyStroke(49, 2));
        this.point_i.addActionListener(this);
        this.pointer_mode_m.add(this.point_i);
        this.zoom_i = new JMenuItem("Zoom");
        this.zoom_i.setAccelerator(KeyStroke.getKeyStroke(50, 2));
        this.pointer_mode_m.add(this.zoom_i);
        this.zoom_i.addActionListener(this);
        this.pan_i = new JMenuItem("Pan");
        this.pan_i.setAccelerator(KeyStroke.getKeyStroke(51, 2));
        this.pointer_mode_m.add(this.pan_i);
        this.pan_i.addActionListener(this);
        this.copy_i = new JMenuItem("Copy");
        this.copy_i.setAccelerator(KeyStroke.getKeyStroke(52, 2));
        this.pointer_mode_m.add(this.copy_i);
        this.copy_i.addActionListener(this);
        this.pointer_mode_m.add(this.copy_i);
        this.customize_m = new JMenu("Customize");
        this.mb.add(this.customize_m);
        this.default_i = new JMenuItem("Global Settings ...");
        this.default_i.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.customize_m.add(this.default_i);
        this.default_i.addActionListener(this);
        this.win_i = new JMenuItem("Window ...");
        this.win_i.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.win_i.addActionListener(this);
        this.customize_m.add(this.win_i);
        this.font_i = new JMenuItem("Font selection ...");
        this.font_i.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.font_i.addActionListener(this);
        this.customize_m.add(this.font_i);
        this.color_i = new JMenuItem("Colors List ...");
        this.color_i.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.color_i.addActionListener(this);
        this.customize_m.add(this.color_i);
        this.pub_variables_i = new JMenuItem("Public variables ...");
        this.pub_variables_i.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.pub_variables_i.addActionListener(this);
        this.customize_m.add(this.pub_variables_i);
        this.brief_error_i = new JCheckBoxMenuItem("Brief Error", true);
        this.brief_error_i.addItemListener(this);
        this.customize_m.add(this.brief_error_i);
        this.customize_m.add(new JSeparator());
        this.use_last_i = new JMenuItem("Use last saved settings");
        this.use_last_i.addActionListener(this);
        this.use_last_i.setEnabled(false);
        this.customize_m.add(this.use_last_i);
        this.use_i = new JMenuItem("Use saved settings from ...");
        this.use_i.addActionListener(this);
        this.customize_m.add(this.use_i);
        this.customize_m.add(new JSeparator());
        this.save_i = new JMenuItem("Save current settings");
        this.save_i.setEnabled(false);
        this.save_i.addActionListener(this);
        this.customize_m.add(this.save_i);
        this.save_as_i = new JMenuItem("Save current settings as ...");
        this.customize_m.add(this.save_as_i);
        this.save_as_i.addActionListener(this);
        this.customize_m.add(new JSeparator());
        this.save_all_as_text_i = new JMenuItem("Save all as text ...");
        this.save_all_as_text_i.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.customize_m.add(this.save_all_as_text_i);
        this.save_all_as_text_i.addActionListener(this);
        this.updates_m = new JMenu("Updates");
        this.mb.add(this.updates_m);
        this.update_i = new JCheckBoxMenuItem("Disable", false);
        this.update_when_icon_i = new JCheckBoxMenuItem("Disable when icon", true);
        this.updates_m.add(this.update_i);
        this.updates_m.add(this.update_when_icon_i);
        this.autoscale_m = new JMenu("Autoscale");
        this.mb.add(this.autoscale_m);
        this.all_i = new JMenuItem("All");
        this.all_i.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.all_i.addActionListener(this);
        this.autoscale_m.add(this.all_i);
        this.allY_i = new JMenuItem("All Y");
        this.allY_i.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.autoscale_m.add(this.allY_i);
        this.allY_i.addActionListener(this);
        this.network_m = new JMenu("Network");
        this.mb.add(this.network_m);
        this.servers_m = new JMenu("Servers");
        this.network_m.add(this.servers_m);
        if (!enableNetworkSelection) {
            this.network_m.setEnabled(false);
        }
        this.servers_m.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                jScopeFacade.this.server_diag.addServerIpList(server_ip_list);
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }
        });
        this.server_list_i = new JMenuItem("Edit server list ...");
        this.network_m.add(this.server_list_i);
        this.server_list_i.addActionListener(this);
        this.point_pos = new JLabel("[0.000000000, 0.000000000]");
        this.point_pos.setFont(new Font("Courier", 0, 12));
        this.info_text = new JTextField(" Status : ", 85);
        this.info_text.setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel progress_pan = new JPanel(new FlowLayout(2, 0, 0));
        this.progress_bar = new JProgressBar(0, 100);
        this.progress_bar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.progress_bar.setStringPainted(true);
        progress_pan.add(this.progress_bar);
        this.help_m = new JMenu("Help");
        this.mb.add(this.help_m);
        JMenuItem about_i = new JMenuItem("About jScope");
        this.help_m.add(about_i);
        about_i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(jScopeFacade.this, "The jScope tutorial is available at www.mdsplus.org in \"Documentation/The MDSplus tutorial\" section", "", 1);
            }
        });
        this.setup_dialog = new SetupDataDialog((Frame)this, "Setup");
        this.wave_panel = this.buildWaveContainer();
        this.wave_panel.addWaveContainerListener(this);
        this.wave_panel.SetParams(1, this.setup_default.getGridMode(), this.setup_default.getLegendMode(), this.setup_default.getXLines(), this.setup_default.getYLines(), this.setup_default.getReversed());
        this.wave_panel.setPopupMenu(new jScopeWavePopup(this.setup_dialog, new ProfileDialog(null, null), this.colorMapDialog));
        this.getContentPane().add("Center", this.wave_panel);
        this.panel = new JPanel();
        this.panel.setLayout(new FlowLayout(0, 2, 3));
        this.shot_l = new JLabel("Shot");
        this.shot_t = new JTextField(10);
        this.shot_t.addActionListener(this);
        this.apply_b = new JButton("Apply");
        this.apply_b.addActionListener(this);
        this.point = new JRadioButton("Point");
        this.point.addItemListener(this);
        this.zoom = new JRadioButton("Zoom", true);
        this.zoom.addItemListener(this);
        this.pan = new JRadioButton("Pan");
        this.pan.addItemListener(this);
        this.copy = new JRadioButton("Copy");
        this.copy.addItemListener(this);
        this.pointer_mode.add(this.point);
        this.pointer_mode.add(this.zoom);
        this.pointer_mode.add(this.pan);
        this.pointer_mode.add(this.copy);
        this.panel.add(this.point);
        this.panel.add(this.zoom);
        this.panel.add(this.pan);
        this.panel.add(this.copy);
        this.panel.add(this.shot_l);
        this.decShot = new BasicArrowButton(7);
        this.panel.add(this.decShot);
        this.panel.add(this.shot_t);
        this.incShot = new BasicArrowButton(3);
        this.panel.add(this.incShot);
        this.decShot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (jScopeFacade.this.shot_t.getText() != null && jScopeFacade.this.shot_t.getText().trim().length() != 0 && !jScopeFacade.this.wave_panel.isBusy()) {
                    --jScopeFacade.this.incShotValue;
                    jScopeFacade.this.ArrowsIncDecShot();
                    jScopeFacade.this.UpdateAllWaves();
                }
            }
        });
        this.incShot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (jScopeFacade.this.shot_t.getText() != null && jScopeFacade.this.shot_t.getText().trim().length() != 0 && !jScopeFacade.this.wave_panel.isBusy()) {
                    ++jScopeFacade.this.incShotValue;
                    jScopeFacade.this.ArrowsIncDecShot();
                    jScopeFacade.this.UpdateAllWaves();
                }
            }
        });
        this.panel.add(this.apply_b);
        this.panel.add(new JLabel(" Signal: "));
        JPanel panel3 = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Insets insets = new Insets(2, 2, 2, 2);
        panel3.setLayout(gridbag);
        c.anchor = 17;
        c.fill = 2;
        c.insets = insets;
        c.weightx = 1.0;
        c.gridwidth = 1;
        this.signal_expr = new JTextField(25);
        this.signal_expr.addActionListener(this);
        gridbag.setConstraints(this.signal_expr, c);
        panel3.add(this.signal_expr);
        JPanel panel4 = new JPanel(new BorderLayout());
        panel4.add("West", this.panel);
        panel4.add("Center", panel3);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.add("West", progress_pan);
        panel2.add("Center", this.info_text);
        this.net_text = new JTextField(" Data server :", 25);
        panel2.add("East", this.net_text);
        this.net_text.setBorder(BorderFactory.createLoweredBevelBorder());
        this.info_text.setEditable(false);
        this.net_text.setEditable(false);
        this.panel1 = new JPanel();
        this.panel1.setLayout(new BorderLayout());
        this.panel1.add("North", panel4);
        this.panel1.add("Center", this.point_pos);
        this.panel1.add("South", panel2);
        this.getContentPane().add("South", this.panel1);
        this.color_dialog.SetReversed(this.setup_default.getReversed());
        if (is_debug) {
            MonMemory mon_mem = new MonMemory();
            mon_mem.start();
            JButton exec_gc = new JButton("Exec gc");
            exec_gc.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.gc();
                }
            });
            this.panel1.add("West", exec_gc);
        }
        this.InitDataServer();
        this.UpdateFont();
        this.UpdateColors();
    }

    protected jScopeWaveContainer buildWaveContainer() {
        int[] rows = new int[]{1, 0, 0, 0};
        return new jScopeWaveContainer(rows, this.def_values);
    }

    public void SetApplicationFonts(String font, int style, int size) {
        this.SetApplicationFonts(new Font(font, style, size));
    }

    public void SetApplicationFonts(Font font) {
        Font userEntryFont = font;
        Font defaultFont = font;
        Font boldFont = font;
        UIManager.put("Text.font", new FontUIResource(userEntryFont));
        UIManager.put("TextField.font", new FontUIResource(userEntryFont));
        UIManager.put("TextArea.font", new FontUIResource(userEntryFont));
        UIManager.put("TextPane.font", new FontUIResource(userEntryFont));
        UIManager.put("List.font", new FontUIResource(userEntryFont));
        UIManager.put("Table.font", new FontUIResource(userEntryFont));
        UIManager.put("ComboBox.font", new FontUIResource(userEntryFont));
        UIManager.put("Button.font", new FontUIResource(defaultFont));
        UIManager.put("Label.font", new FontUIResource(defaultFont));
        UIManager.put("Menu.font", new FontUIResource(defaultFont));
        UIManager.put("MenuItem.font", new FontUIResource(defaultFont));
        UIManager.put("ToolTip.font", new FontUIResource(defaultFont));
        UIManager.put("ToggleButton.font", new FontUIResource(defaultFont));
        UIManager.put("TitledBorder.font", new FontUIResource(boldFont));
        UIManager.put("PopupMenu.font", new FontUIResource(defaultFont));
        UIManager.put("TableHeader.font", new FontUIResource(defaultFont));
        UIManager.put("PasswordField.font", new FontUIResource(defaultFont));
        UIManager.put("CheckBoxMenuItem.font", new FontUIResource(defaultFont));
        UIManager.put("CheckBox.font", new FontUIResource(defaultFont));
        UIManager.put("RadioButtonMenuItem.font", new FontUIResource(defaultFont));
        UIManager.put("RadioButton.font", new FontUIResource(defaultFont));
        UIManager.put("ToolBar.font", new FontUIResource(defaultFont));
        UIManager.put("MenuBar.font", new FontUIResource(defaultFont));
        UIManager.put("Panel.font", new FontUIResource(defaultFont));
        UIManager.put("ProgressBar.font", new FontUIResource(defaultFont));
        UIManager.put("TextPane.font", new FontUIResource(defaultFont));
        UIManager.put("OptionPane.font", new FontUIResource(defaultFont));
        UIManager.put("ScrollPane.font", new FontUIResource(defaultFont));
        UIManager.put("EditorPane.font", new FontUIResource(defaultFont));
        UIManager.put("ColorChooser.font", new FontUIResource(defaultFont));
        this.jScopeUpdateUI();
    }

    public void InvalidateDefaults() {
        this.wave_panel.InvalidateDefaults();
    }

    public static String findFileInClassPath(String file) {
        StringTokenizer path = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (path.hasMoreTokens()) {
            String f_name;
            String p = path.nextToken();
            File f = new File(p);
            if (!f.isDirectory() || !(f = new File(f_name = p + File.separator + file)).exists()) continue;
            return f_name;
        }
        return null;
    }

    public void InitProperties() {
        try {
            InputStream pis;
            String f_name;
            if (is_debug) {
                System.out.println("jScope.properties " + System.getProperty("jScope.properties"));
                System.out.println("jScope.config_directory " + System.getProperty("jScope.config_directory"));
            }
            if (new File(f_name = this.propertiesFile).exists() || (f_name = System.getProperty("jScope.properties")) != null || new File(f_name = JSCOPE_PROPERTIES).exists()) {
                this.js_prop = new Properties();
                this.js_prop.load(new FileInputStream(f_name));
            } else {
                File jScopeUserDir = new File(JSCOPE_PROFILE);
                if (!jScopeUserDir.exists()) {
                    jScopeUserDir.mkdirs();
                }
                this.js_prop = new Properties();
                String res = "mds/jscope/jScope.properties";
                try (InputStream is = jScopeFacade.class.getClassLoader().getResourceAsStream("mds/jscope/jScope.properties");){
                    this.js_prop.load(is);
                }
                is = jScopeFacade.class.getClassLoader().getResourceAsStream("mds/jscope/jScope.properties");
                var5_7 = null;
                try (FileOutputStream os = new FileOutputStream(JSCOPE_PROPERTIES);){
                    byte[] b = new byte[1024];
                    int len = is.read(b);
                    while (len > 0) {
                        ((OutputStream)os).write(b, 0, len);
                        len = is.read(b);
                    }
                }
                catch (Throwable throwable) {
                    var5_7 = throwable;
                    throw throwable;
                }
                finally {
                    if (is != null) {
                        if (var5_7 != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable) {
                                var5_7.addSuppressed(throwable);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            if (!new File(JSCOPE_SERVERS).exists() && (pis = this.getClass().getClassLoader().getResourceAsStream("jScope_servers.conf")) != null) {
                FileOutputStream fos = new FileOutputStream(f_name);
                byte[] b = new byte[1024];
                int len = pis.read(b);
                while (len > 0) {
                    fos.write(b, 0, len);
                    len = pis.read(b);
                }
                fos.close();
                pis.close();
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    protected void GetPropertiesValue() {
        String refreshPeriodStr;
        String timeConversion;
        int val;
        if (this.js_prop == null) {
            return;
        }
        this.curr_directory = System.getProperty("jScope.config_directory");
        if (this.curr_directory == null || this.curr_directory.trim().length() == 0) {
            this.curr_directory = this.js_prop.getProperty("jScope.directory");
            if (this.curr_directory == null || this.curr_directory.trim().length() == 0) {
                this.curr_directory = JSCOPE_CONFIGURATIONS;
                File jScopeUserDir = new File(this.curr_directory);
                if (!jScopeUserDir.exists()) {
                    jScopeUserDir.mkdirs();
                }
            }
        }
        this.default_server_idx = -1;
        String prop = this.js_prop.getProperty("jScope.default_server");
        if (prop != null) {
            try {
                this.default_server_idx = Integer.parseInt(prop) - 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String f_name = this.js_prop.getProperty("jScope.save_selected_points");
        String proxy_host = this.js_prop.getProperty("jScope.http_proxy_host");
        String proxy_port = this.js_prop.getProperty("jScope.http_proxy_port");
        prop = this.js_prop.getProperty("jScope.vertical_offset");
        if (prop != null) {
            val = 0;
            try {
                val = Integer.parseInt(prop);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Waveform.SetVerticalOffset(val);
        }
        if ((prop = this.js_prop.getProperty("jScope.horizontal_offset")) != null) {
            val = 0;
            try {
                val = Integer.parseInt(prop);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Waveform.SetHorizontalOffset(val);
        }
        Properties p = System.getProperties();
        if (f_name != null) {
            p.put("jScope.save_selected_points", f_name);
        }
        if (this.curr_directory != null) {
            p.put("jScope.curr_directory", this.curr_directory);
        }
        if (proxy_port != null && proxy_host != null) {
            p.setProperty("http.proxyHost", proxy_host);
            p.setProperty("http.proxyPort", proxy_port);
        }
        if ((timeConversion = this.js_prop.getProperty("jScope.time_format")) != null) {
            if (timeConversion.toUpperCase().equals("VMS")) {
                Waveform.timeMode = 2;
            } else if (timeConversion.toUpperCase().equals("EPICS")) {
                Waveform.timeMode = 3;
            }
        }
        if ((refreshPeriodStr = this.js_prop.getProperty("jScope.refresh_period")) != null) {
            try {
                refreshPeriod = Integer.parseInt(refreshPeriodStr);
                if (refreshPeriod < 500L) {
                    refreshPeriod = 500L;
                }
            }
            catch (Exception exc) {
                refreshPeriod = -1L;
            }
        }
    }

    public static long getRefreshPeriod() {
        return refreshPeriod;
    }

    private void InitDataServer() {
        String ip_addr = null;
        String dp_class = null;
        DataServerItem srv_item = null;
        Properties props = System.getProperties();
        ip_addr = props.getProperty("data.address");
        dp_class = props.getProperty("data.class");
        this.server_diag = new ServerDialog(this, "Server list");
        if (ip_addr != null && dp_class != null) {
            srv_item = new DataServerItem(ip_addr, ip_addr, null, dp_class, null, null, null);
            this.server_diag.addServerIp(srv_item);
        }
        if (!(srv_item != null && this.SetDataServer(srv_item) || (srv_item = this.wave_panel.DataServerFromClient(srv_item)) != null && this.SetDataServer(srv_item))) {
            if (server_ip_list != null && this.default_server_idx >= 0 && this.default_server_idx < server_ip_list.length) {
                srv_item = server_ip_list[this.default_server_idx];
                this.SetDataServer(srv_item);
            } else {
                this.setDataServerLabel();
            }
        }
    }

    public void setDataServerLabel() {
        if (enableNetworkSelection) {
            if (this.wave_panel != null) {
                this.net_text.setText("Data Server:" + this.wave_panel.GetServerLabel());
            }
        } else if (mdsDataServer != null) {
            this.net_text.setText("Data Server: " + mdsDataServer);
        } else if (sshDataServer != null) {
            this.net_text.setText("SSH Data Server: " + sshDataServer);
        } else {
            this.net_text.setText("Data Server: Local");
        }
    }

    public void SetStatusLabel(String msg) {
        this.info_text.setText(" Status: " + msg);
    }

    public void RepaintAllWaves() {
        int wave_mode = this.wave_panel.GetMode();
        this.wave_panel.SetMode(5);
        int k = 0;
        for (int i = 0; i < 4; ++i) {
            int j = 0;
            while (j < this.wave_panel.getComponentsInColumn(i)) {
                jScopeMultiWave w = (jScopeMultiWave)this.wave_panel.GetWavePanel(k);
                if (w.wi != null) {
                    this.SetStatusLabel("Repaint signal column " + (i + 1) + " row " + (j + 1));
                    this.setColor(w.wi);
                    w.Update(w.wi);
                }
                ++j;
                ++k;
            }
        }
        this.wave_panel.RepaintAllWaves();
        this.wave_panel.SetMode(wave_mode);
    }

    public boolean briefError() {
        return this.brief_error_i.getState();
    }

    public boolean IsShotDefinedXX() {
        String s = this.shot_t.getText();
        if (s != null && s.trim().length() > 0) {
            return true;
        }
        s = this.def_values.shot_str;
        if (s != null && s.trim().length() > 0) {
            this.shot_t.setText(s);
            return true;
        }
        return false;
    }

    public boolean equalsString(String s1, String s2) {
        boolean res = false;
        if (s1 != null) {
            if (s2 == null && s1.length() == 0) {
                res = true;
            } else if (s1.equals(s2)) {
                res = true;
            }
        } else {
            res = s2 == null || s2.length() == 0;
        }
        return res;
    }

    public void setPublicVariables(String public_variables) {
        this.def_values.setPublicVariables(public_variables);
        if (!this.def_values.getIsEvaluated()) {
            this.wave_panel.SetModifiedState(true);
        }
    }

    public void ArrowsIncDecShot() {
        String sh = this.shot_t.getText();
        int idx = sh.lastIndexOf("+");
        if (idx > 1 || (idx = sh.lastIndexOf("-")) > 1) {
            sh = sh.substring(0, idx);
            sh = sh.trim();
        }
        if (this.incShotValue != 0) {
            this.shot_t.setText(sh + (this.incShotValue > 0 ? " + " : " - ") + Math.abs(this.incShotValue));
        } else {
            this.shot_t.setText(sh);
        }
    }

    public void SetMainShot() {
        this.wave_panel.SetMainShot(this.shot_t.getText());
    }

    public void UpdateAllWaves() {
        String s = this.shot_t.getText();
        String s1 = this.def_values.shot_str;
        if ((s == null || s.trim().length() == 0) && s1 != null && s1.trim().length() != 0) {
            this.shot_t.setText(s1);
        }
        this.apply_b.setText("Abort");
        this.setPublicVariables(this.pub_var_diag.getPublicVar());
        this.SetMainShot();
        this.wave_panel.StartUpdate();
    }

    private void ToFile(PrintWriter out) throws IOException {
        Rectangle r = this.getBounds();
        this.setChange(false);
        this.SetWindowTitle("");
        out.println("Scope.geometry: " + r.width + "x" + r.height + "+" + r.x + "+" + r.y);
        out.println("Scope.update.disable: " + this.update_i.getState());
        out.println("Scope.update.disable_when_icon: " + this.update_when_icon_i.getState());
        this.font_dialog.toFile(out, "Scope.font");
        this.pub_var_diag.toFile(out, "Scope.public_variable_");
        this.color_dialog.toFile(out, "Scope.color_");
        this.wave_panel.ToFile(out, "Scope.");
    }

    public void setChange(boolean change) {
        if (this.modified == change) {
            return;
        }
        this.modified = change;
        this.SetWindowTitle("");
    }

    public boolean IsChange() {
        return this.modified;
    }

    private void creaHistoryFile(File f) {
        String[] list;
        int idx = 0;
        int maxIdx = 0;
        int maxHistory = 2;
        String config_file_history = this.js_prop.getProperty("jScope.config_file_history_length");
        try {
            maxHistory = Integer.parseInt(config_file_history);
        }
        catch (Exception exception) {
            // empty catch block
        }
        File pf = f.getParentFile();
        for (String file : list = pf.list(new FileFilter(f.getName()))) {
            StringTokenizer st = new StringTokenizer(file, ";");
            try {
                String s = st.nextToken();
                s = st.nextToken();
                if (s == null || (idx = Integer.parseInt(s)) <= maxIdx) continue;
                maxIdx = idx;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (++maxIdx > maxHistory) {
            File fd = new File(f.getAbsolutePath() + ";" + (maxIdx - maxHistory));
            fd.delete();
        }
        File fr = new File(f.getAbsolutePath() + ";" + maxIdx);
        f.renameTo(fr);
    }

    public void SaveConfiguration(String conf_file) {
        if (conf_file == null || conf_file.length() == 0) {
            return;
        }
        int pPos = conf_file.lastIndexOf(46);
        int sPos = conf_file.lastIndexOf(File.separatorChar);
        if (pPos == -1 || pPos < sPos) {
            conf_file = conf_file + ".jscp";
        }
        this.last_directory = new String(conf_file);
        this.save_i.setEnabled(true);
        this.use_last_i.setEnabled(true);
        File fok = new File(conf_file);
        File ftmp = new File(conf_file + "_tmp");
        try {
            PrintWriter out = new PrintWriter(new FileWriter(ftmp));
            this.ToFile(out);
            out.close();
            if (fok.exists()) {
                this.creaHistoryFile(fok);
            }
            ftmp.renameTo(fok);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e, "alert", 0);
        }
        ftmp.delete();
    }

    private int saveWarning() {
        Object[] options = new Object[]{"Save", "Don't Save", "Cancel"};
        int val = JOptionPane.showOptionDialog(null, "Save change to the configuration file before closing ?", "Warning", 1, 3, null, options, options[0]);
        return val;
    }

    public void closeScope() {
        if (this.IsChange()) {
            switch (this.saveWarning()) {
                case 0: {
                    if (this.config_file == null) {
                        this.SaveAs();
                        break;
                    }
                    this.SaveConfiguration(this.config_file);
                    break;
                }
            }
        }
        this.exitScope();
    }

    private void exitScope() {
        try {
            this.wave_panel.RemoveAllEvents(this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.dispose();
        --num_scope;
    }

    private void SaveAs() {
        File file;
        if (this.curr_directory != null && this.curr_directory.trim().length() != 0) {
            this.file_diag.setCurrentDirectory(new File(this.curr_directory));
        }
        int returnVal = 1;
        boolean done = false;
        while (!done) {
            returnVal = this.file_diag.showSaveDialog(this);
            if (returnVal == 0) {
                file = this.file_diag.getSelectedFile();
                String txtsig_file = file.getAbsolutePath();
                if (file.exists()) {
                    Object[] options = new Object[]{"Yes", "No"};
                    int val = JOptionPane.showOptionDialog(null, txtsig_file + " already exists.\nDo you want to replace it?", "Save as", 0, 2, null, options, options[1]);
                    if (val != 0) continue;
                    done = true;
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        if (returnVal == 0) {
            file = this.file_diag.getSelectedFile();
            String d = file.getAbsolutePath();
            String f = file.getName();
            this.config_file = f != null && f.trim().length() != 0 && d != null && d.trim().length() != 0 ? (this.curr_directory = d) : null;
            if (this.config_file != null) {
                this.SaveConfiguration(this.config_file);
            }
        }
    }

    private void LoadConfigurationFrom() {
        if (this.IsChange()) {
            switch (this.saveWarning()) {
                case 0: {
                    if (this.config_file == null) {
                        this.SaveAs();
                        return;
                    }
                    this.SaveConfiguration(this.config_file);
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        this.setChange(false);
        if (this.curr_directory != null && this.curr_directory.trim().length() != 0) {
            this.file_diag.setCurrentDirectory(new File(this.curr_directory));
        }
        Timer t = new Timer(20, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int returnVal = jScopeFacade.this.file_diag.showOpenDialog(jScopeFacade.this);
                if (returnVal == 0) {
                    File file = jScopeFacade.this.file_diag.getSelectedFile();
                    String d = file.getAbsolutePath();
                    String f = file.getName();
                    if (f != null && f.trim().length() != 0 && d != null && d.trim().length() != 0) {
                        jScopeFacade.this.curr_directory = d;
                        jScopeFacade.this.config_file = jScopeFacade.this.curr_directory;
                        jScopeFacade.this.LoadConfiguration();
                    }
                }
            }
        });
        t.setRepeats(false);
        t.start();
    }

    public boolean SetDataServer(DataServerItem new_srv_item) {
        try {
            this.wave_panel.SetDataServer(new_srv_item, this);
            this.setDataServerLabel();
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Cannot establish connection with data server", 0);
            this.net_text.setText("Not Connected");
            if (!enableNetworkSelection) {
                System.exit(0);
            }
            return false;
        }
    }

    public void UpdateFont() {
        this.wave_panel.SetFont(this.font_dialog.GetFont());
    }

    public void UpdateColors() {
        this.wave_panel.SetColors(this.color_dialog.GetColors(), this.color_dialog.GetColorsName());
        this.setup_dialog.SetColorList();
    }

    public void UpdateDefaultValues() {
        boolean is_changed = false;
        try {
            is_changed = this.setup_default.IsChanged(this.def_values);
            if (is_changed) {
                this.setChange(true);
                this.wave_panel.RemoveAllEvents(this);
                this.setup_default.SaveDefaultConfiguration(this.def_values);
                this.InvalidateDefaults();
                this.wave_panel.AddAllEvents(this);
                this.UpdateAllWaves();
            } else {
                this.setup_default.SaveDefaultConfiguration(this.def_values);
            }
            this.wave_panel.SetParams(this.wave_panel.GetMode(), this.setup_default.getGridMode(), this.setup_default.getLegendMode(), this.setup_default.getXLines(), this.setup_default.getYLines(), this.setup_default.getReversed());
            this.color_dialog.SetReversed(this.setup_default.getReversed());
            this.UpdateColors();
            if (!is_changed) {
                this.RepaintAllWaves();
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "alert UpdateDefaultValues", 0);
        }
    }

    protected void PrintAllWaves(PrintRequestAttributeSet attrs) {
        try {
            this.SetStatusLabel("Executing print");
            this.wave_panel.PrintAllWaves(this.prnJob, attrs);
            this.SetStatusLabel("End print operation");
        }
        catch (PrinterException er) {
            System.out.println(er);
            JOptionPane.showMessageDialog(null, "Error on print operation", "alert PrintAllWaves", 0);
        }
        catch (PrintException er) {
            System.out.println(er);
            JOptionPane.showMessageDialog(null, "Error on print operation", "alert PrintAllWaves", 0);
        }
    }

    @Override
    public void processWaveContainerEvent(WaveContainerEvent e) {
        block17: {
            String s = null;
            int event_id = e.getID();
            block0 : switch (event_id) {
                case 2004: 
                case 2005: {
                    this.apply_b.setText("Apply");
                    if (event_id == 2005) {
                        System.out.println(" processWaveContainerEvent " + e.info);
                        this.SetStatusLabel(" Aborted ");
                    } else {
                        this.SetStatusLabel(e.info);
                    }
                    this.SetWindowTitle("");
                    break;
                }
                case 2003: {
                    this.SetStatusLabel(e.info);
                    break;
                }
                case 2006: {
                    WaveformEvent we = (WaveformEvent)e.we;
                    jScopeMultiWave w = (jScopeMultiWave)we.getSource();
                    MdsWaveInterface wi = (MdsWaveInterface)w.wi;
                    int we_id = we.getID();
                    switch (we_id) {
                        case 2006: {
                            if (this.EventUpdateEnabled()) {
                                this.setPublicVariables(this.pub_var_diag.getPublicVar());
                                this.SetMainShot();
                                this.wave_panel.Refresh(w, we.status_info);
                                w.RefreshOnEvent();
                                break block0;
                            }
                            break block17;
                        }
                        case 2000: 
                        case 2001: 
                        case 2008: {
                            s = we.toString();
                            if (wi.shots != null) {
                                this.point_pos.setText(s + " Expr : " + w.getSignalName(we.signal_idx) + " Shot = " + wi.shots[we.signal_idx]);
                                break block0;
                            }
                            this.point_pos.setText(s + " Expr : " + w.getSignalName(we.signal_idx));
                            break block0;
                        }
                        case 2002: {
                            this.SetStatusLabel(we.status_info);
                            break block0;
                        }
                        case 2011: {
                            if (we.status_info != null) {
                                this.progress_bar.setString(we.status_info);
                            } else {
                                this.progress_bar.setString("");
                            }
                            this.progress_bar.setValue(0);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void processConnectionEvent(ConnectionEvent e) {
        this.progress_bar.setString("");
        if (e.getID() == 2000) {
            if (!enableNetworkSelection) {
                if (JOptionPane.showConfirmDialog(this, e.info + "  Reconnect To Data Server?", "alert processConnectionEvent", 0) == 1) {
                    System.exit(0);
                }
                this.connectDefault();
            } else {
                JOptionPane.showMessageDialog(this, e.info, "alert processConnectionEvent", 0);
                this.SetDataServer(new DataServerItem());
            }
            return;
        }
        if (e.current_size == 0 && e.total_size == 0) {
            if (e.info != null) {
                this.progress_bar.setString(e.info);
            } else {
                this.progress_bar.setString("");
            }
            this.progress_bar.setValue(0);
        } else {
            int v = (int)((double)((float)e.current_size / (float)e.total_size) * 100.0);
            this.progress_bar.setValue(v);
            this.progress_bar.setString((e.info != null ? e.info : "") + v + "%");
        }
    }

    private void connectDefault() {
        if (mdsDataServer != null) {
            this.SetDataServer(new DataServerItem("mdsip connection", mdsDataServer, "JAVA_USER", MdsDataProvider.class.getName(), null, null, null));
        } else if (sshDataServer != null) {
            this.SetDataServer(new DataServerItem("mdsip connection", sshDataServer, "JAVA_USER", MdsDataProviderSsh.class.getName(), null, null, null));
        } else {
            this.SetDataServer(new DataServerItem("local access", null, null, MdsDataProviderLocal.class.getName(), null, null, null));
        }
    }

    private boolean EventUpdateEnabled() {
        if (this.update_i.getState()) {
            this.SetStatusLabel("Disable event update");
            return false;
        }
        if (this.getExtendedState() == 1 && this.update_when_icon_i.getState()) {
            this.SetStatusLabel("Event update is disabled when iconified");
            return false;
        }
        return true;
    }

    @Override
    public void processUpdateEvent(UpdateEvent e) {
        if (this.EventUpdateEnabled()) {
            String print_event = this.wave_panel.GetPrintEvent();
            String event = this.wave_panel.GetEvent();
            if (e.getName().equals(event)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jScopeFacade.this.UpdateAllWaves();
                    }
                });
            }
            if (e.getName().equals(print_event)) {
                this.wave_panel.StartPrint(this.prnJob, this.attrs);
            }
        }
    }

    private DataServerItem getServerItem(String server) {
        for (DataServerItem element : server_ip_list) {
            if (!element.equals(server)) continue;
            return element;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Timer t;
        String sig;
        StringTokenizer act;
        String action;
        Object ob = e.getSource();
        String action_cmd = null;
        if (ob != this.open_i) {
            this.wave_panel.RemoveSelection();
        }
        if (ob instanceof AbstractButton) {
            action_cmd = ((AbstractButton)ob).getModel().getActionCommand();
        }
        if (action_cmd != null && (action = (act = new StringTokenizer(action_cmd)).nextToken()).equals("SET_SERVER")) {
            String value = action_cmd.substring(action.length() + 1);
            if (!this.wave_panel.GetServerLabel().equals(value)) {
                this.SetDataServer(this.getServerItem(value));
            }
        }
        if (ob == this.signal_expr && (sig = this.signal_expr.getText().trim()) != null && sig.length() != 0) {
            this.SetMainShot();
            this.wave_panel.AddSignal(sig, false);
            this.setChange(true);
        }
        if (ob == this.apply_b || ob == this.shot_t) {
            this.incShotValue = 0;
            if (this.wave_panel.isBusy()) {
                if (ob == this.apply_b) {
                    this.wave_panel.AbortUpdate();
                }
            } else {
                if (ob == this.shot_t) {
                    this.SetMainShot();
                }
                if ((sig = this.signal_expr.getText().trim()) != null && sig.length() != 0) {
                    this.wave_panel.AddSignal(sig, true);
                    this.setChange(true);
                }
                this.UpdateAllWaves();
            }
        }
        if (ob == this.color_i) {
            t = new Timer(20, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    jScopeFacade.this.color_dialog.ShowColorDialog(jScopeFacade.this.wave_panel);
                }
            });
            t.setRepeats(false);
            t.start();
        }
        if (ob == this.font_i) {
            this.font_dialog.setLocationRelativeTo(this);
            t = new Timer(20, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    jScopeFacade.this.font_dialog.setVisible(true);
                }
            });
            t.setRepeats(false);
            t.start();
        }
        if (ob == this.default_i) {
            t = new Timer(20, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    jScopeFacade.this.setup_default.Show(jScopeFacade.this, jScopeFacade.this.def_values);
                }
            });
            t.setRepeats(false);
            t.start();
        }
        if (ob == this.win_i) {
            if (this.win_diag == null) {
                this.win_diag = new WindowDialog(this, "Window");
            }
            t = new Timer(20, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    boolean returnFlag = jScopeFacade.this.win_diag.ShowWindowDialog();
                    if (returnFlag) {
                        jScopeFacade.this.wave_panel.ResetDrawPanel(((jScopeFacade)jScopeFacade.this).win_diag.out_row);
                        jScopeFacade.this.UpdateColors();
                        jScopeFacade.this.UpdateFont();
                        jScopeFacade.this.setChange(true);
                    }
                }
            });
            t.setRepeats(false);
            t.start();
        }
        if (ob == this.use_last_i && this.last_directory != null && this.last_directory.trim().length() != 0) {
            this.config_file = this.curr_directory = this.last_directory;
            this.setChange(false);
            this.LoadConfiguration();
        }
        if (ob == this.use_i) {
            this.LoadConfigurationFrom();
        }
        if (ob == this.save_i) {
            this.SaveConfiguration(this.config_file);
        }
        if (ob == this.save_as_i) {
            this.SaveAs();
        }
        if (ob == this.save_all_as_text_i) {
            this.wave_panel.SaveAsText(null, true);
        }
        if (ob == this.exit_i) {
            if (num_scope > 1) {
                Object[] options = new Object[]{"Close this", "Close all", "Cancel"};
                int opt = JOptionPane.showOptionDialog(null, "Close all open scopes?", "Warning", 1, 3, null, options, options[0]);
                switch (opt) {
                    case 0: {
                        this.closeScope();
                        break;
                    }
                    case 1: {
                        System.exit(0);
                        break;
                    }
                }
            } else {
                this.closeScope();
                if (num_scope == 0) {
                    System.exit(0);
                }
            }
        }
        if (ob == this.close_i && num_scope != 1) {
            this.closeScope();
        }
        if (ob == this.open_i) {
            ++num_scope;
            Rectangle r = this.getBounds();
            jScopeFacade new_scope = this.buildNewScope(r.x + 5, r.y + 40);
            new_scope.wave_panel.setCopySource(this.wave_panel.getCopySource());
            new_scope.startScope(null);
        }
        if (ob == this.all_i) {
            this.wave_panel.autoscaleAll();
        }
        if (ob == this.allY_i) {
            this.wave_panel.autoscaleAllY();
        }
        if (ob == this.copy_i) {
            this.wave_panel.SetMode(4);
            this.copy.getModel().setSelected(true);
        }
        if (ob == this.zoom_i) {
            this.wave_panel.SetMode(1);
            this.zoom.getModel().setSelected(true);
        }
        if (ob == this.point_i) {
            this.wave_panel.SetMode(2);
            this.point.getModel().setSelected(true);
        }
        if (ob == this.pan_i) {
            this.wave_panel.SetMode(3);
            this.pan.getModel().setSelected(true);
        }
        if (ob == this.server_list_i) {
            t = new Timer(20, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    jScopeFacade.this.server_diag.Show();
                    server_ip_list = jScopeFacade.this.server_diag.getServerIpList();
                }
            });
            t.setRepeats(false);
            t.start();
        }
        if (ob == this.pub_variables_i) {
            t = new Timer(20, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    jScopeFacade.this.pub_var_diag.Show();
                }
            });
            t.setRepeats(false);
            t.start();
        }
    }

    private void setColor(WaveInterface wi) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object ob = e.getSource();
        if (ob == this.brief_error_i) {
            WaveInterface.brief_error = this.brief_error_i.getState();
        }
        if (e.getStateChange() != 1) {
            return;
        }
        if (ob == this.copy) {
            this.wave_panel.SetMode(4);
        }
        if (ob == this.zoom) {
            this.wave_panel.SetMode(1);
        }
        if (ob == this.point) {
            this.wave_panel.SetMode(2);
        }
        if (ob == this.pan) {
            this.wave_panel.SetMode(3);
        }
    }

    public void SetWindowTitle(String info) {
        String f_name = this.config_file;
        if (f_name == null) {
            f_name = "Untitled";
        }
        if (this.wave_panel.GetTitle() != null) {
            this.setTitle(" - " + this.wave_panel.GetEvaluatedTitle() + " - " + f_name + (this.IsChange() ? " (changed)" : "") + " " + info);
        } else {
            this.setTitle("- Scope - " + f_name + (this.IsChange() ? " (changed)" : "") + " " + info);
        }
    }

    public void FromFile(Properties pr) throws IOException {
        String prop = "";
        try {
            boolean b;
            prop = pr.getProperty("Scope.update.disable");
            if (prop != null) {
                b = new Boolean(prop);
                this.update_i.setState(b);
            }
            if ((prop = pr.getProperty("Scope.update.disable_when_icon")) != null) {
                b = new Boolean(prop);
                this.update_when_icon_i.setState(b);
            }
            if ((prop = pr.getProperty("Scope.geometry")) != null) {
                StringTokenizer st = new StringTokenizer(prop);
                this.width = Integer.parseInt(st.nextToken("x"));
                this.height = Integer.parseInt(st.nextToken("x+"));
                this.xpos = Integer.parseInt(st.nextToken("+"));
                this.ypos = Integer.parseInt(st.nextToken("+"));
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                if (this.height > screenSize.height) {
                    this.height = screenSize.height;
                }
                if (this.width > screenSize.width) {
                    this.width = screenSize.width;
                }
                if (this.ypos + this.height > screenSize.height) {
                    this.ypos = screenSize.height - this.height;
                }
                if (this.xpos + this.width > screenSize.width) {
                    this.xpos = screenSize.width - this.width;
                }
            }
        }
        catch (Exception exc) {
            throw new IOException(prop);
        }
    }

    public void LoadFromFile(Properties pr) throws IOException {
        try {
            this.FromFile(pr);
            this.font_dialog.fromFile(pr, "Scope.font");
            this.color_dialog.FromFile(pr, "Scope.color_");
            this.pub_var_diag.fromFile(pr, "Scope.public_variable_");
            this.wave_panel.FromFile(pr, "Scope", this.color_dialog.getColorMapIndex(), this.colorMapDialog);
            this.wave_panel.AddAllEvents(this);
        }
        catch (Exception e) {
            throw new IOException("Configuration file syntax error : " + e.getMessage());
        }
    }

    private void Reset() {
        this.config_file = null;
        this.incShotValue = 0;
        this.SetWindowTitle("");
        this.wave_panel.Reset();
    }

    public void LoadConfiguration() {
        if (this.config_file == null) {
            return;
        }
        this.incShotValue = 0;
        try {
            jScopeProperties pr = new jScopeProperties();
            pr.load(new FileInputStream(this.config_file));
            this.LoadConfiguration(pr);
        }
        catch (IOException e) {
            this.Reset();
            JOptionPane.showMessageDialog(this, e.getMessage(), "alert LoadConfiguration", 0);
        }
        this.save_i.setEnabled(true);
    }

    public void LoadConfiguration(Properties pr) {
        this.wave_panel.EraseAllWave();
        try {
            this.LoadFromFile(pr);
            this.setBounds(this.xpos, this.ypos, this.width, this.height);
            this.UpdateColors();
            this.UpdateFont();
            this.wave_panel.update();
            this.validate();
            DataServerItem dsi = this.wave_panel.GetServerItem();
            dsi = this.server_diag.addServerIp(dsi);
            if (enableNetworkSelection && !this.SetDataServer(dsi)) {
                this.SetDataServer(new DataServerItem());
            }
            this.UpdateAllWaves();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.Reset();
            JOptionPane.showMessageDialog(this, e.getMessage(), "alert LoadConfiguration", 0);
        }
    }

    protected jScopeFacade buildNewScope(int x, int y) {
        return new jScopeFacade(x, y, this.propertiesFile);
    }

    public void startScope(String file) {
        if (file != null) {
            this.config_file = new String(file);
            this.LoadConfiguration();
        }
        if (!enableNetworkSelection) {
            this.connectDefault();
        }
        this.SetWindowTitle("");
        this.setVisible(true);
    }

    static boolean IsNewJVMVersion() {
        boolean isGreater = (double)Float.valueOf(System.getProperty("java.specification.version")).floatValue() >= 1.2;
        return isGreater;
    }

    public static void main(String[] args) {
        jScopeFacade.startApplication(args);
    }

    public static void startApplication(String[] args) {
        String file = null;
        String propertiesFile = null;
        Properties props = System.getProperties();
        String debug = props.getProperty("debug");
        if (debug != null && debug.equals("true")) {
            is_debug = true;
            Waveform.is_debug = true;
        }
        if (args.length != 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-fp")) {
                    if (i + 1 < args.length) {
                        propertiesFile = args[i + 1];
                    }
                    ++i;
                    continue;
                }
                if (args[i].equals("-s") && i < args.length - 1) {
                    enableNetworkSelection = false;
                    mdsDataServer = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("-ssh") && i < args.length - 1) {
                    enableNetworkSelection = false;
                    sshDataServer = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("-l")) {
                    enableNetworkSelection = false;
                    mdsDataServer = null;
                    continue;
                }
                file = new String(args[i]);
            }
        }
        if (jScopeFacade.IsNewJVMVersion()) {
            win = new jScopeFacade(100, 100, propertiesFile);
        } else {
            System.out.println("jScope application required JDK version 1.2 or later");
            System.out.println("Your version is " + System.getProperty("java.specification.version"));
            System.exit(1);
        }
        win.pack();
        win.setSize(750, 550);
        ++num_scope;
        win.startScope(file);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (num_scope == 1) {
            System.exit(0);
        } else {
            this.exitScope();
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
        if (this.aboutScreen != null) {
            this.hideAbout();
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    protected void jScopeUpdateUI() {
        jScopeFacade.jScopeSetUI(this);
        jScopeFacade.jScopeSetUI(this.font_dialog);
        jScopeFacade.jScopeSetUI(this.setup_default);
        jScopeFacade.jScopeSetUI(this.color_dialog);
        jScopeFacade.jScopeSetUI(this.pub_var_diag);
        jScopeFacade.jScopeSetUI(this.server_diag);
        jScopeFacade.jScopeSetUI(this.file_diag);
    }

    protected static void jScopeSetUI(Component c) {
        if (c != null) {
            SwingUtilities.updateComponentTreeUI(c);
        }
    }

    protected static boolean isAvailableLookAndFeel(String classname) {
        try {
            Class<?> lnfClass = Class.forName(classname);
            LookAndFeel newLAF = (LookAndFeel)lnfClass.newInstance();
            if (newLAF == null) {
                return false;
            }
            return newLAF.isSupportedLookAndFeel();
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        String profile = System.getProperty("user.home") + File.separator + "jscope";
        String upper = System.getProperty("user.home") + File.separator + "jscope";
        if (!new File(profile).exists() && new File(upper).exists()) {
            profile = upper;
        }
        JSCOPE_PROFILE = profile;
        JSCOPE_SERVERS = JSCOPE_PROFILE + File.separator + "jScope_servers.conf";
        JSCOPE_CONFIGURATIONS = JSCOPE_PROFILE + File.separator + "configurations";
        JSCOPE_PROPERTIES = JSCOPE_PROFILE + File.separator + "jScope.properties";
        JSCOPE_PALETTE = JSCOPE_PROFILE + File.separator + "colors.tbl";
        is_debug = false;
        refreshPeriod = -1L;
        enableNetworkSelection = true;
        mdsDataServer = null;
        sshDataServer = null;
        num_scope = 0;
        not_sup_local = false;
        macClassName = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
        metalClassName = "javax.swing.plaf.metal.MetalLookAndFeel";
        motifClassName = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
        windowsClassName = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        String version = AboutWindow.class.getPackage().getImplementationVersion();
        VERSION = version == null ? "unknown" : version;
    }

    class ToggleUIListener
    implements ItemListener {
        ToggleUIListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            jScopeFacade root = jScopeFacade.this;
            ((Component)root).setCursor(Cursor.getPredefinedCursor(3));
            JRadioButtonMenuItem rb = (JRadioButtonMenuItem)e.getSource();
            try {
                if (rb.isSelected() && rb.getText().equals("Windows Style Look and Feel")) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(jScopeFacade.this);
                } else if (rb.isSelected() && rb.getText().equals("Macintosh Look and Feel")) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.mac.MacLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(jScopeFacade.this);
                } else if (rb.isSelected() && rb.getText().equals("Motif Look and Feel")) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(jScopeFacade.this);
                } else if (rb.isSelected() && rb.getText().equals("Java Look and Feel")) {
                    UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(jScopeFacade.this);
                }
                jScopeFacade.this.jScopeUpdateUI();
            }
            catch (UnsupportedLookAndFeelException exc) {
                rb.setEnabled(false);
                System.err.println("Unsupported LookAndFeel: " + rb.getText());
                try {
                    jScopeFacade.this.metalMenuItem.setSelected(true);
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    SwingUtilities.updateComponentTreeUI(jScopeFacade.this);
                }
                catch (Exception exc2) {
                    exc2.printStackTrace();
                    System.err.println("Could not load LookAndFeel: " + exc2);
                    exc2.printStackTrace();
                }
            }
            catch (Exception exc) {
                rb.setEnabled(false);
                exc.printStackTrace();
                System.err.println("Could not load LookAndFeel: " + rb.getText());
                exc.printStackTrace();
            }
            ((Component)root).setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    class MonMemory
    extends Thread {
        MonMemory() {
        }

        @Override
        public void run() {
            this.setName("Monitor Thread");
            try {
                while (true) {
                    jScopeFacade.this.SetWindowTitle("Free :" + (int)(Runtime.getRuntime().freeMemory() / 1024L) + " Total :" + (int)Runtime.getRuntime().totalMemory() / 1024 + " USED :" + (int)((double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0));
                    MonMemory.sleep(2000L, 0);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        synchronized void waitTime(long t) throws InterruptedException {
            this.wait(t);
        }
    }

    class PubVarDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private final Vector<String> name_list;
        private final Vector<String> expr_list;
        private final JButton apply;
        private final JButton cancel;
        private final JButton save;
        private final JButton reset;
        jScopeFacade dw;
        boolean is_pv_apply;

        PubVarDialog(Frame fw) {
            super(fw, "Public Variables", false);
            this.name_list = new Vector();
            this.expr_list = new Vector();
            this.is_pv_apply = false;
            this.dw = (jScopeFacade)fw;
            GridBagConstraints c = new GridBagConstraints();
            GridBagLayout gridbag = new GridBagLayout();
            this.getContentPane().setLayout(gridbag);
            c.insets = new Insets(2, 2, 2, 2);
            c.fill = 0;
            c.anchor = 10;
            c.gridwidth = 1;
            JLabel lab = new JLabel("Name");
            gridbag.setConstraints(lab, c);
            this.getContentPane().add(lab);
            c.gridwidth = 0;
            lab = new JLabel("Expression");
            gridbag.setConstraints(lab, c);
            this.getContentPane().add(lab);
            c.anchor = 17;
            c.fill = 1;
            for (int i = 0; i < 10; ++i) {
                c.gridwidth = 1;
                JTextField txt = new JTextField(10);
                gridbag.setConstraints(txt, c);
                this.getContentPane().add(txt);
                c.gridwidth = 0;
                txt = new JTextField(30);
                gridbag.setConstraints(txt, c);
                this.getContentPane().add(txt);
            }
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout(1));
            this.apply = new JButton("Apply");
            this.apply.addActionListener(this);
            p.add(this.apply);
            this.save = new JButton("Save");
            this.save.addActionListener(this);
            p.add(this.save);
            this.reset = new JButton("Reset");
            this.reset.addActionListener(this);
            p.add(this.reset);
            this.cancel = new JButton("Cancel");
            this.cancel.addActionListener(this);
            p.add(this.cancel);
            c.gridwidth = 0;
            gridbag.setConstraints(p, c);
            this.getContentPane().add(p);
        }

        public String getCurrentPublicVar() {
            StringBuffer buf = new StringBuffer();
            Container p = this.getContentPane();
            for (int i = 2; i < 20; i += 2) {
                String txt1 = ((JTextField)p.getComponent(i)).getText();
                String txt2 = ((JTextField)p.getComponent(i + 1)).getText();
                if (txt1.length() == 0 || txt2.length() == 0) continue;
                String str = txt1.indexOf("_") != 0 ? "public _" + txt1 + " = ( " + txt2 + ";)" : "public " + txt1 + " = (" + txt2 + ";)";
                buf.append(str);
            }
            return new String(buf);
        }

        public String getPublicVar() {
            if (this.is_pv_apply) {
                return this.getCurrentPublicVar();
            }
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.name_list.size() && i < 10; ++i) {
                String txt1 = this.name_list.elementAt(i);
                String txt2 = this.expr_list.elementAt(i);
                if (txt1.length() == 0 || txt2.length() == 0) continue;
                String str = txt1.indexOf("_") != 0 ? "public _" + txt1 + " = (" + txt2 + ");" : "public " + txt1 + " = (" + txt2 + ");";
                buf.append(str);
            }
            return new String(buf);
        }

        private void SavePubVar() {
            if (this.name_list.size() != 0) {
                this.name_list.removeAllElements();
            }
            if (this.expr_list.size() != 0) {
                this.expr_list.removeAllElements();
            }
            Container p = this.getContentPane();
            int i = 2;
            for (int j = 0; j < 10; ++j) {
                String txt1 = ((JTextField)p.getComponent(i)).getText();
                String txt2 = ((JTextField)p.getComponent(i + 1)).getText();
                if (txt1.length() != 0 && txt2.length() != 0) {
                    this.name_list.insertElementAt(new String(txt1), j);
                    this.expr_list.insertElementAt(new String(txt2), j);
                }
                i += 2;
            }
            this.dw.setChange(true);
        }

        private void SetPubVar() {
            Container p = this.getContentPane();
            int i = 2;
            for (int j = 0; j < this.name_list.size() && j < 10; ++j) {
                ((JTextField)p.getComponent(i)).setText(this.name_list.elementAt(j));
                ((JTextField)p.getComponent(i + 1)).setText(this.expr_list.elementAt(j));
                i += 2;
            }
        }

        public void Show() {
            this.is_pv_apply = true;
            this.SetPubVar();
            this.pack();
            this.setLocationRelativeTo(this.dw);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object ob = e.getSource();
            if (ob == this.apply) {
                this.dw.setPublicVariables(this.getPublicVar());
                this.dw.UpdateAllWaves();
            }
            if (ob == this.save) {
                this.SavePubVar();
            }
            if (ob == this.reset) {
                this.SetPubVar();
            }
            if (ob == this.cancel) {
                this.is_pv_apply = false;
                this.setVisible(false);
            }
        }

        public void toFile(PrintWriter out, String prompt) {
            for (int i = 0; i < this.name_list.size() && i < 10; ++i) {
                out.println(prompt + i + ": " + this.name_list.elementAt(i) + " = " + this.expr_list.elementAt(i));
            }
            out.println("");
        }

        public void fromFile(Properties pr, String prompt) throws IOException {
            String prop;
            this.name_list.removeAllElements();
            this.expr_list.removeAllElements();
            for (int idx = 0; (prop = pr.getProperty(prompt + idx)) != null && idx < 10; ++idx) {
                StringTokenizer st = new StringTokenizer(prop, "=");
                String name = st.nextToken();
                String expr = st.nextToken("");
                expr = expr.substring(expr.indexOf(61) + 1);
                this.name_list.insertElementAt(name.trim(), idx);
                this.expr_list.insertElementAt(expr.trim(), idx);
            }
        }
    }

    class FileFilter
    implements FilenameFilter {
        String fname = null;

        FileFilter(String fname) {
            this.fname = fname;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.indexOf(this.fname) == 0;
        }
    }
}

