/*
 * Decompiled with CFR 0.152.
 */
package mds.jscope;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.Timer;
import mds.jscope.SetupDataDialog;
import mds.jscope.jScopeFacade;
import mds.jscope.jScopeMultiWave;
import mds.jscope.jScopeWaveContainer;
import mds.wave.ColorMapDialog;
import mds.wave.MultiWavePopup;
import mds.wave.ProfileDialog;
import mds.wave.Waveform;
import mds.wave.WaveformManager;

class jScopeWavePopup
extends MultiWavePopup {
    private SetupDataDialog setup_dialog;
    protected JMenuItem refresh;
    protected JMenuItem selectWave;
    protected JSeparator sep1;

    public jScopeWavePopup(SetupDataDialog setup_dialog, ProfileDialog profDialog, ColorMapDialog colorMapDialog) {
        super(null, profDialog);
        this.setColorMapDialog(colorMapDialog);
        this.setup.setText("Setup data source...");
        this.setup_dialog = setup_dialog;
        this.selectWave = new JMenuItem("Select wave panel");
        this.selectWave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (jScopeWavePopup.this.wave != ((WaveformManager)((Object)jScopeWavePopup.this.parent)).gGetSelected()) {
                    ((WaveformManager)((Object)jScopeWavePopup.this.parent)).select(jScopeWavePopup.this.wave);
                } else {
                    ((WaveformManager)((Object)jScopeWavePopup.this.parent)).deselect();
                }
            }
        });
        this.sep1 = new JSeparator();
        this.refresh = new JMenuItem("Refresh");
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((jScopeWaveContainer)jScopeWavePopup.this.parent).Refresh((jScopeMultiWave)jScopeWavePopup.this.wave, "Refresh ");
            }
        });
    }

    @Override
    protected void ShowDialog() {
        this.ShowSetupDialog();
    }

    @Override
    protected void SetMenuItem(boolean is_image) {
        super.SetMenuItem(is_image);
        this.insert(this.refresh, this.getComponentCount() - 2);
        this.setup.setEnabled(this.setup_dialog != null);
        if (!is_image) {
            this.insert(this.selectWave, 2);
            this.add(this.sep3);
            this.add(this.saveAsText);
        }
        if (this.wave != null && ((jScopeMultiWave)this.wave).wi.num_waves == 1) {
            ((jScopeMultiWave)this.wave).wi.signal_select = 0;
        }
    }

    @Override
    protected void SetMenuLabel() {
        super.SetMenuLabel();
        if (!this.wave.IsImage()) {
            if (this.wave.IsSelected()) {
                this.selectWave.setText("Deselect wave panel");
            } else {
                this.selectWave.setText("Select wave panel");
            }
        } else {
            this.profile_dialog.setEnabled(!this.wave.isSendProfile());
        }
    }

    @Override
    protected void SetMenu() {
        super.SetMenu();
        jScopeFacade.jScopeSetUI(this);
    }

    protected void ShowSetupDialog() {
        jScopeMultiWave w = (jScopeMultiWave)this.wave;
        if (w.mode == 2) {
            this.setup_dialog.selectSignal(w.GetSelectedSignal());
        } else if (w.GetShowSignalCount() > 0 || w.is_image && w.wi.num_waves != 0) {
            this.setup_dialog.selectSignal(1);
        }
        Timer t = new Timer(20, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Point p = ((WaveformManager)((Object)jScopeWavePopup.this.parent)).getWavePosition(jScopeWavePopup.this.wave);
                jScopeWavePopup.this.setup_dialog.Show(jScopeWavePopup.this.wave, p.x, p.y);
            }
        });
        t.setRepeats(false);
        t.start();
    }

    @Override
    protected void RemoveLegend() {
        super.RemoveLegend();
        ((jScopeMultiWave)this.wave).wi.ShowLegend(false);
    }

    @Override
    protected void PositionLegend(Point p) {
        super.PositionLegend(p);
        ((jScopeMultiWave)this.wave).wi.ShowLegend(true);
        ((jScopeMultiWave)this.wave).wi.SetLegendPosition(((jScopeMultiWave)this.wave).GetLegendXPosition(), ((jScopeMultiWave)this.wave).GetLegendYPosition());
    }

    @Override
    protected void SetInterpolate(boolean state) {
        super.SetInterpolate(state);
        jScopeMultiWave w = (jScopeMultiWave)this.wave;
        w.wi.interpolates[w.GetSelectedSignal()] = state;
    }

    @Override
    protected void SetMode1D(int mode) {
        jScopeMultiWave w = (jScopeMultiWave)this.wave;
        w.wi.mode1D[w.GetSelectedSignal()] = mode;
        super.SetMode1D(mode);
    }

    @Override
    protected void SetMode2D(int mode) {
        jScopeMultiWave w = (jScopeMultiWave)this.wave;
        w.wi.mode2D[w.GetSelectedSignal()] = mode;
        super.SetMode2D(mode);
    }

    @Override
    public void SetDeselectPoint(Waveform w) {
        String f_name = System.getProperty("jScope.save_selected_points");
        if (w.ShowMeasure() && f_name != null && f_name.length() != 0) {
            long shot = 0L;
            jScopeMultiWave mw = (jScopeMultiWave)w;
            if (mw.wi.shots != null) {
                shot = mw.wi.shots[mw.GetSelectedSignal()];
            }
            try {
                boolean exist = false;
                File f = new File(f_name);
                if (f.exists()) {
                    exist = true;
                }
                BufferedWriter out = new BufferedWriter(new FileWriter(f_name, true));
                if (!exist) {
                    out.write(" Shot X1 Y1 X2 Y2");
                    out.newLine();
                }
                out.write(" " + shot + w.getIntervalPoints());
                out.newLine();
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.SetDeselectPoint(w);
    }

    @Override
    public void SetSignalState(String label, boolean state) {
        jScopeMultiWave w = (jScopeMultiWave)this.wave;
        w.SetSignalState(label, state);
    }

    @Override
    public void SetMarker(int idx) {
        super.SetMarker(idx);
        jScopeMultiWave w = (jScopeMultiWave)this.wave;
        if (w.wi.markers[w.GetSelectedSignal()] != idx) {
            w.wi.markers[w.GetSelectedSignal()] = idx;
        }
    }

    @Override
    public void SetMarkerStep(int step) {
        super.SetMarkerStep(step);
        jScopeMultiWave w = (jScopeMultiWave)this.wave;
        if (w.wi.markers_step[w.GetSelectedSignal()] != step) {
            w.wi.markers_step[w.GetSelectedSignal()] = step;
        }
    }

    @Override
    public void SetColor(int idx) {
        super.SetColor(idx);
        jScopeMultiWave w = (jScopeMultiWave)this.wave;
        int sigIdx = w.GetSelectedSignal();
        if (sigIdx != -1 && w.wi.colors_idx[sigIdx] != idx) {
            w.wi.colors_idx[w.GetSelectedSignal()] = idx % Waveform.getColors().length;
            w.SetCrosshairColor(idx);
        }
    }
}

