/*
 * Decompiled with CFR 0.152.
 */
package mds.provider;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import mds.connection.ConnectionEvent;
import mds.connection.ConnectionListener;
import mds.connection.UpdateEventListener;
import mds.wave.DataProvider;
import mds.wave.DataServerItem;
import mds.wave.FrameData;
import mds.wave.Frames;
import mds.wave.WaveData;
import mds.wave.WaveDataListener;
import mds.wave.WaveInterface;
import mds.wave.Waveform;
import mds.wave.XYData;

public class TwuDataProvider
implements DataProvider {
    private transient Vector<ConnectionListener> connection_listener = new Vector();
    private String error_string;
    private String experiment;
    private TwuWaveData lastWaveData = null;
    private long shot;

    private static void handleException(Exception e) {
        if (Waveform.is_debug) {
            e.printStackTrace(System.out);
        }
    }

    public TwuDataProvider() {
    }

    public TwuDataProvider(String user_agent) {
    }

    @Override
    public synchronized void addConnectionListener(ConnectionListener l) {
        if (l == null) {
            return;
        }
        this.connection_listener.addElement(l);
    }

    @Override
    public void addUpdateEventListener(UpdateEventListener l, String event) {
    }

    public void dispatchConnectionEvent(ConnectionEvent e) {
        if (this.connection_listener != null) {
            for (int i = 0; i < this.connection_listener.size(); ++i) {
                this.connection_listener.elementAt(i).processConnectionEvent(e);
            }
        }
    }

    @Override
    public void close() {
    }

    @Override
    public String getError() {
        return this.error_string;
    }

    public synchronized TwuWaveData FindWaveData(String in_y, String in_x) {
        if (this.lastWaveData == null || this.lastWaveData.notEqualsInputSignal(in_y, in_x, this.shot)) {
            this.lastWaveData = new TwuWaveData(this, in_y, in_x);
            try {
                this.lastWaveData.getTwuProperties();
            }
            catch (IOException e) {
                this.setErrorstring("No Such Signal : " + TwuNameServices.GetSignalPath(in_y, this.shot));
            }
        }
        return this.lastWaveData;
    }

    public synchronized String getExperiment() {
        return this.experiment;
    }

    @Override
    public double getFloat(String in, int row, int col, int index) {
        return Double.parseDouble(in);
    }

    public synchronized float[] GetFloatArray(String in) {
        this.resetErrorstring(null);
        if (in.startsWith("TIME:", 0)) {
            in = in.substring(5);
        }
        TwuWaveData wd = (TwuWaveData)this.getWaveData(in, 0, 0, 0);
        float[] data = null;
        try {
            data = wd.getData((int)4000).y;
        }
        catch (Exception e) {
            this.resetErrorstring(e.toString());
            data = null;
        }
        return data;
    }

    public synchronized float[] GetFloatArray(String in, boolean is_time) throws IOException {
        TwuWaveData wd = (TwuWaveData)this.getWaveData(in, 0, 0, 0);
        return is_time ? wd.getXData() : wd.getYData();
    }

    @Override
    public FrameData getFrameData(String in_y, String in_x, float time_min, float time_max) throws IOException {
        return new TwuSimpleFrameData(this, in_y, in_x, time_min, time_max);
    }

    public synchronized WaveData GetResampledWaveData(String in, double start, double end, int n_points) {
        return this.GetResampledWaveData(in, null, start, end, n_points);
    }

    public synchronized WaveData GetResampledWaveData(String in_y, String in_x, double start, double end, int n_points) {
        TwuWaveData find = this.FindWaveData(in_y, in_x);
        find.setZoom((float)start, (float)end, n_points);
        return find;
    }

    @Override
    public long[] getShots(String in, String experiment) {
        this.resetErrorstring(null);
        String curr_in = in.trim();
        if (curr_in.startsWith("[", 0)) {
            if (curr_in.endsWith("]")) {
                curr_in = curr_in.substring(1, curr_in.length() - 1);
                StringTokenizer st = new StringTokenizer(curr_in, ",", false);
                long[] result = new long[st.countTokens()];
                int i = 0;
                try {
                    while (st.hasMoreTokens()) {
                        result[i++] = Integer.parseInt(st.nextToken());
                    }
                    return result;
                }
                catch (Exception exception) {}
            }
        } else if (curr_in.indexOf(":") != -1) {
            StringTokenizer st = new StringTokenizer(curr_in, ":");
            if (st.countTokens() == 2) {
                try {
                    int start = Integer.parseInt(st.nextToken());
                    int end = Integer.parseInt(st.nextToken());
                    if (end < start) {
                        end = start;
                    }
                    long[] result = new long[end - start + 1];
                    for (int i = 0; i < end - start + 1; ++i) {
                        result[i] = start + i;
                    }
                    return result;
                }
                catch (Exception exception) {}
            }
        } else {
            long[] result = new long[1];
            try {
                result[0] = Long.parseLong(curr_in);
                return result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.resetErrorstring("Error parsing shot number(s)");
        return null;
    }

    public synchronized String GetSignalProperty(String prop, String in) throws IOException {
        TwuWaveData wd = (TwuWaveData)this.getWaveData(in, 0, 0, 0);
        return wd.getTwuProperties().getProperty(prop);
    }

    @Override
    public String getString(String in, int row, int col, int index) {
        return in;
    }

    @Override
    public synchronized WaveData getWaveData(String in, int row, int col, int index) {
        return this.getWaveData(in, null, 0, 0, 0);
    }

    @Override
    public synchronized WaveData getWaveData(String in_y, String in_x, int row, int col, int index) {
        TwuWaveData find = this.FindWaveData(in_y, in_x);
        find.setFullFetch();
        return find;
    }

    @Override
    public int inquireCredentials(JFrame f, DataServerItem server_item) {
        return 1;
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public synchronized void removeConnectionListener(ConnectionListener l) {
        if (l == null) {
            return;
        }
        this.connection_listener.removeElement(l);
    }

    @Override
    public void removeUpdateEventListener(UpdateEventListener l, String event) {
    }

    protected synchronized void resetErrorstring(String newErrStr) {
        this.error_string = newErrStr;
    }

    @Override
    public void setArgument(String arg) {
    }

    @Override
    public void setEnvironment(String s) {
    }

    public synchronized void setErrorstring(String newErrStr) {
        if (this.error_string == null) {
            this.error_string = newErrStr;
        }
    }

    @Override
    public boolean supportsTunneling() {
        return false;
    }

    @Override
    public synchronized void update(String experiment, long shot) {
        this.experiment = experiment;
        this.shot = shot;
        this.resetErrorstring(null);
        this.lastWaveData = null;
    }

    private class TwuWaveData
    implements WaveData {
        private TwuSingleSignal abscissa_X = null;
        private String abscissa_X_name = null;
        private TwuSingleSignal mainSignal = null;
        private String mainSignal_name = null;
        private long shotOfThisData = 0L;
        private String title = null;

        private TwuWaveData() {
        }

        private TwuWaveData(TwuDataProvider dp, String in_y) {
            this.init(dp, in_y, null);
        }

        private TwuWaveData(TwuDataProvider dp, String in_y, String in_x) {
            this.init(dp, in_y, in_x);
        }

        @Override
        public void addWaveDataListener(WaveDataListener listener) {
        }

        @Override
        public XYData getData(double xmin, double xmax, int numPoints) throws IOException {
            double[] x = this.GetXDoubleData();
            float[] y = this.GetFloatData();
            return new XYData(x, y, Double.MAX_VALUE);
        }

        @Override
        public XYData getData(int numPoints) throws IOException {
            double[] x = this.GetXDoubleData();
            float[] y = this.GetFloatData();
            return new XYData(x, y, Double.MAX_VALUE);
        }

        @Override
        public XYData getData(long xmin, long xmax, int numPoints) throws IOException {
            double[] x = this.GetXDoubleData();
            float[] y = this.GetFloatData();
            return new XYData(x, y, Double.MAX_VALUE);
        }

        @Override
        public void getDataAsync(double lowerBound, double upperBound, int numPoints) {
        }

        private float[] GetFloatData() throws IOException {
            if (this.mainSignal == null || this.mainSignal.error()) {
                return null;
            }
            return this.mainSignal.getData();
        }

        @Override
        public int getNumDimension() throws IOException {
            return this.mainSignal.getTwuProperties(this.shotOfThisData).Dimensions();
        }

        @Override
        public String GetTitle() throws IOException {
            if (this.title != null) {
                return this.title;
            }
            int dim = this.getNumDimension();
            if (dim != 0) {
                this.title = this.mainSignal.getTwuProperties(this.shotOfThisData).Title();
            } else {
                try {
                    this.title = this.mainSignal.ScalarToTitle(this.shotOfThisData);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    TwuDataProvider.handleException(e);
                    throw new IOException(e.toString());
                }
            }
            return this.title;
        }

        private TwuProperties getTwuProperties() throws IOException {
            return this.mainSignal.getTwuProperties(this.shotOfThisData);
        }

        @Override
        public double[] getX2D() {
            System.out.println("BADABUM!!");
            return null;
        }

        @Override
        public long[] getX2DLong() {
            System.out.println("BADABUM!!");
            return null;
        }

        private float[] getXData() throws IOException {
            return this.abscissa_X.getData();
        }

        private double[] GetXDoubleData() {
            return null;
        }

        @Override
        public String GetXLabel() throws IOException {
            return this.abscissa_X.getTwuProperties(this.shotOfThisData).Units();
        }

        @Override
        public float[] getY2D() {
            System.out.println("BADABUM!!");
            return null;
        }

        private float[] getYData() throws IOException {
            return this.mainSignal.getData();
        }

        @Override
        public String GetYLabel() throws IOException {
            return this.mainSignal.getTwuProperties(this.shotOfThisData).Units();
        }

        @Override
        public float[] getZ() {
            System.out.println("BADABUM!!");
            return null;
        }

        @Override
        public String GetZLabel() throws IOException {
            return null;
        }

        private void init(TwuDataProvider dp, String in_y, String in_x) {
            in_y = in_y != null && in_y.trim().length() != 0 ? in_y.trim() : null;
            in_x = in_x != null && in_x.trim().length() != 0 ? in_x.trim() : null;
            this.shotOfThisData = dp.shot;
            this.mainSignal_name = in_y;
            this.abscissa_X_name = in_x;
            this.mainSignal = new TwuSingleSignal(dp, this.mainSignal_name);
            this.abscissa_X = this.abscissa_X_name != null ? new TwuSingleSignal(dp, this.abscissa_X_name) : new TwuSingleSignal(dp, this.mainSignal);
        }

        @Override
        public boolean isXLong() {
            return false;
        }

        private boolean notEqualsInputSignal(String in_y, String in_x, long requestedShot) {
            boolean y_equals;
            if (this.shotOfThisData != requestedShot) {
                return true;
            }
            in_y = in_y != null && in_y.trim().length() != 0 ? in_y.trim() : null;
            String string = in_x = in_x != null && in_x.trim().length() != 0 ? in_x.trim() : null;
            boolean bl = in_y == null ? this.mainSignal_name == null : (y_equals = this.mainSignal_name != null && in_y.equalsIgnoreCase(this.mainSignal_name));
            boolean x_equals = in_x == null ? this.abscissa_X_name == null : this.abscissa_X_name != null && in_x.equalsIgnoreCase(this.abscissa_X_name);
            return !x_equals || !y_equals;
        }

        @Override
        public void removeWaveDataListener(WaveDataListener listener) {
        }

        private void setFetchOptions(TwuFetchOptions opt) throws IOException {
            this.mainSignal.setFetchOptions(opt);
            this.abscissa_X.setFetchOptions(opt);
        }

        private void setFullFetch() {
            try {
                this.setFetchOptions(new TwuFetchOptions());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void setZoom(float xmin, float xmax, int n_points) {
            try {
                this.setFetchOptions(this.abscissa_X.FindIndicesForXRange(this.shotOfThisData, xmin, xmax, n_points));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public boolean supportsStreaming() {
            return false;
        }
    }

    private static class TwuSingleSignal {
        private float[] data = null;
        private Exception errorSource = null;
        private TwuFetchOptions fetchOptions = null;
        private boolean isAbscissa = false;
        private TwuSingleSignal mainSignal = null;
        private TwuProperties properties = null;
        private TwuDataProvider provider = null;
        private long shotOfTheProperties = 0L;
        private String source = null;

        private static void checkForError(TwuSingleSignal sig) throws Exception {
            if (sig != null && sig.error()) {
                throw (Exception)sig.errorSource.fillInStackTrace();
            }
        }

        private static int FindIndex(float target, TwuSingleSignal xsig, int start, int step, int maxpts, int upperlimit) {
            float[] data = xsig.doFetch(new TwuFetchOptions(start, step, maxpts + 1));
            int newnum = data.length;
            int ix = TwuSingleSignal.findIndexInSubset(data, target);
            int bestGuess = start + ix * step;
            if (step > 1) {
                int newstep = (int)Math.ceil((float)step / (float)maxpts);
                if (newstep < 1) {
                    newstep = 1;
                }
                return TwuSingleSignal.FindIndex(target, xsig, bestGuess, newstep, maxpts, upperlimit);
            }
            if (ix >= newnum - 1) {
                return bestGuess > upperlimit ? upperlimit : bestGuess;
            }
            boolean closer = Math.abs(data[ix] - target) <= Math.abs(data[ix + 1] - target);
            return closer ? bestGuess : bestGuess + 1;
        }

        private static int findIndexInSubset(float[] subsetData, float target) {
            int ix;
            if (subsetData == null) {
                return 0;
            }
            int len = subsetData.length;
            if (len < 2) {
                return 0;
            }
            boolean up = subsetData[1] > subsetData[0];
            if (up) {
                for (ix = 0; ix < len && subsetData[ix] <= target; ++ix) {
                }
            } else {
                while (ix < len && subsetData[ix] >= target) {
                    ++ix;
                }
            }
            if (ix != 0) {
                --ix;
            }
            return ix;
        }

        public TwuSingleSignal(TwuDataProvider dp, String src) {
            this.provider = dp;
            this.source = src;
        }

        public TwuSingleSignal(TwuDataProvider dp, TwuSingleSignal prnt) {
            this.provider = dp;
            this.mainSignal = prnt;
            this.isAbscissa = true;
        }

        private void checkForError() throws Exception {
            TwuSingleSignal.checkForError(this);
        }

        private void createScalarData() {
            if (this.properties != null && this.properties.LengthTotal() == 1) {
                this.data = this.properties.getProperty("Signal.Minimum") != null ? new float[]{(float)this.properties.Minimum()} : new float[]{0.0f};
                return;
            }
            this.setErrorString("No numerical data available!");
            this.data = null;
        }

        private void DispatchConnectionEvent(ConnectionEvent e) {
            if (this.provider != null) {
                this.provider.dispatchConnectionEvent(e);
            }
        }

        private void doClip(TwuFetchOptions opt) throws IOException {
            int length = this.getTwuProperties(this.shotOfTheProperties).LengthTotal();
            opt.clip(length);
        }

        protected float[] doFetch(TwuFetchOptions opt) {
            ConnectionEvent ce = this.makeConnectionEvent("Start Loading " + (this.isAbscissa ? "X" : "Y"));
            this.DispatchConnectionEvent(ce);
            TwuSignal bulk = new TwuSignal(this.properties, opt.getStart(), opt.getStep(), opt.getTotal());
            return this.SimplifiedGetFloats(bulk, opt.getTotal());
        }

        public boolean error() {
            return this.errorSource != null;
        }

        private void fake_my_Properties() {
            int len = this.mainSignal.getTwuProperties().LengthTotal();
            this.properties = new TwuPropertiesFake(len);
        }

        private void fetch_my_Properties(String propsurl, String XorY) throws Exception {
            this.DispatchConnectionEvent(this.makeConnectionEvent("Load Properties", 0, 0));
            this.properties = new TwuProperties(propsurl);
            this.DispatchConnectionEvent(this.makeConnectionEvent(null, 0, 0));
            if (!this.properties.valid()) {
                this.setErrorString("No Such " + XorY + " Signal : " + propsurl);
                this.throwError("Error loading properties of " + XorY + " data !" + propsurl);
            }
        }

        private void fetch_X_Properties() throws Exception {
            int dim;
            TwuSingleSignal.checkForError(this.mainSignal);
            TwuProperties yprops = this.mainSignal != null ? this.mainSignal.getTwuProperties() : null;
            int n = dim = yprops != null ? yprops.Dimensions() : -1;
            if (dim > 1 || dim < 0) {
                this.throwError("Not a 1-dimensional signal !");
            }
            if (!yprops.hasAbscissa0()) {
                this.fake_my_Properties();
                return;
            }
            String mypropsurl = yprops.FQAbscissa0Name();
            this.fetch_my_Properties(mypropsurl, "X");
        }

        private void fetch_Y_Properties() throws Exception {
            if (this.source == null) {
                this.throwError("No input signal set !");
            }
            String propsurl = TwuNameServices.GetSignalPath(this.source, this.shotOfTheProperties);
            this.fetch_my_Properties(propsurl, "Y");
        }

        private void fetchBulkData() throws Exception {
            if (this.fetchOptions == null) {
                this.throwError("unspecified fetch options (internal error)");
            }
            if (this.fetchOptions.getTotal() == -1) {
                this.doClip(this.fetchOptions);
            }
            if (this.fetchOptions.getTotal() <= 1) {
                this.createScalarData();
                return;
            }
            this.data = this.doFetch(this.fetchOptions);
        }

        private void fetchProperties() throws Exception {
            try {
                this.errorSource = null;
                this.data = null;
                if (this.isAbscissa) {
                    this.fetch_X_Properties();
                } else {
                    this.fetch_Y_Properties();
                }
            }
            catch (Exception e) {
                this.errorSource = e;
            }
            this.checkForError();
        }

        private TwuFetchOptions FindIndicesForXRange(long requestedShot, float x_start, float x_end, int n_points) throws Exception {
            TwuProperties prop = this.getTwuProperties(requestedShot);
            int len = prop.LengthTotal();
            if (prop.Dimensions() == 0 || len <= 1) {
                return new TwuFetchOptions(0, 1, 1);
            }
            int POINTS_PER_REQUEST = 100;
            int step = (int)Math.ceil((float)len / 100.0f);
            int ix_start = TwuSingleSignal.FindIndex(x_start, this, 0, step, 100, len);
            int ix_end = TwuSingleSignal.FindIndex(x_end, this, 0, step, 100, len);
            int range = ix_end - ix_start;
            int aproxStep = range / (n_points - 1);
            int finalStep = aproxStep < 1 ? 1 : range / (n_points - 1);
            int finalPoints = 1 + (int)Math.floor((float)range / (float)finalStep);
            return new TwuFetchOptions(ix_start, finalStep, finalPoints);
        }

        public float[] getData() throws IOException {
            if (this.data != null) {
                return this.data;
            }
            try {
                this.fetchBulkData();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                TwuDataProvider.handleException(e);
                throw new IOException(e.toString());
            }
            return this.data;
        }

        public TwuProperties getTwuProperties() {
            return this.properties;
        }

        public TwuProperties getTwuProperties(long requestedShot) throws IOException {
            if (this.properties == null || this.shotOfTheProperties != requestedShot) {
                try {
                    this.shotOfTheProperties = requestedShot;
                    this.fetchProperties();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    TwuDataProvider.handleException(e);
                    throw new IOException(e.toString());
                }
            }
            return this.properties;
        }

        private ConnectionEvent makeConnectionEvent(String info) {
            return new ConnectionEvent(this.provider != null ? this.provider : this, info);
        }

        private ConnectionEvent makeConnectionEvent(String info, int total_size, int current_size) {
            return new ConnectionEvent(this.provider != null ? this.provider : this, info, total_size, current_size);
        }

        public String ScalarToTitle(long requestedShot) throws Exception {
            TwuProperties props = this.getTwuProperties(requestedShot);
            String name = props.Title();
            if (props.LengthTotal() > 1) {
                return name + " (is not a scalar)";
            }
            String units = props.Units();
            float min = 0.0f;
            if (props.getProperty("Signal.Minimum") != null) {
                min = (float)props.Minimum();
            } else {
                float[] scalar = this.doFetch(new TwuFetchOptions());
                min = scalar[0];
            }
            return name + " = " + min + " " + units;
        }

        private void setErrorString(String errmsg) {
            if (this.provider != null) {
                this.provider.setErrorstring(errmsg);
            }
        }

        public void setFetchOptions(TwuFetchOptions opt) throws IOException {
            this.doClip(opt);
            if (this.fetchOptions != null && this.fetchOptions.equalsForBulkData(opt)) {
                return;
            }
            this.fetchOptions = opt;
            this.data = null;
        }

        private float[] SimplifiedGetFloats(TwuSignal bulk, int n_point) {
            ConnectionEvent ce = this.makeConnectionEvent(this.isAbscissa ? "Load X" : "Load Y", 0, 0);
            this.DispatchConnectionEvent(ce);
            int inc = Math.max(n_point / 1000, 10);
            while (!bulk.finished && !bulk.error) {
                bulk.tryToRead(inc);
                ce = this.makeConnectionEvent(this.isAbscissa ? "X:" : "Y:", n_point, bulk.getActualSampleCount());
                this.DispatchConnectionEvent(ce);
                Thread.yield();
            }
            if (bulk.error) {
                this.setErrorString("Error reading Bulk Data");
            }
            this.DispatchConnectionEvent(this.makeConnectionEvent(null, 0, 0));
            return bulk.error ? null : bulk.getBulkData();
        }

        private void throwError(String msg) throws Exception {
            this.errorSource = new Exception(msg);
            throw this.errorSource;
        }
    }

    private class TwuSimpleFrameData
    implements FrameData {
        byte[] buf;
        int first_frame_idx = -1;
        String in_y;
        int mode = -1;
        private int n_frames = 0;
        private TwuDataProvider provider = null;
        private int st_idx = -1;
        private int end_idx = -1;
        private float[] times = null;

        private TwuSimpleFrameData(TwuDataProvider dp, String in_y, String in_x, float time_min, float time_max) throws IOException {
            float t;
            int i;
            float[] all_times = null;
            this.provider = dp;
            this.in_y = in_y;
            all_times = in_x == null || in_x.length() == 0 ? new float[117] : this.provider.GetFloatArray(in_x);
            if (all_times == null) {
                throw new IOException("Frame time evaluation error");
            }
            for (i = 0; i < all_times.length; ++i) {
                all_times[i] = (float)(-0.1 + 0.06 * (double)i);
            }
            for (i = 0; i < all_times.length && !((t = all_times[i]) > time_max); ++i) {
                if (!(t >= time_min) || this.st_idx != -1) continue;
                this.st_idx = i;
            }
            this.end_idx = i;
            if (this.st_idx == -1) {
                throw new IOException("No frames found between " + time_min + " - " + time_max);
            }
            this.n_frames = this.end_idx - this.st_idx;
            this.times = new float[this.n_frames];
            int j = 0;
            for (i = this.st_idx; i < this.end_idx; ++i) {
                this.times[j++] = all_times[i];
            }
        }

        @Override
        public byte[] getFrameAt(int idx) throws IOException {
            if (idx == this.first_frame_idx && this.buf != null) {
                return this.buf;
            }
            ConnectionEvent ce = new ConnectionEvent(this, "Loading Image " + (idx *= 3), 0, 0);
            this.provider.dispatchConnectionEvent(ce);
            StringTokenizer st = new StringTokenizer(this.in_y, "/", true);
            String str = new String();
            int nt = st.countTokens();
            for (int i = 0; i < nt - 1; ++i) {
                str = str + st.nextToken();
            }
            String img_name = "00000" + idx;
            img_name = img_name.substring(img_name.length() - 6, img_name.length());
            str = str + img_name + ".jpg";
            URL url = new URL(str);
            URLConnection url_con = url.openConnection();
            int size = url_con.getContentLength();
            byte[] b_img = null;
            if (size > 0) {
                int offset = 0;
                int num_read = 0;
                b_img = new byte[size];
                InputStream is = url_con.getInputStream();
                while (size > 0 && num_read != -1) {
                    num_read = is.read(b_img, offset, size);
                    size -= num_read;
                    offset += num_read;
                }
            }
            return b_img;
        }

        @Override
        public Dimension getFrameDimension() {
            return null;
        }

        @Override
        public float[] getFrameTimes() {
            return this.times;
        }

        @Override
        public int getFrameType() throws IOException {
            int i;
            if (this.mode != -1) {
                return this.mode;
            }
            for (i = 0; i < this.n_frames; ++i) {
                this.buf = this.getFrameAt(i);
                if (this.buf != null) break;
            }
            this.first_frame_idx = i;
            this.mode = Frames.DecodeImageType(this.buf);
            return this.mode;
        }

        @Override
        public int getNumFrames() {
            return this.n_frames;
        }
    }

    private static class TwuSignal {
        private URL bulkURL = null;
        private boolean error = false;
        private boolean finished = false;
        private BufferedReader instream = null;
        private int sampleCount = 0;
        private int samples2Read = 0;
        private TwuProperties twup = null;
        private float[] ydata = null;

        private TwuSignal(TwuProperties SigURL, int firstSample, int step, int maxSamples) {
            boolean success = false;
            this.twup = SigURL;
            if (maxSamples <= 0) {
                maxSamples = this.twup.LengthTotal();
            }
            this.samples2Read = maxSamples;
            this.ydata = new float[this.samples2Read];
            this.finished = false;
            this.sampleCount = 0;
            if (!SigURL.valid()) {
                this.finished = true;
                return;
            }
            if (this.twup.Equidistant()) {
                success = this.tryToConstruct(firstSample, step, maxSamples);
            }
            if (!success) {
                this.prepareToRead(firstSample, step, maxSamples);
            }
        }

        private int getActualSampleCount() {
            return this.sampleCount;
        }

        private float[] getBulkData() {
            if (this.sampleCount < this.ydata.length) {
                float[] newydata = new float[this.sampleCount];
                if (this.sampleCount > 0) {
                    System.arraycopy(this.ydata, 0, newydata, 0, this.sampleCount);
                }
                this.ydata = null;
                this.ydata = newydata;
            }
            return this.ydata;
        }

        private void prepareToRead(int firstSample, int step, int maxSamples) {
            try {
                this.error = false;
                StringBuffer bulk = new StringBuffer(this.twup.FQBulkName() + "?start=" + firstSample);
                if (step > 0) {
                    bulk.append("&step=" + step);
                }
                if (maxSamples > 0) {
                    bulk.append("&total=" + maxSamples);
                }
                this.bulkURL = new URL(bulk.toString());
                URLConnection con = this.bulkURL.openConnection();
                con.setRequestProperty("User-Agent", "TWUSignal.java for jScope ($Revision$)");
                con.setRequestProperty("Connection", "close");
                con.connect();
                this.instream = new BufferedReader(new InputStreamReader(con.getInputStream()));
            }
            catch (Exception e) {
                System.out.println("TWUSignal.prepareToRead :" + e);
                this.error = true;
            }
        }

        private boolean tryToConstruct(int firstSample, int step, int maxSamples) {
            double last;
            double first;
            double min = this.twup.Minimum();
            double max = this.twup.Maximum();
            if (firstSample < 0) {
                firstSample = 0;
            }
            if (step < 1) {
                step = 1;
            }
            if (maxSamples < 0) {
                maxSamples = 0;
            }
            if (this.twup.Incrementing()) {
                first = min;
                last = max;
            } else if (this.twup.Decrementing()) {
                first = max;
                last = min;
            } else {
                return false;
            }
            long lentotal = this.twup.LengthTotal();
            long stillToGo = lentotal - (long)firstSample;
            long stepsToGo = stillToGo < 1L ? 0L : 1L + (stillToGo - 1L) / (long)step;
            long toReturn = stepsToGo < (long)maxSamples ? stepsToGo : (long)maxSamples;
            double span = last - first;
            long segments = lentotal - 1L;
            double delta = segments == 0L ? 0.0 : span / (double)segments;
            double stepXdelta = (double)step * delta;
            double firstValue = (double)firstSample * delta + first;
            int ix = 0;
            while ((long)ix < toReturn) {
                this.ydata[ix] = (float)((double)ix * stepXdelta + firstValue);
                if ((double)this.ydata[ix] > max) {
                    this.ydata[ix] = (float)max;
                } else if ((double)this.ydata[ix] < min) {
                    this.ydata[ix] = (float)min;
                }
                ++ix;
            }
            this.sampleCount = ix;
            this.finished = true;
            return true;
        }

        private void tryToRead(int samples2Try) {
            block8: {
                int thisAttempt = 0;
                try {
                    String s = null;
                    while (samples2Try > thisAttempt++ && this.samples2Read > this.sampleCount && (s = this.instream.readLine()) != null) {
                        Float F = Float.valueOf(s);
                        this.ydata[this.sampleCount++] = F.floatValue();
                    }
                    boolean bl = this.finished = this.sampleCount >= this.samples2Read || s == null;
                    if (!this.finished) break block8;
                    try {
                        this.instream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.sampleCount < this.samples2Read) {
                        if (this.sampleCount == 0) {
                            this.ydata[this.sampleCount++] = 0.0f;
                        }
                        while (this.sampleCount < this.samples2Read) {
                            this.ydata[this.sampleCount] = this.ydata[this.sampleCount - 1];
                            ++this.sampleCount;
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println("TWUSignal.tryToRead :" + e);
                    this.error = true;
                }
            }
        }
    }

    private static class TwuPropertiesFake
    extends TwuProperties {
        private TwuPropertiesFake(int len) {
            super((String)null);
            this.signalProps.put("TWU.properties.version", "0.7");
            this.signalProps.put("Dimensions", "1");
            this.signalProps.put("Length.total", String.valueOf(len));
            this.signalProps.put("Length.dimension.0", String.valueOf(len));
            this.signalProps.put("Equidistant", "Incrementing");
            this.signalProps.put("Signal.Minimum", "0.0");
            this.signalProps.put("Signal.Maximum", String.valueOf((double)(len - 1)));
        }

        @Override
        protected boolean valid() {
            return true;
        }
    }

    private static class TwuProperties {
        protected Properties signalProps = new Properties();
        private URL signalURL = null;
        private boolean textRead = false;

        private TwuProperties(String SigURL) {
            this(SigURL, (String)null);
        }

        private TwuProperties(String SigURL, String user_agent) {
            String actual_user_agent = user_agent != null ? user_agent : "TWUProperties.java for jScope ($Revision$)";
            this.signalProps = new Properties();
            if (SigURL == null) {
                return;
            }
            String fullURL = this.CompleteURL(SigURL);
            try {
                this.signalURL = new URL(fullURL);
                URLConnection con = this.signalURL.openConnection();
                con.setRequestProperty("User-Agent", actual_user_agent);
                String mime_type = con.getContentType();
                if (mime_type == null || mime_type.indexOf("text") >= 0) {
                    this.signalProps.load(con.getInputStream());
                    this.textRead = true;
                }
            }
            catch (Exception e) {
                this.signalURL = null;
            }
        }

        private String CompleteURL(String in) {
            if (in.indexOf("://") >= 0) {
                return in;
            }
            return "http:" + in;
        }

        private boolean Decrementing() {
            String equidistant = this.signalProps.getProperty("Equidistant");
            return equidistant != null && equidistant.equalsIgnoreCase("decrementing");
        }

        private int Dimensions() {
            String dimstr = this.signalProps.getProperty("Dimensions");
            Integer dim = Integer.valueOf(dimstr == null ? "0" : dimstr);
            return dim;
        }

        private boolean Equidistant() {
            return (this.Incrementing() || this.Decrementing()) && this.signalProps.getProperty("Signal.Minimum") != null && this.signalProps.getProperty("Signal.Maximum") != null;
        }

        private String FQAbscissa0Name() {
            String abs = this.signalProps.getProperty("Abscissa.URL.0");
            return abs == null || abs.equalsIgnoreCase("None") ? null : abs;
        }

        private String FQBulkName() {
            return this.signalProps.getProperty("Bulkfile.URL");
        }

        private String getProperty(String keyword) {
            return this.signalProps.getProperty(keyword);
        }

        private boolean hasAbscissa0() {
            String abscissa = this.signalProps.getProperty("Abscissa.URL.0");
            return abscissa == null ? false : !abscissa.equalsIgnoreCase("None");
        }

        private boolean Incrementing() {
            String equidistant = this.signalProps.getProperty("Equidistant");
            return equidistant != null && equidistant.equalsIgnoreCase("incrementing");
        }

        private int LengthTotal() {
            String ltstr = this.signalProps.getProperty("Length.total");
            Integer lt = Integer.valueOf(ltstr == null ? "0" : ltstr);
            return lt;
        }

        private double Maximum() {
            String max = this.signalProps.getProperty("Signal.Maximum");
            if (max != null) {
                return Double.parseDouble(max);
            }
            return Double.NaN;
        }

        private double Minimum() {
            String min = this.signalProps.getProperty("Signal.Minimum");
            if (min != null) {
                return Double.parseDouble(min);
            }
            return Double.NaN;
        }

        private String Title() {
            String title = this.signalProps.getProperty("Title");
            if (title == null) {
                title = this.signalProps.getProperty("SignalName");
            }
            return title;
        }

        public String toString() {
            return this.signalURL == null ? "" : this.signalURL.toString();
        }

        private String Units() {
            String unitstr = this.signalProps.getProperty("Unit");
            return unitstr == null || unitstr.equalsIgnoreCase("None") ? "" : unitstr;
        }

        protected boolean valid() {
            String version = this.signalProps.getProperty("TWU.properties.version");
            return this.textRead && version != null && (version.equals("0.7") || version.equals("0.8"));
        }
    }

    private static class TwuNameServices {
        private static final String default_experiment = "textor";
        private static final String default_provider_url = "ipptwu.ipp.kfa-juelich.de";

        private TwuNameServices() {
        }

        private static boolean catersFor(DataProvider dp) {
            return dp instanceof TwuDataProvider;
        }

        private static String GetSignalPath(String internalSignalURL, long shot) {
            if (TwuNameServices.IsFullURL(internalSignalURL)) {
                return internalSignalURL;
            }
            if (TwuNameServices.isHashedURL(internalSignalURL)) {
                return TwuNameServices.hashed2shot(internalSignalURL, shot);
            }
            String p_url = TwuNameServices.GetURLserver(internalSignalURL);
            if (p_url == null) {
                p_url = default_provider_url;
            } else {
                internalSignalURL = internalSignalURL.substring(internalSignalURL.indexOf("//") + 2, internalSignalURL.length());
            }
            StringTokenizer st = new StringTokenizer(internalSignalURL, "/");
            String full_url = "http://" + p_url + "/" + TwuNameServices.probableExperiment(null) + "/" + st.nextToken() + "/" + shot;
            while (st.hasMoreTokens()) {
                full_url = full_url + "/" + st.nextToken();
            }
            return full_url;
        }

        private static String GetURLserver(String in) {
            String out = null;
            int idx = in.indexOf("//");
            if (idx != -1) {
                out = in.substring(0, idx);
            }
            return out;
        }

        private static String hashed2shot(String hashedURL, long shot) {
            if (hashedURL == null) {
                return hashedURL;
            }
            int hashfield = hashedURL.indexOf("#");
            if (hashfield == -1) {
                return hashedURL;
            }
            String full_url = hashedURL.substring(0, hashfield) + shot + hashedURL.substring(hashedURL.lastIndexOf("#") + 1);
            return full_url;
        }

        private static boolean IsFullURL(String in) {
            return ((in = in.toLowerCase()).startsWith("http://") || in.startsWith("//")) && in.indexOf("#") == -1;
        }

        public static boolean isHashedURL(String in) {
            return (in = in.toLowerCase()).startsWith("//") && in.indexOf("#") != -1;
        }

        private static String probableExperiment(WaveInterface wi) {
            if (wi != null) {
                TwuDataProvider twudp;
                String twudp_exp;
                if (wi.experiment != null) {
                    return wi.experiment;
                }
                if (wi.dp != null && TwuNameServices.catersFor(wi.dp) && (twudp_exp = (twudp = (TwuDataProvider)wi.dp).getExperiment()) != null) {
                    return twudp_exp;
                }
            }
            return default_experiment;
        }
    }

    private static class TwuFetchOptions {
        private int start = 0;
        private int step = 1;
        private int total = -1;

        public TwuFetchOptions() {
        }

        public TwuFetchOptions(int sta, int ste, int tot) {
            this.start = sta;
            this.step = ste;
            this.total = tot;
        }

        public void clip(int twupLengthTotal) {
            int requestedEnd;
            int overshoot;
            int length = twupLengthTotal;
            if (length <= 0 || length <= this.start) {
                this.start = 0;
                this.step = 1;
                this.total = 0;
                return;
            }
            if (this.start < 0) {
                this.start = 0;
            }
            if (this.step < 1) {
                this.step = 1;
            }
            if (this.total < 0) {
                this.total = length;
            }
            if ((overshoot = (requestedEnd = this.start + (this.total - 1) * this.step) - (length - 1)) > 0 && (overshoot %= this.step) > 0) {
                overshoot -= this.step;
            }
            int realEnd = length - 1 + overshoot;
            this.total = (realEnd - this.start) / this.step + 1;
        }

        public boolean equalsForBulkData(TwuFetchOptions opt) {
            return this.start == opt.start && this.step == opt.step && this.total == opt.total;
        }

        public int getStart() {
            return this.start;
        }

        public int getStep() {
            return this.step;
        }

        public int getTotal() {
            return this.total;
        }

        public String toString() {
            return "TWUFetchOptions(" + this.start + ", " + this.step + ", " + this.total + ")";
        }
    }
}

