/*
 * Decompiled with CFR 0.152.
 */
package mds.wave;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import mds.wave.MultiWaveform;
import mds.wave.ProfileDialog;
import mds.wave.SetupWaveformParams;
import mds.wave.Signal;
import mds.wave.WavePopup;
import mds.wave.Waveform;
import mds.wave.WaveformManager;

public class MultiWavePopup
extends WavePopup {
    protected MultiWaveform wave = null;
    protected JMenuItem legend = new JMenuItem("Position legend");
    protected JMenuItem remove_legend;
    protected JMenu signalList;

    public MultiWavePopup() {
        this(null, null);
    }

    public MultiWavePopup(SetupWaveformParams setup_params, ProfileDialog profDialog) {
        super(setup_params, profDialog);
        this.legend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!MultiWavePopup.this.wave.isFixedLegend() || !MultiWavePopup.this.wave.IsShowLegend()) {
                    MultiWavePopup.this.PositionLegend(new Point(MultiWavePopup.this.curr_x, MultiWavePopup.this.curr_y));
                } else if (MultiWavePopup.this.wave.isFixedLegend()) {
                    MultiWavePopup.this.RemoveLegend();
                }
            }
        });
        this.legend.setEnabled(false);
        this.remove_legend = new JMenuItem("Remove legend");
        this.remove_legend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiWavePopup.this.RemoveLegend();
            }
        });
        this.remove_legend.setEnabled(false);
        this.signalList = new JMenu("Signals");
        this.signalList.setEnabled(false);
    }

    protected Waveform getWave() {
        return ((WavePopup)this).wave;
    }

    protected void RemoveLegend() {
        this.wave.RemoveLegend();
    }

    protected void PositionLegend(Point p) {
        this.wave.SetLegend(p);
    }

    @Override
    protected void SetMenuItem(boolean is_image) {
        int start = 0;
        super.SetMenuItem(is_image);
        if (!is_image) {
            if (this.parent instanceof WaveformManager) {
                start += 2;
            }
            this.insert(this.legend, start + 1);
            if (this.wave.isFixedLegend()) {
                this.insert(this.signalList, start + 4);
                this.legend.setText("Show Legend");
            } else {
                this.insert(this.remove_legend, start + 2);
                this.insert(this.signalList, start + 5);
            }
        }
    }

    @Override
    protected void SetSignalMenu() {
        super.SetSignalMenu();
        if (this.wave.GetShowSignalCount() == 0) {
            this.legend.setEnabled(false);
            this.remove_legend.setEnabled(false);
            this.signalList.setEnabled(false);
        }
    }

    @Override
    protected void InitOptionMenu() {
        String[] s_name = this.wave.GetSignalsName();
        boolean[] s_state = this.wave.GetSignalsState();
        if (s_name == null || s_state == null || s_name.length <= 0 || s_state.length <= 0 || s_name.length != s_state.length) {
            return;
        }
        boolean state = this.wave.mode == 2 || this.wave.GetShowSignalCount() == 1;
        this.markerList.setEnabled(state);
        this.colorList.setEnabled(state);
        this.set_point.setEnabled(this.wave.mode == 2);
        if (state) {
            int st;
            int sig_idx = this.wave.GetShowSignalCount() == 1 ? 0 : this.wave.GetSelectedSignal();
            boolean state_m = state && this.wave.GetMarker(sig_idx) != 0 && this.wave.GetMarker(sig_idx) != 5;
            this.markerStep.setEnabled(state_m);
            this.SelectListItem(this.markerList_bg, this.wave.GetMarker(sig_idx));
            for (st = 0; st < Signal.markerStepList.length && Signal.markerStepList[st] != this.wave.GetMarkerStep(sig_idx); ++st) {
            }
            this.SelectListItem(this.markerStep_bg, st);
            this.SelectListItem(this.colorList_bg, this.wave.GetColorIdx(sig_idx));
        } else {
            this.markerStep.setEnabled(false);
        }
        if (s_name != null) {
            if (this.signalList.getItemCount() != 0) {
                this.signalList.removeAll();
            }
            this.signalList.setEnabled(s_name.length != 0);
            this.legend.setEnabled(s_name.length != 0);
            for (int i = 0; i < s_name.length; ++i) {
                JCheckBoxMenuItem ob = new JCheckBoxMenuItem(s_name[i]);
                this.signalList.add(ob);
                ob.setState(s_state[i]);
                ob.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        Object target = e.getSource();
                        MultiWavePopup.this.SetSignalState(((JCheckBoxMenuItem)target).getText(), ((JCheckBoxMenuItem)target).getState());
                        MultiWavePopup.this.wave.Repaint(true);
                    }
                });
            }
        }
        if (this.wave.isFixedLegend()) {
            if (this.wave.IsShowLegend()) {
                this.legend.setText("Hide Legend");
            } else {
                this.legend.setText("Show Legend");
            }
        } else {
            this.legend.setText("Position Legend");
            if (this.wave.IsShowLegend()) {
                this.remove_legend.setEnabled(true);
            } else {
                this.remove_legend.setEnabled(false);
            }
        }
    }

    @Override
    protected void SetMenu() {
        this.wave = (MultiWaveform)((WavePopup)this).wave;
        super.SetMenu();
    }

    protected void SetInterpolate(boolean state) {
        this.wave.SetInterpolate(this.wave.GetSelectedSignal(), state);
    }

    @Override
    protected void SetMode2D(int mode) {
        this.wave.setSignalMode(this.wave.GetSelectedSignal(), mode);
    }

    public void SetSignalState(String label, boolean state) {
        this.wave.SetSignalState(label, state);
    }

    @Override
    public void SetMarker(int idx) {
        if (this.wave.GetMarker(this.wave.GetSelectedSignal()) != idx) {
            this.wave.SetMarker(this.wave.GetSelectedSignal(), idx);
        }
    }

    @Override
    public void SetMarkerStep(int step) {
        if (this.wave.GetMarkerStep(this.wave.GetSelectedSignal()) != step) {
            this.wave.SetMarkerStep(this.wave.GetSelectedSignal(), step);
        }
    }

    @Override
    public void SetColor(int idx) {
        if (this.wave.GetColorIdx(this.wave.GetSelectedSignal()) != idx) {
            this.wave.SetColorIdx(this.wave.GetSelectedSignal(), idx);
        }
    }
}

