/*
 * Decompiled with CFR 0.152.
 */
package mds.wave;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.JComponent;
import mds.wave.RowColumnLayout;

public class RowColumnContainer
extends JComponent {
    protected RowColumnLayout row_col_layout;
    protected int[] rows = new int[]{1, 0, 0, 0};
    protected float[] ph;
    protected float[] pw;
    private Vector<Point> real_position = new Vector();
    private Point split_pos = null;
    private Component maximizeC = null;

    public RowColumnContainer() {
        this.setName("RowColumnContainer");
        this.row_col_layout = new RowColumnLayout(this.rows);
        this.setLayout(this.row_col_layout);
    }

    public RowColumnContainer(int[] rows, Component[] c) {
        int i;
        this.setName("RowColumnContainer");
        if (rows == null || rows.length == 0) {
            throw new IllegalArgumentException("Defined null or empty row column container");
        }
        this.rows = new int[rows.length];
        for (i = 0; i < rows.length; ++i) {
            this.rows[i] = rows[i];
        }
        this.row_col_layout = new RowColumnLayout(rows);
        this.setLayout(this.row_col_layout);
        int num_component = this.getComponentNumber();
        for (i = 0; i < num_component - 1; ++i) {
            Btm b = new Btm();
            this.add(b);
            this.setListener(b);
        }
        if (c != null) {
            if (num_component != c.length) {
                throw new IllegalArgumentException("Invalid componet number");
            }
            this.add(c);
            this.validate();
        }
    }

    private void setListener(Component b) {
        b.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Component ob = e.getComponent();
                if (ob instanceof Btm && (e.getModifiersEx() & 0x800) != 2048) {
                    RowColumnContainer.this.row_col_layout.ResizeRowColumn(ob, e.getPoint().x, e.getPoint().y);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Component ob = e.getComponent();
                if (ob instanceof Btm && (e.getModifiersEx() & 0x800) == 2048) {
                    RowColumnContainer.this.row_col_layout.ResizeRowColumn(ob);
                }
            }
        });
        b.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Component ob = e.getComponent();
                if ((e.getModifiersEx() & 0x800) != 2048) {
                    RowColumnContainer.this.row_col_layout.DrawResize(ob, e.getPoint().x, e.getPoint().y);
                }
            }
        });
    }

    public void add(Component[] c) {
        if (c.length != this.getComponentNumber()) {
            throw new IllegalArgumentException("Invalid component number");
        }
        int k = 0;
        for (int i = 0; i < this.rows.length; ++i) {
            for (int j = 0; j < this.rows[i]; ++j) {
                super.add(c[k]);
                ++k;
            }
        }
    }

    private boolean positionOverwrite(Point pos) {
        for (int i = 1; i < this.real_position.size(); i += 2) {
            Point real_pos = this.real_position.elementAt(i);
            if (pos.x != real_pos.x || pos.y != real_pos.y) continue;
            return true;
        }
        return false;
    }

    private void setRealPosition(Point in_pos, Point real_pos) {
        if (in_pos == null || real_pos == null) {
            return;
        }
        if (in_pos.x != real_pos.x || in_pos.y != real_pos.y) {
            this.real_position.addElement(in_pos);
            this.real_position.addElement(real_pos);
        }
    }

    private Point getRealPosition(Point in_pos) {
        for (int i = 0; i < this.real_position.size(); i += 2) {
            Point p = this.real_position.elementAt(i);
            if (in_pos.x != p.x || in_pos.y != p.y) continue;
            return this.real_position.elementAt(i + 1);
        }
        return null;
    }

    public void add(Component c, int row, int col) {
        int cmp_idx = 0;
        int rrow = row;
        int rcol = col;
        if (this.getGridComponent(row, col) != null) {
            throw new IllegalArgumentException("Component already added in this position");
        }
        if (col > this.rows.length) {
            if (row != 1) {
                rrow = 1;
            }
            int[] new_rows = new int[col];
            for (int i = 0; i < this.rows.length; ++i) {
                new_rows[i] = this.rows[i];
            }
            new_rows[col - 1] = 1;
            this.rows = new_rows;
            cmp_idx = -1;
        } else {
            rrow = this.rows[col - 1] + 1;
            cmp_idx = this.getComponentIndex(rrow - 1, col) + 1;
            for (int i = 0; i < this.real_position.size(); i += 2) {
                Point in_pos = this.real_position.elementAt(i);
                if (row >= in_pos.y || col != in_pos.x) continue;
                --cmp_idx;
                --rrow;
            }
            for (int j = 0; j < this.real_position.size(); j += 2) {
                Point in_p = this.real_position.elementAt(j);
                if (row >= in_p.y || col != in_p.x) continue;
                Point real_p = this.real_position.elementAt(j + 1);
                ++real_p.y;
                if (in_p.x == real_p.x && in_p.y == real_p.y) {
                    this.real_position.removeElementAt(j);
                    this.real_position.removeElementAt(j);
                    j -= 2;
                    continue;
                }
                if (rrow > real_p.y || rcol != real_p.x) continue;
                this.real_position.setElementAt(new Point(real_p.x, real_p.y), j + 1);
            }
            int n = col - 1;
            this.rows[n] = this.rows[n] + 1;
        }
        if (cmp_idx >= 0) {
            super.add(c, cmp_idx);
        } else {
            super.add(c);
        }
        Btm b = new Btm();
        super.add((Component)b, 0);
        this.setListener(b);
        if (rrow != row || rcol != col) {
            this.setRealPosition(new Point(col, row), new Point(rcol, rrow));
        }
    }

    public void update() {
        this.row_col_layout.SetRowColumn(this.rows, this.ph, this.pw);
        this.invalidate();
        this.validate();
    }

    public void update(float[] ph, float[] pw) {
        this.ph = ph;
        this.pw = pw;
        this.update();
    }

    public Component getMaximizeComponent() {
        return this.maximizeC;
    }

    public void resetMaximizeComponent() {
        this.maximizeC = null;
    }

    public boolean isMaximize() {
        return this.maximizeC != null;
    }

    public void maximizeComponent(Component c) {
        this.maximizeC = c;
        if (c == null) {
            this.update();
            return;
        }
        int n_com = this.getGridComponentCount();
        if (n_com == 1) {
            return;
        }
        float[] m_ph = new float[n_com];
        float[] m_pw = new float[this.rows.length];
        this.ph = new float[n_com];
        this.pw = new float[this.rows.length];
        Point p = this.getComponentPosition(c);
        int k = 0;
        for (int i = 0; i < this.rows.length; ++i) {
            if (this.rows[i] == 0) continue;
            this.pw[i] = this.row_col_layout.getPercentWidth(i);
            m_pw[i] = i == p.x - 1 ? 1.0f : 0.0f;
            for (int j = 0; j < this.rows[i]; ++j) {
                m_ph[k] = i == p.x - 1 && j == p.y - 1 ? 1.0f : 0.0f;
                this.ph[k] = this.row_col_layout.getPercentHeight(k);
                ++k;
            }
        }
        this.row_col_layout.SetRowColumn(this.rows, m_ph, m_pw);
        this.invalidate();
        this.validate();
    }

    public void setRowColumn(int[] rows) {
        this.rows = rows;
        this.row_col_layout.SetRowColumn(rows);
    }

    public int getGridComponentCount() {
        return (super.getComponentCount() + 1) / 2;
    }

    public Component getGridComponent(int n) {
        return this.getComponent(this.getGridComponentCount() - 1 + n);
    }

    public Component getGridComponent(int row, int col) {
        Point curr_pos = new Point(col, row);
        Point p = this.getRealPosition(curr_pos);
        if (p != null) {
            col = p.x;
            row = p.y;
        } else if (this.positionOverwrite(curr_pos)) {
            return null;
        }
        int idx = this.getComponentIndex(row, col);
        if (idx < 0) {
            return null;
        }
        return this.getComponent(idx);
    }

    public int getComponentIndex(int row, int col) {
        int cmp_idx = 0;
        if (col > this.rows.length || row > this.rows[col - 1]) {
            return -1;
        }
        for (int i = 0; i < col - 1; ++i) {
            cmp_idx += this.rows[i];
        }
        return cmp_idx + row + this.getGridComponentCount() - 2;
    }

    public int getComponentIndex(Component c) {
        int idx;
        for (idx = 0; idx < this.getGridComponentCount() && this.getGridComponent(idx) != c; ++idx) {
        }
        if (idx < this.getGridComponentCount()) {
            return idx + 1;
        }
        return -1;
    }

    public Point getComponentPosition(Component c) {
        int col = 0;
        int row = 0;
        if (c == null) {
            return null;
        }
        int idx = this.getComponentIndex(c);
        for (col = 0; col < this.rows.length; ++col) {
            for (row = 0; row < this.rows[col] && idx != 0; --idx, ++row) {
            }
            if (idx == 0) break;
        }
        Point p = new Point(col + 1, row);
        return p;
    }

    public void update(int[] rows, Component[] c) {
        int i;
        if (rows == null || rows.length == 0) {
            throw new IllegalArgumentException("Defined null or empty row column container");
        }
        int[] curr_rows = this.rows;
        int idx_w = this.getGridComponentCount() - 1;
        int idx = 0;
        int col = curr_rows.length > rows.length ? curr_rows.length : rows.length;
        for (i = 0; i < col; ++i) {
            Btm b;
            int k;
            if (i > rows.length) {
                for (k = 0; k < curr_rows[i]; ++k) {
                    this.remove(idx_w);
                    this.remove(0);
                    --idx_w;
                }
                continue;
            }
            if (i > curr_rows.length - 1) {
                for (k = 0; k < rows[i]; ++k) {
                    b = new Btm();
                    this.add((Component)b, 0);
                    this.setListener(b);
                    this.add(c[idx++]);
                }
                continue;
            }
            if (curr_rows[i] > rows[i]) {
                idx_w += rows[i];
                for (k = rows[i]; k < curr_rows[i]; ++k) {
                    if (idx_w > 0) {
                        this.remove(idx_w);
                    }
                    this.remove(0);
                    --idx_w;
                }
                continue;
            }
            idx_w += curr_rows[i];
            for (k = curr_rows[i]; k < rows[i]; ++k) {
                this.add(c[idx++], idx_w);
                b = new Btm();
                this.add((Component)b, 0);
                this.setListener(b);
                ++idx_w;
            }
        }
        if (!rows.equals(this.rows)) {
            this.rows = new int[rows.length];
            for (i = 0; i < rows.length; ++i) {
                this.rows[i] = rows[i];
            }
        }
        this.row_col_layout.SetRowColumn(rows);
        this.invalidate();
        this.validate();
    }

    public void removeComponent(int row, int col) {
        int idx = this.getComponentIndex(row, col);
        int b_idx = idx - this.getGridComponentCount();
        this.remove(idx);
        if (b_idx >= 0) {
            this.remove(b_idx);
        } else {
            this.remove(b_idx + 1);
        }
        int size = this.real_position.size();
        for (int j = 0; j < size; j += 2) {
            Point real_p = this.real_position.elementAt(j + 1);
            if (row != real_p.y || col != real_p.x) continue;
            this.real_position.removeElementAt(j);
            this.real_position.removeElementAt(j);
            break;
        }
        size = this.real_position.size();
        for (int i = row + 1; i <= this.rows[col - 1]; ++i) {
            boolean found = false;
            for (int j = 0; j < size; j += 2) {
                Point real_p = this.real_position.elementAt(j + 1);
                if (i != real_p.y || col != real_p.x) continue;
                found = true;
                --real_p.y;
                this.real_position.setElementAt(new Point(real_p.x, real_p.y), j + 1);
                break;
            }
            if (found) continue;
            this.setRealPosition(new Point(col, i + 1), new Point(col, i));
        }
        int n = col - 1;
        this.rows[n] = this.rows[n] - 1;
        this.pw = null;
        this.ph = null;
        this.update();
    }

    public void removeComponent(Component c) {
        if (c == null) {
            return;
        }
        Point p = this.getComponentPosition(c);
        if (p == null) {
            return;
        }
        this.removeComponent(p.y, p.x);
    }

    public int getComponentNumber() {
        int num = 0;
        for (int i = 0; i < this.rows.length && this.rows[i] != 0; ++i) {
            num += this.rows[i];
        }
        return num;
    }

    public int getColumns() {
        int col = 0;
        for (int c = 0; c < this.rows.length; ++c) {
            if (this.rows[c] == 0) continue;
            ++col;
        }
        return col;
    }

    public int getComponentsInColumn(int col) {
        return this.rows[col];
    }

    public int[] getComponentsInColumns() {
        return this.rows;
    }

    public int splitContainer(Component c) {
        int idx = 1;
        int col = 0;
        int row = 0;
        boolean not_add = true;
        for (int j = this.rows.length; j <= this.rows.length * 4 && not_add; ++j) {
            idx = 0;
            for (int i = 0; i < this.rows.length; ++i) {
                if (this.rows[i] < j && not_add) {
                    row = this.rows[i] + 1;
                    col = i + 1;
                    not_add = false;
                }
                idx += this.rows[i];
            }
        }
        this.add(c, row, col);
        this.split_pos = new Point(col, row);
        this.update();
        return idx - 1;
    }

    public Point getSplitPosition() {
        return this.split_pos;
    }

    public void resetSplitPosition() {
        this.split_pos = null;
    }

    public float[] getNormalizedHeight() {
        if (this.isMaximize()) {
            return this.ph;
        }
        return this.row_col_layout.getPercentHeight();
    }

    public float[] getNormalizedWidth() {
        if (this.isMaximize()) {
            return this.ph;
        }
        return this.row_col_layout.getPercentWidth();
    }

    public int[] getComponetNumInColumns() {
        return this.rows;
    }

    public void repaintAll() {
        for (int i = 0; i < this.getGridComponentCount(); ++i) {
            this.getGridComponent(i).repaint();
        }
    }

    class Btm
    extends Component {
        Btm() {
            this.setBackground(Color.lightGray);
        }

        @Override
        public void paint(Graphics g) {
            Rectangle d = this.getBounds();
            if (d.width > d.height) {
                this.setCursor(new Cursor(8));
            } else {
                this.setCursor(new Cursor(10));
            }
            g.draw3DRect(0, 0, d.width - 1, d.height - 1, true);
        }

        @Override
        public void print(Graphics g) {
        }

        @Override
        public void printAll(Graphics g) {
        }
    }
}

