/*
 * Decompiled with CFR 0.152.
 */
package mds.connection;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Vector;
import java.util.zip.InflaterInputStream;
import mds.connection.ConnectionEvent;
import mds.connection.ConnectionListener;
import mds.connection.Descriptor;

public class MdsMessage {
    public static final int HEADER_SIZE = 48;
    public static final int SUPPORTS_COMPRESSION = 32768;
    public static final byte SENDCAPABILITIES = 15;
    public static final byte COMPRESSED = 32;
    public static final byte BIG_ENDIAN_MASK = -128;
    public static final byte SWAP_ENDIAN_ON_SERVER_MASK = 64;
    public static final byte JAVA_CLIENT = -61;
    public static final String EVENTASTREQUEST = "---EVENTAST---REQUEST---";
    public static final String EVENTCANREQUEST = "---EVENTCAN---REQUEST---";
    static byte msgid = 1;
    int msglen;
    public int status;
    public short length;
    public byte nargs;
    public byte descr_idx;
    public byte message_id;
    public byte dtype;
    public byte client_type;
    public byte ndims;
    public int[] dims;
    public byte[] body;
    protected boolean swap = false;
    protected boolean compressed = false;
    private Vector<ConnectionListener> connectionListeners = null;

    public MdsMessage() {
        this(0, 0, 0, null, new byte[1]);
        this.status = 1;
    }

    public MdsMessage(String s) {
        this(s, null);
    }

    public MdsMessage(byte c) {
        this(c, null);
    }

    public MdsMessage(String s, Vector<ConnectionListener> v) {
        this.connectionListeners = v;
        this.BuildMdsMessage((byte)0, (byte)14, (byte)1, null, s.getBytes());
    }

    public MdsMessage(byte c, Vector<ConnectionListener> v) {
        this.connectionListeners = v;
        byte[] buf = new byte[]{c};
        this.BuildMdsMessage((byte)0, (byte)14, (byte)1, null, buf);
    }

    public MdsMessage(byte descr_idx, byte dtype, byte nargs, int[] dims, byte[] body) {
        this.BuildMdsMessage(descr_idx, dtype, nargs, dims, body);
    }

    public void BuildMdsMessage(byte descr_idx, byte dtype, byte nargs, int[] dims, byte[] body) {
        int body_size = body != null ? body.length : 0;
        this.msglen = 48 + body_size;
        this.status = 0;
        this.message_id = msgid;
        this.length = Descriptor.getDataSize(dtype, body);
        this.nargs = nargs;
        this.descr_idx = descr_idx;
        this.ndims = dims != null ? (byte)(dims.length > 8 ? 8 : dims.length) : (byte)0;
        this.dims = new int[8];
        for (int i = 0; i < 8; ++i) {
            this.dims[i] = dims != null && i < dims.length ? dims[i] : 0;
        }
        this.dtype = dtype;
        this.client_type = (byte)-61;
        this.body = body;
    }

    public void useCompression(boolean use_cmp) {
        this.status = use_cmp ? 32773 : 0;
    }

    protected synchronized byte[] ReadCompressedBuf(InputStream dis) throws IOException {
        int bytes_to_read;
        int read_bytes = 0;
        int curr_offset = 0;
        byte[] b4 = new byte[4];
        this.ReadBuf(b4, dis);
        byte[] out = new byte[bytes_to_read];
        InflaterInputStream zis = new InflaterInputStream(dis);
        for (bytes_to_read = this.ToInt(b4) - 48; bytes_to_read > 0; bytes_to_read -= read_bytes) {
            read_bytes = zis.read(out, curr_offset, bytes_to_read);
            curr_offset += read_bytes;
        }
        byte[] pp = new byte[1];
        while (zis.available() == 1) {
            zis.read(pp);
        }
        return out;
    }

    protected synchronized void ReadBuf(byte[] buf, InputStream dis) throws IOException {
        ConnectionEvent e;
        int bytes_to_read = buf.length;
        int read_bytes = 0;
        int curr_offset = 0;
        boolean send = false;
        if (bytes_to_read > 2000) {
            send = true;
            e = new ConnectionEvent((Object)this, buf.length, curr_offset);
            this.dispatchConnectionEvent(e);
        }
        while (bytes_to_read > 0) {
            read_bytes = dis.read(buf, curr_offset, bytes_to_read);
            if (read_bytes < 0) {
                throw new IOException("Read Operation Failed");
            }
            curr_offset += read_bytes;
            bytes_to_read -= read_bytes;
            if (!send) continue;
            e = new ConnectionEvent((Object)this, buf.length, curr_offset);
            this.dispatchConnectionEvent(e);
        }
    }

    public synchronized void Send(DataOutputStream dos) throws IOException {
        dos.writeInt(this.msglen);
        dos.writeInt(this.status);
        dos.writeShort(this.length);
        dos.writeByte(this.nargs);
        dos.writeByte(this.descr_idx);
        dos.writeByte(this.message_id);
        dos.writeByte(this.dtype);
        dos.writeByte(this.client_type);
        dos.writeByte(this.ndims);
        for (int i = 0; i < 8; ++i) {
            dos.writeInt(this.dims[i]);
        }
        dos.write(this.body, 0, this.body.length);
        dos.flush();
        if (this.descr_idx == this.nargs - 1) {
            msgid = (byte)(msgid + 1);
        }
        if (msgid == 0) {
            msgid = 1;
        }
    }

    protected int ByteToIntSwap(byte[] b, int idx) {
        int ch1 = (b[idx + 3] & 0xFF) << 24;
        int ch2 = (b[idx + 2] & 0xFF) << 16;
        int ch3 = (b[idx + 1] & 0xFF) << 8;
        int ch4 = (b[idx + 0] & 0xFF) << 0;
        return ch1 + ch2 + ch3 + ch4;
    }

    protected int ByteToInt(byte[] b, int idx) {
        int ch1 = (b[idx + 0] & 0xFF) << 24;
        int ch2 = (b[idx + 1] & 0xFF) << 16;
        int ch3 = (b[idx + 2] & 0xFF) << 8;
        int ch4 = (b[idx + 3] & 0xFF) << 0;
        return ch1 + ch2 + ch3 + ch4;
    }

    protected short ByteToShortSwap(byte[] b, int idx) {
        short ch1 = (short)((b[idx + 1] & 0xFF) << 8);
        short ch2 = (short)((b[idx + 0] & 0xFF) << 0);
        return (short)(ch1 + ch2);
    }

    protected short ByteToShort(byte[] b, int idx) {
        short ch1 = (short)((b[idx + 0] & 0xFF) << 8);
        short ch2 = (short)((b[idx + 1] & 0xFF) << 0);
        return (short)(ch1 + ch2);
    }

    public synchronized void Receive(InputStream dis) throws IOException {
        byte[] header_b = new byte[48];
        byte c_type = 0;
        int idx = 0;
        this.ReadBuf(header_b, dis);
        c_type = header_b[14];
        this.swap = (c_type & 0xFFFFFF80) != -128;
        boolean bl = this.compressed = (c_type & 0x20) == 32;
        if (this.swap) {
            this.msglen = this.ByteToIntSwap(header_b, 0);
            idx = 4;
            this.status = this.ByteToIntSwap(header_b, idx);
            this.length = this.ByteToShortSwap(header_b, idx += 4);
            idx += 2;
        } else {
            this.msglen = this.ByteToInt(header_b, 0);
            idx = 4;
            this.status = this.ByteToInt(header_b, idx);
            this.length = this.ByteToShort(header_b, idx += 4);
            idx += 2;
        }
        this.nargs = header_b[idx++];
        this.descr_idx = header_b[idx++];
        this.message_id = header_b[idx++];
        this.dtype = header_b[idx++];
        c_type = header_b[idx++];
        this.ndims = header_b[idx++];
        if (this.swap) {
            int i = 0;
            int j = idx;
            while (i < 8) {
                this.dims[i] = this.ByteToIntSwap(header_b, j);
                ++i;
                j += 4;
            }
        } else {
            int i = 0;
            int j = idx;
            while (i < 8) {
                this.dims[i] = this.ByteToInt(header_b, j);
                ++i;
                j += 4;
            }
        }
        if (this.msglen > 48) {
            if (this.compressed) {
                this.body = this.ReadCompressedBuf(dis);
            } else {
                this.body = new byte[this.msglen - 48];
                this.ReadBuf(this.body, dis);
            }
        } else {
            this.body = new byte[0];
        }
    }

    protected void Flip(byte[] bytes, int size) {
        for (int i = 0; i < bytes.length; i += size) {
            byte b;
            if (size == 2) {
                b = bytes[i];
                bytes[i] = bytes[i + 1];
                bytes[i + 1] = b;
                continue;
            }
            if (size != 4) continue;
            b = bytes[i];
            bytes[i] = bytes[i + 3];
            bytes[i + 3] = b;
            b = bytes[i + 1];
            bytes[i + 1] = bytes[i + 2];
            bytes[i + 2] = b;
        }
    }

    protected int ToInt(byte[] bytes) throws IOException {
        if (this.swap) {
            this.Flip(bytes, 4);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bis);
        return dis.readInt();
    }

    protected short ToShort(byte[] bytes) throws IOException {
        if (this.swap) {
            this.Flip(bytes, 2);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bis);
        return dis.readShort();
    }

    protected float ToFloat(byte[] bytes) throws IOException {
        if (this.swap) {
            this.Flip(bytes, 4);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bis);
        return dis.readFloat();
    }

    private ByteBuffer getWrappedBody() {
        return ByteBuffer.wrap(this.body).order(this.swap ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
    }

    public long[] ToLongArray() throws IOException {
        long[] out = new long[this.body.length / 8];
        this.getWrappedBody().asLongBuffer().get(out);
        return out;
    }

    public int[] ToIntArray() throws IOException {
        int[] out = new int[this.body.length / 4];
        this.getWrappedBody().asIntBuffer().get(out);
        return out;
    }

    public long[] ToUIntArray() throws IOException {
        int[] signed = this.ToIntArray();
        long[] unsigned = new long[signed.length];
        for (int i = 0; i < signed.length; ++i) {
            unsigned[i] = (long)signed[i] & 0xFFFFFFFFL;
        }
        return unsigned;
    }

    public short[] ToShortArray() throws IOException {
        short[] out = new short[this.body.length / 2];
        this.getWrappedBody().asShortBuffer().get(out);
        return out;
    }

    public int[] ToUShortArray() throws IOException {
        short[] shorts = this.ToShortArray();
        int[] unsigned = new int[shorts.length];
        for (int i = 0; i < shorts.length; ++i) {
            unsigned[i] = shorts[i] & 0xFFFF;
        }
        return unsigned;
    }

    public float[] ToFloatArray() throws IOException {
        float[] out = new float[this.body.length / 4];
        this.getWrappedBody().asFloatBuffer().get(out);
        return out;
    }

    public double[] ToDoubleArray() throws IOException {
        double[] out = new double[this.body.length / 8];
        this.getWrappedBody().asDoubleBuffer().get(out);
        return out;
    }

    public String ToString() {
        return new String(this.body);
    }

    protected final boolean IsRoprand(byte[] arr, int idx) {
        return arr[idx] == 0 && arr[idx + 1] == 0 && arr[idx + 2] == -128 && arr[idx + 3] == 0;
    }

    protected synchronized void dispatchConnectionEvent(ConnectionEvent e) {
        if (this.connectionListeners != null) {
            for (int i = 0; i < this.connectionListeners.size(); ++i) {
                this.connectionListeners.elementAt(i).processConnectionEvent(e);
            }
        }
    }
}

