/*
 * Decompiled with CFR 0.152.
 */
package mds.jscope;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.StringTokenizer;
import mds.connection.UpdateEventListener;
import mds.jscope.jScopeDefaultValues;
import mds.jscope.jScopeWaveContainer;
import mds.wave.ColorMapDialog;
import mds.wave.DataProvider;
import mds.wave.Signal;
import mds.wave.WaveInterface;
import mds.wave.Waveform;

class MdsWaveInterface
extends WaveInterface {
    public String in_upd_event;
    public String last_upd_event;
    public String cin_xmin;
    public String cin_xmax;
    public String cin_ymax;
    public String cin_ymin;
    public String cin_timemax;
    public String cin_timemin;
    public String cin_title;
    public String cin_xlabel;
    public String cin_ylabel;
    public String cin_def_node;
    public String cin_upd_event;
    public String cexperiment;
    public boolean cin_upd_limits = true;
    public String cin_shot;
    public int defaults = -1;
    static final int B_shot = 8;
    static final int B_x_min = 12;
    static final int B_x_max = 13;
    static final int B_y_min = 14;
    static final int B_y_max = 15;
    static final int B_title = 16;
    static final int B_x_label = 10;
    static final int B_y_label = 11;
    static final int B_exp = 7;
    static final int B_event = 17;
    static final int B_default_node = 9;
    static final int B_update = 0;
    public boolean default_is_update = true;
    jScopeDefaultValues def_vals;
    MdsWaveInterface prev_wi = null;
    long prevShot = -1L;
    public String previous_shot = "";

    public MdsWaveInterface(Waveform wave, DataProvider dp, jScopeDefaultValues def_vals) {
        super(dp);
        this.setDefaultsValues(def_vals);
        this.wave = wave;
    }

    public void setDefaultsValues(jScopeDefaultValues def_vals) {
        this.def_vals = def_vals;
        this.default_is_update = false;
        this.def_vals.setIsEvaluated(false);
    }

    public String GetDefaultValue(int i, boolean def_flag) {
        String out = null;
        switch (i) {
            case 16: {
                out = def_flag ? this.def_vals.title_str : this.cin_title;
                break;
            }
            case 8: {
                out = def_flag ? this.def_vals.shot_str : this.cin_shot;
                break;
            }
            case 7: {
                out = def_flag ? this.def_vals.experiment_str : this.cexperiment;
                break;
            }
            case 13: {
                if (this.is_image) {
                    out = def_flag ? this.def_vals.xmax : this.cin_timemax;
                    break;
                }
                out = def_flag ? this.def_vals.xmax : this.cin_xmax;
                break;
            }
            case 12: {
                if (this.is_image) {
                    out = def_flag ? this.def_vals.xmin : this.cin_timemin;
                    break;
                }
                out = def_flag ? this.def_vals.xmin : this.cin_xmin;
                break;
            }
            case 10: {
                out = def_flag ? this.def_vals.xlabel : this.cin_xlabel;
                break;
            }
            case 15: {
                out = def_flag ? this.def_vals.ymax : this.cin_ymax;
                break;
            }
            case 14: {
                out = def_flag ? this.def_vals.ymin : this.cin_ymin;
                break;
            }
            case 11: {
                out = def_flag ? this.def_vals.ylabel : this.cin_ylabel;
                break;
            }
            case 17: {
                out = def_flag ? this.def_vals.upd_event_str : this.cin_upd_event;
                break;
            }
            case 9: {
                out = def_flag ? this.def_vals.def_node_str : this.cin_def_node;
                break;
            }
            case 0: {
                out = def_flag ? "" + this.def_vals.upd_limits : "" + this.cin_upd_limits;
            }
        }
        return out;
    }

    public void UpdateDefault() {
        if (this.default_is_update) {
            return;
        }
        this.default_is_update = true;
        int bit = 16;
        boolean def_flag = (this.defaults & 1 << bit) == 1 << bit;
        this.in_title = this.GetDefaultValue(bit, def_flag);
        bit = 7;
        def_flag = (this.defaults & 1 << bit) == 1 << bit;
        this.experiment = this.GetDefaultValue(bit, def_flag);
        bit = 13;
        boolean bl = def_flag = (this.defaults & 1 << bit) == 1 << bit;
        if (this.is_image) {
            this.in_timemax = this.GetDefaultValue(bit, def_flag);
            this.in_xmax = this.cin_xmax;
        } else {
            this.in_xmax = this.GetDefaultValue(bit, def_flag);
        }
        bit = 12;
        boolean bl2 = def_flag = (this.defaults & 1 << bit) == 1 << bit;
        if (this.is_image) {
            this.in_timemin = this.GetDefaultValue(bit, def_flag);
            this.in_xmin = this.cin_xmin;
        } else {
            this.in_xmin = this.GetDefaultValue(bit, def_flag);
        }
        bit = 10;
        def_flag = (this.defaults & 1 << bit) == 1 << bit;
        this.in_xlabel = this.GetDefaultValue(bit, def_flag);
        bit = 15;
        def_flag = (this.defaults & 1 << bit) == 1 << bit;
        this.in_ymax = this.GetDefaultValue(bit, def_flag);
        bit = 14;
        def_flag = (this.defaults & 1 << bit) == 1 << bit;
        this.in_ymin = this.GetDefaultValue(bit, def_flag);
        bit = 11;
        def_flag = (this.defaults & 1 << bit) == 1 << bit;
        this.in_ylabel = this.GetDefaultValue(bit, def_flag);
        bit = 9;
        def_flag = (this.defaults & 1 << bit) == 1 << bit;
        this.in_def_node = this.GetDefaultValue(bit, def_flag);
        bit = 0;
        def_flag = (this.defaults & 1 << bit) == 1 << bit;
        this.in_upd_limits = new Boolean(this.GetDefaultValue(bit, def_flag));
    }

    public int GetShotIdx() {
        String main_shot_str = ((jScopeWaveContainer)this.wave.getParent()).getMainShotStr();
        if (this.UseDefaultShot()) {
            if (main_shot_str != null && main_shot_str.length() != 0) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public String GetUsedShot() {
        String out = null;
        switch (this.GetShotIdx()) {
            case 0: {
                out = this.cin_shot;
                break;
            }
            case 1: {
                out = this.def_vals.shot_str;
                break;
            }
            case 2: {
                out = ((jScopeWaveContainer)this.wave.getParent()).getMainShotStr();
            }
        }
        return out;
    }

    public String Update() throws IOException {
        int mode = this.wave.GetMode();
        try {
            this.wave.SetMode(5);
            this.UpdateShot();
            if (this.error == null) {
                this.UpdateDefault();
            } else {
                this.signals = null;
            }
            this.wave.SetMode(mode);
        }
        catch (IOException exc) {
            this.wave.SetMode(mode);
            throw exc;
        }
        return this.error;
    }

    public static String containMainShot(String in_shot, String m_shot) {
        int idx;
        String out = in_shot;
        if (in_shot != null && (idx = in_shot.indexOf("#")) != -1) {
            out = m_shot != null ? "[" + in_shot.substring(0, idx) + m_shot + in_shot.substring(idx + 1) + "]" : "[" + in_shot.substring(0, idx) + "[]" + in_shot.substring(idx + 1) + "]";
        }
        return out;
    }

    public long[] GetShots() throws IOException {
        long[] curr_shots = null;
        String main_shot_str = ((jScopeWaveContainer)this.wave.getParent()).getMainShotStr();
        String c_shot_str = MdsWaveInterface.containMainShot(this.GetUsedShot(), main_shot_str);
        this.error = null;
        if (this.UseDefaultShot()) {
            if (main_shot_str != null && main_shot_str.length() != 0) {
                curr_shots = ((jScopeWaveContainer)this.wave.getParent()).getMainShots();
                if (curr_shots == null) {
                    this.error = "Main Shot evaluation error: " + ((jScopeWaveContainer)this.wave.getParent()).getMainShotError(true);
                }
            } else if (this.def_vals.getIsEvaluated() && this.def_vals.shots != null) {
                curr_shots = this.def_vals.shots;
            } else {
                curr_shots = this.GetShotArray(MdsWaveInterface.containMainShot(this.def_vals.shot_str, main_shot_str));
                if (this.error == null) {
                    this.def_vals.shots = curr_shots;
                    this.def_vals.setIsEvaluated(false);
                }
            }
        } else {
            curr_shots = this.GetShotArray(MdsWaveInterface.containMainShot(this.cin_shot, main_shot_str));
        }
        this.in_shot = c_shot_str;
        return curr_shots;
    }

    public void UpdateShot() throws IOException {
        long[] curr_shots = this.GetShots();
        if (!this.UpdateShot(curr_shots)) {
            this.previous_shot = "not defined";
        }
    }

    public MdsWaveInterface(MdsWaveInterface wi) {
        int i;
        this.previous_shot = wi.previous_shot;
        this.provider = wi.provider;
        this.num_waves = wi.num_waves;
        this.num_shot = wi.num_shot;
        this.defaults = wi.defaults;
        this.setModified(wi.getModified());
        this.in_grid_mode = wi.in_grid_mode;
        this.x_log = wi.x_log;
        this.y_log = wi.y_log;
        this.is_image = wi.is_image;
        this.keep_ratio = wi.keep_ratio;
        this.vertical_flip = wi.vertical_flip;
        this.horizontal_flip = wi.horizontal_flip;
        this.show_legend = wi.show_legend;
        this.reversed = wi.reversed;
        this.legend_x = wi.legend_x;
        this.legend_y = wi.legend_y;
        this.setColorMap(wi.getColorMap());
        this.in_label = new String[this.num_waves];
        this.in_x = new String[this.num_waves];
        this.in_y = new String[this.num_waves];
        this.in_up_err = new String[this.num_waves];
        this.in_low_err = new String[this.num_waves];
        this.markers = new int[this.num_waves];
        this.markers_step = new int[this.num_waves];
        this.colors_idx = new int[this.num_waves];
        this.interpolates = new boolean[this.num_waves];
        this.mode2D = new int[this.num_waves];
        this.mode1D = new int[this.num_waves];
        this.w_error = new String[this.num_waves];
        this.evaluated = new boolean[this.num_waves];
        this.signals = new Signal[this.num_waves];
        if (wi.in_shot == null || wi.in_shot.trim().length() == 0) {
            wi.shots = null;
            this.shots = null;
        } else {
            this.shots = new long[this.num_waves];
        }
        for (i = 0; i < this.num_waves; ++i) {
            this.in_label[i] = wi.in_label[i] != null ? new String(wi.in_label[i]) : null;
            this.in_x[i] = wi.in_x[i] != null ? new String(wi.in_x[i]) : null;
            this.in_y[i] = wi.in_y[i] != null ? new String(wi.in_y[i]) : null;
            this.in_up_err[i] = wi.in_up_err[i] != null ? new String(wi.in_up_err[i]) : null;
            this.in_low_err[i] = wi.in_low_err[i] != null ? new String(wi.in_low_err[i]) : null;
        }
        for (i = 0; i < this.num_waves; ++i) {
            this.markers[i] = wi.markers[i];
            this.markers_step[i] = wi.markers_step[i];
            this.colors_idx[i] = wi.colors_idx[i];
            this.interpolates[i] = wi.interpolates[i];
            this.mode2D[i] = wi.mode2D[i];
            this.mode1D[i] = wi.mode1D[i];
            if (wi.shots != null) {
                this.shots[i] = wi.shots[i];
            }
            this.evaluated[i] = wi.evaluated != null ? wi.evaluated[i] : false;
            if (wi.signals != null) {
                this.signals[i] = wi.signals[i];
            }
            if (wi.w_error == null) continue;
            this.w_error[i] = wi.w_error[i];
        }
        this.in_upd_limits = wi.in_upd_limits;
        this.in_xmin = wi.in_xmin != null ? new String(wi.in_xmin) : null;
        this.in_ymin = wi.in_ymin != null ? new String(wi.in_ymin) : null;
        this.in_xmax = wi.in_xmax != null ? new String(wi.in_xmax) : null;
        this.in_ymax = wi.in_ymax != null ? new String(wi.in_ymax) : null;
        this.in_timemax = wi.in_timemax != null ? new String(wi.in_timemax) : null;
        this.in_timemin = wi.in_timemin != null ? new String(wi.in_timemin) : null;
        this.in_shot = wi.in_shot != null ? new String(wi.in_shot) : null;
        this.experiment = wi.experiment != null ? new String(wi.experiment) : null;
        this.in_title = wi.in_title != null ? new String(wi.in_title) : null;
        this.in_xlabel = wi.in_xlabel != null ? new String(wi.in_xlabel) : null;
        this.in_ylabel = wi.in_ylabel != null ? new String(wi.in_ylabel) : null;
        this.in_def_node = wi.in_def_node != null ? new String(wi.in_def_node) : null;
        this.cin_upd_limits = wi.cin_upd_limits;
        this.cin_xmin = wi.cin_xmin != null ? new String(wi.cin_xmin) : null;
        this.cin_ymin = wi.cin_ymin != null ? new String(wi.cin_ymin) : null;
        this.cin_xmax = wi.cin_xmax != null ? new String(wi.cin_xmax) : null;
        this.cin_ymax = wi.cin_ymax != null ? new String(wi.cin_ymax) : null;
        this.cin_timemax = wi.cin_timemax != null ? new String(wi.cin_timemax) : null;
        this.cin_timemin = wi.cin_timemin != null ? new String(wi.cin_timemin) : null;
        this.cin_shot = wi.cin_shot != null ? new String(wi.cin_shot) : null;
        this.cexperiment = wi.cexperiment != null ? new String(wi.cexperiment) : null;
        this.cin_title = wi.cin_title != null ? new String(wi.cin_title) : null;
        this.cin_xlabel = wi.cin_xlabel != null ? new String(wi.cin_xlabel) : null;
        this.cin_ylabel = wi.cin_ylabel != null ? new String(wi.cin_ylabel) : null;
        this.error = wi.error != null ? new String(wi.error) : null;
        this.cin_upd_event = wi.cin_upd_event != null ? new String(wi.cin_upd_event) : null;
        this.cin_def_node = wi.cin_def_node != null ? new String(wi.cin_def_node) : null;
        this.def_vals = wi.def_vals;
        this.SetDataProvider(wi.dp);
    }

    public boolean UseDefaultShot() {
        return (this.defaults & 0x100) != 0;
    }

    public String getErrorString() {
        String full_error = null;
        if (this.w_error == null || this.w_error.length == 0) {
            return null;
        }
        if (!this.is_image) {
            int i;
            int idx = 0;
            if (this.isAddSignal()) {
                i = this.num_waves - this.num_shot;
                if (i < 0) {
                    i = 0;
                }
            } else {
                i = 0;
            }
            while (i < this.w_error.length) {
                String e = this.w_error[i];
                if (e != null) {
                    if (!this.isAddSignal()) {
                        e = "<Wave " + (i + 1) + "> " + e;
                    }
                    if (brief_error && (idx = e.indexOf(10)) < 0) {
                        idx = e.length();
                    }
                    full_error = full_error == null ? (brief_error ? e.substring(0, idx) + "\n" : e + "\n") : (brief_error ? full_error + e.substring(0, idx) + "\n" : full_error + e + "\n");
                }
                ++i;
            }
        }
        if (full_error == null && this.error != null) {
            full_error = brief_error && this.error.indexOf("\n") != -1 ? this.error.substring(0, this.error.indexOf("\n")) : this.error;
        }
        return full_error;
    }

    @Override
    public void SetDataProvider(DataProvider _dp) {
        super.SetDataProvider(_dp);
        this.default_is_update = false;
        this.previous_shot = "";
    }

    public synchronized void refresh() throws Exception {
        try {
            this.error = this.Update();
            if (this.error == null) {
                if (this.getModified()) {
                    this.StartEvaluate();
                    if (this.error == null) {
                        this.EvaluateOthers();
                    }
                }
                this.setModified(this.error != null);
            }
        }
        catch (IOException e) {
            this.setModified(true);
            this.error = e.getMessage();
        }
    }

    public synchronized boolean refreshOnEvent() throws Exception {
        long[] shots = this.GetShots();
        if (shots == null) {
            return false;
        }
        if (shots.length != 1 || shots[0] != this.prevShot) {
            this.prevShot = shots[0];
            return false;
        }
        for (int sigIdx = 0; sigIdx < this.signals.length; ++sigIdx) {
            if (this.signals[sigIdx] == null) continue;
            if (!this.signals[sigIdx].supportsStreaming() || !this.signals[sigIdx].updateSignal()) {
                return false;
            }
            this.signals[sigIdx].mergeRegions();
        }
        return true;
    }

    @Override
    public void Erase() {
        super.Erase();
        this.in_def_node = null;
        this.in_upd_event = null;
        this.last_upd_event = null;
        this.cin_xmin = null;
        this.cin_xmax = null;
        this.cin_ymax = null;
        this.cin_ymin = null;
        this.cin_timemax = null;
        this.cin_timemin = null;
        this.cin_title = null;
        this.cin_xlabel = null;
        this.cin_ylabel = null;
        this.cin_def_node = null;
        this.cin_upd_event = null;
        this.cexperiment = null;
        this.in_shot = null;
        this.cin_shot = null;
        this.defaults = -1;
        this.default_is_update = false;
        this.previous_shot = "";
        this.cin_upd_limits = true;
    }

    public void CreateVector() {
        this.in_label = new String[this.num_waves];
        this.shots = new long[this.num_waves];
        this.in_y = new String[this.num_waves];
        this.in_x = new String[this.num_waves];
        this.in_up_err = new String[this.num_waves];
        this.in_low_err = new String[this.num_waves];
        this.markers = new int[this.num_waves];
        this.markers_step = new int[this.num_waves];
        this.colors_idx = new int[this.num_waves];
        this.interpolates = new boolean[this.num_waves];
        this.mode2D = new int[this.num_waves];
        this.mode1D = new int[this.num_waves];
        for (int i = 0; i < this.num_waves; ++i) {
            this.markers[i] = 0;
            this.markers_step[i] = 1;
            this.colors_idx[i] = i % Waveform.getColors().length;
            this.interpolates[i] = true;
            this.mode2D[i] = 0;
            this.mode1D[i] = 0;
        }
    }

    public void AddEvent(UpdateEventListener w) throws IOException {
        int bit = 17;
        boolean def_flag = (this.defaults & 1 << bit) == 1 << bit;
        String new_event = this.GetDefaultValue(bit, def_flag);
        if (this.in_upd_event == null || !this.in_upd_event.equals(new_event)) {
            this.AddEvent(w, new_event);
        }
    }

    public void RemoveEvent(UpdateEventListener w) throws IOException {
        if (this.in_upd_event != null) {
            this.dp.removeUpdateEventListener(w, this.in_upd_event);
            this.in_upd_event = null;
        }
    }

    public void RemoveEvent(UpdateEventListener w, String event) throws IOException {
        this.dp.removeUpdateEventListener(w, event);
    }

    public void AddEvent(UpdateEventListener w, String event) throws IOException {
        if (this.in_upd_event != null && this.in_upd_event.length() != 0) {
            if (event == null || event.length() == 0) {
                this.dp.removeUpdateEventListener(w, this.in_upd_event);
                this.in_upd_event = null;
            } else if (!this.in_upd_event.equals(event)) {
                this.dp.removeUpdateEventListener(w, this.in_upd_event);
                this.dp.addUpdateEventListener(w, event);
                this.in_upd_event = event;
            }
        } else if (event != null && event.length() != 0) {
            this.dp.addUpdateEventListener(w, event);
            this.in_upd_event = event;
        }
    }

    public void ToFile(PrintWriter out, String prompt) throws IOException {
        int eval_shot = 1;
        int cnum_shot = this.num_shot;
        WaveInterface.WriteLine(out, prompt + "x_label: ", this.cin_xlabel);
        WaveInterface.WriteLine(out, prompt + "y_label: ", this.cin_ylabel);
        if (!this.is_image) {
            WaveInterface.WriteLine(out, prompt + "x_log: ", "" + this.x_log);
            WaveInterface.WriteLine(out, prompt + "y_log: ", "" + this.y_log);
            WaveInterface.WriteLine(out, prompt + "update_limits: ", "" + this.cin_upd_limits);
            if (this.show_legend) {
                WaveInterface.WriteLine(out, prompt + "legend: ", "(" + this.legend_x + "," + this.legend_y + ")");
            }
        } else {
            WaveInterface.WriteLine(out, prompt + "is_image: ", "" + this.is_image);
            WaveInterface.WriteLine(out, prompt + "keep_ratio: ", "" + this.keep_ratio);
            WaveInterface.WriteLine(out, prompt + "horizontal_flip: ", "" + this.horizontal_flip);
            WaveInterface.WriteLine(out, prompt + "vertical_flip: ", "" + this.vertical_flip);
        }
        if (this.colorMap != null) {
            WaveInterface.WriteLine(out, prompt + "palette: ", "" + this.colorMap.name);
            WaveInterface.WriteLine(out, prompt + "bitShift: ", "" + this.colorMap.bitShift);
            WaveInterface.WriteLine(out, prompt + "bitClip: ", "" + this.colorMap.bitClip);
            WaveInterface.WriteLine(out, prompt + "paletteMax: ", "" + this.colorMap.getMax());
            WaveInterface.WriteLine(out, prompt + "paletteMin: ", "" + this.colorMap.getMin());
        }
        WaveInterface.WriteLine(out, prompt + "experiment: ", this.cexperiment);
        WaveInterface.WriteLine(out, prompt + "event: ", this.cin_upd_event);
        WaveInterface.WriteLine(out, prompt + "default_node: ", this.cin_def_node);
        WaveInterface.WriteLine(out, prompt + "num_shot: ", "" + cnum_shot);
        if (cnum_shot != 0) {
            eval_shot = this.UseDefaultShot() ? (this.num_shot > 0 ? this.num_shot : 1) : cnum_shot;
            WaveInterface.WriteLine(out, prompt + "num_expr: ", "" + this.num_waves / eval_shot);
        } else {
            WaveInterface.WriteLine(out, prompt + "num_expr: ", "" + this.num_waves);
            cnum_shot = 1;
        }
        WaveInterface.WriteLine(out, prompt + "shot: ", this.cin_shot);
        WaveInterface.WriteLine(out, prompt + "ymin: ", this.cin_ymin);
        WaveInterface.WriteLine(out, prompt + "ymax: ", this.cin_ymax);
        WaveInterface.WriteLine(out, prompt + "xmin: ", this.cin_xmin);
        WaveInterface.WriteLine(out, prompt + "xmax: ", this.cin_xmax);
        if (this.is_image) {
            WaveInterface.WriteLine(out, prompt + "time_min: ", this.cin_timemin);
            WaveInterface.WriteLine(out, prompt + "time_max: ", this.cin_timemax);
        }
        WaveInterface.WriteLine(out, prompt + "continuous_update: ", this.isContinuousUpdate ? "1" : "0");
        WaveInterface.WriteLine(out, prompt + "title: ", this.cin_title);
        WaveInterface.WriteLine(out, prompt + "global_defaults: ", "" + this.defaults);
        int exp = 0;
        int exp_n = 1;
        while (exp < this.num_waves) {
            WaveInterface.WriteLine(out, prompt + "label_" + exp_n + ": ", this.in_label[exp]);
            WaveInterface.WriteLine(out, prompt + "x_expr_" + exp_n + ": ", MdsWaveInterface.AddNewLineCode(this.in_x[exp]));
            WaveInterface.WriteLine(out, prompt + "y_expr_" + exp_n + ": ", MdsWaveInterface.AddNewLineCode(this.in_y[exp]));
            if (!this.is_image) {
                WaveInterface.WriteLine(out, prompt + "up_error_" + exp_n + ": ", this.in_up_err[exp]);
                WaveInterface.WriteLine(out, prompt + "low_error_" + exp_n + ": ", this.in_low_err[exp]);
                int sht = 0;
                int sht_n = 1;
                while (sht < cnum_shot) {
                    WaveInterface.WriteLine(out, prompt + "mode_1D_" + exp_n + "_" + sht_n + ": ", "" + this.mode1DCodeToString(this.mode1D[exp + sht]));
                    WaveInterface.WriteLine(out, prompt + "mode_2D_" + exp_n + "_" + sht_n + ": ", "" + this.mode2DCodeToString(this.mode2D[exp + sht]));
                    WaveInterface.WriteLine(out, prompt + "color_" + exp_n + "_" + sht_n + ": ", "" + this.colors_idx[exp + sht]);
                    WaveInterface.WriteLine(out, prompt + "marker_" + exp_n + "_" + sht_n + ": ", "" + this.markers[exp + sht]);
                    WaveInterface.WriteLine(out, prompt + "step_marker_" + exp_n + "_" + sht_n + ": ", "" + this.markers_step[exp + sht]);
                    ++sht;
                    ++sht_n;
                }
            }
            exp += eval_shot;
            ++exp_n;
        }
    }

    public String mode1DCodeToString(int code) {
        switch (code) {
            case 0: {
                return "Line";
            }
            case 2: {
                return "Noline";
            }
            case 3: {
                return "Step";
            }
        }
        return "";
    }

    public int mode1DStringToCode(String mode) {
        if (mode.equals("Line")) {
            return 0;
        }
        if (mode.equals("Noline")) {
            return 2;
        }
        if (mode.equals("Step")) {
            return 3;
        }
        return 0;
    }

    public String mode2DCodeToString(int code) {
        switch (code) {
            case 0: {
                return "xz(y)";
            }
            case 1: {
                return "yz(x)";
            }
            case 3: {
                return "Image";
            }
            case 2: {
                return "Contour";
            }
        }
        return "";
    }

    public int mode2DStringToCode(String mode) {
        if (mode.equals("xz(y)")) {
            return 0;
        }
        if (mode.equals("yz(x)")) {
            return 1;
        }
        if (mode.equals("Image")) {
            return 3;
        }
        if (mode.equals("Contour")) {
            return 2;
        }
        return 0;
    }

    public void FromFile(Properties pr, String prompt, ColorMapDialog cmd) throws IOException {
        String prop = null;
        int num_expr = 0;
        int autoDefault = -1;
        this.Erase();
        try {
            String continuousUpdateStr;
            prop = pr.getProperty(prompt + ".height");
            if (prop != null) {
                this.height = Integer.parseInt(prop);
            }
            if ((prop = pr.getProperty(prompt + ".grid_mode")) != null) {
                this.in_grid_mode = Integer.parseInt(prop);
            }
            this.cin_ylabel = pr.getProperty(prompt + ".label");
            if (this.cin_ylabel == null) {
                this.cin_ylabel = pr.getProperty(prompt + ".y_label");
            } else {
                this.cin_ylabel = "\"" + this.cin_ylabel + "\"";
                autoDefault &= 0xFFFFF7FF;
            }
            this.cin_xlabel = pr.getProperty(prompt + ".x_label");
            this.cin_title = pr.getProperty(prompt + ".title");
            if (this.cin_title != null) {
                autoDefault &= 0xFFFEFFFF;
            }
            this.cin_ymin = pr.getProperty(prompt + ".ymin");
            if (this.cin_ymin != null) {
                autoDefault &= 0xFFFFBFFF;
            }
            this.cin_ymax = pr.getProperty(prompt + ".ymax");
            if (this.cin_ymax != null) {
                autoDefault &= 0xFFFF7FFF;
            }
            this.cin_xmin = pr.getProperty(prompt + ".xmin");
            if (this.cin_xmin != null) {
                autoDefault &= 0xFFFFEFFF;
            }
            this.cin_xmax = pr.getProperty(prompt + ".xmax");
            if (this.cin_xmax != null) {
                autoDefault &= 0xFFFFDFFF;
            }
            this.cin_timemin = pr.getProperty(prompt + ".time_min");
            this.cin_timemax = pr.getProperty(prompt + ".time_max");
            this.cin_def_node = pr.getProperty(prompt + ".default_node");
            if (this.cin_def_node != null) {
                autoDefault &= 0xFFFFFDFF;
            }
            this.cin_upd_event = pr.getProperty(prompt + ".event");
            if (this.cin_upd_event != null) {
                autoDefault &= 0xFFFFFFFE;
            }
            this.isContinuousUpdate = (continuousUpdateStr = pr.getProperty(prompt + ".continuous_update")) != null && continuousUpdateStr.trim().equals("1");
            prop = pr.getProperty(prompt + ".x_log");
            if (prop != null) {
                this.x_log = new Boolean(prop);
            }
            if ((prop = pr.getProperty(prompt + ".y_log")) != null) {
                this.y_log = new Boolean(prop);
            }
            if ((prop = pr.getProperty(prompt + ".update_limits")) != null) {
                this.cin_upd_limits = new Boolean(prop);
            }
            if ((prop = pr.getProperty(prompt + ".legend")) != null) {
                this.show_legend = true;
                this.legend_x = Double.valueOf(prop.substring(prop.indexOf("(") + 1, prop.indexOf(",")));
                this.legend_y = Double.valueOf(prop.substring(prop.indexOf(",") + 1, prop.indexOf(")")));
            }
            if ((prop = pr.getProperty(prompt + ".is_image")) != null) {
                this.is_image = new Boolean(prop);
            }
            if ((prop = pr.getProperty(prompt + ".keep_ratio")) != null) {
                this.keep_ratio = new Boolean(prop);
            }
            if ((prop = pr.getProperty(prompt + ".horizontal_flip")) != null) {
                this.horizontal_flip = new Boolean(prop);
            }
            if ((prop = pr.getProperty(prompt + ".vertical_flip")) != null) {
                this.vertical_flip = new Boolean(prop);
            }
            if ((prop = pr.getProperty(prompt + ".palette")) != null) {
                this.colorMap = cmd.getColorMap(prop);
                try {
                    prop = pr.getProperty(prompt + ".bitShift");
                    if (prop != null) {
                        this.colorMap.bitShift = Integer.parseInt(prop);
                    }
                    if ((prop = pr.getProperty(prompt + ".bitClip")) != null) {
                        this.colorMap.bitClip = new Boolean(prop);
                    }
                    if ((prop = pr.getProperty(prompt + ".paletteMax")) != null) {
                        this.colorMap.setMax(Float.parseFloat(prop));
                    }
                    if ((prop = pr.getProperty(prompt + ".paletteMin")) != null) {
                        this.colorMap.setMin(Float.parseFloat(prop));
                    }
                }
                catch (Exception exc) {
                    this.colorMap.bitShift = 0;
                    this.colorMap.bitClip = false;
                    this.colorMap.setMax(Float.MAX_VALUE);
                    this.colorMap.setMin(Float.MIN_VALUE);
                }
            }
            this.cexperiment = pr.getProperty(prompt + ".experiment");
            this.cin_shot = pr.getProperty(prompt + ".shot");
            prop = pr.getProperty(prompt + ".x");
            if (prop != null) {
                String x_str = prop;
                x_str = MdsWaveInterface.RemoveNewLineCode(x_str);
                if (this.in_x == null || this.in_x.length == 0) {
                    this.in_x = new String[1];
                }
                this.in_x[0] = x_str;
            }
            if ((prop = pr.getProperty(prompt + ".y")) != null) {
                StringTokenizer st_y = null;
                StringTokenizer st_x = null;
                this.num_shot = 1;
                String token = null;
                String y_str = prop.toLowerCase();
                String x_str = null;
                y_str = MdsWaveInterface.RemoveNewLineCode(y_str);
                if (this.in_x != null && this.in_x.length != 0) {
                    x_str = this.in_x[0];
                }
                if (y_str.indexOf("[") == 0 && y_str.indexOf("$roprand") != -1) {
                    try {
                        st_y = new StringTokenizer(y_str, "[]");
                        token = st_y.nextToken();
                        st_y = new StringTokenizer(token, ",");
                        while (st_y.hasMoreTokens()) {
                            token = st_y.nextToken().trim();
                            if (token.indexOf("$roprand") != -1) continue;
                            ++num_expr;
                        }
                    }
                    catch (Exception e) {
                        num_expr = 1;
                    }
                } else {
                    num_expr = 1;
                }
                this.num_waves = num_expr * this.num_shot;
                this.CreateVector();
                if (num_expr > 1) {
                    try {
                        st_y = new StringTokenizer(y_str, "[]");
                        String token_y = st_y.nextToken();
                        st_y = new StringTokenizer(token_y, ",");
                        if (x_str != null) {
                            st_x = new StringTokenizer(x_str, "[]");
                            token = st_x.nextToken();
                            st_x = new StringTokenizer(token, ",");
                        }
                        int i = 0;
                        while (st_y.hasMoreTokens()) {
                            token_y = st_y.nextToken().trim();
                            if (st_x != null) {
                                token = st_x.nextToken().trim();
                            }
                            if (token_y.indexOf("$roprand") != -1) continue;
                            this.in_y[i] = token_y;
                            if (st_x != null) {
                                this.in_x[i] = token;
                            }
                            if (this.in_y[i].indexOf("multitrace") != -1) {
                                this.in_y[i] = "compile" + this.in_y[i].substring(this.in_y[i].indexOf("("));
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        num_expr = 1;
                        this.num_waves = num_expr * this.num_shot;
                        this.CreateVector();
                    }
                }
                if (num_expr == 1) {
                    this.in_y[0] = y_str;
                    if (this.in_y[0].indexOf("multitrace") != -1) {
                        this.in_y[0] = "compile" + y_str.substring(y_str.indexOf("("));
                    }
                    this.in_x[0] = x_str != null ? new String(x_str) : null;
                }
            }
            if ((prop = pr.getProperty(prompt + ".num_expr")) != null) {
                num_expr = Integer.parseInt(prop);
            }
            if ((prop = pr.getProperty(prompt + ".num_shot")) != null) {
                this.num_shot = Integer.parseInt(prop);
                int n = this.num_shot = this.num_shot > 0 ? this.num_shot : 1;
                if (num_expr != 0) {
                    this.num_waves = num_expr * this.num_shot;
                    this.CreateVector();
                }
            }
            this.defaults = (prop = pr.getProperty(prompt + ".global_defaults")) != null ? Integer.parseInt(prop) : autoDefault;
            for (int idx = 1; idx <= num_expr; ++idx) {
                prop = pr.getProperty(prompt + ".label_" + idx);
                if (prop != null) {
                    int expr_idx = (idx - 1) * this.num_shot;
                    this.in_label[expr_idx] = prop;
                    for (int j = 1; j < this.num_shot; ++j) {
                        this.in_label[expr_idx + j] = prop;
                    }
                }
                if ((prop = pr.getProperty(prompt + ".x_expr_" + idx)) != null) {
                    int expr_idx = (idx - 1) * this.num_shot;
                    this.in_x[expr_idx] = MdsWaveInterface.RemoveNewLineCode(prop);
                    for (int j = 1; j < this.num_shot; ++j) {
                        this.in_x[expr_idx + j] = this.in_x[expr_idx];
                    }
                }
                if ((prop = pr.getProperty(prompt + ".y_expr_" + idx)) != null) {
                    int expr_idx = (idx - 1) * this.num_shot;
                    this.in_y[expr_idx] = MdsWaveInterface.RemoveNewLineCode(prop);
                    for (int j = 1; j < this.num_shot; ++j) {
                        this.in_y[expr_idx + j] = this.in_y[expr_idx];
                    }
                }
                if ((prop = pr.getProperty(prompt + ".up_error_" + idx)) != null) {
                    int expr_idx = (idx - 1) * this.num_shot;
                    this.in_up_err[expr_idx] = prop;
                    for (int j = 1; j < this.num_shot; ++j) {
                        this.in_up_err[expr_idx + j] = prop;
                    }
                }
                if ((prop = pr.getProperty(prompt + ".in_low_err_" + idx)) != null) {
                    int expr_idx = (idx - 1) * this.num_shot;
                    this.in_low_err[expr_idx] = prop;
                    for (int j = 1; j < this.num_shot; ++j) {
                        this.in_low_err[expr_idx + j] = prop;
                    }
                }
                for (int s = 1; s <= this.num_shot; ++s) {
                    int expr_idx = (idx - 1) * this.num_shot - 1;
                    prop = pr.getProperty(prompt + ".mode_1D_" + idx + "_" + s);
                    if (prop != null) {
                        this.mode1D[expr_idx + s] = this.mode1DStringToCode(prop);
                    }
                    if ((prop = pr.getProperty(prompt + ".mode_2D_" + idx + "_" + s)) != null) {
                        this.mode2D[expr_idx + s] = this.mode2DStringToCode(prop);
                    }
                    if ((prop = pr.getProperty(prompt + ".color_" + idx + "_" + s)) != null) {
                        try {
                            this.colors_idx[expr_idx + s] = Integer.parseInt(prop);
                        }
                        catch (Exception e) {
                            this.colors_idx[expr_idx + s] = 0;
                        }
                    }
                    if ((prop = pr.getProperty(prompt + ".marker_" + idx + "_" + s)) != null) {
                        try {
                            this.markers[expr_idx + s] = Integer.parseInt(prop);
                        }
                        catch (Exception e) {
                            this.markers[expr_idx + s] = 0;
                        }
                    }
                    if ((prop = pr.getProperty(prompt + ".step_marker_" + idx + "_" + s)) == null) continue;
                    try {
                        this.markers_step[expr_idx + s] = Integer.parseInt(prop);
                        continue;
                    }
                    catch (Exception e) {
                        this.markers_step[expr_idx + s] = 0;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e + " \n when parsing " + prop);
        }
    }

    public void mapColorIndex(int[] colorMap) {
        if (colorMap == null) {
            return;
        }
        try {
            for (int i = 0; i < this.colors_idx.length; ++i) {
                this.colors_idx[i] = colorMap[this.colors_idx[i]];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setExperiment(String experiment) {
        super.setExperiment(experiment);
        this.cexperiment = experiment;
        this.defaults &= 0xFFFFFF7F;
    }
}

