/*
 * Decompiled with CFR 0.152.
 */
package mds.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import mds.connection.ConnectionListener;
import mds.connection.UpdateEventListener;
import mds.wave.DataProvider;
import mds.wave.DataServerItem;
import mds.wave.FrameData;
import mds.wave.WaveData;
import mds.wave.WaveDataListener;
import mds.wave.XYData;

public class AsciiDataProvider
implements DataProvider {
    private boolean xPropertiesFile = false;
    String error = null;
    String path_exp = null;
    long curr_shot = -1L;
    float[] y;
    float[] x;

    public static void main(String[] args) {
        try (AsciiDataProvider p = new AsciiDataProvider();){
            p.getWaveData("c:\\test.txt", 0, 0, 0);
        }
    }

    @Override
    public WaveData getWaveData(String in, int row, int col, int index) {
        return new SimpleWaveData(in);
    }

    @Override
    public WaveData getWaveData(String in_y, String in_x, int row, int col, int index) {
        return new SimpleWaveData(in_y, in_x);
    }

    @Override
    public void close() {
    }

    @Override
    public int inquireCredentials(JFrame f, DataServerItem server_item) {
        return 1;
    }

    @Override
    public void setArgument(String arg) {
    }

    @Override
    public boolean supportsTunneling() {
        return false;
    }

    @Override
    public void setEnvironment(String exp) {
        this.error = null;
    }

    @Override
    public void update(String exp, long s) {
        this.error = null;
        this.path_exp = exp;
        this.curr_shot = s;
    }

    @Override
    public String getString(String in, int row, int col, int index) {
        this.error = null;
        return new String(in);
    }

    @Override
    public double getFloat(String in, int row, int col, int index) {
        this.error = null;
        return Double.parseDouble(in);
    }

    @Override
    public long[] getShots(String in, String experiment) throws IOException {
        this.error = null;
        String curr_in = in.trim();
        if (curr_in.startsWith("[", 0)) {
            if (curr_in.endsWith("]")) {
                curr_in = curr_in.substring(1, curr_in.length() - 1);
                StringTokenizer st = new StringTokenizer(curr_in, ",", false);
                long[] result = new long[st.countTokens()];
                int i = 0;
                try {
                    while (st.hasMoreTokens()) {
                        result[i++] = Long.parseLong(st.nextToken());
                    }
                    return result;
                }
                catch (Exception exception) {}
            }
        } else if (curr_in.indexOf(":") != -1) {
            StringTokenizer st = new StringTokenizer(curr_in, ":");
            if (st.countTokens() == 2) {
                try {
                    int start = Integer.parseInt(st.nextToken());
                    int end = Integer.parseInt(st.nextToken());
                    if (end < start) {
                        end = start;
                    }
                    long[] result = new long[end - start + 1];
                    for (int i = 0; i < end - start + 1; ++i) {
                        result[i] = start + i;
                    }
                    return result;
                }
                catch (Exception exception) {}
            }
        } else {
            long[] result = new long[1];
            try {
                result[0] = Long.parseLong(curr_in);
                return result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.error = "Error parsing shot number(s)";
        throw new IOException(this.error);
    }

    @Override
    public String getError() {
        return this.error;
    }

    @Override
    public void addUpdateEventListener(UpdateEventListener l, String event) {
    }

    @Override
    public void removeUpdateEventListener(UpdateEventListener l, String event) {
    }

    @Override
    public void addConnectionListener(ConnectionListener l) {
    }

    @Override
    public void removeConnectionListener(ConnectionListener l) {
    }

    @Override
    public FrameData getFrameData(String in_y, String in_x, float time_min, float time_max) throws IOException {
        throw new IOException("Frames visualization on DemoDataProvider not implemented");
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    class SimpleWaveData
    implements WaveData {
        String file_x;
        String file_y;
        int dimension;
        Properties x_prop = new Properties();
        Properties y_prop = new Properties();

        @Override
        public boolean supportsStreaming() {
            return false;
        }

        public SimpleWaveData(String in_y) {
            this.file_y = this.getPathValue(in_y);
            AsciiDataProvider.this.xPropertiesFile = this.setPropValues(this.file_y, this.y_prop);
            this.x_prop = this.y_prop;
            this.file_x = null;
        }

        public SimpleWaveData(String in_y, String in_x) {
            this.file_y = this.getPathValue(in_y);
            this.file_x = this.getPathValue(in_x);
            AsciiDataProvider.this.xPropertiesFile = this.setPropValues(this.file_x, this.x_prop);
        }

        private String getPathValue(String in) {
            String out = "";
            if (AsciiDataProvider.this.path_exp != null) {
                out = AsciiDataProvider.this.path_exp;
            }
            if (AsciiDataProvider.this.curr_shot > 0L) {
                out = out + File.separatorChar + AsciiDataProvider.this.curr_shot;
            }
            out = out != null && out.length() > 0 ? out + File.separatorChar + in : in;
            return out;
        }

        private int numElement(String val, String separator) {
            StringTokenizer st = new StringTokenizer(val, separator);
            return st.countTokens();
        }

        private boolean isPropertiesFile(Properties prop) {
            String val = prop.getProperty("Time");
            return val != null && this.numElement(val, ",") >= 2;
        }

        private float[] resizeBuffer(float[] b, int size) {
            float[] newB = new float[size];
            System.arraycopy(b, 0, newB, 0, size);
            return newB;
        }

        private void loadSignalValues(String in) throws Exception {
            String ln;
            BufferedReader bufR = new BufferedReader(new FileReader(in));
            while ((ln = bufR.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(ln);
                int numColumn = st.countTokens();
                if (numColumn != 2 || !st.nextToken().equals("Time") || !st.nextToken().equals("Data")) continue;
                AsciiDataProvider.this.x = new float[1000];
                AsciiDataProvider.this.y = new float[1000];
                int count = 0;
                int maxCount = 1000;
                while ((ln = bufR.readLine()) != null) {
                    st = new StringTokenizer(ln);
                    if (count == maxCount) {
                        AsciiDataProvider.this.x = this.resizeBuffer(AsciiDataProvider.this.x, AsciiDataProvider.this.x.length + 1000);
                        AsciiDataProvider.this.y = this.resizeBuffer(AsciiDataProvider.this.y, AsciiDataProvider.this.y.length + 1000);
                        maxCount = AsciiDataProvider.this.y.length;
                    }
                    AsciiDataProvider.this.x[count] = Float.parseFloat(st.nextToken());
                    AsciiDataProvider.this.y[count] = Float.parseFloat(st.nextToken());
                    ++count;
                }
                AsciiDataProvider.this.x = this.resizeBuffer(AsciiDataProvider.this.x, count);
                AsciiDataProvider.this.y = this.resizeBuffer(AsciiDataProvider.this.y, count);
            }
            bufR.close();
            if (AsciiDataProvider.this.x == null || AsciiDataProvider.this.y == null) {
                throw new Exception("No data in file or file syntax error");
            }
        }

        private boolean setPropValues(String in, Properties prop) {
            boolean propertiesFile = false;
            try {
                prop.load(new FileInputStream(in));
                propertiesFile = this.isPropertiesFile(prop);
                if (!propertiesFile) {
                    this.loadSignalValues(in);
                }
            }
            catch (Exception exc) {
                AsciiDataProvider.this.error = "File " + in + " error : " + exc.getMessage();
            }
            return false;
        }

        @Override
        public int getNumDimension() throws IOException {
            try {
                this.dimension = Integer.parseInt(this.y_prop.getProperty("Dimension"));
                return this.dimension;
            }
            catch (NumberFormatException exc) {
                this.dimension = 1;
                return 1;
            }
        }

        private float[] GetFloatData() throws IOException {
            if (AsciiDataProvider.this.xPropertiesFile) {
                return this.decodeValues(this.x_prop.getProperty("Data"));
            }
            if (AsciiDataProvider.this.y == null) {
                throw new IOException(AsciiDataProvider.this.error);
            }
            return AsciiDataProvider.this.y;
        }

        private double[] GetXDoubleData() {
            return null;
        }

        private float[] decodeValues(String val) {
            if (val == null) {
                AsciiDataProvider.this.error = "File syntax error";
                return null;
            }
            StringTokenizer st = new StringTokenizer(val, ",");
            int num = st.countTokens();
            float[] out = new float[num];
            int i = 0;
            try {
                while (st.hasMoreElements()) {
                    String d_st = st.nextToken().trim();
                    out[i++] = Float.parseFloat(d_st);
                }
            }
            catch (NumberFormatException exc) {
                AsciiDataProvider.this.error = "File syntax error : " + exc.getMessage();
                out = null;
            }
            return out;
        }

        @Override
        public String GetTitle() throws IOException {
            return this.y_prop.getProperty("Title");
        }

        @Override
        public String GetXLabel() throws IOException {
            if (this.file_x == null) {
                return this.y_prop.getProperty("XLabel");
            }
            return this.x_prop.getProperty("YLabel");
        }

        @Override
        public String GetYLabel() throws IOException {
            return this.y_prop.getProperty("YLabel");
        }

        @Override
        public String GetZLabel() throws IOException {
            return this.y_prop.getProperty("ZLabel");
        }

        @Override
        public XYData getData(long xmin, long xmax, int numPoints) throws IOException {
            double[] x = this.GetXDoubleData();
            float[] y = this.GetFloatData();
            return new XYData(x, y, Double.MAX_VALUE);
        }

        @Override
        public XYData getData(double xmin, double xmax, int numPoints) throws IOException {
            double[] x = this.GetXDoubleData();
            float[] y = this.GetFloatData();
            return new XYData(x, y, Double.MAX_VALUE);
        }

        @Override
        public XYData getData(int numPoints) throws IOException {
            double[] x = this.GetXDoubleData();
            float[] y = this.GetFloatData();
            return new XYData(x, y, Double.MAX_VALUE);
        }

        @Override
        public float[] getZ() {
            System.out.println("BADABUM!!");
            return null;
        }

        @Override
        public double[] getX2D() {
            System.out.println("BADABUM!!");
            return null;
        }

        @Override
        public long[] getX2DLong() {
            System.out.println("BADABUM!!");
            return null;
        }

        @Override
        public float[] getY2D() {
            System.out.println("BADABUM!!");
            return null;
        }

        @Override
        public boolean isXLong() {
            return false;
        }

        @Override
        public void addWaveDataListener(WaveDataListener listener) {
        }

        @Override
        public void removeWaveDataListener(WaveDataListener listener) {
        }

        @Override
        public void getDataAsync(double lowerBound, double upperBound, int numPoints) {
        }
    }
}

