/*
 * Decompiled with CFR 0.152.
 */
package mds.provider;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import mds.provider.MdsDataProvider;
import mds.wave.DataServerItem;
import mds.wave.WaveData;
import mds.wave.WaveDataListener;
import mds.wave.XYData;

public class AsdexDataProvider
extends MdsDataProvider {
    public AsdexDataProvider() {
    }

    public AsdexDataProvider(String provider) throws IOException {
        super(provider);
    }

    @Override
    public void setArgument(String arg) throws IOException {
        this.mds.setProvider(arg);
        this.mds.setUser("mdsplus");
    }

    @Override
    public synchronized void update(String exp, long s) {
        this.error = null;
        this.shot = s;
    }

    private String ParseExpression(String in) {
        String res;
        if (in.startsWith("DIM_OF(")) {
            return in;
        }
        StringTokenizer st = new StringTokenizer(in, ":");
        try {
            String diag = st.nextToken();
            String name = st.nextToken();
            res = "augsignal(" + this.shot + ",\"" + diag + "\",\"" + name + "\")";
        }
        catch (Exception e) {
            this.error = "Wrong signal format: must be <diagnostic>:<signal>";
            return null;
        }
        System.out.println(res);
        return res;
    }

    @Override
    public synchronized int[] getIntArray(String in) throws IOException {
        return super.getIntArray(this.ParseExpression(in));
    }

    public WaveData GetWaveData(String in) {
        return new SimpleWaveData(in);
    }

    @Override
    public synchronized float[] GetFloatArray(String in) throws IOException {
        String parsed = in;
        if (parsed == null) {
            return null;
        }
        this.error = null;
        float[] out_array = super.GetFloatArray(parsed);
        if (out_array == null && this.error == null) {
            this.error = "Cannot evaluate " + in + " for shot " + this.shot;
        }
        if (out_array != null && out_array.length <= 1) {
            this.error = "Cannot evaluate " + in + " for shot " + this.shot;
            return null;
        }
        return out_array;
    }

    @Override
    public boolean SupportsCompression() {
        return false;
    }

    @Override
    public void SetCompression(boolean state) {
    }

    @Override
    public int inquireCredentials(JFrame f, DataServerItem server_item) {
        return 1;
    }

    @Override
    public int[] getNumDimensions(String spec) {
        return new int[]{1};
    }

    class SimpleWaveData
    implements WaveData {
        String in_x;
        String in_y;
        float xmax;
        float xmin;
        int n_points;
        boolean resample = false;
        boolean _jscope_set = false;
        int v_idx;
        MdsDataProvider.RealArray currXData = null;

        @Override
        public boolean supportsStreaming() {
            return false;
        }

        public SimpleWaveData(String in_y) {
            this.in_y = in_y;
            this.v_idx = AsdexDataProvider.this.var_idx;
        }

        public SimpleWaveData(String in_y, String in_x) {
            this.in_y = in_y;
            this.in_x = in_x;
            this.v_idx = AsdexDataProvider.this.var_idx;
        }

        public SimpleWaveData(String in_y, float xmin, float xmax, int n_points) {
            this.resample = true;
            this.in_y = in_y;
            this.xmin = xmin;
            this.xmax = xmax;
            this.n_points = n_points;
            this.v_idx = AsdexDataProvider.this.var_idx;
        }

        public SimpleWaveData(String in_y, String in_x, float xmin, float xmax, int n_points) {
            this.resample = true;
            this.in_y = in_y;
            this.in_x = in_x;
            this.xmin = xmin;
            this.xmax = xmax;
            this.n_points = n_points;
            this.v_idx = AsdexDataProvider.this.var_idx;
        }

        @Override
        public int getNumDimension() throws IOException {
            String expr;
            if (this._jscope_set) {
                expr = "shape(_jscope_" + this.v_idx + ")";
            } else {
                this._jscope_set = true;
                expr = "( _jscope_" + this.v_idx + " = (" + this.in_y + "), shape(_jscope_" + this.v_idx + "))";
                ++AsdexDataProvider.this.var_idx;
            }
            int[] shape = AsdexDataProvider.this.getNumDimensions(expr);
            if (AsdexDataProvider.this.error != null) {
                this._jscope_set = false;
                AsdexDataProvider.this.error = null;
                return 1;
            }
            return shape.length;
        }

        public float[] GetFloatData() throws IOException {
            String in_y = AsdexDataProvider.this.ParseExpression(this.in_y);
            String in_y_expr = "_jscope_" + this.v_idx;
            String set_tdivar = "";
            if (!this._jscope_set) {
                this._jscope_set = true;
                set_tdivar = "_jscope_" + this.v_idx + " = (" + in_y + "), ";
                ++AsdexDataProvider.this.var_idx;
            }
            if (this.resample && this.in_x == null) {
                String limits = "FLOAT(" + this.xmin + "), FLOAT(" + this.xmax + ")";
                String resampledExpr = "JavaResample(FLOAT(" + in_y_expr + "), FLOAT(DIM_OF(" + in_y_expr + ")), " + limits + ")";
                set_tdivar = "_jscope_" + this.v_idx + " = (" + resampledExpr + "), ";
                String expr = set_tdivar + "fs_float(_jscope_" + this.v_idx + ")";
                return AsdexDataProvider.this.GetFloatArray(expr);
            }
            return AsdexDataProvider.this.GetFloatArray(set_tdivar + "fs_float(" + in_y_expr + ")");
        }

        private double[] encodeTimeBase(String expr) {
            try {
                int[] startIdx = AsdexDataProvider.this.getIntArray("begin_of(window_of(dim_of(" + expr + ")))");
                int[] endIdx = AsdexDataProvider.this.getIntArray("end_of(window_of(dim_of(" + expr + ")))");
                if (startIdx.length != 1 || endIdx.length != 1) {
                    return null;
                }
                int numPoint = endIdx[0] - startIdx[0] + 1;
                double[] delta = AsdexDataProvider.this.GetDoubleArray("slope_of(axis_of(dim_of(" + expr + ")))");
                double[] begin = null;
                double[] end = null;
                double[] firstTime = AsdexDataProvider.this.GetDoubleArray("i_to_x(dim_of(" + expr + ")," + startIdx[0] + ")");
                try {
                    begin = AsdexDataProvider.this.GetDoubleArray("begin_of(axis_of(dim_of(" + expr + ")))");
                    end = AsdexDataProvider.this.GetDoubleArray("end_of(axis_of(dim_of(" + expr + ")))");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (delta.length == 1 && numPoint > 1) {
                    double[] out = new double[numPoint];
                    int j = 0;
                    int i = 0;
                    double curr = firstTime[0];
                    while (i < numPoint) {
                        out[i] = curr + (double)j * delta[0];
                        ++i;
                        ++j;
                    }
                    return out;
                }
                if (delta.length > 1 && numPoint > 1) {
                    double[] out = new double[numPoint];
                    int j = 0;
                    int i = 0;
                    int idx = 0;
                    double curr = firstTime[0];
                    while (i < numPoint) {
                        out[i] = curr + (double)j * delta[idx];
                        if (out[i] > end[idx]) {
                            out[i] = end[idx];
                            curr = begin[++idx];
                            j = 0;
                        }
                        ++i;
                        ++j;
                    }
                    return out;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public double[] GetXDoubleData() {
            try {
                if (this.currXData == null) {
                    this.currXData = this.GetXRealData();
                }
                if (!this.currXData.isDouble()) {
                    return null;
                }
                return this.currXData.getDoubleArray();
            }
            catch (Exception exc) {
                return null;
            }
        }

        public long[] GetXLongData() {
            try {
                if (this.currXData == null) {
                    this.currXData = this.GetXRealData();
                }
                if (!this.currXData.isLong()) {
                    return null;
                }
                return this.currXData.getLongArray();
            }
            catch (Exception exc) {
                return null;
            }
        }

        public float[] GetXData() {
            try {
                if (this.currXData == null) {
                    this.currXData = this.GetXRealData();
                }
                return this.currXData.getFloatArray();
            }
            catch (Exception exc) {
                return null;
            }
        }

        MdsDataProvider.RealArray GetXRealData() throws IOException {
            String expr = null;
            double[] tBaseOut = null;
            if (this.in_x == null) {
                if (this._jscope_set) {
                    expr = "dim_of(_jscope_" + this.v_idx + ")";
                    tBaseOut = this.encodeTimeBase("_jscope_" + this.v_idx);
                } else {
                    this._jscope_set = true;
                    String in_y_expr = "_jscope_" + this.v_idx;
                    String set_tdivar = "( _jscope_" + this.v_idx + " = (" + this.in_y + "), ";
                    ++AsdexDataProvider.this.var_idx;
                    if (this.resample) {
                        String limits = "FLOAT(" + this.xmin + "), FLOAT(" + this.xmax + ")";
                        expr = set_tdivar + "JavaResample(FLOAT(" + in_y_expr + "), FLOAT(DIM_OF(" + in_y_expr + ")), " + limits + ")";
                    } else {
                        expr = set_tdivar + "dim_of(" + in_y_expr + ")";
                        tBaseOut = this.encodeTimeBase(this.in_y);
                    }
                }
                if (tBaseOut != null) {
                    return new MdsDataProvider.RealArray(tBaseOut);
                }
                return AsdexDataProvider.this.GetRealArray(expr);
            }
            return AsdexDataProvider.this.GetRealArray(this.in_x);
        }

        public float[] GetYData() throws IOException {
            String expr;
            if (this._jscope_set) {
                expr = "dim_of(_jscope_" + this.v_idx + ", 1)";
            } else {
                this._jscope_set = true;
                expr = "( _jscope_" + this.v_idx + " = (" + this.in_y + "), dim_of(_jscope_" + this.v_idx + ", 1))";
                ++AsdexDataProvider.this.var_idx;
            }
            return AsdexDataProvider.this.GetFloatArray(expr);
        }

        @Override
        public String GetTitle() throws IOException {
            String expr;
            if (this._jscope_set) {
                expr = "help_of(_jscope_" + this.v_idx + ")";
            } else {
                this._jscope_set = true;
                expr = "( _jscope_" + this.v_idx + " = (" + this.in_y + "), help_of(_jscope_" + this.v_idx + "))";
                ++AsdexDataProvider.this.var_idx;
            }
            String out = AsdexDataProvider.this.getStringValue(expr);
            if (out == null) {
                this._jscope_set = false;
            }
            return out;
        }

        @Override
        public String GetXLabel() throws IOException {
            String out = null;
            if (this.in_x == null || this.in_x.length() == 0) {
                String expr;
                if (this._jscope_set) {
                    expr = "Units(dim_of(_jscope_" + this.v_idx + ", 1))";
                } else {
                    this._jscope_set = true;
                    expr = "( _jscope_" + this.v_idx + " = (" + this.in_y + "), Units(dim_of(_jscope_" + this.v_idx + ", 1)))";
                    ++AsdexDataProvider.this.var_idx;
                }
                out = AsdexDataProvider.this.getStringValue(expr);
            } else {
                out = AsdexDataProvider.this.getStringValue("Units(" + this.in_x + ")");
            }
            if (out == null) {
                this._jscope_set = false;
            }
            return out;
        }

        @Override
        public String GetYLabel() throws IOException {
            String expr;
            if (this._jscope_set) {
                expr = "Units(_jscope_" + this.v_idx + ")";
            } else {
                this._jscope_set = true;
                expr = "( _jscope_" + this.v_idx + " = (" + this.in_y + "), Units(_jscope_" + this.v_idx + "))";
                ++AsdexDataProvider.this.var_idx;
            }
            String out = AsdexDataProvider.this.getStringValue(expr);
            if (out == null) {
                this._jscope_set = false;
            }
            return out;
        }

        @Override
        public String GetZLabel() throws IOException {
            String expr;
            if (this._jscope_set) {
                expr = "Units(dim_of(_jscope_" + this.v_idx + ", 1))";
            } else {
                this._jscope_set = true;
                expr = "( _jscope_" + this.v_idx + " = (" + this.in_y + "), Units(dim_of(_jscope_" + this.v_idx + ", 1)))";
                ++AsdexDataProvider.this.var_idx;
            }
            String out = AsdexDataProvider.this.getStringValue(expr);
            if (out == null) {
                this._jscope_set = false;
            }
            return out;
        }

        @Override
        public XYData getData(long xmin, long xmax, int numPoints) throws IOException {
            double[] x = this.GetXDoubleData();
            float[] y = this.GetFloatData();
            return new XYData(x, y, Double.MAX_VALUE);
        }

        @Override
        public XYData getData(double xmin, double xmax, int numPoints) throws IOException {
            double[] x = this.GetXDoubleData();
            float[] y = this.GetFloatData();
            return new XYData(x, y, Double.MAX_VALUE);
        }

        @Override
        public XYData getData(int numPoints) throws IOException {
            double[] x = this.GetXDoubleData();
            float[] y = this.GetFloatData();
            return new XYData(x, y, Double.MAX_VALUE);
        }

        @Override
        public float[] getZ() {
            System.out.println("BADABUM!!");
            return null;
        }

        @Override
        public double[] getX2D() {
            System.out.println("BADABUM!!");
            return null;
        }

        @Override
        public long[] getX2DLong() {
            System.out.println("BADABUM!!");
            return null;
        }

        @Override
        public float[] getY2D() {
            System.out.println("BADABUM!!");
            return null;
        }

        public double[] getXLimits() {
            System.out.println("BADABUM!!");
            return null;
        }

        public long[] getXLong() {
            System.out.println("BADABUM!!");
            return null;
        }

        @Override
        public boolean isXLong() {
            return false;
        }

        @Override
        public void addWaveDataListener(WaveDataListener listener) {
        }

        @Override
        public void removeWaveDataListener(WaveDataListener listener) {
        }

        @Override
        public void getDataAsync(double lowerBound, double upperBound, int numPoints) {
        }
    }
}

