/*
 * Decompiled with CFR 0.152.
 */
package mds.provider.browser;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import mds.jscope.jScopeBrowseSignals;

public class TwuBrowseSignals
extends jScopeBrowseSignals {
    private static final long serialVersionUID = 3L;
    String path;
    String shot = null;
    String tree = null;
    String server_url;

    @Override
    protected String getSignal(String url_name) {
        String sig_path = null;
        boolean is_image = this.mime_type != null && this.mime_type.indexOf("image") != -1;
        try {
            if (is_image) {
                sig_path = url_name;
            } else {
                BufferedReader br = new BufferedReader(new StringReader(this.html.getText()));
                while (sig_path == null) {
                    try {
                        String curr_line = br.readLine();
                        if (!curr_line.startsWith("SignalURL")) continue;
                        sig_path = curr_line.substring(curr_line.indexOf("http:"));
                    }
                    catch (Exception exc) {
                        JOptionPane.showMessageDialog(this, "Error reading URL " + url_name + " : Missing \"SignalURL\" property", "alert", 0);
                        return null;
                    }
                }
                if (sig_path != null) {
                    StringTokenizer st = new StringTokenizer(sig_path, "/");
                    st.nextToken();
                    this.server_url = st.nextToken();
                    this.tree = st.nextToken();
                    String group = st.nextToken();
                    this.shot = st.nextToken();
                    if (TwuBrowseSignals.reasonableShotNr(this.shot)) {
                        sig_path = "//" + this.server_url + "/" + this.tree + "/" + group + "/#####" + st.nextToken("");
                    } else {
                        this.shot = null;
                    }
                }
            }
        }
        catch (Exception exc) {
            sig_path = null;
        }
        return sig_path;
    }

    @Override
    protected String getTree() {
        return this.tree == null ? "" : this.tree;
    }

    @Override
    protected String getShot() {
        return this.shot == null ? "0" : this.shot;
    }

    @Override
    protected String getServerAddr() {
        return this.server_url;
    }

    private static boolean reasonableShotNr(String shot) {
        try {
            Integer.parseInt(shot);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

