/*
 * Decompiled with CFR 0.152.
 */
package mds.provider.mds;

import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.OpenSSHConfig;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public final class SshTunneling
implements AutoCloseable {
    private static final UserInfo userinfo;
    private static final File dotssh;
    private static JSch jsch;
    final Session session;
    final SshTunneling proxy;
    final String proxyjump;
    final String user;
    final String hostname;
    final ConfigRepository.Config config;
    final int port;

    private static final ConfigRepository getConfigRepository() {
        File config = new File(dotssh, "config");
        if (config.exists()) {
            try {
                return OpenSSHConfig.parseFile((String)config.getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return OpenSSHConfig.nullConfig;
    }

    private static SshTunneling parse(String serverstring, ConfigRepository cr) throws JSchException {
        int at = serverstring.indexOf("@");
        int cn = serverstring.indexOf(":");
        String user = at < 0 ? null : serverstring.substring(0, at);
        String host = cn < 0 ? serverstring.substring(at + 1).toLowerCase() : serverstring.substring(at + 1, cn).toLowerCase();
        int port = cn < 0 ? 0 : Integer.parseInt(serverstring.substring(cn + 1));
        return new SshTunneling(user, host, port, cr);
    }

    private SshTunneling(String user, String host, int port, ConfigRepository cr) throws JSchException {
        int pport;
        this.config = cr.getConfig(host);
        String hostname = this.config.getHostname();
        String string = this.hostname = hostname != null ? hostname : host;
        if (user != null) {
            this.user = user;
        } else {
            String cuser = this.config.getUser();
            String string2 = this.user = cuser != null ? cuser : System.getProperty("user.name");
        }
        this.port = port != 0 ? port : ((pport = this.config.getPort()) > 0 ? pport : 22);
        this.proxyjump = this.config.getValue("ProxyJump");
        this.proxy = this.proxyjump == null ? null : SshTunneling.parse(this.proxyjump, cr);
        this.session = this.connect(10000);
    }

    public SshTunneling(String user, String host, int lport, int rport) throws JSchException {
        this(user, host, 22, SshTunneling.getConfigRepository());
        this.session.setPortForwardingL(lport, "127.0.0.1", rport);
    }

    private Session connect(int timeout) throws JSchException {
        Session session;
        if (this.proxy != null) {
            session = this.proxy.connect(timeout);
            int pport = session.setPortForwardingL(0, this.hostname, this.port);
            session = jsch.getSession(this.user, "127.0.0.1", pport);
        } else {
            session = jsch.getSession(this.user, this.hostname, 22);
        }
        String strictHostKeyChecking = this.config.getValue("StrictHostKeyChecking");
        if (strictHostKeyChecking != null) {
            session.setConfig("StrictHostKeyChecking", strictHostKeyChecking);
        }
        session.setUserInfo((com.jcraft.jsch.UserInfo)userinfo);
        SshTunneling.userinfo.tried_pw = false;
        session.connect(timeout);
        return session;
    }

    @Override
    public void close() {
        this.session.disconnect();
        if (this.proxy != null) {
            this.proxy.close();
        }
    }

    static {
        JSch _jsch;
        dotssh = new File(System.getProperty("user.home"), ".ssh");
        try {
            _jsch = new JSch();
            File known_hosts = new File(dotssh, "known_hosts");
            File id_rsa = new File(dotssh, "id_rsa");
            if (!dotssh.exists()) {
                dotssh.mkdirs();
            }
            if (known_hosts.exists()) {
                try {
                    _jsch.setKnownHosts(known_hosts.getAbsolutePath());
                }
                catch (JSchException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    known_hosts.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (id_rsa.exists()) {
                try {
                    _jsch.addIdentity(id_rsa.getAbsolutePath());
                }
                catch (JSchException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error loading JSch, no ssh support!");
            _jsch = null;
        }
        jsch = _jsch;
        UserInfo _userinfo = null;
        try {
            _userinfo = new UserInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        userinfo = _userinfo;
    }

    public static final class UserInfo
    implements com.jcraft.jsch.UserInfo,
    UIKeyboardInteractive {
        static HashMap<String, String[]> keyboard_ans = new HashMap();
        static HashMap<String, UserInfo> keyboard_this = new HashMap();
        private final JTextField passphraseField = new JPasswordField(20);
        private final JTextField passwordField = new JPasswordField(20);
        private final AncestorListener RequestFocusListener = new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent e) {
                JComponent component = (JComponent)e.getSource();
                component.grabFocus();
                Window win = (Window)component.getTopLevelAncestor();
                win.setAlwaysOnTop(true);
            }

            @Override
            public void ancestorMoved(AncestorEvent arg0) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent arg0) {
            }
        };
        public boolean tried_pw = false;

        public UserInfo() {
            this.passphraseField.addAncestorListener(this.RequestFocusListener);
            this.passwordField.addAncestorListener(this.RequestFocusListener);
        }

        public final String getPassphrase() {
            return this.passphraseField.getText();
        }

        public final String getPassword() {
            return this.passwordField.getText();
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            int result;
            UserInfo old = keyboard_this.putIfAbsent(destination, this);
            if (old != null && !this.equals(old)) {
                return (String[])keyboard_ans.get(destination).clone();
            }
            Object[] ob = new Object[prompt.length * 2 + 2];
            ob[0] = name;
            ob[1] = instruction;
            for (int i = 0; i < prompt.length; ++i) {
                ob[i * 2 + 2] = prompt[i];
                ob[i * 2 + 3] = echo[i] ? new JTextField(20) : new JPasswordField(20);
            }
            if (prompt.length > 0) {
                ((JTextField)ob[3]).addAncestorListener(this.RequestFocusListener);
            }
            if ((result = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), ob, destination, 2, -1)) != 0) {
                return null;
            }
            String[] ans = new String[prompt.length];
            for (int i = 0; i < prompt.length; ++i) {
                ans[i] = ((JTextField)ob[i * 2 + 3]).getText();
            }
            keyboard_ans.put(destination, (String[])ans.clone());
            keyboard_this.put(destination, this);
            return ans;
        }

        public final boolean promptPassphrase(String message) {
            if (!this.passphraseField.getText().isEmpty() && !this.tried_pw) {
                this.tried_pw = true;
                return true;
            }
            Object[] ob = new Object[]{message, this.passphraseField};
            int result = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), ob, message, 2, -1);
            if (result == 0) {
                return true;
            }
            this.passphraseField.setText(null);
            return false;
        }

        public final boolean promptPassword(String message) {
            if (!this.passwordField.getText().isEmpty() && !this.tried_pw) {
                this.tried_pw = true;
                return true;
            }
            Object[] ob = new Object[]{message, this.passwordField};
            int result = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), ob, message, 2, -1);
            if (result == 0) {
                return true;
            }
            this.passwordField.setText(null);
            return false;
        }

        public final boolean promptYesNo(String str) {
            Object[] options = new Object[]{"yes", "no"};
            int foo = JOptionPane.showOptionDialog(JOptionPane.getRootFrame(), str, "Warning", -1, 2, null, options, options[0]);
            return foo == 0;
        }

        public final void showMessage(String message) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), message);
        }
    }
}

