/*
 * Decompiled with CFR 0.152.
 */
package mds.wave;

import java.awt.Color;
import java.awt.image.IndexColorModel;

public class ColorMap {
    float[] pR;
    float[] pG;
    float[] pB;
    float[] vR;
    float[] vG;
    float[] vB;
    float min;
    float max;
    int numColors = 0;
    Color[] colors;
    public String name = "unnamed";
    IndexColorModel indexColorModel = null;
    byte[] r = new byte[256];
    byte[] g = new byte[256];
    byte[] b = new byte[256];
    public int bitShift = 0;
    public boolean bitClip = false;

    ColorMap() {
        this.name = "Green scale";
        this.numColors = 256;
        this.colors = new Color[256];
        for (int i = 0; i < this.numColors; ++i) {
            this.r[i] = (byte)(0xFF & i);
            this.g[i] = (byte)(0xFF & i);
            this.b[i] = (byte)(0xFF & i);
            this.colors[i] = new Color(i, i, i);
        }
    }

    public String toString() {
        return this.name;
    }

    ColorMap(String name, int[] r, int[] g, int[] b) {
        this.name = name;
        this.numColors = 256;
        this.colors = new Color[256];
        for (int i = 0; i < this.numColors; ++i) {
            this.r[i] = (byte)(0xFF & r[i]);
            this.g[i] = (byte)(0xFF & g[i]);
            this.b[i] = (byte)(0xFF & b[i]);
            this.colors[i] = new Color(r[i], g[i], b[i]);
        }
    }

    ColorMap(int numColors, float min, float max) {
    }

    public void createColorMap(int numColors, int numPoints, float min, float max) {
        this.max = max;
        this.min = min;
        this.numColors = numColors;
        float delta = max - min;
        this.pR = new float[5];
        this.pR[0] = min;
        this.pR[1] = min + delta * 0.2f;
        this.pR[2] = min + delta * 0.6f;
        this.pR[3] = min + delta * 0.8f;
        this.pR[4] = min + delta * 1.0f;
        this.vR = new float[5];
        this.vR[0] = 255.0f;
        this.vR[1] = 0.0f;
        this.vR[2] = 0.0f;
        this.vR[3] = 255.0f;
        this.vR[4] = 255.0f;
        this.pG = new float[5];
        this.pG[0] = min;
        this.pG[1] = min + delta * 0.2f;
        this.pG[2] = min + delta * 0.4f;
        this.pG[3] = min + delta * 0.8f;
        this.pG[4] = min + delta * 1.0f;
        this.vG = new float[5];
        this.vG[0] = 0.0f;
        this.vG[1] = 0.0f;
        this.vG[2] = 255.0f;
        this.vG[3] = 255.0f;
        this.vG[4] = 0.0f;
        this.pB = new float[4];
        this.pB[0] = min;
        this.pB[1] = min + delta * 0.4f;
        this.pB[2] = min + delta * 0.6f;
        this.pB[3] = min + delta * 1.0f;
        this.vB = new float[4];
        this.vB[0] = 255.0f;
        this.vB[1] = 255.0f;
        this.vB[2] = 0.0f;
        this.vB[3] = 0.0f;
        this.computeColorMap();
    }

    public float[] getRedValues() {
        return this.vR;
    }

    public float[] getRedPoints() {
        return this.pR;
    }

    public float[] getGreenValues() {
        return this.vG;
    }

    public float[] getGreenPoints() {
        return this.pG;
    }

    public float[] getBlueValues() {
        return this.vB;
    }

    public float[] getBluePoints() {
        return this.pB;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public void setRedParam(float[] p, float[] v) {
        this.pR = p;
        this.vR = v;
        int[] r = this.getValues(this.numColors, p, v);
        for (int i = 0; i < this.numColors; ++i) {
            this.colors[i] = new Color(r[i], this.colors[i].getGreen(), this.colors[i].getBlue());
        }
    }

    public void setGreenParam(float[] p, float[] v) {
        this.pG = p;
        this.vG = v;
        int[] g = this.getValues(this.numColors, p, v);
        for (int i = 0; i < this.numColors; ++i) {
            this.colors[i] = new Color(this.colors[i].getRed(), g[i], this.colors[i].getBlue());
        }
    }

    public void setBlueParam(float[] p, float[] v) {
        this.pB = p;
        this.vB = v;
        int[] b = this.getValues(this.numColors, p, v);
        for (int i = 0; i < this.numColors; ++i) {
            this.colors[i] = new Color(this.colors[i].getRed(), this.colors[i].getGreen(), b[i]);
        }
    }

    public void computeColorMap() {
        this.colors = new Color[this.numColors];
        int[] r = this.getValues(this.numColors, this.pR, this.vR);
        int[] g = this.getValues(this.numColors, this.pG, this.vG);
        int[] b = this.getValues(this.numColors, this.pB, this.vB);
        for (int i = 0; i < this.numColors; ++i) {
            this.colors[i] = new Color(r[i], g[i], b[i]);
        }
    }

    public byte[] getRedIntValues() {
        byte[] b = new byte[this.numColors];
        int[] c = this.getValues(this.numColors, this.pR, this.vR);
        for (int i = 0; i < this.numColors; ++i) {
            b[i] = (byte)c[i];
        }
        return b;
    }

    public byte[] getGreenIntValues() {
        byte[] b = new byte[this.numColors];
        int[] c = this.getValues(this.numColors, this.pG, this.vG);
        for (int i = 0; i < this.numColors; ++i) {
            b[i] = (byte)c[i];
        }
        return b;
    }

    public byte[] getBlueIntValues() {
        byte[] b = new byte[this.numColors];
        int[] c = this.getValues(this.numColors, this.pB, this.vB);
        for (int i = 0; i < this.numColors; ++i) {
            b[i] = (byte)c[i];
        }
        return b;
    }

    public Color getColor(float val, float min, float max) {
        int idx = (int)((val - min) / (max - min) * (float)(this.numColors - 1));
        return this.colors[idx];
    }

    public Color getColor(float val) {
        if (val < this.min) {
            return this.colors[0];
        }
        if (val > this.max) {
            return this.colors[this.colors.length - 1];
        }
        int idx = (int)((val - this.max) / (this.max - this.min) + 1.0f) * (this.colors.length - 1);
        return this.colors[idx];
    }

    public Color[] getColors() {
        return this.colors;
    }

    public IndexColorModel getIndexColorModel(int numBit) {
        this.indexColorModel = new IndexColorModel(numBit, this.numColors, this.r, this.g, this.b);
        return this.indexColorModel;
    }

    private int[] getValues(int nVal, float[] p, float[] v) {
        int[] out = new int[nVal];
        float dx = (p[p.length - 1] - p[0]) / (float)(nVal - 1);
        float val = 0.0f;
        int idx = 0;
        float c1 = (v[0] - v[1]) / (p[0] - p[1]);
        for (int i = 0; i < nVal; ++i) {
            if (p[idx] == p[idx + 1]) {
                ++idx;
                --i;
            } else {
                val = (float)i * dx;
                if (val > p[idx + 1]) {
                    ++idx;
                    --i;
                } else {
                    out[i] = (int)(c1 * val - p[idx] * c1 + v[idx]);
                    if (out[i] > 255) {
                        out[i] = 255;
                    } else if (out[i] < 0) {
                        out[i] = 0;
                    }
                }
            }
            c1 = (v[idx] - v[idx + 1]) / (p[idx] - p[idx + 1]);
        }
        return out;
    }
}

