/*
 * Decompiled with CFR 0.152.
 */
package mds.wave;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mds.connection.MdsConnection;
import mds.wave.ColorMap;
import mds.wave.Waveform;

public class ColorMapDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final Vector<ActionListener> colorMapListener = new Vector();
    ColorMap colorMap;
    ColorPalette cp;
    JComboBox<ColorMap> cmComboBox;
    JTextField minVal;
    JTextField maxVal;
    JButton ok;
    JButton apply;
    JButton cancel;
    JSlider shiftSlider;
    JCheckBox bitClip;
    JPanel bitOptionPanel;
    boolean is16BitImage = false;
    Waveform wave = null;
    String[] nameColorTables;
    byte[] colorTables;
    private static String lastMap = null;

    public ColorMapDialog(Frame f, String colorPaletteFile) {
        super(f, "Color Palette");
        this.readColorPalette(colorPaletteFile);
        this.getContentPane().setLayout(new GridLayout(4, 1));
        JPanel pan1 = new JPanel();
        pan1.setLayout(new GridLayout(2, 1));
        JPanel pan2 = new JPanel();
        JPanel pan3 = new JPanel();
        pan2.add(new JLabel("MIN : "));
        this.minVal = new JTextField(6);
        pan2.add(this.minVal);
        this.minVal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                float max;
                float min;
                try {
                    min = Float.parseFloat(ColorMapDialog.this.minVal.getText().trim());
                }
                catch (Exception exc) {
                    min = Float.MIN_VALUE;
                }
                try {
                    max = Float.parseFloat(ColorMapDialog.this.maxVal.getText().trim());
                }
                catch (Exception exc) {
                    max = Float.MAX_VALUE;
                }
                ColorMapDialog.this.wave.setFrameMinMax(min, max);
            }
        });
        pan2.add(new JLabel("MAX : "));
        this.maxVal = new JTextField(6);
        pan2.add(this.maxVal);
        this.maxVal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                float max;
                float min;
                try {
                    min = Float.parseFloat(ColorMapDialog.this.minVal.getText().trim());
                }
                catch (Exception exc) {
                    min = Float.MIN_VALUE;
                }
                try {
                    max = Float.parseFloat(ColorMapDialog.this.maxVal.getText().trim());
                }
                catch (Exception exc) {
                    max = Float.MAX_VALUE;
                }
                ColorMapDialog.this.wave.setFrameMinMax(min, max);
            }
        });
        this.cmComboBox = new JComboBox();
        pan3.add(this.cmComboBox);
        int[] r = new int[256];
        int[] g = new int[256];
        int[] b = new int[256];
        for (int i = 0; i < this.nameColorTables.length; ++i) {
            for (int j = 0; j < 256; ++j) {
                r[j] = 0xFF & this.colorTables[i * 768 + j];
                g[j] = 0xFF & this.colorTables[i * 768 + 256 + j];
                b[j] = 0xFF & this.colorTables[i * 768 + 512 + j];
            }
            this.cmComboBox.addItem(new ColorMap(this.nameColorTables[i], r, g, b));
        }
        this.colorMap = (ColorMap)this.cmComboBox.getSelectedItem();
        this.cmComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                ColorMapDialog.this.cp.setColormap(((ColorMap)ev.getItem()).colors);
                ColorMapDialog.this.wave.applyColorModel((ColorMap)ev.getItem());
            }
        });
        if (this.colorMap == null) {
            this.colorMap = new ColorMap();
        }
        this.cp = new ColorPalette(this.colorMap.colors);
        this.getContentPane().add(this.cp);
        pan1.add(pan2);
        pan1.add(pan3);
        this.bitOptionPanel = new JPanel();
        this.bitOptionPanel.setBorder(BorderFactory.createTitledBorder("16 bit  Option"));
        this.shiftSlider = new JSlider(-8, 8, 0);
        this.bitOptionPanel.add(this.shiftSlider);
        this.shiftSlider.setName("Bit Offset");
        this.shiftSlider.setMajorTickSpacing(1);
        this.shiftSlider.setPaintTicks(true);
        this.shiftSlider.setPaintLabels(true);
        this.shiftSlider.setSnapToTicks(true);
        this.shiftSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorMapDialog.this.wave.setFrameBitShift(ColorMapDialog.this.shiftSlider.getValue(), ColorMapDialog.this.bitClip.isSelected());
            }
        });
        this.bitClip = new JCheckBox("Bit Clip");
        this.bitOptionPanel.add(this.bitClip);
        this.bitClip.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorMapDialog.this.wave.setFrameBitShift(ColorMapDialog.this.shiftSlider.getValue(), ColorMapDialog.this.bitClip.isSelected());
            }
        });
        JPanel pan4 = new JPanel();
        this.ok = new JButton("Ok");
        pan4.add(this.ok);
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorMap cm = (ColorMap)ColorMapDialog.this.cmComboBox.getSelectedItem();
                if (ColorMapDialog.this.is16BitImage) {
                    cm.bitClip = ColorMapDialog.this.bitClip.isSelected();
                    cm.bitShift = ColorMapDialog.this.shiftSlider.getValue();
                }
                try {
                    cm.setMin(Float.parseFloat(ColorMapDialog.this.minVal.getText().trim()));
                }
                catch (Exception exc) {
                    cm.setMin(Float.MIN_VALUE);
                }
                try {
                    cm.setMax(Float.parseFloat(ColorMapDialog.this.maxVal.getText().trim()));
                }
                catch (Exception exc) {
                    cm.setMax(Float.MAX_VALUE);
                }
                ColorMapDialog.this.wave.setColorMap(cm);
                ColorMapDialog.this.setVisible(false);
            }
        });
        this.cancel = new JButton("Cancel");
        pan4.add(this.cancel);
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorMapDialog.this.wave.setColorMap(ColorMapDialog.this.colorMap);
                ColorMapDialog.this.setVisible(false);
                if (ColorMapDialog.this.is16BitImage) {
                    ColorMapDialog.this.bitClip.setSelected(ColorMapDialog.this.colorMap.bitClip);
                    ColorMapDialog.this.shiftSlider.setValue(ColorMapDialog.this.colorMap.bitShift);
                }
            }
        });
        this.getContentPane().add(pan1);
        this.getContentPane().add(pan4);
        this.pack();
        this.setSize(330, 380);
    }

    public ColorMap getColorMap(String name) {
        for (int i = 0; i < this.cmComboBox.getItemCount(); ++i) {
            ColorMap cm = this.cmComboBox.getItemAt(i);
            if (!cm.name.equals(name)) continue;
            return cm;
        }
        return new ColorMap();
    }

    public void setWave(Waveform wave) {
        this.wave = wave;
        this.colorMap = wave.getColorMap();
        this.minVal.setText("" + this.colorMap.getMin());
        this.maxVal.setText("" + this.colorMap.getMax());
        this.cmComboBox.setSelectedItem(this.colorMap);
        this.is16BitImage = false;
        this.getContentPane().remove(this.bitOptionPanel);
        this.getContentPane().setLayout(new GridLayout(3, 1));
        this.setSize(380, 250);
    }

    public void addColorMapListener(ActionListener l) {
        this.colorMapListener.addElement(l);
    }

    public void removeMapListener(ActionListener l) {
        this.colorMapListener.remove(l);
    }

    public void processActionEvents(ActionEvent avtionEvent) {
        for (int i = 0; i < this.colorMapListener.size(); ++i) {
            this.colorMapListener.elementAt(i).actionPerformed(avtionEvent);
        }
    }

    private static final InputStream getResourcePalette() {
        return ColorMapDialog.class.getClassLoader().getResourceAsStream("mds/wave/colors.tbl");
    }

    public static void exportPalette(File file) throws IOException {
        try (InputStream is = ColorMapDialog.getResourcePalette();
             FileOutputStream os = new FileOutputStream(file);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, length);
            }
        }
    }

    public void readColorPalette(String cmap) {
        if (cmap == null) {
            cmap = lastMap;
        }
        DataInputStream dis = null;
        try {
            try {
                dis = new DataInputStream(new FileInputStream(new File(cmap)));
            }
            catch (IOException exc) {
                dis = new DataInputStream(ColorMapDialog.getResourcePalette());
            }
            int nColorTables = dis.readByte();
            this.nameColorTables = new String[nColorTables];
            byte[] name = new byte[32];
            this.colorTables = new byte[nColorTables * 3 * 256];
            dis.readFully(this.colorTables);
            for (int i = 0; i < nColorTables; ++i) {
                dis.readFully(name);
                this.nameColorTables[i] = new String(name).trim();
            }
            lastMap = cmap;
            MdsConnection.tryClose(dis);
        }
        catch (Exception exc) {
            this.nameColorTables = new String[0];
            this.colorTables = new byte[0];
            MdsConnection.tryClose(dis);
        }
    }

    public class ColorPalette
    extends JPanel {
        private static final long serialVersionUID = 1L;
        Color[] colors;

        ColorPalette(Color[] colors) {
            this.setBorder(BorderFactory.createLoweredBevelBorder());
            this.setColormap(colors);
        }

        public void setColormap(Color[] colors) {
            this.colors = colors;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            Dimension d = this.getSize();
            float dx = (float)d.width / (float)this.colors.length;
            for (int i = 0; i < this.colors.length; ++i) {
                int x = (int)((double)((float)i * dx) + 0.5);
                int width = (int)((double)((float)x + dx) + 0.5);
                g.setColor(this.colors[i]);
                g.fillRect(x, 0, width, d.height);
            }
            super.paintBorder(g);
        }
    }
}

