/*
 * Decompiled with CFR 0.152.
 */
package mds.wave;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Vector;
import mds.wave.Signal;

public class ContourSignal {
    static final int CASE_A = 0;
    static final int CASE_B = 1;
    static final int CASE_C = 2;
    static final int CASE_D = 3;
    private static int[] xNear_A = new int[]{0, 1, 1, 0};
    private static int[] yNear_A = new int[]{0, 0, 1, 1};
    private static int[] rPoint_A = new int[]{0, 1, 3};
    private static int[] succCase_A = new int[]{2, 0, 1};
    private static int[] xNear_B = new int[]{1, 1, 0, 0};
    private static int[] yNear_B = new int[]{0, 1, 1, 0};
    private static int[] rPoint_B = new int[]{0, 2, 2};
    private static int[] succCase_B = new int[]{0, 1, 3};
    private static int[] xNear_C = new int[]{0, 0, 1, 1};
    private static int[] yNear_C = new int[]{0, -1, -1, 0};
    private static int[] rPoint_C = new int[]{0, 1, 2};
    private static int[] succCase_C = new int[]{3, 2, 0};
    private static int[] xNear_D = new int[]{0, -1, -1, 0};
    private static int[] yNear_D = new int[]{0, 0, -1, -1};
    private static int[] rPoint_D = new int[]{1, 1, 2};
    private static int[] succCase_D = new int[]{1, 3, 2};
    double[] x;
    float[] y;
    float[][] z;
    double xmin = -1.0;
    double xmax = 1.0;
    double ymin = -1.0;
    double ymax = 1.0;
    double zmin = -1.0;
    double zmax = 1.0;
    boolean automaticLimits = true;
    private boolean[][] xflag;
    private boolean equalZ2;

    ContourSignal(Signal s) {
        if (s.getType() == 1) {
            this.setMinMaxX(s.getX2Dmin(), s.getX2Dmax());
            this.setMinMaxY(s.getY2Dmin(), s.getY2Dmax());
            this.setMinMaxZ(s.getZ2Dmin(), s.getZ2Dmax());
            this.x = s.getX2D();
            this.y = s.getY2D();
            this.z = s.getZ2D();
        }
    }

    ContourSignal(double[] x, float[] y, float[][] z) {
        if (x.length != z.length || y.length != z[0].length) {
            throw new IllegalArgumentException("Z colum must be equals to x element end Z row to y elements");
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.computeMinMax();
    }

    private final boolean checkIntersection(double level, double z1, double z2) {
        boolean out = z1 < level && level < z2 || z2 < level && level < z1 || (this.equalZ2 = level == z2);
        return out;
    }

    public Vector<Vector<Point2D.Double>> contour(double level) {
        Vector<Vector<Point2D.Double>> contours = new Vector<Vector<Point2D.Double>>();
        Vector<Point2D.Double> contour = new Vector<Point2D.Double>();
        int[] xNear = null;
        int[] yNear = null;
        int[] rPoint = null;
        int[] succCase = null;
        Point2D.Double firstCPoint = new Point2D.Double();
        Point2D.Double currCPoint = new Point2D.Double();
        this.xflag = new boolean[this.x.length][this.y.length];
        int edgeCase = 0;
        int ri = 0;
        int rj = 0;
        int maxIteractions = this.x.length * this.y.length;
        for (int i = 0; i < this.x.length; ++i) {
            for (int j = 0; j < this.y.length - 1; ++j) {
                if (this.xflag[i][j]) continue;
                double x1 = this.x[i];
                double y1 = this.y[j];
                double z1 = this.z[i][j];
                double x2 = this.x[i];
                double y2 = this.y[j + 1];
                double z2 = this.z[i][j + 1];
                if (!this.checkIntersection(level, z1, z2)) continue;
                double c1 = (level - z1) / (z2 - z1);
                double xc = x1 + (x2 - x1) * c1;
                double yc = y1 + (y2 - y1) * c1;
                firstCPoint = new Point2D.Double(xc, yc);
                contour.addElement(firstCPoint);
                edgeCase = 0;
                ri = i;
                rj = j;
                if (this.equalZ2) {
                    try {
                        this.xflag[i][j - 1] = true;
                        this.xflag[i][j] = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                boolean contourCompleted = false;
                int numIteractions = 0;
                while (!contourCompleted) {
                    do {
                        try {
                            int l;
                            switch (edgeCase) {
                                case 0: {
                                    xNear = xNear_A;
                                    yNear = yNear_A;
                                    rPoint = rPoint_A;
                                    succCase = succCase_A;
                                    this.xflag[ri][rj] = true;
                                    break;
                                }
                                case 1: {
                                    xNear = xNear_B;
                                    yNear = yNear_B;
                                    rPoint = rPoint_B;
                                    succCase = succCase_B;
                                    break;
                                }
                                case 2: {
                                    xNear = xNear_C;
                                    yNear = yNear_C;
                                    rPoint = rPoint_C;
                                    succCase = succCase_C;
                                    break;
                                }
                                case 3: {
                                    xNear = xNear_D;
                                    yNear = yNear_D;
                                    rPoint = rPoint_D;
                                    succCase = succCase_D;
                                    this.xflag[ri][rj - 1] = true;
                                }
                            }
                            int rri = 0;
                            int rrj = 0;
                            for (l = 0; l < 3; ++l) {
                                rri = ri + xNear[l];
                                rrj = rj + yNear[l];
                                x1 = this.x[rri];
                                y1 = this.y[rrj];
                                z1 = this.z[rri][rrj];
                                int rrii = ri + xNear[l + 1];
                                int rrjj = rj + yNear[l + 1];
                                x2 = this.x[rrii];
                                y2 = this.y[rrjj];
                                z2 = this.z[rrii][rrjj];
                                if (!this.checkIntersection(level, z1, z2)) continue;
                                if (this.equalZ2) {
                                    try {
                                        this.xflag[rrii][rrjj - 1] = true;
                                        this.xflag[rrii][rrjj] = true;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                c1 = (level - z1) / (z2 - z1);
                                xc = x1 + (x2 - x1) * c1;
                                yc = y1 + (y2 - y1) * c1;
                                currCPoint = new Point2D.Double(xc, yc);
                                contour.addElement(currCPoint);
                                ri += xNear[rPoint[l]];
                                rj += yNear[rPoint[l]];
                                edgeCase = succCase[l];
                                break;
                            }
                            if (l != 3) continue;
                            System.out.println("Errore creazione curva di livello");
                            currCPoint = firstCPoint;
                        }
                        catch (Exception exc) {
                            int border;
                            if (exc instanceof IOException) continue;
                            boolean found = false;
                            block23: for (border = 0; border < 4 && !found; ++border) {
                                switch (edgeCase) {
                                    case 1: {
                                        int xi;
                                        int yj = this.y.length - 1;
                                        for (xi = ri; xi > 0; --xi) {
                                            x2 = this.x[xi];
                                            y2 = this.y[yj];
                                            z2 = this.z[xi][yj];
                                            x1 = this.x[xi - 1];
                                            y1 = this.y[yj];
                                            z1 = this.z[xi - 1][yj];
                                            if (!this.checkIntersection(level, z1, z2)) continue;
                                            found = true;
                                            ri = xi - 1;
                                            rj = yj;
                                            edgeCase = 2;
                                            break;
                                        }
                                        if (found) continue block23;
                                        edgeCase = 3;
                                        rj = this.y.length - 1;
                                        continue block23;
                                    }
                                    case 0: {
                                        int yj;
                                        int xi = this.x.length - 1;
                                        for (yj = rj + 1; yj < this.y.length - 1; ++yj) {
                                            x1 = this.x[xi];
                                            y1 = this.y[yj];
                                            z1 = this.z[xi][yj];
                                            x2 = this.x[xi];
                                            y2 = this.y[yj + 1];
                                            z2 = this.z[xi][yj + 1];
                                            this.xflag[xi][yj] = true;
                                            if (!this.checkIntersection(level, z1, z2)) continue;
                                            found = true;
                                            ri = xi;
                                            rj = yj + 1;
                                            edgeCase = 3;
                                            break;
                                        }
                                        if (found) continue block23;
                                        edgeCase = 1;
                                        ri = this.x.length - 1;
                                        continue block23;
                                    }
                                    case 2: {
                                        int xi;
                                        int yj = 0;
                                        for (xi = ri + 1; xi < this.x.length - 1; ++xi) {
                                            x1 = this.x[xi];
                                            y1 = this.y[yj];
                                            z1 = this.z[xi][yj];
                                            x2 = this.x[xi + 1];
                                            y2 = this.y[yj];
                                            z2 = this.z[xi + 1][yj];
                                            if (!this.checkIntersection(level, z1, z2)) continue;
                                            found = true;
                                            ri = xi;
                                            rj = yj;
                                            edgeCase = 1;
                                            break;
                                        }
                                        if (found) continue block23;
                                        edgeCase = 0;
                                        rj = -1;
                                        continue block23;
                                    }
                                    case 3: {
                                        int yj;
                                        int xi = 0;
                                        for (yj = rj - 1; yj > 0; --yj) {
                                            x1 = this.x[xi];
                                            y1 = this.y[yj];
                                            z1 = this.z[xi][yj];
                                            x2 = this.x[xi];
                                            y2 = this.y[yj - 1];
                                            z2 = this.z[xi][yj - 1];
                                            this.xflag[xi][yj] = true;
                                            if (!this.checkIntersection(level, z1, z2)) continue;
                                            found = true;
                                            ri = xi;
                                            rj = yj - 1;
                                            edgeCase = 0;
                                            break;
                                        }
                                        if (found) continue block23;
                                        edgeCase = 2;
                                        ri = -1;
                                    }
                                }
                            }
                            if (contour.size() >= 2) {
                                contours.addElement(contour);
                                contour = new Vector();
                            } else {
                                contour.clear();
                            }
                            c1 = (level - z1) / (z2 - z1);
                            xc = x1 + (x2 - x1) * c1;
                            yc = y1 + (y2 - y1) * c1;
                            currCPoint = new Point2D.Double(xc, yc);
                            contour.addElement(currCPoint);
                            if (found || border != 4) continue;
                            numIteractions = maxIteractions;
                        }
                    } while (++numIteractions <= maxIteractions && !currCPoint.equals(firstCPoint));
                    if (contour.size() >= 2) {
                        contours.addElement(contour);
                        contour = new Vector();
                    } else {
                        contour.clear();
                    }
                    contourCompleted = true;
                }
            }
        }
        this.xflag = null;
        return contours;
    }

    public void setMinMax(float xmin, float xmax, float ymin, float ymax, float zmin, float zmax) {
        this.setMinMaxX(xmin, xmax);
        this.setMinMaxY(ymin, ymax);
        this.setMinMaxZ(zmin, zmax);
    }

    public void setMinMaxX(double xmin, double xmax) {
        this.xmin = xmin;
        this.xmax = xmax;
    }

    public void setMinMaxY(double ymin, double ymax) {
        this.ymin = ymin;
        this.ymax = ymax;
    }

    public void setMinMaxZ(double zmin, double zmax) {
        this.zmin = zmin;
        this.zmax = zmax;
    }

    private void computeMinMax() {
        int i;
        this.xmin = this.xmax = this.x[0];
        this.ymin = this.ymax = (double)this.y[0];
        this.zmin = this.zmax = (double)this.z[0][0];
        for (i = 0; i < this.x.length; ++i) {
            if (this.x[i] < this.xmin) {
                this.xmin = this.x[i];
            }
            if (this.x[i] > this.xmax) {
                this.xmax = this.x[i];
            }
            for (int j = 0; j < this.z[0].length; ++j) {
                if ((double)this.z[i][j] < this.zmin) {
                    this.zmin = this.z[i][j];
                }
                if (!((double)this.z[i][j] > this.zmax)) continue;
                this.zmax = this.z[i][j];
            }
        }
        for (i = 0; i < this.y.length; ++i) {
            if ((double)this.y[i] < this.ymin) {
                this.ymin = this.y[i];
            }
            if (!((double)this.y[i] > this.ymax)) continue;
            this.ymax = this.y[i];
        }
        this.equalCases();
    }

    private void equalCases() {
        if (this.xmax == this.xmin) {
            this.xmin -= this.xmax / 10.0;
            this.xmax += this.xmax / 10.0;
        }
        if (this.ymax == this.ymin) {
            this.ymin -= this.ymax / 10.0;
            this.ymax += this.ymax / 10.0;
        }
        if (this.zmax == this.zmin) {
            this.zmin -= this.zmax / 10.0;
            this.zmax += this.zmax / 10.0;
        }
    }
}

