/*
 * Decompiled with CFR 0.152.
 */
package mds.wave;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.Vector;
import mds.wave.Frames;
import mds.wave.Signal;
import mds.wave.WaveInterface;
import mds.wave.Waveform;

public class MultiWaveform
extends Waveform {
    public static final int MAX_DRAG_POINT = 200;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int PRINT_LEGEND = 4;
    public static final int PRINT_BW = 8;
    public static final int LEGEND_IN_GRAPHICS = 0;
    public static final int LEGEND_BOTTOM = 1;
    public static final int LEGEND_RIGHT = 2;
    protected Vector<Signal> signals = new Vector();
    protected Vector<Signal> orig_signals = null;
    protected double orig_xmin;
    protected double orig_xmax;
    protected int curr_point_sig_idx = -1;
    protected boolean show_legend = false;
    protected double legend_x;
    protected double legend_y;
    private Point legend_point;
    private int right_size = 0;
    private int bottom_size = 0;
    protected boolean fixed_legend = false;
    private int legend_mode = 0;
    public WaveInterface wi;
    boolean continuosAutoscale = false;
    private boolean asinchAutoscale = false;

    public MultiWaveform() {
        if (this.signals.size() != 0) {
            this.signals.removeAllElements();
        }
        this.orig_signals = null;
        Waveform.SymContainer aSymContainer = new Waveform.SymContainer();
        this.addContainerListener(aSymContainer);
    }

    @Override
    public void Erase() {
        if (this.signals.size() != 0) {
            this.signals.removeAllElements();
        }
        this.orig_signals = null;
        this.show_legend = false;
        this.legend_point = null;
        super.Erase();
    }

    @Override
    public void Copy(Waveform wave) {
        super.Copy(wave);
        if (!wave.is_image) {
            MultiWaveform w = (MultiWaveform)wave;
            if (this.signals.size() != 0) {
                this.signals.removeAllElements();
            }
            Vector<Signal> s = w.GetSignals();
            for (int i = 0; i < s.size(); ++i) {
                this.signals.addElement(new Signal(s.elementAt(i)));
                this.signals.elementAt(i).registerSignalListener(this);
            }
            this.show_legend = w.show_legend;
            this.show_sig_image = w.show_sig_image;
            if (w.show_legend) {
                this.legend_x = w.legend_x;
                this.legend_y = w.legend_y;
                this.legend_point = new Point(w.legend_point);
            }
            this.UpdateLimits();
            if (this.waveform_signal != null) {
                super.Update(this.waveform_signal);
            }
        }
    }

    public void removeSignal(int idx) {
        if (idx < this.signals.size()) {
            this.signals.removeElementAt(idx);
        }
    }

    public void replaceSignal(int idx, Signal s) {
        if (idx < this.signals.size()) {
            this.signals.removeElementAt(idx);
            this.signals.insertElementAt(s, idx);
        }
    }

    public boolean exists(Signal s) {
        if (s == null) {
            return true;
        }
        if (s.getName() == null || s.getName().length() == 0) {
            s.setName("Signal_" + this.signals.size());
            return false;
        }
        for (int i = 0; i < this.signals.size(); ++i) {
            Signal s1 = this.signals.elementAt(i);
            if (s1.getName() == null || s.getName() == null || !s1.getName().equals(s.getName())) continue;
            return true;
        }
        return false;
    }

    public void addSignal(Signal s) {
        if (!this.exists(s)) {
            this.signals.addElement(s);
            this.setLimits();
            s.registerSignalListener(this);
        }
    }

    public void addSignals(Signal[] s) {
        if (s == null || s.length == 0) {
            return;
        }
        for (int i = 0; i < s.length; ++i) {
            this.addSignal(s[i]);
            if (s[i] == null) continue;
            s[i].registerSignalListener(this);
        }
        this.setLimits();
        if (this.waveform_signal != null) {
            this.curr_point_sig_idx = 0;
            super.Update(this.waveform_signal);
        }
    }

    public boolean IsShowLegend() {
        return this.show_legend;
    }

    public void setShowLegend(boolean show_legend) {
        this.show_legend = show_legend;
    }

    public void RemoveLegend() {
        this.show_legend = false;
        this.not_drawn = true;
        this.repaint();
    }

    public void setWaveInterface(WaveInterface wi) {
        this.wi = wi;
    }

    public WaveInterface getWaveInterface() {
        return this.wi;
    }

    public double GetLegendXPosition() {
        return this.legend_x;
    }

    public double GetLegendYPosition() {
        return this.legend_y;
    }

    public int getLegendMode() {
        return this.legend_mode;
    }

    public void setLegendMode(int legend_mode) {
        this.legend_mode = legend_mode;
        this.fixed_legend = legend_mode != 0;
    }

    public boolean isFixedLegend() {
        return this.fixed_legend;
    }

    public void SetLegend(Point p) {
        Dimension d = this.getSize();
        this.legend_x = this.wm.XValue(p.x, d);
        this.legend_y = this.wm.YValue(p.y, d);
        this.legend_point = new Point(p);
        this.show_legend = true;
        this.not_drawn = true;
        this.repaint();
    }

    @Override
    protected void PaintSignal(Graphics g, Dimension d, int print_mode) {
        Dimension dim = print_mode == 0 ? this.getWaveSize() : this.getPrintWaveSize(d);
        super.PaintSignal(g, d, print_mode);
        if (this.show_legend && !this.fixed_legend && !this.is_min_size) {
            Point p = new Point();
            if (this.legend_point == null || this.prev_width != d.width || this.prev_height != d.height) {
                p.x = this.wm.XPixel(this.legend_x, dim);
                p.y = this.wm.YPixel(this.legend_y, dim);
                this.legend_point = p;
            } else {
                p = this.legend_point;
            }
            this.drawLegend(g, p, print_mode, 1);
        }
        if (this.fixed_legend && this.show_legend || (print_mode & 4) == 4) {
            g.setClip(0, 0, d.width, d.height);
            if (this.legend_mode == 1 && this.bottom_size != 0) {
                this.drawLegend(g, new Point(0, dim.height), print_mode, 0);
            }
            if (this.legend_mode == 2 && this.right_size != 0) {
                this.drawLegend(g, new Point(dim.width, 0), print_mode, 1);
            }
        }
    }

    public synchronized void UpdateSignals(Signal[] signals, int timestamp, boolean force_update) {
        int i;
        if (!force_update && this.update_timestamp != timestamp) {
            return;
        }
        for (i = 0; i < signals.length; ++i) {
            signals[i].setAttributes(this.signals.elementAt(i));
        }
        if (this.signals.size() != 0) {
            this.signals.removeAllElements();
        }
        for (i = 0; i < signals.length; ++i) {
            this.signals.addElement(signals[i]);
            if (signals[i] == null) continue;
            signals[i].registerSignalListener(this);
        }
        if (force_update) {
            this.SetEnabledDispatchEvents(false);
            this.UpdateLimits();
        }
        if (this.waveform_signal != null) {
            if (this.curr_point_sig_idx > signals.length || this.curr_point_sig_idx == -1) {
                this.curr_point_sig_idx = 0;
            }
            if (force_update && this.continuosAutoscale) {
                super.Update(this.waveform_signal);
            } else {
                super.UpdateSignal(this.waveform_signal);
            }
        }
        if (this.asinchAutoscale) {
            this.AutoscaleY();
            this.asinchAutoscale = false;
        }
        if (force_update) {
            this.SetEnabledDispatchEvents(true);
        }
    }

    public Vector<Signal> GetSignals() {
        return this.signals;
    }

    public String[] GetSignalsName() {
        try {
            String[] names = new String[this.signals.size()];
            for (int i = 0; i < this.signals.size(); ++i) {
                Signal s = this.signals.elementAt(i);
                String n = s.getName();
                if (n != null) {
                    names[i] = n;
                    continue;
                }
                names[i] = new String("Signal_" + i);
                s.setName(names[i]);
            }
            return names;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getSignalName(int idx) {
        if (idx < this.signals.size() && this.signals.elementAt(idx) != null) {
            Signal s = this.signals.elementAt(idx);
            if (s.getName() == null) {
                s.setName(new String("Signal_" + idx));
            }
            return s.getName();
        }
        if (this.is_image && this.frames != null) {
            return this.frames.getName();
        }
        return null;
    }

    public void SetInterpolate(int idx, boolean interpolate) {
        if (idx < this.signals.size()) {
            this.signals.elementAt(idx).setInterpolate(interpolate);
        }
    }

    public boolean GetInterpolate(int idx) {
        if (idx < this.signals.size()) {
            return this.signals.elementAt(idx).getInterpolate();
        }
        return false;
    }

    public void SetMarker(int idx, int marker) {
        if (idx < this.signals.size()) {
            this.signals.elementAt(idx).setMarker(marker);
        }
    }

    public int GetMarker(int idx) {
        if (idx < this.signals.size()) {
            return this.signals.elementAt(idx).getMarker();
        }
        return 0;
    }

    public void SetMarkerStep(int idx, int marker_step) {
        if (idx < this.signals.size()) {
            this.signals.elementAt(idx).setMarkerStep(marker_step);
        }
    }

    public int GetMarkerStep(int idx) {
        if (idx < this.signals.size()) {
            return this.signals.elementAt(idx).getMarkerStep();
        }
        return 0;
    }

    public void SetColorIdx(int idx, int color_idx) {
        if (this.is_image) {
            super.SetColorIdx(color_idx);
            super.SetCrosshairColor(color_idx);
            return;
        }
        if (idx < this.signals.size()) {
            this.signals.elementAt(idx).setColorIdx(color_idx);
            if (idx == this.curr_point_sig_idx) {
                this.crosshair_color = colors[color_idx % colors.length];
            }
        }
    }

    public int GetColorIdx(int idx) {
        if (this.is_image) {
            return super.GetColorIdx();
        }
        if (idx < this.signals.size()) {
            return this.signals.elementAt(idx).getColorIdx();
        }
        return 0;
    }

    @Override
    public int GetShowSignalCount() {
        if (this.signals != null) {
            return this.signals.size();
        }
        return 0;
    }

    public int getSignalCount() {
        return this.GetShowSignalCount();
    }

    protected void setLimits() {
        this.setXlimits(this.lx_min, this.lx_max);
        this.setYlimits(this.ly_min, this.ly_max);
        this.UpdateLimits();
        this.change_limits = true;
    }

    @Override
    public void setXlimits(double xmin, double xmax) {
        if (this.signals == null) {
            return;
        }
        for (int i = 0; i < this.signals.size(); ++i) {
            Signal s = this.signals.elementAt(i);
            if (s == null) continue;
            s.setXLimits(xmin, xmax, 0);
        }
    }

    @Override
    public void setYlimits(float ymin, float ymax) {
        if (this.signals == null) {
            return;
        }
        for (int i = 0; i < this.signals.size(); ++i) {
            this.signals.elementAt(i).setYlimits(ymin, ymax);
        }
    }

    public void setPointSignalIndex(int idx) {
        if (idx >= 0 && idx < this.signals.size()) {
            this.curr_point_sig_idx = idx;
            Signal curr_signal = this.signals.elementAt(this.curr_point_sig_idx);
            if (curr_signal == null) {
                return;
            }
            this.crosshair_color = curr_signal.getColor() != null ? curr_signal.getColor() : colors[curr_signal.getColorIdx() % colors.length];
        }
    }

    public void SetSignalState(String label, boolean state) {
        if (this.signals != null) {
            for (int i = 0; i < this.signals.size(); ++i) {
                Signal sig = this.signals.elementAt(i);
                if (sig == null || !sig.getName().equals(label)) continue;
                sig.setInterpolate(state);
                sig.setMarker(0);
            }
            if (this.mode == 2) {
                Dimension d = this.getSize();
                double curr_x = this.wm.XValue(this.end_x, d);
                double curr_y = this.wm.YValue(this.end_y, d);
                this.FindPoint(curr_x, curr_y, true);
            }
        }
    }

    public boolean[] GetSignalsState() {
        boolean[] s_state = null;
        if (this.signals != null) {
            s_state = new boolean[this.signals.size()];
            for (int i = 0; i < this.signals.size(); ++i) {
                s_state[i] = this.GetSignalState(i);
            }
        }
        return s_state;
    }

    public boolean GetSignalState(int idx) {
        if (idx > this.signals.size()) {
            return false;
        }
        Signal s = this.signals.elementAt(idx);
        if (s == null) {
            return false;
        }
        return s.getInterpolate() || s.getMarker() != 0;
    }

    @Override
    public void Update() {
        if (!this.is_image) {
            this.UpdateLimits();
            if (this.waveform_signal != null) {
                this.curr_point_sig_idx = 0;
                super.Update(this.waveform_signal);
            } else {
                this.not_drawn = true;
                this.repaint();
            }
        } else if (this.frames != null) {
            super.Update();
        }
    }

    @Override
    public void appendUpdate() {
        for (int i = 0; i < this.signals.size(); ++i) {
            if (!this.signals.elementAt(i).fullPaint()) continue;
            this.Update();
            return;
        }
        this.appendPaint(this.getGraphics(), this.getSize());
    }

    public void Update(Frames frames) {
        this.frames = frames;
        this.is_image = true;
        this.Update();
    }

    public void Update(Signal[] signals) {
        if (signals == null) {
            return;
        }
        if (this.signals.size() != 0) {
            this.signals.removeAllElements();
        }
        for (int i = 0; i < signals.length; ++i) {
            this.signals.addElement(signals[i]);
            if (signals[i] == null) continue;
            signals[i].registerSignalListener(this);
        }
        this.Update();
    }

    void UpdateLimits() {
        int i;
        if (this.signals == null || this.signals.size() == 0) {
            return;
        }
        if (this.curr_point_sig_idx == -1 || this.curr_point_sig_idx >= this.signals.size() || this.signals.elementAt(this.curr_point_sig_idx) == null) {
            for (i = 0; i < this.signals.size() && this.signals.elementAt(i) == null; ++i) {
            }
            if (i == this.signals.size()) {
                return;
            }
        } else {
            i = this.curr_point_sig_idx;
        }
        if (this.waveform_signal != null) {
            this.waveform_signal.dispose();
        }
        this.waveform_signal = new Signal(this.signals.elementAt(i));
        boolean anyLongX = false;
        for (i = 0; i < this.signals.size(); ++i) {
            if (this.signals.elementAt(i) == null || !this.signals.elementAt(i).isLongX()) continue;
            anyLongX = true;
            this.waveform_signal.setXLimits(this.signals.elementAt(i).getXmin(), this.waveform_signal.getXmax(), 1);
            break;
        }
        for (i = 0; i < this.signals.size(); ++i) {
            if (this.signals.elementAt(i) == null || anyLongX && !this.signals.elementAt(i).isLongX()) continue;
            if (this.waveform_signal.getXmax() < this.signals.elementAt(i).getXmax()) {
                this.waveform_signal.setXLimits(this.waveform_signal.getXmin(), this.signals.elementAt(i).getXmax(), 1);
            }
            if (this.waveform_signal.getXmin() > this.signals.elementAt(i).getXmin()) {
                this.waveform_signal.setXLimits(this.signals.elementAt(i).getXmin(), this.waveform_signal.getXmax(), 1);
            }
            if (this.waveform_signal.getYmax() < this.signals.elementAt(i).getYmax()) {
                this.waveform_signal.setYmax(this.signals.elementAt(i).getYmax(), 1);
            }
            if (!(this.waveform_signal.getYmin() > this.signals.elementAt(i).getYmin())) continue;
            this.waveform_signal.setYmin(this.signals.elementAt(i).getYmin(), 1);
        }
    }

    @Override
    public synchronized void paint(Graphics g, Dimension d, int print_mode) {
        this.right_size = 0;
        this.bottom_size = 0;
        if (this.fixed_legend && this.show_legend || (print_mode & 4) == 4) {
            Dimension dim;
            this.setFont(g);
            if (this.legend_mode == 1) {
                dim = this.getLegendDimension(g, d, 0);
                this.bottom_size = dim.height;
                g.drawLine(0, dim.height - 1, d.width, dim.height - 1);
            }
            if (this.legend_mode == 2) {
                dim = this.getLegendDimension(g, d, 1);
                this.right_size = dim.width;
                g.drawLine(dim.width - 1, 0, dim.width - 1, d.height);
            }
        }
        super.paint(g, d, print_mode);
    }

    @Override
    protected int getRightSize() {
        return this.right_size;
    }

    @Override
    protected int getBottomSize() {
        return this.bottom_size;
    }

    protected Dimension getLegendDimension(Graphics g, Dimension d, int orientation) {
        Dimension dim = new Dimension(0, 0);
        int curr_width = 0;
        int sum_width = 0;
        Font f = g.getFont();
        int h = f.getSize() + 2;
        FontMetrics fm = this.getFontMetrics(f);
        if (this.getSignalCount() == 0) {
            return dim;
        }
        for (int i = 0; i < this.getSignalCount(); ++i) {
            if (!this.isSignalShow(i)) continue;
            String lab = this.getSignalInfo(i);
            char[] lab_ar = lab.toCharArray();
            curr_width = fm.charsWidth(lab_ar, 0, lab_ar.length);
            if (orientation == 1) {
                dim.height += h;
                if ((curr_width += 2 * this.marker_width) > dim.width) {
                    dim.width = curr_width;
                }
            }
            if (orientation != 0) continue;
            if (sum_width + (curr_width += 3 * this.marker_width) < d.width) {
                sum_width += curr_width;
                continue;
            }
            if (sum_width > dim.width) {
                dim.width = sum_width;
            }
            sum_width = curr_width;
            dim.height += h;
        }
        dim.height = dim.height + (orientation == 0 ? (int)(1.5 * (double)h + 0.5) : h / 2);
        return dim;
    }

    protected String getSignalInfo(int i) {
        Signal sign = this.signals.elementAt(i);
        String lab = sign.getName();
        if (sign.getType() == 1) {
            switch (sign.getMode2D()) {
                case 0: {
                    lab = lab + " [X-Z Y = " + Waveform.ConvertToString(sign.getYinXZplot(), false) + " ]";
                    break;
                }
                case 1: {
                    lab = lab + " [Y-Z X = " + sign.getStringOfXinYZplot() + " ]";
                }
            }
        }
        return lab;
    }

    protected boolean isSignalShow(int i) {
        Signal sign = this.signals.elementAt(i);
        return sign != null && (sign.getInterpolate() || sign.getMarker() != 0);
    }

    protected Color getSignalColor(int i) {
        if (i > this.signals.size()) {
            return Color.black;
        }
        Signal sign = this.signals.elementAt(i);
        if (sign.getColor() != null) {
            return sign.getColor();
        }
        return colors[sign.getColorIdx() % colors.length];
    }

    protected void drawLegend(Graphics g, Point p, int print_mode, int orientation) {
        Dimension d = this.getSize();
        int h = g.getFont().getSize() + 2;
        Color prev_col = g.getColor();
        Point[] pts = new Point[1];
        FontMetrics fm = this.getFontMetrics(g.getFont());
        pts[0] = new Point();
        int curr_width = 0;
        int sum_width = p.x;
        int curr_marker = 0;
        g.setColor(Color.black);
        if (orientation == 1) {
            g.translate(-this.marker_width, 0);
        }
        int py = p.y + h;
        int px = p.x;
        for (int i = 0; i < this.getSignalCount(); ++i) {
            if (!this.isSignalShow(i)) continue;
            if ((print_mode & 8) != 8) {
                g.setColor(this.getSignalColor(i));
            }
            String s = this.getSignalInfo(i);
            if (orientation == 0) {
                char[] s_ar = s.toCharArray();
                curr_width = fm.charsWidth(s_ar, 0, s_ar.length) + 3 * this.marker_width;
                if (sum_width + curr_width < d.width) {
                    px = sum_width;
                    sum_width += curr_width;
                } else {
                    py += h;
                    px = p.x;
                    sum_width = p.x + curr_width;
                }
            }
            pts[0].x = px + 2 * this.marker_width;
            pts[0].y = py - this.marker_width / 2;
            this.drawMarkers(g, pts, 1, this.GetMarker(i), 1, -1);
            if (this.GetMarker(i) == 0 && (print_mode & 8) == 8) {
                this.drawMarkers(g, pts, 1, curr_marker + 1, 1, -1);
                curr_marker = (curr_marker + 1) % (Signal.markerList.length - 1);
            }
            g.drawString(s, px + 3 * this.marker_width, py);
            if (orientation != 1) continue;
            py += h;
        }
        if (orientation == 1) {
            g.translate(this.marker_width, 0);
        }
        g.setColor(prev_col);
    }

    @Override
    protected void drawSignal(Graphics g) {
        this.drawSignal(g, this.getSize(), 0);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void drawSignal(Graphics g, Dimension d, int print_mode) {
        num_marker = Signal.markerList.length - 1;
        segments = null;
        marker_step = 1;
        g.setColor(Color.black);
        for (i = 0; i < this.signals.size(); ++i) {
            s = this.signals.elementAt(i);
            if (s == null) continue;
            if ((print_mode & 8) != 8) {
                v0 = marker_step = s.getMarkerStep() > 0 ? s.getMarkerStep() : 1;
                if (s.getColor() != null) {
                    g.setColor(s.getColor());
                } else {
                    g.setColor(MultiWaveform.colors[s.getColorIdx() % MultiWaveform.colors.length]);
                }
            } else if (s.getMarker() != 0) {
                marker_step = (int)((s.getNumPoints() > 1000 ? 100.0 : (double)s.getNumPoints() / 10.0) + 0.5);
            }
            if (this.mode == 3 && this.dragging && s.getNumPoints() > 200) {
                drag_point = 200;
                if (this.signals.size() == 1) {
                    drag_point = s.getNumPoints() > 600 ? 600 : s.getNumPoints();
                }
                x = new int[s.getNumPoints()];
                y = new int[s.getNumPoints()];
                curr_points = new Point[s.getNumPoints()];
                step = (float)s.getNumPoints() / (float)drag_point;
                num_steps = drag_point;
                for (j = 0; j < num_steps; ++j) {
                    x[j] = this.wm.XPixel(s.getX((int)(step * (float)j)), d);
                    y[j] = this.wm.YPixel(s.getY((int)(step * (float)j)), d);
                    curr_points[j] = new Point(x[j], y[j]);
                }
                for (jj = 0; jj < num_steps - 1; ++jj) {
                    if (Double.isNaN(s.getY((int)(step * (float)jj))) || Double.isNaN(s.getY((int)(step * (float)(jj + 1))))) continue;
                    g.drawLine(x[jj], y[jj], x[jj + 1], y[jj + 1]);
                }
            } else if (s.getType() == 1 && (s.getMode2D() == 3 || s.getMode2D() == 2)) {
                if (this.mode != 3 || !this.dragging) {
                    switch (s.getMode2D()) {
                        case 3: {
                            img = this.createImage(d.width, d.height);
                            this.wm.ToImage(s, img, d, this.colorMap);
                            g.drawImage(img, 0, 0, d.width, d.height, this);
                            ** break;
                        }
                        case 2: {
                            this.drawSignalContour(s, g, d);
                        }
                    }
                }
lbl48:
                // 5 sources

            } else {
                segments = this.wm.ToPolygons(s, d, this.appendDrawMode);
                if (segments != null && (s.getInterpolate() || this.mode == 3 && this.dragging)) {
                    for (k = 0; k < segments.size(); ++k) {
                        curr_polygon = segments.elementAt(k);
                        g.drawPolyline(curr_polygon.xpoints, curr_polygon.ypoints, curr_polygon.npoints);
                    }
                }
            }
            if (this.dragging && this.mode == 3) continue;
            if (s.getMarker() != 0 && s.getMode2D() != 3) {
                this.drawMarkers(g, segments, s);
            }
            if (!s.hasError()) continue;
            this.drawError(s, g, d);
        }
        if ((print_mode & 8) == 8) {
            curr_marker = 0;
            for (i = 0; i < this.signals.size(); ++i) {
                s = this.signals.elementAt(i);
                if (s == null) continue;
                segments = this.wm.ToPolygons(s, d, this.appendDrawMode);
                marker_step = (int)((s.getNumPoints() > 1000 ? 100.0 : (double)s.getNumPoints() / 10.0) + 0.5);
                this.drawMarkers(g, segments, curr_marker + 1, marker_step, s.getMode1D());
                curr_marker = (curr_marker + 1) % num_marker;
            }
        }
        segments = null;
    }

    protected void drawMarkers(Graphics g, Vector<Polygon> segments, Signal s) {
        this.drawMarkers(g, segments, s.getMarker(), s.getMarkerStep(), s.getMode1D());
    }

    @Override
    protected void drawMarkers(Graphics g, Vector<Polygon> segments, int mark_type, int step, int mode) {
        int i;
        int num_segments = 0;
        if (segments != null) {
            num_segments = segments.size();
        }
        int num_points = 0;
        for (i = 0; i < num_segments; ++i) {
            num_points += segments.elementAt((int)i).npoints;
        }
        Point[] points = new Point[num_points];
        for (i = 0; i < num_points; ++i) {
            points[i] = new Point();
        }
        num_points = 0;
        for (i = 0; i < num_segments; ++i) {
            Polygon curr_polygon = segments.elementAt(i);
            for (int j = 0; j < curr_polygon.npoints; j += step) {
                points[num_points].x = curr_polygon.xpoints[j];
                points[num_points].y = curr_polygon.ypoints[j];
                ++num_points;
            }
        }
        super.drawMarkers(g, points, num_points, mark_type, 1, mode);
    }

    @Override
    protected Point FindPoint(double curr_x, double curr_y, boolean is_first) {
        return this.FindPoint(curr_x, curr_y, this.getWaveSize(), is_first);
    }

    @Override
    protected Point FindPoint(double curr_x, double curr_y, Dimension d, boolean is_first) {
        Signal curr_signal;
        int curr_idx = -1;
        int img_idx = -1;
        double curr_dist = 0.0;
        double min_dist = Double.MAX_VALUE;
        if (this.signals == null || this.signals.size() == 0) {
            return null;
        }
        if (!is_first) {
            Signal curr_signal2 = this.signals.elementAt(this.curr_point_sig_idx);
            return this.FindPoint(curr_signal2, curr_x, curr_y, d);
        }
        this.curr_point_sig_idx = 0;
        for (int i = 0; i < this.signals.size(); ++i) {
            curr_signal = this.signals.elementAt(i);
            if (curr_signal == null || !this.GetSignalState(i)) continue;
            curr_idx = curr_signal.FindClosestIdx(curr_x, curr_y);
            if (curr_signal.getType() == 1 && (curr_signal.getMode2D() == 3 || curr_signal.getMode2D() == 2)) {
                double[] x2D = curr_signal.getX2D();
                int inc = (int)((double)x2D.length / 10.0) + 1;
                inc = curr_idx + inc > x2D.length ? x2D.length - curr_idx - 1 : inc;
                img_idx = i;
                continue;
            }
            if (curr_signal.hasX()) {
                curr_dist = ((double)curr_signal.getY(curr_idx) - curr_y) * ((double)curr_signal.getY(curr_idx) - curr_y) + (curr_signal.getX(curr_idx) - curr_x) * (curr_signal.getX(curr_idx) - curr_x);
            }
            if (i != 0 && !(curr_dist < min_dist)) continue;
            min_dist = curr_dist;
            this.curr_point_sig_idx = i;
        }
        try {
            if (img_idx != -1) {
                if (curr_idx != -1) {
                    curr_signal = this.signals.elementAt(this.curr_point_sig_idx);
                    if (min_dist > (double)(10.0f * (curr_signal.getY(0) - curr_signal.getY(1)) * (curr_signal.getY(0) - curr_signal.getY(1)))) {
                        this.curr_point_sig_idx = img_idx;
                    }
                } else {
                    this.curr_point_sig_idx = img_idx;
                }
            }
        }
        catch (Exception x2D) {
            // empty catch block
        }
        this.setPointSignalIndex(this.curr_point_sig_idx);
        curr_signal = this.signals.elementAt(this.curr_point_sig_idx);
        this.not_drawn = true;
        Point p = this.FindPoint(curr_signal, curr_x, curr_y, d);
        return p;
    }

    @Override
    public void UpdatePoint(double curr_x) {
        this.UpdatePoint(curr_x, Double.NaN);
    }

    @Override
    public synchronized void UpdatePoint(double curr_x, double curr_y) {
        if (!this.is_image) {
            if (this.mode != 2 || this.signals == null || this.signals.size() == 0) {
                return;
            }
            for (int i = 0; i < this.signals.size(); ++i) {
                Signal s = this.signals.elementAt(i);
                if (s == null || s.getType() != 1 || s.getMode2D() != 1) continue;
                s.showYZ(curr_x);
                this.not_drawn = true;
            }
        }
        super.UpdatePoint(curr_x, curr_y);
    }

    @Override
    public int GetSelectedSignal() {
        return this.curr_point_sig_idx;
    }

    @Override
    public Signal GetSignal() {
        if (this.signals != null && this.signals.size() > 0) {
            return this.signals.elementAt(this.curr_point_sig_idx);
        }
        return null;
    }

    public int getSignalMode1D(int idx) {
        try {
            return this.signals.elementAt(idx).getMode1D();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
    }

    public int getSignalMode2D(int idx) {
        try {
            return this.signals.elementAt(idx).getMode2D();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
    }

    @Override
    public int getSignalMode1D() {
        return this.getSignalMode1D(this.curr_point_sig_idx);
    }

    @Override
    public int getSignalMode2D() {
        return this.getSignalMode2D(this.curr_point_sig_idx);
    }

    public int getSignalType(int idx) {
        int type = -1;
        if (idx >= 0 && idx < this.signals.size() && this.signals.elementAt(idx) != null) {
            type = this.signals.elementAt(idx).getType();
        }
        return type;
    }

    @Override
    public int getSignalType() {
        return this.getSignalType(this.curr_point_sig_idx);
    }

    public void setSignalMode(int idx, int mode) {
        Signal s;
        if (idx >= 0 && idx < this.signals.size() && (s = this.signals.elementAt(idx)) != null) {
            if (s.getType() == 0) {
                s.setMode1D(mode);
            } else if (s.getType() == 1) {
                switch (mode) {
                    case 0: {
                        s.setMode2D(mode, (float)this.wave_point_y);
                        break;
                    }
                    case 1: {
                        s.setMode2D(mode, (float)this.wave_point_x);
                        break;
                    }
                    case 3: {
                        s.setMode2D(mode, (float)this.wave_point_x);
                        break;
                    }
                    case 2: {
                        s.setMode2D(mode, (float)this.wave_point_x);
                    }
                }
                this.sendUpdateEvent();
                this.Autoscale();
            }
        }
        this.not_drawn = true;
        this.repaint();
    }

    public void setSignalMode(int mode) {
        this.setSignalMode(this.curr_point_sig_idx, mode);
    }

    @Override
    protected void ReportLimits(Waveform.ZoomRegion r, boolean add_undo) {
        this.continuosAutoscale = false;
        if (!add_undo) {
            if (this.waveform_signal == null) {
                return;
            }
            ++this.update_timestamp;
            if (this.signals == null) {
                return;
            }
            if (this.orig_signals != null) {
                this.signals = this.orig_signals;
                this.orig_signals = null;
            }
        }
        super.ReportLimits(r, add_undo);
        if (add_undo) {
            this.NotifyZoom(r.start_xs, r.end_xs, r.start_ys, r.end_ys, this.update_timestamp);
        }
    }

    @Override
    public void Autoscale() {
        int i;
        if (this.is_image && this.frames != null) {
            super.Autoscale();
            return;
        }
        if (this.waveform_signal == null) {
            return;
        }
        ++this.update_timestamp;
        this.continuosAutoscale = true;
        if (this.signals == null) {
            return;
        }
        if (this.orig_signals != null) {
            this.signals = this.orig_signals;
            this.orig_signals = null;
        }
        for (i = 0; i < this.signals.size() && this.signals.elementAt(i) == null; ++i) {
        }
        if (i == this.signals.size()) {
            return;
        }
        this.waveform_signal.setMode1D(this.signals.elementAt(i).getMode1D());
        this.waveform_signal.setMode2D(this.signals.elementAt(i).getMode2D());
        this.waveform_signal.unblock();
        boolean firstHit = true;
        for (i = 0; i < this.signals.size(); ++i) {
            if (this.signals.elementAt(i) == null) continue;
            this.signals.elementAt(i).Autoscale();
            if (firstHit) {
                firstHit = false;
                this.waveform_signal.setXLimits(this.signals.elementAt(i).getXmin(), this.signals.elementAt(i).getXmax(), 0);
                this.waveform_signal.setYmin(this.signals.elementAt(i).getYmin(), 0);
                this.waveform_signal.setYmax(this.signals.elementAt(i).getYmax(), 0);
                continue;
            }
            if (!this.signals.elementAt(i).xLimitsInitialized() || this.signals.elementAt(i).getXmin() < this.waveform_signal.getXmin()) {
                this.waveform_signal.setXLimits(this.signals.elementAt(i).getXmin(), this.waveform_signal.getXmax(), 0);
            }
            if (!this.signals.elementAt(i).xLimitsInitialized() || this.signals.elementAt(i).getXmax() > this.waveform_signal.getXmax()) {
                this.waveform_signal.setXLimits(this.waveform_signal.getXmin(), this.signals.elementAt(i).getXmax(), 0);
            }
            if (this.signals.elementAt(i).getYmin() < this.waveform_signal.getYmin()) {
                this.waveform_signal.setYmin(this.signals.elementAt(i).getYmin(), 0);
            }
            if (!(this.signals.elementAt(i).getYmax() > this.waveform_signal.getYmax())) continue;
            this.waveform_signal.setYmax(this.signals.elementAt(i).getYmax(), 0);
        }
        this.ReportChanges();
    }

    @Override
    public void AutoscaleY() {
        if (this.waveform_signal == null) {
            return;
        }
        double prev_xmin = this.waveform_signal.getXmin();
        double prev_xmax = this.waveform_signal.getXmax();
        if (this.signals == null) {
            return;
        }
        double ymin = Double.POSITIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.signals.size(); ++i) {
            if (this.signals.elementAt(i) == null) continue;
            this.signals.elementAt(i).AutoscaleY(prev_xmin, prev_xmax);
            if (this.signals.elementAt(i).getYmin() < ymin) {
                ymin = this.signals.elementAt(i).getYmin();
            }
            if (!(this.signals.elementAt(i).getYmax() > ymax)) continue;
            ymax = this.signals.elementAt(i).getYmax();
        }
        if (ymin >= ymax) {
            ymax = ymin + 2.0 * ymin;
            ymin -= 2.0 * ymin;
        }
        this.waveform_signal.setYmin(ymin, 0);
        this.waveform_signal.setYmax(ymax, 0);
        this.ReportChanges();
    }

    @Override
    public void SetXScale(Waveform w) {
        if (this.waveform_signal == null) {
            return;
        }
        this.waveform_signal.setXLimits(w.waveform_signal.getXmin(), w.waveform_signal.getXmax(), 0);
        for (int i = 0; i < this.signals.size(); ++i) {
            Signal s = this.signals.elementAt(i);
            if (s == null) continue;
            s.setXLimits(w.waveform_signal.getXmin(), w.waveform_signal.getXmax(), 0);
        }
        this.ReportChanges();
    }

    @Override
    public void SetXScaleAutoY(Waveform w) {
        int i;
        if (this.waveform_signal == null) {
            return;
        }
        if (this.signals == null) {
            return;
        }
        if (w != this && this.orig_signals != null) {
            this.signals = this.orig_signals;
            this.orig_signals = new Vector();
            for (i = 0; i < this.signals.size(); ++i) {
                this.orig_signals.addElement(this.signals.elementAt(i));
            }
        }
        this.waveform_signal.setXLimits(w.waveform_signal.getXmin(), w.waveform_signal.getXmax(), 0);
        this.waveform_signal.setFreezeMode(w.waveform_signal.getFreezeMode());
        for (i = 0; i < this.signals.size(); ++i) {
            Signal s = this.signals.elementAt(i);
            if (s == null) continue;
            s.setXLimits(w.waveform_signal.getXmin(), w.waveform_signal.getXmax(), 0);
        }
        this.AutoscaleY();
        ++this.update_timestamp;
        this.asinchAutoscale = true;
        this.NotifyZoom(this.waveform_signal.getXmin(), this.waveform_signal.getXmax(), this.waveform_signal.getYmin(), this.waveform_signal.getYmax(), this.update_timestamp);
    }

    @Override
    public void ResetScales() {
        if (this.signals == null || this.waveform_signal == null) {
            return;
        }
        if (this.orig_signals != null) {
            this.signals = this.orig_signals;
            for (int i = 0; i < this.signals.size(); ++i) {
                if (this.signals.elementAt(i) == null) continue;
                this.signals.elementAt(i).ResetScales();
            }
        }
        this.waveform_signal.ResetScales();
        this.ReportChanges();
    }

    @Override
    protected void NotifyZoom(double start_xs, double end_xs, double start_ys, double end_ys, int timestamp) {
        if (this.orig_signals == null) {
            this.orig_signals = new Vector();
            for (int i = 0; i < this.signals.size(); ++i) {
                this.orig_signals.addElement(this.signals.elementAt(i));
            }
            this.orig_xmin = this.waveform_signal.getXmin();
            this.orig_xmax = this.waveform_signal.getXmax();
        }
    }

    @Override
    protected void HandleCopy() {
    }

    @Override
    protected void HandlePaste() {
    }

    @Override
    public void SetMode(int mod) {
        super.SetMode(mod);
    }

    @Override
    public void signalUpdated(boolean changeLimits) {
        int i;
        this.change_limits = changeLimits;
        this.not_drawn = true;
        boolean anyLongX = false;
        for (i = 1; i < this.signals.size(); ++i) {
            if (this.signals.elementAt(i) == null || !this.signals.elementAt(i).isLongX()) continue;
            anyLongX = true;
            this.waveform_signal.setXLimits(this.signals.elementAt(i).getXmin(), this.waveform_signal.getXmax(), 1);
            break;
        }
        for (i = 1; i < this.signals.size(); ++i) {
            if (this.signals.elementAt(i) == null || anyLongX && !this.signals.elementAt(i).isLongX()) continue;
            if (this.waveform_signal.getXmax() < this.signals.elementAt(i).getXmax()) {
                this.waveform_signal.setXLimits(this.waveform_signal.getXmin(), this.signals.elementAt(i).getXmax(), 0);
            }
            if (this.waveform_signal.getXmin() > this.signals.elementAt(i).getXmin()) {
                this.waveform_signal.setXLimits(this.signals.elementAt(i).getXmin(), this.waveform_signal.getXmax(), 0);
            }
            if (this.waveform_signal.getYmax() < this.signals.elementAt(i).getYmax()) {
                this.waveform_signal.setYmax(this.signals.elementAt(i).getYmax(), 0);
            }
            if (!(this.waveform_signal.getYmin() > this.signals.elementAt(i).getYmin())) continue;
            this.waveform_signal.setYmin(this.signals.elementAt(i).getYmin(), 0);
        }
        this.repaint();
    }
}

