/*
 * Decompiled with CFR 0.152.
 */
package mds.wave;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import mds.wave.MultiWaveform;
import mds.wave.Waveform;

public class RowColumnLayout
implements LayoutManager {
    private int vgap = 0;
    private int hgap = 0;
    private int minWidth = 0;
    private int minHeight = 0;
    private int maxWidth = 0;
    private int maxHeight = 0;
    private int preferredWidth = 0;
    private int preferredHeight = 0;
    private boolean sizeUnknown = true;
    private int column;
    private int b_comp = 0;
    private int[] row;
    private float[] percent_height;
    private float[] percent_width;
    private int resize_mode;
    private int comp_idx;
    private int col_idx;
    private int pos_y;
    private Container main_p;
    static final int NONE = 3;
    static final int VERTICAL = 2;
    static final int HORIZONTAL = 1;
    private int MIN_SIZE_H = 10;
    private int MIN_SIZE_W = 10;
    private int by_pos = 20;
    private int bx_pos = 25;
    private boolean init_resize = true;
    private int prev_col_idx = -1;

    public RowColumnLayout(int[] row) {
        this.SetRowColumn(row, null, null);
    }

    public RowColumnLayout(int[] row, float[] ph, float[] pw) {
        this.SetRowColumn(row, ph, pw);
    }

    public void SetPanelSize(float[] ph, float[] pw) {
        if (ph != null && pw != null) {
            int i;
            if (ph.length < this.b_comp + 1 || pw.length < this.row.length) {
                return;
            }
            this.percent_height = new float[this.b_comp + 1];
            this.percent_width = new float[this.row.length];
            for (i = 0; i < this.b_comp + 1; ++i) {
                this.percent_height[i] = ph[i];
            }
            for (i = 0; i < this.row.length; ++i) {
                this.percent_width[i] = pw[i];
            }
            this.sizeUnknown = false;
        }
    }

    public void SetRowColumn(int[] row, float[] ph, float[] pw) {
        this.SetRowColumn(row);
        this.SetPanelSize(ph, pw);
    }

    public void SetRowColumn(int[] row) {
        this.b_comp = 0;
        this.column = 0;
        this.row = new int[row.length];
        for (int i = 0; i < row.length; ++i) {
            this.row[i] = row[i];
            this.b_comp += row[i];
            if (row[i] == 0) continue;
            ++this.column;
        }
        --this.b_comp;
        this.sizeUnknown = true;
    }

    public float getPercentHeight(int i) {
        if (i < this.percent_height.length) {
            return this.percent_height[i];
        }
        return 0.0f;
    }

    public float getPercentWidth(int i) {
        if (i < this.row.length) {
            return this.percent_width[i];
        }
        return 0.0f;
    }

    public int GetColumns() {
        return this.column;
    }

    public int[] GetRows() {
        return this.row;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    private void setSizes(Container parent) {
        Component c;
        int j;
        int i;
        int nComps = parent.getComponentCount();
        Dimension d = null;
        this.preferredWidth = 0;
        this.preferredHeight = 0;
        this.minWidth = 0;
        this.minHeight = 0;
        if (2 * this.b_comp + 1 != nComps) {
            throw new IllegalArgumentException("Invalid number of component in RowColumnLayout");
        }
        this.percent_height = new float[this.b_comp + 1];
        this.percent_width = new float[this.row.length];
        Dimension min_d = parent.getComponent(this.b_comp + 0).getMinimumSize();
        this.MIN_SIZE_W = min_d.width;
        this.MIN_SIZE_H = min_d.height;
        int k = 0;
        int totW = 0;
        int[] maxW = new int[this.row.length];
        for (i = 0; i < this.row.length; ++i) {
            if (this.row[i] == 0) continue;
            maxW[i] = 0;
            int totH = 0;
            for (j = 0; j < this.row[i]; ++j) {
                if (!(c = parent.getComponent(this.b_comp + k++)).isVisible()) continue;
                d = c.getPreferredSize();
                if (d.height < this.MIN_SIZE_H) {
                    d.height = this.MIN_SIZE_H;
                }
                if (d.width < this.MIN_SIZE_W) {
                    d.width = this.MIN_SIZE_W;
                }
                if (maxW[i] < d.width) {
                    maxW[i] = d.width;
                }
                totH += d.height;
            }
            if (totH > this.preferredHeight) {
                this.preferredHeight = totH;
            }
            totW += maxW[i];
        }
        this.minWidth = this.preferredWidth = totW;
        this.minHeight = this.preferredHeight;
        k = 0;
        for (i = 0; i < this.row.length; ++i) {
            if (this.row[i] == 0) continue;
            for (j = 0; j < this.row[i]; ++j) {
                c = parent.getComponent(this.b_comp + k);
                if (c.isVisible()) {
                    this.percent_height[k] = 1.0f / (float)this.row[i];
                }
                ++k;
            }
            this.percent_width[i] = 1.0f / (float)this.column;
        }
    }

    private void ResetHeight(int col) {
        if (this.row != null && col < this.row.length) {
            int k = 0;
            for (int i = 0; i < col; ++i) {
                k += this.row[i];
            }
            if (this.percent_height != null && k + this.row[col] <= this.percent_height.length) {
                for (int j = 0; j < this.row[col]; ++j) {
                    this.percent_height[k] = 1.0f / (float)this.row[col];
                    ++k;
                }
            }
        }
    }

    private void ResetWidth() {
        if (this.row != null && this.percent_width != null && this.percent_width.length >= this.row.length) {
            for (int i = 0; i < this.row.length; ++i) {
                if (this.row[i] == 0) continue;
                this.percent_width[i] = 1.0f / (float)this.column;
            }
        }
    }

    public void DrawResize(Component _b, int x, int y) {
        Rectangle r;
        int pos;
        int k;
        int i;
        int j;
        Component c = null;
        int idx = 0;
        int num_line = 0;
        if (this.init_resize) {
            this.init_resize = false;
            boolean found = false;
            block0: for (j = 0; j < this.row.length && !found; ++j) {
                for (i = 0; i < this.row[j]; ++i) {
                    Component b = this.main_p.getComponent(idx);
                    if (_b == b) {
                        this.col_idx = j;
                        this.comp_idx = idx;
                        this.resize_mode = i == this.row[j] - 1 ? 1 : 2;
                        found = true;
                        continue block0;
                    }
                    ++idx;
                }
            }
        }
        if (this.resize_mode == 2) {
            int n_draw;
            int jj;
            int start_pos;
            int curr_height;
            int pos_y;
            k = 0;
            for (i = 0; i < this.col_idx + 1; ++i) {
                k += this.row[i];
            }
            if (y < 0) {
                pos_y = pos = y;
                curr_height = 0;
                start_pos = _b.getBounds().y;
                k -= this.row[this.col_idx];
                c = this.main_p.getComponent(this.b_comp + this.comp_idx + 1);
                this.DrawYResize(c, 0, 0, 0);
                j = 0;
                jj = 0;
                i = this.b_comp + this.comp_idx;
                while (i > this.b_comp + k - 1) {
                    c = this.main_p.getComponent(i);
                    r = c.getBounds();
                    if ((curr_height += r.height) + pos < this.MIN_SIZE_H * (num_line + 1)) {
                        ++num_line;
                    }
                    if (start_pos + pos + (k - this.comp_idx - 1) * this.MIN_SIZE_H <= 0) {
                        return;
                    }
                    n_draw = 0;
                    while (jj < num_line + 1 && Math.abs(pos) + jj * this.MIN_SIZE_H < curr_height) {
                        ++n_draw;
                        ++jj;
                    }
                    if (n_draw > 0) {
                        pos_y = r.height + pos - (-curr_height + r.height + (jj - n_draw) * this.MIN_SIZE_H);
                        this.DrawYResize(c, pos_y - 2, n_draw, -this.MIN_SIZE_H);
                    } else {
                        this.DrawYResize(c, 0, 0, 0);
                    }
                    --i;
                    ++j;
                }
            } else {
                pos_y = pos = y;
                curr_height = 0;
                start_pos = _b.getBounds().y;
                c = this.main_p.getComponent(this.b_comp + this.comp_idx);
                this.DrawYResize(c, 0, 0, 0);
                j = 0;
                jj = 0;
                i = this.b_comp + this.comp_idx + 1;
                while (i < this.b_comp + k) {
                    c = this.main_p.getComponent(i);
                    r = c.getBounds();
                    if ((curr_height += r.height) - pos < this.MIN_SIZE_H * (num_line + 1)) {
                        ++num_line;
                    }
                    if (start_pos + pos + (k - this.comp_idx - 1) * this.MIN_SIZE_H > this.maxHeight) {
                        return;
                    }
                    n_draw = 0;
                    while (jj < num_line + 1 && pos + jj * this.MIN_SIZE_H < curr_height) {
                        ++n_draw;
                        ++jj;
                    }
                    if (n_draw > 0) {
                        pos_y = pos - curr_height + r.height + (jj - n_draw) * this.MIN_SIZE_H;
                        this.DrawYResize(c, pos_y - 2, n_draw, this.MIN_SIZE_H);
                    } else {
                        this.DrawYResize(c, 0, 0, 0);
                    }
                    ++i;
                    ++j;
                }
            }
        }
        if (this.resize_mode == 1) {
            idx = x < 0 ? this.col_idx : this.col_idx + 1;
            if (this.prev_col_idx != -1 && this.prev_col_idx != idx) {
                k = 0;
                for (i = 0; i < this.prev_col_idx; ++i) {
                    k += this.row[i];
                }
                for (i = k; i < k + this.row[this.prev_col_idx]; ++i) {
                    c = this.main_p.getComponent(this.b_comp + i);
                    this.DrawXResize(c, 0);
                }
            }
            this.prev_col_idx = idx;
            k = 0;
            for (i = 0; i < idx; ++i) {
                k += this.row[i];
            }
            c = this.main_p.getComponent(this.b_comp + k);
            r = c.getBounds();
            if (x < 0) {
                pos = r.width + x;
                if (pos < this.MIN_SIZE_W) {
                    pos = this.MIN_SIZE_W;
                }
            } else {
                pos = x;
                if (r.width - pos < this.MIN_SIZE_W) {
                    pos = r.width - this.MIN_SIZE_W;
                }
            }
            for (i = k; i < k + this.row[idx]; ++i) {
                c = this.main_p.getComponent(this.b_comp + i);
                this.DrawXResize(c, pos - 2);
            }
        }
    }

    public void ResizeRowColumn(Component _b) {
        int idx = 0;
        this.init_resize = true;
        for (int j = 0; j < this.row.length; ++j) {
            for (int i = 0; i < this.row[j]; ++i) {
                Component b = this.main_p.getComponent(idx);
                if (_b == b) {
                    this.col_idx = j;
                    this.comp_idx = idx;
                    this.resize_mode = i == this.row[j] - 1 ? 1 : 2;
                }
                ++idx;
            }
        }
        if (this.resize_mode == 2) {
            this.ResetHeight(this.col_idx);
            this.ResizeColumn(this.main_p, this.col_idx);
        }
        if (this.resize_mode == 1) {
            this.ResetWidth();
            this.ResizeColumns(this.main_p);
        }
    }

    private int nextColumn(int idx) {
        for (int i = idx + 1; i < this.row.length; ++i) {
            if (this.row[i] == 0) continue;
            return i;
        }
        return -1;
    }

    public void ResizeRowColumn(Component _b, int x, int y) {
        int i;
        int k = 0;
        int currHeight = 0;
        int curr_y = 0;
        int curr_x = 0;
        int idx = 0;
        this.init_resize = true;
        this.prev_col_idx = -1;
        for (int j = 0; j < this.row.length; ++j) {
            for (int i2 = 0; i2 < this.row[j]; ++i2) {
                Component b = this.main_p.getComponent(idx);
                if (_b == b) {
                    Component c = this.main_p.getComponent(this.b_comp + idx);
                    Rectangle d = c.getBounds();
                    Rectangle d1 = b.getBounds();
                    this.col_idx = j;
                    this.comp_idx = idx;
                    this.pos_y = d.y + d.height;
                    x += d1.x;
                    y += d1.y;
                    this.resize_mode = i2 == this.row[j] - 1 ? 1 : 2;
                }
                ++idx;
            }
        }
        for (i = 0; i < this.col_idx; ++i) {
            k += this.row[i];
        }
        if (this.resize_mode == 2) {
            int max_y;
            int inc_comp;
            int end_comp;
            int start_comp;
            if (this.maxHeight < this.row[this.col_idx] * (this.MIN_SIZE_H + this.vgap) - this.vgap) {
                return;
            }
            if (this.pos_y < y) {
                start_comp = k;
                end_comp = k + this.row[this.col_idx];
                inc_comp = 1;
                max_y = this.maxHeight - (this.row[this.col_idx] - (this.comp_idx - k) - 1) * (this.MIN_SIZE_H + this.vgap) + this.vgap;
            } else {
                start_comp = k + this.row[this.col_idx] - 1;
                end_comp = k - 1;
                inc_comp = -1;
                y = this.maxHeight - y;
                ++this.comp_idx;
                max_y = this.maxHeight - (this.comp_idx - k) * (this.MIN_SIZE_H + this.vgap);
            }
            int resize_y = y > max_y ? max_y : y;
            int currMaxHeight = this.maxHeight - (this.row[this.col_idx] - 1) * this.vgap;
            int new_y = 0;
            for (k = start_comp; k != end_comp; k += inc_comp) {
                currHeight = (int)((float)currMaxHeight * this.percent_height[k]);
                this.percent_height[k] = k == this.comp_idx ? (float)(resize_y - curr_y) / (float)currMaxHeight : (curr_y + currHeight - new_y < this.MIN_SIZE_H ? (float)this.MIN_SIZE_H / (float)currMaxHeight : (float)(curr_y + currHeight - new_y) / (float)currMaxHeight);
                curr_y += currHeight + this.vgap;
                new_y += (int)((float)currMaxHeight * this.percent_height[k]) + this.vgap;
            }
            this.ResizeColumn(this.main_p, this.col_idx);
        }
        if (this.resize_mode == 1) {
            if (this.maxWidth < this.column * (this.MIN_SIZE_W + this.hgap) - this.hgap) {
                return;
            }
            int currMaxWidth = this.maxWidth - (this.column - 1) * this.hgap;
            for (i = 0; i < this.col_idx; ++i) {
                curr_x = (int)((float)curr_x + ((float)currMaxWidth * this.percent_width[i] + (float)this.hgap));
            }
            int min_x = curr_x + this.MIN_SIZE_W;
            int max_x = (int)((float)curr_x + (float)currMaxWidth * (this.percent_width[this.col_idx] + this.percent_width[this.nextColumn(this.col_idx)])) + this.hgap;
            if (x < min_x) {
                x = min_x;
            }
            if (x > max_x - this.MIN_SIZE_W) {
                x = max_x - this.MIN_SIZE_W;
            }
            this.percent_width[this.col_idx] = (float)(x - curr_x) / (float)currMaxWidth;
            this.percent_width[this.nextColumn((int)this.col_idx)] = (float)(max_x - x - this.hgap) / (float)currMaxWidth;
            this.ResizeColumns(this.main_p);
        }
    }

    private void ResizeColumns(Container parent) {
        int k = 0;
        int x = 0;
        int previousWidth = 0;
        int currMaxWidth = this.maxWidth - (this.column - 1) * this.hgap;
        int curr_col = 0;
        for (int i = 0; i < this.row.length; ++i) {
            if (this.row[i] == 0) continue;
            int currWidth = (int)((float)currMaxWidth * this.percent_width[i]);
            for (int j = 0; j < this.row[i]; ++j) {
                Component c = parent.getComponent(this.b_comp + k);
                if (c.isVisible()) {
                    Dimension d = c.getSize();
                    x = previousWidth;
                    d.width = currWidth;
                    d.width = curr_col != this.column - 1 ? (int)((float)currMaxWidth * this.percent_width[i]) : this.maxWidth - x;
                    c.setBounds(x, c.getBounds().y, d.width, c.getBounds().height);
                    if (k < this.b_comp) {
                        Component b = parent.getComponent(k);
                        if (j == this.row[i] - 1) {
                            b.setBounds(x + d.width - this.hgap - 2, this.maxHeight - this.bx_pos, 4, 8);
                        } else {
                            int p = this.by_pos;
                            if (d.width < this.by_pos + 8) {
                                p = d.width - 1;
                            }
                            b.setBounds(x + d.width - p, c.getBounds().y + c.getBounds().height - 2, 8, 4);
                        }
                        b.invalidate();
                    }
                }
                ++k;
            }
            previousWidth += currWidth + this.hgap;
            ++curr_col;
        }
    }

    private void ResizeColumn(Container parent, int col_idx) {
        int k = 0;
        int y = 0;
        int previousHeight = 0;
        for (int i = 0; i < col_idx; ++i) {
            k += this.row[i];
        }
        int currMaxHeight = this.maxHeight - (this.row[col_idx] - 1) * this.vgap;
        for (int j = 0; j < this.row[col_idx]; ++j) {
            Component c = parent.getComponent(this.b_comp + k);
            if (c.isVisible()) {
                Dimension d = c.getSize();
                d.height = (int)((float)currMaxHeight * this.percent_height[k]);
                d.height = j != this.row[col_idx] - 1 ? (int)((float)currMaxHeight * this.percent_height[k]) : this.maxHeight - (y += previousHeight);
                c.setBounds(c.getBounds().x, y, c.getBounds().width, d.height);
                previousHeight = d.height + this.vgap;
                if (k < this.b_comp) {
                    Component b = parent.getComponent(k);
                    if (j == this.row[col_idx] - 1) {
                        b.setBounds(c.getBounds().x + c.getBounds().width - this.hgap - 2, this.maxHeight - this.bx_pos, 4, 8);
                    } else {
                        int p = this.by_pos;
                        if (d.width < this.by_pos + 8) {
                            p = d.width - 1;
                        }
                        b.setBounds(c.getBounds().x + c.getBounds().width - p, y + d.height - 2, 8, 4);
                    }
                }
            }
            ++k;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        this.setSizes(parent);
        Insets insets = parent.getInsets();
        dim.width = this.preferredWidth + insets.left + insets.right;
        dim.height = this.preferredHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dim;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        Insets insets = parent.getInsets();
        dim.width = this.minWidth + insets.left + insets.right;
        dim.height = this.minHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dim;
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        this.maxWidth = parent.getSize().width - (insets.left + insets.right);
        this.maxHeight = parent.getSize().height - (insets.top + insets.bottom);
        this.main_p = parent;
        if (this.maxWidth <= 0 || this.maxHeight <= 0) {
            return;
        }
        if (this.sizeUnknown) {
            this.setSizes(parent);
            this.sizeUnknown = false;
        }
        this.ResizeColumns(parent);
        for (int i = 0; i < this.row.length; ++i) {
            this.ResizeColumn(parent, i);
        }
    }

    private void DrawXResize(Component c, int x) {
        if (!(c instanceof Waveform) && !(c instanceof MultiWaveform)) {
            return;
        }
        Dimension d = c.getSize();
        Graphics g = c.getGraphics();
        c.paint(g);
        g.drawLine(x, 0, x, d.height);
        g.dispose();
    }

    private void DrawYResize(Component c, int y, int n_line, int space) {
        if (!(c instanceof Waveform) && !(c instanceof MultiWaveform)) {
            return;
        }
        Dimension d = c.getSize();
        Graphics g = c.getGraphics();
        c.paint(g);
        for (int i = 0; i < n_line; ++i) {
            g.drawLine(0, y + i * space, d.width, y + i * space);
        }
        g.dispose();
    }

    public String toString() {
        String str = "";
        return this.getClass().getName() + "[vgap=" + this.vgap + str + "]";
    }

    public float[] getPercentHeight() {
        return this.percent_height;
    }

    public float[] getPercentWidth() {
        return this.percent_width;
    }
}

