/*
 * Decompiled with CFR 0.152.
 */
package mds.wave;

import java.awt.AWTEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import mds.wave.Waveform;

public class WaveformEvent
extends AWTEvent {
    public static final int POINT_UPDATE = 2000;
    public static final int MEASURE_UPDATE = 2001;
    public static final int STATUS_INFO = 2002;
    public static final int BROADCAST_SCALE = 2003;
    public static final int COPY_PASTE = 2004;
    public static final int COPY_CUT = 2005;
    public static final int EVENT_UPDATE = 2006;
    public static final int PROFILE_UPDATE = 2007;
    public static final int POINT_IMAGE_UPDATE = 2008;
    public static final int START_UPDATE = 2009;
    public static final int END_UPDATE = 2010;
    public static final int CACHE_DATA = 2011;
    int frame_type;
    public int signal_idx;
    int pixel_value;
    float point_value;
    double point_x;
    double point_y;
    double delta_x;
    double delta_y;
    String name;
    public String status_info;
    int[] pixels_x;
    float[] values_x;
    int start_pixel_x;
    int[] pixels_y;
    float[] values_y;
    int start_pixel_y;
    int[] pixels_signal;
    float[] values_signal;
    int[] pixels_line = null;
    float[] values_line = null;
    float[] frames_time;
    float x_value = Float.NaN;
    double time_value = Double.NaN;
    double data_value = Double.NaN;
    boolean is_mb2 = false;
    private long dateValue;
    boolean showXasDate = false;
    int x_pixel;
    int y_pixel;

    public WaveformEvent(Object source, int event_id, String status_info) {
        super(source, event_id);
        this.status_info = status_info;
    }

    public WaveformEvent(Object source, int event_id) {
        super(source, event_id);
    }

    public WaveformEvent(Object source, String status_info) {
        super(source, 2002);
        this.status_info = status_info;
    }

    public WaveformEvent(Object source, int event_id, double point_x, double point_y, double delta_x, double delta_y, int pixel_value, int signal_idx) {
        super(source, event_id);
        this.signal_idx = signal_idx;
        this.point_x = point_x;
        this.point_y = point_y;
        this.delta_x = delta_x;
        this.delta_y = delta_y;
        this.pixel_value = pixel_value;
    }

    public void setPointValue(float val) {
        this.point_value = val;
    }

    public void setDateValue(long date) {
        long dayMilliSeconds = 86400000L;
        this.dateValue = date - date % dayMilliSeconds;
        this.showXasDate = true;
    }

    public float getPointValue() {
        return this.point_value;
    }

    public void setFrameType(int frame_type) {
        this.frame_type = frame_type;
    }

    public WaveformEvent(Object source, int x_pixel, int y_pixel, float frame_time, String name, int[] pixels_x, int start_pixel_x, int[] pixels_y, int start_pixel_y) {
        super(source, 2007);
        this.x_pixel = x_pixel;
        this.y_pixel = y_pixel;
        this.time_value = frame_time;
        this.name = name;
        this.pixels_x = pixels_x;
        this.pixels_y = pixels_y;
        this.pixels_signal = this.pixels_signal;
        this.frames_time = this.frames_time;
        this.start_pixel_x = start_pixel_x;
        this.start_pixel_y = start_pixel_y;
    }

    public WaveformEvent(Object source, int x_pixel, int y_pixel, float frame_time, String name, float[] values_x, int start_pixel_x, float[] values_y, int start_pixel_y) {
        super(source, 2007);
        this.x_pixel = x_pixel;
        this.y_pixel = y_pixel;
        this.time_value = frame_time;
        this.name = name;
        this.values_x = values_x;
        this.values_y = values_y;
        this.values_signal = this.values_signal;
        this.frames_time = this.frames_time;
        this.start_pixel_x = start_pixel_x;
        this.start_pixel_y = start_pixel_y;
    }

    public void setIsMB2(boolean is_mb2) {
        this.is_mb2 = is_mb2;
    }

    public void setPixelsLine(int[] p_line) {
        this.pixels_line = p_line;
    }

    public void setValuesLine(float[] v_line) {
        this.values_line = v_line;
    }

    public void setXValue(float x_value) {
        this.x_value = x_value;
    }

    public void setTimeValue(double time_value) {
        this.time_value = time_value;
    }

    public void setDataValue(double data_value) {
        this.data_value = data_value;
    }

    private String SetStrSize(String s, int size) {
        StringBuffer sb = new StringBuffer(size);
        sb.append(s.substring(0, s.length() < size ? s.length() : size));
        if (sb.length() < size) {
            for (int i = sb.length(); i < size; ++i) {
                sb.append(" ");
            }
        }
        return new String(sb);
    }

    private String getFormattedDate(long d, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Date date = new Date();
        date.setTime(Math.abs(d));
        if (d <= 86400000L) {
            dateFormat = new SimpleDateFormat("H:mm:ss.SSS");
            dateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
            return dateFormat.format(date).toString();
        }
        return dateFormat.format(date).toString();
    }

    @Override
    public String toString() {
        String s = null;
        int event_id = this.getID();
        Waveform w = (Waveform)this.getSource();
        switch (event_id) {
            case 2001: {
                double dx_f = Math.abs(this.delta_x) < 1.0E-20 ? 1.0E-20 : Math.abs(this.delta_x);
                if (this.showXasDate) {
                    this.point_x = Waveform.convertFromSpecificTime((long)this.point_x);
                    this.delta_x = Waveform.convertFromSpecificDeltaTime((long)this.delta_x);
                    s = this.SetStrSize("[" + this.getFormattedDate(this.dateValue + (long)this.point_x, "d-MMM-yyyy HH:mm:ss.SSS") + ", " + Waveform.ConvertToString(this.point_y, false) + "; dx " + this.getFormattedDate((long)this.delta_x, "HHH:mm:ss.SSS") + "; dy " + Waveform.ConvertToString(this.delta_y, false) + "]", 90);
                } else {
                    s = this.SetStrSize("[" + Waveform.ConvertToString(this.point_x, false) + ", " + Waveform.ConvertToString(this.point_y, false) + "; dx " + Waveform.ConvertToString(this.delta_x, false) + "; dy " + Waveform.ConvertToString(this.delta_y, false) + "; 1/dx " + Waveform.ConvertToString(1.0 / dx_f, false) + "]", 90);
                }
            }
            case 2000: 
            case 2008: {
                if (s != null) break;
                if (!w.IsImage()) {
                    String xt_string = null;
                    if (!Float.isNaN(this.x_value)) {
                        xt_string = ", Y = " + Waveform.ConvertToString(this.x_value, false);
                    } else if (!Double.isNaN(this.time_value)) {
                        if (this.showXasDate) {
                            this.time_value = Waveform.convertFromSpecificTime((long)this.time_value);
                            xt_string = ", T = " + this.getFormattedDate((long)this.time_value, "d-MMM-yyyy HH:mm:ss.SSS");
                            this.showXasDate = false;
                        } else {
                            xt_string = ", X = " + Waveform.ConvertToString(this.time_value, false);
                        }
                    } else if (!Double.isNaN(this.data_value)) {
                        xt_string = ", Z = " + Waveform.ConvertToString(this.data_value, false);
                    }
                    String x_string = null;
                    int string_size = 40;
                    if (this.showXasDate) {
                        this.point_x = Waveform.convertFromSpecificTime((long)this.point_x);
                        x_string = this.getFormattedDate((long)this.point_x, "d-MMM-yyyy HH:mm:ss.SSS");
                        string_size = 45;
                    } else {
                        x_string = Double.toString(this.point_x);
                    }
                    if (xt_string == null) {
                        s = this.SetStrSize("[" + x_string + ", " + this.point_y + "]", string_size);
                        break;
                    }
                    s = this.SetStrSize("[" + x_string + ", " + this.point_y + xt_string + "]", string_size + 40);
                    break;
                }
                s = this.frame_type == 5 || this.frame_type == 6 || this.frame_type == 3 || this.frame_type == 4 || this.frame_type == 7 ? this.SetStrSize("[" + (int)this.point_x + ", " + (int)this.point_y + " : (" + this.point_value + ") : " + this.delta_x + "]", 50) : this.SetStrSize("[" + (int)this.point_x + ", " + (int)this.point_y + " : (" + (this.pixel_value >> 16 & 0xFF) + "," + (this.pixel_value >> 8 & 0xFF) + "," + (this.pixel_value & 0xFF) + ") : " + this.delta_x + "]", 50);
            }
        }
        return s == null ? "" : s;
    }
}

