/*
 * Decompiled with CFR 0.152.
 */
package mds.provider;

import MDSplus.Connection;
import MDSplus.Data;
import MDSplus.DataStreamListener;
import MDSplus.Int64;
import MDSplus.Int64Array;
import MDSplus.Uint64;
import MDSplus.Uint64Array;
import java.util.Vector;
import mds.provider.MdsDataProvider;
import mds.wave.WaveDataListener;

public class MdsDataProviderStream
extends MdsDataProvider {
    private final Vector<Connection> activeConnections = new Vector();
    Connection conn = null;

    @Override
    public MdsDataProvider.AsyncDataSource getAsynchSource() {
        return new AsynchWaveData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetPrevious() {
        Vector<Connection> vector = this.activeConnections;
        synchronized (vector) {
            for (Connection connection : this.activeConnections) {
                connection.disconnect();
            }
            this.activeConnections.clear();
        }
    }

    class AsynchWaveData
    implements MdsDataProvider.AsyncDataSource,
    DataStreamListener {
        boolean listenerReady = false;
        Vector<Data> samplesV = new Vector();
        Vector<Data> timesV = new Vector();
        double sinePeriod = 1.0;
        Vector<WaveDataListener> listeners = new Vector();

        AsynchWaveData() {
        }

        @Override
        public void addDataListener(WaveDataListener listener) {
            this.listeners.addElement(listener);
            for (int i = 0; i < this.samplesV.size(); ++i) {
                this.handleDataReceived(this.samplesV.elementAt(i), this.timesV.elementAt(i));
            }
            this.listenerReady = true;
        }

        public void dataReceived(Data samples, Data times) {
            if (!this.listenerReady) {
                this.samplesV.addElement(samples);
                this.timesV.addElement(times);
            }
            this.handleDataReceived(samples, times);
        }

        public void handleDataReceived(Data samples, Data times) {
            try {
                float[] y = samples.getFloatArray();
                if (times instanceof Int64Array || times instanceof Int64 || times instanceof Uint64Array || times instanceof Uint64) {
                    long[] x = times.getLongArray();
                    for (int j = 0; j < this.listeners.size(); ++j) {
                        this.listeners.elementAt(j).dataRegionUpdated(x, y, (double)Double.MAX_VALUE);
                    }
                } else {
                    double[] x = times.getDoubleArray();
                    int dataLen = x.length;
                    if (dataLen > y.length) {
                        dataLen = y.length;
                    }
                    if (dataLen != x.length) {
                        double[] newX = new double[dataLen];
                        System.arraycopy(x, 0, newX, 0, dataLen);
                        x = newX;
                    }
                    if (dataLen != y.length) {
                        float[] newY = new float[dataLen];
                        System.arraycopy(y, 0, newY, 0, dataLen);
                        y = newY;
                    }
                    for (int j = 0; j < this.listeners.size(); ++j) {
                        this.listeners.elementAt(j).dataRegionUpdated(x, y, Double.MAX_VALUE);
                    }
                }
            }
            catch (Exception exc) {
                System.out.println("Error handling streaming: " + exc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startGeneration(String expression) {
            try {
                Connection conn = new Connection(MdsDataProviderStream.this.getProvider());
                Vector vector = MdsDataProviderStream.this.activeConnections;
                synchronized (vector) {
                    MdsDataProviderStream.this.activeConnections.addElement(conn);
                }
                conn.registerStreamListener((DataStreamListener)this, expression, MdsDataProviderStream.this.experiment, (int)MdsDataProviderStream.this.shot);
                conn.startStreaming();
            }
            catch (Exception exc) {
                System.out.println("Cannot connect to " + MdsDataProviderStream.this.getProvider());
            }
        }
    }
}

