/*
 * Decompiled with CFR 0.152.
 */
package MDSplus;

import MDSplus.Array;
import MDSplus.Data;
import MDSplus.DataStreamListener;
import MDSplus.Event;
import MDSplus.Float32;
import MDSplus.Float32Array;
import MDSplus.MdsException;
import MDSplus.Scalar;
import MDSplus.Uint64;
import MDSplus.Uint64Array;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class EventStream
extends Event {
    String streamName;
    Hashtable<String, Vector<DataStreamListener>> listenerHash = new Hashtable();

    public EventStream() throws MdsException {
        super("STREAMING");
    }

    public synchronized void registerListener(String streamName, DataStreamListener listener) {
        Vector<DataStreamListener> listenerV = this.listenerHash.get(streamName);
        if (listenerV == null) {
            listenerV = new Vector();
        }
        listenerV.addElement(listener);
        this.listenerHash.put(streamName, listenerV);
    }

    public static void send(int shot, String streamName, float time, float sample) {
        String msgString = "" + shot + " " + streamName + " F 1 " + time + " " + sample;
        EventStream.seteventRaw("STREAMING", msgString.getBytes());
    }

    public static void send(int shot, String streamName, long time, float sample) {
        String msgString = "" + shot + " " + streamName + " L 1 " + time + " " + sample;
        EventStream.seteventRaw("STREAMING", msgString.getBytes());
    }

    public static void send(int shot, String streamName, float[] times, float[] samples, boolean oscilloscopeMode) {
        int i;
        int numSamples = times.length;
        if (numSamples > samples.length) {
            numSamples = samples.length;
        }
        String msgString = oscilloscopeMode ? "" + shot + " " + streamName + " A " + numSamples : "" + shot + " " + streamName + " F " + numSamples;
        for (i = 0; i < numSamples; ++i) {
            msgString = msgString + " " + times[i];
        }
        for (i = 0; i < numSamples; ++i) {
            msgString = msgString + " " + samples[i];
        }
        EventStream.seteventRaw("STREAMING", msgString.getBytes());
    }

    public static void send(int shot, String streamName, float[] times, float[] samples) {
        EventStream.send(shot, streamName, times, samples, false);
    }

    public static void send(int shot, String streamName, long[] times, float[] samples, boolean oscilloscopeMode) {
        int i;
        int numSamples = times.length;
        if (numSamples > samples.length) {
            numSamples = samples.length;
        }
        String msgString = "" + shot + " " + streamName + " L " + numSamples;
        for (i = 0; i < numSamples; ++i) {
            msgString = msgString + " " + times[i];
        }
        for (i = 0; i < numSamples; ++i) {
            msgString = msgString + " " + samples[i];
        }
        EventStream.seteventRaw("STREAMING", msgString.getBytes());
    }

    @Override
    public synchronized void run() {
        String evName = this.getName();
        if (!evName.equals("STREAMING")) {
            return;
        }
        String evMessage = new String(this.getRaw());
        StringTokenizer st = new StringTokenizer(evMessage);
        try {
            int shot = Integer.parseInt(st.nextToken());
            String streamName = st.nextToken();
            Vector<DataStreamListener> listeners = this.listenerHash.get(streamName);
            if (listeners != null && listeners.size() > 0) {
                String mode = st.nextToken();
                int numSamples = Integer.parseInt(st.nextToken());
                if (numSamples == 1) {
                    Scalar timeD = mode.equals("A") || mode.equals("F") ? new Float32(Float.parseFloat(st.nextToken())) : new Uint64(Long.parseLong(st.nextToken()));
                    Float32 sampleD = new Float32(Float.parseFloat(st.nextToken()));
                    for (int i = 0; i < listeners.size(); ++i) {
                        DataStreamListener listener = listeners.elementAt(i);
                        listener.dataReceived(streamName, shot, timeD, sampleD);
                    }
                } else {
                    Array timesD;
                    int i;
                    Object[] times;
                    if (mode.equals("A") || mode.equals("F")) {
                        times = new float[numSamples];
                        for (i = 0; i < numSamples; ++i) {
                            times[i] = Float.parseFloat(st.nextToken());
                        }
                        timesD = new Float32Array((float[])times);
                    } else {
                        times = new long[numSamples];
                        for (i = 0; i < numSamples; ++i) {
                            times[i] = Long.parseLong(st.nextToken());
                        }
                        timesD = new Uint64Array((long[])times);
                    }
                    float[] samples = new float[numSamples];
                    for (i = 0; i < numSamples; ++i) {
                        samples[i] = Float.parseFloat(st.nextToken());
                    }
                    Float32Array samplesD = new Float32Array(samples);
                    for (i = 0; i < listeners.size(); ++i) {
                        listeners.elementAt(i).dataReceived(streamName, shot, timesD, samplesD);
                    }
                }
            }
        }
        catch (Exception exc) {
            System.out.println("Error getting data from stream: " + exc);
        }
    }

    public static void main(String[] args) {
        try {
            EventStream es = new EventStream();
            es.registerListener("TestStream", new DataStreamListener(){

                @Override
                public void dataReceived(String streamName, int shot, Data times, Data samples) {
                    System.out.println(streamName + " Time: " + times + "Sample: " + samples);
                }
            });
            Thread.currentThread();
            Thread.sleep(1000000L);
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
    }
}

