/*
 * Decompiled with CFR 0.152.
 */
package mds.provider;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import mds.connection.ConnectionEvent;
import mds.connection.ConnectionListener;
import mds.connection.Descriptor;
import mds.connection.MdsConnection;
import mds.connection.UpdateEventListener;
import mds.provider.mds.SshTunneling;
import mds.wave.DataProvider;
import mds.wave.DataServerItem;
import mds.wave.FrameData;
import mds.wave.Frames;
import mds.wave.WaveData;
import mds.wave.WaveDataListener;
import mds.wave.Waveform;
import mds.wave.XYData;

public class MdsDataProvider
implements DataProvider {
    static final long RESAMPLE_TRESHOLD = 1000000000L;
    static final int MAX_PIXELS = 20000;
    static boolean debug = false;
    protected String provider;
    protected String experiment;
    private String prev_default_node = null;
    private String default_node = null;
    private String environment_vars;
    protected long shot;
    protected boolean open;
    protected boolean connected;
    protected final MdsConnection mds;
    protected String error;
    protected boolean use_compression = false;
    protected int var_idx = 0;
    private boolean is_tunneling = false;
    private String tunnel_provider = "127.0.0.1:8000";
    private SshTunneling ssh_tunneling = null;
    UpdateWorker updateWorker;

    public MdsDataProvider() {
        this.experiment = null;
        this.shot = 0L;
        this.connected = false;
        this.open = false;
        this.mds = this.getConnection();
        this.error = null;
    }

    public MdsDataProvider(String provider) {
        this.setProvider(provider);
        this.experiment = null;
        this.shot = 0L;
        this.connected = false;
        this.open = false;
        this.mds = this.getConnection(this.provider);
        this.error = null;
    }

    public MdsDataProvider(String exp, int s) {
        this.experiment = exp;
        this.shot = 0L;
        this.connected = false;
        this.open = false;
        this.mds = this.getConnection();
        this.error = null;
    }

    @Override
    public synchronized void addConnectionListener(ConnectionListener l) {
        if (this.mds != null) {
            this.mds.addConnectionListener(l);
        }
    }

    @Override
    public synchronized void addUpdateEventListener(UpdateEventListener l, String event_name) throws IOException {
        if (event_name == null || event_name.trim().length() == 0) {
            return;
        }
        this.CheckConnection();
        this.mds.MdsSetEvent(l, event_name);
    }

    protected synchronized void CheckConnection() throws IOException {
        if (!this.connected) {
            if (this.mds.ConnectToMds(this.use_compression) == 0) {
                if (this.mds.error != null) {
                    throw new IOException(this.mds.error);
                }
                throw new IOException("Could not get IO for " + this.provider);
            }
            this.connected = true;
            this.updateWorker = new UpdateWorker();
            this.updateWorker.start();
        }
    }

    protected synchronized boolean CheckOpen() throws IOException {
        return this.CheckOpen(this.experiment, this.shot, null);
    }

    protected synchronized boolean CheckOpen(String experiment, long shot, String defaultNode) throws IOException {
        Descriptor descr;
        if (!this.connected) {
            int status = this.mds.ConnectToMds(this.use_compression);
            if (status == 0) {
                if (this.mds.error != null) {
                    throw new IOException("Cannot connect to data server : " + this.mds.error);
                }
                this.error = "Cannot connect to data server";
                return false;
            }
            this.connected = true;
            this.updateWorker = new UpdateWorker();
            this.updateWorker.start();
        }
        if (!this.open && experiment != null || this.shot != shot || experiment != null && !experiment.equalsIgnoreCase(this.experiment)) {
            descr = this.mds.MdsValue("JavaOpen(\"" + experiment + "\"," + shot + ")", new Descriptor[0]);
            if (descr.dtype != 14 && descr.dtype == 8 && descr.int_data != null && descr.int_data.length > 0 && descr.int_data[0] % 2 == 1) {
                this.open = true;
                this.shot = shot;
                this.experiment = experiment;
                Descriptor descr1 = this.mds.MdsValue("setenv('MDSPLUS_DEFAULT_RESAMPLE_MODE=MinMax')", new Descriptor[0]);
                switch (descr1.dtype) {
                    case 14: {
                        if ((descr1.status & 1) != 0) break;
                        this.error = descr1.error;
                        return false;
                    }
                }
                if (this.environment_vars != null && this.environment_vars.length() > 0) {
                    this.SetEnvironmentSpecific(this.environment_vars);
                    if (this.error != null) {
                        this.error = "Public variable evaluation error " + experiment + " shot " + shot + " : " + this.error;
                        return false;
                    }
                }
            } else {
                this.error = this.mds.error != null ? "Cannot open experiment " + experiment + " shot " + shot + " : " + this.mds.error : "Cannot open experiment " + experiment + " shot " + shot;
                return false;
            }
        }
        if (this.open) {
            if (!(defaultNode == null || this.prev_default_node != null && defaultNode.equals(this.prev_default_node))) {
                descr = this.default_node.trim().charAt(0) == '\\' ? this.mds.MdsValue("TreeSetDefault(\"\\" + defaultNode + "\")", new Descriptor[0]) : this.mds.MdsValue("TreeSetDefault(\"\\\\" + defaultNode + "\")", new Descriptor[0]);
                this.prev_default_node = defaultNode;
                if ((descr.int_data[0] & 1) == 0) {
                    this.mds.MdsValue("TreeSetDefault(\"\\\\::TOP\")", new Descriptor[0]);
                    this.prev_default_node = null;
                }
            } else if (defaultNode == null && this.prev_default_node != null) {
                this.mds.MdsValue("TreeSetDefault(\"\\\\::TOP\")", new Descriptor[0]);
                this.prev_default_node = null;
            }
        }
        return true;
    }

    @Override
    public synchronized void close() {
        if (this.is_tunneling && this.ssh_tunneling != null) {
            this.ssh_tunneling.close();
        }
        if (this.connected) {
            this.connected = false;
            this.mds.DisconnectFromMds();
            ConnectionEvent ce = new ConnectionEvent((Object)this, 2000, "Lost connection from : " + this.provider);
            this.mds.dispatchConnectionEvent(ce);
        }
        if (this.updateWorker != null && this.updateWorker.isAlive()) {
            this.updateWorker.stopUpdateWorker();
        }
    }

    protected void dispatchConnectionEvent(ConnectionEvent e) {
        if (this.mds != null) {
            this.mds.dispatchConnectionEvent(e);
        }
    }

    public void enableAsyncUpdate(boolean enable) {
        this.updateWorker.enableAsyncUpdate(enable);
    }

    protected void finalize() {
        if (this.open) {
            this.mds.MdsValue("JavaClose(\"" + this.experiment + "\"," + this.shot + ")", new Descriptor[0]);
        }
        if (this.connected) {
            this.mds.DisconnectFromMds();
        }
    }

    public synchronized byte[] GetAllFrames(String in_frame) throws IOException {
        int pixel_size = 8;
        int num_time = 0;
        if (!this.CheckOpen()) {
            return null;
        }
        String in = "DIM_OF( _jScope_img = (" + in_frame + "), 2)";
        float[] time = this.GetFloatArray(in);
        if ((time == null || time.length >= 2 && (double)time[1] == 1.0) && (time = this.GetFloatArray(in = "DIM_OF( _jScope_img )")) == null) {
            return null;
        }
        in = "eshape(data( _jScope_img ))";
        int[] shape = this.getIntArray(in);
        if (shape == null) {
            return null;
        }
        in = "_jScope_img";
        byte[] img_buf = this.GetByteArray(in);
        if (img_buf == null) {
            return null;
        }
        if (shape.length == 3) {
            num_time = shape[2];
            pixel_size = img_buf.length / (shape[0] * shape[1] * shape[2]) * 8;
        } else if (shape.length == 2) {
            num_time = 1;
            pixel_size = img_buf.length / (shape[0] * shape[1]) * 8;
        } else if (shape.length == 1) {
            throw new IOException("The evaluated signal is not an image");
        }
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try (DataOutputStream d = new DataOutputStream(b);){
            d.writeInt(pixel_size);
            d.writeInt(shape[0]);
            d.writeInt(shape[1]);
            d.writeInt(num_time);
            for (int i = 0; i < num_time; ++i) {
                d.writeFloat(time[i]);
            }
            d.write(img_buf);
            byte[] byArray = b.toByteArray();
            return byArray;
        }
    }

    public AsyncDataSource getAsynchSource() {
        return null;
    }

    public synchronized byte[] GetByteArray(String in) throws IOException {
        return this.GetByteArray(in, null);
    }

    public synchronized byte[] GetByteArray(String in, Vector<Descriptor> args) throws IOException {
        if (debug) {
            System.out.println("GetByteArray " + in);
        }
        byte[] out_byte = null;
        ByteArrayOutputStream dosb = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(dosb);
        if (!this.CheckOpen()) {
            return null;
        }
        Descriptor desc = args == null ? this.mds.MdsValue(in, new Descriptor[0]) : this.mds.MdsValue(in, args);
        switch (desc.dtype) {
            case 10: {
                for (float element : desc.float_data) {
                    dos.writeFloat(element);
                }
                out_byte = dosb.toByteArray();
                return out_byte;
            }
            case 3: 
            case 7: {
                for (short element : desc.short_data) {
                    dos.writeShort(element);
                }
                out_byte = dosb.toByteArray();
                return out_byte;
            }
            case 8: {
                for (int element : desc.int_data) {
                    dos.writeInt(element);
                }
                out_byte = dosb.toByteArray();
                return out_byte;
            }
            case 2: 
            case 6: {
                return desc.byte_data;
            }
            case 14: {
                if ((desc.status & 1) != 0) break;
                this.error = desc.error;
                throw new IOException(this.error);
            }
        }
        throw new IOException(this.error);
    }

    protected MdsConnection getConnection() {
        return new MdsConnection();
    }

    protected MdsConnection getConnection(String arg) {
        return new MdsConnection(arg);
    }

    public double[] GetDoubleArray(String in) throws IOException {
        RealArray realArray;
        if (debug) {
            System.out.println("GetDoubleArray " + in);
        }
        if ((realArray = this.GetRealArray(in)) == null) {
            return null;
        }
        return realArray.getDoubleArray();
    }

    @Override
    public synchronized String getError() {
        return this.error;
    }

    protected String GetExperimentName(String in_frame) {
        String exp = this.experiment == null ? (in_frame.indexOf(".") == -1 ? in_frame : in_frame.substring(0, in_frame.indexOf("."))) : this.experiment;
        return exp;
    }

    @Override
    public synchronized double getFloat(String in, int row, int col, int index) throws IOException {
        this.error = null;
        if (debug) {
            System.out.println("GetFloat " + in);
        }
        try {
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat("d-MMM-yyyy HH:mm Z");
            Date date = df.parse(in + " GMT");
            cal.setTime(date);
            long javaTime = cal.getTime().getTime();
            return javaTime;
        }
        catch (Exception exc) {
            try {
                return this.GetNow(in);
            }
            catch (Exception df) {
                if (this.NotYetNumber(in)) {
                    if (!this.CheckOpen()) {
                        return 0.0;
                    }
                    Descriptor desc = row != -1 ? this.mds.MdsValue("( _ROW = " + row + "; _COLUMN = " + col + "; _INDEX = " + index + "; " + in + " ; )", new Descriptor[0]) : this.mds.MdsValue(in, new Descriptor[0]);
                    if (desc.error != null) {
                        this.error = desc.error;
                    }
                    switch (desc.dtype) {
                        case 11: {
                            return desc.double_data[0];
                        }
                        case 10: {
                            return desc.float_data[0];
                        }
                        case 8: {
                            return desc.int_data[0];
                        }
                        case 6: {
                            return desc.byte_data[0];
                        }
                        case 2: {
                            int currShort = 0;
                            currShort = (short)(currShort | desc.byte_data[0] & 0xFF);
                            return currShort;
                        }
                        case 14: {
                            if ((desc.status & 1) == 0) {
                                this.error = desc.error;
                                throw new IOException(this.error);
                            }
                            return 0.0;
                        }
                    }
                } else {
                    return Float.parseFloat(in);
                }
                return 0.0;
            }
        }
    }

    public float[] GetFloatArray(String in) throws IOException {
        RealArray realArray;
        if (debug) {
            System.out.println("GetFloatArray " + in);
        }
        if ((realArray = this.GetRealArray(in)) == null) {
            return null;
        }
        return realArray.getFloatArray();
    }

    public byte[] GetFrameAt(String in_frame, int frame_idx) throws IOException {
        if (debug) {
            System.out.println("GetFrameAt " + in_frame + "  " + frame_idx);
        }
        String exp = this.GetExperimentName(in_frame);
        String in = "JavaGetFrameAt(\"" + exp + "\",\" " + in_frame + "\"," + this.shot + ", " + frame_idx + " )";
        return this.GetByteArray(in);
    }

    @Override
    public FrameData getFrameData(String in_y, String in_x, float time_min, float time_max) throws IOException {
        int[] numSegments = null;
        try {
            numSegments = this.getIntArray("GetNumSegments(" + in_y + ")");
        }
        catch (Exception exc) {
            this.error = null;
        }
        if (numSegments != null && numSegments[0] > 0) {
            return new SegmentedFrameData(in_y, in_x, time_min, time_max, numSegments[0]);
        }
        try {
            return new SimpleFrameData(in_y, in_x, time_min, time_max);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public synchronized float[] GetFrameTimes(String in_frame) {
        String exp = this.GetExperimentName(in_frame);
        String in = "JavaGetFrameTimes(\"" + exp + "\",\"" + in_frame + "\"," + this.shot + " )";
        Descriptor desc = this.mds.MdsValue(in, new Descriptor[0]);
        switch (desc.dtype) {
            case 10: {
                return desc.float_data;
            }
            case 8: {
                float[] out_data = new float[desc.int_data.length];
                for (int i = 0; i < desc.int_data.length; ++i) {
                    out_data[i] = desc.int_data[i];
                }
                return out_data;
            }
            case 6: {
                this.error = "Cannot convert byte array to float array";
                return null;
            }
            case 14: {
                if ((desc.status & 1) == 0) {
                    this.error = desc.error;
                }
                return null;
            }
        }
        return null;
    }

    public int[] getIntArray(String in) throws IOException {
        if (debug) {
            System.out.println("GetIntArray " + in);
        }
        if (in == null) {
            return null;
        }
        if (!this.CheckOpen()) {
            throw new IOException("Tree not open");
        }
        return this.getIntegerArray(in);
    }

    private synchronized int[] getIntegerArray(String in) throws IOException {
        if (debug) {
            System.out.println("GetIntegerArray " + in);
        }
        Descriptor desc = this.mds.MdsValue(in, new Descriptor[0]);
        switch (desc.dtype) {
            case 8: {
                return desc.int_data;
            }
            case 10: {
                int[] out_data = new int[desc.float_data.length];
                for (int i = 0; i < desc.float_data.length; ++i) {
                    out_data[i] = (int)((double)desc.float_data[i] + 0.5);
                }
                return out_data;
            }
            case 2: 
            case 6: {
                int[] out_data = new int[desc.byte_data.length];
                for (int i = 0; i < desc.byte_data.length; ++i) {
                    out_data[i] = (int)((double)desc.byte_data[i] + 0.5);
                }
                return out_data;
            }
            case 14: {
                if ((desc.status & 1) == 0) {
                    this.error = desc.error;
                }
                throw new IOException(this.error);
            }
        }
        this.error = "Data type code : " + desc.dtype + " not yet supported ";
        throw new IOException(this.error);
    }

    double GetNow(String in) throws Exception {
        boolean isPlus = true;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        String currStr = in.trim().toUpperCase();
        if (!currStr.startsWith("NOW")) {
            throw new Exception();
        }
        if ((currStr = currStr.substring(3).trim()).length() > 0) {
            if (currStr.startsWith("+")) {
                isPlus = true;
            } else if (currStr.startsWith("-")) {
                isPlus = false;
            } else {
                throw new Exception();
            }
            currStr = currStr.substring(1).trim();
            StringTokenizer st = new StringTokenizer(currStr, ":", true);
            String currTok = st.nextToken();
            if (currTok.equals(":")) {
                hours = 0;
            } else {
                hours = Integer.parseInt(currTok);
                currTok = st.nextToken();
            }
            if (!currTok.equals(":")) {
                throw new Exception();
            }
            currTok = st.nextToken();
            if (currTok.equals(":")) {
                minutes = 0;
            } else {
                minutes = Integer.parseInt(currTok);
                currTok = st.nextToken();
            }
            if (!currTok.equals(":")) {
                throw new Exception();
            }
            if (st.hasMoreTokens()) {
                seconds = Integer.parseInt(st.nextToken());
            }
        }
        if (!isPlus) {
            hours = -hours;
            minutes = -minutes;
            seconds = -seconds;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(10, hours);
        cal.add(12, minutes);
        cal.add(13, seconds);
        long javaTime = cal.getTime().getTime();
        return javaTime;
    }

    protected int[] getNumDimensions(String in_y) throws IOException {
        int[] fullDims = this.getIntArray(in_y);
        if (fullDims == null) {
            return null;
        }
        if (fullDims.length == 1) {
            return fullDims;
        }
        int numDimensions = 0;
        for (int fullDim : fullDims) {
            if (fullDim == 1) continue;
            ++numDimensions;
        }
        int[] retDims = new int[numDimensions];
        int j = 0;
        for (int fullDim : fullDims) {
            if (fullDim == 1) continue;
            retDims[j++] = fullDim;
        }
        return retDims;
    }

    protected String getProvider() {
        return this.provider;
    }

    public synchronized RealArray GetRealArray(String in) throws IOException {
        if (debug) {
            System.out.println("GetRealArray " + in);
        }
        ConnectionEvent e = new ConnectionEvent((Object)this, 1, 0);
        this.dispatchConnectionEvent(e);
        if (!this.CheckOpen()) {
            return null;
        }
        Descriptor desc = this.mds.MdsValue(in, new Descriptor[0]);
        RealArray out = null;
        switch (desc.dtype) {
            case 10: {
                out = new RealArray(desc.float_data);
                break;
            }
            case 11: {
                out = new RealArray(desc.double_data);
                break;
            }
            case 8: {
                int i;
                float[] outF = new float[desc.int_data.length];
                for (i = 0; i < desc.int_data.length; ++i) {
                    outF[i] = desc.int_data[i];
                }
                out = new RealArray(outF);
            }
            case 4: {
                int i;
                float[] outF = new float[desc.int_data.length];
                for (i = 0; i < desc.int_data.length; ++i) {
                    long currLong = 0L;
                    outF[i] = currLong |= (long)desc.int_data[i] & 0xFFFFFFFFFFFFFFFFL;
                }
                out = new RealArray(outF);
                break;
            }
            case 3: {
                float[] outF = new float[desc.int_data.length];
                for (int i = 0; i < desc.int_data.length; ++i) {
                    int currInt = 0;
                    outF[i] = currInt |= desc.short_data[i] & 0xFFFF;
                }
                out = new RealArray(outF);
                break;
            }
            case 7: {
                float[] outF = new float[desc.short_data.length];
                for (int i = 0; i < desc.short_data.length; ++i) {
                    outF[i] = desc.short_data[i];
                }
                out = new RealArray(outF);
                break;
            }
            case 6: {
                float[] outF = new float[desc.byte_data.length];
                for (int i = 0; i < desc.byte_data.length; ++i) {
                    outF[i] = desc.byte_data[i];
                }
                out = new RealArray(outF);
                break;
            }
            case 2: {
                float[] outF = new float[desc.byte_data.length];
                for (int i = 0; i < desc.byte_data.length; ++i) {
                    int currShort = 0;
                    currShort = (short)(currShort | desc.byte_data[i] & 0xFF);
                    outF[i] = currShort;
                }
                out = new RealArray(outF);
                break;
            }
            case 5: 
            case 9: {
                out = new RealArray(desc.long_data);
                break;
            }
            case 14: {
                if ((desc.status & 1) == 0) {
                    this.error = desc.error;
                    throw new IOException(this.error);
                }
            }
            default: {
                this.error = "Data type code : " + desc.dtype + " not yet supported ";
            }
        }
        return out;
    }

    @Override
    public long[] getShots(String in, String experiment) throws IOException {
        if (debug) {
            System.out.println("GetShots " + in + "  " + experiment);
        }
        this.CheckConnection();
        MdsDataProvider mdsDataProvider = this;
        synchronized (mdsDataProvider) {
            Descriptor desc = this.mds.MdsValue(in, new Descriptor[0]);
            switch (desc.dtype) {
                case 5: 
                case 9: {
                    return desc.long_data;
                }
                case 8: {
                    long[] out_data = new long[desc.int_data.length];
                    for (int i = 0; i < desc.int_data.length; ++i) {
                        out_data[i] = desc.int_data[i];
                    }
                    return out_data;
                }
                case 10: {
                    long[] out_data = new long[desc.float_data.length];
                    for (int i = 0; i < desc.float_data.length; ++i) {
                        out_data[i] = (long)((double)desc.float_data[i] + 0.5);
                    }
                    return out_data;
                }
                case 2: 
                case 6: {
                    long[] out_data = new long[desc.byte_data.length];
                    for (int i = 0; i < desc.byte_data.length; ++i) {
                        out_data[i] = (long)((double)desc.byte_data[i] + 0.5);
                    }
                    return out_data;
                }
                case 14: {
                    if ((desc.status & 1) == 0) {
                        this.error = desc.error;
                    }
                    throw new IOException(this.error);
                }
            }
            this.error = "Data type code : " + desc.dtype + " not yet supported ";
            throw new IOException(this.error);
        }
    }

    @Override
    public synchronized String getString(String _in, int row, int col, int index) throws IOException {
        if (_in == null) {
            return null;
        }
        String in = row != -1 ? "( _ROW = " + row + "; _COLUMN = " + col + "; _INDEX = " + index + "; " + _in + " ; )" : _in;
        this.error = null;
        if (this.NotYetString(in)) {
            if (!this.CheckOpen()) {
                return null;
            }
            Descriptor desc = this.mds.MdsValue(in, new Descriptor[0]);
            switch (desc.dtype) {
                case 2: 
                case 6: {
                    return new String(desc.byte_data);
                }
                case 10: {
                    this.error = "Cannot convert a float to string";
                    throw new IOException(this.error);
                }
                case 14: {
                    if ((desc.status & 1) == 1) {
                        return desc.strdata;
                    }
                    this.error = desc.error;
                    return this.error;
                }
            }
            if (desc.error == null) {
                return "Undefined error";
            }
            this.error = desc.error;
            return this.error;
        }
        return new String(in.getBytes(), 1, in.length() - 2);
    }

    public String getStringValue(String expr) throws IOException {
        String out;
        if (debug) {
            System.out.println("getStringValue " + expr);
        }
        if ((out = this.getString(expr, -1, -1, -1)) == null || out.length() == 0 || this.error != null) {
            this.error = null;
            return null;
        }
        if (out.indexOf(0) > 0) {
            out = out.substring(0, out.indexOf(0));
        }
        return out;
    }

    @Override
    public WaveData getWaveData(String in, int row, int col, int index) {
        return new SimpleWaveData("( _ROW = " + row + "; _COLUMN = " + col + "; _INDEX = " + index + "; " + in + " ; )", this.experiment, this.shot, this.default_node);
    }

    @Override
    public WaveData getWaveData(String in_y, String in_x, int col, int row, int index) {
        return new SimpleWaveData("( _ROW = " + row + "; _COLUMN = " + col + "; _INDEX = " + index + "; " + in_y + " ; )", in_x, this.experiment, this.shot, this.default_node);
    }

    @Override
    public int inquireCredentials(JFrame f, DataServerItem server_item) {
        this.mds.setUser(server_item.getUser());
        this.is_tunneling = false;
        String tunnelPort = server_item.getTunnelPort();
        if (tunnelPort != null && tunnelPort.length() != 0) {
            StringTokenizer st = new StringTokenizer(server_item.getArgument(), ":");
            String ip = st.nextToken();
            int rport = st.hasMoreTokens() ? Integer.valueOf(st.nextToken()) : 8000;
            this.is_tunneling = true;
            try {
                int lport = Integer.valueOf(server_item.getTunnelPort());
                this.ssh_tunneling = new SshTunneling(server_item.getUser(), ip, lport, rport);
                this.tunnel_provider = "127.0.0.1:" + server_item.getTunnelPort();
            }
            catch (Throwable exc) {
                if (exc instanceof NoClassDefFoundError) {
                    JOptionPane.showMessageDialog(f, "The MindTerm.jar library is required for ssh tunneling.You can download it from \nhttp://www.appgate.com/mindterm/download.php\n" + exc, "alert", 0);
                }
                return 2;
            }
        }
        return 1;
    }

    @Override
    public boolean isBusy() {
        return this.mds != null && this.mds.isBusy();
    }

    protected boolean NotYetNumber(String in) {
        try {
            Float.parseFloat(in);
            return false;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    protected boolean NotYetString(String in) {
        if (in.charAt(0) == '\"') {
            int i;
            for (i = 1; i < in.length() && (in.charAt(i) != '\"' || i > 0 && in.charAt(i) == '\"' && in.charAt(i - 1) == '\\'); ++i) {
            }
            if (i == in.length() - 1) {
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized void removeConnectionListener(ConnectionListener l) {
        if (this.mds != null) {
            this.mds.removeConnectionListener(l);
        }
    }

    @Override
    public synchronized void removeUpdateEventListener(UpdateEventListener l, String event_name) throws IOException {
        if (event_name == null || event_name.trim().length() == 0) {
            return;
        }
        this.CheckConnection();
        this.mds.MdsRemoveEvent(l, event_name);
    }

    protected void resetPrevious() {
    }

    @Override
    public void setArgument(String arg) throws IOException {
        this.setProvider(arg);
        this.mds.setProvider(this.provider);
    }

    public void SetCompression(boolean state) {
        if (this.connected) {
            this.close();
        }
        this.use_compression = state;
    }

    @Override
    public synchronized void setEnvironment(String in) throws IOException {
        if (in == null || in.length() == 0) {
            return;
        }
        Properties pr = new Properties();
        pr.load(new ByteArrayInputStream(in.getBytes()));
        String def_node = pr.getProperty("__default_node");
        if (def_node != null) {
            def_node = def_node.trim();
            if (this.default_node == null || !def_node.equals(this.default_node) || def_node.length() == 0 && this.default_node != null) {
                this.default_node = def_node.length() == 0 ? null : def_node;
            }
            return;
        }
        if (in.indexOf("pulseSetVer") >= 0) {
            this.open = false;
        }
        if (this.environment_vars == null || !this.environment_vars.equalsIgnoreCase(in)) {
            this.open = false;
            this.environment_vars = in;
        }
    }

    void SetEnvironmentSpecific(String in) {
        Descriptor desc = this.mds.MdsValue(in, new Descriptor[0]);
        switch (desc.dtype) {
            case 14: {
                if ((desc.status & 1) != 0) break;
                this.error = desc.error;
            }
        }
    }

    private void setProvider(String arg) {
        this.provider = this.is_tunneling ? this.tunnel_provider : arg;
    }

    public boolean SupportsCompression() {
        return true;
    }

    @Override
    public boolean supportsTunneling() {
        return true;
    }

    @Override
    public synchronized void update(String experiment, long shot) {
        this.Update(experiment, shot, false);
    }

    public synchronized void Update(String experiment, long shot, boolean resetExperiment) {
        this.error = null;
        this.var_idx = 0;
        if (resetExperiment) {
            this.experiment = null;
        }
        if (shot != this.shot || shot == 0L || this.experiment == null || this.experiment.length() == 0 || !this.experiment.equalsIgnoreCase(experiment)) {
            this.experiment = experiment != null && experiment.trim().length() > 0 ? experiment : null;
            this.shot = shot;
            this.open = false;
            this.resetPrevious();
        }
    }

    class UpdateWorker
    extends Thread {
        boolean enabled = true;
        Vector<UpdateDescriptor> requestsV = new Vector();
        boolean stopWorker = false;

        UpdateWorker() {
        }

        synchronized void enableAsyncUpdate(boolean enabled) {
            this.enabled = enabled;
            if (enabled) {
                this.notify();
            }
        }

        synchronized void intUpdateInfo(double updateLowerBound, double updateUpperBound, int updatePoints, Vector<WaveDataListener> waveDataListenersV, SimpleWaveData simpleWaveData, boolean isXLong, long updateTime) {
            this.requestsV.add(new UpdateDescriptor(updateLowerBound, updateUpperBound, updatePoints, waveDataListenersV, simpleWaveData, isXLong, updateTime));
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            this.setName("UpdateWorker");
            block7: while (true) {
                var1_1 = this;
                synchronized (var1_1) {
                    try {
                        this.wait();
                        if (this.stopWorker) {
                            return;
                        }
                    }
                    catch (InterruptedException var2_3) {
                        // empty catch block
                    }
                }
                if (!this.enabled) continue;
                block8: while (true) {
                    if (this.requestsV.size() > 0 && this.enabled) ** break;
                    continue block7;
                    currUpdate = this.requestsV.elementAt(this.requestsV.size() - 1);
                    try {
                        this.requestsV.removeElementAt(this.requestsV.size() - 1);
                        currData = currUpdate.simpleWaveData.getData(currUpdate.updateLowerBound, currUpdate.updateUpperBound, currUpdate.updatePoints, currUpdate.isXLong);
                        if (MdsDataProvider.debug) {
                            System.out.println("UPDATE Lower Bound: " + currUpdate.updateLowerBound + "   Upper bound: " + currUpdate.updateUpperBound + "  Resolution: " + (currData == null ? "None" : "" + currData.resolution));
                        }
                        if (currData == null || currData.nSamples == 0) continue;
                        j = 0;
                        while (true) {
                            if (j >= currUpdate.waveDataListenersV.size()) continue block8;
                            if (currUpdate.isXLong) {
                                currUpdate.waveDataListenersV.elementAt(j).dataRegionUpdated(currData.xLong, currData.y, currData.resolution);
                            } else {
                                currUpdate.waveDataListenersV.elementAt(j).dataRegionUpdated(currData.x, currData.y, currData.resolution);
                            }
                            ++j;
                        }
                    }
                    catch (Exception exc) {
                        d = new Date();
                        System.out.println(d + " Error in asynchUpdate: " + exc);
                        continue;
                    }
                    break;
                }
                break;
            }
        }

        synchronized void stopUpdateWorker() {
            this.stopWorker = true;
            this.notify();
        }

        void updateInfo(double updateLowerBound, double updateUpperBound, int updatePoints, Vector<WaveDataListener> waveDataListenersV, SimpleWaveData simpleWaveData, boolean isXLong) {
            this.intUpdateInfo(updateLowerBound, updateUpperBound, updatePoints, waveDataListenersV, simpleWaveData, isXLong, -1L);
        }

        class UpdateDescriptor {
            double updateLowerBound;
            double updateUpperBound;
            int updatePoints;
            Vector<WaveDataListener> waveDataListenersV;
            SimpleWaveData simpleWaveData;
            boolean isXLong;
            long updateTime;

            UpdateDescriptor(double updateLowerBound, double updateUpperBound, int updatePoints, Vector<WaveDataListener> waveDataListenersV, SimpleWaveData simpleWaveData, boolean isXLong, long updateTime) {
                this.updateLowerBound = updateLowerBound;
                this.updateUpperBound = updateUpperBound;
                this.updatePoints = updatePoints;
                this.waveDataListenersV = waveDataListenersV;
                this.simpleWaveData = simpleWaveData;
                this.isXLong = isXLong;
                this.updateTime = updateTime;
            }
        }
    }

    class SimpleWaveData
    implements WaveData {
        static final int SEGMENTED_YES = 1;
        static final int SEGMENTED_NO = 2;
        static final int SEGMENTED_UNKNOWN = 3;
        static final int UNKNOWN = -1;
        String in_x;
        String in_y;
        boolean _jscope_set = false;
        int numDimensions = -1;
        int segmentMode = 3;
        String segmentNodeName;
        int v_idx;
        boolean isXLong = false;
        String title = null;
        String xLabel = null;
        String yLabel = null;
        String defaultNode = null;
        boolean titleEvaluated = false;
        boolean xLabelEvaluated = false;
        boolean yLabelEvaluated = false;
        String wd_experiment;
        long wd_shot;
        AsyncDataSource asynchSource = null;
        private long[] x2DLong;
        Vector<WaveDataListener> waveDataListenersV = new Vector();

        public SimpleWaveData(String in_y, String experiment, long shot, String defaultNode) {
            this.wd_experiment = experiment;
            this.wd_shot = shot;
            this.defaultNode = defaultNode;
            if (this.checkForAsynchRequest(in_y)) {
                this.in_y = "[]";
                this.in_x = "[]";
            } else {
                this.in_y = in_y;
            }
            this.v_idx = MdsDataProvider.this.var_idx;
            MdsDataProvider.this.var_idx += 2;
            if (this.segmentMode == 3) {
                String fixedY = this.duplicateBackslashes(in_y);
                try {
                    String segExpr = "long(MdsMisc->IsSegmented(\"" + fixedY + "\"))";
                    int[] retData = MdsDataProvider.this.getIntArray(segExpr);
                    if (debug) {
                        System.out.println(segExpr + " " + retData[0]);
                    }
                    if (retData[0] != 0) {
                        this.segmentMode = 1;
                        this.segmentNodeName = MdsDataProvider.this.getStringValue("MdsMisc->GetPathOf:DSC(" + retData[0] + ")");
                        if (debug) {
                            System.out.println("Segmented Node: " + this.segmentNodeName);
                        }
                    } else {
                        this.segmentMode = 2;
                    }
                }
                catch (IOException exc) {
                    MdsDataProvider.this.error = null;
                    this.segmentMode = 3;
                }
            }
        }

        public SimpleWaveData(String in_y, String in_x, String experiment, long shot, String defaultNode) {
            this.wd_experiment = experiment;
            this.wd_shot = shot;
            this.defaultNode = defaultNode;
            if (this.checkForAsynchRequest(in_y)) {
                this.in_y = "[]";
                this.in_x = "[]";
            } else {
                this.in_y = in_y;
                this.in_x = in_x;
            }
            this.v_idx = MdsDataProvider.this.var_idx;
            MdsDataProvider.this.var_idx += 2;
            if (this.segmentMode == 3) {
                Vector<Descriptor> args = new Vector<Descriptor>();
                String fixedY = in_y.replaceAll("\\\\", "\\\\\\\\");
                args.addElement(new Descriptor(null, fixedY));
                try {
                    byte[] retData = MdsDataProvider.this.GetByteArray("byte(MdsMisc->IsSegmented($))", args);
                    if (retData[0] > 0) {
                        this.segmentNodeName = MdsDataProvider.this.getStringValue("MdsMisc->GetPathOf:DSC(" + retData[0] + ")");
                        if (debug) {
                            System.out.println("Segmented Node: " + this.segmentNodeName);
                        }
                        this.segmentMode = 1;
                    } else {
                        this.segmentMode = 2;
                    }
                }
                catch (Exception exc) {
                    MdsDataProvider.this.error = null;
                    this.segmentMode = 3;
                }
            }
        }

        @Override
        public void addWaveDataListener(WaveDataListener listener) {
            this.waveDataListenersV.addElement(listener);
            if (this.asynchSource != null) {
                this.asynchSource.addDataListener(listener);
            }
        }

        boolean checkForAsynchRequest(String expression) {
            if (expression.startsWith("ASYNCH::")) {
                this.asynchSource = MdsDataProvider.this.getAsynchSource();
                if (this.asynchSource != null) {
                    this.asynchSource.startGeneration(expression.substring("ASYNCH::".length()));
                }
                return true;
            }
            return false;
        }

        public String duplicateBackslashes(String inStr) {
            StringBuffer outStr = new StringBuffer();
            for (int i = 0; i < inStr.length(); ++i) {
                if (inStr.charAt(i) == '\\') {
                    outStr.append('\\');
                }
                outStr.append(inStr.charAt(i));
            }
            return outStr.toString();
        }

        @Override
        public XYData getData(double xmin, double xmax, int numPoints) throws IOException {
            return this.getData(xmin, xmax, numPoints, false);
        }

        public XYData getData(double xmin, double xmax, int numPoints, boolean isLong) throws IOException {
            String xExpr;
            String yExpr;
            byte[] retData;
            Vector<Descriptor> args;
            XYData res = null;
            if (debug) {
                System.out.println("GET DATA " + this.in_y + "   Start: " + xmin + "   End: " + xmax);
            }
            if (!MdsDataProvider.this.CheckOpen(this.wd_experiment, this.wd_shot, this.defaultNode)) {
                return null;
            }
            if (this.segmentMode == 3) {
                args = new Vector<Descriptor>();
                args.addElement(new Descriptor(null, this.in_y));
                try {
                    retData = MdsDataProvider.this.GetByteArray("byte(MdsMisc->IsSegmented($))", args);
                    if (retData[0] > 0) {
                        this.segmentMode = 1;
                        this.segmentNodeName = MdsDataProvider.this.getStringValue("MdsMisc->GetPathOf:DSC(" + retData[0] + ")");
                        if (debug) {
                            System.out.println("Segmented Node: " + this.segmentNodeName);
                        }
                    } else {
                        this.segmentMode = 2;
                    }
                }
                catch (Exception exc) {
                    this.segmentMode = 2;
                }
            }
            if (this.segmentMode == 2) {
                yExpr = this.in_y;
                this._jscope_set = false;
                xExpr = this.in_x == null ? "DIM_OF( " + this.in_y + " );" : this.in_x;
            } else if (this.in_x == null) {
                yExpr = this.in_y;
                xExpr = "DIM_OF( " + this.in_y + " );";
            } else {
                yExpr = this.in_y;
                xExpr = this.in_x;
            }
            args = new Vector();
            args.addElement(new Descriptor(null, yExpr));
            if (this.in_x == null) {
                args.addElement(new Descriptor(null, ""));
            } else {
                args.addElement(new Descriptor(null, xExpr));
            }
            if (isLong) {
                args.addElement(new Descriptor(null, new long[]{xmin <= -1.7976931348623157E308 ? Long.MIN_VALUE : (long)xmin}));
                args.addElement(new Descriptor(null, new long[]{xmax >= Double.MAX_VALUE ? Long.MAX_VALUE : (long)xmax}));
            } else {
                args.addElement(new Descriptor(null, new float[]{(float)xmin}));
                args.addElement(new Descriptor(null, new float[]{(float)xmax}));
            }
            args.addElement(new Descriptor(null, new int[]{numPoints}));
            try {
                int yLabelLen;
                int xLabelLen;
                double[] x;
                int i;
                if (numPoints == Integer.MAX_VALUE) {
                    throw new Exception("Use Old Method for getting data");
                }
                retData = isLong ? MdsDataProvider.this.GetByteArray(" MdsMisc->GetXYSignalLongTimes:DSC", args) : MdsDataProvider.this.GetByteArray(" MdsMisc->GetXYSignal:DSC", args);
                ByteArrayInputStream bis = new ByteArrayInputStream(retData);
                DataInputStream dis = new DataInputStream(bis);
                float fRes = dis.readFloat();
                if (fRes == 0.0f) {
                    int nSamples = dis.readInt();
                    byte[] errorBuf = new byte[nSamples];
                    dis.readFully(errorBuf);
                    throw new Exception(new String(errorBuf));
                }
                if (debug) {
                    System.out.println("********************RET RESOLUTION: " + fRes);
                }
                double dRes = (double)fRes >= 1.0E10 ? Double.MAX_VALUE : (double)fRes;
                int nSamples = dis.readInt();
                if (nSamples <= 0) {
                    MdsDataProvider.this.error = "No Samples returned";
                    return null;
                }
                byte type = dis.readByte();
                float[] y = new float[nSamples];
                for (int i2 = 0; i2 < nSamples; ++i2) {
                    y[i2] = dis.readFloat();
                }
                if (type == 1) {
                    long[] longX = new long[nSamples];
                    for (i = 0; i < nSamples; ++i) {
                        longX[i] = dis.readLong();
                    }
                    this.isXLong = true;
                    res = new XYData(longX, y, dRes);
                } else if (type == 2) {
                    x = new double[nSamples];
                    for (i = 0; i < nSamples; ++i) {
                        x[i] = dis.readDouble();
                    }
                    res = new XYData(x, y, dRes);
                } else {
                    x = new double[nSamples];
                    for (i = 0; i < nSamples; ++i) {
                        x[i] = dis.readFloat();
                    }
                    res = new XYData(x, y, dRes);
                }
                int titleLen = dis.readInt();
                if (titleLen > 0) {
                    byte[] titleBuf = new byte[titleLen];
                    dis.readFully(titleBuf);
                    this.title = new String(titleBuf);
                }
                if ((xLabelLen = dis.readInt()) > 0) {
                    byte[] xLabelBuf = new byte[xLabelLen];
                    dis.readFully(xLabelBuf);
                    this.xLabel = new String(xLabelBuf);
                }
                if ((yLabelLen = dis.readInt()) > 0) {
                    byte[] yLabelBuf = new byte[yLabelLen];
                    dis.readFully(yLabelBuf);
                    this.yLabel = new String(yLabelBuf);
                }
                this.yLabelEvaluated = true;
                this.xLabelEvaluated = true;
                this.titleEvaluated = true;
                if (type == 1) {
                    isLong = true;
                }
                return res;
            }
            catch (Exception bis) {
                float[] y = MdsDataProvider.this.GetFloatArray("(" + yExpr + ")");
                RealArray xReal = MdsDataProvider.this.GetRealArray("(" + xExpr + ";)");
                if (y == null || xReal == null) {
                    return null;
                }
                if (xReal.isLong()) {
                    this.isXLong = true;
                    return new XYData(xReal.getLongArray(), y, 1.0E12);
                }
                this.isXLong = false;
                return new XYData(xReal.getDoubleArray(), y, 1.0E12);
            }
        }

        @Override
        public XYData getData(int numPoints) throws IOException {
            return this.getData(-1.7976931348623157E308, Double.MAX_VALUE, numPoints);
        }

        @Override
        public XYData getData(long xmin, long xmax, int numPoints) throws IOException {
            return this.getData(xmin, xmax, numPoints, true);
        }

        @Override
        public void getDataAsync(double lowerBound, double upperBound, int numPoints) {
            if (debug) {
                System.out.println("***GET DATA ASYNCH " + lowerBound + "  " + upperBound + "  " + numPoints);
            }
            MdsDataProvider.this.updateWorker.updateInfo(lowerBound, upperBound, numPoints, this.waveDataListenersV, this, this.isXLong);
        }

        @Override
        public int getNumDimension() throws IOException {
            String expr;
            if (this.numDimensions != -1) {
                return this.numDimensions;
            }
            if (this._jscope_set) {
                expr = "shape(_jscope_" + this.v_idx + ")";
            } else if (this.segmentMode == 1) {
                expr = "shape(GetSegment(" + this.segmentNodeName + ",0))";
            } else {
                this._jscope_set = true;
                expr = "( _jscope_" + this.v_idx + " = (" + this.in_y + ";), shape(_jscope_" + this.v_idx + "))";
            }
            MdsDataProvider.this.error = null;
            int[] shape = MdsDataProvider.this.getNumDimensions(expr);
            if (MdsDataProvider.this.error != null || shape == null) {
                this._jscope_set = false;
                MdsDataProvider.this.error = null;
                return 1;
            }
            this.numDimensions = shape.length;
            return shape.length;
        }

        @Override
        public String GetTitle() throws IOException {
            if (!this.titleEvaluated) {
                this.titleEvaluated = true;
                if (this._jscope_set) {
                    String expr = "help_of(_jscope_" + this.v_idx + ")";
                    this.title = MdsDataProvider.this.getStringValue(expr);
                } else {
                    String expr;
                    if (this.segmentMode == 1) {
                        expr = "help_of(" + this.in_y + ")";
                    } else {
                        this._jscope_set = true;
                        expr = "( _jscope_" + this.v_idx + " = (" + this.in_y + "), help_of(_jscope_" + this.v_idx + "))";
                    }
                    this.title = MdsDataProvider.this.getStringValue(expr);
                }
            }
            return this.title;
        }

        public float[] getX_X2D() {
            String in = "DIM_OF( " + this.in_x + ", 0);";
            try {
                return MdsDataProvider.this.GetFloatArray(in);
            }
            catch (Exception exc) {
                return null;
            }
        }

        public float[] getX_Y2D() {
            String in = "DIM_OF( " + this.in_x + ", 1);";
            try {
                return MdsDataProvider.this.GetFloatArray(in);
            }
            catch (Exception exc) {
                return null;
            }
        }

        public float[] getX_Z() {
            try {
                return MdsDataProvider.this.GetFloatArray(this.in_x);
            }
            catch (Exception exc) {
                return null;
            }
        }

        @Override
        public double[] getX2D() {
            String in = "DIM_OF(" + this.in_y + ", 0);";
            try {
                RealArray realArray = MdsDataProvider.this.GetRealArray(in);
                if (realArray.isLong()) {
                    this.isXLong = true;
                    this.x2DLong = realArray.getLongArray();
                    return null;
                }
                this.x2DLong = null;
                return realArray.getDoubleArray();
            }
            catch (Exception exc) {
                return null;
            }
        }

        @Override
        public long[] getX2DLong() {
            return this.x2DLong;
        }

        @Override
        public String GetXLabel() throws IOException {
            if (!this.xLabelEvaluated) {
                this.xLabelEvaluated = true;
                if (this.in_x == null || this.in_x.length() == 0) {
                    if (this._jscope_set) {
                        String expr = "Units(dim_of(_jscope_" + this.v_idx + "))";
                        this.xLabel = MdsDataProvider.this.getStringValue(expr);
                    } else if (this.segmentMode == 1) {
                        String expr = "Units(dim_of(GetSegment(" + this.segmentNodeName + ", 0)))";
                        this.xLabel = MdsDataProvider.this.getStringValue(expr);
                    } else {
                        this._jscope_set = true;
                        String expr = "( _jscope_" + this.v_idx + " = (" + this.in_y + "), Units(dim_of(_jscope_" + this.v_idx + ")))";
                        this.xLabel = MdsDataProvider.this.getStringValue(expr);
                    }
                } else {
                    this.xLabel = MdsDataProvider.this.getStringValue("Units(" + this.in_x + ")");
                }
            }
            return this.xLabel;
        }

        @Override
        public float[] getY2D() {
            String in = "DIM_OF( " + this.in_y + ", 1);";
            try {
                return MdsDataProvider.this.GetFloatArray(in);
            }
            catch (Exception exc) {
                return null;
            }
        }

        @Override
        public String GetYLabel() throws IOException {
            if (!this.yLabelEvaluated) {
                this.yLabelEvaluated = true;
                if (this.getNumDimension() > 1) {
                    if (this.segmentMode == 1) {
                        String expr = "Units(dim_of(GetSegment(" + this.segmentNodeName + ", 1)))";
                        this.yLabel = MdsDataProvider.this.getStringValue(expr);
                    } else if (this._jscope_set) {
                        String expr = "Units(dim_of(_jscope_" + this.v_idx + ", 1))";
                        this.yLabel = MdsDataProvider.this.getStringValue(expr);
                    } else {
                        this._jscope_set = true;
                        String expr = "( _jscope_" + this.v_idx + " = (" + this.in_y + "), Units(dim_of(_jscope_" + this.v_idx + ", 1)))";
                        this.yLabel = MdsDataProvider.this.getStringValue(expr);
                    }
                }
                return this.yLabel;
            }
            if (this.segmentMode == 1) {
                String expr = "Units(dim_of(GetSegment(" + this.segmentNodeName + ", 0)))";
                this.yLabel = MdsDataProvider.this.getStringValue(expr);
            } else if (this._jscope_set) {
                String expr = "Units(_jscope_" + this.v_idx + ")";
                this.yLabel = MdsDataProvider.this.getStringValue(expr);
            } else {
                this._jscope_set = true;
                String expr = "( _jscope_" + this.v_idx + " = (" + this.in_y + "), Units(_jscope_" + this.v_idx + "))";
                this.yLabel = MdsDataProvider.this.getStringValue(expr);
            }
            return this.yLabel;
        }

        @Override
        public float[] getZ() {
            try {
                return MdsDataProvider.this.GetFloatArray(this.in_y);
            }
            catch (Exception exc) {
                return null;
            }
        }

        @Override
        public String GetZLabel() throws IOException {
            String expr;
            if (this._jscope_set) {
                expr = "Units(_jscope_" + this.v_idx + ")";
            } else {
                this._jscope_set = true;
                expr = "( _jscope_" + this.v_idx + " = (" + this.in_y + "), Units(_jscope_" + this.v_idx + "))";
            }
            String out = MdsDataProvider.this.getStringValue(expr);
            if (out == null) {
                this._jscope_set = false;
            }
            return out;
        }

        @Override
        public boolean isXLong() {
            return this.isXLong;
        }

        @Override
        public void removeWaveDataListener(WaveDataListener listener) {
            this.waveDataListenersV.remove(listener);
        }

        @Override
        public boolean supportsStreaming() {
            return this.segmentMode == 1;
        }
    }

    class SimpleFrameData
    implements FrameData {
        String in_x;
        String in_y;
        float time_max;
        float time_min;
        int mode = -1;
        int pixel_size;
        int first_frame_idx = -1;
        byte[] buf;
        String error;
        private int st_idx = -1;
        private int end_idx = -1;
        private int n_frames = 0;
        private float[] times = null;
        private Dimension dim = null;
        private int header_size = 0;

        public SimpleFrameData(String in_y, String in_x, float time_min, float time_max) throws Exception {
            float t;
            int i;
            float[] all_times = null;
            this.in_y = in_y;
            this.in_x = in_x;
            this.time_min = time_min;
            this.time_max = time_max;
            this.buf = MdsDataProvider.this.GetAllFrames(in_y);
            if (this.buf != null) {
                ByteArrayInputStream b = new ByteArrayInputStream(this.buf);
                DataInputStream d = new DataInputStream(b);
                this.pixel_size = d.readInt();
                int width = d.readInt();
                int height = d.readInt();
                int n_frame = d.readInt();
                this.dim = new Dimension(width, height);
                if (in_x == null || in_x.length() == 0) {
                    all_times = new float[n_frame];
                    for (i = 0; i < n_frame; ++i) {
                        all_times[i] = d.readFloat();
                    }
                } else {
                    all_times = MdsDataProvider.this.getWaveData((String)in_x, (int)0, (int)0, (int)0).getData((int)20000).y;
                }
                this.header_size = 16 + 4 * n_frame;
                switch (this.pixel_size) {
                    case 8: {
                        this.mode = 1;
                        break;
                    }
                    case 16: {
                        this.mode = 3;
                        break;
                    }
                    case 32: {
                        this.mode = 5;
                    }
                }
            } else {
                String mframe_error = MdsDataProvider.this.getError();
                all_times = in_x == null || in_x.length() == 0 ? MdsDataProvider.this.GetFrameTimes(in_y) : MdsDataProvider.this.getWaveData((String)in_x, (int)0, (int)0, (int)0).getData((int)20000).y;
                if (all_times == null) {
                    this.error = mframe_error != null ? " Pulse file or image file not found\nRead pulse file error\n" + mframe_error + "\nFrame times read error" : " Image file not found ";
                    if (MdsDataProvider.this.getError() != null) {
                        this.error = this.error + "\n" + MdsDataProvider.this.getError();
                    }
                    throw new IOException(this.error);
                }
            }
            for (i = 0; i < all_times.length && !((t = all_times[i]) > time_max); ++i) {
                if (!(t >= time_min) || this.st_idx != -1) continue;
                this.st_idx = i;
            }
            this.end_idx = i;
            if (this.st_idx == -1) {
                throw new IOException("No frames found between " + time_min + " - " + time_max);
            }
            this.n_frames = this.end_idx - this.st_idx;
            this.times = new float[this.n_frames];
            int j = 0;
            for (i = this.st_idx; i < this.end_idx; ++i) {
                this.times[j++] = all_times[i];
            }
        }

        @Override
        public byte[] getFrameAt(int idx) throws IOException {
            if (debug) {
                System.out.println("GetFrameAt " + idx);
            }
            byte[] b_img = null;
            if (this.mode == 1 || this.mode == 3 || this.mode == 5) {
                if (this.buf == null) {
                    throw new IOException("Frames not loaded");
                }
                ByteArrayInputStream b = new ByteArrayInputStream(this.buf);
                DataInputStream d = new DataInputStream(b);
                if (this.buf == null) {
                    throw new IOException("Frames dimension not evaluated");
                }
                int img_size = this.dim.width * this.dim.height * this.pixel_size / 8;
                d.skip(this.header_size + (this.st_idx + idx) * img_size);
                if (d.available() < img_size) {
                    return null;
                }
                b_img = new byte[img_size];
                d.readFully(b_img);
                return b_img;
            }
            if (idx == this.first_frame_idx && this.buf != null) {
                return this.buf;
            }
            b_img = MdsDataProvider.this.GetFrameAt(this.in_y, this.st_idx + idx);
            return b_img;
        }

        @Override
        public Dimension getFrameDimension() {
            return this.dim;
        }

        @Override
        public float[] getFrameTimes() {
            return this.times;
        }

        @Override
        public int getFrameType() throws IOException {
            int i;
            if (this.mode != -1) {
                return this.mode;
            }
            for (i = 0; i < this.n_frames; ++i) {
                this.buf = this.getFrameAt(i);
                if (this.buf != null) break;
            }
            this.first_frame_idx = i;
            this.mode = Frames.DecodeImageType(this.buf);
            return this.mode;
        }

        @Override
        public int getNumFrames() {
            return this.n_frames;
        }
    }

    class SegmentedFrameData
    implements FrameData {
        String inX;
        String inY;
        float timeMax;
        float timeMin;
        int framesPerSegment;
        int numSegments;
        int startSegment;
        int endSegment;
        int actSegments;
        int mode;
        Dimension dim;
        float[] times;
        int bytesPerPixel;

        public SegmentedFrameData(String inY, String inX, float timeMin, float timeMax, int numSegments) throws IOException {
            float[] limits;
            this.inX = inX;
            this.inY = inY;
            this.timeMin = timeMin;
            this.timeMax = timeMax;
            this.numSegments = numSegments;
            this.startSegment = -1;
            float[] startTimes = new float[numSegments];
            for (int i = 0; i < numSegments; ++i) {
                limits = MdsDataProvider.this.GetFloatArray("GetSegmentLimits(" + inY + "," + i + ")");
                startTimes[i] = limits[0];
                if (!(limits[1] > timeMin)) continue;
                this.startSegment = i;
                break;
            }
            if (this.startSegment == -1) {
                throw new IOException("Frames outside defined time window");
            }
            float[] endLimits = MdsDataProvider.this.GetFloatArray("GetSegmentLimits(" + inY + "," + (numSegments - 1) + ")");
            while ((endLimits == null || endLimits.length != 2) && --numSegments != 0) {
                endLimits = MdsDataProvider.this.GetFloatArray("GetSegmentLimits(" + inY + "," + (numSegments - 1) + ")");
            }
            if (numSegments > 100 && endLimits[0] < timeMax) {
                this.endSegment = numSegments - 1;
                for (int i = this.startSegment; i < numSegments; ++i) {
                    startTimes[i] = startTimes[0] + (float)i * (endLimits[0] - startTimes[0]) / (float)numSegments;
                }
            } else {
                this.endSegment = this.startSegment;
                while (this.endSegment < numSegments) {
                    try {
                        limits = MdsDataProvider.this.GetFloatArray("GetSegmentLimits(" + inY + "," + this.endSegment + ")");
                        startTimes[this.endSegment] = limits[0];
                        if (limits[0] > timeMax) {
                        }
                    }
                    catch (Exception exc) {}
                    break;
                    ++this.endSegment;
                }
            }
            this.actSegments = this.endSegment - this.startSegment;
            int[] dims = MdsDataProvider.this.getIntArray("shape(GetSegment(" + inY + ", 0))");
            if (dims.length != 3 && dims.length != 1) {
                throw new IOException("Invalid number of segment dimensions: " + dims.length);
            }
            if (dims.length == 3) {
                this.dim = new Dimension(dims[0], dims[1]);
                this.framesPerSegment = dims[2];
                int[] len = MdsDataProvider.this.getIntArray("len(GetSegment(" + inY + ", 0))");
                this.bytesPerPixel = len[0];
                switch (len[0]) {
                    case 1: {
                        this.mode = 1;
                        break;
                    }
                    case 2: {
                        this.mode = 3;
                        break;
                    }
                    case 4: {
                        this.mode = 5;
                        break;
                    }
                    default: {
                        throw new IOException("Unexpected length for frame data: " + len[0]);
                    }
                }
            } else {
                this.framesPerSegment = 1;
                this.mode = 8;
                this.bytesPerPixel = 1;
                byte[] firstSegment = MdsDataProvider.this.GetByteArray("GetSegment(" + inY + ",0)");
                BufferedImage img = ImageIO.read(new ByteArrayInputStream(firstSegment));
                this.dim = new Dimension(img.getWidth(), img.getHeight());
            }
            if (this.framesPerSegment == 1) {
                this.times = new float[this.actSegments];
                for (int i = 0; i < this.actSegments; ++i) {
                    this.times[i] = startTimes[this.startSegment + i];
                }
            } else {
                this.times = new float[this.actSegments * this.framesPerSegment];
                for (int i = 0; i < this.actSegments; ++i) {
                    float[] segTimes = MdsDataProvider.this.GetFloatArray("dim_of(GetSegment(" + inY + "," + i + "))");
                    if (segTimes.length != this.framesPerSegment) {
                        throw new IOException("Inconsistent definition of time in frame + " + i + ": read " + segTimes.length + " times, expected " + this.framesPerSegment);
                    }
                    for (int j = 0; j < this.framesPerSegment; ++j) {
                        this.times[i * this.framesPerSegment + j] = segTimes[j];
                    }
                }
            }
        }

        @Override
        public byte[] getFrameAt(int idx) throws IOException {
            if (debug) {
                System.out.println("GetFrameAt " + idx);
            }
            int segmentIdx = this.startSegment + idx / this.framesPerSegment;
            int segmentOffset = idx % this.framesPerSegment * this.dim.width * this.dim.height * this.bytesPerPixel;
            byte[] segment = MdsDataProvider.this.GetByteArray("GetSegment(" + this.inY + "," + segmentIdx + ")");
            if (this.framesPerSegment == 1) {
                return segment;
            }
            byte[] outFrame = new byte[this.dim.width * this.dim.height * this.bytesPerPixel];
            System.arraycopy(segment, segmentOffset, outFrame, 0, this.dim.width * this.dim.height * this.bytesPerPixel);
            return outFrame;
        }

        @Override
        public Dimension getFrameDimension() {
            return this.dim;
        }

        @Override
        public float[] getFrameTimes() {
            return this.times;
        }

        @Override
        public int getFrameType() throws IOException {
            return this.mode;
        }

        @Override
        public int getNumFrames() {
            return this.actSegments * this.framesPerSegment;
        }
    }

    static class RealArray {
        double[] doubleArray = null;
        float[] floatArray = null;
        long[] longArray = null;
        boolean isDouble;
        boolean isLong;

        RealArray(double[] doubleArray) {
            this.doubleArray = doubleArray;
            this.isDouble = true;
            this.isLong = false;
        }

        RealArray(float[] floatArray) {
            this.floatArray = floatArray;
            this.isDouble = false;
            this.isLong = false;
        }

        RealArray(long[] longArray) {
            this.longArray = longArray;
            for (int i = 0; i < longArray.length; ++i) {
                longArray[i] = Waveform.convertFromSpecificTime(longArray[i]);
            }
            this.isDouble = false;
            this.isLong = true;
        }

        double[] getDoubleArray() {
            if (this.isLong) {
                return null;
            }
            if (!this.isDouble && this.floatArray != null && this.doubleArray == null) {
                this.doubleArray = new double[this.floatArray.length];
                for (int i = 0; i < this.floatArray.length; ++i) {
                    this.doubleArray[i] = this.floatArray[i];
                }
            }
            return this.doubleArray;
        }

        float[] getFloatArray() {
            if (this.isLong) {
                return null;
            }
            if (this.isDouble && this.floatArray == null && this.doubleArray != null) {
                this.floatArray = new float[this.doubleArray.length];
                for (int i = 0; i < this.doubleArray.length; ++i) {
                    this.floatArray[i] = (float)this.doubleArray[i];
                }
            }
            return this.floatArray;
        }

        long[] getLongArray() {
            if (this.isDouble) {
                return null;
            }
            return this.longArray;
        }

        boolean isDouble() {
            return this.isDouble;
        }

        boolean isLong() {
            return this.isLong;
        }
    }

    public static interface AsyncDataSource {
        public void addDataListener(WaveDataListener var1);

        public void startGeneration(String var1);
    }
}

