/*
 * Decompiled with CFR 0.152.
 */
package MDSplus;

import MDSplus.Array;
import MDSplus.Data;
import MDSplus.MdsException;
import MDSplus.Uint64;

public class Uint64Array
extends Array {
    long[] datum;

    public Uint64Array(long[] inDatum) {
        this.help = null;
        this.units = null;
        this.error = null;
        this.validation = null;
        this.clazz = 4;
        this.dtype = 5;
        this.dims = new int[1];
        this.dims[0] = inDatum.length;
        this.datum = new long[inDatum.length];
        System.arraycopy(inDatum, 0, this.datum, 0, inDatum.length);
    }

    public Uint64Array(long[] inDatum, int[] dims) throws MdsException {
        this(inDatum, dims, null, null, null, null);
    }

    public Uint64Array(long[] inDatum, int[] dims, Data help, Data units, Data error, Data validation) throws MdsException {
        super(dims, help, units, error, validation);
        this.clazz = 4;
        this.dtype = 5;
        this.datum = new long[inDatum.length];
        System.arraycopy(inDatum, 0, this.datum, 0, inDatum.length);
        this.setShape(dims);
    }

    public boolean equals(Object obj) {
        int i;
        if (!(obj instanceof Uint64Array)) {
            return false;
        }
        Uint64Array data = (Uint64Array)obj;
        if (data.dims.length != this.dims.length) {
            return false;
        }
        for (i = 0; i < this.dims.length; ++i) {
            if (data.dims[i] == this.dims[i]) continue;
            return false;
        }
        for (i = 0; i < this.datum.length; ++i) {
            if (data.datum[i] == this.datum[i]) continue;
            return false;
        }
        return true;
    }

    public static Data getData(long[] datum, int[] dims, Data help, Data units, Data error, Data validation) {
        try {
            return new Uint64Array(datum, dims, help, units, error, validation);
        }
        catch (Exception exc) {
            return null;
        }
    }

    @Override
    public Data getElementAt(int idx) {
        return new Uint64(this.datum[idx]);
    }

    @Override
    public int getSize() {
        return this.datum.length;
    }

    @Override
    protected Array getPortionAt(int startIdx, int[] newDims, int newSize) throws MdsException {
        long[] newDatum = new long[newSize];
        System.arraycopy(this.datum, startIdx, newDatum, 0, newSize);
        return new Uint64Array(newDatum, newDims);
    }

    @Override
    public void setElementAt(int idx, Data data) throws MdsException {
        this.datum[idx] = data.getLong();
    }

    @Override
    protected void setPortionAt(Array data, int startIdx, int size) throws MdsException {
        long[] newDatum = data.getLongArray();
        System.arraycopy(this.datum, startIdx, newDatum, 0, size);
    }

    @Override
    public byte[] getByteArray() {
        byte[] retDatum = new byte[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = (byte)this.datum[i];
        }
        return retDatum;
    }

    @Override
    public short[] getShortArray() {
        short[] retDatum = new short[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = (short)this.datum[i];
        }
        return retDatum;
    }

    @Override
    public int[] getIntArray() {
        int[] retDatum = new int[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = (int)this.datum[i];
        }
        return retDatum;
    }

    @Override
    public long[] getLongArray() {
        long[] retDatum = new long[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = this.datum[i];
        }
        return retDatum;
    }

    @Override
    public float[] getFloatArray() {
        float[] retDatum = new float[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = this.datum[i];
        }
        return retDatum;
    }

    @Override
    public double[] getDoubleArray() {
        double[] retDatum = new double[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = this.datum[i];
        }
        return retDatum;
    }

    @Override
    public String[] getStringArray() throws MdsException {
        throw new MdsException("Cannot convert byte array to string array");
    }

    @Override
    public int getSizeInBytes() {
        return this.getSize() * 8;
    }
}

