/*
 * Decompiled with CFR 0.152.
 */
package mds.wave;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import mds.wave.ContourSignal;
import mds.wave.SignalListener;
import mds.wave.WaveData;
import mds.wave.WaveDataListener;
import mds.wave.XYData;
import mds.wave.XYWaveData;

public class Signal
implements WaveDataListener {
    public static final int TYPE_1D = 0;
    public static final int TYPE_2D = 1;
    public static final int MODE_XZ = 0;
    public static final int MODE_YZ = 1;
    public static final int MODE_CONTOUR = 2;
    public static final int MODE_IMAGE = 3;
    public static final int MODE_ONDINE = 4;
    public static final int MODE_PROFILE = 5;
    public static final int MODE_LINE = 0;
    public static final int MODE_NOLINE = 2;
    public static final int MODE_STEP = 3;
    public static final int DEFAULT_CONTOUR_LEVEL = 20;
    public static final int FUSO = 0;
    public static final String[] markerList = new String[]{"None", "Square", "Circle", "Cross", "Triangle", "Point"};
    static final int[] markerStepList = new int[]{1, 5, 10, 20, 50, 100};
    public static final int NONE = 0;
    public static final int SQUARE = 1;
    public static final int CIRCLE = 2;
    public static final int CROSS = 3;
    public static final int TRIANGLE = 4;
    public static final int POINT = 5;
    static final int NUM_POINTS = 2000;
    public static final int SIMPLE = 0;
    public static final int AT_CREATION = 1;
    public static final int FIXED_LIMIT = 2;
    public static final int DO_NOT_UPDATE = 4;
    private static final int DEFAULT_INC_SIZE = 10000;
    boolean debug = false;
    private WaveData data;
    private WaveData x_data;
    private WaveData up_errorData;
    private WaveData low_errorData;
    private boolean xLimitsInitialized = false;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    private double saved_xmin = -1.7976931348623157E308;
    private double saved_xmax = Double.MAX_VALUE;
    private double saved_ymin = -1.7976931348623157E308;
    private double saved_ymax = Double.MAX_VALUE;
    private boolean error;
    private boolean asym_error;
    private int[] nans;
    private int n_nans = 0;
    private int prev_idx = 0;
    private double t_xmax;
    private double t_xmin;
    private double t_ymax;
    private double t_ymin;
    private boolean increasing_x = true;
    protected String name;
    protected int marker = 0;
    protected int marker_step = 1;
    protected int color_idx = 0;
    protected Color color = null;
    protected boolean interpolate = true;
    protected float gain = 1.0f;
    protected float offset = 0.0f;
    protected int type = 0;
    protected int mode2D;
    protected int mode1D;
    protected double curr_x_yz_plot = Double.NaN;
    protected float curr_y_xz_plot = Float.NaN;
    private int curr_y_xz_idx = -1;
    private int curr_x_yz_idx = -1;
    private double[] sliceX;
    private float[] sliceY;
    protected double z2D_max;
    protected double z2D_min;
    protected double y2D_max;
    protected double y2D_min;
    protected double x2D_max;
    protected double x2D_min;
    protected double curr_xmax;
    protected double curr_xmin;
    protected String xlabel;
    protected String ylabel;
    protected String zlabel;
    protected String title;
    private String legend = null;
    private boolean full_load = false;
    private boolean longXLimits = false;
    private long xMinLong;
    private long xMaxLong;
    ContourSignal cs;
    private double[] contourLevels;
    Vector<Vector<Vector<Point2D.Double>>> contourSignals = new Vector();
    Vector<Double> contourLevelValues = new Vector();
    final int NOT_FREEZED = 0;
    final int FREEZED_BLOCK = 1;
    final int FREEZED_SCROLL = 2;
    int freezeMode = 0;
    double freezedXMin;
    double freezedXMax;
    Vector<XYData> pendingUpdatesV = new Vector();
    Vector<SignalListener> signalListeners = new Vector();
    double[] x2D;
    long[] x2DLong;
    float[] y2D;
    float[] z;
    double[] xY2D;
    float[] yY2D;
    float[] zY2D;
    double[] x = null;
    float[] y = null;
    long[] xLong = null;
    float[] upError;
    float[] lowError;
    boolean upToDate = false;
    ResolutionManager resolutionManager = new ResolutionManager();
    private double z_value = Double.NaN;
    private boolean find_NaN = false;
    private int img_xprev = 0;
    private int img_yprev = 0;
    boolean fix_xmin = false;
    boolean fix_xmax = false;
    boolean fix_ymin = false;
    boolean fix_ymax = false;
    private int updSignalSizeInc;
    public int startIndexToUpdate = 0;
    public boolean needFullUpdate = true;
    private int x2D_points = 0;
    private int y2D_points = 0;
    private int z2D_points = 0;

    static String toStringTime(long time) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:sss");
        return df.format(new Date(time));
    }

    public Signal() {
        this.asym_error = false;
        this.error = false;
        double[] x = new double[]{0.0, 1.0};
        float[] y = new float[]{0.0f, 0.0f};
        this.data = new XYWaveData(x, y);
        this.setAxis();
        this.saved_xmin = this.curr_xmin = this.xmin;
        this.saved_xmax = this.curr_xmax = this.xmax;
        this.ymin = 0.0;
        this.saved_ymin = 0.0;
        this.ymax = 0.0;
        this.saved_ymax = 0.0;
        this.increasing_x = true;
    }

    public Signal(double[] _x, float[] _y) {
        this.asym_error = false;
        this.error = false;
        this.data = new XYWaveData(_x, _y, _x.length < _y.length ? _x.length : _y.length);
        this.setAxis();
        this.saved_xmin = this.curr_xmin = this.xmin;
        this.saved_xmax = this.curr_xmax = this.xmax;
        this.saved_ymin = this.ymin;
        this.saved_ymax = this.ymax;
        this.checkIncreasingX();
    }

    public Signal(double[] _x, float[] _y, int _n_points) throws IOException {
        this.asym_error = false;
        this.error = false;
        this.data = new XYWaveData(_x, _y, _n_points);
        this.setAxis();
        this.saved_xmin = this.curr_xmin = this.xmin;
        this.saved_xmax = this.curr_xmax = this.xmax;
        this.saved_ymin = this.ymin;
        this.saved_ymax = this.ymax;
        this.checkIncreasingX();
    }

    public Signal(float[] _x, float[] _y) {
        this.asym_error = false;
        this.error = false;
        this.data = new XYWaveData(_x, _y, _x.length < _y.length ? _x.length : _y.length);
        this.setAxis();
        this.saved_xmin = this.curr_xmin = this.xmin;
        this.saved_xmax = this.curr_xmax = this.xmax;
        this.saved_ymin = this.ymin;
        this.saved_ymax = this.ymax;
        this.checkIncreasingX();
    }

    public Signal(float[] _x, float[] _y, int _n_points) throws IOException {
        this.asym_error = false;
        this.error = false;
        this.data = new XYWaveData(_x, _y, _n_points);
        this.setAxis();
        this.xLimitsInitialized = true;
        this.saved_xmin = this.curr_xmin = this.xmin;
        this.saved_xmax = this.curr_xmax = this.xmax;
        this.saved_ymin = this.ymin;
        this.saved_ymax = this.ymax;
        this.checkIncreasingX();
    }

    public Signal(float[] _x, float[] _y, int _n_points, double _xmin, double _xmax, double _ymin, double _ymax) {
        this.asym_error = false;
        this.error = false;
        this.data = new XYWaveData(_x, _y, _n_points);
        this.xLimitsInitialized = true;
        this.xmin = _xmin;
        this.xmax = _xmax;
        if (this.xmax - this.xmin < (double)(_x[1] - _x[0])) {
            this.xmax = this.xmin + (double)_x[1] - (double)_x[0];
        }
        this.saved_xmin = this.curr_xmin = this.xmin;
        this.saved_xmax = this.curr_xmax = this.xmax;
        if (this.xmax <= this.xmin) {
            this.saved_xmax = this.xmax = this.xmin + (double)1.0E-6f;
        }
        if (_ymin > _ymax) {
            _ymin = _ymax;
        }
        this.saved_ymin = this.ymin = _ymin;
        this.saved_ymax = this.ymax = _ymax;
        this.curr_xmax = this.xmax;
        this.curr_xmin = this.xmin;
        this.setAxis();
        this.ymin = this.saved_ymin;
        this.ymax = this.saved_ymax;
        this.saved_xmin = this.curr_xmin = this.xmin;
        this.saved_xmax = this.curr_xmax = this.xmax;
        this.checkIncreasingX();
    }

    public Signal(float[] _x, float[] _y, String name) {
        this(_x, _y);
        this.setName(new String(name));
    }

    public Signal(long[] _x, float[] _y, int _n_points) {
        this.asym_error = false;
        this.error = false;
        this.data = new XYWaveData(_x, _y);
        this.setAxis();
        this.saved_xmin = this.curr_xmin = this.xmin;
        this.saved_xmax = this.curr_xmax = this.xmax;
        this.saved_ymin = this.ymin;
        this.saved_ymax = this.ymax;
        this.checkIncreasingX();
    }

    public Signal(Signal s) {
        this.error = s.error;
        if (this.error) {
            this.upError = s.upError;
        }
        this.asym_error = s.asym_error;
        if (this.asym_error) {
            this.lowError = s.lowError;
        }
        this.nans = s.nans;
        this.n_nans = s.n_nans;
        this.gain = s.gain;
        this.offset = s.offset;
        this.cs = s.cs;
        this.contourLevels = s.contourLevels;
        this.contourSignals = s.contourSignals;
        this.contourLevelValues = s.contourLevelValues;
        this.data = s.data;
        this.data.addWaveDataListener(this);
        this.resolutionManager = new ResolutionManager(s.resolutionManager);
        this.xLimitsInitialized = s.xLimitsInitialized;
        this.saved_ymax = s.saved_ymax;
        this.ymax = s.ymax;
        this.saved_ymin = s.saved_ymin;
        this.ymin = s.ymin;
        this.saved_xmin = s.saved_xmin;
        this.curr_xmin = s.curr_xmin;
        this.xmin = s.xmin;
        this.saved_xmax = s.saved_xmax;
        this.curr_xmax = s.curr_xmax;
        this.xmax = s.xmax;
        this.fix_xmin = s.fix_xmin;
        this.fix_xmax = s.fix_xmax;
        this.fix_ymin = s.fix_ymin;
        this.fix_ymax = s.fix_ymax;
        this.x2D_max = s.x2D_max;
        this.x2D_min = s.x2D_min;
        this.y2D_max = s.y2D_max;
        this.y2D_min = s.y2D_min;
        this.z2D_max = s.z2D_max;
        this.z2D_min = s.z2D_min;
        if (this.xmax <= this.xmin) {
            this.saved_xmax = this.xmax = this.xmin + 1.0E-6;
        }
        this.increasing_x = s.increasing_x;
        this.marker = s.marker;
        this.marker_step = s.marker_step;
        this.color_idx = s.color_idx;
        this.color = s.color;
        this.interpolate = s.interpolate;
        this.name = s.name;
        this.type = s.type;
        this.mode1D = s.mode1D;
        this.mode2D = s.mode2D;
        this.xlabel = s.xlabel;
        this.ylabel = s.ylabel;
        this.zlabel = s.zlabel;
        this.title = s.title;
        if (s.x != null) {
            this.x = new double[s.x.length];
            System.arraycopy(s.x, 0, this.x, 0, this.x.length);
        }
        if (s.y != null) {
            this.y = new float[s.y.length];
            System.arraycopy(s.y, 0, this.y, 0, this.y.length);
        }
        if (s.xLong != null) {
            this.xLong = new long[s.xLong.length];
            System.arraycopy(s.xLong, 0, this.xLong, 0, this.xLong.length);
        }
        this.x_data = s.x_data;
        if (s.x2D != null) {
            this.x2D = new double[s.x2D.length];
            System.arraycopy(s.x2D, 0, this.x2D, 0, this.x2D.length);
        }
        if (s.x2DLong != null) {
            this.x2DLong = new long[s.x2DLong.length];
            System.arraycopy(s.x2DLong, 0, this.x2DLong, 0, this.x2DLong.length);
        }
        if (s.y2D != null) {
            this.y2D = new float[s.y2D.length];
            System.arraycopy(s.y2D, 0, this.y2D, 0, this.y2D.length);
        }
        if (s.z != null) {
            this.z = new float[s.z.length];
            System.arraycopy(s.z, 0, this.z, 0, this.z.length);
        }
        if (s.xY2D != null) {
            this.xY2D = new double[s.xY2D.length];
            System.arraycopy(s.xY2D, 0, this.xY2D, 0, this.xY2D.length);
        }
        if (s.yY2D != null) {
            this.yY2D = new float[s.yY2D.length];
            System.arraycopy(s.yY2D, 0, this.yY2D, 0, this.yY2D.length);
        }
        if (s.zY2D != null) {
            this.zY2D = new float[s.zY2D.length];
            System.arraycopy(s.zY2D, 0, this.zY2D, 0, this.zY2D.length);
        }
        this.startIndexToUpdate = s.startIndexToUpdate;
        this.freezeMode = s.freezeMode;
        this.longXLimits = s.longXLimits;
        this.xMinLong = s.xMinLong;
        this.xMaxLong = s.xMaxLong;
    }

    public Signal(Signal s, double start_x, double end_x, double start_y, double end_y) {
        this.xLimitsInitialized = true;
        this.data = s.data;
        this.nans = s.nans;
        this.n_nans = s.n_nans;
        this.error = s.error;
        if (this.error) {
            this.upError = s.upError;
        }
        this.asym_error = s.asym_error;
        if (this.asym_error) {
            this.lowError = s.lowError;
        }
        this.increasing_x = s.increasing_x;
        this.saved_ymax = s.saved_ymax;
        this.ymax = end_y;
        this.saved_ymin = s.saved_ymin;
        this.ymin = start_y;
        this.saved_xmin = this.curr_xmin = s.saved_xmin;
        this.xmin = start_x;
        this.saved_xmax = this.curr_xmax = s.saved_xmax;
        this.xmax = end_x;
        if (this.xmax <= this.xmin) {
            this.curr_xmax = this.xmax = this.xmin + 1.0E-6;
            this.saved_xmax = this.xmax;
        }
        this.marker = s.marker;
        this.marker_step = s.marker_step;
        this.color_idx = s.color_idx;
        this.color = s.color;
        this.interpolate = s.interpolate;
        this.name = s.name;
    }

    public Signal(String name) {
        this();
        this.name = name;
    }

    public Signal(WaveData data, double xmin, double xmax) throws IOException {
        this(data, null, xmin, xmax);
    }

    public Signal(WaveData data, WaveData x_data, double xminVal, double xmaxVal) throws IOException {
        this(data, x_data, xminVal, xmaxVal, null, null);
    }

    public Signal(WaveData data, WaveData x_data, double xminVal, double xmaxVal, WaveData lowErrData, WaveData upErrData) throws IOException {
        this.error = lowErrData != null || upErrData != null;
        this.asym_error = lowErrData != null && upErrData != null;
        this.up_errorData = upErrData;
        this.low_errorData = lowErrData;
        if (xminVal != -1.7976931348623157E308) {
            this.xLimitsInitialized = true;
            this.xmin = this.curr_xmin = xminVal;
            this.saved_xmin = this.curr_xmin;
        }
        if (xmaxVal != Double.MAX_VALUE) {
            this.xmax = this.curr_xmax = xmaxVal;
            this.saved_xmax = this.curr_xmax;
        }
        this.data = data;
        this.x_data = x_data;
        data.addWaveDataListener(this);
        this.checkData(this.saved_xmin, this.saved_xmax);
        if (this.saved_xmin == -1.7976931348623157E308) {
            this.saved_xmin = this.xmin;
        }
        if (this.saved_xmax == Double.MAX_VALUE) {
            this.saved_xmax = this.xmax;
        }
    }

    public Signal(WaveData data, WaveData x_data, long xminVal, long xmaxVal) throws IOException {
        this(data, x_data, xminVal, xmaxVal, (WaveData)null, (WaveData)null);
    }

    public Signal(WaveData data, WaveData x_data, long xminVal, long xmaxVal, WaveData lowErrData, WaveData upErrData) throws IOException {
        this.xMinLong = xminVal;
        this.xMaxLong = xmaxVal;
        this.longXLimits = true;
        this.error = lowErrData != null || upErrData != null;
        this.asym_error = lowErrData != null && upErrData != null;
        this.up_errorData = upErrData;
        this.low_errorData = lowErrData;
        if ((double)xminVal != -1.7976931348623157E308) {
            this.xLimitsInitialized = true;
            this.xmin = this.curr_xmin = (double)xminVal;
            this.saved_xmin = this.curr_xmin;
        }
        if ((double)xmaxVal != Double.MAX_VALUE) {
            this.xmax = this.curr_xmax = (double)xmaxVal;
            this.saved_xmax = this.curr_xmax;
        }
        this.data = data;
        this.x_data = x_data;
        try {
            this.checkData(this.saved_xmin, this.saved_xmax);
            if (this.saved_xmin == -1.7976931348623157E308) {
                this.saved_xmin = this.xmin;
            }
            if (this.saved_xmax == Double.MAX_VALUE) {
                this.saved_xmax = this.xmax;
            }
        }
        catch (Exception exc) {
            System.out.println("Signal exception: " + exc);
        }
        data.addWaveDataListener(this);
    }

    public void AddAsymError(WaveData up_error, WaveData low_error) {
        this.asym_error = true;
        this.error = true;
        this.up_errorData = up_error;
        this.low_errorData = low_error;
    }

    public Vector<Vector<Point2D.Double>> addContourLevel(double level) {
        Vector<Vector<Point2D.Double>> v;
        if (this.cs == null) {
            this.cs = new ContourSignal(this);
        }
        if ((v = this.cs.contour(level)).size() != 0) {
            this.contourSignals.addElement(v);
            this.contourLevelValues.addElement(new Double(level));
        }
        return v;
    }

    public void AddError(WaveData in_error) {
        this.error = true;
        this.up_errorData = this.low_errorData = in_error;
    }

    void adjustArraySizes() {
        if (this.x.length < this.y.length) {
            float[] newY = new float[this.x.length];
            System.arraycopy(this.y, 0, newY, 0, this.x.length);
            this.y = newY;
        }
        if (this.y.length < this.x.length) {
            double[] newX = new double[this.y.length];
            System.arraycopy(this.x, 0, newX, 0, this.y.length);
            this.x = newX;
        }
    }

    private double[] appendArray(double[] arr1, int sizeUsed, double[] arr2, int incSize) {
        double[] val;
        if (arr1 == null) {
            return (double[])arr2.clone();
        }
        if (arr2 == null) {
            return (double[])arr1.clone();
        }
        if (arr1.length < sizeUsed + arr2.length) {
            val = new double[arr1.length + arr2.length + incSize];
            System.arraycopy(arr1, 0, val, 0, sizeUsed);
        } else {
            val = arr1;
        }
        System.arraycopy(arr2, 0, val, sizeUsed, arr2.length);
        return val;
    }

    private float[] appendArray(float[] arr1, int sizeUsed, float[] arr2, int incSize) {
        float[] val;
        if (arr1 == null) {
            return (float[])arr2.clone();
        }
        if (arr2 == null) {
            return (float[])arr1.clone();
        }
        if (arr1.length < sizeUsed + arr2.length) {
            val = new float[arr1.length + arr2.length + incSize];
            System.arraycopy(arr1, 0, val, 0, sizeUsed);
        } else {
            val = arr1;
        }
        System.arraycopy(arr2, 0, val, sizeUsed, arr2.length);
        return val;
    }

    public void appendValues(double[] x, float[] y, int[] numPoints, float[] time) {
        int zIdx;
        if (this.type != 1 || x.length != y.length || time == null || numPoints == null) {
            return;
        }
        int numProfile = 0;
        double[] x2D = this.data.getX2D();
        float[] y2D = this.data.getY2D();
        float[] z2D = this.data.getZ();
        int xIdx = x2D == null ? 0 : this.x2D_points;
        int yIdx = y2D == null ? 0 : this.y2D_points;
        int n = zIdx = z2D == null ? 0 : this.z2D_points;
        if (numPoints.length == time.length) {
            numProfile = time.length * 2;
        } else if (numPoints.length > time.length) {
            numProfile = numPoints.length * 2;
        } else if (numPoints.length < time.length) {
            numProfile = time.length * 2;
        }
        float[] t = new float[numProfile];
        int j = 0;
        for (int i = 0; i < numProfile; i += 2) {
            t[i] = time.length == 1 ? time[0] : time[j];
            t[i + 1] = numPoints.length == 1 ? (float)numPoints[0] : (float)numPoints[j];
            ++j;
        }
        x2D = this.appendArray(x2D, this.x2D_points, x, this.updSignalSizeInc);
        this.x2D_points += x.length;
        y2D = this.appendArray(y2D, this.y2D_points, y, this.updSignalSizeInc);
        this.y2D_points += y.length;
        z2D = this.appendArray(z2D, this.z2D_points, t, this.updSignalSizeInc);
        this.z2D_points += t.length;
        this.data = new XYWaveData(x2D, y2D, z2D);
        this.setAxis(x2D, z2D, y2D, xIdx, zIdx, yIdx);
        if (this.xmin > this.x2D_min) {
            this.xmin = this.x2D_min;
        }
        if (this.ymin > this.y2D_min) {
            this.ymin = this.y2D_min;
        }
        if (this.xmax < this.x2D_max) {
            this.xmax = this.x2D_max;
        }
        if (this.ymax < this.y2D_max) {
            this.ymax = this.y2D_max;
        }
        this.curr_x_yz_plot = t[t.length - 2];
    }

    public void appendValues(float[] inX, float[] inY) {
        if (this.x == null || this.y == null) {
            return;
        }
        if (this.type == 0) {
            int i;
            int len = inX.length < inY.length ? inX.length : inY.length;
            double[] newX = new double[this.x.length + len];
            float[] newY = new float[this.x.length + len];
            for (i = 0; i < this.x.length; ++i) {
                newX[i] = this.x[i];
                newY[i] = this.y[i];
            }
            for (i = 0; i < len; ++i) {
                newX[this.x.length + i] = inX[i];
                newY[this.x.length + i] = inY[i];
            }
            this.data = new XYWaveData(newX, newY);
            try {
                XYData xyData = this.data.getData(2000);
                this.x = xyData.x;
                this.y = xyData.y;
                this.adjustArraySizes();
                this.xmax = this.x[this.x.length - 1];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void Autoscale() {
        this.freezeMode = 0;
        this.setAxis();
        this.AutoscaleX();
        this.AutoscaleY();
    }

    public void AutoscaleX() {
        if (this.type == 1 && (this.mode2D == 3 || this.mode2D == 2)) {
            this.xmax = this.x2D_max;
            this.xmin = this.x2D_min;
            return;
        }
        double[] currX = this.type == 1 && (this.mode2D == 0 || this.mode2D == 1) ? this.sliceX : this.x;
        if (this.x == null || this.x.length == 0) {
            return;
        }
        this.xmin = this.xmax = currX[0];
        for (double element : currX) {
            if (element < this.xmin) {
                this.xmin = element;
            }
            if (!(element > this.xmax)) continue;
            this.xmax = element;
        }
        if (this.xmin == this.xmax) {
            this.xmax = this.xmin + (double)1.0E-10f;
        }
    }

    public void AutoscaleY() {
        int startIdx;
        if (this.type == 1) {
            if (this.mode2D == 3 || this.mode2D == 2) {
                this.ymax = this.y2D_max;
                this.ymin = this.y2D_min;
                return;
            }
            this.ymax = this.ymin = (double)this.sliceY[0];
            for (float element : this.sliceY) {
                if ((double)element < this.ymin) {
                    this.ymin = element;
                }
                if (!((double)element > this.ymax)) continue;
                this.ymax = element;
            }
            if (this.ymin == this.ymax) {
                this.ymax = this.ymin + this.ymin / 4.0;
            }
            return;
        }
        if (this.y == null || this.y.length == 0) {
            return;
        }
        float[] currY = this.type == 1 && (this.mode2D == 0 || this.mode2D == 1) ? this.sliceY : this.y;
        if (currY == null || this.y == null) {
            return;
        }
        for (startIdx = 0; startIdx < currY.length && Float.isNaN(this.y[startIdx]); ++startIdx) {
        }
        this.ymin = this.ymax = (double)this.y[startIdx];
        for (int i = startIdx; i < currY.length; ++i) {
            if (Float.isNaN(this.y[startIdx])) continue;
            if ((double)currY[i] < this.ymin) {
                this.ymin = currY[i];
            }
            if (!((double)currY[i] > this.ymax)) continue;
            this.ymax = currY[i];
        }
        if (this.ymin == this.ymax) {
            this.ymax = this.ymin + this.ymin / 4.0;
        }
    }

    public void AutoscaleY(double min, double max) {
        int i;
        double[] currX;
        float[] currY;
        if (this.type == 1 && (this.mode2D == 3 || this.mode2D == 2)) {
            this.ymin = this.y2D_min;
            this.ymax = this.y2D_max;
            return;
        }
        if (this.type == 1 && (this.mode2D == 0 || this.mode2D == 1)) {
            currY = this.sliceY;
            currX = this.sliceX;
        } else {
            currY = this.y;
            currX = this.x;
        }
        if (currX == null || currY == null) {
            return;
        }
        int len = currX.length < currY.length ? currX.length : currY.length;
        for (i = 0; i < len; ++i) {
            if (!(currX[i] >= min) || !(currX[i] <= this.xmax)) continue;
            this.ymin = this.ymax = (double)currY[i];
            break;
        }
        for (i = 0; i < len; ++i) {
            if (!(currX[i] >= min) || !(currX[i] <= max)) continue;
            if ((double)currY[i] < this.ymin) {
                this.ymin = currY[i];
            }
            if (!((double)currY[i] > this.ymax)) continue;
            this.ymax = currY[i];
        }
    }

    void checkData(double xMin, double xMax) throws IOException {
        int numDimensions;
        try {
            numDimensions = this.data.getNumDimension();
        }
        catch (Exception exc) {
            numDimensions = 1;
        }
        if (numDimensions == 1) {
            XYData xyData;
            this.type = 0;
            if (this.x == null) {
                xyData = !this.error ? (this.longXLimits ? this.data.getData(this.xMinLong, this.xMaxLong, 2000) : this.data.getData(xMin, xMax, 2000)) : (this.longXLimits ? this.data.getData(this.xMinLong, this.xMaxLong, Integer.MAX_VALUE) : this.data.getData(xMin, xMax, Integer.MAX_VALUE));
                if (xyData == null) {
                    return;
                }
                this.x = xyData.x;
                this.y = xyData.y;
                this.adjustArraySizes();
                this.increasing_x = xyData.increasingX;
                if (this.longXLimits) {
                    this.xmin = xMin == 0.0 ? (this.curr_xmin = xyData.xMin) : (this.curr_xmin = xMin);
                    this.xmax = xMax == 0.0 ? (this.curr_xmax = xyData.xMax) : (this.curr_xmax = xMax);
                } else {
                    this.xmin = xMin == -1.7976931348623157E308 ? (this.curr_xmin = xyData.xMin) : (this.curr_xmin = xMin);
                    this.xmax = xMax == Double.MAX_VALUE ? (this.curr_xmax = xyData.xMax) : (this.curr_xmax = xMax);
                }
                if (this.y.length > 0) {
                    this.ymin = this.ymax = (double)this.y[0];
                    for (float element : this.y) {
                        if ((double)element < this.ymin) {
                            this.ymin = element;
                        }
                        if (!((double)element > this.ymax)) continue;
                        this.ymax = element;
                    }
                    if (this.data.isXLong()) {
                        this.xLong = xyData.xLong;
                    }
                    this.resolutionManager.addRegion(new RegionDescriptor(xMin, xMax, xyData.resolution));
                }
            }
            if (this.up_errorData != null && this.upError == null) {
                xyData = this.up_errorData.getData(xMin, xMax, Integer.MAX_VALUE);
                this.upError = xyData.y;
            }
            if (this.low_errorData != null && this.lowError == null) {
                xyData = this.low_errorData.getData(xMin, xMax, Integer.MAX_VALUE);
                this.lowError = xyData.y;
            }
            if (this.saved_ymin == -1.7976931348623157E308) {
                this.saved_ymin = this.ymin;
            }
            if (this.saved_ymax == Double.MAX_VALUE) {
                this.saved_ymax = this.ymax;
            }
        } else if (numDimensions == 2) {
            this.type = 1;
            this.x2D = this.data.getX2D();
            if (this.x2D == null && this.data.isXLong()) {
                this.x2DLong = this.data.getX2DLong();
                this.x2D = new double[this.x2DLong.length];
                for (int i = 0; i < this.x2DLong.length; ++i) {
                    this.x2D[i] = this.x2DLong[i];
                }
            }
            this.y2D = this.data.getY2D();
            this.z = this.data.getZ();
            if (this.x_data != null) {
                this.xY2D = this.x_data.getX2D();
                this.yY2D = this.x_data.getY2D();
                this.zY2D = this.x_data.getZ();
                if (this.xY2D == null || this.yY2D == null || this.zY2D == null || this.xY2D != null && this.yY2D != null && this.zY2D != null && (this.x2D != null && this.x2D.length != this.xY2D.length || this.x2DLong != null && this.x2DLong.length != this.xY2D.length && this.y2D.length != this.yY2D.length && this.z.length != this.zY2D.length)) {
                    this.xY2D = null;
                    this.yY2D = null;
                    this.zY2D = null;
                    this.x_data = null;
                }
            }
            double[] x2DVal = this.x2D;
            this.x2D_min = this.x2D_max = x2DVal[0];
            for (int i = 0; i < this.x2D.length; ++i) {
                if (x2DVal[i] < this.x2D_min) {
                    this.x2D_min = x2DVal[i];
                }
                if (!(x2DVal[i] > this.x2D_max)) continue;
                this.x2D_max = x2DVal[i];
            }
            if (this.y2D != null && this.y2D.length > 0) {
                this.y2D_min = this.y2D_max = (double)this.y2D[0];
                for (float element : this.y2D) {
                    if ((double)element < this.y2D_min) {
                        this.y2D_min = element;
                    }
                    if (!((double)element > this.y2D_max)) continue;
                    this.y2D_max = element;
                }
            } else {
                this.y2D_max = 0.0;
                this.y2D_min = 0.0;
            }
            if (this.z != null && this.z.length > 0) {
                this.z2D_min = this.z2D_max = (double)this.z[0];
                for (float element : this.z) {
                    if ((double)element < this.z2D_min) {
                        this.z2D_min = element;
                    }
                    if (!((double)element > this.z2D_max)) continue;
                    this.z2D_max = element;
                }
            } else {
                this.z2D_max = 0.0;
                this.z2D_min = 0.0;
            }
            this.xmin = xMin == -1.7976931348623157E308 ? (this.curr_xmin = this.x2D_min) : (this.curr_xmin = xMin);
            this.xmax = xMax == Double.MAX_VALUE ? (this.curr_xmax = this.x2D_max) : (this.curr_xmax = xMax);
        } else {
            System.out.println("ERROR: UP TO 2 Dimensions supported");
        }
    }

    void checkIncreasingX() {
        if (this.type == 1) {
            this.checkIncreasingX2D();
            return;
        }
        this.increasing_x = true;
        for (int i = 1; i < this.x.length; ++i) {
            if (!(this.x[i] < this.x[i - 1])) continue;
            this.increasing_x = false;
            return;
        }
    }

    void checkIncreasingX2D() {
        this.increasing_x = true;
        double[] x = this.x2D;
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i] < x[i - 1])) continue;
            this.increasing_x = false;
            return;
        }
    }

    @Override
    public void dataRegionUpdated(double[] regX, float[] regY, double resolution) {
        int i;
        int samplesAfter;
        int samplesBefore;
        if (regX == null || regX.length == 0) {
            return;
        }
        if (this.debug) {
            System.out.println("dataRegionUpdated " + this.resolutionManager.lowResRegions.size() + " new data len:" + regX.length + " XMIN:" + regX[0] + "  XMAX: " + regX[regX.length - 1]);
        }
        if (this.freezeMode != 0) {
            this.pendingUpdatesV.addElement(new XYData(regX, regY, resolution, true, regX[0], regX[regX.length - 1]));
            return;
        }
        if (this.x == null) {
            this.x = new double[0];
        }
        if (this.y == null) {
            this.y = new float[0];
        }
        for (samplesBefore = 0; samplesBefore < this.x.length && this.x[samplesBefore] < regX[0]; ++samplesBefore) {
        }
        if (samplesBefore > 0 && samplesBefore < this.x.length && this.x[samplesBefore] > regX[0]) {
            --samplesBefore;
        }
        for (samplesAfter = 0; samplesAfter < this.x.length - 1 && this.x[this.x.length - samplesAfter - 1] > regX[regX.length - 1]; ++samplesAfter) {
        }
        double[] newX = new double[samplesBefore + regX.length + samplesAfter];
        float[] newY = new float[samplesBefore + regX.length + samplesAfter];
        for (i = 0; i < samplesBefore; ++i) {
            newX[i] = this.x[i];
            newY[i] = this.y[i];
        }
        for (i = 0; i < regX.length; ++i) {
            newX[samplesBefore + i] = regX[i];
            newY[samplesBefore + i] = regY[i];
        }
        for (i = 0; i < samplesAfter; ++i) {
            newX[newX.length - i - 1] = this.x[this.x.length - i - 1];
            newY[newX.length - i - 1] = this.y[this.x.length - i - 1];
        }
        if (this.x.length == 0 || regX[0] >= this.x[this.x.length - 1]) {
            this.resolutionManager.appendRegion(new RegionDescriptor(regX[0], regX[regX.length - 1], resolution));
            if (this.xmax < newX[newX.length - 1]) {
                this.xmax = newX[newX.length - 1];
            }
            this.x = newX;
            this.y = newY;
            this.fireSignalUpdated(true);
        } else {
            this.resolutionManager.addRegion(new RegionDescriptor(regX[0], regX[regX.length - 1], resolution));
            this.x = newX;
            this.y = newY;
            this.fireSignalUpdated(false);
        }
    }

    @Override
    public void dataRegionUpdated(long[] regX, float[] regY, double resolution) {
        if (regX == null || regX.length == 0) {
            return;
        }
        if (this.debug) {
            System.out.println("dataRegionUpdated " + this.resolutionManager.lowResRegions.size());
        }
        if (this.freezeMode == 1) {
            this.pendingUpdatesV.addElement(new XYData(regX, regY, resolution, true));
            return;
        }
        if (this.freezeMode == 2) {
            double delta = this.xmax - this.xmin;
            this.xmax = regX[regX.length - 1];
            this.xmin = this.xmax - delta;
        }
        if (this.xLong == null) {
            this.resolutionManager.appendRegion(new RegionDescriptor(regX[0], regX[regX.length - 1], resolution));
            this.xmin = regX[0];
            this.xmax = regX[regX.length - 1];
            this.xLong = regX;
            this.x = new double[regX.length];
            for (int i = 0; i < regX.length; ++i) {
                this.x[i] = regX[i];
            }
            this.y = regY;
            this.fireSignalUpdated(true);
        } else {
            int i;
            int samplesAfter;
            int samplesBefore;
            for (samplesBefore = 0; samplesBefore < this.xLong.length && this.xLong[samplesBefore] < regX[0]; ++samplesBefore) {
            }
            if (samplesBefore > 0 && samplesBefore < this.xLong.length && this.xLong[samplesBefore] > regX[0]) {
                --samplesBefore;
            }
            for (samplesAfter = 0; samplesAfter < this.xLong.length - 1 && this.xLong[this.xLong.length - samplesAfter - 1] > regX[regX.length - 1]; ++samplesAfter) {
            }
            if (samplesAfter > 0 && this.xLong.length - samplesAfter - 1 >= 0 && this.xLong[this.xLong.length - samplesAfter - 1] < regX[regX.length - 1]) {
                --samplesAfter;
            }
            if (samplesBefore > this.x.length) {
                samplesBefore = this.x.length;
            }
            if (samplesBefore > this.y.length) {
                samplesBefore = this.y.length;
            }
            double[] newX = new double[samplesBefore + regX.length + samplesAfter];
            long[] newXLong = new long[samplesBefore + regX.length + samplesAfter];
            float[] newY = new float[samplesBefore + regX.length + samplesAfter];
            for (i = 0; i < samplesBefore; ++i) {
                newX[i] = this.x[i];
                newXLong[i] = this.xLong[i];
                newY[i] = this.y[i];
            }
            for (i = 0; i < regX.length; ++i) {
                newX[samplesBefore + i] = regX[i];
                newXLong[samplesBefore + i] = regX[i];
                newY[samplesBefore + i] = regY[i];
            }
            for (i = 0; i < samplesAfter; ++i) {
                newXLong[newX.length - i - 1] = this.xLong[this.x.length - i - 1];
                newX[newX.length - i - 1] = this.x[this.x.length - i - 1];
                newY[newX.length - i - 1] = this.y[this.x.length - i - 1];
            }
            if (regX[0] >= this.xLong[this.xLong.length - 1]) {
                double delta = newX[newX.length - 1] - this.xmax;
                this.resolutionManager.appendRegion(new RegionDescriptor(regX[0], regX[regX.length - 1], resolution));
                if (this.freezeMode == 2) {
                    this.xmax += delta;
                    this.xmin += delta;
                } else if (this.freezeMode == 0) {
                    this.xmax = newX[newX.length - 1];
                }
                this.x = newX;
                this.xLong = newXLong;
                this.y = newY;
                this.fireSignalUpdated(true);
            } else {
                this.resolutionManager.addRegion(new RegionDescriptor(regX[0], regX[regX.length - 1], resolution));
                this.x = newX;
                this.xLong = newXLong;
                this.y = newY;
                this.fireSignalUpdated(false);
            }
        }
    }

    public void decShow() {
        if (this.type == 1) {
            switch (this.mode2D) {
                case 0: {
                    this.decShowXZ();
                    break;
                }
                case 1: {
                    this.decShowYZ();
                    break;
                }
            }
        }
    }

    public void decShowXZ() {
        if (this.type == 1 && this.mode2D == 0) {
            int idx = this.curr_y_xz_idx - 1;
            if (idx < 0) {
                idx = this.y2D.length - 1;
            }
            this.showXZ(idx);
        }
    }

    public void decShowYZ() {
        if (this.type == 1 && this.mode2D == 1) {
            int idx = this.curr_x_yz_idx - 1;
            if (idx < 0) {
                idx = this.x2D.length - 1;
            }
            this.showYZ(idx);
        }
    }

    void dispose() {
        if (this.data != null) {
            this.data.removeWaveDataListener(this);
        }
    }

    public int FindClosestIdx(double curr_x, double curr_y) {
        double[] currX;
        int i = 0;
        if (this.type == 1 && (this.mode2D == 3 || this.mode2D == 2)) {
            this.img_xprev = this.FindIndex(this.x2D, curr_x, this.img_xprev);
            this.img_yprev = this.FindIndex(this.y2D, curr_y, this.img_yprev);
            if (this.img_xprev > this.y2D.length) {
                return this.img_xprev - 6;
            }
            return this.img_xprev;
        }
        if (this.type == 0) {
            currX = this.x;
        } else if (this.mode2D == 0 || this.mode2D == 1) {
            currX = this.sliceX;
        } else {
            double[] xf = this.x2D;
            currX = new double[xf.length];
            for (int idx = 0; idx < xf.length; ++idx) {
                currX[idx] = xf[idx];
            }
        }
        if (this.increasing_x || this.type == 1) {
            if (currX == null || currX.length == 0) {
                return -1;
            }
            if (this.prev_idx >= currX.length) {
                this.prev_idx = currX.length - 1;
            }
            if (curr_x > currX[this.prev_idx]) {
                for (i = this.prev_idx; i < currX.length && currX[i] < curr_x; ++i) {
                }
                if (i > 0) {
                    --i;
                }
                this.prev_idx = i;
                return i;
            }
            if (curr_x < currX[this.prev_idx]) {
                for (i = this.prev_idx; i > 0 && currX[i] > curr_x; --i) {
                }
                this.prev_idx = i;
                return i;
            }
            return this.prev_idx;
        }
        if (curr_x > this.curr_xmax) {
            int min_idx;
            for (min_idx = 0; min_idx < currX.length && currX[min_idx] != this.curr_xmax; ++min_idx) {
            }
            if (min_idx == currX.length) {
                --min_idx;
            }
            return min_idx;
        }
        if (curr_x < this.curr_xmin) {
            int min_idx;
            for (min_idx = 0; min_idx < currX.length && currX[min_idx] != this.curr_xmin; ++min_idx) {
            }
            if (min_idx == currX.length) {
                --min_idx;
            }
            return min_idx;
        }
        int min_idx = 0;
        double min_dist = Double.MAX_VALUE;
        this.find_NaN = false;
        for (i = 0; i < this.x.length - 1; ++i) {
            if (Float.isNaN(this.y[i])) {
                this.find_NaN = true;
                continue;
            }
            if (!(curr_x > currX[i] && curr_x < currX[i + 1] || curr_x < currX[i] && curr_x > currX[i + 1]) && currX[i] != currX[i + 1]) continue;
            double curr_dist = (curr_x - currX[i]) * (curr_x - currX[i]) + (curr_y - (double)this.y[i]) * (curr_y - (double)this.y[i]);
            if (currX[i] != currX[i + 1] && !Float.isNaN(this.y[i + 1])) {
                curr_dist += (curr_x - currX[i + 1]) * (curr_x - currX[i + 1]) + (curr_y - (double)this.y[i + 1]) * (curr_y - (double)this.y[i + 1]);
            }
            if (!(curr_dist < min_dist)) continue;
            min_dist = curr_dist;
            min_idx = i;
        }
        return min_idx;
    }

    private int findIndex(double[] d, double v, int pIdx) {
        if (v > d[pIdx]) {
            int i;
            for (i = pIdx; i < d.length && d[i] < v; ++i) {
            }
            if (i > 0) {
                --i;
            }
            return i;
        }
        if (v < d[pIdx]) {
            int i;
            for (i = pIdx; i > 0 && d[i] > v; --i) {
            }
            return i;
        }
        return pIdx;
    }

    private int findIndex(float[] d, double v, int pIdx) {
        double[] o = new double[d.length];
        for (int i = 0; i < d.length; ++i) {
            o[i] = d[i];
        }
        return this.findIndex(o, v, pIdx);
    }

    private int FindIndex(double[] d, double v, int pIdx) {
        if (v > d[pIdx]) {
            int i;
            for (i = pIdx; i < d.length && d[i] < v; ++i) {
            }
            if (i > 0) {
                --i;
            }
            return i;
        }
        if (v < d[pIdx]) {
            int i;
            for (i = pIdx; i > 0 && d[i] > v; --i) {
            }
            return i;
        }
        return pIdx;
    }

    private int FindIndex(float[] d, double v, int pIdx) {
        double[] o = new double[d.length];
        for (int i = 0; i < d.length; ++i) {
            o[i] = d[i];
        }
        return this.FindIndex(o, v, pIdx);
    }

    public boolean findNaN() {
        return this.find_NaN;
    }

    void fireSignalUpdated(boolean changeLimits) {
        if (this.debug) {
            System.out.println("FIRE SIGNAL UPDATE " + this.signalListeners.size());
        }
        for (int i = 0; i < this.signalListeners.size(); ++i) {
            this.signalListeners.elementAt(i).signalUpdated(changeLimits);
        }
    }

    void freeze() {
        this.freezeMode = this.isLongX() && this.xmax > (double)this.xLong[this.xLong.length - 1] ? 2 : 1;
        this.freezedXMin = this.xmin;
        this.freezedXMax = this.xmax;
    }

    public boolean fullPaint() {
        return true;
    }

    private int getArrayIndex(double[] arr, double d) {
        int i = -1;
        if (i == -1) {
            for (i = 0; !(i >= arr.length - 1 || d > arr[i] && d < arr[i + 1] || d == arr[i]); ++i) {
            }
        }
        return i;
    }

    private int getArrayIndex(float[] arr, double d) {
        int i = -1;
        if (i == -1) {
            for (i = 0; !(i >= arr.length - 1 || d > (double)arr[i] && d < (double)arr[i + 1] || d == (double)arr[i]); ++i) {
            }
        }
        return i;
    }

    public float getClosestX(double x) {
        if (this.type == 1 && (this.mode2D == 3 || this.mode2D == 2)) {
            this.img_xprev = this.FindIndex(this.x2D, x, this.img_xprev);
            return (float)this.x2D[this.img_xprev];
        }
        return 0.0f;
    }

    public float getClosestY(double y) {
        if (this.type == 1 && (this.mode2D == 3 || this.mode2D == 2)) {
            this.img_yprev = this.FindIndex(this.y2D, y, this.img_yprev);
            return this.y2D[this.img_yprev];
        }
        return 0.0f;
    }

    public Color getColor() {
        return this.color;
    }

    public int getColorIdx() {
        return this.color_idx;
    }

    Vector<Double> getContourLevelValues() {
        return this.contourLevelValues;
    }

    Vector<Vector<Vector<Point2D.Double>>> getContourSignals() {
        return this.contourSignals;
    }

    public double getCurrentXmax() {
        return this.curr_xmax;
    }

    public double getCurrentXmin() {
        return this.curr_xmin;
    }

    int getFreezeMode() {
        return this.freezeMode;
    }

    public float getGain() {
        return this.gain;
    }

    public boolean getInterpolate() {
        return this.interpolate;
    }

    public String getLegend() {
        return this.legend;
    }

    public float[] getLowError() {
        return this.lowError;
    }

    public int getMarker() {
        return this.marker;
    }

    public int getMarkerStep() {
        if (this.marker == 5) {
            return 1;
        }
        return this.marker_step;
    }

    public int getMode1D() {
        return this.mode1D;
    }

    public int getMode2D() {
        return this.mode2D;
    }

    public String getName() {
        return this.name;
    }

    public int[] getNaNs() {
        return this.nans;
    }

    public int getNumNaNs() {
        return this.n_nans;
    }

    public int getNumPoints() {
        if (this.type == 1 && (this.mode2D == 1 || this.mode2D == 0) && this.sliceX != null) {
            return this.sliceX.length;
        }
        if (this.data != null) {
            try {
                return this.x.length < this.y.length ? this.x.length : this.y.length;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public float getOffset() {
        return this.offset;
    }

    public double getOriginalYmax() {
        return this.saved_ymax;
    }

    public double getOriginalYmin() {
        return this.saved_ymin;
    }

    public String getStringOfXinYZplot() {
        if (this.isLongX()) {
            return Signal.toStringTime((long)this.curr_x_yz_plot);
        }
        return "" + this.curr_x_yz_plot;
    }

    public String getTitlelabel() {
        return this.title;
    }

    public int getType() {
        return this.type;
    }

    public int getUpdSignalSizeInc() {
        return this.updSignalSizeInc;
    }

    public float[] getUpError() {
        return this.upError;
    }

    public double[] getX() throws IOException {
        if (this.type == 1 && (this.mode2D == 0 || this.mode2D == 1)) {
            return this.sliceX;
        }
        return this.x;
    }

    public double getX(int idx) {
        try {
            if (this.type == 1 && (this.mode2D == 1 || this.mode2D == 0)) {
                return this.sliceX[idx];
            }
            return this.x[idx];
        }
        catch (Exception exc) {
            return 0.0;
        }
    }

    public double[] getX2D() {
        if (this.x2D == null) {
            this.x2D = this.data.getX2D();
        }
        return this.x2D;
    }

    public double getX2Dmax() {
        return this.x2D_max;
    }

    public double getX2Dmin() {
        return this.x2D_min;
    }

    public double getXinYZplot() {
        return this.curr_x_yz_plot;
    }

    public String getXlabel() {
        return this.xlabel;
    }

    public double getXmax() {
        return this.xmax;
    }

    public double getXmin() {
        return this.xmin;
    }

    public float[] getY() throws IOException {
        if (this.type == 1 && (this.mode2D == 0 || this.mode2D == 1)) {
            return this.sliceY;
        }
        return this.y;
    }

    public float getY(int idx) {
        try {
            if (this.type == 1 && (this.mode2D == 1 || this.mode2D == 0)) {
                return this.sliceY[idx];
            }
            return this.y[idx];
        }
        catch (Exception exc) {
            return 0.0f;
        }
    }

    public float[] getY2D() {
        if (this.y2D == null) {
            this.y2D = this.data.getY2D();
        }
        return this.y2D;
    }

    public double getY2Dmax() {
        return this.y2D_max;
    }

    public double getY2Dmin() {
        return this.y2D_min;
    }

    public float getYinXZplot() {
        return this.curr_y_xz_plot;
    }

    public String getYlabel() {
        return this.ylabel;
    }

    public double getYmax() {
        return this.ymax;
    }

    public double getYmin() {
        return this.ymin;
    }

    public float[] getZ() {
        if (this.z == null) {
            this.z = this.data.getZ();
        }
        return this.z;
    }

    public float getZ(int idx) {
        if (this.z == null) {
            this.z = this.data.getZ();
        }
        return this.z[idx];
    }

    public float[][] getZ2D() {
        float[][] zOut = new float[this.x2D.length][this.y2D.length];
        for (int i = 0; i < this.x2D.length; ++i) {
            for (int j = 0; j < this.y2D.length; ++j) {
                int k = j * this.x2D.length + i;
                if (k >= this.z.length) continue;
                zOut[i][j] = this.z[k];
            }
        }
        return zOut;
    }

    public double getZ2Dmax() {
        return this.z2D_max;
    }

    public double getZ2Dmin() {
        return this.z2D_min;
    }

    public String getZlabel() {
        return this.zlabel;
    }

    public double getZValue() {
        if (this.type == 1) {
            switch (this.mode2D) {
                case 3: {
                    float[] y = this.y2D;
                    int idx = this.img_xprev * y.length + this.img_yprev;
                    if (this.z != null && idx < this.z.length) {
                        return this.z[idx];
                    }
                }
                case 2: {
                    return this.z_value;
                }
            }
        }
        return Double.NaN;
    }

    boolean hasAsymError() {
        return this.asym_error;
    }

    boolean hasError() {
        return this.error;
    }

    public final boolean hasX() {
        return true;
    }

    public void incShow() {
        if (this.type == 1) {
            switch (this.mode2D) {
                case 0: {
                    this.incShowXZ();
                    break;
                }
                case 1: {
                    this.incShowYZ();
                    break;
                }
            }
        }
    }

    public void incShowXZ() {
        if (this.type == 1 && this.mode2D == 0) {
            this.showXZ((this.curr_y_xz_idx + 1) % this.y2D.length);
        }
    }

    public void incShowYZ() {
        if (this.type == 1 && this.mode2D == 1) {
            this.showYZ((this.curr_x_yz_idx + 1) % this.x2D.length);
        }
    }

    public void initContour() {
        this.saved_ymin = this.ymin = this.y2D_min;
        this.saved_ymax = this.ymax = this.y2D_max;
        this.saved_xmin = this.xmin = this.x2D_min;
        this.saved_xmax = this.xmax = this.x2D_max;
        this.cs = new ContourSignal(this);
        if (this.contourLevels == null || this.contourLevels.length == 0) {
            this.contourLevels = new double[20];
            double dz = (this.z2D_max - this.z2D_min) / 21.0;
            for (int i = 0; i < this.contourLevels.length; ++i) {
                this.contourLevels[i] = this.z2D_min + dz * (double)(i + 1);
            }
        }
        for (double contourLevel : this.contourLevels) {
            this.addContourLevel(contourLevel);
        }
    }

    public boolean isFullLoad() {
        return this.full_load;
    }

    public final boolean isIncreasingX() {
        return this.increasing_x;
    }

    public boolean isLongX() {
        if (this.type == 0 || this.type == 1 && (this.mode2D == 0 || this.mode2D == 3)) {
            return this.xLong != null;
        }
        return false;
    }

    public boolean isLongXForLabel() {
        if (this.type == 0 || this.type == 1 && (this.mode2D == 0 || this.mode2D == 1 || this.mode2D == 3)) {
            return this.data.isXLong();
        }
        return false;
    }

    @Override
    public void legendUpdated(String name) {
        this.setLegend(name);
    }

    public void mergeRegions() {
        if (this.x == null || this.x.length < 1) {
            return;
        }
        double currXMin = this.x[0];
        double currXMax = this.x[this.x.length - 1];
        double currResolution = 6000.0 / (currXMax - currXMin);
        double currDelta = (currXMax - currXMin) / 6000.0;
        int newPoints = 0;
        double currX = currXMin - currDelta / 2.0;
        int currIdx = 0;
        int currOutIdx = 0;
        float currYMin = Float.MAX_VALUE;
        float currYMax = -3.4028235E38f;
        while (currX <= currXMax + currDelta / 2.0) {
            while (currOutIdx < this.x.length && this.x[currOutIdx] < currX) {
                if (this.y[currOutIdx] < currYMin) {
                    currYMin = this.y[currOutIdx];
                }
                if (this.y[currOutIdx] > currYMax) {
                    currYMax = this.y[currOutIdx];
                }
                ++currOutIdx;
            }
            if (currOutIdx == this.x.length) break;
            if (currYMin == currYMax) {
                ++newPoints;
            } else if (currYMin != Float.MAX_VALUE) {
                newPoints += 2;
            }
            currX = currXMin - currDelta / 2.0 + (double)(++currIdx) * currDelta;
            currYMin = Float.MAX_VALUE;
            currYMax = -3.4028235E38f;
        }
        double[] newX = new double[newPoints];
        float[] newY = new float[newPoints];
        currX = currXMin - currDelta / 2.0;
        newPoints = 0;
        currOutIdx = 0;
        currIdx = 0;
        currYMin = Float.MAX_VALUE;
        currYMax = -3.4028235E38f;
        while (currX <= currXMax + currDelta / 2.0) {
            while (currOutIdx < this.x.length && this.x[currOutIdx] < currX) {
                if (this.y[currOutIdx] < currYMin) {
                    currYMin = this.y[currOutIdx];
                }
                if (this.y[currOutIdx] > currYMax) {
                    currYMax = this.y[currOutIdx];
                }
                ++currOutIdx;
            }
            if (currOutIdx == this.x.length) break;
            if (currYMin == currYMax) {
                newX[newPoints] = this.x[currOutIdx == 0 ? currOutIdx : currOutIdx - 1];
                newY[newPoints] = currYMin;
                ++newPoints;
            } else if (currYMin != Float.MAX_VALUE) {
                newX[newPoints] = this.x[currOutIdx == 0 ? currOutIdx : currOutIdx - 1];
                newY[newPoints] = currYMin;
                newX[++newPoints] = this.x[currOutIdx == 0 ? currOutIdx : currOutIdx - 1];
                newY[newPoints] = currYMax;
                ++newPoints;
            }
            currX = currXMin - currDelta / 2.0 + (double)(++currIdx) * currDelta;
            currYMin = Float.MAX_VALUE;
            currYMax = -3.4028235E38f;
        }
        this.x = newX;
        this.y = newY;
        this.resolutionManager.resetRegions();
        this.resolutionManager.appendRegion(new RegionDescriptor(currXMin, currXMax, currResolution));
    }

    void registerSignalListener(SignalListener listener) {
        this.signalListeners.addElement(listener);
    }

    public void ResetScales() {
        this.freezedXMax = this.curr_xmax = this.saved_xmax;
        this.xmax = this.curr_xmax;
        this.freezedXMin = this.curr_xmin = this.saved_xmin;
        this.xmin = this.curr_xmin;
        this.ymax = this.saved_ymax;
        this.ymin = this.saved_ymin;
        this.unfreeze();
    }

    public void resetSignalData() {
        this.x2D_points = 0;
        this.y2D_points = 0;
        this.z2D_points = 0;
        double[] x = new double[]{0.0, 1.0};
        float[] y = new float[]{0.0f, 0.0f};
        this.data = new XYWaveData(x, y);
        this.low_errorData = null;
        this.up_errorData = null;
        this.startIndexToUpdate = 0;
    }

    public void ResetXScale() {
        this.freezedXMax = this.curr_xmax = this.saved_xmax;
        this.xmax = this.curr_xmax;
        this.freezedXMin = this.curr_xmin = this.saved_xmin;
        this.xmin = this.curr_xmin;
    }

    public void ResetYScale() {
        this.ymax = this.saved_ymax;
        this.ymin = this.saved_ymin;
    }

    public void setAttributes(Signal s) {
        this.color = s.getColor();
        this.color_idx = s.getColorIdx();
        this.gain = s.getGain();
        this.interpolate = s.getInterpolate();
        this.marker = s.getMarker();
        this.marker_step = s.getMarkerStep();
        this.offset = s.getOffset();
        this.name = s.getName();
    }

    public void setAttributes(String name, int color_idx, int marker, int marker_step, boolean interpolate) {
        this.marker = marker;
        this.marker_step = marker_step;
        this.interpolate = interpolate;
        this.color_idx = color_idx;
        this.name = new String(name);
    }

    void setAxis() {
        double[] minMax;
        if (this.type != 0 || !this.increasing_x) {
            return;
        }
        if (!this.resolutionManager.isEmpty() && (minMax = this.resolutionManager.getMinMaxX())[0] == -1.7976931348623157E308 && minMax[1] == Double.MAX_VALUE) {
            this.xLimitsInitialized = true;
            this.xmin = this.x[0];
            this.xmax = this.x[this.x.length - 1];
            return;
        }
        try {
            XYData xyData = this.data.getData(2000);
            if (xyData == null) {
                return;
            }
            this.x = xyData.x;
            this.y = xyData.y;
            if (this.x == null || this.x.length == 0) {
                return;
            }
            this.adjustArraySizes();
            this.increasing_x = xyData.increasingX;
            if (this.increasing_x) {
                this.resolutionManager.addRegion(new RegionDescriptor(-1.7976931348623157E308, Double.MAX_VALUE, 2000.0 / (this.x[this.x.length - 1] - this.x[0])));
            }
            if (this.data.isXLong()) {
                this.xLong = xyData.xLong;
            }
            this.xmax = xyData.xMax;
            this.xmin = xyData.xMin;
            this.ymax = this.ymin = (double)this.y[0];
            for (int i = 0; i < this.x.length; ++i) {
                if (Float.isNaN(this.y[i]) && this.n_nans < 100) {
                    this.nans[this.n_nans++] = i;
                }
                if ((double)this.y[i] > this.ymax) {
                    this.ymax = this.y[i];
                }
                if (!(this.ymin > (double)this.y[i])) continue;
                this.ymin = this.y[i];
            }
            this.curr_xmin = this.xmin;
            this.curr_xmax = this.xmax;
        }
        catch (Exception exc) {
            System.out.println("Set Axis Exception: " + exc);
        }
    }

    void setAxis(double[] x2D, float[] z2D, float[] y2D) {
        this.x2D_max = this.x2D_min = x2D[0];
        this.z2D_max = this.z2D_min = (double)z2D[0];
        this.y2D_max = this.y2D_min = (double)y2D[0];
        this.setAxis(x2D, z2D, y2D, 0, 0, 0);
    }

    void setAxis(double[] x2D, float[] z2D, float[] y2D, int xIdx, int zIdx, int yIdx) {
        int i;
        for (i = xIdx; i < x2D.length; ++i) {
            if (x2D[i] > this.x2D_max) {
                this.x2D_max = x2D[i];
            }
            if (!(this.x2D_min > x2D[i])) continue;
            this.x2D_min = x2D[i];
        }
        for (i = zIdx; i < z2D.length; ++i) {
            if ((double)z2D[i] > this.z2D_max) {
                this.z2D_max = z2D[i];
            }
            if (!(this.z2D_min > (double)z2D[i])) continue;
            this.z2D_min = z2D[i];
        }
        for (i = yIdx; i < y2D.length; ++i) {
            if ((double)y2D[i] > this.y2D_max) {
                this.y2D_max = y2D[i];
            }
            if (!(this.y2D_min > (double)y2D[i])) continue;
            this.y2D_min = y2D[i];
        }
    }

    public void setCalibrate(float gain, float offset) {
        this.gain = gain;
        this.offset = offset;
        this.setAxis();
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColorIdx(int color_idx) {
        this.color = null;
        this.color_idx = color_idx;
    }

    void setFreezeMode(int freezeMode) {
        this.freezeMode = freezeMode;
    }

    public void setFullLoad(boolean full_load) {
        this.full_load = full_load;
    }

    public void setInterpolate(boolean interpolate) {
        this.interpolate = interpolate;
    }

    public void setLabels(String title, String xlabel, String ylabel, String zlabel) {
        this.title = title;
        this.xlabel = xlabel;
        this.ylabel = ylabel;
        this.zlabel = zlabel;
    }

    public void setLegend(String legend) {
        this.legend = legend;
    }

    public void setMarker(int marker) {
        this.marker = marker;
    }

    public void setMarker(String name) {
        if (name == null) {
            return;
        }
        for (int i = 0; i < markerList.length; ++i) {
            if (!name.toLowerCase().equals(markerList[i].toLowerCase())) continue;
            this.setMarker(i);
            return;
        }
        this.setMarker(0);
    }

    public void setMarkerStep(int marker_step) {
        this.marker_step = marker_step;
    }

    public void setMode1D(int mode) {
        this.mode1D = mode;
        switch (mode) {
            case 0: {
                this.interpolate = true;
                break;
            }
            case 2: {
                this.interpolate = false;
                break;
            }
            case 3: {
                this.interpolate = true;
            }
        }
    }

    public void setMode2D(int mode) {
        if (this.type == 0) {
            return;
        }
        switch (mode) {
            case 3: {
                this.setMode2D(mode, 0.0);
                break;
            }
            case 0: {
                if (this.y2D == null || this.y2D.length <= 0) break;
                this.setMode2D(mode, this.y2D[0]);
                break;
            }
            case 1: {
                double v = this.x2D[0];
                if (!Double.isNaN(this.curr_x_yz_plot)) {
                    v = this.curr_x_yz_plot;
                }
                this.setMode2D(mode, v);
                break;
            }
            case 2: {
                this.setMode2D(mode, 0.0);
                break;
            }
        }
    }

    public void setMode2D(int mode, double value) {
        if (this.type == 0) {
            return;
        }
        this.curr_x_yz_plot = Double.NaN;
        this.curr_y_xz_plot = Float.NaN;
        this.curr_x_yz_idx = -1;
        this.curr_y_xz_idx = -1;
        switch (mode) {
            case 3: {
                if (this.saved_ymin == -1.7976931348623157E308) {
                    this.saved_ymin = this.ymin = this.y2D_min;
                } else {
                    this.ymin = this.saved_ymin;
                }
                if (this.saved_ymax == Double.MAX_VALUE) {
                    this.saved_ymax = this.ymax = this.y2D_max;
                } else {
                    this.ymax = this.saved_ymax;
                }
                if (this.saved_xmin == -1.7976931348623157E308) {
                    this.saved_xmin = this.xmin = this.x2D_min;
                } else {
                    this.xmin = this.saved_xmin;
                }
                if (this.saved_xmax == Double.MAX_VALUE) {
                    this.saved_xmax = this.xmax = this.x2D_max;
                    break;
                }
                this.xmax = this.saved_xmax;
                break;
            }
            case 0: {
                this.showXZ((float)value);
                break;
            }
            case 1: {
                this.prev_idx = 0;
                this.showYZ((float)value);
                break;
            }
            case 2: {
                this.initContour();
                break;
            }
        }
        this.mode2D = mode;
    }

    public void setName(String name) {
        if (name != null && name.length() != 0) {
            this.name = new String(name);
        }
    }

    public void setStartIndexToUpdate() {
        if (this.x != null) {
            this.startIndexToUpdate = this.x.length;
        }
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setUpdSignalSizeInc(int updSignalSizeInc) {
        if (updSignalSizeInc <= 0) {
            updSignalSizeInc = 10000;
        }
        this.updSignalSizeInc = updSignalSizeInc;
    }

    public void setXinYZplot(float curr_x_yz_plot) {
        this.curr_x_yz_plot = curr_x_yz_plot;
    }

    public void setXLimits(double xmin, double xmax, int mode) {
        double actXMax;
        double actXMin;
        this.xLimitsInitialized = true;
        if (xmin != -1.7976931348623157E308) {
            this.xmin = xmin;
            if ((mode & 1) != 0) {
                this.saved_xmin = xmin;
            }
            if ((mode & 2) != 0) {
                this.fix_xmin = true;
            }
        }
        if (xmax != Double.MAX_VALUE) {
            this.xmax = xmax;
            if ((mode & 1) != 0) {
                this.saved_xmax = xmax;
            }
            if ((mode & 2) != 0) {
                this.fix_xmax = true;
            }
        }
        if ((actXMin = xmin) == -1.7976931348623157E308) {
            actXMin = this.xmin;
        }
        if ((actXMax = xmax) == Double.MAX_VALUE) {
            actXMax = this.xmax;
        }
        double enlargeFactor = 3.0;
        actXMax += (actXMax - actXMin) / 3.0;
        actXMin -= (actXMax - actXMin) / 3.0;
        double actResolution = 2000.0 / (actXMax - actXMin);
        if (!this.increasing_x) {
            return;
        }
        if (this.up_errorData != null || this.low_errorData != null) {
            return;
        }
        Vector<RegionDescriptor> lowResRegions = this.resolutionManager.getLowerResRegions(actXMin, actXMax, actResolution);
        for (int i = 0; i < lowResRegions.size(); ++i) {
            RegionDescriptor currReg = lowResRegions.elementAt(i);
            double currLower = currReg.lowerBound;
            double currUpper = currReg.upperBound;
            while (i < lowResRegions.size() - 1 && lowResRegions.elementAt((int)(i + 1)).lowerBound <= currUpper) {
                currUpper = lowResRegions.elementAt((int)(i + 1)).upperBound;
                ++i;
            }
            if ((mode & 4) != 0 || currLower == this.saved_xmin && currUpper == this.saved_xmax && (mode & 1) != 0) continue;
            this.data.getDataAsync(currLower, currUpper, 2000);
        }
    }

    public void setYinXZplot(float curr_y_xz_plot) {
        this.curr_y_xz_plot = curr_y_xz_plot;
    }

    public void setYlimits(double ymin, double ymax) {
        if (ymax != Double.MAX_VALUE) {
            this.ymax = ymax;
            this.fix_ymax = true;
        } else {
            this.fix_ymax = false;
        }
        if (ymin != -1.7976931348623157E308) {
            this.ymin = ymin;
            this.fix_ymin = true;
        } else {
            this.fix_ymin = false;
        }
    }

    public void setYmax(double ymax, int mode) {
        if (ymax == Double.MAX_VALUE) {
            return;
        }
        this.ymax = ymax;
        if ((mode & 1) != 0) {
            this.saved_ymax = ymax;
        }
        if ((mode & 2) != 0) {
            this.fix_ymax = true;
        }
    }

    public void setYmin(double ymin, int mode) {
        if (ymin == -1.7976931348623157E308) {
            return;
        }
        this.ymin = ymin;
        if ((mode & 1) != 0) {
            this.saved_ymin = ymin;
        }
        if ((mode & 2) != 0) {
            this.fix_ymin = true;
        }
    }

    public void showXZ(double xd) {
        if ((double)this.curr_y_xz_plot == xd) {
            return;
        }
        int i = this.getArrayIndex(this.y2D, xd);
        this.showXZ(i);
    }

    public void showXZ(int idx) {
        float sliceMax;
        float[] y2d = this.y2D;
        double[] x2d = this.x2D;
        if ((idx >= y2d.length || idx == this.curr_y_xz_idx) && this.mode2D == 0) {
            return;
        }
        this.prev_idx = 0;
        this.curr_y_xz_plot = y2d[idx];
        this.curr_y_xz_idx = idx;
        this.curr_x_yz_plot = Double.NaN;
        this.curr_x_yz_idx = -1;
        if (this.zY2D != null) {
            x2d = new double[this.x2D.length];
            this.curr_xmin = this.curr_xmax = (double)this.zY2D[this.x2D.length * idx];
            for (int j = 0; j < this.x2D.length; ++j) {
                x2d[j] = this.zY2D[this.x2D.length * idx + j];
                if (x2d[j] > this.curr_xmax) {
                    this.curr_xmax = x2d[j];
                    continue;
                }
                if (!(x2d[j] < this.curr_xmin)) continue;
                this.curr_xmin = x2d[j];
            }
        }
        this.sliceX = new double[x2d.length];
        this.sliceY = new float[x2d.length];
        int zLen = this.z.length;
        if (x2d.length * (idx + 1) >= this.z.length) {
            return;
        }
        float sliceMin = sliceMax = this.z[x2d.length * idx];
        for (int j = 0; j < x2d.length; ++j) {
            this.sliceX[j] = x2d[j];
            int k = x2d.length * idx + j;
            if (k >= zLen) break;
            this.sliceY[j] = this.z[k];
            if (sliceMin > this.z[k]) {
                sliceMin = this.z[k];
            }
            if (!(sliceMax < this.z[k])) continue;
            sliceMax = this.z[k];
        }
        this.asym_error = false;
        this.error = false;
        this.mode2D = 0;
        if (!this.fix_xmin) {
            this.curr_xmin = this.xmin = this.x2D_min;
            this.saved_xmin = this.xmin;
        }
        if (!this.fix_xmax) {
            this.curr_xmax = this.xmax = this.x2D_max;
            this.saved_xmax = this.xmax;
        }
        if (!this.fix_ymin) {
            this.saved_ymin = this.ymin = (double)sliceMin;
        }
        if (!this.fix_ymax) {
            this.saved_ymax = this.ymax = (double)sliceMax;
        }
        this.increasing_x = true;
    }

    public void showYZ(double t) {
        if (this.curr_x_yz_plot == t && this.mode2D == 1) {
            return;
        }
        int i = this.getArrayIndex(this.x2D, t);
        this.showYZ(i);
    }

    public void showYZ(int idx) {
        float sliceMax;
        float[] y2d = this.y2D;
        double[] x2d = this.x2D;
        if ((idx >= x2d.length || idx == this.curr_x_yz_idx) && this.mode2D == 1) {
            return;
        }
        this.prev_idx = 0;
        this.curr_x_yz_plot = x2d[idx];
        this.curr_x_yz_idx = idx;
        this.curr_y_xz_plot = Float.NaN;
        this.curr_y_xz_idx = -1;
        if (this.zY2D != null && idx < this.zY2D.length) {
            this.ymin = this.ymax = (double)this.zY2D[idx];
            for (int j = 0; j < y2d.length; ++j) {
                int k = x2d.length * j + idx;
                y2d[j] = this.zY2D[k];
                if (this.ymin > (double)y2d[j]) {
                    this.ymin = y2d[j];
                }
                if (!(this.ymax < (double)y2d[j])) continue;
                this.ymax = y2d[j];
            }
        }
        this.sliceX = new double[y2d.length];
        this.sliceY = new float[y2d.length];
        int zLen = this.z.length;
        if (idx >= zLen) {
            return;
        }
        float sliceMin = sliceMax = this.z[idx];
        for (int j = 0; j < y2d.length; ++j) {
            int k = x2d.length * j + idx;
            this.sliceX[j] = y2d[j];
            if (k >= zLen) break;
            this.sliceY[j] = this.z[k];
            if (sliceMin > this.z[k]) {
                sliceMin = this.z[k];
            }
            if (!(sliceMax < this.z[k])) continue;
            sliceMax = this.z[k];
        }
        this.asym_error = false;
        this.error = false;
        this.mode2D = 1;
        if (!this.fix_xmin) {
            this.curr_xmin = this.xmin = this.y2D_min;
            this.saved_xmin = this.xmin;
        }
        if (!this.fix_xmax) {
            this.curr_xmax = this.xmax = this.y2D_max;
            this.saved_xmax = this.xmax;
        }
        if (!this.fix_ymin) {
            this.saved_ymin = this.ymin = (double)sliceMin;
        }
        if (!this.fix_ymax) {
            this.saved_ymax = this.ymax = (double)sliceMax;
        }
        this.increasing_x = true;
    }

    public void StartTraslate() {
        this.t_xmax = this.xmax;
        this.t_xmin = this.xmin;
        this.t_ymax = this.ymax;
        this.t_ymin = this.ymin;
    }

    public boolean supportsStreaming() {
        return this.data.supportsStreaming();
    }

    public double surfaceValue(double x0, double y0) {
        double zOut = 0.0;
        float[] z2D = this.z;
        try {
            if (this.type == 1 && (this.mode2D == 3 || this.mode2D == 2)) {
                this.img_yprev = this.findIndex(this.y2D, y0, this.img_yprev);
                this.img_xprev = this.findIndex(this.x2D, x0, this.img_xprev);
                double x1 = 0.0;
                double y1 = 0.0;
                double z1 = 0.0;
                double x2 = 0.0;
                double y2 = 0.0;
                double z2 = 0.0;
                double x3 = 0.0;
                double y3 = 0.0;
                double z3 = 0.0;
                double x4 = 0.0;
                double y4 = 0.0;
                double z4 = 0.0;
                double xn = this.x2D[this.img_xprev];
                double yn = this.y2D[this.img_yprev];
                if (x0 > xn && y0 > yn) {
                    x1 = xn;
                    y1 = yn;
                    z1 = z2D[this.img_xprev * this.y2D.length + this.img_yprev];
                    x2 = this.x2D[this.img_xprev + 1];
                    y2 = this.y2D[this.img_yprev];
                    z2 = z2D[(this.img_xprev + 1) * this.y2D.length + this.img_yprev];
                    x3 = this.x2D[this.img_xprev];
                    y3 = this.y2D[this.img_yprev + 1];
                    z3 = z2D[this.img_xprev * this.y2D.length + this.img_yprev + 1];
                    x4 = this.x2D[this.img_xprev + 1];
                    y4 = this.y2D[this.img_yprev + 1];
                    z4 = z2D[(this.img_xprev + 1) * this.y2D.length + this.img_yprev + 1];
                } else if (x0 > xn && y0 < yn) {
                    x1 = this.x2D[this.img_xprev - 1];
                    y1 = this.y2D[this.img_yprev];
                    z1 = z2D[(this.img_xprev - 1) * this.y2D.length + this.img_yprev];
                    x2 = xn;
                    y2 = yn;
                    z2 = z2D[this.img_xprev * this.y2D.length + this.img_yprev];
                    x3 = this.x2D[this.img_xprev - 1];
                    y3 = this.y2D[this.img_yprev + 1];
                    z3 = z2D[(this.img_xprev - 1) * this.y2D.length + this.img_yprev + 1];
                    x4 = this.x2D[this.img_xprev];
                    y4 = this.y2D[this.img_yprev + 1];
                    z4 = z2D[this.img_xprev * this.y2D.length + this.img_yprev + 1];
                } else if (x0 < xn && y0 > yn) {
                    x1 = this.x2D[this.img_xprev];
                    y1 = this.y2D[this.img_yprev - 1];
                    z3 = z2D[this.img_xprev * this.y2D.length + this.img_yprev - 1];
                    x2 = this.x2D[this.img_xprev - 1];
                    y2 = this.y2D[this.img_yprev - 1];
                    z2 = z2D[(this.img_xprev - 1) * this.y2D.length + this.img_yprev - 1];
                    x3 = xn;
                    y3 = yn;
                    z3 = z2D[this.img_xprev * this.y2D.length + this.img_yprev];
                    x4 = this.x2D[this.img_xprev + 1];
                    y4 = this.y2D[this.img_yprev];
                    z4 = z2D[(this.img_xprev + 1) * this.y2D.length + this.img_yprev];
                } else if (x0 < xn && y0 < yn) {
                    x1 = this.x2D[this.img_xprev - 1];
                    y1 = this.y2D[this.img_yprev - 1];
                    z1 = z2D[(this.img_xprev - 1) * this.y2D.length + this.img_yprev - 1];
                    x2 = this.x2D[this.img_xprev];
                    y2 = this.y2D[this.img_yprev - 1];
                    z2 = z2D[this.img_xprev * this.y2D.length + this.img_yprev - 1];
                    x3 = this.x2D[this.img_xprev - 1];
                    y3 = this.y2D[this.img_yprev];
                    z3 = z2D[(this.img_xprev - 1) * this.y2D.length + this.img_yprev];
                    x4 = xn;
                    y4 = yn;
                    z4 = z2D[this.img_xprev * this.y2D.length + this.img_yprev];
                }
                double yc = ((double)((float)x0) - x1) * (y4 - y1) / (x4 - x1) + y1;
                zOut = yc > y0 ? ((double)((float)y0) - y1) * ((x2 - x1) * (z4 - z1) - (z2 - z1) * (x4 - x1)) / ((x2 - x1) * (y4 - y1) - (y2 - y1) * (x4 - x1)) - ((double)((float)x0) - x1) * ((y2 - y1) * (z4 - z1) - (z2 - z1) * (y4 - y1)) / ((x2 - x1) * (y4 - y1) - (y2 - y1) * (x4 - x1)) + z1 : ((double)((float)y0) - y1) * ((x3 - x1) * (z4 - z1) - (z3 - z1) * (x4 - x1)) / ((x3 - x1) * (y4 - y1) - (y3 - y1) * (x4 - x1)) - ((double)((float)x0) - x1) * ((y3 - y1) * (z4 - z1) - (z3 - z1) * (y4 - y1)) / ((x3 - x1) * (y4 - y1) - (y3 - y1) * (x4 - x1)) + z1;
            }
        }
        catch (Exception exc) {
            zOut = z2D[this.img_xprev * this.x2D.length + this.img_yprev];
        }
        this.z_value = zOut;
        return zOut;
    }

    public void Traslate(double delta_x, double delta_y, boolean x_log, boolean y_log) {
        if (x_log) {
            this.xmax = this.t_xmax * delta_x;
            this.xmin = this.t_xmin * delta_x;
        } else {
            this.xmax = this.t_xmax + delta_x;
            this.xmin = this.t_xmin + delta_x;
        }
        if (y_log) {
            this.ymax = this.t_ymax * delta_y;
            this.ymin = this.t_ymin * delta_y;
        } else {
            this.ymax = this.t_ymax + delta_y;
            this.ymin = this.t_ymin + delta_y;
        }
    }

    void unblock() {
        this.freezeMode = 0;
    }

    void unfreeze() {
        this.freezeMode = 0;
        this.xmin = this.freezedXMin;
        this.xmax = this.freezedXMax;
        for (int i = 0; i < this.pendingUpdatesV.size(); ++i) {
            if (this.pendingUpdatesV.elementAt((int)i).xLong != null) {
                this.dataRegionUpdated(this.pendingUpdatesV.elementAt((int)i).xLong, this.pendingUpdatesV.elementAt((int)i).y, this.pendingUpdatesV.elementAt((int)i).resolution);
                continue;
            }
            this.dataRegionUpdated(this.pendingUpdatesV.elementAt((int)i).x, this.pendingUpdatesV.elementAt((int)i).y, this.pendingUpdatesV.elementAt((int)i).resolution);
        }
        this.pendingUpdatesV.clear();
    }

    public boolean updateSignal() {
        if (this.longXLimits) {
            return false;
        }
        double currXMax = this.x != null && this.x.length > 0 ? this.x[this.x.length - 1] : this.xmin;
        this.data.getDataAsync(currXMax, Double.MAX_VALUE, 2000);
        return true;
    }

    public boolean xLimitsInitialized() {
        return this.xLimitsInitialized;
    }

    class ResolutionManager {
        Vector<RegionDescriptor> lowResRegions = new Vector();

        ResolutionManager() {
        }

        ResolutionManager(ResolutionManager rm) {
            for (int i = 0; i < rm.lowResRegions.size(); ++i) {
                this.lowResRegions.addElement(rm.lowResRegions.elementAt(i));
            }
        }

        void addRegion(RegionDescriptor newReg) {
            RegionDescriptor currRegion;
            int idx;
            if (newReg.upperBound < newReg.lowerBound) {
                System.err.println("INTERNAL ERROR: LOWER BOUND > UPPER BOUND!!!!!");
            }
            for (idx = 0; idx < this.lowResRegions.size(); ++idx) {
                currRegion = this.lowResRegions.elementAt(idx);
                if (currRegion.upperBound > newReg.lowerBound) break;
            }
            if (idx == this.lowResRegions.size()) {
                if (Signal.this.debug) {
                    System.out.println("Added region (" + newReg.lowerBound + "," + newReg.upperBound + "," + newReg.resolution + ") at bottom");
                }
                this.lowResRegions.addElement(newReg);
                return;
            }
            currRegion = this.lowResRegions.elementAt(idx);
            if (currRegion.lowerBound < newReg.lowerBound) {
                if (currRegion.upperBound <= newReg.upperBound) {
                    currRegion.upperBound = newReg.lowerBound;
                    if (Signal.this.debug) {
                        System.out.println("updated region (" + currRegion.lowerBound + "," + currRegion.upperBound + ") ");
                    }
                    ++idx;
                } else {
                    double prevUpper = currRegion.upperBound;
                    currRegion.upperBound = newReg.lowerBound;
                    if (Signal.this.debug) {
                        System.out.println("Updated region (" + currRegion.lowerBound + "," + currRegion.upperBound + ") ");
                    }
                    this.lowResRegions.insertElementAt(newReg, ++idx);
                    if (Signal.this.debug) {
                        System.out.println("Added region (" + newReg.lowerBound + "," + newReg.upperBound + "," + newReg.resolution + ")");
                    }
                    this.lowResRegions.insertElementAt(new RegionDescriptor(newReg.upperBound, prevUpper, currRegion.resolution), ++idx);
                    if (Signal.this.debug) {
                        System.out.println("Added region (" + newReg.upperBound + "," + prevUpper + "," + currRegion.resolution + ")");
                    }
                    return;
                }
            }
            while (idx < this.lowResRegions.size() && this.lowResRegions.elementAt((int)idx).upperBound <= newReg.upperBound) {
                if (Signal.this.debug) {
                    System.out.println("Removed region (" + this.lowResRegions.elementAt((int)idx).lowerBound + "," + this.lowResRegions.elementAt((int)idx).upperBound + ")");
                }
                this.lowResRegions.removeElementAt(idx);
            }
            if (idx < this.lowResRegions.size() && this.lowResRegions.elementAt((int)idx).lowerBound < newReg.upperBound) {
                this.lowResRegions.elementAt((int)idx).lowerBound = newReg.upperBound;
                if (Signal.this.debug) {
                    System.out.println("Updated region (" + this.lowResRegions.elementAt((int)idx).lowerBound + "," + this.lowResRegions.elementAt((int)idx).upperBound + ")");
                }
            }
            this.lowResRegions.insertElementAt(newReg, idx);
            if (Signal.this.debug) {
                System.out.println("Added region (" + newReg.lowerBound + "," + newReg.upperBound + "," + newReg.resolution + ")");
            }
            idx = 1;
            while (idx < this.lowResRegions.size()) {
                RegionDescriptor currReg = this.lowResRegions.elementAt(idx);
                RegionDescriptor prevReg = this.lowResRegions.elementAt(idx - 1);
                if (prevReg.upperBound == currReg.lowerBound && prevReg.resolution == currReg.resolution) {
                    if (Signal.this.debug) {
                        System.out.println("Regions at (" + prevReg.lowerBound + "," + prevReg.upperBound + ")  (" + currReg.lowerBound + "," + currReg.upperBound + ") merged");
                    }
                    prevReg.upperBound = currReg.upperBound;
                    this.lowResRegions.removeElementAt(idx);
                    continue;
                }
                ++idx;
            }
        }

        void appendRegion(RegionDescriptor newReg) {
            if (newReg.upperBound < newReg.lowerBound) {
                System.err.println("INTERNAL ERROR IN APPEND: LOWER BOUND > UPPER BOUND!!!!!");
            }
            if (this.lowResRegions.size() == 0) {
                this.lowResRegions.addElement(newReg);
                return;
            }
            RegionDescriptor lastReg = this.lowResRegions.elementAt(this.lowResRegions.size() - 1);
            if (lastReg.resolution == newReg.resolution) {
                lastReg.upperBound = newReg.upperBound;
            } else {
                if (lastReg.upperBound > newReg.lowerBound) {
                    newReg.lowerBound = lastReg.upperBound;
                }
                this.lowResRegions.addElement(newReg);
            }
        }

        Vector<RegionDescriptor> getLowerResRegions(double lowerInt, double upperInt, double resolution) {
            Vector<RegionDescriptor> retRegions = new Vector<RegionDescriptor>();
            for (int i = 0; i < this.lowResRegions.size(); ++i) {
                RegionDescriptor currReg = this.lowResRegions.elementAt(i);
                if (currReg.lowerBound < upperInt && currReg.lowerBound > lowerInt) {
                    if (Signal.this.debug) {
                        System.out.println("CASE 1: Lower bound is within interval for region " + i + "  its resolution: " + currReg.resolution + " in resolution: " + resolution);
                    }
                    if (!(currReg.resolution < resolution)) continue;
                    double currUpper = currReg.upperBound;
                    if (currUpper > upperInt) {
                        currUpper = upperInt;
                    }
                    if (Signal.this.debug) {
                        System.out.println("Added Region lower: " + currReg.lowerBound + "  upper: " + currUpper + " resoluton: " + resolution);
                    }
                    retRegions.addElement(new RegionDescriptor(currReg.lowerBound, currUpper, resolution));
                    continue;
                }
                if (currReg.upperBound < upperInt && currReg.upperBound > lowerInt) {
                    if (Signal.this.debug) {
                        System.out.println("CASE 2: Upper bound is within interval for region " + i);
                    }
                    if (!(currReg.resolution < resolution)) continue;
                    double currLower = currReg.lowerBound;
                    if (currLower < lowerInt) {
                        currLower = lowerInt;
                    }
                    retRegions.addElement(new RegionDescriptor(currLower, currReg.upperBound, resolution));
                    continue;
                }
                if (!(currReg.lowerBound < lowerInt) || !(currReg.upperBound > upperInt)) continue;
                if (Signal.this.debug) {
                    System.out.println("CASE 3: UThe interval is fully within the current region for region " + i);
                }
                if (!(currReg.resolution < resolution)) continue;
                retRegions.addElement(new RegionDescriptor(lowerInt, upperInt, resolution));
            }
            return retRegions;
        }

        double[] getMinMaxX() {
            double[] limits = new double[]{this.lowResRegions.elementAt((int)0).lowerBound, this.lowResRegions.elementAt((int)(this.lowResRegions.size() - 1)).upperBound};
            return limits;
        }

        boolean isEmpty() {
            return this.lowResRegions.size() == 0;
        }

        void resetRegions() {
            this.lowResRegions.clear();
        }
    }

    static class RegionDescriptor {
        double lowerBound;
        double upperBound;
        double resolution;

        RegionDescriptor(double lowerBound, double upperBound, double resolution) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.resolution = resolution;
        }
    }
}

