/*
 * Decompiled with CFR 0.152.
 */
package MDSplus;

import MDSplus.Compound;
import MDSplus.Data;

public class Call
extends Compound {
    public Call(int retType, Data image, Data routine, Data[] args, Data help, Data units, Data error, Data validation) {
        super(help, units, error, validation);
        this.opcode = retType;
        this.clazz = 194;
        this.dtype = 212;
        this.descs = new Data[2 + args.length];
        this.descs[0] = image;
        this.descs[1] = routine;
        for (int i = 0; i < args.length; ++i) {
            this.descs[2 + i] = args[i];
        }
    }

    public Call(int retType, Data image, Data routine, Data[] args) {
        this(retType, image, routine, args, null, null, null, null);
    }

    public Call(Data help, Data units, Data error, Data validation) {
        super(help, units, error, validation);
        this.clazz = 194;
        this.dtype = 212;
        this.descs = new Data[0];
        this.opcode = 0;
    }

    public static Call getData(Data help, Data units, Data error, Data validation) {
        return new Call(help, units, error, validation);
    }

    public Data getImage() {
        try {
            return this.descs[0];
        }
        catch (Exception exc) {
            return null;
        }
    }

    public Data getRoutine() {
        try {
            return this.descs[1];
        }
        catch (Exception exc) {
            return null;
        }
    }

    public Data[] getArguments() {
        Data[] args = new Data[this.descs.length - 2];
        for (int i = 0; i < this.descs.length - 2; ++i) {
            args[i] = this.descs[2 + i];
        }
        return args;
    }

    public Data getArgumentAt(int idx) {
        try {
            return this.descs[2 + idx];
        }
        catch (Exception exc) {
            return null;
        }
    }

    public void setImage(Data data) {
        this.resizeDescs(1);
        this.descs[0] = data;
    }

    public void setRoutine(Data data) {
        this.resizeDescs(2);
        this.descs[1] = data;
    }

    public void setArguments(Data[] args) {
        this.resizeDescs(2 + args.length);
        Data[] newDescs = new Data[2 + args.length];
        newDescs[0] = this.descs[0];
        newDescs[1] = this.descs[1];
        for (int i = 0; i < args.length; ++i) {
            newDescs[2 + i] = args[i];
        }
        this.descs = newDescs;
    }

    public void setArgumentAt(int idx, Data data) {
        this.resizeDescs(2 + idx + 1);
        this.descs[2 + idx] = data;
    }

    public int getRetType() {
        return this.opcode;
    }

    public void setRetType(int dtype) {
        this.opcode = dtype;
    }
}

