/*
 * Decompiled with CFR 0.152.
 */
package mds.connection;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import mds.connection.ConnectionEvent;
import mds.connection.ConnectionListener;
import mds.connection.Descriptor;
import mds.connection.MdsMessage;
import mds.connection.UpdateEvent;
import mds.connection.UpdateEventListener;

public class MdsConnection {
    public static final int DEFAULT_PORT = 8000;
    public static final String DEFAULT_USER = "JAVA_USER";
    static final int MAX_NUM_EVENTS = 256;
    protected String provider;
    protected String user;
    protected String host;
    protected int port;
    protected Socket sock = null;
    protected InputStream dis = null;
    protected DataOutputStream dos = null;
    public String error;
    protected MRT receiveThread;
    protected boolean connected = false;
    private int pending_count = 0;
    private final Vector<ConnectionListener> connection_listener = new Vector();
    private final boolean[] event_flags = new boolean[256];
    private final Hashtable<String, EventItem> hashEventName = new Hashtable();
    private final Hashtable<Integer, EventItem> hashEventId = new Hashtable();
    private boolean busy;
    private final Descriptor[] DA_TMP = new Descriptor[0];

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
    }

    public final boolean isConnected() {
        return this.connected;
    }

    public String getProvider() {
        return this.provider;
    }

    public static final void tryClose(Object obj) {
        if (obj != null) {
            try {
                obj.getClass().getMethod("close", new Class[0]).invoke(obj, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public MdsConnection() {
        this.provider = null;
        this.port = 8000;
        this.host = null;
    }

    public MdsConnection(String provider) {
        this.provider = provider;
        this.port = 8000;
        this.host = null;
    }

    public void setProvider(String provider) {
        if (this.connected) {
            this.DisconnectFromMds();
        }
        this.provider = provider;
        this.port = 8000;
        this.host = null;
    }

    public void setUser(String user) {
        this.user = user == null || user.length() == 0 ? DEFAULT_USER : user;
    }

    public String getProviderUser() {
        return this.user != null ? this.user : DEFAULT_USER;
    }

    public synchronized String getProviderHost() {
        if (this.provider == null) {
            return null;
        }
        String address = this.provider;
        int idx = this.provider.indexOf("|");
        int idx_1 = this.provider.indexOf(":");
        if (idx_1 == -1) {
            idx_1 = this.provider.length();
        }
        address = idx != -1 ? this.provider.substring(idx + 1, idx_1) : this.provider.substring(0, idx_1);
        return address;
    }

    public synchronized int getProviderPort() throws NumberFormatException {
        if (this.provider == null) {
            return 8000;
        }
        int port = 8000;
        int idx = this.provider.indexOf(":");
        if (idx != -1) {
            port = Integer.parseInt(this.provider.substring(idx + 1, this.provider.length()));
        }
        return port;
    }

    public synchronized Descriptor getAnswer() throws IOException {
        Descriptor out = new Descriptor();
        MdsMessage message = this.receiveThread.GetMessage();
        if (message == null || message.length == 0) {
            out.error = "Null response from server";
            return out;
        }
        out.status = message.status;
        out.dtype = message.dtype;
        switch (out.dtype) {
            case 2: 
            case 6: {
                out.byte_data = message.body;
                break;
            }
            case 3: {
                out.int_data = message.ToUShortArray();
                out.dtype = (byte)8;
                break;
            }
            case 7: {
                out.short_data = message.ToShortArray();
                break;
            }
            case 4: 
            case 8: {
                out.int_data = message.ToIntArray();
                break;
            }
            case 5: 
            case 9: {
                out.long_data = message.ToLongArray();
                break;
            }
            case 14: {
                if ((message.status & 1) == 1) {
                    out.strdata = new String(message.body);
                    break;
                }
                out.error = new String(message.body);
                break;
            }
            case 10: {
                out.float_data = message.ToFloatArray();
                break;
            }
            case 11: {
                out.double_data = message.ToDoubleArray();
            }
        }
        return out;
    }

    @Deprecated
    public Descriptor MdsValue(String expr, Vector<Descriptor> args) {
        return this.MdsValue(expr, args.toArray(this.DA_TMP));
    }

    public Descriptor MdsValue(String expr, Descriptor ... args) {
        return this.MdsValue(expr, true, args);
    }

    @Deprecated
    public Descriptor MdsValueStraight(String expr, Vector<Descriptor> args) {
        return this.MdsValueStraight(expr, args.toArray(this.DA_TMP));
    }

    public Descriptor MdsValueStraight(String expr, Descriptor ... args) {
        return this.MdsValue(expr, false, args);
    }

    @Deprecated
    public Descriptor MdsValue(String expr, Vector<Descriptor> args, boolean wait) {
        return this.MdsValue(expr, wait, args.toArray(this.DA_TMP));
    }

    public synchronized Descriptor MdsValue(String expr, boolean wait, Descriptor ... args) {
        Descriptor out;
        StringBuffer cmd = new StringBuffer(expr);
        int n_args = args.length;
        byte idx = 0;
        byte totalarg = (byte)(n_args + 1);
        try {
            if (expr.indexOf("($") == -1 && n_args > 0) {
                cmd.append("(");
                for (int i = 0; i < n_args - 1; ++i) {
                    cmd.append("$,");
                }
                cmd.append("$)");
            }
            byte by = idx;
            idx = (byte)(idx + 1);
            this.sendArg(by, (byte)14, totalarg, null, cmd.toString().getBytes());
            for (Descriptor p : args) {
                byte by2 = idx;
                idx = (byte)(idx + 1);
                this.sendArg(by2, p.dtype, totalarg, p.dims, p.dataToByteArray());
            }
            ++this.pending_count;
            if (wait) {
                out = this.getAnswer();
                if (out == null) {
                    out = new Descriptor("Could not get IO for " + this.provider);
                }
            } else {
                out = new Descriptor();
            }
        }
        catch (IOException e) {
            out = new Descriptor("Could not get IO for " + this.provider + e);
        }
        return out;
    }

    public void sendArg(byte descr_idx, byte dtype, byte nargs, int[] dims, byte[] body) throws IOException {
        MdsMessage msg = new MdsMessage(descr_idx, dtype, nargs, dims, body);
        msg.Send(this.dos);
    }

    public int DisconnectFromMds() {
        this.connection_listener.removeAllElements();
        this.connected = false;
        return 1;
    }

    public void QuitFromMds() {
        this.DisconnectFromMds();
        MdsConnection.tryClose(this.dos);
        MdsConnection.tryClose(this.dis);
    }

    public void connectToServer() throws IOException {
        this.host = this.getProviderHost();
        this.port = this.getProviderPort();
        this.user = this.getProviderUser();
        this.sock = new Socket(this.host, this.port);
        this.sock.setTcpNoDelay(true);
        this.dis = new BufferedInputStream(this.sock.getInputStream());
        this.dos = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
    }

    public synchronized int ConnectToMds(boolean use_compression) {
        try {
            if (this.provider == null) {
                this.error = "Data provider host:port is <null>";
                return 0;
            }
            this.connectToServer();
            MdsMessage message = new MdsMessage(this.user);
            message.useCompression(use_compression);
            message.Send(this.dos);
            message.Receive(this.dis);
            this.receiveThread = new MRT();
            this.receiveThread.start();
            this.connected = true;
        }
        catch (NumberFormatException e) {
            this.error = "Data provider syntax error " + this.provider + " (host:port)";
            return 0;
        }
        catch (UnknownHostException e) {
            this.error = "Data provider: " + this.host + " port " + this.port + " unknown";
            return 0;
        }
        catch (IOException e) {
            this.error = "Could not get IO for " + this.provider + " " + e;
            return 0;
        }
        return 1;
    }

    private int getEventId() {
        int i;
        for (i = 0; i < 256 && this.event_flags[i]; ++i) {
        }
        if (i == 256) {
            return -1;
        }
        this.event_flags[i] = true;
        return i;
    }

    public synchronized int AddEvent(UpdateEventListener l, String eventName) {
        int eventid = -1;
        if (this.hashEventName.containsKey(eventName)) {
            EventItem eventItem = this.hashEventName.get(eventName);
            if (!eventItem.listener.contains(l)) {
                eventItem.listener.addElement(l);
            }
        } else {
            eventid = this.getEventId();
            EventItem eventItem = new EventItem(eventName, eventid, l);
            this.hashEventName.put(eventName, eventItem);
            this.hashEventId.put(new Integer(eventid), eventItem);
        }
        return eventid;
    }

    public synchronized int RemoveEvent(UpdateEventListener l, String eventName) {
        int eventid = -1;
        if (this.hashEventName.containsKey(eventName)) {
            EventItem eventItem = this.hashEventName.get(eventName);
            eventItem.listener.remove(l);
            if (eventItem.listener.isEmpty()) {
                eventid = eventItem.eventid;
                this.event_flags[eventid] = false;
                this.hashEventName.remove(eventName);
                this.hashEventId.remove(new Integer(eventid));
            }
        }
        return eventid;
    }

    public synchronized void dispatchUpdateEvent(int eventid) {
        if (this.hashEventId.containsKey(eventid)) {
            this.dispatchUpdateEvent(this.hashEventId.get(eventid));
        }
    }

    public synchronized void dispatchUpdateEvent(String eventName) {
        if (this.hashEventName.containsKey(eventName)) {
            this.dispatchUpdateEvent(this.hashEventName.get(eventName));
        }
    }

    private void dispatchUpdateEvent(EventItem eventItem) {
        Vector<UpdateEventListener> eventListener = eventItem.listener;
        UpdateEvent e = new UpdateEvent((Object)this, eventItem.name);
        for (int i = 0; i < eventListener.size(); ++i) {
            eventListener.elementAt(i).processUpdateEvent(e);
        }
    }

    public synchronized void MdsSetEvent(UpdateEventListener l, String event) {
        int eventid = this.AddEvent(l, event);
        if (eventid == -1) {
            return;
        }
        try {
            this.sendArg((byte)0, (byte)14, (byte)3, null, "---EVENTAST---REQUEST---".getBytes());
            this.sendArg((byte)1, (byte)14, (byte)3, null, event.getBytes());
            byte[] data = new byte[]{(byte)eventid};
            this.sendArg((byte)2, (byte)2, (byte)3, null, data);
        }
        catch (IOException e) {
            this.error = new String("Could not get IO for " + this.provider + e);
        }
    }

    public synchronized void MdsRemoveEvent(UpdateEventListener l, String event) {
        int eventid = this.RemoveEvent(l, event);
        if (eventid == -1) {
            return;
        }
        try {
            this.sendArg((byte)0, (byte)14, (byte)2, null, "---EVENTCAN---REQUEST---".getBytes());
            byte[] data = new byte[]{(byte)eventid};
            this.sendArg((byte)1, (byte)14, (byte)2, null, data);
        }
        catch (IOException e) {
            this.error = new String("Could not get IO for " + this.provider + e);
        }
    }

    public synchronized void addConnectionListener(ConnectionListener l) {
        if (l != null && this.connection_listener != null) {
            this.connection_listener.addElement(l);
        }
    }

    public synchronized void removeConnectionListener(ConnectionListener l) {
        if (l != null && this.connection_listener != null) {
            this.connection_listener.removeElement(l);
        }
    }

    public void dispatchConnectionEvent(ConnectionEvent e) {
        if (this.connection_listener != null) {
            Enumeration<ConnectionListener> elements = this.connection_listener.elements();
            try {
                while (true) {
                    elements.nextElement().processConnectionEvent(e);
                }
            }
            catch (NoSuchElementException done) {
            }
        }
    }

    class MRT
    extends Thread {
        MdsMessage message;
        boolean pending = false;
        boolean killed = false;

        MRT() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setName("Mds Receive Thread");
            try {
                while (true) {
                    Thread PMdsEvent;
                    MdsMessage curr_message = new MdsMessage("", (Vector<ConnectionListener>)MdsConnection.this.connection_listener);
                    curr_message.Receive(MdsConnection.this.dis);
                    if (curr_message.dtype == 99) {
                        PMdsEvent = new PMET();
                        ((PMET)PMdsEvent).SetEventid(curr_message.body[12]);
                        PMdsEvent.start();
                        continue;
                    }
                    MdsConnection.this.pending_count--;
                    PMdsEvent = this;
                    synchronized (PMdsEvent) {
                        this.message = curr_message;
                        if (MdsConnection.this.pending_count == 0) {
                            this.notify();
                        }
                    }
                    curr_message = null;
                }
            }
            catch (Exception e) {
                MRT mRT = this;
                synchronized (mRT) {
                    this.killed = true;
                    this.notifyAll();
                }
                if (MdsConnection.this.connected) {
                    this.message = null;
                    MdsConnection.this.connected = false;
                    new Thread(){

                        @Override
                        public void run() {
                            ConnectionEvent ce = new ConnectionEvent((Object)MdsConnection.this, 2000, "Lost connection from : " + MdsConnection.this.provider);
                            MdsConnection.this.dispatchConnectionEvent(ce);
                        }
                    }.start();
                }
                return;
            }
        }

        public synchronized void waitExited() {
            while (!this.killed) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized MdsMessage GetMessage() {
            while (!this.killed && this.message == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.killed) {
                return null;
            }
            MdsMessage msg = this.message;
            this.message = null;
            return msg;
        }
    }

    class PMET
    extends Thread {
        int eventId = -1;
        String eventName;

        PMET() {
        }

        @Override
        public void run() {
            this.setName("Process Mds Event Thread");
            if (MdsConnection.this.busy) {
                return;
            }
            if (this.eventName != null) {
                MdsConnection.this.dispatchUpdateEvent(this.eventName);
            } else if (this.eventId != -1) {
                MdsConnection.this.dispatchUpdateEvent(this.eventId);
            }
        }

        public void SetEventid(int id) {
            this.eventId = id;
            this.eventName = null;
        }

        public void SetEventName(String name) {
            this.eventId = -1;
            this.eventName = name;
        }
    }

    static class EventItem {
        String name;
        int eventid;
        Vector<UpdateEventListener> listener = new Vector();

        public EventItem(String name, int eventid, UpdateEventListener l) {
            this.name = name;
            this.eventid = eventid;
            this.listener.addElement(l);
        }

        public String toString() {
            return new String("Event name = " + this.name + " Event id = " + this.eventid);
        }
    }
}

