/*
 * Decompiled with CFR 0.152.
 */
package mds.wave;

import java.util.Vector;
import mds.wave.WaveData;
import mds.wave.WaveDataListener;
import mds.wave.XYData;

public class XYWaveData
implements WaveData {
    int type;
    boolean isLong = false;
    boolean increasingX = true;
    double[] x;
    float[] y;
    double[] x2D;
    long[] x2DLong;
    float[] y2D;
    float[] z;
    long[] xLong;
    Vector<WaveDataListener> listeners = new Vector();
    boolean liveUpdateStarted = false;

    XYWaveData(double[] x, float[] y) {
        this(x, y, x.length);
    }

    XYWaveData(double[] x, float[] y, float[] z) {
        int i;
        this.type = 1;
        this.x2D = new double[x.length];
        this.y2D = new float[y.length];
        this.z = new float[z.length];
        for (i = 0; i < x.length; ++i) {
            this.x2D[i] = (float)x[i];
        }
        for (i = 0; i < y.length; ++i) {
            this.y2D[i] = y[i];
        }
        for (i = 0; i < z.length; ++i) {
            this.z[i] = z[i];
        }
        if (z.length != x.length * y.length) {
            System.out.println("INTERNAL ERROR: WRONG DIMENSIONS FOR 2D SIGNAL");
        }
    }

    XYWaveData(double[] x, float[] y, int numPoints) {
        this.type = 0;
        int len = numPoints;
        if (x.length < len) {
            len = x.length;
        }
        if (y.length < len) {
            len = y.length;
        }
        this.x = new double[len];
        this.y = new float[len];
        for (int i = 0; i < len; ++i) {
            this.x[i] = x[i];
            this.y[i] = y[i];
        }
        this.checkIncreasingX();
    }

    XYWaveData(float[] x, float[] y) {
        this(x, y, x.length);
    }

    XYWaveData(float[] x, float[] y, float[] z) {
        int i;
        this.type = 1;
        this.x2D = new double[x.length];
        this.y2D = new float[y.length];
        this.z = new float[z.length];
        for (i = 0; i < x.length; ++i) {
            this.x2D[i] = x[i];
        }
        for (i = 0; i < y.length; ++i) {
            this.y2D[i] = y[i];
        }
        for (i = 0; i < z.length; ++i) {
            this.z[i] = z[i];
        }
        if (z.length != x.length * y.length) {
            System.out.println("INTERNAL ERROR: WRONG DIMENSIONS FOR 2D SIGNAL");
        }
    }

    XYWaveData(float[] x, float[] y, int numPoints) {
        this.type = 0;
        int len = numPoints;
        if (x.length < len) {
            len = x.length;
        }
        if (y.length < len) {
            len = y.length;
        }
        this.x = new double[len];
        this.y = new float[len];
        for (int i = 0; i < len; ++i) {
            this.x[i] = x[i];
            this.y[i] = y[i];
        }
        this.checkIncreasingX();
    }

    XYWaveData(long[] x, float[] y) {
        this.type = 0;
        int len = x.length;
        if (y.length < len) {
            len = y.length;
        }
        this.x = new double[len];
        this.y = new float[len];
        this.xLong = new long[len];
        for (int i = 0; i < len; ++i) {
            this.x[i] = x[i];
            this.y[i] = y[i];
            this.xLong[i] = this.xLong[i];
        }
        this.isLong = true;
        this.checkIncreasingX();
    }

    XYWaveData(long[] x, float[] y, float[] z) {
        int i;
        this.type = 1;
        this.x2DLong = new long[x.length];
        this.y2D = new float[y.length];
        this.z = new float[z.length];
        for (i = 0; i < x.length; ++i) {
            this.x2DLong[i] = x[i];
        }
        for (i = 0; i < y.length; ++i) {
            this.y2D[i] = y[i];
        }
        for (i = 0; i < z.length; ++i) {
            this.z[i] = z[i];
        }
        if (z.length != x.length * y.length) {
            System.out.println("INTERNAL ERROR: WRONG DIMENSIONS FOR 2D SIGNAL");
        }
        this.isLong = true;
    }

    @Override
    public void addWaveDataListener(WaveDataListener listener) {
        this.listeners.addElement(listener);
    }

    void checkIncreasingX() {
        this.increasingX = true;
        for (int i = 1; i < this.x.length; ++i) {
            if (!(this.x[i - 1] > this.x[i])) continue;
            this.increasingX = false;
            return;
        }
    }

    void fireListeners(double[] x, float[] y, double resolution) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.elementAt(i).dataRegionUpdated(x, y, resolution);
        }
    }

    void fireListeners(long[] x, float[] y, double resolution) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.elementAt(i).dataRegionUpdated(x, y, resolution);
        }
    }

    @Override
    public XYData getData(double xmin, double xmax, int numPoints) {
        int actPoints;
        int maxIdx;
        int minIdx;
        if (!this.increasingX) {
            return new XYData(this.x, this.y, Double.MAX_VALUE, false);
        }
        if (xmin == -3.4028234663852886E38) {
            xmin = this.x[0];
            minIdx = 0;
        } else {
            for (minIdx = 0; minIdx < this.x.length - 2 && this.x[minIdx] < xmin; ++minIdx) {
            }
            if (minIdx > 0 && this.x[minIdx] > xmin) {
                --minIdx;
            }
        }
        if (xmax == 3.4028234663852886E38) {
            xmax = this.x[this.x.length - 1];
            maxIdx = this.x.length - 1;
        } else {
            for (maxIdx = minIdx + 1; maxIdx < this.x.length - 1 && this.x[maxIdx] < xmax; ++maxIdx) {
            }
        }
        double delta = (xmax - xmin) / (double)numPoints;
        boolean showMinMax = false;
        if (maxIdx - minIdx > 1000 && delta > (double)(4 * (maxIdx - minIdx + 1)) / (xmax - xmin)) {
            actPoints = 2 * (int)((xmax - xmin) / delta + 0.5);
            showMinMax = true;
        } else {
            actPoints = maxIdx - minIdx + 1;
            showMinMax = false;
        }
        float[] retY = new float[actPoints];
        double[] retX = new double[actPoints];
        long[] retXLong = null;
        if (this.isLong) {
            retXLong = new long[actPoints];
        }
        if (showMinMax) {
            int currIdx = minIdx;
            for (int i = 0; i < actPoints / 2; ++i) {
                float currMin = this.y[currIdx];
                float currMax = this.y[currIdx];
                double currStart = this.x[currIdx];
                while (currIdx < this.x.length - 1 && this.x[currIdx] - currStart < delta) {
                    if (this.y[currIdx] < currMin) {
                        currMin = this.y[currIdx];
                    }
                    if (this.y[currIdx] > currMax) {
                        currMax = this.y[currIdx];
                    }
                    ++currIdx;
                }
                double d = (currStart + this.x[currIdx == 0 ? 0 : currIdx - 1]) / 2.0;
                retX[2 * i + 1] = d;
                retX[2 * i] = d;
                if (this.isLong) {
                    long l = (long)((currStart + this.x[currIdx == 0 ? 0 : currIdx - 1]) / 2.0);
                    retXLong[2 * i + 1] = l;
                    retXLong[2 * i] = l;
                }
                retY[2 * i] = currMin;
                retY[2 * i + 1] = currMax;
            }
            if (this.isLong) {
                return new XYData(retXLong, retY, (double)actPoints / (xmax - xmin), true);
            }
            return new XYData(retX, retY, (double)actPoints / (xmax - xmin), true);
        }
        for (int i = 0; i < maxIdx - minIdx + 1; ++i) {
            retY[i] = this.y[minIdx + i];
            retX[i] = this.x[minIdx + i];
            if (!this.isLong) continue;
            retXLong[i] = this.xLong[minIdx + i];
        }
        if (this.isLong) {
            return new XYData(retXLong, retY, (double)Double.MAX_VALUE, true);
        }
        return new XYData(retX, retY, Double.MAX_VALUE, true);
    }

    @Override
    public XYData getData(int numPoints) {
        if (this.type != 0) {
            System.out.println("INTERNAL ERROR getData called for non 1 D signal");
            return null;
        }
        if (numPoints >= this.x.length) {
            return new XYData(this.x, this.y, Double.MAX_VALUE, true);
        }
        return this.getData(-3.4028234663852886E38, 3.4028234663852886E38, numPoints);
    }

    @Override
    public XYData getData(long xmin, long xmax, int numPoints) {
        return this.getData((double)xmin, (double)xmax, numPoints);
    }

    @Override
    public void getDataAsync(double lowerBound, double upperBound, int numPoints) {
    }

    @Override
    public int getNumDimension() {
        return 1;
    }

    @Override
    public String GetTitle() {
        return "Title";
    }

    @Override
    public double[] getX2D() {
        if (this.type == 1) {
            return this.x2D;
        }
        System.out.println("INTERNAL ERROR SimpleWave.getZ for 1D signal");
        return null;
    }

    @Override
    public long[] getX2DLong() {
        if (this.type == 1) {
            return this.x2DLong;
        }
        System.out.println("INTERNAL ERROR SimpleWave.getZ2dLong for 1D signal");
        return null;
    }

    @Override
    public String GetXLabel() {
        return "XLabel";
    }

    public double[] getXLimits() {
        double xmax;
        double xmin = xmax = this.x[0];
        for (int i = 0; i < this.x.length; ++i) {
            if (this.x[i] > xmax) {
                xmax = this.x[i];
            }
            if (!(this.x[i] < xmin)) continue;
            xmin = this.x[i];
        }
        return new double[]{xmin, xmax};
    }

    public long[] getXLong() {
        if (!this.isLong) {
            System.out.println("INTERNAL ERROR: getLong called for non long X");
            return null;
        }
        return this.xLong;
    }

    @Override
    public float[] getY2D() {
        if (this.type == 1) {
            return this.y2D;
        }
        System.out.println("INTERNAL ERROR SimpleWave.getZ for 1D signal");
        return null;
    }

    @Override
    public String GetYLabel() {
        return "YLabel";
    }

    @Override
    public float[] getZ() {
        if (this.type == 1) {
            return this.z;
        }
        System.out.println("INTERNAL ERROR SimpleWave.getZ for 1D signal");
        return null;
    }

    @Override
    public String GetZLabel() {
        return "ZLabel";
    }

    @Override
    public boolean isXLong() {
        return this.isLong;
    }

    @Override
    public void removeWaveDataListener(WaveDataListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean supportsStreaming() {
        return false;
    }

    class AsyncUpdater
    extends Thread {
        double lowerBound;
        double upperBound;
        double resolution;

        AsyncUpdater(double lowerBound, double upperBound, double resolution) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.resolution = resolution;
        }

        @Override
        public void run() {
            XYData newData = XYWaveData.this.getData(this.lowerBound, this.upperBound, 1000);
            if (XYWaveData.this.isLong) {
                XYWaveData.this.fireListeners(newData.xLong, newData.y, newData.resolution);
            } else {
                XYWaveData.this.fireListeners(newData.x, newData.y, newData.resolution);
            }
        }
    }
}

