/*
 * Decompiled with CFR 0.152.
 */
package mds.wave;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.border.Border;
import mds.wave.ColorMap;
import mds.wave.Frames;
import mds.wave.Grid;
import mds.wave.RowColumnContainer;
import mds.wave.Signal;
import mds.wave.SignalListener;
import mds.wave.WavePopup;
import mds.wave.WaveformEvent;
import mds.wave.WaveformListener;
import mds.wave.WaveformMetrics;

public class Waveform
extends JComponent
implements SignalListener {
    private static final long serialVersionUID = 1L;
    public static final int JAVA_TIME = 1;
    public static final int VMS_TIME = 2;
    public static final int EPICS_TIME = 3;
    public static int timeMode = 1;
    public static final long VMS_BASE = 35067168000000000L;
    public static final long EPICS_BASE = 631152000000L;
    public static final int MAX_POINTS = 1000;
    public static boolean is_debug = false;
    public static final Color[] COLOR_SET = new Color[]{Color.black, Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.red, Color.yellow};
    public static final String[] COLOR_NAME = new String[]{"Black", "Blue", "Cyan", "DarkGray", "Gray", "Green", "LightGray", "Magenta", "Orange", "Pink", "Red", "Yellow"};
    public static boolean zoom_on_mb1 = true;
    public static final int MARKER_WIDTH = 8;
    public static final int MODE_ZOOM = 1;
    public static final int MODE_POINT = 2;
    public static final int MODE_PAN = 3;
    public static final int MODE_COPY = 4;
    public static final int MODE_WAIT = 5;
    private static final int MIN_W = 10;
    private static final int MIN_H = 10;
    public static final int NO_PRINT = 0;
    public static final int PRINT = 2;
    protected static Color[] colors;
    protected static String[] colors_name;
    protected static boolean colors_changed;
    protected static Font font;
    static double mark_point_x;
    static double mark_point_y;
    private static boolean bug_image;
    protected static int horizontal_offset;
    protected static int vertical_offset;
    protected Signal waveform_signal;
    protected WaveformMetrics wm;
    protected boolean not_drawn = true;
    protected boolean reversed = false;
    protected boolean show_sig_image = false;
    protected Polygon polygon;
    protected int prev_width;
    protected int prev_height;
    protected int prev_point_x;
    protected int prev_point_y;
    protected Grid grid;
    protected Color crosshair_color;
    protected Rectangle curr_rect = null;
    protected int start_x;
    protected int start_y;
    protected int end_x;
    protected int end_y;
    protected int orig_x;
    protected int orig_y;
    protected Image off_image;
    protected Graphics off_graphics;
    protected Rectangle wave_b_box;
    protected String x_label;
    protected String y_label;
    protected String z_label;
    protected String title;
    public int mode;
    public int grid_mode;
    protected boolean dragging;
    protected boolean copy_selected = false;
    protected boolean resizing = true;
    protected int pan_x;
    protected int pan_y;
    protected double pan_delta_x;
    protected double pan_delta_y;
    protected int update_timestamp;
    protected Point[] points;
    protected int num_points;
    protected int grid_step_x = 3;
    protected int grid_step_y = 3;
    protected boolean first_set_point;
    protected int marker_width;
    protected boolean x_log;
    protected boolean y_log;
    protected boolean is_mb2;
    protected boolean is_mb3;
    protected boolean int_xlabel = true;
    protected boolean int_ylabel = true;
    protected Rectangle curr_display_limits;
    protected Cursor def_cursor;
    protected boolean is_select;
    protected boolean just_deselected;
    protected WavePopup menu;
    private boolean execute_print = false;
    protected boolean show_measure = false;
    protected boolean change_limits = false;
    protected double wave_point_x = 0.0;
    protected double wave_point_y = 0.0;
    protected double curr_point;
    protected double curr_point_y;
    protected int frame = 0;
    protected int prev_frame = -1;
    public boolean is_image = false;
    protected boolean is_playing = false;
    protected Frames frames;
    protected double frame_time = 0.0;
    protected String wave_error = null;
    private final Vector<WaveformListener> waveform_listener = new Vector();
    private final Vector<ZoomRegion> undo_zoom = new Vector();
    private boolean send_profile = false;
    protected Border unselect_border;
    protected Border select_border;
    private boolean border_changed = false;
    private final Timer play_timer;
    private boolean restart_play = false;
    private boolean pan_enabled = true;
    private double xmax = 1.0;
    private double ymax = 1.0;
    private double xmin = 0.0;
    private double ymin = 0.0;
    boolean is_min_size;
    private boolean event_enabled = true;
    public float lx_max = Float.MAX_VALUE;
    public float lx_min = Float.MIN_VALUE;
    public float ly_max = Float.MAX_VALUE;
    public float ly_min = Float.MIN_VALUE;
    protected ColorMap colorMap = new ColorMap();
    private String properties;
    boolean appendDrawMode = false;
    boolean appendPaintFlag = false;
    Rectangle frame_zoom = null;

    public static int ColorNameToIndex(String name) {
        if (name == null) {
            return 0;
        }
        for (int i = 0; i < COLOR_NAME.length; ++i) {
            if (!name.toLowerCase().equals(COLOR_NAME[i].toLowerCase())) continue;
            return i;
        }
        return 0;
    }

    public static long convertFromSpecificDeltaTime(long deltaTime) {
        if (timeMode == 2) {
            return deltaTime / 10000L;
        }
        if (timeMode == 3) {
            return deltaTime / 1000000L;
        }
        return deltaTime;
    }

    public static long convertFromSpecificTime(long inTime) {
        if (timeMode == 2) {
            return (inTime - 35067168000000000L) / 10000L;
        }
        if (timeMode == 3) {
            long currTime = inTime / 1000000L + 631152000000L;
            return currTime;
        }
        return inTime;
    }

    public static long convertToSpecificTime(long inTime) {
        if (timeMode == 2) {
            return inTime * 10000L + 35067168000000000L;
        }
        if (timeMode == 3) {
            return (inTime - 631152000000L) * 1000000L;
        }
        return inTime;
    }

    protected static String ConvertToString(double f, boolean is_log) {
        String out;
        double abs_f = Math.abs(f);
        if (abs_f != Double.POSITIVE_INFINITY) {
            if (abs_f > 1000.0) {
                double curr_f = f;
                int exp = 0;
                while (Math.abs(curr_f) > 10.0) {
                    curr_f /= 10.0;
                    ++exp;
                }
                out = Float.toString((float)((double)Math.round(curr_f * 100.0) / 100.0)) + "e" + Integer.toString(exp);
            } else if (abs_f < 0.001 && abs_f > 0.0) {
                double curr_f = f;
                int exp = 0;
                while (Math.abs(curr_f) < 1.0) {
                    curr_f *= 10.0;
                    --exp;
                }
                out = Float.toString((float)curr_f) + "e" + Integer.toString(exp);
            } else {
                out = Float.toString((float)f);
                if (f < 1.0 && f > -1.0) {
                    int i = out.length() - 1;
                    while (out.charAt(i) == '0') {
                        --i;
                    }
                    out = out.substring(0, i + 1);
                }
            }
        } else {
            out = (f > 0.0 ? "+" : "-") + "inf";
        }
        out = out.trim();
        return out;
    }

    public static Color[] getColors() {
        colors_changed = false;
        return colors;
    }

    public static String[] getColorsName() {
        colors_changed = false;
        return colors_name;
    }

    public static int GetHorizontalOffset() {
        return horizontal_offset;
    }

    public static int getTimeMode() {
        return timeMode;
    }

    public static int GetVerticalOffset() {
        return vertical_offset;
    }

    static boolean isColorsChanged() {
        return colors_changed;
    }

    public static void SetColors(Color[] _colors, String[] _colors_name) {
        colors_changed = true;
        colors = _colors;
        colors_name = _colors_name;
    }

    public static void SetFont(Font f) {
        font = f;
    }

    public static void SetHorizontalOffset(int h_offset) {
        horizontal_offset = h_offset;
    }

    public static void SetVerticalOffset(int v_offset) {
        vertical_offset = v_offset;
    }

    public Waveform() {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setSelectBorder(BorderFactory.createBevelBorder(0, Color.red, Color.red));
        this.play_timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Waveform.this.frame = Waveform.this.frames.getNextFrameIdx();
                if (Waveform.this.frame == Waveform.this.frames.getNumFrame() - 1) {
                    Waveform.this.frame = 0;
                }
                Waveform.this.repaint();
                if (Waveform.this.mode == 2) {
                    Waveform.this.sendUpdateEvent();
                    if (Waveform.this.send_profile) {
                        Waveform.this.sendProfileEvent();
                    }
                }
            }
        });
        this.prev_point_y = -1;
        this.prev_point_x = -1;
        this.update_timestamp = 0;
        this.waveform_signal = null;
        this.mode = 1;
        this.dragging = false;
        this.grid_mode = 0;
        this.first_set_point = true;
        this.marker_width = 8;
        this.y_log = false;
        this.x_log = false;
        this.setMouse();
        this.setKeys();
        this.SetDefaultColors();
    }

    public Waveform(Signal s) {
        this();
        this.waveform_signal = s;
        this.waveform_signal.registerSignalListener(this);
        this.not_drawn = true;
    }

    public synchronized void addWaveformListener(WaveformListener l) {
        if (l == null) {
            return;
        }
        this.waveform_listener.addElement(l);
    }

    public synchronized void appendPaint(Graphics g, Dimension d) {
        this.setFont(g);
        g.setColor(Color.black);
        if (!this.is_image) {
            if (this.wm != null) {
                this.appendDrawMode = true;
                this.appendPaintFlag = true;
                this.drawSignal(g, d, 0);
                this.appendDrawMode = false;
            } else {
                this.PaintSignal(g, d, 0);
            }
        } else {
            this.PaintImage(g, d, 0);
        }
    }

    public void appendUpdate() {
        this.appendPaint(this.getGraphics(), this.getSize());
    }

    public void applyColorModel(ColorMap cm) {
        if (cm == null) {
            return;
        }
        if (this.frames != null) {
            this.frames.applyColorModel(cm);
        } else {
            this.colorMap = cm;
        }
        this.not_drawn = true;
        this.repaint();
    }

    public void Autoscale() {
        if (this.is_image && this.frames != null && this.frames.getNumFrame() != 0) {
            this.frames.Resize();
        } else {
            if (this.waveform_signal == null) {
                return;
            }
            this.waveform_signal.Autoscale();
            this.unfreeze();
        }
        this.ReportChanges();
    }

    public void AutoscaleY() {
        if (this.waveform_signal == null) {
            return;
        }
        this.waveform_signal.AutoscaleY();
        this.ReportChanges();
    }

    protected float convertX(int x) {
        Dimension d = this.getWaveSize();
        return (float)this.wm.XValue(x, d);
    }

    protected float convertY(int y) {
        Dimension d = this.getWaveSize();
        return (float)this.wm.YValue(y, d);
    }

    public void Copy(Waveform wave) {
        if (wave.is_image) {
            this.frames = new Frames(wave.frames);
            this.frame = wave.frame;
            this.prev_frame = wave.prev_frame;
            this.frame_time = wave.frame_time;
            this.is_image = true;
        } else {
            this.is_image = false;
        }
        this.not_drawn = true;
        this.repaint();
    }

    public void DeselectWave() {
        this.is_select = false;
        this.border_changed = true;
        if (!this.unselect_border.getBorderInsets(this).equals(this.select_border.getBorderInsets(this))) {
            this.not_drawn = true;
        }
        this.setBorder(this.unselect_border);
    }

    protected synchronized void dispatchWaveformEvent(WaveformEvent e) {
        if (e == null || !this.event_enabled) {
            return;
        }
        if (this.waveform_listener != null) {
            for (int i = 0; i < this.waveform_listener.size(); ++i) {
                this.waveform_listener.elementAt(i).processWaveformEvent(e);
            }
        }
    }

    public void drawContourLevel(Vector<Vector<Point2D.Double>> cOnLevel, Graphics g, Dimension d) {
        this.wm.ComputeFactors(d);
        for (int i = 0; i < cOnLevel.size(); ++i) {
            Vector<Point2D.Double> c = cOnLevel.elementAt(i);
            int[] cx = new int[c.size()];
            int[] cy = new int[c.size()];
            for (int j = 0; j < c.size(); ++j) {
                Point2D.Double p = c.elementAt(j);
                cx[j] = this.wm.XPixel(p.x);
                cy[j] = this.wm.YPixel(p.y);
            }
            g.drawPolyline(cx, cy, c.size());
        }
    }

    void drawError(Signal sig, Graphics g, Dimension d) {
        if (!sig.hasError()) {
            return;
        }
        float[] up_error = sig.getUpError();
        float[] low_error = sig.getLowError();
        for (int i = 0; i < sig.getNumPoints(); ++i) {
            try {
                int up = this.wm.YPixel(up_error[i] + sig.getY(i), d);
                int low = !sig.hasAsymError() ? this.wm.YPixel(sig.getY(i) - up_error[i], d) : this.wm.YPixel(sig.getY(i) - low_error[i], d);
                int x = this.wm.XPixel(sig.getX(i), d);
                g.drawLine(x, up, x, low);
                g.drawLine(x - 2, up, x + 2, up);
                g.drawLine(x - 2, low, x + 2, low);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected boolean DrawFrame(Graphics g, Dimension d, int frame_idx) {
        Image img;
        this.wave_error = null;
        if (this.mode == 1 && this.curr_rect != null) {
            Rectangle rect = new Rectangle(this.start_x, this.start_y, Math.abs(this.start_x - this.end_x), Math.abs(this.start_y - this.end_y));
            frame_idx = this.frames.GetFrameIdx();
            this.frames.SetZoomRegion(frame_idx, d, rect);
            this.curr_rect = null;
        }
        if ((img = this.frames.GetFrame(frame_idx, d)) == null) {
            this.wave_error = this.frames.getError();
            if (this.wave_error == null || this.wave_error.length() == 0) {
                this.wave_error = " No frame at time " + this.curr_point;
            }
            return false;
        }
        Dimension dim = this.frames.getFrameSize(frame_idx, this.getWaveSize());
        int type = this.frames.getFrameType();
        this.DrawImage(g, img, dim, type);
        return true;
    }

    protected void DrawImage(Graphics g, Image img, Dimension dim, int type) {
        Rectangle r = this.frames.GetZoomRect();
        Graphics2D g2 = (Graphics2D)g;
        Dimension imgDim = new Dimension(((BufferedImage)img).getWidth(), ((BufferedImage)img).getHeight());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (type != 9) {
            int sy2;
            int dx1 = 1;
            int dy1 = 1;
            int dx2 = dim.width;
            int dy2 = dim.height;
            int sx1 = r == null ? 0 : r.x;
            int sy1 = r == null ? 0 : r.y;
            int sx2 = r == null ? imgDim.width : r.x + r.width;
            int n = sy2 = r == null ? imgDim.height : r.y + r.height;
            if (this.frames.getVerticalFlip() && this.frames.getHorizontalFlip()) {
                dx1 = dim.width;
                dy1 = dim.height;
                dx2 = 1;
                dy2 = 1;
            } else if (this.frames.getVerticalFlip()) {
                dx1 = dim.width;
                dy1 = 1;
                dx2 = 1;
                dy2 = dim.height;
            } else if (this.frames.getHorizontalFlip()) {
                dx1 = 1;
                dy1 = dim.height;
                dx2 = dim.width;
                dy2 = 1;
            }
            g2.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this);
        } else {
            g2.clearRect(0, 0, dim.width, dim.height);
            g2.drawRenderedImage((RenderedImage)((Object)img), new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        }
    }

    protected void drawMarkers(Graphics g, Point[] pnt, int n_pnt, int marker, int step, int mode) {
        block7: for (int i = 0; i < n_pnt; i += step) {
            if (mode == 3 && i % 2 == 1) continue;
            switch (marker) {
                case 2: {
                    g.drawOval(pnt[i].x - this.marker_width / 2, pnt[i].y - this.marker_width / 2, this.marker_width, this.marker_width);
                    continue block7;
                }
                case 1: {
                    g.drawRect(pnt[i].x - this.marker_width / 2, pnt[i].y - this.marker_width / 2, this.marker_width, this.marker_width);
                    continue block7;
                }
                case 4: {
                    g.drawLine(pnt[i].x - this.marker_width / 2, pnt[i].y + this.marker_width / 2, pnt[i].x, pnt[i].y - this.marker_width / 2);
                    g.drawLine(pnt[i].x + this.marker_width / 2, pnt[i].y + this.marker_width / 2, pnt[i].x, pnt[i].y - this.marker_width / 2);
                    g.drawLine(pnt[i].x - this.marker_width / 2, pnt[i].y + this.marker_width / 2, pnt[i].x + this.marker_width / 2, pnt[i].y + this.marker_width / 2);
                    continue block7;
                }
                case 3: {
                    g.drawLine(pnt[i].x, pnt[i].y - this.marker_width / 2, pnt[i].x, pnt[i].y + this.marker_width / 2);
                    g.drawLine(pnt[i].x - this.marker_width / 2, pnt[i].y, pnt[i].x + this.marker_width / 2, pnt[i].y);
                    continue block7;
                }
                case 5: {
                    g.fillRect(pnt[i].x - 1, pnt[i].y - 1, 3, 3);
                }
            }
        }
    }

    protected void drawMarkers(Graphics g, Vector<Polygon> segments, int marker, int step, int mode) {
        for (int k = 0; k < segments.size(); ++k) {
            Polygon currPolygon = segments.elementAt(k);
            int[] pntX = currPolygon.xpoints;
            int[] pntY = currPolygon.ypoints;
            block8: for (int i = 0; i < currPolygon.npoints; i += step) {
                if (mode == 3 && i % 2 == 1) continue;
                switch (marker) {
                    case 2: {
                        g.drawOval(pntX[i] - this.marker_width / 2, pntY[i] - this.marker_width / 2, this.marker_width, this.marker_width);
                        continue block8;
                    }
                    case 1: {
                        g.drawRect(pntX[i] - this.marker_width / 2, pntY[i] - this.marker_width / 2, this.marker_width, this.marker_width);
                        continue block8;
                    }
                    case 4: {
                        g.drawLine(pntX[i] - this.marker_width / 2, pntY[i] + this.marker_width / 2, pntX[i], pntY[i] - this.marker_width / 2);
                        g.drawLine(pntX[i] + this.marker_width / 2, pntY[i] + this.marker_width / 2, pntX[i], pntY[i] - this.marker_width / 2);
                        g.drawLine(pntX[i] - this.marker_width / 2, pntY[i] + this.marker_width / 2, pntX[i] + this.marker_width / 2, pntY[i] + this.marker_width / 2);
                        continue block8;
                    }
                    case 3: {
                        g.drawLine(pntX[i], pntY[i] - this.marker_width / 2, pntX[i], pntY[i] + this.marker_width / 2);
                        g.drawLine(pntX[i] - this.marker_width / 2, pntY[i], pntX[i] + this.marker_width / 2, pntY[i]);
                        continue block8;
                    }
                    case 5: {
                        g.fillRect(pntX[i] - 1, pntY[i] - 1, 3, 3);
                    }
                }
            }
        }
    }

    protected void drawMarkers(Signal s, Graphics g, Dimension d) {
        if (s.getMarker() != 0) {
            Vector<Polygon> segments = this.wm.ToPolygons(s, d, this.appendDrawMode);
            this.drawMarkers(g, segments, s.getMarker(), s.getMarkerStep(), s.getMode1D());
        }
    }

    protected void drawSignal(Graphics g) {
        this.drawSignal(g, this.getWaveSize(), 0);
    }

    protected void drawSignal(Graphics g, Dimension d, int print_mode) {
        this.drawSignal(this.waveform_signal, g, d);
    }

    protected void drawSignal(Signal s, Graphics g, Dimension d) {
        if (s.getType() == 1) {
            switch (s.getMode2D()) {
                case 3: {
                    if (this.mode != 3 || !this.dragging) {
                        Image img = this.createImage(d.width, d.height);
                        this.wm.ToImage(s, img, d, this.colorMap);
                        g.drawImage(img, 0, 0, d.width, d.height, this);
                    }
                    return;
                }
                case 2: {
                    if (this.mode != 3 || !this.dragging) {
                        this.drawSignalContour(s, g, d);
                    }
                    return;
                }
            }
        }
        this.drawWave(s, g, d);
        this.drawMarkers(s, g, d);
        this.drawError(s, g, d);
    }

    protected void drawSignalContour(Signal s, Graphics g, Dimension d) {
        Vector<Vector<Vector<Point2D.Double>>> cs = s.getContourSignals();
        Vector<Double> ls = s.getContourLevelValues();
        for (int l = 0; l < cs.size(); ++l) {
            float zMax;
            Vector<Vector<Point2D.Double>> cOnLevel = cs.elementAt(l);
            float level = ls.elementAt(l).floatValue();
            float[] z = s.getZ();
            float zMin = zMax = z[0];
            for (float element : z) {
                if (element < zMin) {
                    zMin = element;
                }
                if (!(element > zMax)) continue;
                zMax = element;
            }
            g.setColor(this.colorMap.getColor(level, zMin, zMax));
            this.drawContourLevel(cOnLevel, g, d);
        }
    }

    void drawWave(Signal s, Graphics g, Dimension d) {
        Vector<Polygon> segments = this.wm.ToPolygons(s, d, this.appendDrawMode);
        if (s.getColor() != null) {
            g.setColor(s.getColor());
        } else {
            g.setColor(colors[s.getColorIdx() % colors.length]);
        }
        for (int k = 0; k < segments.size(); ++k) {
            Polygon curr_polygon = segments.elementAt(k);
            if (!s.getInterpolate()) continue;
            g.drawPolyline(curr_polygon.xpoints, curr_polygon.ypoints, curr_polygon.npoints);
        }
    }

    void DrawWave(Dimension d) {
        int i;
        int curr_mode = this.waveform_signal.getMode1D();
        this.num_points = curr_mode == 3 ? this.waveform_signal.getNumPoints() * 2 - 1 : this.waveform_signal.getNumPoints();
        int[] x = new int[this.waveform_signal.getNumPoints()];
        int[] y = new int[this.waveform_signal.getNumPoints()];
        this.points = new Point[this.waveform_signal.getNumPoints()];
        if (curr_mode == 3) {
            for (i = 1; i < this.waveform_signal.getNumPoints() - 1; i += 2) {
                x[i - 1] = this.wm.XPixel(this.waveform_signal.getX(i), d);
                y[i - 1] = this.wm.YPixel(this.waveform_signal.getY(i), d);
                x[i] = x[i - 1];
                y[i] = y[i + 1];
                this.points[i] = new Point(x[i - 1], y[i + 1]);
            }
        } else {
            for (i = 0; i < this.waveform_signal.getNumPoints(); ++i) {
                x[i] = this.wm.XPixel(this.waveform_signal.getX(i), d);
                y[i] = this.wm.YPixel(this.waveform_signal.getY(i), d);
                this.points[i] = new Point(x[i], y[i]);
            }
        }
        this.polygon = new Polygon(x, y, i);
        this.end_x = x[0];
        this.end_y = y[0];
    }

    public void Erase() {
        this.update_timestamp = 0;
        this.waveform_signal = null;
        this.dragging = false;
        this.first_set_point = true;
        this.marker_width = 8;
        this.y_log = false;
        this.x_log = false;
        this.off_image = null;
        this.not_drawn = true;
        this.frames = null;
        this.prev_frame = -1;
        this.grid = null;
        this.x_label = null;
        this.y_label = null;
        this.not_drawn = true;
        this.show_sig_image = false;
        this.repaint();
    }

    protected Point FindPoint(double curr_x, double curr_y, boolean is_first) {
        return this.FindPoint(this.waveform_signal, curr_x, curr_y, this.getWaveSize());
    }

    protected Point FindPoint(double curr_x, double curr_y, Dimension d, boolean is_first) {
        return this.FindPoint(this.waveform_signal, curr_x, curr_y, d);
    }

    protected Point FindPoint(Signal s, double curr_x, double curr_y, Dimension d) {
        double x = 0.0;
        double y = 0.0;
        if (s == null) {
            return null;
        }
        if (s.getType() == 1) {
            switch (s.getMode2D()) {
                case 3: {
                    this.wave_point_x = s.getClosestX(curr_x);
                    this.wave_point_y = s.getClosestY(curr_y);
                    d = this.getWaveSize();
                    Point p = new Point(this.wm.XPixel(this.wave_point_x, d), this.wm.YPixel(this.wave_point_y, d));
                    return p;
                }
                case 2: {
                    this.wave_point_x = curr_x;
                    this.wave_point_y = curr_y;
                    s.surfaceValue(this.wave_point_x, this.wave_point_y);
                    d = this.getWaveSize();
                    Point p = new Point(this.wm.XPixel(this.wave_point_x, d), this.wm.YPixel(this.wave_point_y, d));
                    return p;
                }
            }
        }
        if (!s.hasX()) {
            return null;
        }
        int idx = s.FindClosestIdx(curr_x, curr_y);
        if (curr_x > s.getCurrentXmax() || curr_x < s.getCurrentXmin() || idx == s.getNumPoints() - 1) {
            y = s.getY(idx);
            x = s.getX(idx);
        } else if (s.getMarker() != 0 && !s.getInterpolate() && s.getMode1D() != 3 || s.findNaN()) {
            boolean increase = s.getX(idx) < s.getX(idx + 1);
            double val = increase ? s.getX(idx) + s.getX(idx + 1) - s.getX(idx) / 2.0 : s.getX(idx + 1) + s.getX(idx) - s.getX(idx + 1) / 2.0;
            if (s.getX(idx) == s.getX(idx + 1) && !Double.isNaN(s.getY(idx + 1))) {
                val += curr_x;
            }
            if (curr_x < val) {
                y = s.getY(idx + (increase ? 0 : 1));
                x = s.getX(idx + (increase ? 0 : 1));
            } else {
                y = s.getY(idx + (increase ? 1 : 0));
                x = s.getX(idx + (increase ? 1 : 0));
            }
        } else {
            x = curr_x;
            try {
                y = s.getMode1D() == 3 ? (double)s.getY(idx) : (double)s.getY(idx) + (double)(s.getY(idx + 1) - s.getY(idx)) * (x - s.getX(idx)) / (s.getX(idx + 1) - s.getX(idx));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.wave_point_x = x;
        this.wave_point_y = y;
        return new Point(this.wm.XPixel(x, d), this.wm.YPixel(y, d));
    }

    void freeze() {
        this.waveform_signal.freeze();
    }

    protected int getBottomSize() {
        return 0;
    }

    public int GetColorIdx() {
        if (this.waveform_signal != null) {
            return this.waveform_signal.getColorIdx();
        }
        if (this.frames != null) {
            return this.frames.GetColorIdx();
        }
        return 0;
    }

    public ColorMap getColorMap() {
        return this.frames.getColorMap();
    }

    public int getColumn() {
        RowColumnContainer rwc = (RowColumnContainer)this.getParent();
        Point p = rwc.getComponentPosition(this);
        return p.x - 1;
    }

    public int GetGridMode() {
        return this.grid_mode;
    }

    public int GetGridStepX() {
        return this.grid_step_x;
    }

    public int GetGridStepY() {
        return this.grid_step_y;
    }

    public Image GetImage() {
        return this.off_image;
    }

    public int getIndex() {
        RowColumnContainer rwc = (RowColumnContainer)this.getParent();
        return rwc.getComponentIndex(this) - 1;
    }

    public boolean GetInterpolate() {
        return this.waveform_signal != null ? this.waveform_signal.getInterpolate() : true;
    }

    public String getIntervalPoints() {
        Dimension d = this.getWaveSize();
        double curr_x = this.wm.XValue(this.end_x, d);
        double curr_y = this.wm.YValue(this.end_y, d);
        curr_x = this.wave_point_x;
        curr_y = this.wave_point_y;
        return " " + mark_point_x + " " + mark_point_y + " " + curr_x + " " + curr_y;
    }

    protected Dimension getLegendDimension(Graphics g) {
        return new Dimension(0, 0);
    }

    public int GetMarker() {
        return this.waveform_signal != null ? this.waveform_signal.getMarker() : 0;
    }

    public int GetMarkerStep() {
        return this.waveform_signal != null ? this.waveform_signal.getMarkerStep() : 0;
    }

    @Override
    public Dimension getMinimumSize() {
        Insets i = this.getInsets();
        return new Dimension(10 + i.right + i.left, 10 + i.top + i.bottom);
    }

    public int GetMode() {
        return this.mode;
    }

    protected Dimension getPrintWaveSize(Dimension dim) {
        return new Dimension(dim.width - this.getRightSize(), dim.height - this.getBottomSize());
    }

    public String getProperties() {
        return this.properties;
    }

    protected int getRightSize() {
        return 0;
    }

    public int getRow() {
        RowColumnContainer rwc = (RowColumnContainer)this.getParent();
        Point p = rwc.getComponentPosition(this);
        return p.y - 1;
    }

    protected int GetSelectedSignal() {
        return 0;
    }

    public int GetShowSignalCount() {
        if (this.waveform_signal != null) {
            return 1;
        }
        return 0;
    }

    public Signal GetSignal() {
        return this.waveform_signal;
    }

    public int getSignalMode1D() {
        int mode = -1;
        if (this.waveform_signal != null) {
            mode = this.waveform_signal.getMode1D();
        }
        return mode;
    }

    public int getSignalMode2D() {
        int mode = -1;
        if (this.waveform_signal != null) {
            mode = this.waveform_signal.getMode2D();
        }
        return mode;
    }

    public String getSignalName() {
        if (this.is_image && this.frames != null) {
            return this.frames.getName();
        }
        return this.waveform_signal != null ? this.waveform_signal.getName() : "";
    }

    public int getSignalType() {
        return this.waveform_signal != null ? this.waveform_signal.getType() : -1;
    }

    public String GetTitle() {
        return this.title;
    }

    public WaveformMetrics GetWaveformMetrics() {
        return this.wm;
    }

    protected Dimension getWaveSize() {
        Dimension dim = this.getSize();
        Insets i = this.getInsets();
        return new Dimension(dim.width - this.getRightSize() - i.top - i.bottom, dim.height - this.getBottomSize() - i.right - i.left);
    }

    public String GetXLabel() {
        return this.x_label;
    }

    public String GetYLabel() {
        return this.y_label;
    }

    protected void HandleCopy() {
    }

    protected void HandlePaste() {
    }

    private void ImageActions(Graphics g, Dimension d) {
        if ((this.frames != null && this.frames.getNumFrame() != 0 && (this.mode == 2 || this.mode == 1) && !this.not_drawn && !this.is_min_size || this.frames != null && this.send_profile && this.prev_frame != this.frame) && this.mode == 2) {
            Color prev_color = g.getColor();
            if (this.crosshair_color != null) {
                g.setColor(this.crosshair_color);
            }
            g.drawLine(0, this.end_y, d.width, this.end_y);
            g.drawLine(this.end_x, 0, this.end_x, d.height);
            if (this.show_measure) {
                g.setColor(Color.green);
                Point mp = this.frames.getMeasurePoint(d);
                g.drawLine(mp.x, mp.y, this.end_x, this.end_y);
            }
            g.setColor(prev_color);
        }
    }

    public boolean IsCopySelected() {
        return this.copy_selected;
    }

    public boolean IsImage() {
        return this.is_image;
    }

    public boolean IsReversed() {
        return this.reversed;
    }

    public boolean IsSelected() {
        return this.is_select;
    }

    public boolean isSendProfile() {
        return this.send_profile;
    }

    public boolean IsShowSigImage() {
        return this.show_sig_image;
    }

    public boolean isWaveformVisible() {
        Dimension d = this.getWaveSize();
        return d.width > 0 && d.height > 0;
    }

    protected double MaxXSignal() {
        if (this.waveform_signal == null) {
            return 1.0;
        }
        return this.waveform_signal.getXmax();
    }

    protected double MaxYSignal() {
        if (this.waveform_signal == null) {
            return 1.0;
        }
        if (this.waveform_signal.getYmax() <= this.waveform_signal.getYmin()) {
            return this.waveform_signal.getYmax() + 0.001 + Math.abs(this.waveform_signal.getYmax());
        }
        return this.waveform_signal.getYmax();
    }

    protected double MinXSignal() {
        if (this.waveform_signal == null) {
            return 0.0;
        }
        return this.waveform_signal.getXmin();
    }

    protected double MinYSignal() {
        if (this.waveform_signal == null) {
            return 0.0;
        }
        if (this.waveform_signal.getYmax() <= this.waveform_signal.getYmin()) {
            return this.waveform_signal.getYmin() - 0.001 - Math.abs(this.waveform_signal.getYmax());
        }
        return this.waveform_signal.getYmin();
    }

    protected void NotifyZoom(double start_xs, double end_xs, double start_ys, double end_ys, int timestamp) {
    }

    public synchronized void paint(Graphics g, Dimension d, int print_mode) {
        this.execute_print = print_mode != 0;
        Insets i = this.getInsets();
        this.setFont(g);
        if (this.not_drawn || this.prev_width != d.width || this.prev_height != d.height || this.execute_print || this.is_image && this.prev_frame != this.frame || this.appendPaintFlag) {
            Dimension dim;
            this.appendPaintFlag = false;
            this.not_drawn = false;
            if (print_mode == 0) {
                boolean bl = this.resizing = this.prev_width != d.width || this.prev_height != d.height;
                if (this.resizing && this.is_image && this.frames != null) {
                    try {
                        Point p = this.frames.getFramePoint(new Point(this.end_x, this.end_y), new Dimension(this.prev_width, this.prev_height));
                        p = this.frames.getImagePoint(p, d);
                        this.end_x = p.x;
                        this.end_y = p.y;
                    }
                    catch (Exception p) {
                        // empty catch block
                    }
                }
                dim = this.getWaveSize();
                this.is_min_size = dim.width < 10 || dim.height < 10;
                if (bug_image) {
                    bug_image = false;
                    this.off_image = this.createImage(1, 1);
                    this.off_graphics = this.off_image.getGraphics();
                    this.off_graphics.drawString("", 0, 0);
                    this.off_graphics.dispose();
                }
                this.off_image = this.createImage(d.width, d.height);
                this.off_graphics = this.off_image.getGraphics();
                this.setFont(this.off_graphics);
                this.paintBorder(this.off_graphics);
                this.border_changed = false;
                this.off_graphics.translate(i.right, i.top);
            } else {
                this.resizing = true;
                dim = d;
                this.off_graphics = g;
                g.setColor(Color.black);
                this.off_graphics.drawRect(0, 0, d.width - 1, d.height - 1);
            }
            this.off_graphics.setClip(0, 0, dim.width, dim.height);
            if (!this.is_image) {
                this.PaintSignal(this.off_graphics, d, print_mode);
            } else {
                this.PaintImage(this.off_graphics, d, print_mode);
            }
            if (print_mode == 0) {
                this.off_graphics.translate(-i.right, -i.top);
                this.off_graphics.setClip(0, 0, d.width, d.height);
                this.prev_width = d.width;
                this.prev_height = d.height;
            }
        } else if (this.border_changed) {
            this.paintBorder(this.off_graphics);
            this.border_changed = false;
        }
        if (this.execute_print) {
            this.execute_print = false;
            System.gc();
            return;
        }
        if ((this.mode != 3 || !this.dragging || this.waveform_signal == null || this.is_image) && this.off_image != null) {
            g.drawImage(this.off_image, 0, 0, this);
        }
        g.translate(i.right, i.top);
        if (this.mode == 1 && this.curr_rect != null) {
            if (this.is_image && this.crosshair_color != null) {
                g.setColor(this.crosshair_color);
            } else if (this.reversed) {
                g.setColor(Color.white);
            } else {
                g.setColor(Color.black);
            }
            g.drawRect(this.curr_rect.x, this.curr_rect.y, this.curr_rect.width, this.curr_rect.height);
        }
        if (this.is_image) {
            d = this.getWaveSize();
            this.ImageActions(g, d);
        } else {
            d = this.getWaveSize();
            this.SignalActions(g, d);
        }
        if (this.show_measure && this.mode == 2) {
            int mark_py;
            int mark_px;
            Color c = g.getColor();
            g.setColor(Color.red);
            if (this.is_image) {
                mark_px = (int)mark_point_x;
                mark_py = (int)mark_point_y;
                Point mp = this.frames.getMeasurePoint(d);
                mark_px = mp.x;
                mark_py = mp.y;
            } else {
                mark_px = this.wm.XPixel(mark_point_x, d);
                mark_py = this.wm.YPixel(mark_point_y, d);
            }
            g.drawLine(mark_px, 0, mark_px, d.height);
            g.drawLine(0, mark_py, d.width, mark_py);
            g.setColor(c);
        }
        g.translate(-i.right, -i.top);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.execute_print) {
            return;
        }
        Dimension d = this.getSize();
        this.paint(g, d, 0);
        if (this.mode == 2 && this.send_profile) {
            this.sendProfileEvent();
        }
    }

    public synchronized void PaintImage(Graphics g, Dimension d, int print_mode) {
        if (this.frames != null) {
            this.DrawFrame(g, d, this.frame);
            this.prev_frame = this.frames.GetFrameIdx();
        } else {
            this.prev_frame = -1;
            this.curr_rect = null;
        }
        this.grid = new Grid(this.xmax, this.ymax, this.xmin, this.ymin, this.x_log, this.y_log, this.grid_mode, this.x_label, this.y_label, this.title, this.wave_error, this.grid_step_x, this.grid_step_y, this.int_xlabel, this.int_ylabel, true);
        if (!this.is_min_size) {
            this.grid.paint(g, d, this, null);
        }
    }

    protected synchronized void PaintSignal(Graphics g, Dimension dim, int print_mode) {
        double curr_y;
        double curr_x;
        Point p;
        String orizLabel = this.x_label;
        String vertLabel = this.y_label;
        String sigTitle = this.title;
        Dimension d = print_mode == 0 ? this.getWaveSize() : this.getPrintWaveSize(dim);
        this.xmax = 1.0;
        this.ymax = 1.0;
        this.xmin = 0.0;
        this.ymin = 0.0;
        if (!(this.mode == 3 && this.dragging || this.waveform_signal == null)) {
            this.xmax = this.MaxXSignal();
            this.xmin = this.MinXSignal();
            this.ymax = this.MaxYSignal();
            this.ymin = this.MinYSignal();
            if (this.xmax != Double.MAX_VALUE && this.xmin != Double.MIN_VALUE) {
                double xrange = this.xmax - this.xmin;
                this.xmax += xrange * (double)horizontal_offset / 200.0;
                this.xmin -= xrange * (double)horizontal_offset / 200.0;
            }
            double yrange = this.ymax - this.ymin;
            this.ymax += yrange * (double)vertical_offset / 200.0;
            this.ymin -= yrange * (double)vertical_offset / 200.0;
            orizLabel = this.x_label == null ? this.waveform_signal.getXlabel() : this.x_label;
            vertLabel = this.y_label == null ? this.waveform_signal.getYlabel() : this.y_label;
            String string = sigTitle = this.title == null || this.title.length() == 0 ? this.waveform_signal.getTitlelabel() : this.title;
            if (this.waveform_signal.getType() == 1) {
                switch (this.waveform_signal.getMode2D()) {
                    case 3: {
                        vertLabel = this.waveform_signal.getZlabel();
                        break;
                    }
                    case 1: {
                        orizLabel = vertLabel;
                        vertLabel = this.waveform_signal.getZlabel();
                        break;
                    }
                    case 0: {
                        vertLabel = this.waveform_signal.getZlabel();
                    }
                }
            }
        }
        if (this.resizing || this.grid == null || this.wm == null || this.change_limits) {
            this.change_limits = false;
            this.grid = new Grid(this.xmax, this.ymax, this.xmin, this.ymin, this.x_log, this.y_log, this.grid_mode, orizLabel, vertLabel, sigTitle, this.wave_error, this.grid_step_x, this.grid_step_y, this.int_xlabel, this.int_ylabel, this.reversed);
            this.curr_display_limits = new Rectangle();
            this.grid.GetLimits(g, this.curr_display_limits, this.y_log);
            this.wm = new WaveformMetrics(this.xmax, this.xmin, this.ymax, this.ymin, this.curr_display_limits, d, this.x_log, this.y_log, 0, 0);
        } else {
            this.grid.updateValues(orizLabel, vertLabel, sigTitle, this.wave_error, this.grid_step_x, this.grid_step_y, this.int_xlabel, this.int_ylabel, this.reversed);
            this.grid.setLabels(sigTitle, orizLabel, vertLabel);
        }
        if (this.waveform_signal != null) {
            this.grid.setXaxisHMS(this.waveform_signal.isLongX());
        }
        if (!this.copy_selected || print_mode != 0) {
            if (this.reversed && print_mode == 0) {
                g.setColor(Color.black);
            } else {
                g.setColor(Color.white);
            }
        } else {
            g.setColor(Color.lightGray);
        }
        g.fillRect(1, 1, d.width - 2, d.height - 2);
        if (this.waveform_signal != null) {
            this.wave_b_box = new Rectangle(this.wm.XPixel(this.MinXSignal(), d), this.wm.YPixel(this.MaxYSignal(), d), this.wm.XPixel(this.MaxXSignal(), d) - this.wm.XPixel(this.MinXSignal(), d) + 1, this.wm.YPixel(this.MinYSignal(), d) - this.wm.YPixel(this.MaxYSignal(), d) + 1);
            if (print_mode == 0) {
                g.clipRect(this.curr_display_limits.width, 0, d.width - this.curr_display_limits.width, d.height - this.curr_display_limits.height);
            }
            this.drawSignal(g, d, print_mode);
        }
        if (print_mode == 2 && this.mode == 2 && (p = this.FindPoint(curr_x = this.wm.XValue(this.end_x, d), curr_y = this.wm.YValue(this.end_y, d), d, true)) != null) {
            Color prev_color = g.getColor();
            if (this.crosshair_color != null) {
                g.setColor(this.crosshair_color);
            }
            g.drawLine(0, p.y, d.width, p.y);
            g.drawLine(p.x, 0, p.x, d.height);
            g.setColor(prev_color);
        }
        if (!this.is_min_size && this.grid != null) {
            this.grid.paint(g, d, this, this.wm);
        }
    }

    public void performZoom() {
        if (this.wm == null) {
            return;
        }
        Dimension d = this.getWaveSize();
        double start_xs = this.wm.XValue(this.start_x, d);
        double end_xs = this.wm.XValue(this.end_x, d);
        double start_ys = this.wm.YValue(this.start_y, d);
        double end_ys = this.wm.YValue(this.end_y, d);
        ZoomRegion r = new ZoomRegion(start_xs, end_xs, start_ys, end_ys);
        this.ReportLimits(r, true);
    }

    public void PlayFrame() {
        if (!this.is_playing) {
            this.is_playing = true;
            this.play_timer.start();
        }
    }

    public boolean Playing() {
        return this.is_playing;
    }

    public synchronized void removeWaveformListener(WaveformListener l) {
        if (l == null) {
            return;
        }
        this.waveform_listener.removeElement(l);
    }

    public void Repaint(boolean state) {
        this.not_drawn = state;
        this.repaint();
    }

    void ReportChanges() {
        this.wm = null;
        this.not_drawn = true;
        if (this.mode == 2 && this.is_image && this.frames != null) {
            Point p = this.frames.getFramePoint(this.getWaveSize());
            this.end_x = p.x;
            this.end_y = p.y;
        }
        this.repaint();
        if (this.mode == 2) {
            this.sendUpdateEvent();
            if (this.is_image && this.send_profile) {
                this.sendProfileEvent();
            }
        }
        if (this.waveform_signal != null) {
            this.NotifyZoom(this.waveform_signal.getXmin(), this.waveform_signal.getXmax(), this.waveform_signal.getYmin(), this.waveform_signal.getYmax(), this.update_timestamp);
        }
    }

    protected void ReportLimits(ZoomRegion r, boolean add_undo) {
        if (add_undo) {
            ZoomRegion r_prev = new ZoomRegion(this.waveform_signal.getXmin(), this.waveform_signal.getXmax(), this.waveform_signal.getYmax(), this.waveform_signal.getYmin());
            this.undo_zoom.addElement(r_prev);
        } else {
            this.undo_zoom.removeElement(r);
            if (this.undo_zoom.size() == 0) {
                this.unfreeze();
            }
        }
        this.setXlimits(r.start_xs, r.end_xs);
        this.waveform_signal.setXLimits(r.start_xs, r.end_xs, 0);
        this.waveform_signal.setYmin(r.end_ys, 0);
        this.waveform_signal.setYmax(r.start_ys, 0);
        this.change_limits = true;
        if (add_undo) {
            this.freeze();
        }
    }

    protected void resetMode() {
        this.SetMode(this.mode);
    }

    public void ResetScales() {
        if (this.waveform_signal == null) {
            return;
        }
        this.waveform_signal.ResetScales();
        this.undo_zoom.clear();
        this.unfreeze();
        this.ReportChanges();
    }

    protected void Resize(int x, int y, boolean enlarge) {
        double new_ymin;
        double new_ymax;
        double new_xmin;
        double new_xmax;
        Dimension d = this.getWaveSize();
        double curr_x = this.wm.XValue(x, d);
        double curr_y = this.wm.YValue(y, d);
        double prev_xmax = this.wm.XMax();
        double prev_xmin = this.wm.XMin();
        double prev_ymax = this.wm.YMax();
        double prev_ymin = this.wm.YMin();
        if (enlarge) {
            new_xmax = curr_x + (prev_xmax - curr_x) / 2.0;
            new_xmin = curr_x - (curr_x - prev_xmin) / 2.0;
            new_ymax = curr_y + (prev_ymax - curr_y) / 2.0;
            new_ymin = curr_y - (curr_y - prev_ymin) / 2.0;
        } else {
            new_xmax = curr_x + (prev_xmax - curr_x) * 2.0;
            new_xmin = curr_x - (curr_x - prev_xmin) * 2.0;
            new_ymax = curr_y + (prev_ymax - curr_y) * 2.0;
            new_ymin = curr_y - (curr_y - prev_ymin) * 2.0;
        }
        ZoomRegion r = new ZoomRegion(new_xmin, new_xmax, new_ymax, new_ymin);
        this.ReportLimits(r, true);
        this.not_drawn = true;
    }

    public void SelectWave() {
        if (!this.is_select) {
            this.is_select = true;
            this.border_changed = true;
            this.unselect_border = this.getBorder();
            if (!this.unselect_border.getBorderInsets(this).equals(this.select_border.getBorderInsets(this))) {
                this.not_drawn = true;
            }
            this.setBorder(this.select_border);
        }
    }

    public void sendCutEvent() {
        WaveformEvent we = new WaveformEvent((Object)this, 2005);
        this.dispatchWaveformEvent(we);
    }

    public void sendPasteEvent() {
        WaveformEvent we = new WaveformEvent((Object)this, 2004);
        this.dispatchWaveformEvent(we);
    }

    public void sendProfileEvent() {
        if (this.frames != null && this.frames.getNumFrame() != 0) {
            WaveformEvent we;
            Dimension d = this.getWaveSize();
            Point p = this.frames.getFramePoint(new Point(this.end_x, this.end_y), d);
            int frame_type = this.frames.getFrameType();
            if (frame_type == 5 || frame_type == 6 || frame_type == 3 || frame_type == 3 || frame_type == 7) {
                we = new WaveformEvent((Object)this, p.x, p.y, (float)((double)Math.round(this.frames.GetFrameTime() * 10000.0f) / 10000.0), this.frames.getName(), this.frames.getValuesX(p.y), this.frames.getStartPixelX(), this.frames.getValuesY(p.x), this.frames.getStartPixelY());
                if (this.show_measure) {
                    Point p_pos = new Point((int)mark_point_x, (int)mark_point_y);
                    Point mp = this.frames.getFramePoint(p_pos, d);
                    we.setValuesLine(this.frames.getValuesLine(mp.x, mp.y, p.x, p.y));
                }
                we.setFrameType(frame_type);
            } else {
                we = new WaveformEvent((Object)this, p.x, p.y, (float)((double)Math.round(this.frames.GetFrameTime() * 10000.0f) / 10000.0), this.frames.getName(), this.frames.getPixelsX(p.y), this.frames.getStartPixelX(), this.frames.getPixelsY(p.x), this.frames.getStartPixelY());
                if (this.show_measure) {
                    Point p_pos = new Point((int)mark_point_x, (int)mark_point_y);
                    Point mp = this.frames.getFramePoint(p_pos, d);
                    we.setPixelsLine(this.frames.getPixelsLine(mp.x, mp.y, p.x, p.y));
                }
                we.setFrameType(frame_type);
            }
            this.dispatchWaveformEvent(we);
        }
    }

    public void sendUpdateEvent() {
        Dimension d = this.getWaveSize();
        if (this.is_image) {
            if (this.frames != null && this.frames.getNumFrame() != 0) {
                Point p = this.frames.getFramePoint(new Point(this.end_x, this.end_y), d);
                int frame_type = this.frames.getFrameType();
                WaveformEvent we = new WaveformEvent(this, 2000, p.x, p.y, this.frames.GetFrameTime(), 0.0, this.frames.getPixel(this.frames.GetFrameIdx(), p.x, p.y), 0);
                if (frame_type == 5 || frame_type == 3 || frame_type == 6 || frame_type == 4 || frame_type == 1 || frame_type == 2 || frame_type == 7) {
                    we.setPointValue(this.frames.getPointValue(this.frames.GetFrameIdx(), p.x, p.y));
                }
                we.setFrameType(frame_type);
                this.dispatchWaveformEvent(we);
            }
        } else if (this.waveform_signal != null && this.wm != null) {
            double curr_x = this.wm.XValue(this.end_x, d);
            double curr_y = this.wm.YValue(this.end_y, d);
            this.FindPoint(curr_x, curr_y, this.first_set_point);
            this.first_set_point = false;
            curr_x = this.curr_point = this.wave_point_x;
            curr_y = this.curr_point_y = this.wave_point_y;
            double dx = 0.0;
            double dy = 0.0;
            dx = curr_x - mark_point_x;
            dy = curr_y - mark_point_y;
            int event_id = this.show_measure ? 2001 : 2000;
            WaveformEvent we = new WaveformEvent(this, event_id, curr_x, curr_y, dx, dy, 0, this.GetSelectedSignal());
            Signal s = this.GetSignal();
            we.setTimeValue(s.getXinYZplot());
            we.setXValue(s.getYinXZplot());
            we.setDataValue(s.getZValue());
            we.setIsMB2(this.is_mb2);
            if (s.isLongXForLabel()) {
                we.setDateValue(0L);
            }
            this.dispatchWaveformEvent(we);
        }
    }

    public void SetColorIdx(int idx) {
        idx %= colors.length;
        if (this.waveform_signal != null) {
            this.waveform_signal.setColorIdx(idx);
        } else if (this.frames != null) {
            idx = idx == 0 ? 1 : idx;
            this.frames.SetColorIdx(idx);
            this.SetCrosshairColor(idx);
        }
        this.SetCrosshairColor(idx);
    }

    public void setColorMap(ColorMap cm) {
        this.colorMap = cm;
        if (this.frames != null) {
            this.frames.setColorMap(cm);
        }
        this.not_drawn = true;
        this.repaint();
    }

    public void SetCopySelected(boolean selec) {
        this.copy_selected = selec;
        this.not_drawn = true;
        this.repaint();
    }

    public void SetCrosshairColor(Color crosshair_color) {
        this.crosshair_color = crosshair_color;
    }

    public void SetCrosshairColor(int idx) {
        this.crosshair_color = colors[idx % colors.length];
    }

    public void SetDefaultColors() {
        if (colors != null && colors_name != null && (colors != COLOR_SET || colors_name != COLOR_NAME)) {
            return;
        }
        colors = COLOR_SET;
        colors_name = COLOR_NAME;
    }

    public void SetEnabledDispatchEvents(boolean event_enabled) {
        this.event_enabled = event_enabled;
    }

    public void SetEnabledPan(boolean pan_enabled) {
        this.pan_enabled = pan_enabled;
    }

    public void setFixedLimits() {
        try {
            this.waveform_signal.setXLimits(this.lx_min, this.lx_max, 0);
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
        this.setYlimits(this.ly_min, this.ly_max);
        this.change_limits = true;
    }

    public void setFixedLimits(float xmin, float xmax, float ymin, float ymax) {
        this.lx_max = xmax;
        this.lx_min = xmin;
        this.ly_max = ymax;
        this.ly_min = ymin;
        this.setFixedLimits();
    }

    public void setFont(Graphics g) {
        Font f = g.getFont();
        if (font == null || !font.equals(f)) {
            if (font == null) {
                font = g.getFont();
                font = new Font(font.getName(), font.getStyle(), 10);
                g.setFont(font);
            } else {
                g.setFont(font);
            }
        }
    }

    public void setFrameBitShift(int bitShift, boolean bitClip) {
        if (this.frames != null) {
            this.frames.shiftImagePixel(bitShift, bitClip);
            this.not_drawn = true;
            this.repaint();
        }
    }

    public void setFrameMinMax(float min, float max) {
        if (this.frames != null) {
            this.frames.setMinMax(min, max);
            this.not_drawn = true;
            this.repaint();
        }
    }

    public void SetFrames(Frames frames) {
        this.frames = frames;
    }

    public void SetGridMode(int grid_mode, boolean int_xlabel, boolean int_ylabel) {
        this.grid_mode = grid_mode;
        this.int_xlabel = int_xlabel;
        this.int_ylabel = int_ylabel;
        this.wm = null;
        this.grid = null;
        this.not_drawn = true;
    }

    public void SetGridSteps(int _grid_step_x, int _grid_step_y) {
        this.grid_step_x = _grid_step_x;
        if (this.grid_step_x <= 1) {
            this.grid_step_x = 2;
        }
        this.grid_step_y = _grid_step_y;
        if (this.grid_step_y <= 1) {
            this.grid_step_y = 2;
        }
        this.wm = null;
        this.grid = null;
        this.not_drawn = true;
    }

    public void SetInterpolate(boolean interpolate) {
        if (this.waveform_signal != null) {
            this.waveform_signal.setInterpolate(interpolate);
        }
    }

    protected void setKeys() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Signal s;
                if (e.getKeyCode() == 34) {
                    if (Waveform.this.is_image) {
                        if (Waveform.this.frames != null && Waveform.this.frames.GetFrameIdx() > 0) {
                            Waveform.this.frame = Waveform.this.frames.getLastFrameIdx();
                            Waveform.this.not_drawn = false;
                        }
                    } else {
                        s = Waveform.this.GetSignal();
                        if (s.getType() == 1) {
                            s.decShow();
                            Waveform.this.not_drawn = true;
                        }
                    }
                }
                if (e.getKeyCode() == 33) {
                    if (Waveform.this.is_image) {
                        if (Waveform.this.frames != null) {
                            Waveform.this.frame = Waveform.this.frames.getNextFrameIdx();
                            Waveform.this.not_drawn = false;
                        }
                    } else {
                        s = Waveform.this.GetSignal();
                        if (s.getType() == 1) {
                            s.incShow();
                            Waveform.this.not_drawn = true;
                        }
                    }
                }
                Waveform.this.repaint();
                Waveform.this.sendUpdateEvent();
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    public void SetMarker(int marker) {
        if (this.waveform_signal != null) {
            this.waveform_signal.setMarker(marker);
        }
    }

    public void SetMarkerStep(int step) {
        if (this.waveform_signal != null) {
            if (step == 0 || step < 0) {
                step = 1;
            }
            this.waveform_signal.setMarkerStep(step);
        }
    }

    public void SetMarkerWidth(int marker_width) {
        this.marker_width = marker_width;
    }

    public void SetMode(int mode) {
        if (this.def_cursor == null) {
            this.def_cursor = this.getCursor();
        }
        switch (mode) {
            case 3: {
                if (!this.pan_enabled) break;
                this.setCursor(new Cursor(13));
                this.mode = mode;
                break;
            }
            case 4: {
                this.setCursor(new Cursor(12));
                this.mode = mode;
                break;
            }
            case 5: {
                this.setCursor(new Cursor(3));
                this.mode = mode;
                break;
            }
            case 1: {
                this.setCursor(new Cursor(0));
                this.mode = mode;
                break;
            }
            default: {
                this.setCursor(this.def_cursor);
                this.mode = mode;
            }
        }
        if (this.waveform_signal != null || this.is_image) {
            if (mode == 2 && this.is_image && this.frames != null) {
                Point p = this.frames.getFramePoint(this.getWaveSize());
                this.end_x = p.x;
                this.end_y = p.y;
            }
            this.repaint();
            if (mode == 2 && this.is_image && this.send_profile) {
                this.sendProfileEvent();
            }
        }
    }

    protected void setMouse() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Signal s;
                if (Waveform.this.getCursor().getType() == 3) {
                    return;
                }
                Insets i = Waveform.this.getInsets();
                Waveform.this.just_deselected = false;
                Waveform.this.requestFocus();
                Waveform.this.is_mb3 = false;
                Waveform.this.is_mb2 = false;
                if ((e.getModifiersEx() & 0x800) != 0) {
                    Waveform.this.is_mb2 = true;
                } else if ((e.getModifiersEx() & 0x1000) != 0) {
                    Waveform.this.is_mb3 = true;
                }
                if (Waveform.this.mode == 4 && !Waveform.this.is_mb3) {
                    if (Waveform.this.is_mb2) {
                        if (!Waveform.this.IsCopySelected()) {
                            Waveform.this.sendPasteEvent();
                        }
                    } else {
                        Waveform.this.sendCutEvent();
                    }
                    return;
                }
                if (Waveform.this.is_mb3) {
                    Waveform.this.getParent().dispatchEvent(e);
                    return;
                }
                int x = e.getX() - i.right;
                int y = e.getY() - i.top;
                if (Waveform.this.mode != 2) {
                    ++Waveform.this.update_timestamp;
                }
                Waveform.this.prev_point_x = Waveform.this.orig_x = x;
                Waveform.this.end_x = Waveform.this.orig_x;
                Waveform.this.start_x = Waveform.this.orig_x;
                Waveform.this.prev_point_y = Waveform.this.orig_y = y;
                Waveform.this.end_y = Waveform.this.orig_y;
                Waveform.this.start_y = Waveform.this.orig_y;
                Waveform.this.dragging = true;
                Waveform.this.first_set_point = true;
                Waveform.this.setMousePoint();
                if (Waveform.this.mode == 3 && Waveform.this.waveform_signal != null) {
                    Waveform.this.waveform_signal.StartTraslate();
                }
                if (Waveform.this.mode == 2 && Waveform.this.waveform_signal != null) {
                    Waveform.this.repaint();
                }
                if ((e.getModifiersEx() & 0x80) != 0) {
                    if (Waveform.this.is_image) {
                        if (Waveform.this.frames != null && Waveform.this.frames.GetFrameIdx() > 0) {
                            Waveform.this.frame = Waveform.this.frames.getLastFrameIdx();
                        }
                    } else {
                        s = Waveform.this.GetSignal();
                        if (s.getType() == 1) {
                            s.decShow();
                            Waveform.this.not_drawn = true;
                            Waveform.this.repaint();
                        }
                    }
                }
                if ((e.getModifiersEx() & 0x40) != 0) {
                    if (Waveform.this.is_image) {
                        if (Waveform.this.frames != null) {
                            Waveform.this.frame = Waveform.this.frames.getNextFrameIdx();
                        }
                    } else {
                        s = Waveform.this.GetSignal();
                        if (s.getType() == 1) {
                            s.incShow();
                            Waveform.this.not_drawn = true;
                            Waveform.this.repaint();
                        }
                    }
                }
                if (Waveform.this.mode == 2) {
                    if (Waveform.this.is_image && Waveform.this.frames != null) {
                        Waveform.this.not_drawn = false;
                        Waveform.this.repaint();
                    } else {
                        s = Waveform.this.GetSignal();
                        if (Waveform.this.is_mb2 && s.getType() == 1 && s.getMode2D() == 2) {
                            s.addContourLevel(s.getZValue());
                            Waveform.this.not_drawn = true;
                            Waveform.this.repaint();
                        }
                    }
                    Waveform.this.sendUpdateEvent();
                } else {
                    Waveform.this.end_y = 0;
                    Waveform.this.end_x = 0;
                    Waveform.this.show_measure = false;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (Waveform.this.getCursor().getType() == 3) {
                    return;
                }
                Insets i = Waveform.this.getInsets();
                Dimension d = Waveform.this.getWaveSize();
                Waveform.this.dragging = false;
                int x = e.getX() - i.right;
                int y = e.getY() - i.top;
                if (Waveform.this.mode == 2 && Waveform.this.is_image && Waveform.this.frames != null) {
                    Waveform.this.frames.setFramePoint(new Point(Waveform.this.end_x, Waveform.this.end_y), d);
                }
                if (Waveform.this.is_mb3) {
                    return;
                }
                if (Waveform.this.waveform_signal == null && !Waveform.this.is_image || Waveform.this.frames == null && Waveform.this.is_image) {
                    return;
                }
                if (Waveform.this.mode == 1 && x != Waveform.this.orig_x && y != Waveform.this.orig_y) {
                    if (!Waveform.this.is_image) {
                        Waveform.this.performZoom();
                    }
                    Waveform.this.not_drawn = true;
                }
                if (Waveform.this.mode == 1 && zoom_on_mb1 && x == Waveform.this.orig_x && y == Waveform.this.orig_y && !Waveform.this.is_image) {
                    if ((e.getModifiersEx() & 0x800) != 0) {
                        Waveform.this.Resize(x, y, false);
                    } else {
                        Waveform.this.Resize(x, y, true);
                    }
                }
                if (Waveform.this.mode == 3 && !Waveform.this.is_image) {
                    Waveform.this.NotifyZoom(Waveform.this.MinXSignal(), Waveform.this.MaxXSignal(), Waveform.this.MinYSignal(), Waveform.this.MaxYSignal(), Waveform.this.update_timestamp);
                    Waveform.this.grid = null;
                    Waveform.this.not_drawn = true;
                    try {
                        Waveform.this.waveform_signal.setXLimits(Waveform.this.MinXSignal(), Waveform.this.MaxXSignal(), 0);
                        Waveform.this.setXlimits(Waveform.this.MinXSignal(), Waveform.this.MaxXSignal());
                    }
                    catch (Exception exc) {
                        System.out.println(exc);
                    }
                }
                Waveform.this.prev_point_y = -1;
                Waveform.this.prev_point_x = -1;
                if (!Waveform.this.is_image) {
                    Waveform.this.curr_rect = null;
                }
                Waveform.this.dragging = false;
                Waveform.this.repaint();
                if (Waveform.this.is_image && Waveform.this.restart_play) {
                    Waveform.this.play_timer.start();
                    Waveform.this.restart_play = false;
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (Waveform.this.getCursor().getType() == 3) {
                    return;
                }
                if (Waveform.this.waveform_signal == null && !Waveform.this.is_image || Waveform.this.is_mb2) {
                    return;
                }
                Insets i = Waveform.this.getInsets();
                Dimension d = Waveform.this.getWaveSize();
                int x = e.getX() - i.right;
                int y = e.getY() - i.top;
                if ((e.getModifiersEx() & 0x1000) != 0 || Waveform.this.is_mb3 || e.isPopupTrigger()) {
                    return;
                }
                if (Waveform.this.mode == 1 && x < Waveform.this.orig_x) {
                    Waveform.this.start_x = x;
                    Waveform.this.end_x = Waveform.this.orig_x;
                } else {
                    Waveform.this.end_x = x;
                    Waveform.this.start_x = Waveform.this.orig_x;
                }
                if (Waveform.this.mode == 1 && y < Waveform.this.orig_y) {
                    Waveform.this.end_y = Waveform.this.orig_y;
                    Waveform.this.start_y = y;
                } else {
                    Waveform.this.end_y = y;
                    Waveform.this.start_y = Waveform.this.orig_y;
                }
                if (Waveform.this.is_image && Waveform.this.frames != null) {
                    if (Waveform.this.mode == 1 && !Waveform.this.frames.contain(new Point(Waveform.this.start_x, Waveform.this.start_y), d)) {
                        return;
                    }
                    Waveform.this.setMousePoint();
                }
                if (Waveform.this.mode == 1) {
                    if (Waveform.this.is_image && Waveform.this.is_playing) {
                        Waveform.this.restart_play = true;
                        Waveform.this.play_timer.stop();
                    }
                    if (Waveform.this.curr_rect == null) {
                        Waveform.this.curr_rect = new Rectangle(Waveform.this.start_x, Waveform.this.start_y, Waveform.this.end_x - Waveform.this.start_x, Waveform.this.end_y - Waveform.this.start_y);
                    } else {
                        Waveform.this.curr_rect.setBounds(Waveform.this.start_x, Waveform.this.start_y, Waveform.this.end_x - Waveform.this.start_x, Waveform.this.end_y - Waveform.this.start_y);
                    }
                    Waveform.this.not_drawn = false;
                    Waveform.this.repaint();
                } else {
                    Waveform.this.curr_rect = null;
                }
                if (Waveform.this.mode == 2) {
                    Waveform.this.not_drawn = false;
                    Waveform.this.sendUpdateEvent();
                    Waveform.this.paintImmediately(0, 0, d.width, d.height);
                    if (Waveform.this.is_image && Waveform.this.send_profile) {
                        Waveform.this.sendProfileEvent();
                    }
                }
                if (Waveform.this.mode == 3 && !Waveform.this.is_image) {
                    Waveform.this.pan_delta_x = Waveform.this.wm.x_log ? Waveform.this.wm.XValue(Waveform.this.start_x, d) / Waveform.this.wm.XValue(Waveform.this.end_x, d) : Waveform.this.wm.XValue(Waveform.this.start_x, d) - Waveform.this.wm.XValue(Waveform.this.end_x, d);
                    Waveform.this.pan_delta_y = Waveform.this.wm.y_log ? Waveform.this.wm.YValue(Waveform.this.start_y, d) / Waveform.this.wm.YValue(Waveform.this.end_y, d) : Waveform.this.wm.YValue(Waveform.this.start_y, d) - Waveform.this.wm.YValue(Waveform.this.end_y, d);
                    Waveform.this.not_drawn = false;
                    Waveform.this.repaint();
                }
            }
        });
    }

    private void setMousePoint() {
        if (this.is_image && this.frames != null) {
            Dimension d = this.getWaveSize();
            Point p_pos = new Point(this.end_x, this.end_y);
            this.frames.getFramePoint(p_pos, d);
            this.end_x = p_pos.x;
            this.end_y = p_pos.y;
        }
    }

    public void SetPointMeasure() {
        Dimension d = this.getWaveSize();
        if (this.is_image) {
            mark_point_x = this.end_x;
            mark_point_y = this.end_y;
            this.frames.setMeasurePoint(this.end_x, this.end_y, d);
        } else {
            double curr_x = this.wm.XValue(this.end_x, d);
            double curr_y = this.wm.YValue(this.end_y, d);
            this.FindPoint(curr_x, curr_y, true);
            mark_point_x = curr_x = this.wave_point_x;
            mark_point_y = curr_y = this.wave_point_y;
        }
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public void SetReversed(boolean reversed) {
        if (this.is_image && !reversed) {
            return;
        }
        if (this.reversed != reversed) {
            this.reversed = reversed;
            if (this.grid != null) {
                this.grid.SetReversed(reversed);
            }
        }
    }

    public void SetScale(Waveform w) {
        if (this.waveform_signal == null) {
            return;
        }
        this.waveform_signal.setXLimits(w.waveform_signal.getXmin(), w.waveform_signal.getXmax(), 0);
        this.waveform_signal.setYmin(w.waveform_signal.getYmin(), 0);
        this.waveform_signal.setYmax(w.waveform_signal.getYmax(), 0);
        this.ReportChanges();
    }

    public void setSelectBorder(Border border) {
        this.select_border = border;
    }

    public void setSendProfile(boolean state) {
        this.send_profile = state;
    }

    public void SetShowMeasure(boolean state) {
        this.show_measure = state;
    }

    public void setShowSigImage(boolean show_sig_image) {
        this.show_sig_image = show_sig_image;
    }

    public void setSignalMode1D(int mode) {
        if (this.waveform_signal != null) {
            this.waveform_signal.setMode1D(mode);
            this.not_drawn = true;
            this.repaint();
        }
    }

    public void setSignalMode2D(int mode) {
        if (this.waveform_signal != null) {
            this.waveform_signal.setMode2D(mode);
            if (this.waveform_signal.getType() == 1) {
                this.Autoscale();
                this.sendUpdateEvent();
            }
            this.not_drawn = true;
            this.repaint();
        }
    }

    public void SetSignalState(boolean state) {
        if (this.waveform_signal != null) {
            this.waveform_signal.setInterpolate(state);
            this.waveform_signal.setMarker(0);
        }
    }

    public void SetTitle(String title) {
        this.title = title;
    }

    public void SetXLabel(String x_label) {
        this.x_label = x_label;
    }

    public void setXlimits(double xmin, double xmax) {
        if (this.waveform_signal == null) {
            return;
        }
        try {
            this.waveform_signal.setXLimits(xmin, xmax, 0);
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
    }

    public void SetXLog(boolean x_log) {
        this.x_log = x_log;
    }

    public void SetXScale(Waveform w) {
        if (this.waveform_signal == null) {
            return;
        }
        this.waveform_signal.setXLimits(w.waveform_signal.getXmin(), w.waveform_signal.getXmax(), 0);
        this.ReportChanges();
    }

    public void SetXScaleAutoY(Waveform w) {
        if (this.waveform_signal == null) {
            return;
        }
        this.waveform_signal.setXLimits(w.waveform_signal.getXmin(), w.waveform_signal.getXmax(), 0);
        this.waveform_signal.AutoscaleY();
        this.ReportChanges();
    }

    public void SetYLabel(String y_label) {
        this.y_label = y_label;
    }

    public void setYlimits(float ymin, float ymax) {
        if (this.waveform_signal == null) {
            return;
        }
        this.waveform_signal.setYlimits(ymin, ymax);
    }

    public void SetYLog(boolean y_log) {
        this.y_log = y_log;
    }

    public void SetYScale(Waveform w) {
        if (this.waveform_signal == null) {
            return;
        }
        this.waveform_signal.setYmin(w.waveform_signal.getYmin(), 0);
        this.waveform_signal.setYmax(w.waveform_signal.getYmax(), 0);
        this.ReportChanges();
    }

    public boolean ShowMeasure() {
        return this.show_measure;
    }

    private void SignalActions(Graphics g, Dimension d) {
        if (this.waveform_signal != null && this.mode == 2 && !this.not_drawn && !this.is_min_size && this.wm != null) {
            double curr_x = this.curr_point;
            double curr_y = this.wm.YValue(this.end_y, d);
            Point p = this.FindPoint(curr_x, curr_y, this.first_set_point);
            this.first_set_point = false;
            if (p != null) {
                if (!Double.isNaN(this.curr_point_y)) {
                    p.y = this.wm.YPixel(this.curr_point_y, d);
                }
                curr_x = this.wave_point_x;
                curr_y = this.wave_point_y;
                Color prev_color = g.getColor();
                if (this.crosshair_color != null) {
                    g.setColor(this.crosshair_color);
                }
                g.drawLine(0, p.y, d.width, p.y);
                g.drawLine(p.x, 0, p.x, d.height);
                g.setColor(prev_color);
                this.prev_point_x = p.x;
                this.prev_point_y = p.y;
            }
        }
        if (this.mode == 3 && this.dragging && this.waveform_signal != null) {
            this.waveform_signal.Traslate(this.pan_delta_x, this.pan_delta_y, this.wm.x_log, this.wm.y_log);
            this.wm = new WaveformMetrics(this.MaxXSignal(), this.MinXSignal(), this.MaxYSignal(), this.MinYSignal(), this.curr_display_limits, d, this.wm.x_log, this.wm.y_log, 0, 0);
            if (this.reversed) {
                g.setColor(Color.black);
            } else {
                g.setColor(Color.white);
            }
            g.fillRect(1, 1, d.width - 2, d.height - 2);
            g.setColor(Color.black);
            g.clipRect(this.wave_b_box.x, this.wave_b_box.y, this.wave_b_box.width, this.wave_b_box.height);
            this.drawSignal(g);
        }
    }

    @Override
    public void signalUpdated(boolean changeLimits) {
        this.change_limits = changeLimits;
        this.not_drawn = true;
        this.repaint();
    }

    public synchronized void StopFrame() {
        if (this.is_image && this.is_playing) {
            this.is_playing = false;
            this.play_timer.stop();
        }
    }

    public void undoZoom() {
        if (this.undo_zoom.size() == 0) {
            return;
        }
        ZoomRegion r = this.undo_zoom.lastElement();
        this.ReportLimits(r, false);
        this.not_drawn = true;
        this.repaint();
    }

    public boolean undoZoomPendig() {
        return this.undo_zoom.size() > 0;
    }

    void unfreeze() {
        this.waveform_signal.unfreeze();
    }

    public void Update() {
        this.wm = null;
        this.curr_rect = null;
        this.prev_point_y = -1;
        this.prev_point_x = -1;
        this.not_drawn = true;
        this.repaint();
    }

    public void Update(float[] x, float[] y) {
        this.wave_error = null;
        if (x.length <= 1 || y.length <= 1) {
            this.wave_error = " Less than two points";
            this.waveform_signal = null;
            this.Update();
            return;
        }
        this.Update(new Signal(x, y));
        this.repaint();
    }

    public synchronized void Update(Signal s) {
        ++this.update_timestamp;
        this.waveform_signal = s;
        this.waveform_signal.registerSignalListener(this);
        this.wm = null;
        this.curr_rect = null;
        this.prev_point_y = -1;
        this.prev_point_x = -1;
        this.not_drawn = true;
        this.repaint();
    }

    public void UpdateImage(Frames frames) {
        this.SetFrames(frames);
        if (frames == null || frames.getNumFrame() > 0) {
            // empty if block
        }
        this.is_image = true;
        this.curr_rect = null;
        this.prev_point_y = -1;
        this.prev_point_x = -1;
        this.not_drawn = true;
        this.repaint();
    }

    public void UpdatePoint(double curr_x) {
        this.UpdatePoint(curr_x, Double.NaN);
    }

    public synchronized void UpdatePoint(double curr_x, double curr_y) {
        Dimension d = this.getWaveSize();
        if (curr_x == this.curr_point && !this.dragging) {
            return;
        }
        this.curr_point = curr_x;
        this.curr_point_y = curr_y;
        if (!this.is_image) {
            if (this.mode != 2 || this.waveform_signal == null) {
                return;
            }
            if (this.waveform_signal.getType() == 1 && this.waveform_signal.getMode2D() == 1) {
                this.waveform_signal.showYZ((float)curr_x);
                this.not_drawn = true;
            }
            if (this.waveform_signal.getType() == 1 && this.waveform_signal.getMode2D() == 0) {
                this.waveform_signal.showXZ(curr_y);
                this.not_drawn = false;
            }
            this.paintImmediately(0, 0, d.width, d.height);
        } else if (this.frames != null && !this.is_playing) {
            this.frame = this.frames.GetFrameIdxAtTime((float)curr_x);
            this.not_drawn = true;
            this.repaint();
            if (this.send_profile) {
                this.sendProfileEvent();
            }
        }
    }

    public void UpdateSignal(Signal s) {
        this.waveform_signal = s;
        this.waveform_signal.registerSignalListener(this);
        this.curr_rect = null;
        this.prev_point_y = -1;
        this.prev_point_x = -1;
        this.not_drawn = true;
        this.repaint();
    }

    void Waveform_ComponentAdded(ContainerEvent event) {
    }

    static {
        colors_changed = true;
        font = null;
        bug_image = true;
        horizontal_offset = 0;
        vertical_offset = 0;
    }

    class ZoomRegion {
        double start_xs;
        double end_xs;
        double start_ys;
        double end_ys;

        ZoomRegion(double start_xs, double end_xs, double start_ys, double end_ys) {
            this.start_xs = start_xs;
            this.end_xs = end_xs;
            this.start_ys = start_ys;
            this.end_ys = end_ys;
        }
    }

    class SymContainer
    extends ContainerAdapter {
        SymContainer() {
        }

        @Override
        public void componentAdded(ContainerEvent event) {
            Object object = event.getSource();
            if (object == Waveform.this) {
                Waveform.this.Waveform_ComponentAdded(event);
            }
        }
    }
}

