/*
 * Decompiled with CFR 0.152.
 */
package mds.wave;

public class XYData {
    public double resolution;
    boolean increasingX;
    public int nSamples;
    public double[] x = null;
    public long[] xLong = null;
    public float[] y;
    double xMin;
    double xMax;

    public XYData(double[] x, float[] y, double resolution) {
        this.resolution = resolution;
        this.x = x;
        this.y = y;
        this.increasingX = true;
        int n = this.nSamples = x.length < y.length ? x.length : y.length;
        if (this.nSamples > 0) {
            this.xMin = this.xMax = x[0];
            for (int i = 1; i < x.length; ++i) {
                if (x[i - 1] > x[i]) {
                    this.increasingX = false;
                }
                if (x[i] > this.xMax) {
                    this.xMax = x[i];
                }
                if (!(x[i] < this.xMin)) continue;
                this.xMin = x[i];
            }
        }
    }

    public XYData(double[] x, float[] y, double resolution, boolean increasingX) {
        this(x, y, resolution, increasingX, x[0], x[x.length - 1]);
    }

    public XYData(double[] x, float[] y, double resolution, boolean increasingX, double xMin, double xMax) {
        this.resolution = resolution;
        this.increasingX = increasingX;
        this.x = x;
        this.y = y;
        this.xMin = xMin;
        this.xMax = xMax;
        this.nSamples = x.length < y.length ? x.length : y.length;
    }

    public XYData(long[] x, float[] y, double resolution) {
        int i;
        this.resolution = resolution;
        this.xLong = x;
        this.y = y;
        this.x = new double[x.length];
        for (i = 0; i < x.length; ++i) {
            this.x[i] = x[i];
        }
        this.increasingX = true;
        int n = this.nSamples = x.length < y.length ? x.length : y.length;
        if (this.nSamples > 0) {
            this.xMin = this.xMax = (double)x[0];
            for (i = 1; i < x.length; ++i) {
                if (x[i - 1] > x[i]) {
                    this.increasingX = false;
                }
                if ((double)x[i] > this.xMax) {
                    this.xMax = x[i];
                }
                if (!((double)x[i] < this.xMin)) continue;
                this.xMin = x[i];
            }
        }
    }

    public XYData(long[] x, float[] y, double resolution, boolean increasingX) {
        this.resolution = resolution;
        this.increasingX = increasingX;
        this.xLong = x;
        this.y = y;
        this.x = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            this.x[i] = x[i];
        }
        this.nSamples = x.length < y.length ? x.length : y.length;
    }
}

