/*
 * Decompiled with CFR 0.152.
 */
package mds.jscope;

import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mds.jscope.jScopeFacade;
import mds.wave.DataProvider;
import mds.wave.DataServerItem;

class ServerDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static JList<DataServerItem> server_list;
    private final JButton add_b;
    private final JButton remove_b;
    private final JButton exit_b;
    private final JButton connect_b;
    private final JButton modify_b;
    JCheckBox automatic;
    JComboBox<String> data_provider_list;
    private final Set<String> data_server_class = new HashSet<String>();
    jScopeFacade dw;
    private final DefaultListModel<DataServerItem> list_model = new DefaultListModel();
    JTextField server_l;
    JTextField server_a;
    JTextField server_u;
    JLabel server_label;
    JLabel user_label;
    JTextField tunnel_port;
    JCheckBox tunneling;

    ServerDialog(JFrame dw, String title) {
        super(dw, title, true);
        this.dw = (jScopeFacade)dw;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Insets insets = new Insets(4, 4, 4, 4);
        this.getContentPane().setLayout(gridbag);
        c.insets = insets;
        c.anchor = 17;
        c.gridwidth = 0;
        c.fill = 1;
        c.gridheight = 10;
        server_list = new JList<DataServerItem>(this.list_model);
        JScrollPane scrollServerList = new JScrollPane(server_list);
        server_list.setSelectionMode(0);
        server_list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DataServerItem dsi = (DataServerItem)server_list.getSelectedValue();
                if (dsi != null) {
                    ServerDialog.this.remove_b.setEnabled(true);
                    ServerDialog.this.modify_b.setEnabled(true);
                    ServerDialog.this.server_l.setText(dsi.getName());
                    ServerDialog.this.server_a.setText(dsi.getArgument());
                    ServerDialog.this.server_u.setText(dsi.getUser());
                    ServerDialog.this.data_provider_list.setSelectedItem(dsi.getClassName());
                    if (dsi.getTunnelPort() != null) {
                        ServerDialog.this.tunneling.setSelected(true);
                        ServerDialog.this.tunnel_port.setText(dsi.getTunnelPort());
                        ServerDialog.this.tunnel_port.setEditable(true);
                    } else {
                        ServerDialog.this.tunnel_port.setText("");
                        ServerDialog.this.tunneling.setSelected(false);
                        ServerDialog.this.tunnel_port.setEditable(false);
                    }
                } else {
                    ServerDialog.this.remove_b.setEnabled(false);
                    ServerDialog.this.modify_b.setEnabled(false);
                }
            }
        });
        gridbag.setConstraints(scrollServerList, c);
        this.getContentPane().add(scrollServerList);
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        this.server_label = new JLabel("Server label ");
        gridbag.setConstraints(this.server_label, c);
        this.getContentPane().add(this.server_label);
        c.gridwidth = 0;
        c.fill = 1;
        this.server_l = new JTextField(20);
        gridbag.setConstraints(this.server_l, c);
        this.getContentPane().add(this.server_l);
        c.gridwidth = 1;
        this.server_label = new JLabel("Server argument ");
        gridbag.setConstraints(this.server_label, c);
        this.getContentPane().add(this.server_label);
        c.gridwidth = 0;
        c.fill = 1;
        this.server_a = new JTextField(20);
        gridbag.setConstraints(this.server_a, c);
        this.getContentPane().add(this.server_a);
        c.gridwidth = 1;
        this.tunneling = new JCheckBox("Tunneling local Port:");
        this.tunneling.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ServerDialog.this.tunneling.isSelected()) {
                    ServerDialog.this.tunnel_port.setEditable(true);
                } else {
                    ServerDialog.this.tunnel_port.setEditable(false);
                }
            }
        });
        gridbag.setConstraints(this.tunneling, c);
        this.getContentPane().add(this.tunneling);
        c.gridwidth = 0;
        c.fill = 1;
        this.tunnel_port = new JTextField(6);
        this.tunnel_port.setEditable(false);
        gridbag.setConstraints(this.tunnel_port, c);
        this.getContentPane().add(this.tunnel_port);
        c.gridwidth = 0;
        c.fill = 1;
        this.automatic = new JCheckBox("Get user name from host");
        this.automatic.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ServerDialog.this.automatic.isSelected()) {
                    ServerDialog.this.server_u.setText(System.getProperty("user.name"));
                    ServerDialog.this.server_u.setEditable(false);
                } else {
                    ServerDialog.this.server_u.setText("");
                    ServerDialog.this.server_u.setEditable(true);
                }
            }
        });
        gridbag.setConstraints(this.automatic, c);
        this.getContentPane().add(this.automatic);
        c.gridwidth = 1;
        this.server_label = new JLabel("User name ");
        gridbag.setConstraints(this.server_label, c);
        this.getContentPane().add(this.server_label);
        c.gridwidth = 0;
        c.fill = 1;
        this.server_u = new JTextField(20);
        gridbag.setConstraints(this.server_u, c);
        this.getContentPane().add(this.server_u);
        c.anchor = 17;
        c.gridwidth = 1;
        JLabel lab = new JLabel("Server Class : ");
        gridbag.setConstraints(lab, c);
        this.getContentPane().add(lab);
        c.gridwidth = 0;
        c.fill = 1;
        this.data_provider_list = new JComboBox();
        gridbag.setConstraints(this.data_provider_list, c);
        this.getContentPane().add(this.data_provider_list);
        this.data_provider_list.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    String srv;
                    if (e.getStateChange() == 1 && (srv = (String)ServerDialog.this.data_provider_list.getSelectedItem()) != null) {
                        Class<?> cl = Class.forName("mds.provider." + srv);
                        DataProvider dp = (DataProvider)cl.newInstance();
                        boolean state = dp.supportsTunneling();
                        ServerDialog.this.tunneling.setEnabled(state);
                        ServerDialog.this.tunnel_port.setEnabled(state);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JPanel p = new JPanel(new FlowLayout(1));
        this.add_b = new JButton("Add");
        this.add_b.addActionListener(this);
        p.add(this.add_b);
        this.modify_b = new JButton("Modify");
        this.modify_b.addActionListener(this);
        this.modify_b.setEnabled(false);
        p.add(this.modify_b);
        this.remove_b = new JButton("Remove");
        this.remove_b.addActionListener(this);
        this.remove_b.setEnabled(false);
        p.add(this.remove_b);
        this.connect_b = new JButton("Connect");
        this.connect_b.addActionListener(this);
        p.add(this.connect_b);
        this.exit_b = new JButton("Close");
        this.exit_b.addActionListener(this);
        p.add(this.exit_b);
        c.gridwidth = 0;
        gridbag.setConstraints(p, c);
        this.getContentPane().add(p);
        ArrayList<String> names = new ArrayList<String>(DataServerItem.knownProviders.size());
        DataServerItem.knownProviders.forEach(e -> names.add(e.getSimpleName()));
        names.sort(Comparator.comparing(String::toString));
        names.forEach(this::addProviderName);
        if (jScopeFacade.server_ip_list == null) {
            this.GetPropertiesValue();
        } else {
            this.addServerIpList(jScopeFacade.server_ip_list);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String srv;
        int idx;
        String srv2;
        Object ob = event.getSource();
        if (ob == this.exit_b) {
            this.setVisible(false);
        }
        if (ob == this.add_b && (srv2 = this.server_l.getText().trim()) != null && srv2.length() != 0) {
            this.addServerIp(new DataServerItem(srv2, this.server_a.getText().trim(), this.server_u.getText().trim(), (String)this.data_provider_list.getSelectedItem(), null, null, this.tunnel_port.getText()));
        }
        if (ob == this.remove_b && (idx = server_list.getSelectedIndex()) >= 0) {
            this.list_model.removeElementAt(idx);
            this.dw.servers_m.remove(idx);
        }
        if (ob == this.connect_b && (idx = server_list.getSelectedIndex()) >= 0) {
            this.dw.SetDataServer(jScopeFacade.server_ip_list[idx]);
        }
        if (ob == this.modify_b && (idx = server_list.getSelectedIndex()) >= 0 && (srv = this.server_l.getText().trim()) != null && srv.length() != 0) {
            if (!jScopeFacade.server_ip_list[idx].getName().equals(srv)) {
                int itemsCount = this.dw.servers_m.getItemCount();
                for (int i = 0; i < itemsCount; ++i) {
                    JMenuItem mi = this.dw.servers_m.getItem(i);
                    if (!mi.getText().trim().equals(jScopeFacade.server_ip_list[idx].getName())) continue;
                    mi.setText(srv);
                    mi.setActionCommand("SET_SERVER " + srv);
                }
            }
            jScopeFacade.server_ip_list[idx].update(srv, this.server_a.getText(), this.server_u.getText(), (String)this.data_provider_list.getSelectedItem(), this.tunnel_port.getText());
            server_list.repaint();
        }
    }

    private final void addProviderName(String name) {
        if (name == null || this.data_server_class.contains(name)) {
            return;
        }
        this.data_server_class.add(name);
        this.data_provider_list.addItem(name);
    }

    public DataServerItem addServerIp(DataServerItem dsi) {
        DataServerItem found_dsi = null;
        found_dsi = this.findServer(dsi);
        if (found_dsi != null) {
            return found_dsi;
        }
        this.addProviderName(dsi.getClassName());
        if (dsi.getClassName() == null) {
            JOptionPane.showMessageDialog(null, "Undefined data server class for " + dsi.getName(), "alert addServerIp", 0);
        }
        this.list_model.addElement(dsi);
        JMenuItem new_ip = new JMenuItem(dsi.getName());
        this.dw.servers_m.add(new_ip);
        new_ip.setActionCommand("SET_SERVER " + dsi.getName());
        new_ip.addActionListener(this.dw);
        jScopeFacade.server_ip_list = this.getServerIpList();
        return dsi;
    }

    public void addServerIpList(DataServerItem[] dsi_list) {
        if (dsi_list == null) {
            return;
        }
        for (DataServerItem element : dsi_list) {
            this.addServerIp(element);
        }
    }

    private DataServerItem findServer(DataServerItem dsi) {
        DataServerItem found_dsi = null;
        Enumeration<DataServerItem> e = this.list_model.elements();
        while (e.hasMoreElements()) {
            found_dsi = e.nextElement();
            if (!found_dsi.equals(dsi)) continue;
            return found_dsi;
        }
        return null;
    }

    private void GetPropertiesValue() {
        String name;
        Properties js_prop = this.dw.js_prop;
        if (js_prop == null) {
            return;
        }
        int i = 1;
        while ((name = js_prop.getProperty("jScope.data_server_" + i + ".name")) != null) {
            String argument = js_prop.getProperty("jScope.data_server_" + i + ".argument");
            String user = js_prop.getProperty("jScope.data_server_" + i + ".user");
            String class_name = js_prop.getProperty("jScope.data_server_" + i + ".class");
            String browse_class = js_prop.getProperty("jScope.data_server_" + i + ".browse_class");
            String browse_url = js_prop.getProperty("jScope.data_server_" + i + ".browse_url");
            String tunnel_port = js_prop.getProperty("jScope.data_server_" + i + ".tunnel_port");
            DataServerItem dsi = new DataServerItem(name, argument, user, class_name, browse_class, browse_url, tunnel_port);
            this.addServerIp(dsi);
            ++i;
        }
    }

    public DataServerItem[] getServerIpList() {
        Enumeration<DataServerItem> e = this.list_model.elements();
        DataServerItem[] out = new DataServerItem[this.list_model.size()];
        int i = 0;
        while (e.hasMoreElements()) {
            out[i] = e.nextElement();
            ++i;
        }
        return out;
    }

    private void resetAll() {
        server_list.clearSelection();
        this.server_l.setText("");
        this.server_a.setText("");
        this.server_u.setText("");
        this.tunnel_port.setText("");
        this.data_provider_list.setSelectedIndex(this.data_provider_list.getItemCount() > 0 ? 0 : -1);
    }

    public void Show() {
        this.pack();
        this.resetAll();
        DataServerItem found_dsi = this.findServer(this.dw.wave_panel.GetServerItem());
        if (found_dsi != null) {
            server_list.setSelectedValue(found_dsi, true);
        }
        this.setLocationRelativeTo(this.dw);
        this.setVisible(true);
    }
}

